
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * These are the formats for Frequent Flyer (FF)

 - add
 frequent flyer number

 FF(carrier code)(number)-(name number)
 FFUS87658768-2.1

 - add frequent flyer number using a specific
 passenger
 name

 FF(carrier code)(number)-(name)
 FFBA12345678-BRIAND/FREDERIC

 - add frequent flyer number on LAN
 airlines for new
 customer numbers in Argentina, Ecuador and Peru

 FF(carrier code LP)(number) FFLP34593001

 - delete a frequent flyer
 number

 FF(frequent flyer line number)¤ FF1¤

 - delete all frequent
 flyer numbers

 FF¤ALL

 - delete range of frequent flyer numbers

 FF(first
 FF line #)-(last FF line #)¤ FF1-4¤

 - delete specific FF numbers

 FF(FF line #),(FF line #)¤ FF1,3¤

 - modify FF info

 FF(line #)¤(carrier
 code)(FF #) FF1¤4UA5522123

 To add name number: FF1¤4UA5522123-3.1
 TODO - what is relationship to FrequentFlyer.PNRB. If different, then why is comment the
 same?

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Loyalty.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="SupplierCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Number" minOccurs="0"/>
 *     &lt;xs:element type="xs:integer" name="TierLevelNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ShortText" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ReceivingCarrierCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="StatusCode" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="id"/>
 *   &lt;xs:attribute type="ns:OperationType.PNRB" name="op"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class LoyaltyPNRB implements Serializable
{
    private String supplierCode;
    private String number;
    private BigInteger tierLevelNumber;
    private String shortText;
    private String receivingCarrierCode;
    private String statusCode;
    private String id;
    private OperationTypePNRB op;

    /** 
     * Get the 'SupplierCode' element value.
     * 
     * @return value
     */
    public String getSupplierCode() {
        return supplierCode;
    }

    /** 
     * Set the 'SupplierCode' element value.
     * 
     * @param supplierCode
     */
    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }

    /** 
     * Get the 'Number' element value.
     * 
     * @return value
     */
    public String getNumber() {
        return number;
    }

    /** 
     * Set the 'Number' element value.
     * 
     * @param number
     */
    public void setNumber(String number) {
        this.number = number;
    }

    /** 
     * Get the 'TierLevelNumber' element value. Represents the level that pax reached within the loyalty program.
                      
     * 
     * @return value
     */
    public BigInteger getTierLevelNumber() {
        return tierLevelNumber;
    }

    /** 
     * Set the 'TierLevelNumber' element value. Represents the level that pax reached within the loyalty program.
                      
     * 
     * @param tierLevelNumber
     */
    public void setTierLevelNumber(BigInteger tierLevelNumber) {
        this.tierLevelNumber = tierLevelNumber;
    }

    /** 
     * Get the 'ShortText' element value. Miscellaneous remark regarding FF.
     * 
     * @return value
     */
    public String getShortText() {
        return shortText;
    }

    /** 
     * Set the 'ShortText' element value. Miscellaneous remark regarding FF.
     * 
     * @param shortText
     */
    public void setShortText(String shortText) {
        this.shortText = shortText;
    }

    /** 
     * Get the 'ReceivingCarrierCode' element value. Receiving carrier code for FF supplier.
     * 
     * @return value
     */
    public String getReceivingCarrierCode() {
        return receivingCarrierCode;
    }

    /** 
     * Set the 'ReceivingCarrierCode' element value. Receiving carrier code for FF supplier.
     * 
     * @param receivingCarrierCode
     */
    public void setReceivingCarrierCode(String receivingCarrierCode) {
        this.receivingCarrierCode = receivingCarrierCode;
    }

    /** 
     * Get the 'StatusCode' element value. Indication of the validity of the Frequent Flyer, loyalty program confirmation.
                      
     * 
     * @return value
     */
    public String getStatusCode() {
        return statusCode;
    }

    /** 
     * Set the 'StatusCode' element value. Indication of the validity of the Frequent Flyer, loyalty program confirmation.
                      
     * 
     * @param statusCode
     */
    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    /** 
     * Get the 'id' attribute value. unique identifier identifying a specific
                      FrequentFlyer instance
                  
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value. unique identifier identifying a specific
                      FrequentFlyer instance
                  
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @return value
     */
    public OperationTypePNRB getOp() {
        return op;
    }

    /** 
     * Set the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @param op
     */
    public void setOp(OperationTypePNRB op) {
        this.op = op;
    }
}
