
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Bid Price and Fare Reference data - Pnr footprint
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ODDataType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:int" name="OriginalFare" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="EffectiveBidPrice" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="AdjustedFare" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="AdjustedBidPrice" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FareClass" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="LowestAvailFareClass" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PointOfCommencement" minOccurs="0"/>
 *     &lt;xs:element type="xs:integer" name="CustomerScore" minOccurs="0"/>
 *     &lt;xs:element type="ns:ODFrequentFlyerType" name="FrequentFlyer" minOccurs="0"/>
 *     &lt;xs:element type="ns:ODMarketType" name="Market" minOccurs="0"/>
 *     &lt;xs:element type="ns:ODMarketType" name="TripMarket" minOccurs="0"/>
 *     &lt;xs:element type="ns:ODMarketType" name="RetrievedFareMarket" minOccurs="0"/>
 *     &lt;xs:element type="ns:ODFareTypeIndicatorsType" name="FareTypeIndicators" minOccurs="0"/>
 *     &lt;xs:element type="ns:ODEvaluationTypeIndicatorsType" name="EvaluationTypeIndicators" minOccurs="0"/>
 *     &lt;xs:element type="ns:ODExceptionTypeIndicatorsType" name="ExceptionTypeIndicators" minOccurs="0"/>
 *     &lt;xs:element type="xs:unsignedLong" name="AdditionalFlags" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="AdditionalData" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="uniqueId"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ODDataType implements Serializable
{
    private Integer originalFare;
    private Integer effectiveBidPrice;
    private Integer adjustedFare;
    private Integer adjustedBidPrice;
    private String fareClass;
    private String lowestAvailFareClass;
    private String pointOfCommencement;
    private BigInteger customerScore;
    private ODFrequentFlyerType frequentFlyer;
    private ODMarketType market;
    private ODMarketType tripMarket;
    private ODMarketType retrievedFareMarket;
    private ODFareTypeIndicatorsType fareTypeIndicators;
    private ODEvaluationTypeIndicatorsType evaluationTypeIndicators;
    private ODExceptionTypeIndicatorsType exceptionTypeIndicators;
    private String additionalFlags;
    private String additionalData;
    private String uniqueId;

    /** 
     * Get the 'OriginalFare' element value. Original Fare value retrieved from O and D
     * 
     * @return value
     */
    public Integer getOriginalFare() {
        return originalFare;
    }

    /** 
     * Set the 'OriginalFare' element value. Original Fare value retrieved from O and D
     * 
     * @param originalFare
     */
    public void setOriginalFare(Integer originalFare) {
        this.originalFare = originalFare;
    }

    /** 
     * Get the 'EffectiveBidPrice' element value. Effective bid price
     * 
     * @return value
     */
    public Integer getEffectiveBidPrice() {
        return effectiveBidPrice;
    }

    /** 
     * Set the 'EffectiveBidPrice' element value. Effective bid price
     * 
     * @param effectiveBidPrice
     */
    public void setEffectiveBidPrice(Integer effectiveBidPrice) {
        this.effectiveBidPrice = effectiveBidPrice;
    }

    /** 
     * Get the 'AdjustedFare' element value. Adjusted final fare used for evaluation
     * 
     * @return value
     */
    public Integer getAdjustedFare() {
        return adjustedFare;
    }

    /** 
     * Set the 'AdjustedFare' element value. Adjusted final fare used for evaluation
     * 
     * @param adjustedFare
     */
    public void setAdjustedFare(Integer adjustedFare) {
        this.adjustedFare = adjustedFare;
    }

    /** 
     * Get the 'AdjustedBidPrice' element value. Adjusted bid price
     * 
     * @return value
     */
    public Integer getAdjustedBidPrice() {
        return adjustedBidPrice;
    }

    /** 
     * Set the 'AdjustedBidPrice' element value. Adjusted bid price
     * 
     * @param adjustedBidPrice
     */
    public void setAdjustedBidPrice(Integer adjustedBidPrice) {
        this.adjustedBidPrice = adjustedBidPrice;
    }

    /** 
     * Get the 'FareClass' element value. Orign and Destination Fare Class
     * 
     * @return value
     */
    public String getFareClass() {
        return fareClass;
    }

    /** 
     * Set the 'FareClass' element value. Orign and Destination Fare Class
     * 
     * @param fareClass
     */
    public void setFareClass(String fareClass) {
        this.fareClass = fareClass;
    }

    /** 
     * Get the 'LowestAvailFareClass' element value. Lowest Orign and Destination class available
     * 
     * @return value
     */
    public String getLowestAvailFareClass() {
        return lowestAvailFareClass;
    }

    /** 
     * Set the 'LowestAvailFareClass' element value. Lowest Orign and Destination class available
     * 
     * @param lowestAvailFareClass
     */
    public void setLowestAvailFareClass(String lowestAvailFareClass) {
        this.lowestAvailFareClass = lowestAvailFareClass;
    }

    /** 
     * Get the 'PointOfCommencement' element value. Point of Commencement
     * 
     * @return value
     */
    public String getPointOfCommencement() {
        return pointOfCommencement;
    }

    /** 
     * Set the 'PointOfCommencement' element value. Point of Commencement
     * 
     * @param pointOfCommencement
     */
    public void setPointOfCommencement(String pointOfCommencement) {
        this.pointOfCommencement = pointOfCommencement;
    }

    /** 
     * Get the 'CustomerScore' element value. Customer Value Score
     * 
     * @return value
     */
    public BigInteger getCustomerScore() {
        return customerScore;
    }

    /** 
     * Set the 'CustomerScore' element value. Customer Value Score
     * 
     * @param customerScore
     */
    public void setCustomerScore(BigInteger customerScore) {
        this.customerScore = customerScore;
    }

    /** 
     * Get the 'FrequentFlyer' element value. Frequent Flyer
     * 
     * @return value
     */
    public ODFrequentFlyerType getFrequentFlyer() {
        return frequentFlyer;
    }

    /** 
     * Set the 'FrequentFlyer' element value. Frequent Flyer
     * 
     * @param frequentFlyer
     */
    public void setFrequentFlyer(ODFrequentFlyerType frequentFlyer) {
        this.frequentFlyer = frequentFlyer;
    }

    /** 
     * Get the 'Market' element value. Financial Orign and Destination with Level
     * 
     * @return value
     */
    public ODMarketType getMarket() {
        return market;
    }

    /** 
     * Set the 'Market' element value. Financial Orign and Destination with Level
     * 
     * @param market
     */
    public void setMarket(ODMarketType market) {
        this.market = market;
    }

    /** 
     * Get the 'TripMarket' element value. Trip Orign and Destination with Level
     * 
     * @return value
     */
    public ODMarketType getTripMarket() {
        return tripMarket;
    }

    /** 
     * Set the 'TripMarket' element value. Trip Orign and Destination with Level
     * 
     * @param tripMarket
     */
    public void setTripMarket(ODMarketType tripMarket) {
        this.tripMarket = tripMarket;
    }

    /** 
     * Get the 'RetrievedFareMarket' element value. Retrieved Fare Orign and Destination with Level
     * 
     * @return value
     */
    public ODMarketType getRetrievedFareMarket() {
        return retrievedFareMarket;
    }

    /** 
     * Set the 'RetrievedFareMarket' element value. Retrieved Fare Orign and Destination with Level
     * 
     * @param retrievedFareMarket
     */
    public void setRetrievedFareMarket(ODMarketType retrievedFareMarket) {
        this.retrievedFareMarket = retrievedFareMarket;
    }

    /** 
     * Get the 'FareTypeIndicators' element value. Fare Type Indicators
     * 
     * @return value
     */
    public ODFareTypeIndicatorsType getFareTypeIndicators() {
        return fareTypeIndicators;
    }

    /** 
     * Set the 'FareTypeIndicators' element value. Fare Type Indicators
     * 
     * @param fareTypeIndicators
     */
    public void setFareTypeIndicators(
            ODFareTypeIndicatorsType fareTypeIndicators) {
        this.fareTypeIndicators = fareTypeIndicators;
    }

    /** 
     * Get the 'EvaluationTypeIndicators' element value. Evaluation Type Indicators
     * 
     * @return value
     */
    public ODEvaluationTypeIndicatorsType getEvaluationTypeIndicators() {
        return evaluationTypeIndicators;
    }

    /** 
     * Set the 'EvaluationTypeIndicators' element value. Evaluation Type Indicators
     * 
     * @param evaluationTypeIndicators
     */
    public void setEvaluationTypeIndicators(
            ODEvaluationTypeIndicatorsType evaluationTypeIndicators) {
        this.evaluationTypeIndicators = evaluationTypeIndicators;
    }

    /** 
     * Get the 'ExceptionTypeIndicators' element value. Exception Type Indicators
     * 
     * @return value
     */
    public ODExceptionTypeIndicatorsType getExceptionTypeIndicators() {
        return exceptionTypeIndicators;
    }

    /** 
     * Set the 'ExceptionTypeIndicators' element value. Exception Type Indicators
     * 
     * @param exceptionTypeIndicators
     */
    public void setExceptionTypeIndicators(
            ODExceptionTypeIndicatorsType exceptionTypeIndicators) {
        this.exceptionTypeIndicators = exceptionTypeIndicators;
    }

    /** 
     * Get the 'AdditionalFlags' element value. Additional Flags - undefined
     * 
     * @return value
     */
    public String getAdditionalFlags() {
        return additionalFlags;
    }

    /** 
     * Set the 'AdditionalFlags' element value. Additional Flags - undefined
     * 
     * @param additionalFlags
     */
    public void setAdditionalFlags(String additionalFlags) {
        this.additionalFlags = additionalFlags;
    }

    /** 
     * Get the 'AdditionalData' element value. Additional Data - undefined
     * 
     * @return value
     */
    public String getAdditionalData() {
        return additionalData;
    }

    /** 
     * Set the 'AdditionalData' element value. Additional Data - undefined
     * 
     * @param additionalData
     */
    public void setAdditionalData(String additionalData) {
        this.additionalData = additionalData;
    }

    /** 
     * Get the 'uniqueId' attribute value.
     * 
     * @return value
     */
    public String getUniqueId() {
        return uniqueId;
    }

    /** 
     * Set the 'uniqueId' attribute value.
     * 
     * @param uniqueId
     */
    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }
}
