
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;

/** 
 * 3 command process:

 #1 - Send form of payment

 format 3OTHS(opt seg #)/(credit card code)/(credit card
 #)EXP (2 # exp month) (last 2 #'s exp year)
 3OTHS1/AX11428755558239001EXP 12 07

 #2 - send cardholder name as shown on the card

 format 3OTHS(opt seg #)/CH (card holder name) 3OTHS/CH
 ALLAN JACKSON

 #3 - send free text remarks that you have read contract
 of carriage information to passenger

 format 3OTHS(opt seg #)/(free text) 3OTHS/PAX AGREES TO
 OPERATOR PARTICIPANT CONTRACT

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OTHSFOPMessage.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CreditCardCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CreditCardNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ExpirationMonth" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ExpirationYear" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CardHolderName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Comment" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="id"/>
 *   &lt;xs:attribute type="ns:OperationType.PNRB" name="op"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OTHSFOPMessagePNRB implements Serializable
{
    private String creditCardCode;
    private String creditCardNumber;
    private String expirationMonth;
    private String expirationYear;
    private String cardHolderName;
    private String comment;
    private String id;
    private OperationTypePNRB op;

    /** 
     * Get the 'CreditCardCode' element value.
     * 
     * @return value
     */
    public String getCreditCardCode() {
        return creditCardCode;
    }

    /** 
     * Set the 'CreditCardCode' element value.
     * 
     * @param creditCardCode
     */
    public void setCreditCardCode(String creditCardCode) {
        this.creditCardCode = creditCardCode;
    }

    /** 
     * Get the 'CreditCardNumber' element value.
     * 
     * @return value
     */
    public String getCreditCardNumber() {
        return creditCardNumber;
    }

    /** 
     * Set the 'CreditCardNumber' element value.
     * 
     * @param creditCardNumber
     */
    public void setCreditCardNumber(String creditCardNumber) {
        this.creditCardNumber = creditCardNumber;
    }

    /** 
     * Get the 'ExpirationMonth' element value.
     * 
     * @return value
     */
    public String getExpirationMonth() {
        return expirationMonth;
    }

    /** 
     * Set the 'ExpirationMonth' element value.
     * 
     * @param expirationMonth
     */
    public void setExpirationMonth(String expirationMonth) {
        this.expirationMonth = expirationMonth;
    }

    /** 
     * Get the 'ExpirationYear' element value.
     * 
     * @return value
     */
    public String getExpirationYear() {
        return expirationYear;
    }

    /** 
     * Set the 'ExpirationYear' element value.
     * 
     * @param expirationYear
     */
    public void setExpirationYear(String expirationYear) {
        this.expirationYear = expirationYear;
    }

    /** 
     * Get the 'CardHolderName' element value.
     * 
     * @return value
     */
    public String getCardHolderName() {
        return cardHolderName;
    }

    /** 
     * Set the 'CardHolderName' element value.
     * 
     * @param cardHolderName
     */
    public void setCardHolderName(String cardHolderName) {
        this.cardHolderName = cardHolderName;
    }

    /** 
     * Get the 'Comment' element value.
     * 
     * @return value
     */
    public String getComment() {
        return comment;
    }

    /** 
     * Set the 'Comment' element value.
     * 
     * @param comment
     */
    public void setComment(String comment) {
        this.comment = comment;
    }

    /** 
     * Get the 'id' attribute value.
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value.
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @return value
     */
    public OperationTypePNRB getOp() {
        return op;
    }

    /** 
     * Set the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @param op
     */
    public void setOp(OperationTypePNRB op) {
        this.op = op;
    }
}
