
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.math.BigInteger;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:group xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OptionalAncillaryServicesInformationDataGroup.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:integer" name="Quantity" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:byte" name="SegmentNumber" minOccurs="0" maxOccurs="24"/>
 *     &lt;xs:element type="ns:AncillaryPrice.PNRB" name="EquivalentPrice" minOccurs="0"/>
 *     &lt;xs:element type="ns:AncillaryPrice.PNRB" name="TTLPrice" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PortionOfTravelIndicator" minOccurs="0"/>
 *     &lt;xs:element type="ns:AncillaryPrice.PNRB" name="OriginalBasePrice" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="RefundIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CommisionIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="InterlineIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FeeApplicationIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PassengerTypeCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="BoardPoint" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="OffPoint" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="TaxesIncluded" minOccurs="0"/>
 *     &lt;xs:element name="Taxes" minOccurs="0">
 *       &lt;!-- Reference to inner class Taxes -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:boolean" name="SoftMatchIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="NoChargeNotAvailIndicator" minOccurs="0"/>
 *     &lt;xs:element name="TicketCouponNumberAssociation" minOccurs="0" maxOccurs="4">
 *       &lt;!-- Reference to inner class TicketCouponNumberAssociation -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="SimultaneousTicketIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FormOfRefund" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="FeeNotGuaranteedIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:short" name="FQTVTierLevel" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TourCodeSHC" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TravelDateEffective" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="LatestTravelDatePermitted" minOccurs="0"/>
 *     &lt;xs:element type="xs:date" name="PurchaseByDate" minOccurs="0"/>
 *     &lt;xs:element type="ns:AncillaryPrice.PNRB" name="TotalOriginalBasePrice" minOccurs="0"/>
 *     &lt;xs:element type="ns:AncillaryPrice.PNRB" name="TotalEquivalentPrice" minOccurs="0"/>
 *     &lt;xs:element type="ns:AncillaryPrice.PNRB" name="TotalTTLPrice" minOccurs="0"/>
 *     &lt;xs:element name="TotalTaxes" minOccurs="0">
 *       &lt;!-- Reference to inner class TotalTaxes -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="TaxExemptIndicator" minOccurs="0"/>
 *     &lt;xs:element name="BagWeight" minOccurs="0">
 *       &lt;!-- Reference to inner class BagWeight -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:FCMIType" name="FareCalculationModeIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FareCalculationPriceIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:integer" name="BagOccurence" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:group>
 * </pre>
 */
public class OptionalAncillaryServicesInformationDataGroupPNRB implements
    Serializable
{
    private BigInteger quantity;
    private List<Byte> segmentNumberList = new ArrayList<Byte>();
    private AncillaryPricePNRB equivalentPrice;
    private AncillaryPricePNRB TTLPrice;
    private String portionOfTravelIndicator;
    private AncillaryPricePNRB originalBasePrice;
    private String refundIndicator;
    private String commisionIndicator;
    private String interlineIndicator;
    private String feeApplicationIndicator;
    private String passengerTypeCode;
    private String boardPoint;
    private String offPoint;
    private Boolean taxesIncluded;
    private Taxes taxes;
    private Boolean softMatchIndicator;
    private String noChargeNotAvailIndicator;
    private List<TicketCouponNumberAssociation> ticketCouponNumberAssociationList = new ArrayList<TicketCouponNumberAssociation>();
    private String simultaneousTicketIndicator;
    private String formOfRefund;
    private Boolean feeNotGuaranteedIndicator;
    private Short FQTVTierLevel;
    private String tourCodeSHC;
    private String travelDateEffective;
    private String latestTravelDatePermitted;
    private Date purchaseByDate;
    private AncillaryPricePNRB totalOriginalBasePrice;
    private AncillaryPricePNRB totalEquivalentPrice;
    private AncillaryPricePNRB totalTTLPrice;
    private TotalTaxes totalTaxes;
    private String taxExemptIndicator;
    private BagWeight bagWeight;
    private FCMIType fareCalculationModeIndicator;
    private String fareCalculationPriceIndicator;
    private BigInteger bagOccurence;

    /** 
     * Get the 'Quantity' element value.
     * 
     * @return value
     */
    public BigInteger getQuantity() {
        return quantity;
    }

    /** 
     * Set the 'Quantity' element value.
     * 
     * @param quantity
     */
    public void setQuantity(BigInteger quantity) {
        this.quantity = quantity;
    }

    /** 
     * Get the list of 'SegmentNumber' element items.
     * 
     * @return list
     */
    public List<Byte> getSegmentNumberList() {
        return segmentNumberList;
    }

    /** 
     * Set the list of 'SegmentNumber' element items.
     * 
     * @param list
     */
    public void setSegmentNumberList(List<Byte> list) {
        segmentNumberList = list;
    }

    /** 
     * Get the 'EquivalentPrice' element value. Price in different currency than one used as a base line.
     * 
     * @return value
     */
    public AncillaryPricePNRB getEquivalentPrice() {
        return equivalentPrice;
    }

    /** 
     * Set the 'EquivalentPrice' element value. Price in different currency than one used as a base line.
     * 
     * @param equivalentPrice
     */
    public void setEquivalentPrice(AncillaryPricePNRB equivalentPrice) {
        this.equivalentPrice = equivalentPrice;
    }

    /** 
     * Get the 'TTLPrice' element value. One unit price of the ancillary service after taxation.
     * 
     * @return value
     */
    public AncillaryPricePNRB getTTLPrice() {
        return TTLPrice;
    }

    /** 
     * Set the 'TTLPrice' element value. One unit price of the ancillary service after taxation.
     * 
     * @param TTLPrice
     */
    public void setTTLPrice(AncillaryPricePNRB TTLPrice) {
        this.TTLPrice = TTLPrice;
    }

    /** 
     * Get the 'PortionOfTravelIndicator' element value.
     * 
     * @return value
     */
    public String getPortionOfTravelIndicator() {
        return portionOfTravelIndicator;
    }

    /** 
     * Set the 'PortionOfTravelIndicator' element value.
     * 
     * @param portionOfTravelIndicator
     */
    public void setPortionOfTravelIndicator(String portionOfTravelIndicator) {
        this.portionOfTravelIndicator = portionOfTravelIndicator;
    }

    /** 
     * Get the 'OriginalBasePrice' element value. One unit price of the ancillary service before taxation.
     * 
     * @return value
     */
    public AncillaryPricePNRB getOriginalBasePrice() {
        return originalBasePrice;
    }

    /** 
     * Set the 'OriginalBasePrice' element value. One unit price of the ancillary service before taxation.
     * 
     * @param originalBasePrice
     */
    public void setOriginalBasePrice(AncillaryPricePNRB originalBasePrice) {
        this.originalBasePrice = originalBasePrice;
    }

    /** 
     * Get the 'RefundIndicator' element value. Indicates if ancillary service is refundable.
     * 
     * @return value
     */
    public String getRefundIndicator() {
        return refundIndicator;
    }

    /** 
     * Set the 'RefundIndicator' element value. Indicates if ancillary service is refundable.
     * 
     * @param refundIndicator
     */
    public void setRefundIndicator(String refundIndicator) {
        this.refundIndicator = refundIndicator;
    }

    /** 
     * Get the 'CommisionIndicator' element value. Indicates if ancillary service is commissionable.
     * 
     * @return value
     */
    public String getCommisionIndicator() {
        return commisionIndicator;
    }

    /** 
     * Set the 'CommisionIndicator' element value. Indicates if ancillary service is commissionable.
     * 
     * @param commisionIndicator
     */
    public void setCommisionIndicator(String commisionIndicator) {
        this.commisionIndicator = commisionIndicator;
    }

    /** 
     * Get the 'InterlineIndicator' element value. Indicates if ancillary service is interlineable
     * 
     * @return value
     */
    public String getInterlineIndicator() {
        return interlineIndicator;
    }

    /** 
     * Set the 'InterlineIndicator' element value. Indicates if ancillary service is interlineable
     * 
     * @param interlineIndicator
     */
    public void setInterlineIndicator(String interlineIndicator) {
        this.interlineIndicator = interlineIndicator;
    }

    /** 
     * Get the 'FeeApplicationIndicator' element value. Indicates if the fee is based on a flight segment, multiple flight segments or
                          entire ticket.
                      
     * 
     * @return value
     */
    public String getFeeApplicationIndicator() {
        return feeApplicationIndicator;
    }

    /** 
     * Set the 'FeeApplicationIndicator' element value. Indicates if the fee is based on a flight segment, multiple flight segments or
                          entire ticket.
                      
     * 
     * @param feeApplicationIndicator
     */
    public void setFeeApplicationIndicator(String feeApplicationIndicator) {
        this.feeApplicationIndicator = feeApplicationIndicator;
    }

    /** 
     * Get the 'PassengerTypeCode' element value. Indicates the type of passenger to whom the record applies like "ADT".
                      
     * 
     * @return value
     */
    public String getPassengerTypeCode() {
        return passengerTypeCode;
    }

    /** 
     * Set the 'PassengerTypeCode' element value. Indicates the type of passenger to whom the record applies like "ADT".
                      
     * 
     * @param passengerTypeCode
     */
    public void setPassengerTypeCode(String passengerTypeCode) {
        this.passengerTypeCode = passengerTypeCode;
    }

    /** 
     * Get the 'BoardPoint' element value.
     * 
     * @return value
     */
    public String getBoardPoint() {
        return boardPoint;
    }

    /** 
     * Set the 'BoardPoint' element value.
     * 
     * @param boardPoint
     */
    public void setBoardPoint(String boardPoint) {
        this.boardPoint = boardPoint;
    }

    /** 
     * Get the 'OffPoint' element value.
     * 
     * @return value
     */
    public String getOffPoint() {
        return offPoint;
    }

    /** 
     * Set the 'OffPoint' element value.
     * 
     * @param offPoint
     */
    public void setOffPoint(String offPoint) {
        this.offPoint = offPoint;
    }

    /** 
     * Get the 'TaxesIncluded' element value. Indicates if service fee amounts are inclusive of applicable taxes. Ex."TRUE"
                      
     * 
     * @return value
     */
    public Boolean getTaxesIncluded() {
        return taxesIncluded;
    }

    /** 
     * Set the 'TaxesIncluded' element value. Indicates if service fee amounts are inclusive of applicable taxes. Ex."TRUE"
                      
     * 
     * @param taxesIncluded
     */
    public void setTaxesIncluded(Boolean taxesIncluded) {
        this.taxesIncluded = taxesIncluded;
    }

    /** 
     * Get the 'Taxes' element value.
     * 
     * @return value
     */
    public Taxes getTaxes() {
        return taxes;
    }

    /** 
     * Set the 'Taxes' element value.
     * 
     * @param taxes
     */
    public void setTaxes(Taxes taxes) {
        this.taxes = taxes;
    }

    /** 
     * Get the 'SoftMatchIndicator' element value. Identifies a service which may match the request based on the data in the
                          request.
                      
     * 
     * @return value
     */
    public Boolean getSoftMatchIndicator() {
        return softMatchIndicator;
    }

    /** 
     * Set the 'SoftMatchIndicator' element value. Identifies a service which may match the request based on the data in the
                          request.
                      
     * 
     * @param softMatchIndicator
     */
    public void setSoftMatchIndicator(Boolean softMatchIndicator) {
        this.softMatchIndicator = softMatchIndicator;
    }

    /** 
     * Get the 'NoChargeNotAvailIndicator' element value. Not Available / No Charge: indicates that
                          the service in this record is not available or that there is no charge for the service..
                      
     * 
     * @return value
     */
    public String getNoChargeNotAvailIndicator() {
        return noChargeNotAvailIndicator;
    }

    /** 
     * Set the 'NoChargeNotAvailIndicator' element value. Not Available / No Charge: indicates that
                          the service in this record is not available or that there is no charge for the service..
                      
     * 
     * @param noChargeNotAvailIndicator
     */
    public void setNoChargeNotAvailIndicator(String noChargeNotAvailIndicator) {
        this.noChargeNotAvailIndicator = noChargeNotAvailIndicator;
    }

    /** 
     * Get the list of 'TicketCouponNumberAssociation' element items.
     * 
     * @return list
     */
    public List<TicketCouponNumberAssociation> getTicketCouponNumberAssociationList() {
        return ticketCouponNumberAssociationList;
    }

    /** 
     * Set the list of 'TicketCouponNumberAssociation' element items.
     * 
     * @param list
     */
    public void setTicketCouponNumberAssociationList(
            List<TicketCouponNumberAssociation> list) {
        ticketCouponNumberAssociationList = list;
    }

    /** 
     * Get the 'SimultaneousTicketIndicator' element value. Is the simultaneous changes process applicable.
     * 
     * @return value
     */
    public String getSimultaneousTicketIndicator() {
        return simultaneousTicketIndicator;
    }

    /** 
     * Set the 'SimultaneousTicketIndicator' element value. Is the simultaneous changes process applicable.
     * 
     * @param simultaneousTicketIndicator
     */
    public void setSimultaneousTicketIndicator(
            String simultaneousTicketIndicator) {
        this.simultaneousTicketIndicator = simultaneousTicketIndicator;
    }

    /** 
     * Get the 'FormOfRefund' element value. How may the fee be refunded, e.g., original FOP, voucher.
     * 
     * @return value
     */
    public String getFormOfRefund() {
        return formOfRefund;
    }

    /** 
     * Set the 'FormOfRefund' element value. How may the fee be refunded, e.g., original FOP, voucher.
     * 
     * @param formOfRefund
     */
    public void setFormOfRefund(String formOfRefund) {
        this.formOfRefund = formOfRefund;
    }

    /** 
     * Get the 'FeeNotGuaranteedIndicator' element value. Is the fee not guaranteed.
     * 
     * @return value
     */
    public Boolean getFeeNotGuaranteedIndicator() {
        return feeNotGuaranteedIndicator;
    }

    /** 
     * Set the 'FeeNotGuaranteedIndicator' element value. Is the fee not guaranteed.
     * 
     * @param feeNotGuaranteedIndicator
     */
    public void setFeeNotGuaranteedIndicator(Boolean feeNotGuaranteedIndicator) {
        this.feeNotGuaranteedIndicator = feeNotGuaranteedIndicator;
    }

    /** 
     * Get the 'FQTVTierLevel' element value. Frequent Traveler tier level.
     * 
     * @return value
     */
    public Short getFQTVTierLevel() {
        return FQTVTierLevel;
    }

    /** 
     * Set the 'FQTVTierLevel' element value. Frequent Traveler tier level.
     * 
     * @param FQTVTierLevel
     */
    public void setFQTVTierLevel(Short FQTVTierLevel) {
        this.FQTVTierLevel = FQTVTierLevel;
    }

    /** 
     * Get the 'TourCodeSHC' element value. This is the tour code used for matching the OC Fee.
     * 
     * @return value
     */
    public String getTourCodeSHC() {
        return tourCodeSHC;
    }

    /** 
     * Set the 'TourCodeSHC' element value. This is the tour code used for matching the OC Fee.
     * 
     * @param tourCodeSHC
     */
    public void setTourCodeSHC(String tourCodeSHC) {
        this.tourCodeSHC = tourCodeSHC;
    }

    /** 
     * Get the 'TravelDateEffective' element value.
     * 
     * @return value
     */
    public String getTravelDateEffective() {
        return travelDateEffective;
    }

    /** 
     * Set the 'TravelDateEffective' element value.
     * 
     * @param travelDateEffective
     */
    public void setTravelDateEffective(String travelDateEffective) {
        this.travelDateEffective = travelDateEffective;
    }

    /** 
     * Get the 'LatestTravelDatePermitted' element value.
     * 
     * @return value
     */
    public String getLatestTravelDatePermitted() {
        return latestTravelDatePermitted;
    }

    /** 
     * Set the 'LatestTravelDatePermitted' element value.
     * 
     * @param latestTravelDatePermitted
     */
    public void setLatestTravelDatePermitted(String latestTravelDatePermitted) {
        this.latestTravelDatePermitted = latestTravelDatePermitted;
    }

    /** 
     * Get the 'PurchaseByDate' element value. Date by which the service must be purchased/ticketed.
     * 
     * @return value
     */
    public Date getPurchaseByDate() {
        return purchaseByDate;
    }

    /** 
     * Set the 'PurchaseByDate' element value. Date by which the service must be purchased/ticketed.
     * 
     * @param purchaseByDate
     */
    public void setPurchaseByDate(Date purchaseByDate) {
        this.purchaseByDate = purchaseByDate;
    }

    /** 
     * Get the 'TotalOriginalBasePrice' element value. "OrginalBasePrice" multiplied by "NumberOfItems
     * 
     * @return value
     */
    public AncillaryPricePNRB getTotalOriginalBasePrice() {
        return totalOriginalBasePrice;
    }

    /** 
     * Set the 'TotalOriginalBasePrice' element value. "OrginalBasePrice" multiplied by "NumberOfItems
     * 
     * @param totalOriginalBasePrice
     */
    public void setTotalOriginalBasePrice(
            AncillaryPricePNRB totalOriginalBasePrice) {
        this.totalOriginalBasePrice = totalOriginalBasePrice;
    }

    /** 
     * Get the 'TotalEquivalentPrice' element value. "EquivalentPrice" multiplied by "NumberOfItems".
     * 
     * @return value
     */
    public AncillaryPricePNRB getTotalEquivalentPrice() {
        return totalEquivalentPrice;
    }

    /** 
     * Set the 'TotalEquivalentPrice' element value. "EquivalentPrice" multiplied by "NumberOfItems".
     * 
     * @param totalEquivalentPrice
     */
    public void setTotalEquivalentPrice(AncillaryPricePNRB totalEquivalentPrice) {
        this.totalEquivalentPrice = totalEquivalentPrice;
    }

    /** 
     * Get the 'TotalTTLPrice' element value. "TTLPrice" multiplied by "NumberOfItems. Ex."60"
     * 
     * @return value
     */
    public AncillaryPricePNRB getTotalTTLPrice() {
        return totalTTLPrice;
    }

    /** 
     * Set the 'TotalTTLPrice' element value. "TTLPrice" multiplied by "NumberOfItems. Ex."60"
     * 
     * @param totalTTLPrice
     */
    public void setTotalTTLPrice(AncillaryPricePNRB totalTTLPrice) {
        this.totalTTLPrice = totalTTLPrice;
    }

    /** 
     * Get the 'TotalTaxes' element value.
     * 
     * @return value
     */
    public TotalTaxes getTotalTaxes() {
        return totalTaxes;
    }

    /** 
     * Set the 'TotalTaxes' element value.
     * 
     * @param totalTaxes
     */
    public void setTotalTaxes(TotalTaxes totalTaxes) {
        this.totalTaxes = totalTaxes;
    }

    /** 
     * Get the 'TaxExemptIndicator' element value.
     * 
     * @return value
     */
    public String getTaxExemptIndicator() {
        return taxExemptIndicator;
    }

    /** 
     * Set the 'TaxExemptIndicator' element value.
     * 
     * @param taxExemptIndicator
     */
    public void setTaxExemptIndicator(String taxExemptIndicator) {
        this.taxExemptIndicator = taxExemptIndicator;
    }

    /** 
     * Get the 'BagWeight' element value.
     * 
     * @return value
     */
    public BagWeight getBagWeight() {
        return bagWeight;
    }

    /** 
     * Set the 'BagWeight' element value.
     * 
     * @param bagWeight
     */
    public void setBagWeight(BagWeight bagWeight) {
        this.bagWeight = bagWeight;
    }

    /** 
     * Get the 'FareCalculationModeIndicator' element value. 0 = System priced, 1 = Manually priced, 2 - System priced, but tax data
                          manually changed
                      
     * 
     * @return value
     */
    public FCMIType getFareCalculationModeIndicator() {
        return fareCalculationModeIndicator;
    }

    /** 
     * Set the 'FareCalculationModeIndicator' element value. 0 = System priced, 1 = Manually priced, 2 - System priced, but tax data
                          manually changed
                      
     * 
     * @param fareCalculationModeIndicator
     */
    public void setFareCalculationModeIndicator(
            FCMIType fareCalculationModeIndicator) {
        this.fareCalculationModeIndicator = fareCalculationModeIndicator;
    }

    /** 
     * Get the 'FareCalculationPriceIndicator' element value. 
                          0 = System computer priced (without any manual modifications except for baggage allowance),
                          1 = Manually priced, 2-9 = For individual airline/system provider use, A-Z = Undefined industry
                          use
                      
     * 
     * @return value
     */
    public String getFareCalculationPriceIndicator() {
        return fareCalculationPriceIndicator;
    }

    /** 
     * Set the 'FareCalculationPriceIndicator' element value. 
                          0 = System computer priced (without any manual modifications except for baggage allowance),
                          1 = Manually priced, 2-9 = For individual airline/system provider use, A-Z = Undefined industry
                          use
                      
     * 
     * @param fareCalculationPriceIndicator
     */
    public void setFareCalculationPriceIndicator(
            String fareCalculationPriceIndicator) {
        this.fareCalculationPriceIndicator = fareCalculationPriceIndicator;
    }

    /** 
     * Get the 'BagOccurence' element value. Number of occurrences of a given bag ancillary subcode within a PNR 
     * 
     * @return value
     */
    public BigInteger getBagOccurence() {
        return bagOccurence;
    }

    /** 
     * Set the 'BagOccurence' element value. Number of occurrences of a given bag ancillary subcode within a PNR 
     * 
     * @param bagOccurence
     */
    public void setBagOccurence(BigInteger bagOccurence) {
        this.bagOccurence = bagOccurence;
    }
    /** 
     * Taxes
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:AncillaryTax.PNRB" name="Tax" minOccurs="0" maxOccurs="99"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Taxes implements Serializable
    {
        private List<AncillaryTaxPNRB> taxList = new ArrayList<AncillaryTaxPNRB>();

        /** 
         * Get the list of 'Tax' element items.
         * 
         * @return list
         */
        public List<AncillaryTaxPNRB> getTaxList() {
            return taxList;
        }

        /** 
         * Set the list of 'Tax' element items.
         * 
         * @param list
         */
        public void setTaxList(List<AncillaryTaxPNRB> list) {
            taxList = list;
        }
    }
    /** 
     * Etkt coupon number to which the EMD is associated.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketCouponNumberAssociation" minOccurs="0" maxOccurs="4">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:short" name="TicketCouponNumber" minOccurs="0" maxOccurs="16"/>
     *       &lt;xs:element type="xs:string" name="TicketReferenceNumber" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TicketCouponNumberAssociation implements Serializable
    {
        private List<Short> ticketCouponNumberList = new ArrayList<Short>();
        private String ticketReferenceNumber;

        /** 
         * Get the list of 'TicketCouponNumber' element items. Coupon number of the ticket.
         * 
         * @return list
         */
        public List<Short> getTicketCouponNumberList() {
            return ticketCouponNumberList;
        }

        /** 
         * Set the list of 'TicketCouponNumber' element items. Coupon number of the ticket.
         * 
         * @param list
         */
        public void setTicketCouponNumberList(List<Short> list) {
            ticketCouponNumberList = list;
        }

        /** 
         * Get the 'TicketReferenceNumber' element value. The Etkt number.
         * 
         * @return value
         */
        public String getTicketReferenceNumber() {
            return ticketReferenceNumber;
        }

        /** 
         * Set the 'TicketReferenceNumber' element value. The Etkt number.
         * 
         * @param ticketReferenceNumber
         */
        public void setTicketReferenceNumber(String ticketReferenceNumber) {
            this.ticketReferenceNumber = ticketReferenceNumber;
        }
    }
    /** 
     * Tax multiplied by "NumberOfItems".
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalTaxes" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:AncillaryTax.PNRB" name="Tax" minOccurs="0" maxOccurs="99"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TotalTaxes implements Serializable
    {
        private List<AncillaryTaxPNRB> taxList = new ArrayList<AncillaryTaxPNRB>();

        /** 
         * Get the list of 'Tax' element items.
         * 
         * @return list
         */
        public List<AncillaryTaxPNRB> getTaxList() {
            return taxList;
        }

        /** 
         * Set the list of 'Tax' element items.
         * 
         * @param list
         */
        public void setTaxList(List<AncillaryTaxPNRB> list) {
            taxList = list;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BagWeight" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:integer">
     *         &lt;xs:attribute type="xs:string" use="optional" name="Unit"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class BagWeight implements Serializable
    {
        private BigInteger integer;
        private String unit;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public BigInteger getInteger() {
            return integer;
        }

        /** 
         * Set the extension value.
         * 
         * @param integer
         */
        public void setInteger(BigInteger integer) {
            this.integer = integer;
        }

        /** 
         * Get the 'Unit' attribute value.
         * 
         * @return value
         */
        public String getUnit() {
            return unit;
        }

        /** 
         * Set the 'Unit' attribute value.
         * 
         * @param unit
         */
        public void setUnit(String unit) {
            this.unit = unit;
        }
    }
}
