
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PACInfo.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="PAC" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class PAC -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PACInfoPNRB implements Serializable
{
    private List<PAC> PACList = new ArrayList<PAC>();

    /** 
     * Get the list of 'PAC' element items.
     * 
     * @return list
     */
    public List<PAC> getPACList() {
        return PACList;
    }

    /** 
     * Set the list of 'PAC' element items.
     * 
     * @param list
     */
    public void setPACList(List<PAC> list) {
        PACList = list;
    }
    /** 
     * "PAC" is used to reflect Passenger Account Code Banner.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PAC" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" name="NameAssociation"/>
     *     &lt;xs:attribute type="xs:string" name="Text"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="Id"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PAC implements Serializable
    {
        private String nameAssociation;
        private String text;
        private String id;

        /** 
         * Get the 'NameAssociation' attribute value. "NameAssociation" is the passenger name number to be associated with the passenger account code data in the PNR.
                                
         * 
         * @return value
         */
        public String getNameAssociation() {
            return nameAssociation;
        }

        /** 
         * Set the 'NameAssociation' attribute value. "NameAssociation" is the passenger name number to be associated with the passenger account code data in the PNR.
                                
         * 
         * @param nameAssociation
         */
        public void setNameAssociation(String nameAssociation) {
            this.nameAssociation = nameAssociation;
        }

        /** 
         * Get the 'Text' attribute value.
         * 
         * @return value
         */
        public String getText() {
            return text;
        }

        /** 
         * Set the 'Text' attribute value.
         * 
         * @param text
         */
        public void setText(String text) {
            this.text = text;
        }

        /** 
         * Get the 'Id' attribute value.
         * 
         * @return value
         */
        public String getId() {
            return id;
        }

        /** 
         * Set the 'Id' attribute value.
         * 
         * @param id
         */
        public void setId(String id) {
            this.id = id;
        }
    }
}
