
package com.sabre.webservices.pnrbuilder.v119;

import com.sabre.services.res.or.v114.OpenReservationElementsType;
import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:ns1="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passenger.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="LastName"/>
 *     &lt;xs:element type="ns:NativeLanguageValueType" name="OriginalLastName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FirstName" minOccurs="0"/>
 *     &lt;xs:element type="ns:NativeLanguageValueType" name="OriginalFirstName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Title" minOccurs="0"/>
 *     &lt;xs:element type="ns:FrequentFlyer.PNRB" name="FrequentFlyer" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element type="ns:EmailAddress.PNRB" name="EmailAddress" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element type="xs:string" name="Gender" minOccurs="0"/>
 *     &lt;xs:element type="xs:date" name="DateOfBirth" minOccurs="0"/>
 *     &lt;xs:element type="ns:Profiles.PNRB" name="Profiles" minOccurs="0"/>
 *     &lt;xs:element type="ns:NameAssociatedSpecialRequests.PNRB" name="SpecialRequests" minOccurs="0"/>
 *     &lt;xs:element type="ns:Seats.PNRB" name="Seats" minOccurs="0"/>
 *     &lt;xs:element type="ns:PreReservedSeats.PNRB" name="PreReservedSeats" minOccurs="0"/>
 *     &lt;xs:element type="ns:AccountingLines.PNRB" name="AccountingLines" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PassengerProfileID" minOccurs="0"/>
 *     &lt;xs:element name="AncillaryServices" minOccurs="0">
 *       &lt;!-- Reference to inner class AncillaryServices -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="OSI" minOccurs="0">
 *       &lt;!-- Reference to inner class OSI -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:Remarks.PNRB" name="Remarks" minOccurs="0"/>
 *     &lt;xs:element type="ns:PhoneNumbers.PNRB" name="PhoneNumbers" minOccurs="0"/>
 *     &lt;xs:element type="ns:TicketingInfo.PNRB" name="TicketingInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:FqtvUpgradeRequests" name="FqtvUpgradeRequests" minOccurs="0"/>
 *     &lt;xs:element type="ns1:OpenReservationElementsType" name="OpenReservationElements" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="id"/>
 *   &lt;xs:attribute type="ns:PassengerType.PNRB" name="nameType"/>
 *   &lt;xs:attribute type="xs:string" name="passengerType"/>
 *   &lt;xs:attribute type="xs:string" name="referenceNumber"/>
 *   &lt;xs:attribute type="xs:string" name="nameId"/>
 *   &lt;xs:attribute type="xs:string" name="nameAssocId"/>
 *   &lt;xs:attribute type="xs:boolean" name="withInfant"/>
 *   &lt;xs:attribute type="ns:OperationType.PNRB" name="op"/>
 *   &lt;xs:attribute type="xs:string" name="lang"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="elementId"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PassengerPNRB implements Serializable
{
    private String lastName;
    private NativeLanguageValueType originalLastName;
    private String firstName;
    private NativeLanguageValueType originalFirstName;
    private String title;
    private List<FrequentFlyerPNRB> frequentFlyerList = new ArrayList<FrequentFlyerPNRB>();
    private List<EmailAddressPNRB> emailAddressList = new ArrayList<EmailAddressPNRB>();
    private String gender;
    private Date dateOfBirth;
    private ProfilesPNRB profiles;
    private NameAssociatedSpecialRequestsPNRB specialRequests;
    private SeatsPNRB seats;
    private PreReservedSeatsPNRB preReservedSeats;
    private AccountingLinesPNRB accountingLines;
    private String passengerProfileID;
    private AncillaryServices ancillaryServices;
    private OSI OSI1;
    private RemarksPNRB remarks;
    private PhoneNumbersPNRB phoneNumbers;
    private TicketingInfoPNRB ticketingInfo;
    private FqtvUpgradeRequests fqtvUpgradeRequests;
    private OpenReservationElementsType openReservationElements;
    private String id;
    private PassengerTypePNRB nameType;
    private String passengerType;
    private String referenceNumber;
    private String nameId;
    private String nameAssocId;
    private Boolean withInfant;
    private OperationTypePNRB op;
    private String lang;
    private String elementId;
    private String RPH;

    /** 
     * Get the 'LastName' element value. LastName. Ex."WOOD"
     * 
     * @return value
     */
    public String getLastName() {
        return lastName;
    }

    /** 
     * Set the 'LastName' element value. LastName. Ex."WOOD"
     * 
     * @param lastName
     */
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    /** 
     * Get the 'OriginalLastName' element value.
     * 
     * @return value
     */
    public NativeLanguageValueType getOriginalLastName() {
        return originalLastName;
    }

    /** 
     * Set the 'OriginalLastName' element value.
     * 
     * @param originalLastName
     */
    public void setOriginalLastName(NativeLanguageValueType originalLastName) {
        this.originalLastName = originalLastName;
    }

    /** 
     * Get the 'FirstName' element value.
     * 
     * @return value
     */
    public String getFirstName() {
        return firstName;
    }

    /** 
     * Set the 'FirstName' element value.
     * 
     * @param firstName
     */
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    /** 
     * Get the 'OriginalFirstName' element value.
     * 
     * @return value
     */
    public NativeLanguageValueType getOriginalFirstName() {
        return originalFirstName;
    }

    /** 
     * Set the 'OriginalFirstName' element value.
     * 
     * @param originalFirstName
     */
    public void setOriginalFirstName(NativeLanguageValueType originalFirstName) {
        this.originalFirstName = originalFirstName;
    }

    /** 
     * Get the 'Title' element value.
     * 
     * @return value
     */
    public String getTitle() {
        return title;
    }

    /** 
     * Set the 'Title' element value.
     * 
     * @param title
     */
    public void setTitle(String title) {
        this.title = title;
    }

    /** 
     * Get the list of 'FrequentFlyer' element items.
     * 
     * @return list
     */
    public List<FrequentFlyerPNRB> getFrequentFlyerList() {
        return frequentFlyerList;
    }

    /** 
     * Set the list of 'FrequentFlyer' element items.
     * 
     * @param list
     */
    public void setFrequentFlyerList(List<FrequentFlyerPNRB> list) {
        frequentFlyerList = list;
    }

    /** 
     * Get the list of 'EmailAddress' element items. Email address added to the PNR. Ex."ANNE@MAIL.COM"
     * 
     * @return list
     */
    public List<EmailAddressPNRB> getEmailAddressList() {
        return emailAddressList;
    }

    /** 
     * Set the list of 'EmailAddress' element items. Email address added to the PNR. Ex."ANNE@MAIL.COM"
     * 
     * @param list
     */
    public void setEmailAddressList(List<EmailAddressPNRB> list) {
        emailAddressList = list;
    }

    /** 
     * Get the 'Gender' element value.
     * 
     * @return value
     */
    public String getGender() {
        return gender;
    }

    /** 
     * Set the 'Gender' element value.
     * 
     * @param gender
     */
    public void setGender(String gender) {
        this.gender = gender;
    }

    /** 
     * Get the 'DateOfBirth' element value.
     * 
     * @return value
     */
    public Date getDateOfBirth() {
        return dateOfBirth;
    }

    /** 
     * Set the 'DateOfBirth' element value.
     * 
     * @param dateOfBirth
     */
    public void setDateOfBirth(Date dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    /** 
     * Get the 'Profiles' element value.
     * 
     * @return value
     */
    public ProfilesPNRB getProfiles() {
        return profiles;
    }

    /** 
     * Set the 'Profiles' element value.
     * 
     * @param profiles
     */
    public void setProfiles(ProfilesPNRB profiles) {
        this.profiles = profiles;
    }

    /** 
     * Get the 'SpecialRequests' element value.
     * 
     * @return value
     */
    public NameAssociatedSpecialRequestsPNRB getSpecialRequests() {
        return specialRequests;
    }

    /** 
     * Set the 'SpecialRequests' element value.
     * 
     * @param specialRequests
     */
    public void setSpecialRequests(
            NameAssociatedSpecialRequestsPNRB specialRequests) {
        this.specialRequests = specialRequests;
    }

    /** 
     * Get the 'Seats' element value.
     * 
     * @return value
     */
    public SeatsPNRB getSeats() {
        return seats;
    }

    /** 
     * Set the 'Seats' element value.
     * 
     * @param seats
     */
    public void setSeats(SeatsPNRB seats) {
        this.seats = seats;
    }

    /** 
     * Get the 'PreReservedSeats' element value.
     * 
     * @return value
     */
    public PreReservedSeatsPNRB getPreReservedSeats() {
        return preReservedSeats;
    }

    /** 
     * Set the 'PreReservedSeats' element value.
     * 
     * @param preReservedSeats
     */
    public void setPreReservedSeats(PreReservedSeatsPNRB preReservedSeats) {
        this.preReservedSeats = preReservedSeats;
    }

    /** 
     * Get the 'AccountingLines' element value.
     * 
     * @return value
     */
    public AccountingLinesPNRB getAccountingLines() {
        return accountingLines;
    }

    /** 
     * Set the 'AccountingLines' element value.
     * 
     * @param accountingLines
     */
    public void setAccountingLines(AccountingLinesPNRB accountingLines) {
        this.accountingLines = accountingLines;
    }

    /** 
     * Get the 'PassengerProfileID' element value.
     * 
     * @return value
     */
    public String getPassengerProfileID() {
        return passengerProfileID;
    }

    /** 
     * Set the 'PassengerProfileID' element value.
     * 
     * @param passengerProfileID
     */
    public void setPassengerProfileID(String passengerProfileID) {
        this.passengerProfileID = passengerProfileID;
    }

    /** 
     * Get the 'AncillaryServices' element value.
     * 
     * @return value
     */
    public AncillaryServices getAncillaryServices() {
        return ancillaryServices;
    }

    /** 
     * Set the 'AncillaryServices' element value.
     * 
     * @param ancillaryServices
     */
    public void setAncillaryServices(AncillaryServices ancillaryServices) {
        this.ancillaryServices = ancillaryServices;
    }

    /** 
     * Get the 'OSI' element value.
     * 
     * @return value
     */
    public OSI getOSI1() {
        return OSI1;
    }

    /** 
     * Set the 'OSI' element value.
     * 
     * @param OSI1
     */
    public void setOSI1(OSI OSI1) {
        this.OSI1 = OSI1;
    }

    /** 
     * Get the 'Remarks' element value.
     * 
     * @return value
     */
    public RemarksPNRB getRemarks() {
        return remarks;
    }

    /** 
     * Set the 'Remarks' element value.
     * 
     * @param remarks
     */
    public void setRemarks(RemarksPNRB remarks) {
        this.remarks = remarks;
    }

    /** 
     * Get the 'PhoneNumbers' element value.
     * 
     * @return value
     */
    public PhoneNumbersPNRB getPhoneNumbers() {
        return phoneNumbers;
    }

    /** 
     * Set the 'PhoneNumbers' element value.
     * 
     * @param phoneNumbers
     */
    public void setPhoneNumbers(PhoneNumbersPNRB phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
    }

    /** 
     * Get the 'TicketingInfo' element value.
     * 
     * @return value
     */
    public TicketingInfoPNRB getTicketingInfo() {
        return ticketingInfo;
    }

    /** 
     * Set the 'TicketingInfo' element value.
     * 
     * @param ticketingInfo
     */
    public void setTicketingInfo(TicketingInfoPNRB ticketingInfo) {
        this.ticketingInfo = ticketingInfo;
    }

    /** 
     * Get the 'FqtvUpgradeRequests' element value.
     * 
     * @return value
     */
    public FqtvUpgradeRequests getFqtvUpgradeRequests() {
        return fqtvUpgradeRequests;
    }

    /** 
     * Set the 'FqtvUpgradeRequests' element value.
     * 
     * @param fqtvUpgradeRequests
     */
    public void setFqtvUpgradeRequests(FqtvUpgradeRequests fqtvUpgradeRequests) {
        this.fqtvUpgradeRequests = fqtvUpgradeRequests;
    }

    /** 
     * Get the 'OpenReservationElements' element value.
     * 
     * @return value
     */
    public OpenReservationElementsType getOpenReservationElements() {
        return openReservationElements;
    }

    /** 
     * Set the 'OpenReservationElements' element value.
     * 
     * @param openReservationElements
     */
    public void setOpenReservationElements(
            OpenReservationElementsType openReservationElements) {
        this.openReservationElements = openReservationElements;
    }

    /** 
     * Get the 'id' attribute value.
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value.
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'nameType' attribute value. I = Infant, S = Standard
     * 
     * @return value
     */
    public PassengerTypePNRB getNameType() {
        return nameType;
    }

    /** 
     * Set the 'nameType' attribute value. I = Infant, S = Standard
     * 
     * @param nameType
     */
    public void setNameType(PassengerTypePNRB nameType) {
        this.nameType = nameType;
    }

    /** 
     * Get the 'passengerType' attribute value.
     * 
     * @return value
     */
    public String getPassengerType() {
        return passengerType;
    }

    /** 
     * Set the 'passengerType' attribute value.
     * 
     * @param passengerType
     */
    public void setPassengerType(String passengerType) {
        this.passengerType = passengerType;
    }

    /** 
     * Get the 'referenceNumber' attribute value.
     * 
     * @return value
     */
    public String getReferenceNumber() {
        return referenceNumber;
    }

    /** 
     * Set the 'referenceNumber' attribute value.
     * 
     * @param referenceNumber
     */
    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    /** 
     * Get the 'nameId' attribute value. Name id. Ex."02.02"
     * 
     * @return value
     */
    public String getNameId() {
        return nameId;
    }

    /** 
     * Set the 'nameId' attribute value. Name id. Ex."02.02"
     * 
     * @param nameId
     */
    public void setNameId(String nameId) {
        this.nameId = nameId;
    }

    /** 
     * Get the 'nameAssocId' attribute value.
     * 
     * @return value
     */
    public String getNameAssocId() {
        return nameAssocId;
    }

    /** 
     * Set the 'nameAssocId' attribute value.
     * 
     * @param nameAssocId
     */
    public void setNameAssocId(String nameAssocId) {
        this.nameAssocId = nameAssocId;
    }

    /** 
     * Get the 'withInfant' attribute value. "with infant" True/False indicator. Ex. "TRUE"
     * 
     * @return value
     */
    public Boolean getWithInfant() {
        return withInfant;
    }

    /** 
     * Set the 'withInfant' attribute value. "with infant" True/False indicator. Ex. "TRUE"
     * 
     * @param withInfant
     */
    public void setWithInfant(Boolean withInfant) {
        this.withInfant = withInfant;
    }

    /** 
     * Get the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @return value
     */
    public OperationTypePNRB getOp() {
        return op;
    }

    /** 
     * Set the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @param op
     */
    public void setOp(OperationTypePNRB op) {
        this.op = op;
    }

    /** 
     * Get the 'lang' attribute value.
     * 
     * @return value
     */
    public String getLang() {
        return lang;
    }

    /** 
     * Set the 'lang' attribute value.
     * 
     * @param lang
     */
    public void setLang(String lang) {
        this.lang = lang;
    }

    /** 
     * Get the 'elementId' attribute value.
     * 
     * @return value
     */
    public String getElementId() {
        return elementId;
    }

    /** 
     * Set the 'elementId' attribute value.
     * 
     * @param elementId
     */
    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    /** 
     * Get the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                      in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                  
     * 
     * @return value
     */
    public String getRPH() {
        return RPH;
    }

    /** 
     * Set the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                      in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                  
     * 
     * @param RPH
     */
    public void setRPH(String RPH) {
        this.RPH = RPH;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AncillaryServices" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:AncillaryServices.PNRB" name="AncillaryService" minOccurs="0" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AncillaryServices implements Serializable
    {
        private List<AncillaryServicesPNRB> ancillaryServiceList = new ArrayList<AncillaryServicesPNRB>();

        /** 
         * Get the list of 'AncillaryService' element items.
         * 
         * @return list
         */
        public List<AncillaryServicesPNRB> getAncillaryServiceList() {
            return ancillaryServiceList;
        }

        /** 
         * Set the list of 'AncillaryService' element items.
         * 
         * @param list
         */
        public void setAncillaryServiceList(List<AncillaryServicesPNRB> list) {
            ancillaryServiceList = list;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OSI" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:OSIType" name="OSIMessage" minOccurs="0" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OSI implements Serializable
    {
        private List<OSIType> OSIMessageList = new ArrayList<OSIType>();

        /** 
         * Get the list of 'OSIMessage' element items.
         * 
         * @return list
         */
        public List<OSIType> getOSIMessageList() {
            return OSIMessageList;
        }

        /** 
         * Set the list of 'OSIMessage' element items.
         * 
         * @param list
         */
        public void setOSIMessageList(List<OSIType> list) {
            OSIMessageList = list;
        }
    }
}
