
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * PayInfo contains data in the PAY field in the PNR
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PayInfo.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="PersonName" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class PersonName -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="fieldTagID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="linkSubkey"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="sectionID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="securityIndicator"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="id"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PayInfoPNRB implements Serializable
{
    private List<PersonName> personNameList = new ArrayList<PersonName>();
    private String text;
    private String fieldTagID;
    private String linkSubkey;
    private String sectionID;
    private String securityIndicator;
    private String id;

    /** 
     * Get the list of 'PersonName' element items.
     * 
     * @return list
     */
    public List<PersonName> getPersonNameList() {
        return personNameList;
    }

    /** 
     * Set the list of 'PersonName' element items.
     * 
     * @param list
     */
    public void setPersonNameList(List<PersonName> list) {
        personNameList = list;
    }

    /** 
     * Get the 'Text' element value. Credit card number
     * 
     * @return value
     */
    public String getText() {
        return text;
    }

    /** 
     * Set the 'Text' element value. Credit card number
     * 
     * @param text
     */
    public void setText(String text) {
        this.text = text;
    }

    /** 
     * Get the 'fieldTagID' attribute value. Optional field Example: CC_Code
     * 
     * @return value
     */
    public String getFieldTagID() {
        return fieldTagID;
    }

    /** 
     * Set the 'fieldTagID' attribute value. Optional field Example: CC_Code
     * 
     * @param fieldTagID
     */
    public void setFieldTagID(String fieldTagID) {
        this.fieldTagID = fieldTagID;
    }

    /** 
     * Get the 'linkSubkey' attribute value.
     * 
     * @return value
     */
    public String getLinkSubkey() {
        return linkSubkey;
    }

    /** 
     * Set the 'linkSubkey' attribute value.
     * 
     * @param linkSubkey
     */
    public void setLinkSubkey(String linkSubkey) {
        this.linkSubkey = linkSubkey;
    }

    /** 
     * Get the 'sectionID' attribute value.
     * 
     * @return value
     */
    public String getSectionID() {
        return sectionID;
    }

    /** 
     * Set the 'sectionID' attribute value.
     * 
     * @param sectionID
     */
    public void setSectionID(String sectionID) {
        this.sectionID = sectionID;
    }

    /** 
     * Get the 'securityIndicator' attribute value. Holds Security indicator details Example: E for Encryption , M for
                      Masking, B for Both, X for Inhibit Display
                  
     * 
     * @return value
     */
    public String getSecurityIndicator() {
        return securityIndicator;
    }

    /** 
     * Set the 'securityIndicator' attribute value. Holds Security indicator details Example: E for Encryption , M for
                      Masking, B for Both, X for Inhibit Display
                  
     * 
     * @param securityIndicator
     */
    public void setSecurityIndicator(String securityIndicator) {
        this.securityIndicator = securityIndicator;
    }

    /** 
     * Get the 'id' attribute value.
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value.
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PersonName" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:string" use="optional" name="nameNumber"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PersonName implements Serializable
    {
        private String string;
        private String nameNumber;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'nameNumber' attribute value. NameNumber is used to return the passenger name
                                            number associated with the particular passenger
                                        
         * 
         * @return value
         */
        public String getNameNumber() {
            return nameNumber;
        }

        /** 
         * Set the 'nameNumber' attribute value. NameNumber is used to return the passenger name
                                            number associated with the particular passenger
                                        
         * 
         * @param nameNumber
         */
        public void setNameNumber(String nameNumber) {
            this.nameNumber = nameNumber;
        }
    }
}
