
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * each phone field can have up to 62 chars

 The
 formats for phone numbers are:

 * add phone contact

 9(area code)(phone
 number)-(code)
 9212-123-1234-A

 * insert phone field as a specific line

 9(line # to insert at)/(area
 code)-(prefix)-(number)-(phone location)

 * insert phone field and
 make it the first number in the
 field

 90/(area
 code)-(prefix)-(number)-(phone location)
 90/202-675-6543-A

 *
 add phone
 contact and include city code that is
 outside of your area

 9/(city
 code)(area code)(phone number)-(code)
 9/BOS616-123-1234-A

 *
 change
 phone field to new number

 9(line #)¤(area
 code)-(prefix)-(number)-(phone location)
 92¤415-991-0220-A

 * change
 city code in phone field

 9(line #)¤(new city code) 92¤LON

 * delete
 specific line number in the phone field

 9(line #)¤ 92¤

 * delete a
 range of phone fields

 9(first line # in range)-(last line # in
 range)¤ 92-3¤

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PhoneNumber.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:PhoneLocationType.PNRB" name="Location" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TJRCityCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CityCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Extension" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Number" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="id"/>
 *   &lt;xs:attribute type="ns:OperationType.PNRB" name="op"/>
 *   &lt;xs:attribute type="xs:integer" name="index"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="elementId"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PhoneNumberPNRB implements Serializable
{
    private PhoneLocationTypePNRB location;
    private String TJRCityCode;
    private String cityCode;
    private String extension;
    private String number;
    private String id;
    private OperationTypePNRB op;
    private BigInteger index;
    private String elementId;
    private String RPH;

    /** 
     * Get the 'Location' element value. A = Agency, H = Home, B = Business, C = Cell, M
                          = Mobile, F = Fax, HTL = Hotel
                      
     * 
     * @return value
     */
    public PhoneLocationTypePNRB getLocation() {
        return location;
    }

    /** 
     * Set the 'Location' element value. A = Agency, H = Home, B = Business, C = Cell, M
                          = Mobile, F = Fax, HTL = Hotel
                      
     * 
     * @param location
     */
    public void setLocation(PhoneLocationTypePNRB location) {
        this.location = location;
    }

    /** 
     * Get the 'TJRCityCode' element value.
     * 
     * @return value
     */
    public String getTJRCityCode() {
        return TJRCityCode;
    }

    /** 
     * Set the 'TJRCityCode' element value.
     * 
     * @param TJRCityCode
     */
    public void setTJRCityCode(String TJRCityCode) {
        this.TJRCityCode = TJRCityCode;
    }

    /** 
     * Get the 'CityCode' element value. City Code associated with the phone nunber. Ex."LON"
     * 
     * @return value
     */
    public String getCityCode() {
        return cityCode;
    }

    /** 
     * Set the 'CityCode' element value. City Code associated with the phone nunber. Ex."LON"
     * 
     * @param cityCode
     */
    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    /** 
     * Get the 'Extension' element value. max 5 chars
     * 
     * @return value
     */
    public String getExtension() {
        return extension;
    }

    /** 
     * Set the 'Extension' element value. max 5 chars
     * 
     * @param extension
     */
    public void setExtension(String extension) {
        this.extension = extension;
    }

    /** 
     * Get the 'Number' element value.
     * 
     * @return value
     */
    public String getNumber() {
        return number;
    }

    /** 
     * Set the 'Number' element value.
     * 
     * @param number
     */
    public void setNumber(String number) {
        this.number = number;
    }

    /** 
     * Get the 'id' attribute value.
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value.
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @return value
     */
    public OperationTypePNRB getOp() {
        return op;
    }

    /** 
     * Set the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @param op
     */
    public void setOp(OperationTypePNRB op) {
        this.op = op;
    }

    /** 
     * Get the 'index' attribute value.
     * 
     * @return value
     */
    public BigInteger getIndex() {
        return index;
    }

    /** 
     * Set the 'index' attribute value.
     * 
     * @param index
     */
    public void setIndex(BigInteger index) {
        this.index = index;
    }

    /** 
     * Get the 'elementId' attribute value.
     * 
     * @return value
     */
    public String getElementId() {
        return elementId;
    }

    /** 
     * Set the 'elementId' attribute value.
     * 
     * @param elementId
     */
    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    /** 
     * Get the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                      in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                  
     * 
     * @return value
     */
    public String getRPH() {
        return RPH;
    }

    /** 
     * Set the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                      in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                  
     * 
     * @param RPH
     */
    public void setRPH(String RPH) {
        this.RPH = RPH;
    }
}
