
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.math.BigInteger;
import java.sql.Date;

/** 
 * * add future queue placement in remarks field

 5Q-(PCC)(queue #)/(prefatory instruction number)
 5Q-B4T03AUG55/11

 NOTE: max of 14 5Q- entries in one PNR. Cannot enter
 remarks
 beginning with 5QQ.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="QueueRemark.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="PseudoCityCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:integer" name="QueueNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:date" name="FutureDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:integer" name="InstructionNumber" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:integer" name="index"/>
 *   &lt;xs:attribute type="xs:string" name="id"/>
 *   &lt;xs:attribute type="ns:OperationType.PNRB" name="op"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class QueueRemarkPNRB implements Serializable
{
    private String pseudoCityCode;
    private BigInteger queueNumber;
    private Date futureDate;
    private BigInteger instructionNumber;
    private BigInteger index;
    private String id;
    private OperationTypePNRB op;
    private String RPH;

    /** 
     * Get the 'PseudoCityCode' element value.
     * 
     * @return value
     */
    public String getPseudoCityCode() {
        return pseudoCityCode;
    }

    /** 
     * Set the 'PseudoCityCode' element value.
     * 
     * @param pseudoCityCode
     */
    public void setPseudoCityCode(String pseudoCityCode) {
        this.pseudoCityCode = pseudoCityCode;
    }

    /** 
     * Get the 'QueueNumber' element value.
     * 
     * @return value
     */
    public BigInteger getQueueNumber() {
        return queueNumber;
    }

    /** 
     * Set the 'QueueNumber' element value.
     * 
     * @param queueNumber
     */
    public void setQueueNumber(BigInteger queueNumber) {
        this.queueNumber = queueNumber;
    }

    /** 
     * Get the 'FutureDate' element value.
     * 
     * @return value
     */
    public Date getFutureDate() {
        return futureDate;
    }

    /** 
     * Set the 'FutureDate' element value.
     * 
     * @param futureDate
     */
    public void setFutureDate(Date futureDate) {
        this.futureDate = futureDate;
    }

    /** 
     * Get the 'InstructionNumber' element value. prefatory instruction number
     * 
     * @return value
     */
    public BigInteger getInstructionNumber() {
        return instructionNumber;
    }

    /** 
     * Set the 'InstructionNumber' element value. prefatory instruction number
     * 
     * @param instructionNumber
     */
    public void setInstructionNumber(BigInteger instructionNumber) {
        this.instructionNumber = instructionNumber;
    }

    /** 
     * Get the 'index' attribute value.
     * 
     * @return value
     */
    public BigInteger getIndex() {
        return index;
    }

    /** 
     * Set the 'index' attribute value.
     * 
     * @param index
     */
    public void setIndex(BigInteger index) {
        this.index = index;
    }

    /** 
     * Get the 'id' attribute value.
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value.
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @return value
     */
    public OperationTypePNRB getOp() {
        return op;
    }

    /** 
     * Set the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @param op
     */
    public void setOp(OperationTypePNRB op) {
        this.op = op;
    }

    /** 
     * Get the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                      in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                  
     * 
     * @return value
     */
    public String getRPH() {
        return RPH;
    }

    /** 
     * Set the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                      in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                  
     * 
     * @param RPH
     */
    public void setRPH(String RPH) {
        this.RPH = RPH;
    }
}
