
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Each remark line can contain a max of 70 chars

 The
 entire remarks field can contain a max of 32,767
 chars.

 Remarks
 formats:

 * add remark

 5(free text) 5JASON AGE 6YRS

 * add more than one
 line of remark in one entry

 5(free text)§5(free text) 5CHECK
 PASSPORTS§5CHECK
 ADDRESS FIELD

 * add historical remarks to store info
 in history

 5H-(free text) 5H-FARE QUOTED 690.00

 * enter alpha coded
 remarks

 5(letter)‡(free text) 5H‡HOTEL NEEDED IN SWITZERLAND

 5C‡CALL
 AND MAKE CAR RESERVATIONS ON DEC 23

 * add corporate identification
 number

 5C-CORP(corporate #) 5C-CORPD14569812

 * enter hidden remark

 5HR-(free text) 5HR-XYZ CORP PSGRS RECIEVE FOLLOWING
 DISCOUNTS 5HR-25
 PERCENT OFF ALL CAR RENTALS

 NOTE: max 70 chars after the 5. Total
 size of complete
 remarks field in any PNR is 32.762. To enter
 multiple
 lines use the §

 * modify basic remark

 5(line #)¤(new text)
 59¤YOU MUST BRING YOUR PHOTO ID

 * modify an invoice remark

 5(line
 #)¤.(new text) 52¤.THANKS

 * modify an itinerary remark

 5(line #)¤‡(new
 text) 59¤‡HAVE A GOOD TRIP

 * delete remarks

 5(line #)¤ 53¤

 *delete a
 range of remarks lines

 5(line #)-(line #)¤ 59-12¤

 * delete specific
 remarks lines

 5(line #),(line #)¤ 59,12¤

 NOTE: When you delete
 specific remarks lines, you can
 delete a max of 5 per entry.

 * insert
 a new remark after specified remarks line

 5(line # new text is to
 follow)/(free text) 52/PLEASE
 ALLOW EXTRA TIME DUE TO AIRPORT
 CONSTRUCTION

 * insert a new remark as the first remark in a PNR

 50/(free text) 50/HAVE ADVISED ALL DOCS

 * move and insert specific
 remarks

 5(remark line you want to insert after)//(remark line to
 be
 moved),(remark line to be moved) 57//10,2

 NOTE: the above moves
 remarks 10 and 2 and inserts them
 after remark 7

 * move and insert a
 range of remarks

 5(remark line you want to insert after)//(range of
 remarks) 57//3-5

 * combine a range of remarks and specific remarks
 lines

 5(remark line you want to insert after)//(range of
 remarks),(specific remark line) 57//3-5,9

 * reverse order of remarks
 - example from 1 through 10

 50//(remark lines in descending order)
 50//10,9,8,7,6,5,4,3,2,1

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Remark.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:RemarkLines.PNRB" name="RemarkLines" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:integer" name="index"/>
 *   &lt;xs:attribute type="xs:string" name="id"/>
 *   &lt;xs:attribute type="ns:RemarkType.PNRB" name="type"/>
 *   &lt;xs:attribute type="ns:OperationType.PNRB" name="op"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="code"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="segmentNumber"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="elementId"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RemarkPNRB implements Serializable
{
    private RemarkLinesPNRB remarkLines;
    private BigInteger index;
    private String id;
    private RemarkTypePNRB type;
    private OperationTypePNRB op;
    private String code;
    private String segmentNumber;
    private String elementId;
    private String RPH;

    /** 
     * Get the 'RemarkLines' element value.
     * 
     * @return value
     */
    public RemarkLinesPNRB getRemarkLines() {
        return remarkLines;
    }

    /** 
     * Set the 'RemarkLines' element value.
     * 
     * @param remarkLines
     */
    public void setRemarkLines(RemarkLinesPNRB remarkLines) {
        this.remarkLines = remarkLines;
    }

    /** 
     * Get the 'index' attribute value.
     * 
     * @return value
     */
    public BigInteger getIndex() {
        return index;
    }

    /** 
     * Set the 'index' attribute value.
     * 
     * @param index
     */
    public void setIndex(BigInteger index) {
        this.index = index;
    }

    /** 
     * Get the 'id' attribute value.
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value.
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'type' attribute value.
     * 
     * @return value
     */
    public RemarkTypePNRB getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value.
     * 
     * @param type
     */
    public void setType(RemarkTypePNRB type) {
        this.type = type;
    }

    /** 
     * Get the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @return value
     */
    public OperationTypePNRB getOp() {
        return op;
    }

    /** 
     * Set the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @param op
     */
    public void setOp(OperationTypePNRB op) {
        this.op = op;
    }

    /** 
     * Get the 'code' attribute value.
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'code' attribute value.
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }

    /** 
     * Get the 'segmentNumber' attribute value. "segmentNumber" is used to return the segment number associated with the particular
                      remark line if applicable
                  
     * 
     * @return value
     */
    public String getSegmentNumber() {
        return segmentNumber;
    }

    /** 
     * Set the 'segmentNumber' attribute value. "segmentNumber" is used to return the segment number associated with the particular
                      remark line if applicable
                  
     * 
     * @param segmentNumber
     */
    public void setSegmentNumber(String segmentNumber) {
        this.segmentNumber = segmentNumber;
    }

    /** 
     * Get the 'elementId' attribute value.
     * 
     * @return value
     */
    public String getElementId() {
        return elementId;
    }

    /** 
     * Set the 'elementId' attribute value.
     * 
     * @param elementId
     */
    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    /** 
     * Get the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                      in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                  
     * 
     * @return value
     */
    public String getRPH() {
        return RPH;
    }

    /** 
     * Set the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                      in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                  
     * 
     * @param RPH
     */
    public void setRPH(String RPH) {
        this.RPH = RPH;
    }
}
