
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Information on the rates associated with this vehicle. Rate information can include the
 distance and the base rental cost, along with information on the various factors that may influence this
 rate.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RentalRate.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="RateCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="RateGuaranteedQuoted" minOccurs="0"/>
 *     &lt;xs:element name="RentalRateQuote" minOccurs="0" maxOccurs="1">
 *       &lt;!-- Reference to inner class RentalRateQuote -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="RateChanged" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="ExtraMileageCharge" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="MileageCurrencyCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:integer" name="MileageDecimalPlaces" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="MileageKilometersCode" minOccurs="0"/>
 *     &lt;xs:element type="ns:VehicleCharges.PNRB" name="VehicleCharges" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="RateQualifierCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="BillingNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="BillingReference" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PromotionalCoupon" minOccurs="0"/>
 *     &lt;xs:element name="Client" minOccurs="0">
 *       &lt;!-- Reference to inner class Client -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Corporate" minOccurs="0">
 *       &lt;!-- Reference to inner class Corporate -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="CustomerLoyalty" minOccurs="0">
 *       &lt;!-- Reference to inner class CustomerLoyalty -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="InvoiceRemarks" minOccurs="0">
 *       &lt;!-- Reference to inner class InvoiceRemarks -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Remarks" minOccurs="0">
 *       &lt;!-- Reference to inner class Remarks -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="ReserveUnderName" minOccurs="0"/>
 *     &lt;xs:element name="ServiceInformation" minOccurs="0">
 *       &lt;!-- Reference to inner class ServiceInformation -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="TourCode" minOccurs="0">
 *       &lt;!-- Reference to inner class TourCode -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="VehicleTypes" minOccurs="0">
 *       &lt;!-- Reference to inner class VehicleTypes -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Voucher" minOccurs="0">
 *       &lt;!-- Reference to inner class Voucher -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RentalRatePNRB implements Serializable
{
    private String rateCode;
    private String rateGuaranteedQuoted;
    private RentalRateQuote rentalRateQuote;
    private String rateChanged;
    private BigDecimal extraMileageCharge;
    private String mileageCurrencyCode;
    private BigInteger mileageDecimalPlaces;
    private String mileageKilometersCode;
    private VehicleChargesPNRB vehicleCharges;
    private String rateQualifierCode;
    private String billingNumber;
    private String billingReference;
    private String promotionalCoupon;
    private Client client;
    private Corporate corporate;
    private CustomerLoyalty customerLoyalty;
    private InvoiceRemarks invoiceRemarks;
    private Remarks remarks;
    private String reserveUnderName;
    private ServiceInformation serviceInformation;
    private TourCode tourCode;
    private VehicleTypes vehicleTypes;
    private Voucher voucher;

    /** 
     * Get the 'RateCode' element value. rate code for the car
     * 
     * @return value
     */
    public String getRateCode() {
        return rateCode;
    }

    /** 
     * Set the 'RateCode' element value. rate code for the car
     * 
     * @param rateCode
     */
    public void setRateCode(String rateCode) {
        this.rateCode = rateCode;
    }

    /** 
     * Get the 'RateGuaranteedQuoted' element value. is rate guaranteed
     * 
     * @return value
     */
    public String getRateGuaranteedQuoted() {
        return rateGuaranteedQuoted;
    }

    /** 
     * Set the 'RateGuaranteedQuoted' element value. is rate guaranteed
     * 
     * @param rateGuaranteedQuoted
     */
    public void setRateGuaranteedQuoted(String rateGuaranteedQuoted) {
        this.rateGuaranteedQuoted = rateGuaranteedQuoted;
    }

    /** 
     * Get the 'RentalRateQuote' element value.
     * 
     * @return value
     */
    public RentalRateQuote getRentalRateQuote() {
        return rentalRateQuote;
    }

    /** 
     * Set the 'RentalRateQuote' element value.
     * 
     * @param rentalRateQuote
     */
    public void setRentalRateQuote(RentalRateQuote rentalRateQuote) {
        this.rentalRateQuote = rentalRateQuote;
    }

    /** 
     * Get the 'RateChanged' element value. has rate changed
     * 
     * @return value
     */
    public String getRateChanged() {
        return rateChanged;
    }

    /** 
     * Set the 'RateChanged' element value. has rate changed
     * 
     * @param rateChanged
     */
    public void setRateChanged(String rateChanged) {
        this.rateChanged = rateChanged;
    }

    /** 
     * Get the 'ExtraMileageCharge' element value. amount of extra mileage charge
     * 
     * @return value
     */
    public BigDecimal getExtraMileageCharge() {
        return extraMileageCharge;
    }

    /** 
     * Set the 'ExtraMileageCharge' element value. amount of extra mileage charge
     * 
     * @param extraMileageCharge
     */
    public void setExtraMileageCharge(BigDecimal extraMileageCharge) {
        this.extraMileageCharge = extraMileageCharge;
    }

    /** 
     * Get the 'MileageCurrencyCode' element value. currency code for extra mileage charge
     * 
     * @return value
     */
    public String getMileageCurrencyCode() {
        return mileageCurrencyCode;
    }

    /** 
     * Set the 'MileageCurrencyCode' element value. currency code for extra mileage charge
     * 
     * @param mileageCurrencyCode
     */
    public void setMileageCurrencyCode(String mileageCurrencyCode) {
        this.mileageCurrencyCode = mileageCurrencyCode;
    }

    /** 
     * Get the 'MileageDecimalPlaces' element value. number of decimal points in extra mileage charge
     * 
     * @return value
     */
    public BigInteger getMileageDecimalPlaces() {
        return mileageDecimalPlaces;
    }

    /** 
     * Set the 'MileageDecimalPlaces' element value. number of decimal points in extra mileage charge
     * 
     * @param mileageDecimalPlaces
     */
    public void setMileageDecimalPlaces(BigInteger mileageDecimalPlaces) {
        this.mileageDecimalPlaces = mileageDecimalPlaces;
    }

    /** 
     * Get the 'MileageKilometersCode' element value. is extra "mileage" quoted in kilometers
     * 
     * @return value
     */
    public String getMileageKilometersCode() {
        return mileageKilometersCode;
    }

    /** 
     * Set the 'MileageKilometersCode' element value. is extra "mileage" quoted in kilometers
     * 
     * @param mileageKilometersCode
     */
    public void setMileageKilometersCode(String mileageKilometersCode) {
        this.mileageKilometersCode = mileageKilometersCode;
    }

    /** 
     * Get the 'VehicleCharges' element value.
     * 
     * @return value
     */
    public VehicleChargesPNRB getVehicleCharges() {
        return vehicleCharges;
    }

    /** 
     * Set the 'VehicleCharges' element value.
     * 
     * @param vehicleCharges
     */
    public void setVehicleCharges(VehicleChargesPNRB vehicleCharges) {
        this.vehicleCharges = vehicleCharges;
    }

    /** 
     * Get the 'RateQualifierCode' element value. Indicates the type of rates applicable to the customer, along with any discount
                          number or promotional codes that affect the quoted rate.
                      The RateQualifierCoreType complex type defines the rate information that is
                          common to all transactions. Such information may include rate codes, rate type, promotional
                          codes, etc. This information may be used to determine the rate that is made available.
                      
     * 
     * @return value
     */
    public String getRateQualifierCode() {
        return rateQualifierCode;
    }

    /** 
     * Set the 'RateQualifierCode' element value. Indicates the type of rates applicable to the customer, along with any discount
                          number or promotional codes that affect the quoted rate.
                      The RateQualifierCoreType complex type defines the rate information that is
                          common to all transactions. Such information may include rate codes, rate type, promotional
                          codes, etc. This information may be used to determine the rate that is made available.
                      
     * 
     * @param rateQualifierCode
     */
    public void setRateQualifierCode(String rateQualifierCode) {
        this.rateQualifierCode = rateQualifierCode;
    }

    /** 
     * Get the 'BillingNumber' element value. The RateQualifierCoreType complex type defines the rate information that is
                          common to all transactions. Such information may include rate codes, rate type, promotional
                          codes, etc. This information may be used to determine the rate that is made available.
                          prepaid billing number
                      
     * 
     * @return value
     */
    public String getBillingNumber() {
        return billingNumber;
    }

    /** 
     * Set the 'BillingNumber' element value. The RateQualifierCoreType complex type defines the rate information that is
                          common to all transactions. Such information may include rate codes, rate type, promotional
                          codes, etc. This information may be used to determine the rate that is made available.
                          prepaid billing number
                      
     * 
     * @param billingNumber
     */
    public void setBillingNumber(String billingNumber) {
        this.billingNumber = billingNumber;
    }

    /** 
     * Get the 'BillingReference' element value. agency billing reference number
     * 
     * @return value
     */
    public String getBillingReference() {
        return billingReference;
    }

    /** 
     * Set the 'BillingReference' element value. agency billing reference number
     * 
     * @param billingReference
     */
    public void setBillingReference(String billingReference) {
        this.billingReference = billingReference;
    }

    /** 
     * Get the 'PromotionalCoupon' element value. promotional coupon number
     * 
     * @return value
     */
    public String getPromotionalCoupon() {
        return promotionalCoupon;
    }

    /** 
     * Set the 'PromotionalCoupon' element value. promotional coupon number
     * 
     * @param promotionalCoupon
     */
    public void setPromotionalCoupon(String promotionalCoupon) {
        this.promotionalCoupon = promotionalCoupon;
    }

    /** 
     * Get the 'Client' element value.
     * 
     * @return value
     */
    public Client getClient() {
        return client;
    }

    /** 
     * Set the 'Client' element value.
     * 
     * @param client
     */
    public void setClient(Client client) {
        this.client = client;
    }

    /** 
     * Get the 'Corporate' element value.
     * 
     * @return value
     */
    public Corporate getCorporate() {
        return corporate;
    }

    /** 
     * Set the 'Corporate' element value.
     * 
     * @param corporate
     */
    public void setCorporate(Corporate corporate) {
        this.corporate = corporate;
    }

    /** 
     * Get the 'CustomerLoyalty' element value.
     * 
     * @return value
     */
    public CustomerLoyalty getCustomerLoyalty() {
        return customerLoyalty;
    }

    /** 
     * Set the 'CustomerLoyalty' element value.
     * 
     * @param customerLoyalty
     */
    public void setCustomerLoyalty(CustomerLoyalty customerLoyalty) {
        this.customerLoyalty = customerLoyalty;
    }

    /** 
     * Get the 'InvoiceRemarks' element value.
     * 
     * @return value
     */
    public InvoiceRemarks getInvoiceRemarks() {
        return invoiceRemarks;
    }

    /** 
     * Set the 'InvoiceRemarks' element value.
     * 
     * @param invoiceRemarks
     */
    public void setInvoiceRemarks(InvoiceRemarks invoiceRemarks) {
        this.invoiceRemarks = invoiceRemarks;
    }

    /** 
     * Get the 'Remarks' element value.
     * 
     * @return value
     */
    public Remarks getRemarks() {
        return remarks;
    }

    /** 
     * Set the 'Remarks' element value.
     * 
     * @param remarks
     */
    public void setRemarks(Remarks remarks) {
        this.remarks = remarks;
    }

    /** 
     * Get the 'ReserveUnderName' element value. "ReserveUnderName" is used to return the name of the customer associated with the vehicle reservation.
     * 
     * @return value
     */
    public String getReserveUnderName() {
        return reserveUnderName;
    }

    /** 
     * Set the 'ReserveUnderName' element value. "ReserveUnderName" is used to return the name of the customer associated with the vehicle reservation.
     * 
     * @param reserveUnderName
     */
    public void setReserveUnderName(String reserveUnderName) {
        this.reserveUnderName = reserveUnderName;
    }

    /** 
     * Get the 'ServiceInformation' element value.
     * 
     * @return value
     */
    public ServiceInformation getServiceInformation() {
        return serviceInformation;
    }

    /** 
     * Set the 'ServiceInformation' element value.
     * 
     * @param serviceInformation
     */
    public void setServiceInformation(ServiceInformation serviceInformation) {
        this.serviceInformation = serviceInformation;
    }

    /** 
     * Get the 'TourCode' element value.
     * 
     * @return value
     */
    public TourCode getTourCode() {
        return tourCode;
    }

    /** 
     * Set the 'TourCode' element value.
     * 
     * @param tourCode
     */
    public void setTourCode(TourCode tourCode) {
        this.tourCode = tourCode;
    }

    /** 
     * Get the 'VehicleTypes' element value.
     * 
     * @return value
     */
    public VehicleTypes getVehicleTypes() {
        return vehicleTypes;
    }

    /** 
     * Set the 'VehicleTypes' element value.
     * 
     * @param vehicleTypes
     */
    public void setVehicleTypes(VehicleTypes vehicleTypes) {
        this.vehicleTypes = vehicleTypes;
    }

    /** 
     * Get the 'Voucher' element value.
     * 
     * @return value
     */
    public Voucher getVoucher() {
        return voucher;
    }

    /** 
     * Set the 'Voucher' element value.
     * 
     * @param voucher
     */
    public void setVoucher(Voucher voucher) {
        this.voucher = voucher;
    }
    /** 
     * Information related to rental rate quote
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RentalRateQuote" minOccurs="0" maxOccurs="1">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="optional" name="changed"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="guaranteeQuoted"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class RentalRateQuote implements Serializable
    {
        private String changed;
        private String guaranteeQuoted;

        /** 
         * Get the 'changed' attribute value. C or S to indicate if the quote changed
         * 
         * @return value
         */
        public String getChanged() {
            return changed;
        }

        /** 
         * Set the 'changed' attribute value. C or S to indicate if the quote changed
         * 
         * @param changed
         */
        public void setChanged(String changed) {
            this.changed = changed;
        }

        /** 
         * Get the 'guaranteeQuoted' attribute value. G indicates a quarantee was issued.
         * 
         * @return value
         */
        public String getGuaranteeQuoted() {
            return guaranteeQuoted;
        }

        /** 
         * Set the 'guaranteeQuoted' attribute value. G indicates a quarantee was issued.
         * 
         * @param guaranteeQuoted
         */
        public void setGuaranteeQuoted(String guaranteeQuoted) {
            this.guaranteeQuoted = guaranteeQuoted;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Client" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="id" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Client implements Serializable
    {
        private String id;

        /** 
         * Get the 'id' element value. "id" is used to return the client ID associated with the vehicle reservation if applicable.
         * 
         * @return value
         */
        public String getId() {
            return id;
        }

        /** 
         * Set the 'id' element value. "id" is used to return the client ID associated with the vehicle reservation if applicable.
         * 
         * @param id
         */
        public void setId(String id) {
            this.id = id;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Corporate" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="id" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Corporate implements Serializable
    {
        private String id;

        /** 
         * Get the 'id' element value. "id" is used to return the corporate ID associated with the vehicle reservation if applicable.
         * 
         * @return value
         */
        public String getId() {
            return id;
        }

        /** 
         * Set the 'id' element value. "id" is used to return the corporate ID associated with the vehicle reservation if applicable.
         * 
         * @param id
         */
        public void setId(String id) {
            this.id = id;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CustomerLoyalty" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="optional" name="membershipID"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class CustomerLoyalty implements Serializable
    {
        private String membershipID;

        /** 
         * Get the 'membershipID' attribute value. "MembershipID" is used to return the frequent flyer number associated with the vehicle reservation if applicable.
         * 
         * @return value
         */
        public String getMembershipID() {
            return membershipID;
        }

        /** 
         * Set the 'membershipID' attribute value. "MembershipID" is used to return the frequent flyer number associated with the vehicle reservation if applicable.
         * 
         * @param membershipID
         */
        public void setMembershipID(String membershipID) {
            this.membershipID = membershipID;
        }
    }
    /** 
     * invoice related remarks
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InvoiceRemarks" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class InvoiceRemarks implements Serializable
    {
        private List<String> textList = new ArrayList<String>();

        /** 
         * Get the list of 'Text' element items.
         * 
         * @return list
         */
        public List<String> getTextList() {
            return textList;
        }

        /** 
         * Set the list of 'Text' element items.
         * 
         * @param list
         */
        public void setTextList(List<String> list) {
            textList = list;
        }
    }
    /** 
     * additional remarks
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Remarks" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Remarks implements Serializable
    {
        private List<String> textList = new ArrayList<String>();

        /** 
         * Get the list of 'Text' element items.
         * 
         * @return list
         */
        public List<String> getTextList() {
            return textList;
        }

        /** 
         * Set the list of 'Text' element items.
         * 
         * @param list
         */
        public void setTextList(List<String> list) {
            textList = list;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceInformation" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ServiceInformation implements Serializable
    {
        private String text;

        /** 
         * Get the 'Text' element value. "Text" is used to return service-related information.
         * 
         * @return value
         */
        public String getText() {
            return text;
        }

        /** 
         * Set the 'Text' element value. "Text" is used to return service-related information.
         * 
         * @param text
         */
        public void setText(String text) {
            this.text = text;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TourCode" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TourCode implements Serializable
    {
        private String text;

        /** 
         * Get the 'Text' element value. "Text" is used to return tour code-related information.
         * 
         * @return value
         */
        public String getText() {
            return text;
        }

        /** 
         * Set the 'Text' element value. "Text" is used to return tour code-related information.
         * 
         * @param text
         */
        public void setText(String text) {
            this.text = text;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VehicleTypes" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="VehType" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class VehicleTypes implements Serializable
    {
        private String vehType;

        /** 
         * Get the 'VehType' element value. "VehType" is used to return the vehicle type associated with the vehicle reservation.
         * 
         * @return value
         */
        public String getVehType() {
            return vehType;
        }

        /** 
         * Set the 'VehType' element value. "VehType" is used to return the vehicle type associated with the vehicle reservation.
         * 
         * @param vehType
         */
        public void setVehType(String vehType) {
            this.vehType = vehType;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Voucher" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" name="billingNumber"/>
     *     &lt;xs:attribute type="xs:string" name="format"/>
     *     &lt;xs:attribute type="xs:string" name="id"/>
     *     &lt;xs:attribute type="xs:string" name="type"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Voucher implements Serializable
    {
        private String billingNumber;
        private String format;
        private String id;
        private String type;

        /** 
         * Get the 'billingNumber' attribute value. "BillingNumber" used to return the voucher billing number associated with the vehicle reservation if applicable.
         * 
         * @return value
         */
        public String getBillingNumber() {
            return billingNumber;
        }

        /** 
         * Set the 'billingNumber' attribute value. "BillingNumber" used to return the voucher billing number associated with the vehicle reservation if applicable.
         * 
         * @param billingNumber
         */
        public void setBillingNumber(String billingNumber) {
            this.billingNumber = billingNumber;
        }

        /** 
         * Get the 'format' attribute value. "Format" is used to return the voucher format associated with the vehicle reservation if applicable.
         * 
         * @return value
         */
        public String getFormat() {
            return format;
        }

        /** 
         * Set the 'format' attribute value. "Format" is used to return the voucher format associated with the vehicle reservation if applicable.
         * 
         * @param format
         */
        public void setFormat(String format) {
            this.format = format;
        }

        /** 
         * Get the 'id' attribute value. "id" is used to return the voucher ID associated with the vehicle reservation if applicable.
         * 
         * @return value
         */
        public String getId() {
            return id;
        }

        /** 
         * Set the 'id' attribute value. "id" is used to return the voucher ID associated with the vehicle reservation if applicable.
         * 
         * @param id
         */
        public void setId(String id) {
            this.id = id;
        }

        /** 
         * Get the 'type' attribute value. "Type" is used to return the type of voucher associated with the vehicle reservation if applicable.
         * 
         * @return value
         */
        public String getType() {
            return type;
        }

        /** 
         * Set the 'type' attribute value. "Type" is used to return the type of voucher associated with the vehicle reservation if applicable.
         * 
         * @param type
         */
        public void setType(String type) {
            this.type = type;
        }
    }
}
