
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RequestEnumerationType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Stateful"/>
 *     &lt;xs:enumeration value="Stateless"/>
 *     &lt;xs:enumeration value="Payload"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum RequestEnumerationType implements Serializable {
    STATEFUL("Stateful"), STATELESS("Stateless"), PAYLOAD("Payload");
    private final String value;

    private RequestEnumerationType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static RequestEnumerationType convert(String value) {
        for (RequestEnumerationType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
