
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:group xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReservationChoiceGroup">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:PassengerReservation.PNRB" name="PassengerReservation" minOccurs="0"/>
 *     &lt;xs:element type="ns:BSGReservation.PNRB" name="BSGReservation" minOccurs="0"/>
 *   &lt;/xs:choice>
 * &lt;/xs:group>
 * </pre>
 */
public class ReservationChoiceGroup implements Serializable
{
    private int choiceSelect = -1;
    private static final int PASSENGER_RESERVATION_CHOICE = 0;
    private static final int BSG_RESERVATION_CHOICE = 1;
    private PassengerReservationPNRB passengerReservation;
    private BSGReservationPNRB BSGReservation;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if PassengerReservation is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPassengerReservation() {
        return choiceSelect == PASSENGER_RESERVATION_CHOICE;
    }

    /** 
     * Get the 'PassengerReservation' element value.
     * 
     * @return value
     */
    public PassengerReservationPNRB getPassengerReservation() {
        return passengerReservation;
    }

    /** 
     * Set the 'PassengerReservation' element value.
     * 
     * @param passengerReservation
     */
    public void setPassengerReservation(
            PassengerReservationPNRB passengerReservation) {
        setChoiceSelect(PASSENGER_RESERVATION_CHOICE);
        this.passengerReservation = passengerReservation;
    }

    /** 
     * Check if BSGReservation is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifBSGReservation() {
        return choiceSelect == BSG_RESERVATION_CHOICE;
    }

    /** 
     * Get the 'BSGReservation' element value.
     * 
     * @return value
     */
    public BSGReservationPNRB getBSGReservation() {
        return BSGReservation;
    }

    /** 
     * Set the 'BSGReservation' element value.
     * 
     * @param BSGReservation
     */
    public void setBSGReservation(BSGReservationPNRB BSGReservation) {
        setChoiceSelect(BSG_RESERVATION_CHOICE);
        this.BSGReservation = BSGReservation;
    }
}
