
package com.sabre.webservices.pnrbuilder.v119;

import com.sabre.services.res.or.v114.OpenReservationElementsType;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:ns1="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Reservation.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:BookingDetails.PNRB" name="BookingDetails" minOccurs="0"/>
 *     &lt;xs:element type="ns:POS_Type.PNRB" name="POS" minOccurs="0"/>
 *     &lt;xs:group ref="ns:ReservationChoiceGroup"/>
 *     &lt;xs:element type="ns:CV_Score" name="ReservationValueScore" minOccurs="0"/>
 *     &lt;xs:element type="ns:DKNumbers.PNRB" name="DKNumbers" minOccurs="0"/>
 *     &lt;xs:element type="ns:CorporateIDs.PNRB" name="CorporatedIDs" minOccurs="0"/>
 *     &lt;xs:element type="ns:ReceivedFrom.PNRB" name="ReceivedFrom" minOccurs="0"/>
 *     &lt;xs:element type="ns:Addresses.PNRB" name="Addresses" minOccurs="0"/>
 *     &lt;xs:element type="ns:PhoneNumbers.PNRB" name="PhoneNumbers" minOccurs="0"/>
 *     &lt;xs:element type="ns:Remarks.PNRB" name="Remarks" minOccurs="0"/>
 *     &lt;xs:element type="ns:EmailAddresses.PNRB" name="EmailAddresses" minOccurs="0"/>
 *     &lt;xs:element type="ns:AccountingLines.PNRB" name="AccountingLines" minOccurs="0"/>
 *     &lt;xs:element type="ns:DescriptiveBillingInformation.PNRB" name="DescriptiveBillingInformation" minOccurs="0"/>
 *     &lt;xs:element type="ns:PayInfos.PNRB" name="PayInfos" minOccurs="0"/>
 *     &lt;xs:element type="ns:GenericSpecialRequest.PNRB" name="GenericSpecialRequests" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:FileInfo.PNRB" name="FileInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:Actions.PNRB" name="Actions" minOccurs="0"/>
 *     &lt;xs:element type="ns:Profiles.PNRB" name="Profiles" minOccurs="0"/>
 *     &lt;xs:element type="ns:AssociationMatrices.PNRB" name="AssociationMatrices" minOccurs="0"/>
 *     &lt;xs:element name="ReservationExtensions" minOccurs="0">
 *       &lt;!-- Reference to inner class ReservationExtensions -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="History" minOccurs="0">
 *       &lt;!-- Reference to inner class History -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns1:OpenReservationElementsType" name="OpenReservationElements" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:integer" use="optional" name="numberInParty"/>
 *   &lt;xs:attribute type="xs:int" use="optional" name="numberOfInfants"/>
 *   &lt;xs:attribute type="xs:int" use="optional" name="NumberInSegment"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="hostOperatedCodeShare"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="hostMarketedCodeShare"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="isTripPNR"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="isMultiCarrierPlatform"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="isDirectConnectPlatformBooking"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ReservationPNRB implements Serializable
{
    private BookingDetailsPNRB bookingDetails;
    private POSTypePNRB POS;
    private ReservationChoiceGroup reservationChoiceGroup;
    private CVScore reservationValueScore;
    private DKNumbersPNRB DKNumbers;
    private CorporateIDsPNRB corporatedIDs;
    private ReceivedFromPNRB receivedFrom;
    private AddressesPNRB addresses;
    private PhoneNumbersPNRB phoneNumbers;
    private RemarksPNRB remarks;
    private EmailAddressesPNRB emailAddresses;
    private AccountingLinesPNRB accountingLines;
    private DescriptiveBillingInformationPNRB descriptiveBillingInformation;
    private PayInfosPNRB payInfos;
    private List<GenericSpecialRequestPNRB> genericSpecialRequestList = new ArrayList<GenericSpecialRequestPNRB>();
    private FileInfoPNRB fileInfo;
    private ActionsPNRB actions;
    private ProfilesPNRB profiles;
    private AssociationMatricesPNRB associationMatrices;
    private ReservationExtensions reservationExtensions;
    private History history;
    private OpenReservationElementsType openReservationElements;
    private BigInteger numberInParty;
    private Integer numberOfInfants;
    private Integer numberInSegment;
    private Boolean hostOperatedCodeShare;
    private Boolean hostMarketedCodeShare;
    private Boolean isTripPNR;
    private Boolean isMultiCarrierPlatform;
    private Boolean isDirectConnectPlatformBooking;

    /** 
     * Get the 'BookingDetails' element value.
     * 
     * @return value
     */
    public BookingDetailsPNRB getBookingDetails() {
        return bookingDetails;
    }

    /** 
     * Set the 'BookingDetails' element value.
     * 
     * @param bookingDetails
     */
    public void setBookingDetails(BookingDetailsPNRB bookingDetails) {
        this.bookingDetails = bookingDetails;
    }

    /** 
     * Get the 'POS' element value.
     * 
     * @return value
     */
    public POSTypePNRB getPOS() {
        return POS;
    }

    /** 
     * Set the 'POS' element value.
     * 
     * @param POS
     */
    public void setPOS(POSTypePNRB POS) {
        this.POS = POS;
    }

    /** 
     * Get the 'ReservationChoiceGroup' group value.
     * 
     * @return value
     */
    public ReservationChoiceGroup getReservationChoiceGroup() {
        return reservationChoiceGroup;
    }

    /** 
     * Set the 'ReservationChoiceGroup' group value.
     * 
     * @param reservationChoiceGroup
     */
    public void setReservationChoiceGroup(
            ReservationChoiceGroup reservationChoiceGroup) {
        this.reservationChoiceGroup = reservationChoiceGroup;
    }

    /** 
     * Get the 'ReservationValueScore' element value. Reservation value score
     * 
     * @return value
     */
    public CVScore getReservationValueScore() {
        return reservationValueScore;
    }

    /** 
     * Set the 'ReservationValueScore' element value. Reservation value score
     * 
     * @param reservationValueScore
     */
    public void setReservationValueScore(CVScore reservationValueScore) {
        this.reservationValueScore = reservationValueScore;
    }

    /** 
     * Get the 'DKNumbers' element value.
     * 
     * @return value
     */
    public DKNumbersPNRB getDKNumbers() {
        return DKNumbers;
    }

    /** 
     * Set the 'DKNumbers' element value.
     * 
     * @param DKNumbers
     */
    public void setDKNumbers(DKNumbersPNRB DKNumbers) {
        this.DKNumbers = DKNumbers;
    }

    /** 
     * Get the 'CorporatedIDs' element value.
     * 
     * @return value
     */
    public CorporateIDsPNRB getCorporatedIDs() {
        return corporatedIDs;
    }

    /** 
     * Set the 'CorporatedIDs' element value.
     * 
     * @param corporatedIDs
     */
    public void setCorporatedIDs(CorporateIDsPNRB corporatedIDs) {
        this.corporatedIDs = corporatedIDs;
    }

    /** 
     * Get the 'ReceivedFrom' element value.
     * 
     * @return value
     */
    public ReceivedFromPNRB getReceivedFrom() {
        return receivedFrom;
    }

    /** 
     * Set the 'ReceivedFrom' element value.
     * 
     * @param receivedFrom
     */
    public void setReceivedFrom(ReceivedFromPNRB receivedFrom) {
        this.receivedFrom = receivedFrom;
    }

    /** 
     * Get the 'Addresses' element value.
     * 
     * @return value
     */
    public AddressesPNRB getAddresses() {
        return addresses;
    }

    /** 
     * Set the 'Addresses' element value.
     * 
     * @param addresses
     */
    public void setAddresses(AddressesPNRB addresses) {
        this.addresses = addresses;
    }

    /** 
     * Get the 'PhoneNumbers' element value.
     * 
     * @return value
     */
    public PhoneNumbersPNRB getPhoneNumbers() {
        return phoneNumbers;
    }

    /** 
     * Set the 'PhoneNumbers' element value.
     * 
     * @param phoneNumbers
     */
    public void setPhoneNumbers(PhoneNumbersPNRB phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
    }

    /** 
     * Get the 'Remarks' element value.
     * 
     * @return value
     */
    public RemarksPNRB getRemarks() {
        return remarks;
    }

    /** 
     * Set the 'Remarks' element value.
     * 
     * @param remarks
     */
    public void setRemarks(RemarksPNRB remarks) {
        this.remarks = remarks;
    }

    /** 
     * Get the 'EmailAddresses' element value.
     * 
     * @return value
     */
    public EmailAddressesPNRB getEmailAddresses() {
        return emailAddresses;
    }

    /** 
     * Set the 'EmailAddresses' element value.
     * 
     * @param emailAddresses
     */
    public void setEmailAddresses(EmailAddressesPNRB emailAddresses) {
        this.emailAddresses = emailAddresses;
    }

    /** 
     * Get the 'AccountingLines' element value.
     * 
     * @return value
     */
    public AccountingLinesPNRB getAccountingLines() {
        return accountingLines;
    }

    /** 
     * Set the 'AccountingLines' element value.
     * 
     * @param accountingLines
     */
    public void setAccountingLines(AccountingLinesPNRB accountingLines) {
        this.accountingLines = accountingLines;
    }

    /** 
     * Get the 'DescriptiveBillingInformation' element value.
     * 
     * @return value
     */
    public DescriptiveBillingInformationPNRB getDescriptiveBillingInformation() {
        return descriptiveBillingInformation;
    }

    /** 
     * Set the 'DescriptiveBillingInformation' element value.
     * 
     * @param descriptiveBillingInformation
     */
    public void setDescriptiveBillingInformation(
            DescriptiveBillingInformationPNRB descriptiveBillingInformation) {
        this.descriptiveBillingInformation = descriptiveBillingInformation;
    }

    /** 
     * Get the 'PayInfos' element value.
     * 
     * @return value
     */
    public PayInfosPNRB getPayInfos() {
        return payInfos;
    }

    /** 
     * Set the 'PayInfos' element value.
     * 
     * @param payInfos
     */
    public void setPayInfos(PayInfosPNRB payInfos) {
        this.payInfos = payInfos;
    }

    /** 
     * Get the list of 'GenericSpecialRequests' element items.
     * 
     * @return list
     */
    public List<GenericSpecialRequestPNRB> getGenericSpecialRequestList() {
        return genericSpecialRequestList;
    }

    /** 
     * Set the list of 'GenericSpecialRequests' element items.
     * 
     * @param list
     */
    public void setGenericSpecialRequestList(
            List<GenericSpecialRequestPNRB> list) {
        genericSpecialRequestList = list;
    }

    /** 
     * Get the 'FileInfo' element value.
     * 
     * @return value
     */
    public FileInfoPNRB getFileInfo() {
        return fileInfo;
    }

    /** 
     * Set the 'FileInfo' element value.
     * 
     * @param fileInfo
     */
    public void setFileInfo(FileInfoPNRB fileInfo) {
        this.fileInfo = fileInfo;
    }

    /** 
     * Get the 'Actions' element value.
     * 
     * @return value
     */
    public ActionsPNRB getActions() {
        return actions;
    }

    /** 
     * Set the 'Actions' element value.
     * 
     * @param actions
     */
    public void setActions(ActionsPNRB actions) {
        this.actions = actions;
    }

    /** 
     * Get the 'Profiles' element value.
     * 
     * @return value
     */
    public ProfilesPNRB getProfiles() {
        return profiles;
    }

    /** 
     * Set the 'Profiles' element value.
     * 
     * @param profiles
     */
    public void setProfiles(ProfilesPNRB profiles) {
        this.profiles = profiles;
    }

    /** 
     * Get the 'AssociationMatrices' element value.
     * 
     * @return value
     */
    public AssociationMatricesPNRB getAssociationMatrices() {
        return associationMatrices;
    }

    /** 
     * Set the 'AssociationMatrices' element value.
     * 
     * @param associationMatrices
     */
    public void setAssociationMatrices(
            AssociationMatricesPNRB associationMatrices) {
        this.associationMatrices = associationMatrices;
    }

    /** 
     * Get the 'ReservationExtensions' element value.
     * 
     * @return value
     */
    public ReservationExtensions getReservationExtensions() {
        return reservationExtensions;
    }

    /** 
     * Set the 'ReservationExtensions' element value.
     * 
     * @param reservationExtensions
     */
    public void setReservationExtensions(
            ReservationExtensions reservationExtensions) {
        this.reservationExtensions = reservationExtensions;
    }

    /** 
     * Get the 'History' element value.
     * 
     * @return value
     */
    public History getHistory() {
        return history;
    }

    /** 
     * Set the 'History' element value.
     * 
     * @param history
     */
    public void setHistory(History history) {
        this.history = history;
    }

    /** 
     * Get the 'OpenReservationElements' element value.
     * 
     * @return value
     */
    public OpenReservationElementsType getOpenReservationElements() {
        return openReservationElements;
    }

    /** 
     * Set the 'OpenReservationElements' element value.
     * 
     * @param openReservationElements
     */
    public void setOpenReservationElements(
            OpenReservationElementsType openReservationElements) {
        this.openReservationElements = openReservationElements;
    }

    /** 
     * Get the 'numberInParty' attribute value. Number of name fields in the PNR. Example "6"
     * 
     * @return value
     */
    public BigInteger getNumberInParty() {
        return numberInParty;
    }

    /** 
     * Set the 'numberInParty' attribute value. Number of name fields in the PNR. Example "6"
     * 
     * @param numberInParty
     */
    public void setNumberInParty(BigInteger numberInParty) {
        this.numberInParty = numberInParty;
    }

    /** 
     * Get the 'numberOfInfants' attribute value. Number Infant Name fields in the PNR. Example "1"
     * 
     * @return value
     */
    public Integer getNumberOfInfants() {
        return numberOfInfants;
    }

    /** 
     * Set the 'numberOfInfants' attribute value. Number Infant Name fields in the PNR. Example "1"
     * 
     * @param numberOfInfants
     */
    public void setNumberOfInfants(Integer numberOfInfants) {
        this.numberOfInfants = numberOfInfants;
    }

    /** 
     * Get the 'NumberInSegment' attribute value. Number Infant Name fields in the PNR. Example "5"
     * 
     * @return value
     */
    public Integer getNumberInSegment() {
        return numberInSegment;
    }

    /** 
     * Set the 'NumberInSegment' attribute value. Number Infant Name fields in the PNR. Example "5"
     * 
     * @param numberInSegment
     */
    public void setNumberInSegment(Integer numberInSegment) {
        this.numberInSegment = numberInSegment;
    }

    /** 
     * Get the 'hostOperatedCodeShare' attribute value.
     * 
     * @return value
     */
    public Boolean getHostOperatedCodeShare() {
        return hostOperatedCodeShare;
    }

    /** 
     * Set the 'hostOperatedCodeShare' attribute value.
     * 
     * @param hostOperatedCodeShare
     */
    public void setHostOperatedCodeShare(Boolean hostOperatedCodeShare) {
        this.hostOperatedCodeShare = hostOperatedCodeShare;
    }

    /** 
     * Get the 'hostMarketedCodeShare' attribute value.
     * 
     * @return value
     */
    public Boolean getHostMarketedCodeShare() {
        return hostMarketedCodeShare;
    }

    /** 
     * Set the 'hostMarketedCodeShare' attribute value.
     * 
     * @param hostMarketedCodeShare
     */
    public void setHostMarketedCodeShare(Boolean hostMarketedCodeShare) {
        this.hostMarketedCodeShare = hostMarketedCodeShare;
    }

    /** 
     * Get the 'isTripPNR' attribute value.
     * 
     * @return value
     */
    public Boolean getIsTripPNR() {
        return isTripPNR;
    }

    /** 
     * Set the 'isTripPNR' attribute value.
     * 
     * @param isTripPNR
     */
    public void setIsTripPNR(Boolean isTripPNR) {
        this.isTripPNR = isTripPNR;
    }

    /** 
     * Get the 'isMultiCarrierPlatform' attribute value.
     * 
     * @return value
     */
    public Boolean getIsMultiCarrierPlatform() {
        return isMultiCarrierPlatform;
    }

    /** 
     * Set the 'isMultiCarrierPlatform' attribute value.
     * 
     * @param isMultiCarrierPlatform
     */
    public void setIsMultiCarrierPlatform(Boolean isMultiCarrierPlatform) {
        this.isMultiCarrierPlatform = isMultiCarrierPlatform;
    }

    /** 
     * Get the 'isDirectConnectPlatformBooking' attribute value. Indicates if Direct Connect Platform (DCP) booking, created by GSA or ownership
                      changed to DCP by RES agent.
                  
     * 
     * @return value
     */
    public Boolean getIsDirectConnectPlatformBooking() {
        return isDirectConnectPlatformBooking;
    }

    /** 
     * Set the 'isDirectConnectPlatformBooking' attribute value. Indicates if Direct Connect Platform (DCP) booking, created by GSA or ownership
                      changed to DCP by RES agent.
                  
     * 
     * @param isDirectConnectPlatformBooking
     */
    public void setIsDirectConnectPlatformBooking(
            Boolean isDirectConnectPlatformBooking) {
        this.isDirectConnectPlatformBooking = isDirectConnectPlatformBooking;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReservationExtensions" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:any minOccurs="0" maxOccurs="unbounded" processContents="lax"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ReservationExtensions implements Serializable
    {
        private List<Element> anyList = new ArrayList<Element>();

        /** 
         * Get the list of 'ReservationExtensions' element items.
         * 
         * @return list
         */
        public List<Element> getAnyList() {
            return anyList;
        }

        /** 
         * Set the list of 'ReservationExtensions' element items.
         * 
         * @param list
         */
        public void setAnyList(List<Element> list) {
            anyList = list;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="History" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="HistoryTransaction" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class HistoryTransaction -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class History implements Serializable
    {
        private List<HistoryTransaction> historyTransactionList = new ArrayList<HistoryTransaction>();

        /** 
         * Get the list of 'HistoryTransaction' element items.
         * 
         * @return list
         */
        public List<HistoryTransaction> getHistoryTransactionList() {
            return historyTransactionList;
        }

        /** 
         * Set the list of 'HistoryTransaction' element items.
         * 
         * @param list
         */
        public void setHistoryTransactionList(List<HistoryTransaction> list) {
            historyTransactionList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HistoryTransaction" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:SignatureType" name="Signature" minOccurs="0"/>
         *       &lt;xs:choice minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Choice -->
         *       &lt;/xs:choice>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class HistoryTransaction implements Serializable
        {
            private SignatureType signature;
            private List<Choice> choiceList = new ArrayList<Choice>();

            /** 
             * Get the 'Signature' element value.
             * 
             * @return value
             */
            public SignatureType getSignature() {
                return signature;
            }

            /** 
             * Set the 'Signature' element value.
             * 
             * @param signature
             */
            public void setSignature(SignatureType signature) {
                this.signature = signature;
            }

            /** 
             * Get the list of choice items.
             * 
             * @return list
             */
            public List<Choice> getChoiceList() {
                return choiceList;
            }

            /** 
             * Set the list of choice items.
             * 
             * @param list
             */
            public void setChoiceList(List<Choice> list) {
                choiceList = list;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:choice xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:element name="ItineraryHistory" minOccurs="0">
             *     &lt;!-- Reference to inner class ItineraryHistory -->
             *   &lt;/xs:element>
             *   &lt;xs:element type="ns:RemarkHistoryType" name="RemarkHistory" minOccurs="0"/>
             *   &lt;xs:element type="ns:FactHistoryType" name="FactHistory" minOccurs="0"/>
             *   &lt;xs:element type="ns:TicketingHistoryType" name="TicketingHistory" minOccurs="0"/>
             *   &lt;xs:element type="ns:SeatsHistoryType" name="SeatsHistory" minOccurs="0"/>
             *   &lt;xs:element type="ns:BSGHistoryType" name="BSGHistory" minOccurs="0"/>
             *   &lt;xs:element type="ns:FrequentFlierHistoryType" name="FrequentFlierHistory" minOccurs="0"/>
             *   &lt;xs:element type="ns:PassengerNameHistoryType" name="NameHistory" minOccurs="0"/>
             *   &lt;xs:element type="ns:SubscriptionCardHistoryType" name="SubscriptionCardHistory" minOccurs="0"/>
             *   &lt;xs:element type="ns:PhoneHistoryType" name="PhoneHistory" minOccurs="0"/>
             *   &lt;xs:element type="ns:AddressHistoryType" name="AddressHistory" minOccurs="0"/>
             *   &lt;xs:element type="ns:CorporateIDHistoryType" name="CorporateIDHistory" minOccurs="0"/>
             *   &lt;xs:element type="ns:PassengerDetailsHistoryType" name="PassengerDetailsHistory" minOccurs="0"/>
             *   &lt;xs:element type="ns:CustomerInsightProfileHistoryType" name="CustomerInsightProfileHistory" minOccurs="0"/>
             *   &lt;xs:element type="ns:AccountingLineHistoryType" name="AccountingLineHistory" minOccurs="0"/>
             *   &lt;xs:element type="ns:GroupPlannerHistoryType" name="GroupPlannerHistory" minOccurs="0"/>
             *   &lt;xs:element type="ns:TravelPolicyHistoryType" name="TravelPolicyHistory" minOccurs="0"/>
             *   &lt;xs:element type="ns:CommentHistoryType" name="CommentHistory" minOccurs="0"/>
             *   &lt;xs:element type="ns:DKNumberHistoryType" name="DKNumberHistory" minOccurs="0"/>
             *   &lt;xs:element type="ns:NameChangeRestrictionHistoryType" name="NameChangeRestrictionHistory" minOccurs="0"/>
             *   &lt;xs:element type="ns:ExtFrequentTravelerHistoryType" name="ExtFrequentTravelerHistory" minOccurs="0"/>
             *   &lt;xs:element type="ns:ProductDetailsHistoryType" name="ProductDetailsHistory" minOccurs="0"/>
             *   &lt;xs:element type="ns:AncillaryServicesHistoryType" name="AncillaryServicesHistory" minOccurs="0"/>
             *   &lt;xs:element type="ns:AssociationHistoryType" name="AssociationHistory" minOccurs="0"/>
             *   &lt;xs:element type="ns:OpenReservationElementHistoryType" name="OpenReservationElementHistory" minOccurs="0"/>
             * &lt;/xs:choice>
             * </pre>
             */
            public static class Choice implements Serializable
            {
                private int choiceListSelect = -1;
                private static final int ITINERARY_HISTORY_CHOICE = 0;
                private static final int REMARK_HISTORY_CHOICE = 1;
                private static final int FACT_HISTORY_CHOICE = 2;
                private static final int TICKETING_HISTORY_CHOICE = 3;
                private static final int SEATS_HISTORY_CHOICE = 4;
                private static final int BSG_HISTORY_CHOICE = 5;
                private static final int FREQUENT_FLIER_HISTORY_CHOICE = 6;
                private static final int NAME_HISTORY_CHOICE = 7;
                private static final int SUBSCRIPTION_CARD_HISTORY_CHOICE = 8;
                private static final int PHONE_HISTORY_CHOICE = 9;
                private static final int ADDRESS_HISTORY_CHOICE = 10;
                private static final int CORPORATE_ID_HISTORY_CHOICE = 11;
                private static final int PASSENGER_DETAILS_HISTORY_CHOICE = 12;
                private static final int CUSTOMER_INSIGHT_PROFILE_HISTORY_CHOICE = 13;
                private static final int ACCOUNTING_LINE_HISTORY_CHOICE = 14;
                private static final int GROUP_PLANNER_HISTORY_CHOICE = 15;
                private static final int TRAVEL_POLICY_HISTORY_CHOICE = 16;
                private static final int COMMENT_HISTORY_CHOICE = 17;
                private static final int DK_NUMBER_HISTORY_CHOICE = 18;
                private static final int NAME_CHANGE_RESTRICTION_HISTORY_CHOICE = 19;
                private static final int EXT_FREQUENT_TRAVELER_HISTORY_CHOICE = 20;
                private static final int PRODUCT_DETAILS_HISTORY_CHOICE = 21;
                private static final int ANCILLARY_SERVICES_HISTORY_CHOICE = 22;
                private static final int ASSOCIATION_HISTORY_CHOICE = 23;
                private static final int OPEN_RESERVATION_ELEMENT_HISTORY_CHOICE = 24;
                private ItineraryHistory itineraryHistory;
                private RemarkHistoryType remarkHistory;
                private FactHistoryType factHistory;
                private TicketingHistoryType ticketingHistory;
                private SeatsHistoryType seatsHistory;
                private BSGHistoryType BSGHistory;
                private FrequentFlierHistoryType frequentFlierHistory;
                private PassengerNameHistoryType nameHistory;
                private SubscriptionCardHistoryType subscriptionCardHistory;
                private PhoneHistoryType phoneHistory;
                private AddressHistoryType addressHistory;
                private CorporateIDHistoryType corporateIDHistory;
                private PassengerDetailsHistoryType passengerDetailsHistory;
                private CustomerInsightProfileHistoryType customerInsightProfileHistory;
                private AccountingLineHistoryType accountingLineHistory;
                private GroupPlannerHistoryType groupPlannerHistory;
                private TravelPolicyHistoryType travelPolicyHistory;
                private CommentHistoryType commentHistory;
                private DKNumberHistoryType DKNumberHistory;
                private NameChangeRestrictionHistoryType nameChangeRestrictionHistory;
                private ExtFrequentTravelerHistoryType extFrequentTravelerHistory;
                private ProductDetailsHistoryType productDetailsHistory;
                private AncillaryServicesHistoryType ancillaryServicesHistory;
                private AssociationHistoryType associationHistory;
                private OpenReservationElementHistoryType openReservationElementHistory;

                private void setChoiceListSelect(int choice) {
                    if (choiceListSelect == -1) {
                        choiceListSelect = choice;
                    } else if (choiceListSelect != choice) {
                        throw new IllegalStateException(
                                "Need to call clearChoiceListSelect() before changing existing choice");
                    }
                }

                /** 
                 * Clear the choice selection.
                 */
                public void clearChoiceListSelect() {
                    choiceListSelect = -1;
                }

                /** 
                 * Check if ItineraryHistory is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifItineraryHistory() {
                    return choiceListSelect == ITINERARY_HISTORY_CHOICE;
                }

                /** 
                 * Get the 'ItineraryHistory' element value.
                 * 
                 * @return value
                 */
                public ItineraryHistory getItineraryHistory() {
                    return itineraryHistory;
                }

                /** 
                 * Set the 'ItineraryHistory' element value.
                 * 
                 * @param itineraryHistory
                 */
                public void setItineraryHistory(
                        ItineraryHistory itineraryHistory) {
                    setChoiceListSelect(ITINERARY_HISTORY_CHOICE);
                    this.itineraryHistory = itineraryHistory;
                }

                /** 
                 * Check if RemarkHistory is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifRemarkHistory() {
                    return choiceListSelect == REMARK_HISTORY_CHOICE;
                }

                /** 
                 * Get the 'RemarkHistory' element value.
                 * 
                 * @return value
                 */
                public RemarkHistoryType getRemarkHistory() {
                    return remarkHistory;
                }

                /** 
                 * Set the 'RemarkHistory' element value.
                 * 
                 * @param remarkHistory
                 */
                public void setRemarkHistory(RemarkHistoryType remarkHistory) {
                    setChoiceListSelect(REMARK_HISTORY_CHOICE);
                    this.remarkHistory = remarkHistory;
                }

                /** 
                 * Check if FactHistory is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifFactHistory() {
                    return choiceListSelect == FACT_HISTORY_CHOICE;
                }

                /** 
                 * Get the 'FactHistory' element value.
                 * 
                 * @return value
                 */
                public FactHistoryType getFactHistory() {
                    return factHistory;
                }

                /** 
                 * Set the 'FactHistory' element value.
                 * 
                 * @param factHistory
                 */
                public void setFactHistory(FactHistoryType factHistory) {
                    setChoiceListSelect(FACT_HISTORY_CHOICE);
                    this.factHistory = factHistory;
                }

                /** 
                 * Check if TicketingHistory is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifTicketingHistory() {
                    return choiceListSelect == TICKETING_HISTORY_CHOICE;
                }

                /** 
                 * Get the 'TicketingHistory' element value.
                 * 
                 * @return value
                 */
                public TicketingHistoryType getTicketingHistory() {
                    return ticketingHistory;
                }

                /** 
                 * Set the 'TicketingHistory' element value.
                 * 
                 * @param ticketingHistory
                 */
                public void setTicketingHistory(
                        TicketingHistoryType ticketingHistory) {
                    setChoiceListSelect(TICKETING_HISTORY_CHOICE);
                    this.ticketingHistory = ticketingHistory;
                }

                /** 
                 * Check if SeatsHistory is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifSeatsHistory() {
                    return choiceListSelect == SEATS_HISTORY_CHOICE;
                }

                /** 
                 * Get the 'SeatsHistory' element value.
                 * 
                 * @return value
                 */
                public SeatsHistoryType getSeatsHistory() {
                    return seatsHistory;
                }

                /** 
                 * Set the 'SeatsHistory' element value.
                 * 
                 * @param seatsHistory
                 */
                public void setSeatsHistory(SeatsHistoryType seatsHistory) {
                    setChoiceListSelect(SEATS_HISTORY_CHOICE);
                    this.seatsHistory = seatsHistory;
                }

                /** 
                 * Check if BSGHistory is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifBSGHistory() {
                    return choiceListSelect == BSG_HISTORY_CHOICE;
                }

                /** 
                 * Get the 'BSGHistory' element value.
                 * 
                 * @return value
                 */
                public BSGHistoryType getBSGHistory() {
                    return BSGHistory;
                }

                /** 
                 * Set the 'BSGHistory' element value.
                 * 
                 * @param BSGHistory
                 */
                public void setBSGHistory(BSGHistoryType BSGHistory) {
                    setChoiceListSelect(BSG_HISTORY_CHOICE);
                    this.BSGHistory = BSGHistory;
                }

                /** 
                 * Check if FrequentFlierHistory is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifFrequentFlierHistory() {
                    return choiceListSelect == FREQUENT_FLIER_HISTORY_CHOICE;
                }

                /** 
                 * Get the 'FrequentFlierHistory' element value.
                 * 
                 * @return value
                 */
                public FrequentFlierHistoryType getFrequentFlierHistory() {
                    return frequentFlierHistory;
                }

                /** 
                 * Set the 'FrequentFlierHistory' element value.
                 * 
                 * @param frequentFlierHistory
                 */
                public void setFrequentFlierHistory(
                        FrequentFlierHistoryType frequentFlierHistory) {
                    setChoiceListSelect(FREQUENT_FLIER_HISTORY_CHOICE);
                    this.frequentFlierHistory = frequentFlierHistory;
                }

                /** 
                 * Check if NameHistory is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifNameHistory() {
                    return choiceListSelect == NAME_HISTORY_CHOICE;
                }

                /** 
                 * Get the 'NameHistory' element value.
                 * 
                 * @return value
                 */
                public PassengerNameHistoryType getNameHistory() {
                    return nameHistory;
                }

                /** 
                 * Set the 'NameHistory' element value.
                 * 
                 * @param nameHistory
                 */
                public void setNameHistory(PassengerNameHistoryType nameHistory) {
                    setChoiceListSelect(NAME_HISTORY_CHOICE);
                    this.nameHistory = nameHistory;
                }

                /** 
                 * Check if SubscriptionCardHistory is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifSubscriptionCardHistory() {
                    return choiceListSelect == SUBSCRIPTION_CARD_HISTORY_CHOICE;
                }

                /** 
                 * Get the 'SubscriptionCardHistory' element value.
                 * 
                 * @return value
                 */
                public SubscriptionCardHistoryType getSubscriptionCardHistory() {
                    return subscriptionCardHistory;
                }

                /** 
                 * Set the 'SubscriptionCardHistory' element value.
                 * 
                 * @param subscriptionCardHistory
                 */
                public void setSubscriptionCardHistory(
                        SubscriptionCardHistoryType subscriptionCardHistory) {
                    setChoiceListSelect(SUBSCRIPTION_CARD_HISTORY_CHOICE);
                    this.subscriptionCardHistory = subscriptionCardHistory;
                }

                /** 
                 * Check if PhoneHistory is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifPhoneHistory() {
                    return choiceListSelect == PHONE_HISTORY_CHOICE;
                }

                /** 
                 * Get the 'PhoneHistory' element value.
                 * 
                 * @return value
                 */
                public PhoneHistoryType getPhoneHistory() {
                    return phoneHistory;
                }

                /** 
                 * Set the 'PhoneHistory' element value.
                 * 
                 * @param phoneHistory
                 */
                public void setPhoneHistory(PhoneHistoryType phoneHistory) {
                    setChoiceListSelect(PHONE_HISTORY_CHOICE);
                    this.phoneHistory = phoneHistory;
                }

                /** 
                 * Check if AddressHistory is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifAddressHistory() {
                    return choiceListSelect == ADDRESS_HISTORY_CHOICE;
                }

                /** 
                 * Get the 'AddressHistory' element value.
                 * 
                 * @return value
                 */
                public AddressHistoryType getAddressHistory() {
                    return addressHistory;
                }

                /** 
                 * Set the 'AddressHistory' element value.
                 * 
                 * @param addressHistory
                 */
                public void setAddressHistory(AddressHistoryType addressHistory) {
                    setChoiceListSelect(ADDRESS_HISTORY_CHOICE);
                    this.addressHistory = addressHistory;
                }

                /** 
                 * Check if CorporateIDHistory is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifCorporateIDHistory() {
                    return choiceListSelect == CORPORATE_ID_HISTORY_CHOICE;
                }

                /** 
                 * Get the 'CorporateIDHistory' element value.
                 * 
                 * @return value
                 */
                public CorporateIDHistoryType getCorporateIDHistory() {
                    return corporateIDHistory;
                }

                /** 
                 * Set the 'CorporateIDHistory' element value.
                 * 
                 * @param corporateIDHistory
                 */
                public void setCorporateIDHistory(
                        CorporateIDHistoryType corporateIDHistory) {
                    setChoiceListSelect(CORPORATE_ID_HISTORY_CHOICE);
                    this.corporateIDHistory = corporateIDHistory;
                }

                /** 
                 * Check if PassengerDetailsHistory is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifPassengerDetailsHistory() {
                    return choiceListSelect == PASSENGER_DETAILS_HISTORY_CHOICE;
                }

                /** 
                 * Get the 'PassengerDetailsHistory' element value.
                 * 
                 * @return value
                 */
                public PassengerDetailsHistoryType getPassengerDetailsHistory() {
                    return passengerDetailsHistory;
                }

                /** 
                 * Set the 'PassengerDetailsHistory' element value.
                 * 
                 * @param passengerDetailsHistory
                 */
                public void setPassengerDetailsHistory(
                        PassengerDetailsHistoryType passengerDetailsHistory) {
                    setChoiceListSelect(PASSENGER_DETAILS_HISTORY_CHOICE);
                    this.passengerDetailsHistory = passengerDetailsHistory;
                }

                /** 
                 * Check if CustomerInsightProfileHistory is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifCustomerInsightProfileHistory() {
                    return choiceListSelect == CUSTOMER_INSIGHT_PROFILE_HISTORY_CHOICE;
                }

                /** 
                 * Get the 'CustomerInsightProfileHistory' element value.
                 * 
                 * @return value
                 */
                public CustomerInsightProfileHistoryType getCustomerInsightProfileHistory() {
                    return customerInsightProfileHistory;
                }

                /** 
                 * Set the 'CustomerInsightProfileHistory' element value.
                 * 
                 * @param customerInsightProfileHistory
                 */
                public void setCustomerInsightProfileHistory(
                        CustomerInsightProfileHistoryType customerInsightProfileHistory) {
                    setChoiceListSelect(CUSTOMER_INSIGHT_PROFILE_HISTORY_CHOICE);
                    this.customerInsightProfileHistory = customerInsightProfileHistory;
                }

                /** 
                 * Check if AccountingLineHistory is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifAccountingLineHistory() {
                    return choiceListSelect == ACCOUNTING_LINE_HISTORY_CHOICE;
                }

                /** 
                 * Get the 'AccountingLineHistory' element value.
                 * 
                 * @return value
                 */
                public AccountingLineHistoryType getAccountingLineHistory() {
                    return accountingLineHistory;
                }

                /** 
                 * Set the 'AccountingLineHistory' element value.
                 * 
                 * @param accountingLineHistory
                 */
                public void setAccountingLineHistory(
                        AccountingLineHistoryType accountingLineHistory) {
                    setChoiceListSelect(ACCOUNTING_LINE_HISTORY_CHOICE);
                    this.accountingLineHistory = accountingLineHistory;
                }

                /** 
                 * Check if GroupPlannerHistory is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifGroupPlannerHistory() {
                    return choiceListSelect == GROUP_PLANNER_HISTORY_CHOICE;
                }

                /** 
                 * Get the 'GroupPlannerHistory' element value.
                 * 
                 * @return value
                 */
                public GroupPlannerHistoryType getGroupPlannerHistory() {
                    return groupPlannerHistory;
                }

                /** 
                 * Set the 'GroupPlannerHistory' element value.
                 * 
                 * @param groupPlannerHistory
                 */
                public void setGroupPlannerHistory(
                        GroupPlannerHistoryType groupPlannerHistory) {
                    setChoiceListSelect(GROUP_PLANNER_HISTORY_CHOICE);
                    this.groupPlannerHistory = groupPlannerHistory;
                }

                /** 
                 * Check if TravelPolicyHistory is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifTravelPolicyHistory() {
                    return choiceListSelect == TRAVEL_POLICY_HISTORY_CHOICE;
                }

                /** 
                 * Get the 'TravelPolicyHistory' element value.
                 * 
                 * @return value
                 */
                public TravelPolicyHistoryType getTravelPolicyHistory() {
                    return travelPolicyHistory;
                }

                /** 
                 * Set the 'TravelPolicyHistory' element value.
                 * 
                 * @param travelPolicyHistory
                 */
                public void setTravelPolicyHistory(
                        TravelPolicyHistoryType travelPolicyHistory) {
                    setChoiceListSelect(TRAVEL_POLICY_HISTORY_CHOICE);
                    this.travelPolicyHistory = travelPolicyHistory;
                }

                /** 
                 * Check if CommentHistory is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifCommentHistory() {
                    return choiceListSelect == COMMENT_HISTORY_CHOICE;
                }

                /** 
                 * Get the 'CommentHistory' element value.
                 * 
                 * @return value
                 */
                public CommentHistoryType getCommentHistory() {
                    return commentHistory;
                }

                /** 
                 * Set the 'CommentHistory' element value.
                 * 
                 * @param commentHistory
                 */
                public void setCommentHistory(CommentHistoryType commentHistory) {
                    setChoiceListSelect(COMMENT_HISTORY_CHOICE);
                    this.commentHistory = commentHistory;
                }

                /** 
                 * Check if DKNumberHistory is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifDKNumberHistory() {
                    return choiceListSelect == DK_NUMBER_HISTORY_CHOICE;
                }

                /** 
                 * Get the 'DKNumberHistory' element value.
                 * 
                 * @return value
                 */
                public DKNumberHistoryType getDKNumberHistory() {
                    return DKNumberHistory;
                }

                /** 
                 * Set the 'DKNumberHistory' element value.
                 * 
                 * @param DKNumberHistory
                 */
                public void setDKNumberHistory(
                        DKNumberHistoryType DKNumberHistory) {
                    setChoiceListSelect(DK_NUMBER_HISTORY_CHOICE);
                    this.DKNumberHistory = DKNumberHistory;
                }

                /** 
                 * Check if NameChangeRestrictionHistory is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifNameChangeRestrictionHistory() {
                    return choiceListSelect == NAME_CHANGE_RESTRICTION_HISTORY_CHOICE;
                }

                /** 
                 * Get the 'NameChangeRestrictionHistory' element value.
                 * 
                 * @return value
                 */
                public NameChangeRestrictionHistoryType getNameChangeRestrictionHistory() {
                    return nameChangeRestrictionHistory;
                }

                /** 
                 * Set the 'NameChangeRestrictionHistory' element value.
                 * 
                 * @param nameChangeRestrictionHistory
                 */
                public void setNameChangeRestrictionHistory(
                        NameChangeRestrictionHistoryType nameChangeRestrictionHistory) {
                    setChoiceListSelect(NAME_CHANGE_RESTRICTION_HISTORY_CHOICE);
                    this.nameChangeRestrictionHistory = nameChangeRestrictionHistory;
                }

                /** 
                 * Check if ExtFrequentTravelerHistory is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifExtFrequentTravelerHistory() {
                    return choiceListSelect == EXT_FREQUENT_TRAVELER_HISTORY_CHOICE;
                }

                /** 
                 * Get the 'ExtFrequentTravelerHistory' element value.
                 * 
                 * @return value
                 */
                public ExtFrequentTravelerHistoryType getExtFrequentTravelerHistory() {
                    return extFrequentTravelerHistory;
                }

                /** 
                 * Set the 'ExtFrequentTravelerHistory' element value.
                 * 
                 * @param extFrequentTravelerHistory
                 */
                public void setExtFrequentTravelerHistory(
                        ExtFrequentTravelerHistoryType extFrequentTravelerHistory) {
                    setChoiceListSelect(EXT_FREQUENT_TRAVELER_HISTORY_CHOICE);
                    this.extFrequentTravelerHistory = extFrequentTravelerHistory;
                }

                /** 
                 * Check if ProductDetailsHistory is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifProductDetailsHistory() {
                    return choiceListSelect == PRODUCT_DETAILS_HISTORY_CHOICE;
                }

                /** 
                 * Get the 'ProductDetailsHistory' element value.
                 * 
                 * @return value
                 */
                public ProductDetailsHistoryType getProductDetailsHistory() {
                    return productDetailsHistory;
                }

                /** 
                 * Set the 'ProductDetailsHistory' element value.
                 * 
                 * @param productDetailsHistory
                 */
                public void setProductDetailsHistory(
                        ProductDetailsHistoryType productDetailsHistory) {
                    setChoiceListSelect(PRODUCT_DETAILS_HISTORY_CHOICE);
                    this.productDetailsHistory = productDetailsHistory;
                }

                /** 
                 * Check if AncillaryServicesHistory is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifAncillaryServicesHistory() {
                    return choiceListSelect == ANCILLARY_SERVICES_HISTORY_CHOICE;
                }

                /** 
                 * Get the 'AncillaryServicesHistory' element value.
                 * 
                 * @return value
                 */
                public AncillaryServicesHistoryType getAncillaryServicesHistory() {
                    return ancillaryServicesHistory;
                }

                /** 
                 * Set the 'AncillaryServicesHistory' element value.
                 * 
                 * @param ancillaryServicesHistory
                 */
                public void setAncillaryServicesHistory(
                        AncillaryServicesHistoryType ancillaryServicesHistory) {
                    setChoiceListSelect(ANCILLARY_SERVICES_HISTORY_CHOICE);
                    this.ancillaryServicesHistory = ancillaryServicesHistory;
                }

                /** 
                 * Check if AssociationHistory is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifAssociationHistory() {
                    return choiceListSelect == ASSOCIATION_HISTORY_CHOICE;
                }

                /** 
                 * Get the 'AssociationHistory' element value.
                 * 
                 * @return value
                 */
                public AssociationHistoryType getAssociationHistory() {
                    return associationHistory;
                }

                /** 
                 * Set the 'AssociationHistory' element value.
                 * 
                 * @param associationHistory
                 */
                public void setAssociationHistory(
                        AssociationHistoryType associationHistory) {
                    setChoiceListSelect(ASSOCIATION_HISTORY_CHOICE);
                    this.associationHistory = associationHistory;
                }

                /** 
                 * Check if OpenReservationElementHistory is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifOpenReservationElementHistory() {
                    return choiceListSelect == OPEN_RESERVATION_ELEMENT_HISTORY_CHOICE;
                }

                /** 
                 * Get the 'OpenReservationElementHistory' element value.
                 * 
                 * @return value
                 */
                public OpenReservationElementHistoryType getOpenReservationElementHistory() {
                    return openReservationElementHistory;
                }

                /** 
                 * Set the 'OpenReservationElementHistory' element value.
                 * 
                 * @param openReservationElementHistory
                 */
                public void setOpenReservationElementHistory(
                        OpenReservationElementHistoryType openReservationElementHistory) {
                    setChoiceListSelect(OPEN_RESERVATION_ELEMENT_HISTORY_CHOICE);
                    this.openReservationElementHistory = openReservationElementHistory;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ItineraryHistory" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:choice minOccurs="0" maxOccurs="unbounded">
                 *       &lt;!-- Reference to inner class ItineraryHistoryInner -->
                 *     &lt;/xs:choice>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ItineraryHistory implements Serializable
                {
                    private List<ItineraryHistoryInner> itineraryHistoryList = new ArrayList<ItineraryHistoryInner>();

                    /** 
                     * Get the list of 'ItineraryHistory' element items.
                     * 
                     * @return list
                     */
                    public List<ItineraryHistoryInner> getItineraryHistoryList() {
                        return itineraryHistoryList;
                    }

                    /** 
                     * Set the list of 'ItineraryHistory' element items.
                     * 
                     * @param list
                     */
                    public void setItineraryHistoryList(
                            List<ItineraryHistoryInner> list) {
                        itineraryHistoryList = list;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:choice xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:element type="ns:AirSegmentHistoryType" name="AirSegment" minOccurs="0"/>
                     *   &lt;xs:element type="ns:GeneralSegmentHistoryType" name="GeneralSegment" minOccurs="0"/>
                     *   &lt;xs:element type="ns:VehicleSegmentHistoryType" name="VehicleSegment" minOccurs="0"/>
                     *   &lt;xs:element type="ns:HotelSegmentHistoryType" name="HotelSegment" minOccurs="0"/>
                     *   &lt;xs:element type="ns:ProductBaseHistoryType" name="ProductBase" minOccurs="0"/>
                     * &lt;/xs:choice>
                     * </pre>
                     */
                    public static class ItineraryHistoryInner implements
                        Serializable
                    {
                        private int itineraryHistoryListSelect = -1;
                        private static final int AIR_SEGMENT_CHOICE = 0;
                        private static final int GENERAL_SEGMENT_CHOICE = 1;
                        private static final int VEHICLE_SEGMENT_CHOICE = 2;
                        private static final int HOTEL_SEGMENT_CHOICE = 3;
                        private static final int PRODUCT_BASE_CHOICE = 4;
                        private AirSegmentHistoryType airSegment;
                        private GeneralSegmentHistoryType generalSegment;
                        private VehicleSegmentHistoryType vehicleSegment;
                        private HotelSegmentHistoryType hotelSegment;
                        private ProductBaseHistoryType productBase;

                        private void setItineraryHistoryListSelect(int choice) {
                            if (itineraryHistoryListSelect == -1) {
                                itineraryHistoryListSelect = choice;
                            } else if (itineraryHistoryListSelect != choice) {
                                throw new IllegalStateException(
                                        "Need to call clearItineraryHistoryListSelect() before changing existing choice");
                            }
                        }

                        /** 
                         * Clear the choice selection.
                         */
                        public void clearItineraryHistoryListSelect() {
                            itineraryHistoryListSelect = -1;
                        }

                        /** 
                         * Check if AirSegment is current selection for choice.
                         * 
                         * @return <code>true</code> if selection, <code>false</code> if not
                         */
                        public boolean ifAirSegment() {
                            return itineraryHistoryListSelect == AIR_SEGMENT_CHOICE;
                        }

                        /** 
                         * Get the 'AirSegment' element value.
                         * 
                         * @return value
                         */
                        public AirSegmentHistoryType getAirSegment() {
                            return airSegment;
                        }

                        /** 
                         * Set the 'AirSegment' element value.
                         * 
                         * @param airSegment
                         */
                        public void setAirSegment(
                                AirSegmentHistoryType airSegment) {
                            setItineraryHistoryListSelect(AIR_SEGMENT_CHOICE);
                            this.airSegment = airSegment;
                        }

                        /** 
                         * Check if GeneralSegment is current selection for choice.
                         * 
                         * @return <code>true</code> if selection, <code>false</code> if not
                         */
                        public boolean ifGeneralSegment() {
                            return itineraryHistoryListSelect == GENERAL_SEGMENT_CHOICE;
                        }

                        /** 
                         * Get the 'GeneralSegment' element value.
                         * 
                         * @return value
                         */
                        public GeneralSegmentHistoryType getGeneralSegment() {
                            return generalSegment;
                        }

                        /** 
                         * Set the 'GeneralSegment' element value.
                         * 
                         * @param generalSegment
                         */
                        public void setGeneralSegment(
                                GeneralSegmentHistoryType generalSegment) {
                            setItineraryHistoryListSelect(GENERAL_SEGMENT_CHOICE);
                            this.generalSegment = generalSegment;
                        }

                        /** 
                         * Check if VehicleSegment is current selection for choice.
                         * 
                         * @return <code>true</code> if selection, <code>false</code> if not
                         */
                        public boolean ifVehicleSegment() {
                            return itineraryHistoryListSelect == VEHICLE_SEGMENT_CHOICE;
                        }

                        /** 
                         * Get the 'VehicleSegment' element value.
                         * 
                         * @return value
                         */
                        public VehicleSegmentHistoryType getVehicleSegment() {
                            return vehicleSegment;
                        }

                        /** 
                         * Set the 'VehicleSegment' element value.
                         * 
                         * @param vehicleSegment
                         */
                        public void setVehicleSegment(
                                VehicleSegmentHistoryType vehicleSegment) {
                            setItineraryHistoryListSelect(VEHICLE_SEGMENT_CHOICE);
                            this.vehicleSegment = vehicleSegment;
                        }

                        /** 
                         * Check if HotelSegment is current selection for choice.
                         * 
                         * @return <code>true</code> if selection, <code>false</code> if not
                         */
                        public boolean ifHotelSegment() {
                            return itineraryHistoryListSelect == HOTEL_SEGMENT_CHOICE;
                        }

                        /** 
                         * Get the 'HotelSegment' element value.
                         * 
                         * @return value
                         */
                        public HotelSegmentHistoryType getHotelSegment() {
                            return hotelSegment;
                        }

                        /** 
                         * Set the 'HotelSegment' element value.
                         * 
                         * @param hotelSegment
                         */
                        public void setHotelSegment(
                                HotelSegmentHistoryType hotelSegment) {
                            setItineraryHistoryListSelect(HOTEL_SEGMENT_CHOICE);
                            this.hotelSegment = hotelSegment;
                        }

                        /** 
                         * Check if ProductBase is current selection for choice.
                         * 
                         * @return <code>true</code> if selection, <code>false</code> if not
                         */
                        public boolean ifProductBase() {
                            return itineraryHistoryListSelect == PRODUCT_BASE_CHOICE;
                        }

                        /** 
                         * Get the 'ProductBase' element value.
                         * 
                         * @return value
                         */
                        public ProductBaseHistoryType getProductBase() {
                            return productBase;
                        }

                        /** 
                         * Set the 'ProductBase' element value.
                         * 
                         * @param productBase
                         */
                        public void setProductBase(
                                ProductBaseHistoryType productBase) {
                            setItineraryHistoryListSelect(PRODUCT_BASE_CHOICE);
                            this.productBase = productBase;
                        }
                    }
                }
            }
        }
    }
}
