
package com.sabre.webservices.pnrbuilder.v119;

import com.sabre.services.res.or.v114.OpenReservationAction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:ns1="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReservationUpdateItemType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:PassengerNameUpdate.PNRB" name="PassengerNameUpdate" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:GroupNameUpdate.PNRB" name="GroupNameUpdate" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:AncillaryServicesUpdate.PNRB" name="AncillaryServicesUpdate"/>
 *     &lt;xs:element type="ns:AncillaryServicesPartialUpdate.PNRB" name="AncillaryServicesPartialUpdate"/>
 *     &lt;xs:element type="ns:EmailAddressUpdate.PNRB" name="EmailAddressUpdate" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:ProfileUpdate.PNRB" name="ProfileUpdate"/>
 *     &lt;xs:element type="ns:PreReservedSeatPartialUpdate.PNRB" name="PreReservedSeatPartialUpdate"/>
 *     &lt;xs:element type="ns:SpecialServiceRequestUpdate.PNRB" name="SpecialServiceRequestUpdate"/>
 *     &lt;xs:element type="ns:SSRPartialUpdate.PNRB" name="SpecialServiceRequestPartialUpdate"/>
 *     &lt;xs:element type="ns:RemarkUpdate.PNRB" name="RemarkUpdate" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:TicketDetailsUpdate.PNRB" name="TicketDetailsUpdate"/>
 *     &lt;xs:element type="ns:CssRequestUpdate.PNRB" name="CssRequestUpdate"/>
 *     &lt;xs:element type="ns:RemarkPartialUpdate.PNRB" name="RemarkPartialUpdate"/>
 *     &lt;xs:element type="ns:FrequentFlyerTSAPreCheckUpdate.PNRB" name="FrequentFlyerTSAPreCheckUpdate"/>
 *     &lt;xs:element type="ns:ProductUpdate.PNRB" name="ProductUpdate"/>
 *     &lt;xs:element type="ns:PhoneNumberUpdate.PNRB" name="PhoneNumberUpdate"/>
 *     &lt;xs:element type="ns:PhoneNumberPartialUpdate.PNRB" name="PhoneNumberPartialUpdate"/>
 *     &lt;xs:element type="ns:OpenReservationElementUpdate.PNRB" name="OpenReservationElementUpdate"/>
 *     &lt;xs:element type="ns:DKNumber.PNRB" name="DKNumber"/>
 *     &lt;xs:element type="ns:OtherServiceInformation.PNRB" name="OtherServiceInformation" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:AccountingLine.PNRB" name="AccountingLine" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:DescriptiveBillingInfo.PNRB" name="DescriptiveBillingInfo" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:AirSegmentPartialUpdate.PNRB" name="AirSegmentPartialUpdate"/>
 *     &lt;xs:element type="ns:AirItineraryUpdate.PNRB" name="AirItineraryUpdate"/>
 *     &lt;xs:element type="ns:GeneralSegmentUpdate.PNRB" name="GeneralSegmentUpdate"/>
 *     &lt;xs:element type="ns:CarrierRefundItem.PNRB" name="CarrierRefundItem" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:HeaderUpdateItem.PNRB" name="HeaderUpdateItem" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:AssociationMatrixUpdate.PNRB" name="AssociationMatrixUpdate"/>
 *     &lt;xs:element type="ns:PreReservedSeatUpdate.PNRB" name="PreReservedSeatUpdate" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:TicketingInfo" name="TicketingInfoUpdate" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:BookAndHoldType.PNRB" name="BookAndHold" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns1:OpenReservationAction" name="OpenReservationAction" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:TicketingHistoryType.PNRB" name="TicketingHistory" minOccurs="0"/>
 *   &lt;/xs:choice>
 *   &lt;xs:attribute type="xs:string" name="UpdateId"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ReservationUpdateItemType implements Serializable
{
    private int choiceSelect = -1;
    private static final int PASSENGER_NAME_UPDATE_CHOICE = 0;
    private static final int GROUP_NAME_UPDATE_CHOICE = 1;
    private static final int ANCILLARY_SERVICES_UPDATE_CHOICE = 2;
    private static final int ANCILLARY_SERVICES_PARTIAL_UPDATE_CHOICE = 3;
    private static final int EMAIL_ADDRESS_UPDATE_LIST_CHOICE = 4;
    private static final int PROFILE_UPDATE_CHOICE = 5;
    private static final int PRE_RESERVED_SEAT_PARTIAL_UPDATE_CHOICE = 6;
    private static final int SPECIAL_SERVICE_REQUEST_UPDATE_CHOICE = 7;
    private static final int SPECIAL_SERVICE_REQUEST_PARTIAL_UPDATE_CHOICE = 8;
    private static final int REMARK_UPDATE_LIST_CHOICE = 9;
    private static final int TICKET_DETAILS_UPDATE_CHOICE = 10;
    private static final int CSS_REQUEST_UPDATE_CHOICE = 11;
    private static final int REMARK_PARTIAL_UPDATE_CHOICE = 12;
    private static final int FREQUENT_FLYER_TSA_PRE_CHECK_UPDATE_CHOICE = 13;
    private static final int PRODUCT_UPDATE_CHOICE = 14;
    private static final int PHONE_NUMBER_UPDATE_CHOICE = 15;
    private static final int PHONE_NUMBER_PARTIAL_UPDATE_CHOICE = 16;
    private static final int OPEN_RESERVATION_ELEMENT_UPDATE_CHOICE = 17;
    private static final int DK_NUMBER_CHOICE = 18;
    private static final int OTHER_SERVICE_INFORMATION_LIST_CHOICE = 19;
    private static final int ACCOUNTING_LINE_LIST_CHOICE = 20;
    private static final int DESCRIPTIVE_BILLING_INFO_LIST_CHOICE = 21;
    private static final int AIR_SEGMENT_PARTIAL_UPDATE_CHOICE = 22;
    private static final int AIR_ITINERARY_UPDATE_CHOICE = 23;
    private static final int GENERAL_SEGMENT_UPDATE_CHOICE = 24;
    private static final int CARRIER_REFUND_ITEM_CHOICE = 25;
    private static final int HEADER_UPDATE_ITEM_CHOICE = 26;
    private static final int ASSOCIATION_MATRIX_UPDATE_CHOICE = 27;
    private static final int PRE_RESERVED_SEAT_UPDATE_CHOICE = 28;
    private static final int TICKETING_INFO_UPDATE_CHOICE = 29;
    private static final int BOOK_AND_HOLD_CHOICE = 30;
    private static final int OPEN_RESERVATION_ACTION_CHOICE = 31;
    private static final int TICKETING_HISTORY_CHOICE = 32;
    private PassengerNameUpdatePNRB passengerNameUpdate;
    private GroupNameUpdatePNRB groupNameUpdate;
    private AncillaryServicesUpdatePNRB ancillaryServicesUpdate;
    private AncillaryServicesPartialUpdatePNRB ancillaryServicesPartialUpdate;
    private List<EmailAddressUpdatePNRB> emailAddressUpdateList = new ArrayList<EmailAddressUpdatePNRB>();
    private ProfileUpdatePNRB profileUpdate;
    private PreReservedSeatPartialUpdatePNRB preReservedSeatPartialUpdate;
    private SpecialServiceRequestUpdatePNRB specialServiceRequestUpdate;
    private SSRPartialUpdatePNRB specialServiceRequestPartialUpdate;
    private List<RemarkUpdatePNRB> remarkUpdateList = new ArrayList<RemarkUpdatePNRB>();
    private TicketDetailsUpdatePNRB ticketDetailsUpdate;
    private CssRequestUpdatePNRB cssRequestUpdate;
    private RemarkPartialUpdatePNRB remarkPartialUpdate;
    private FrequentFlyerTSAPreCheckUpdatePNRB frequentFlyerTSAPreCheckUpdate;
    private ProductUpdatePNRB productUpdate;
    private PhoneNumberUpdatePNRB phoneNumberUpdate;
    private PhoneNumberPartialUpdatePNRB phoneNumberPartialUpdate;
    private OpenReservationElementUpdatePNRB openReservationElementUpdate;
    private DKNumberPNRB DKNumber;
    private List<OtherServiceInformationPNRB> otherServiceInformationList = new ArrayList<OtherServiceInformationPNRB>();
    private List<AccountingLinePNRB> accountingLineList = new ArrayList<AccountingLinePNRB>();
    private List<DescriptiveBillingInfoPNRB> descriptiveBillingInfoList = new ArrayList<DescriptiveBillingInfoPNRB>();
    private AirSegmentPartialUpdatePNRB airSegmentPartialUpdate;
    private AirItineraryUpdatePNRB airItineraryUpdate;
    private GeneralSegmentUpdatePNRB generalSegmentUpdate;
    private CarrierRefundItemPNRB carrierRefundItem;
    private HeaderUpdateItemPNRB headerUpdateItem;
    private AssociationMatrixUpdatePNRB associationMatrixUpdate;
    private PreReservedSeatUpdatePNRB preReservedSeatUpdate;
    private TicketingInfo ticketingInfoUpdate;
    private BookAndHoldTypePNRB bookAndHold;
    private OpenReservationAction openReservationAction;
    private TicketingHistoryTypePNRB ticketingHistory;
    private String updateId;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if PassengerNameUpdate is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPassengerNameUpdate() {
        return choiceSelect == PASSENGER_NAME_UPDATE_CHOICE;
    }

    /** 
     * Get the 'PassengerNameUpdate' element value.
     * 
     * @return value
     */
    public PassengerNameUpdatePNRB getPassengerNameUpdate() {
        return passengerNameUpdate;
    }

    /** 
     * Set the 'PassengerNameUpdate' element value.
     * 
     * @param passengerNameUpdate
     */
    public void setPassengerNameUpdate(
            PassengerNameUpdatePNRB passengerNameUpdate) {
        setChoiceSelect(PASSENGER_NAME_UPDATE_CHOICE);
        this.passengerNameUpdate = passengerNameUpdate;
    }

    /** 
     * Check if GroupNameUpdate is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifGroupNameUpdate() {
        return choiceSelect == GROUP_NAME_UPDATE_CHOICE;
    }

    /** 
     * Get the 'GroupNameUpdate' element value.
     * 
     * @return value
     */
    public GroupNameUpdatePNRB getGroupNameUpdate() {
        return groupNameUpdate;
    }

    /** 
     * Set the 'GroupNameUpdate' element value.
     * 
     * @param groupNameUpdate
     */
    public void setGroupNameUpdate(GroupNameUpdatePNRB groupNameUpdate) {
        setChoiceSelect(GROUP_NAME_UPDATE_CHOICE);
        this.groupNameUpdate = groupNameUpdate;
    }

    /** 
     * Check if AncillaryServicesUpdate is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAncillaryServicesUpdate() {
        return choiceSelect == ANCILLARY_SERVICES_UPDATE_CHOICE;
    }

    /** 
     * Get the 'AncillaryServicesUpdate' element value.
     * 
     * @return value
     */
    public AncillaryServicesUpdatePNRB getAncillaryServicesUpdate() {
        return ancillaryServicesUpdate;
    }

    /** 
     * Set the 'AncillaryServicesUpdate' element value.
     * 
     * @param ancillaryServicesUpdate
     */
    public void setAncillaryServicesUpdate(
            AncillaryServicesUpdatePNRB ancillaryServicesUpdate) {
        setChoiceSelect(ANCILLARY_SERVICES_UPDATE_CHOICE);
        this.ancillaryServicesUpdate = ancillaryServicesUpdate;
    }

    /** 
     * Check if AncillaryServicesPartialUpdate is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAncillaryServicesPartialUpdate() {
        return choiceSelect == ANCILLARY_SERVICES_PARTIAL_UPDATE_CHOICE;
    }

    /** 
     * Get the 'AncillaryServicesPartialUpdate' element value.
     * 
     * @return value
     */
    public AncillaryServicesPartialUpdatePNRB getAncillaryServicesPartialUpdate() {
        return ancillaryServicesPartialUpdate;
    }

    /** 
     * Set the 'AncillaryServicesPartialUpdate' element value.
     * 
     * @param ancillaryServicesPartialUpdate
     */
    public void setAncillaryServicesPartialUpdate(
            AncillaryServicesPartialUpdatePNRB ancillaryServicesPartialUpdate) {
        setChoiceSelect(ANCILLARY_SERVICES_PARTIAL_UPDATE_CHOICE);
        this.ancillaryServicesPartialUpdate = ancillaryServicesPartialUpdate;
    }

    /** 
     * Check if EmailAddressUpdateList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifEmailAddressUpdateList() {
        return choiceSelect == EMAIL_ADDRESS_UPDATE_LIST_CHOICE;
    }

    /** 
     * Get the list of 'EmailAddressUpdate' element items.
     * 
     * @return list
     */
    public List<EmailAddressUpdatePNRB> getEmailAddressUpdateList() {
        return emailAddressUpdateList;
    }

    /** 
     * Set the list of 'EmailAddressUpdate' element items.
     * 
     * @param list
     */
    public void setEmailAddressUpdateList(List<EmailAddressUpdatePNRB> list) {
        setChoiceSelect(EMAIL_ADDRESS_UPDATE_LIST_CHOICE);
        emailAddressUpdateList = list;
    }

    /** 
     * Check if ProfileUpdate is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifProfileUpdate() {
        return choiceSelect == PROFILE_UPDATE_CHOICE;
    }

    /** 
     * Get the 'ProfileUpdate' element value.
     * 
     * @return value
     */
    public ProfileUpdatePNRB getProfileUpdate() {
        return profileUpdate;
    }

    /** 
     * Set the 'ProfileUpdate' element value.
     * 
     * @param profileUpdate
     */
    public void setProfileUpdate(ProfileUpdatePNRB profileUpdate) {
        setChoiceSelect(PROFILE_UPDATE_CHOICE);
        this.profileUpdate = profileUpdate;
    }

    /** 
     * Check if PreReservedSeatPartialUpdate is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPreReservedSeatPartialUpdate() {
        return choiceSelect == PRE_RESERVED_SEAT_PARTIAL_UPDATE_CHOICE;
    }

    /** 
     * Get the 'PreReservedSeatPartialUpdate' element value.
     * 
     * @return value
     */
    public PreReservedSeatPartialUpdatePNRB getPreReservedSeatPartialUpdate() {
        return preReservedSeatPartialUpdate;
    }

    /** 
     * Set the 'PreReservedSeatPartialUpdate' element value.
     * 
     * @param preReservedSeatPartialUpdate
     */
    public void setPreReservedSeatPartialUpdate(
            PreReservedSeatPartialUpdatePNRB preReservedSeatPartialUpdate) {
        setChoiceSelect(PRE_RESERVED_SEAT_PARTIAL_UPDATE_CHOICE);
        this.preReservedSeatPartialUpdate = preReservedSeatPartialUpdate;
    }

    /** 
     * Check if SpecialServiceRequestUpdate is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSpecialServiceRequestUpdate() {
        return choiceSelect == SPECIAL_SERVICE_REQUEST_UPDATE_CHOICE;
    }

    /** 
     * Get the 'SpecialServiceRequestUpdate' element value.
     * 
     * @return value
     */
    public SpecialServiceRequestUpdatePNRB getSpecialServiceRequestUpdate() {
        return specialServiceRequestUpdate;
    }

    /** 
     * Set the 'SpecialServiceRequestUpdate' element value.
     * 
     * @param specialServiceRequestUpdate
     */
    public void setSpecialServiceRequestUpdate(
            SpecialServiceRequestUpdatePNRB specialServiceRequestUpdate) {
        setChoiceSelect(SPECIAL_SERVICE_REQUEST_UPDATE_CHOICE);
        this.specialServiceRequestUpdate = specialServiceRequestUpdate;
    }

    /** 
     * Check if SpecialServiceRequestPartialUpdate is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSpecialServiceRequestPartialUpdate() {
        return choiceSelect == SPECIAL_SERVICE_REQUEST_PARTIAL_UPDATE_CHOICE;
    }

    /** 
     * Get the 'SpecialServiceRequestPartialUpdate' element value.
     * 
     * @return value
     */
    public SSRPartialUpdatePNRB getSpecialServiceRequestPartialUpdate() {
        return specialServiceRequestPartialUpdate;
    }

    /** 
     * Set the 'SpecialServiceRequestPartialUpdate' element value.
     * 
     * @param specialServiceRequestPartialUpdate
     */
    public void setSpecialServiceRequestPartialUpdate(
            SSRPartialUpdatePNRB specialServiceRequestPartialUpdate) {
        setChoiceSelect(SPECIAL_SERVICE_REQUEST_PARTIAL_UPDATE_CHOICE);
        this.specialServiceRequestPartialUpdate = specialServiceRequestPartialUpdate;
    }

    /** 
     * Check if RemarkUpdateList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifRemarkUpdateList() {
        return choiceSelect == REMARK_UPDATE_LIST_CHOICE;
    }

    /** 
     * Get the list of 'RemarkUpdate' element items.
     * 
     * @return list
     */
    public List<RemarkUpdatePNRB> getRemarkUpdateList() {
        return remarkUpdateList;
    }

    /** 
     * Set the list of 'RemarkUpdate' element items.
     * 
     * @param list
     */
    public void setRemarkUpdateList(List<RemarkUpdatePNRB> list) {
        setChoiceSelect(REMARK_UPDATE_LIST_CHOICE);
        remarkUpdateList = list;
    }

    /** 
     * Check if TicketDetailsUpdate is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTicketDetailsUpdate() {
        return choiceSelect == TICKET_DETAILS_UPDATE_CHOICE;
    }

    /** 
     * Get the 'TicketDetailsUpdate' element value.
     * 
     * @return value
     */
    public TicketDetailsUpdatePNRB getTicketDetailsUpdate() {
        return ticketDetailsUpdate;
    }

    /** 
     * Set the 'TicketDetailsUpdate' element value.
     * 
     * @param ticketDetailsUpdate
     */
    public void setTicketDetailsUpdate(
            TicketDetailsUpdatePNRB ticketDetailsUpdate) {
        setChoiceSelect(TICKET_DETAILS_UPDATE_CHOICE);
        this.ticketDetailsUpdate = ticketDetailsUpdate;
    }

    /** 
     * Check if CssRequestUpdate is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCssRequestUpdate() {
        return choiceSelect == CSS_REQUEST_UPDATE_CHOICE;
    }

    /** 
     * Get the 'CssRequestUpdate' element value.
     * 
     * @return value
     */
    public CssRequestUpdatePNRB getCssRequestUpdate() {
        return cssRequestUpdate;
    }

    /** 
     * Set the 'CssRequestUpdate' element value.
     * 
     * @param cssRequestUpdate
     */
    public void setCssRequestUpdate(CssRequestUpdatePNRB cssRequestUpdate) {
        setChoiceSelect(CSS_REQUEST_UPDATE_CHOICE);
        this.cssRequestUpdate = cssRequestUpdate;
    }

    /** 
     * Check if RemarkPartialUpdate is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifRemarkPartialUpdate() {
        return choiceSelect == REMARK_PARTIAL_UPDATE_CHOICE;
    }

    /** 
     * Get the 'RemarkPartialUpdate' element value.
     * 
     * @return value
     */
    public RemarkPartialUpdatePNRB getRemarkPartialUpdate() {
        return remarkPartialUpdate;
    }

    /** 
     * Set the 'RemarkPartialUpdate' element value.
     * 
     * @param remarkPartialUpdate
     */
    public void setRemarkPartialUpdate(
            RemarkPartialUpdatePNRB remarkPartialUpdate) {
        setChoiceSelect(REMARK_PARTIAL_UPDATE_CHOICE);
        this.remarkPartialUpdate = remarkPartialUpdate;
    }

    /** 
     * Check if FrequentFlyerTSAPreCheckUpdate is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifFrequentFlyerTSAPreCheckUpdate() {
        return choiceSelect == FREQUENT_FLYER_TSA_PRE_CHECK_UPDATE_CHOICE;
    }

    /** 
     * Get the 'FrequentFlyerTSAPreCheckUpdate' element value.
     * 
     * @return value
     */
    public FrequentFlyerTSAPreCheckUpdatePNRB getFrequentFlyerTSAPreCheckUpdate() {
        return frequentFlyerTSAPreCheckUpdate;
    }

    /** 
     * Set the 'FrequentFlyerTSAPreCheckUpdate' element value.
     * 
     * @param frequentFlyerTSAPreCheckUpdate
     */
    public void setFrequentFlyerTSAPreCheckUpdate(
            FrequentFlyerTSAPreCheckUpdatePNRB frequentFlyerTSAPreCheckUpdate) {
        setChoiceSelect(FREQUENT_FLYER_TSA_PRE_CHECK_UPDATE_CHOICE);
        this.frequentFlyerTSAPreCheckUpdate = frequentFlyerTSAPreCheckUpdate;
    }

    /** 
     * Check if ProductUpdate is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifProductUpdate() {
        return choiceSelect == PRODUCT_UPDATE_CHOICE;
    }

    /** 
     * Get the 'ProductUpdate' element value.
     * 
     * @return value
     */
    public ProductUpdatePNRB getProductUpdate() {
        return productUpdate;
    }

    /** 
     * Set the 'ProductUpdate' element value.
     * 
     * @param productUpdate
     */
    public void setProductUpdate(ProductUpdatePNRB productUpdate) {
        setChoiceSelect(PRODUCT_UPDATE_CHOICE);
        this.productUpdate = productUpdate;
    }

    /** 
     * Check if PhoneNumberUpdate is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPhoneNumberUpdate() {
        return choiceSelect == PHONE_NUMBER_UPDATE_CHOICE;
    }

    /** 
     * Get the 'PhoneNumberUpdate' element value.
     * 
     * @return value
     */
    public PhoneNumberUpdatePNRB getPhoneNumberUpdate() {
        return phoneNumberUpdate;
    }

    /** 
     * Set the 'PhoneNumberUpdate' element value.
     * 
     * @param phoneNumberUpdate
     */
    public void setPhoneNumberUpdate(PhoneNumberUpdatePNRB phoneNumberUpdate) {
        setChoiceSelect(PHONE_NUMBER_UPDATE_CHOICE);
        this.phoneNumberUpdate = phoneNumberUpdate;
    }

    /** 
     * Check if PhoneNumberPartialUpdate is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPhoneNumberPartialUpdate() {
        return choiceSelect == PHONE_NUMBER_PARTIAL_UPDATE_CHOICE;
    }

    /** 
     * Get the 'PhoneNumberPartialUpdate' element value.
     * 
     * @return value
     */
    public PhoneNumberPartialUpdatePNRB getPhoneNumberPartialUpdate() {
        return phoneNumberPartialUpdate;
    }

    /** 
     * Set the 'PhoneNumberPartialUpdate' element value.
     * 
     * @param phoneNumberPartialUpdate
     */
    public void setPhoneNumberPartialUpdate(
            PhoneNumberPartialUpdatePNRB phoneNumberPartialUpdate) {
        setChoiceSelect(PHONE_NUMBER_PARTIAL_UPDATE_CHOICE);
        this.phoneNumberPartialUpdate = phoneNumberPartialUpdate;
    }

    /** 
     * Check if OpenReservationElementUpdate is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOpenReservationElementUpdate() {
        return choiceSelect == OPEN_RESERVATION_ELEMENT_UPDATE_CHOICE;
    }

    /** 
     * Get the 'OpenReservationElementUpdate' element value.
     * 
     * @return value
     */
    public OpenReservationElementUpdatePNRB getOpenReservationElementUpdate() {
        return openReservationElementUpdate;
    }

    /** 
     * Set the 'OpenReservationElementUpdate' element value.
     * 
     * @param openReservationElementUpdate
     */
    public void setOpenReservationElementUpdate(
            OpenReservationElementUpdatePNRB openReservationElementUpdate) {
        setChoiceSelect(OPEN_RESERVATION_ELEMENT_UPDATE_CHOICE);
        this.openReservationElementUpdate = openReservationElementUpdate;
    }

    /** 
     * Check if DKNumber is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDKNumber() {
        return choiceSelect == DK_NUMBER_CHOICE;
    }

    /** 
     * Get the 'DKNumber' element value.
     * 
     * @return value
     */
    public DKNumberPNRB getDKNumber() {
        return DKNumber;
    }

    /** 
     * Set the 'DKNumber' element value.
     * 
     * @param DKNumber
     */
    public void setDKNumber(DKNumberPNRB DKNumber) {
        setChoiceSelect(DK_NUMBER_CHOICE);
        this.DKNumber = DKNumber;
    }

    /** 
     * Check if OtherServiceInformationList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOtherServiceInformationList() {
        return choiceSelect == OTHER_SERVICE_INFORMATION_LIST_CHOICE;
    }

    /** 
     * Get the list of 'OtherServiceInformation' element items.
     * 
     * @return list
     */
    public List<OtherServiceInformationPNRB> getOtherServiceInformationList() {
        return otherServiceInformationList;
    }

    /** 
     * Set the list of 'OtherServiceInformation' element items.
     * 
     * @param list
     */
    public void setOtherServiceInformationList(
            List<OtherServiceInformationPNRB> list) {
        setChoiceSelect(OTHER_SERVICE_INFORMATION_LIST_CHOICE);
        otherServiceInformationList = list;
    }

    /** 
     * Check if AccountingLineList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAccountingLineList() {
        return choiceSelect == ACCOUNTING_LINE_LIST_CHOICE;
    }

    /** 
     * Get the list of 'AccountingLine' element items.
     * 
     * @return list
     */
    public List<AccountingLinePNRB> getAccountingLineList() {
        return accountingLineList;
    }

    /** 
     * Set the list of 'AccountingLine' element items.
     * 
     * @param list
     */
    public void setAccountingLineList(List<AccountingLinePNRB> list) {
        setChoiceSelect(ACCOUNTING_LINE_LIST_CHOICE);
        accountingLineList = list;
    }

    /** 
     * Check if DescriptiveBillingInfoList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDescriptiveBillingInfoList() {
        return choiceSelect == DESCRIPTIVE_BILLING_INFO_LIST_CHOICE;
    }

    /** 
     * Get the list of 'DescriptiveBillingInfo' element items.
     * 
     * @return list
     */
    public List<DescriptiveBillingInfoPNRB> getDescriptiveBillingInfoList() {
        return descriptiveBillingInfoList;
    }

    /** 
     * Set the list of 'DescriptiveBillingInfo' element items.
     * 
     * @param list
     */
    public void setDescriptiveBillingInfoList(
            List<DescriptiveBillingInfoPNRB> list) {
        setChoiceSelect(DESCRIPTIVE_BILLING_INFO_LIST_CHOICE);
        descriptiveBillingInfoList = list;
    }

    /** 
     * Check if AirSegmentPartialUpdate is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAirSegmentPartialUpdate() {
        return choiceSelect == AIR_SEGMENT_PARTIAL_UPDATE_CHOICE;
    }

    /** 
     * Get the 'AirSegmentPartialUpdate' element value.
     * 
     * @return value
     */
    public AirSegmentPartialUpdatePNRB getAirSegmentPartialUpdate() {
        return airSegmentPartialUpdate;
    }

    /** 
     * Set the 'AirSegmentPartialUpdate' element value.
     * 
     * @param airSegmentPartialUpdate
     */
    public void setAirSegmentPartialUpdate(
            AirSegmentPartialUpdatePNRB airSegmentPartialUpdate) {
        setChoiceSelect(AIR_SEGMENT_PARTIAL_UPDATE_CHOICE);
        this.airSegmentPartialUpdate = airSegmentPartialUpdate;
    }

    /** 
     * Check if AirItineraryUpdate is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAirItineraryUpdate() {
        return choiceSelect == AIR_ITINERARY_UPDATE_CHOICE;
    }

    /** 
     * Get the 'AirItineraryUpdate' element value.
     * 
     * @return value
     */
    public AirItineraryUpdatePNRB getAirItineraryUpdate() {
        return airItineraryUpdate;
    }

    /** 
     * Set the 'AirItineraryUpdate' element value.
     * 
     * @param airItineraryUpdate
     */
    public void setAirItineraryUpdate(AirItineraryUpdatePNRB airItineraryUpdate) {
        setChoiceSelect(AIR_ITINERARY_UPDATE_CHOICE);
        this.airItineraryUpdate = airItineraryUpdate;
    }

    /** 
     * Check if GeneralSegmentUpdate is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifGeneralSegmentUpdate() {
        return choiceSelect == GENERAL_SEGMENT_UPDATE_CHOICE;
    }

    /** 
     * Get the 'GeneralSegmentUpdate' element value.
     * 
     * @return value
     */
    public GeneralSegmentUpdatePNRB getGeneralSegmentUpdate() {
        return generalSegmentUpdate;
    }

    /** 
     * Set the 'GeneralSegmentUpdate' element value.
     * 
     * @param generalSegmentUpdate
     */
    public void setGeneralSegmentUpdate(
            GeneralSegmentUpdatePNRB generalSegmentUpdate) {
        setChoiceSelect(GENERAL_SEGMENT_UPDATE_CHOICE);
        this.generalSegmentUpdate = generalSegmentUpdate;
    }

    /** 
     * Check if CarrierRefundItem is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCarrierRefundItem() {
        return choiceSelect == CARRIER_REFUND_ITEM_CHOICE;
    }

    /** 
     * Get the 'CarrierRefundItem' element value.
     * 
     * @return value
     */
    public CarrierRefundItemPNRB getCarrierRefundItem() {
        return carrierRefundItem;
    }

    /** 
     * Set the 'CarrierRefundItem' element value.
     * 
     * @param carrierRefundItem
     */
    public void setCarrierRefundItem(CarrierRefundItemPNRB carrierRefundItem) {
        setChoiceSelect(CARRIER_REFUND_ITEM_CHOICE);
        this.carrierRefundItem = carrierRefundItem;
    }

    /** 
     * Check if HeaderUpdateItem is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifHeaderUpdateItem() {
        return choiceSelect == HEADER_UPDATE_ITEM_CHOICE;
    }

    /** 
     * Get the 'HeaderUpdateItem' element value.
     * 
     * @return value
     */
    public HeaderUpdateItemPNRB getHeaderUpdateItem() {
        return headerUpdateItem;
    }

    /** 
     * Set the 'HeaderUpdateItem' element value.
     * 
     * @param headerUpdateItem
     */
    public void setHeaderUpdateItem(HeaderUpdateItemPNRB headerUpdateItem) {
        setChoiceSelect(HEADER_UPDATE_ITEM_CHOICE);
        this.headerUpdateItem = headerUpdateItem;
    }

    /** 
     * Check if AssociationMatrixUpdate is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAssociationMatrixUpdate() {
        return choiceSelect == ASSOCIATION_MATRIX_UPDATE_CHOICE;
    }

    /** 
     * Get the 'AssociationMatrixUpdate' element value.
     * 
     * @return value
     */
    public AssociationMatrixUpdatePNRB getAssociationMatrixUpdate() {
        return associationMatrixUpdate;
    }

    /** 
     * Set the 'AssociationMatrixUpdate' element value.
     * 
     * @param associationMatrixUpdate
     */
    public void setAssociationMatrixUpdate(
            AssociationMatrixUpdatePNRB associationMatrixUpdate) {
        setChoiceSelect(ASSOCIATION_MATRIX_UPDATE_CHOICE);
        this.associationMatrixUpdate = associationMatrixUpdate;
    }

    /** 
     * Check if PreReservedSeatUpdate is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPreReservedSeatUpdate() {
        return choiceSelect == PRE_RESERVED_SEAT_UPDATE_CHOICE;
    }

    /** 
     * Get the 'PreReservedSeatUpdate' element value.
     * 
     * @return value
     */
    public PreReservedSeatUpdatePNRB getPreReservedSeatUpdate() {
        return preReservedSeatUpdate;
    }

    /** 
     * Set the 'PreReservedSeatUpdate' element value.
     * 
     * @param preReservedSeatUpdate
     */
    public void setPreReservedSeatUpdate(
            PreReservedSeatUpdatePNRB preReservedSeatUpdate) {
        setChoiceSelect(PRE_RESERVED_SEAT_UPDATE_CHOICE);
        this.preReservedSeatUpdate = preReservedSeatUpdate;
    }

    /** 
     * Check if TicketingInfoUpdate is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTicketingInfoUpdate() {
        return choiceSelect == TICKETING_INFO_UPDATE_CHOICE;
    }

    /** 
     * Get the 'TicketingInfoUpdate' element value.
     * 
     * @return value
     */
    public TicketingInfo getTicketingInfoUpdate() {
        return ticketingInfoUpdate;
    }

    /** 
     * Set the 'TicketingInfoUpdate' element value.
     * 
     * @param ticketingInfoUpdate
     */
    public void setTicketingInfoUpdate(TicketingInfo ticketingInfoUpdate) {
        setChoiceSelect(TICKETING_INFO_UPDATE_CHOICE);
        this.ticketingInfoUpdate = ticketingInfoUpdate;
    }

    /** 
     * Check if BookAndHold is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifBookAndHold() {
        return choiceSelect == BOOK_AND_HOLD_CHOICE;
    }

    /** 
     * Get the 'BookAndHold' element value.
     * 
     * @return value
     */
    public BookAndHoldTypePNRB getBookAndHold() {
        return bookAndHold;
    }

    /** 
     * Set the 'BookAndHold' element value.
     * 
     * @param bookAndHold
     */
    public void setBookAndHold(BookAndHoldTypePNRB bookAndHold) {
        setChoiceSelect(BOOK_AND_HOLD_CHOICE);
        this.bookAndHold = bookAndHold;
    }

    /** 
     * Check if OpenReservationAction is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOpenReservationAction() {
        return choiceSelect == OPEN_RESERVATION_ACTION_CHOICE;
    }

    /** 
     * Get the 'OpenReservationAction' element value.
     * 
     * @return value
     */
    public OpenReservationAction getOpenReservationAction() {
        return openReservationAction;
    }

    /** 
     * Set the 'OpenReservationAction' element value.
     * 
     * @param openReservationAction
     */
    public void setOpenReservationAction(
            OpenReservationAction openReservationAction) {
        setChoiceSelect(OPEN_RESERVATION_ACTION_CHOICE);
        this.openReservationAction = openReservationAction;
    }

    /** 
     * Check if TicketingHistory is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTicketingHistory() {
        return choiceSelect == TICKETING_HISTORY_CHOICE;
    }

    /** 
     * Get the 'TicketingHistory' element value. Adding a ticket history through reservation orchestration
     * 
     * @return value
     */
    public TicketingHistoryTypePNRB getTicketingHistory() {
        return ticketingHistory;
    }

    /** 
     * Set the 'TicketingHistory' element value. Adding a ticket history through reservation orchestration
     * 
     * @param ticketingHistory
     */
    public void setTicketingHistory(TicketingHistoryTypePNRB ticketingHistory) {
        setChoiceSelect(TICKETING_HISTORY_CHOICE);
        this.ticketingHistory = ticketingHistory;
    }

    /** 
     * Get the 'UpdateId' attribute value.
     * 
     * @return value
     */
    public String getUpdateId() {
        return updateId;
    }

    /** 
     * Set the 'UpdateId' attribute value.
     * 
     * @param updateId
     */
    public void setUpdateId(String updateId) {
        this.updateId = updateId;
    }
}
