
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReservationUpdateListType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:LocatorWithPartitionType" name="Locator" minOccurs="0"/>
 *     &lt;xs:element type="xs:date" name="CreateDate" minOccurs="0"/>
 *     &lt;xs:choice minOccurs="0">
 *       &lt;!-- Reference to inner class Choice -->
 *     &lt;/xs:choice>
 *     &lt;xs:element type="ns:ReceivedFrom.PNRB" name="ReceivedFrom" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ReservationUpdateListType implements Serializable
{
    private LocatorWithPartitionType locator;
    private Date createDate;
    private Choice choice;
    private ReceivedFromPNRB receivedFrom;

    /** 
     * Get the 'Locator' element value.
     * 
     * @return value
     */
    public LocatorWithPartitionType getLocator() {
        return locator;
    }

    /** 
     * Set the 'Locator' element value.
     * 
     * @param locator
     */
    public void setLocator(LocatorWithPartitionType locator) {
        this.locator = locator;
    }

    /** 
     * Get the 'CreateDate' element value. PNR creation date that is used as part of PNR identifier (both active and
                          inactive PNRs)
                      
     * 
     * @return value
     */
    public Date getCreateDate() {
        return createDate;
    }

    /** 
     * Set the 'CreateDate' element value. PNR creation date that is used as part of PNR identifier (both active and
                          inactive PNRs)
                      
     * 
     * @param createDate
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /** 
     * Get the choice value.
     * 
     * @return value
     */
    public Choice getChoice() {
        return choice;
    }

    /** 
     * Set the choice value.
     * 
     * @param choice
     */
    public void setChoice(Choice choice) {
        this.choice = choice;
    }

    /** 
     * Get the 'ReceivedFrom' element value.
     * 
     * @return value
     */
    public ReceivedFromPNRB getReceivedFrom() {
        return receivedFrom;
    }

    /** 
     * Set the 'ReceivedFrom' element value.
     * 
     * @param receivedFrom
     */
    public void setReceivedFrom(ReceivedFromPNRB receivedFrom) {
        this.receivedFrom = receivedFrom;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
     *   &lt;xs:element type="ns:ReservationUpdateItemType" name="ReservationUpdateItem" maxOccurs="unbounded"/>
     *   &lt;xs:element type="ns:ChangeNbrInPartyType.PNRB" name="ChangeNbrInParty"/>
     *   &lt;xs:element type="ns:LinearEntryRequestType.PNRB" name="LinearEntryRequest"/>
     *   &lt;xs:element type="ns:GMRUpdateType.PNRB" name="GMRUpdate" minOccurs="0"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceSelect = -1;
        private static final int RESERVATION_UPDATE_ITEM_LIST_CHOICE = 0;
        private static final int CHANGE_NBR_IN_PARTY_CHOICE = 1;
        private static final int LINEAR_ENTRY_REQUEST_CHOICE = 2;
        private static final int GMR_UPDATE_CHOICE = 3;
        private List<ReservationUpdateItemType> reservationUpdateItemList = new ArrayList<ReservationUpdateItemType>();
        private ChangeNbrInPartyTypePNRB changeNbrInParty;
        private LinearEntryRequestTypePNRB linearEntryRequest;
        private GMRUpdateTypePNRB GMRUpdate;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if ReservationUpdateItemList is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifReservationUpdateItemList() {
            return choiceSelect == RESERVATION_UPDATE_ITEM_LIST_CHOICE;
        }

        /** 
         * Get the list of 'ReservationUpdateItem' element items.
         * 
         * @return list
         */
        public List<ReservationUpdateItemType> getReservationUpdateItemList() {
            return reservationUpdateItemList;
        }

        /** 
         * Set the list of 'ReservationUpdateItem' element items.
         * 
         * @param list
         */
        public void setReservationUpdateItemList(
                List<ReservationUpdateItemType> list) {
            setChoiceSelect(RESERVATION_UPDATE_ITEM_LIST_CHOICE);
            reservationUpdateItemList = list;
        }

        /** 
         * Check if ChangeNbrInParty is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifChangeNbrInParty() {
            return choiceSelect == CHANGE_NBR_IN_PARTY_CHOICE;
        }

        /** 
         * Get the 'ChangeNbrInParty' element value.
         * 
         * @return value
         */
        public ChangeNbrInPartyTypePNRB getChangeNbrInParty() {
            return changeNbrInParty;
        }

        /** 
         * Set the 'ChangeNbrInParty' element value.
         * 
         * @param changeNbrInParty
         */
        public void setChangeNbrInParty(
                ChangeNbrInPartyTypePNRB changeNbrInParty) {
            setChoiceSelect(CHANGE_NBR_IN_PARTY_CHOICE);
            this.changeNbrInParty = changeNbrInParty;
        }

        /** 
         * Check if LinearEntryRequest is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifLinearEntryRequest() {
            return choiceSelect == LINEAR_ENTRY_REQUEST_CHOICE;
        }

        /** 
         * Get the 'LinearEntryRequest' element value. Linear entry requests such as CKS* coming from Terminal Gateway, restricted
                                for internal use
                            
         * 
         * @return value
         */
        public LinearEntryRequestTypePNRB getLinearEntryRequest() {
            return linearEntryRequest;
        }

        /** 
         * Set the 'LinearEntryRequest' element value. Linear entry requests such as CKS* coming from Terminal Gateway, restricted
                                for internal use
                            
         * 
         * @param linearEntryRequest
         */
        public void setLinearEntryRequest(
                LinearEntryRequestTypePNRB linearEntryRequest) {
            setChoiceSelect(LINEAR_ENTRY_REQUEST_CHOICE);
            this.linearEntryRequest = linearEntryRequest;
        }

        /** 
         * Check if GMRUpdate is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifGMRUpdate() {
            return choiceSelect == GMR_UPDATE_CHOICE;
        }

        /** 
         * Get the 'GMRUpdate' element value.
         * 
         * @return value
         */
        public GMRUpdateTypePNRB getGMRUpdate() {
            return GMRUpdate;
        }

        /** 
         * Set the 'GMRUpdate' element value.
         * 
         * @param GMRUpdate
         */
        public void setGMRUpdate(GMRUpdateTypePNRB GMRUpdate) {
            setChoiceSelect(GMR_UPDATE_CHOICE);
            this.GMRUpdate = GMRUpdate;
        }
    }
}
