
package com.sabre.webservices.pnrbuilder.v119;

import com.sabre.services.res.or.v114.OpenReservationElementType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Results.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Request" minOccurs="0">
 *       &lt;!-- Reference to inner class Request -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="UpdateResult" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class UpdateResult -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ResultsPNRB implements Serializable
{
    private Request request;
    private List<UpdateResult> updateResultList = new ArrayList<UpdateResult>();

    /** 
     * Get the 'Request' element value.
     * 
     * @return value
     */
    public Request getRequest() {
        return request;
    }

    /** 
     * Set the 'Request' element value.
     * 
     * @param request
     */
    public void setRequest(Request request) {
        this.request = request;
    }

    /** 
     * Get the list of 'UpdateResult' element items.
     * 
     * @return list
     */
    public List<UpdateResult> getUpdateResultList() {
        return updateResultList;
    }

    /** 
     * Set the list of 'UpdateResult' element items.
     * 
     * @param list
     */
    public void setUpdateResultList(List<UpdateResult> list) {
        updateResultList = list;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Request" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:base64Binary" name="fragment" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Request implements Serializable
    {
        private List<byte[]> fragmentList = new ArrayList<byte[]>();

        /** 
         * Get the list of 'fragment' element items.
         * 
         * @return list
         */
        public List<byte[]> getFragmentList() {
            return fragmentList;
        }

        /** 
         * Set the list of 'fragment' element items.
         * 
         * @param list
         */
        public void setFragmentList(List<byte[]> list) {
            fragmentList = list;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UpdateResult" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Item" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Item -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="optional" name="UpdateId"/>
     *     &lt;xs:attribute type="xs:string" name="Status"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class UpdateResult implements Serializable
    {
        private List<Item> itemList = new ArrayList<Item>();
        private String updateId;
        private String status;

        /** 
         * Get the list of 'Item' element items.
         * 
         * @return list
         */
        public List<Item> getItemList() {
            return itemList;
        }

        /** 
         * Set the list of 'Item' element items.
         * 
         * @param list
         */
        public void setItemList(List<Item> list) {
            itemList = list;
        }

        /** 
         * Get the 'UpdateId' attribute value.
         * 
         * @return value
         */
        public String getUpdateId() {
            return updateId;
        }

        /** 
         * Set the 'UpdateId' attribute value.
         * 
         * @param updateId
         */
        public void setUpdateId(String updateId) {
            this.updateId = updateId;
        }

        /** 
         * Get the 'Status' attribute value. Success, Failure
         * 
         * @return value
         */
        public String getStatus() {
            return status;
        }

        /** 
         * Set the 'Status' attribute value. Success, Failure
         * 
         * @param status
         */
        public void setStatus(String status) {
            this.status = status;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:ns1="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Item" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="AncillaryServicePricing" minOccurs="0">
         *         &lt;!-- Reference to inner class AncillaryServicePricing -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="ns1:OpenReservationElementType" name="OpenReservationElement" minOccurs="0"/>
         *       &lt;xs:element type="ns:AirType" name="AirSegment" minOccurs="0"/>
         *       &lt;xs:element type="ns:RefundResult.PNRB" name="RefundResult" minOccurs="0"/>
         *       &lt;xs:element name="BookAndHoldResult" minOccurs="0" maxOccurs="1">
         *         &lt;!-- Reference to inner class BookAndHoldResult -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="optional" name="id"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="type"/>
         *     &lt;xs:attribute type="ns:OperationType.PNRB" use="optional" name="op"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Item implements Serializable
        {
            private AncillaryServicePricing ancillaryServicePricing;
            private OpenReservationElementType openReservationElement;
            private AirType airSegment;
            private RefundResultPNRB refundResult;
            private BookAndHoldResult bookAndHoldResult;
            private String id;
            private String type;
            private OperationTypePNRB op;

            /** 
             * Get the 'AncillaryServicePricing' element value.
             * 
             * @return value
             */
            public AncillaryServicePricing getAncillaryServicePricing() {
                return ancillaryServicePricing;
            }

            /** 
             * Set the 'AncillaryServicePricing' element value.
             * 
             * @param ancillaryServicePricing
             */
            public void setAncillaryServicePricing(
                    AncillaryServicePricing ancillaryServicePricing) {
                this.ancillaryServicePricing = ancillaryServicePricing;
            }

            /** 
             * Get the 'OpenReservationElement' element value. Result of psh processing of linear entry requests such as
                                                      CKS*
                                                  
             * 
             * @return value
             */
            public OpenReservationElementType getOpenReservationElement() {
                return openReservationElement;
            }

            /** 
             * Set the 'OpenReservationElement' element value. Result of psh processing of linear entry requests such as
                                                      CKS*
                                                  
             * 
             * @param openReservationElement
             */
            public void setOpenReservationElement(
                    OpenReservationElementType openReservationElement) {
                this.openReservationElement = openReservationElement;
            }

            /** 
             * Get the 'AirSegment' element value. Result of air segment sell
             * 
             * @return value
             */
            public AirType getAirSegment() {
                return airSegment;
            }

            /** 
             * Set the 'AirSegment' element value. Result of air segment sell
             * 
             * @param airSegment
             */
            public void setAirSegment(AirType airSegment) {
                this.airSegment = airSegment;
            }

            /** 
             * Get the 'RefundResult' element value.
             * 
             * @return value
             */
            public RefundResultPNRB getRefundResult() {
                return refundResult;
            }

            /** 
             * Set the 'RefundResult' element value.
             * 
             * @param refundResult
             */
            public void setRefundResult(RefundResultPNRB refundResult) {
                this.refundResult = refundResult;
            }

            /** 
             * Get the 'BookAndHoldResult' element value.
             * 
             * @return value
             */
            public BookAndHoldResult getBookAndHoldResult() {
                return bookAndHoldResult;
            }

            /** 
             * Set the 'BookAndHoldResult' element value.
             * 
             * @param bookAndHoldResult
             */
            public void setBookAndHoldResult(BookAndHoldResult bookAndHoldResult) {
                this.bookAndHoldResult = bookAndHoldResult;
            }

            /** 
             * Get the 'id' attribute value.
             * 
             * @return value
             */
            public String getId() {
                return id;
            }

            /** 
             * Set the 'id' attribute value.
             * 
             * @param id
             */
            public void setId(String id) {
                this.id = id;
            }

            /** 
             * Get the 'type' attribute value.
             * 
             * @return value
             */
            public String getType() {
                return type;
            }

            /** 
             * Set the 'type' attribute value.
             * 
             * @param type
             */
            public void setType(String type) {
                this.type = type;
            }

            /** 
             * Get the 'op' attribute value.
             * 
             * @return value
             */
            public OperationTypePNRB getOp() {
                return op;
            }

            /** 
             * Set the 'op' attribute value.
             * 
             * @param op
             */
            public void setOp(OperationTypePNRB op) {
                this.op = op;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AncillaryServicePricing" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:AncillaryPrice.PNRB" name="OriginalBasePrice" minOccurs="0"/>
             *       &lt;xs:element type="ns:AncillaryPrice.PNRB" name="EquivalentPrice" minOccurs="0"/>
             *       &lt;xs:element name="Taxes" minOccurs="0">
             *         &lt;!-- Reference to inner class Taxes -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="ns:AncillaryPrice.PNRB" name="TTLPrice"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AncillaryServicePricing implements Serializable
            {
                private AncillaryPricePNRB originalBasePrice;
                private AncillaryPricePNRB equivalentPrice;
                private Taxes taxes;
                private AncillaryPricePNRB TTLPrice;

                /** 
                 * Get the 'OriginalBasePrice' element value.
                 * 
                 * @return value
                 */
                public AncillaryPricePNRB getOriginalBasePrice() {
                    return originalBasePrice;
                }

                /** 
                 * Set the 'OriginalBasePrice' element value.
                 * 
                 * @param originalBasePrice
                 */
                public void setOriginalBasePrice(
                        AncillaryPricePNRB originalBasePrice) {
                    this.originalBasePrice = originalBasePrice;
                }

                /** 
                 * Get the 'EquivalentPrice' element value.
                 * 
                 * @return value
                 */
                public AncillaryPricePNRB getEquivalentPrice() {
                    return equivalentPrice;
                }

                /** 
                 * Set the 'EquivalentPrice' element value.
                 * 
                 * @param equivalentPrice
                 */
                public void setEquivalentPrice(
                        AncillaryPricePNRB equivalentPrice) {
                    this.equivalentPrice = equivalentPrice;
                }

                /** 
                 * Get the 'Taxes' element value.
                 * 
                 * @return value
                 */
                public Taxes getTaxes() {
                    return taxes;
                }

                /** 
                 * Set the 'Taxes' element value.
                 * 
                 * @param taxes
                 */
                public void setTaxes(Taxes taxes) {
                    this.taxes = taxes;
                }

                /** 
                 * Get the 'TTLPrice' element value.
                 * 
                 * @return value
                 */
                public AncillaryPricePNRB getTTLPrice() {
                    return TTLPrice;
                }

                /** 
                 * Set the 'TTLPrice' element value.
                 * 
                 * @param TTLPrice
                 */
                public void setTTLPrice(AncillaryPricePNRB TTLPrice) {
                    this.TTLPrice = TTLPrice;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="ns:AncillaryTax.PNRB" name="Tax" minOccurs="0" maxOccurs="99"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Taxes implements Serializable
                {
                    private List<AncillaryTaxPNRB> taxList = new ArrayList<AncillaryTaxPNRB>();

                    /** 
                     * Get the list of 'Tax' element items.
                     * 
                     * @return list
                     */
                    public List<AncillaryTaxPNRB> getTaxList() {
                        return taxList;
                    }

                    /** 
                     * Set the list of 'Tax' element items.
                     * 
                     * @param list
                     */
                    public void setTaxList(List<AncillaryTaxPNRB> list) {
                        taxList = list;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BookAndHoldResult" minOccurs="0" maxOccurs="1">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="AirlineCode"/>
             *       &lt;xs:element name="Status">
             *         &lt;xs:complexType>
             *           &lt;xs:simpleContent>
             *             &lt;xs:extension base="xs:string">
             *               &lt;xs:attribute type="xs:string" use="optional" name="message"/>
             *             &lt;/xs:extension>
             *           &lt;/xs:simpleContent>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class BookAndHoldResult implements Serializable
            {
                private String airlineCode;
                private String statusString;
                private String statusMessage;

                /** 
                 * Get the 'AirlineCode' element value.
                 * 
                 * @return value
                 */
                public String getAirlineCode() {
                    return airlineCode;
                }

                /** 
                 * Set the 'AirlineCode' element value.
                 * 
                 * @param airlineCode
                 */
                public void setAirlineCode(String airlineCode) {
                    this.airlineCode = airlineCode;
                }

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getStatusString() {
                    return statusString;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param statusString
                 */
                public void setStatusString(String statusString) {
                    this.statusString = statusString;
                }

                /** 
                 * Get the 'message' attribute value. Additional information of the
                                                                                    holding result
                                                                                
                 * 
                 * @return value
                 */
                public String getStatusMessage() {
                    return statusMessage;
                }

                /** 
                 * Set the 'message' attribute value. Additional information of the
                                                                                    holding result
                                                                                
                 * 
                 * @param statusMessage
                 */
                public void setStatusMessage(String statusMessage) {
                    this.statusMessage = statusMessage;
                }
            }
        }
    }
}
