
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecialServiceRequestUpdate.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:NameAssociationList.PNRB" name="NameAssociationList" minOccurs="0"/>
 *     &lt;xs:element type="ns:SegmentAssociationList.PNRB" name="SegmentAssociationList" minOccurs="0"/>
 *     &lt;xs:choice minOccurs="0">
 *       &lt;!-- Reference to inner class Choice -->
 *     &lt;/xs:choice>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="id"/>
 *   &lt;xs:attribute type="ns:OperationType.PNRB" name="op"/>
 *   &lt;xs:attribute type="ns:FactType.PNRB" default="H" name="type"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SpecialServiceRequestUpdatePNRB implements Serializable
{
    private NameAssociationListPNRB nameAssociationList;
    private SegmentAssociationListPNRB segmentAssociationList;
    private Choice choice;
    private String id;
    private OperationTypePNRB op;
    private FactTypePNRB type;

    /** 
     * Get the 'NameAssociationList' element value.
     * 
     * @return value
     */
    public NameAssociationListPNRB getNameAssociationList() {
        return nameAssociationList;
    }

    /** 
     * Set the 'NameAssociationList' element value.
     * 
     * @param nameAssociationList
     */
    public void setNameAssociationList(
            NameAssociationListPNRB nameAssociationList) {
        this.nameAssociationList = nameAssociationList;
    }

    /** 
     * Get the 'SegmentAssociationList' element value.
     * 
     * @return value
     */
    public SegmentAssociationListPNRB getSegmentAssociationList() {
        return segmentAssociationList;
    }

    /** 
     * Set the 'SegmentAssociationList' element value.
     * 
     * @param segmentAssociationList
     */
    public void setSegmentAssociationList(
            SegmentAssociationListPNRB segmentAssociationList) {
        this.segmentAssociationList = segmentAssociationList;
    }

    /** 
     * Get the choice value.
     * 
     * @return value
     */
    public Choice getChoice() {
        return choice;
    }

    /** 
     * Set the choice value.
     * 
     * @param choice
     */
    public void setChoice(Choice choice) {
        this.choice = choice;
    }

    /** 
     * Get the 'id' attribute value.
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value.
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @return value
     */
    public OperationTypePNRB getOp() {
        return op;
    }

    /** 
     * Set the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @param op
     */
    public void setOp(OperationTypePNRB op) {
        this.op = op;
    }

    /** 
     * Get the 'type' attribute value. G = General, H = Hosted
     * 
     * @return value
     */
    public FactTypePNRB getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value. G = General, H = Hosted
     * 
     * @param type
     */
    public void setType(FactTypePNRB type) {
        this.type = type;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
     *   &lt;xs:element type="xs:string" name="SpecialServiceRequestText" minOccurs="0"/>
     *   &lt;xs:element type="ns:SpecialService.PNRB" name="SpecialService" minOccurs="0"/>
     *   &lt;xs:element type="ns:OSIRequest.PNRB" name="OtherSupplementaryInformation" minOccurs="0"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceSelect = -1;
        private static final int SPECIAL_SERVICE_REQUEST_TEXT_CHOICE = 0;
        private static final int SPECIAL_SERVICE_CHOICE = 1;
        private static final int OTHER_SUPPLEMENTARY_INFORMATION_CHOICE = 2;
        private String specialServiceRequestText;
        private SpecialServicePNRB specialService;
        private OSIRequestPNRB otherSupplementaryInformation;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if SpecialServiceRequestText is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifSpecialServiceRequestText() {
            return choiceSelect == SPECIAL_SERVICE_REQUEST_TEXT_CHOICE;
        }

        /** 
         * Get the 'SpecialServiceRequestText' element value.
         * 
         * @return value
         */
        public String getSpecialServiceRequestText() {
            return specialServiceRequestText;
        }

        /** 
         * Set the 'SpecialServiceRequestText' element value.
         * 
         * @param specialServiceRequestText
         */
        public void setSpecialServiceRequestText(
                String specialServiceRequestText) {
            setChoiceSelect(SPECIAL_SERVICE_REQUEST_TEXT_CHOICE);
            this.specialServiceRequestText = specialServiceRequestText;
        }

        /** 
         * Check if SpecialService is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifSpecialService() {
            return choiceSelect == SPECIAL_SERVICE_CHOICE;
        }

        /** 
         * Get the 'SpecialService' element value.
         * 
         * @return value
         */
        public SpecialServicePNRB getSpecialService() {
            return specialService;
        }

        /** 
         * Set the 'SpecialService' element value.
         * 
         * @param specialService
         */
        public void setSpecialService(SpecialServicePNRB specialService) {
            setChoiceSelect(SPECIAL_SERVICE_CHOICE);
            this.specialService = specialService;
        }

        /** 
         * Check if OtherSupplementaryInformation is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifOtherSupplementaryInformation() {
            return choiceSelect == OTHER_SUPPLEMENTARY_INFORMATION_CHOICE;
        }

        /** 
         * Get the 'OtherSupplementaryInformation' element value.
         * 
         * @return value
         */
        public OSIRequestPNRB getOtherSupplementaryInformation() {
            return otherSupplementaryInformation;
        }

        /** 
         * Set the 'OtherSupplementaryInformation' element value.
         * 
         * @param otherSupplementaryInformation
         */
        public void setOtherSupplementaryInformation(
                OSIRequestPNRB otherSupplementaryInformation) {
            setChoiceSelect(OTHER_SUPPLEMENTARY_INFORMATION_CHOICE);
            this.otherSupplementaryInformation = otherSupplementaryInformation;
        }
    }
}
