
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Ticketing information must be entered before the PNR can be finalized.

 The ticketing field (7) has a maximum of 71 characters starting with the
 7, regardless of the entry or character combination used.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketingInfo.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:FutureTicketing.PNRB" name="FutureTicketing" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:TicketingTimeLimit.PNRB" name="TicketingTimeLimit" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:TourTicketing.PNRB" name="TourTicketing" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:AlreadyTicketed.PNRB" name="AlreadyTicketed" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:ETicketNumberType" name="ETicketNumber" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:TicketDetailsType" name="TicketDetails" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:VCRAssociationDetailsType" name="VCRAssociationDetails" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TicketingInfoPNRB implements Serializable
{
    private List<FutureTicketingPNRB> futureTicketingList = new ArrayList<FutureTicketingPNRB>();
    private List<TicketingTimeLimitPNRB> ticketingTimeLimitList = new ArrayList<TicketingTimeLimitPNRB>();
    private List<TourTicketingPNRB> tourTicketingList = new ArrayList<TourTicketingPNRB>();
    private List<AlreadyTicketedPNRB> alreadyTicketedList = new ArrayList<AlreadyTicketedPNRB>();
    private List<ETicketNumberType> ETicketNumberList = new ArrayList<ETicketNumberType>();
    private List<TicketDetailsType> ticketDetailList = new ArrayList<TicketDetailsType>();
    private List<VCRAssociationDetailsType> VCRAssociationDetailList = new ArrayList<VCRAssociationDetailsType>();

    /** 
     * Get the list of 'FutureTicketing' element items.
     * 
     * @return list
     */
    public List<FutureTicketingPNRB> getFutureTicketingList() {
        return futureTicketingList;
    }

    /** 
     * Set the list of 'FutureTicketing' element items.
     * 
     * @param list
     */
    public void setFutureTicketingList(List<FutureTicketingPNRB> list) {
        futureTicketingList = list;
    }

    /** 
     * Get the list of 'TicketingTimeLimit' element items.
     * 
     * @return list
     */
    public List<TicketingTimeLimitPNRB> getTicketingTimeLimitList() {
        return ticketingTimeLimitList;
    }

    /** 
     * Set the list of 'TicketingTimeLimit' element items.
     * 
     * @param list
     */
    public void setTicketingTimeLimitList(List<TicketingTimeLimitPNRB> list) {
        ticketingTimeLimitList = list;
    }

    /** 
     * Get the list of 'TourTicketing' element items.
     * 
     * @return list
     */
    public List<TourTicketingPNRB> getTourTicketingList() {
        return tourTicketingList;
    }

    /** 
     * Set the list of 'TourTicketing' element items.
     * 
     * @param list
     */
    public void setTourTicketingList(List<TourTicketingPNRB> list) {
        tourTicketingList = list;
    }

    /** 
     * Get the list of 'AlreadyTicketed' element items.
     * 
     * @return list
     */
    public List<AlreadyTicketedPNRB> getAlreadyTicketedList() {
        return alreadyTicketedList;
    }

    /** 
     * Set the list of 'AlreadyTicketed' element items.
     * 
     * @param list
     */
    public void setAlreadyTicketedList(List<AlreadyTicketedPNRB> list) {
        alreadyTicketedList = list;
    }

    /** 
     * Get the list of 'ETicketNumber' element items.
     * 
     * @return list
     */
    public List<ETicketNumberType> getETicketNumberList() {
        return ETicketNumberList;
    }

    /** 
     * Set the list of 'ETicketNumber' element items.
     * 
     * @param list
     */
    public void setETicketNumberList(List<ETicketNumberType> list) {
        ETicketNumberList = list;
    }

    /** 
     * Get the list of 'TicketDetails' element items.
     * 
     * @return list
     */
    public List<TicketDetailsType> getTicketDetailList() {
        return ticketDetailList;
    }

    /** 
     * Set the list of 'TicketDetails' element items.
     * 
     * @param list
     */
    public void setTicketDetailList(List<TicketDetailsType> list) {
        ticketDetailList = list;
    }

    /** 
     * Get the list of 'VCRAssociationDetails' element items.
     * 
     * @return list
     */
    public List<VCRAssociationDetailsType> getVCRAssociationDetailList() {
        return VCRAssociationDetailList;
    }

    /** 
     * Set the list of 'VCRAssociationDetails' element items.
     * 
     * @param list
     */
    public void setVCRAssociationDetailList(List<VCRAssociationDetailsType> list) {
        VCRAssociationDetailList = list;
    }
}
