
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketingInstructionsInfo.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="TicketingInstruction" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class TicketingInstruction -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TicketingInstructionsInfoPNRB implements Serializable
{
    private List<TicketingInstruction> ticketingInstructionList = new ArrayList<TicketingInstruction>();

    /** 
     * Get the list of 'TicketingInstruction' element items.
     * 
     * @return list
     */
    public List<TicketingInstruction> getTicketingInstructionList() {
        return ticketingInstructionList;
    }

    /** 
     * Set the list of 'TicketingInstruction' element items.
     * 
     * @param list
     */
    public void setTicketingInstructionList(List<TicketingInstruction> list) {
        ticketingInstructionList = list;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketingInstruction" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" name="NameAssociation"/>
     *     &lt;xs:attribute type="xs:short" name="segmentAssociationId"/>
     *     &lt;xs:attribute type="xs:string" name="Text"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="Id"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TicketingInstruction implements Serializable
    {
        private String nameAssociation;
        private Short segmentAssociationId;
        private String text;
        private String id;

        /** 
         * Get the 'NameAssociation' attribute value. "NameAssociation" is the passenger name number to be associated with the ticket data in the PNR.
                                
         * 
         * @return value
         */
        public String getNameAssociation() {
            return nameAssociation;
        }

        /** 
         * Set the 'NameAssociation' attribute value. "NameAssociation" is the passenger name number to be associated with the ticket data in the PNR.
                                
         * 
         * @param nameAssociation
         */
        public void setNameAssociation(String nameAssociation) {
            this.nameAssociation = nameAssociation;
        }

        /** 
         * Get the 'segmentAssociationId' attribute value. Unique segment tab for the segment the association is processed.
         * 
         * @return value
         */
        public Short getSegmentAssociationId() {
            return segmentAssociationId;
        }

        /** 
         * Set the 'segmentAssociationId' attribute value. Unique segment tab for the segment the association is processed.
         * 
         * @param segmentAssociationId
         */
        public void setSegmentAssociationId(Short segmentAssociationId) {
            this.segmentAssociationId = segmentAssociationId;
        }

        /** 
         * Get the 'Text' attribute value. "Text" is used to pass back miscellaneous remark-related freetext.
                                
         * 
         * @return value
         */
        public String getText() {
            return text;
        }

        /** 
         * Set the 'Text' attribute value. "Text" is used to pass back miscellaneous remark-related freetext.
                                
         * 
         * @param text
         */
        public void setText(String text) {
            this.text = text;
        }

        /** 
         * Get the 'Id' attribute value.
         * 
         * @return value
         */
        public String getId() {
            return id;
        }

        /** 
         * Set the 'Id' attribute value.
         * 
         * @param id
         */
        public void setId(String id) {
            this.id = id;
        }
    }
}
