
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * * add ticketing time limit for future date and specify a
 downline city 8(downline city)-(carrier
 code)(time)(future date)

 8SEA-DL6P/17MAY

 * add ticketing time limit for today's date 8(downline
 city)-(carrier code)(time)

 8LON-BA6P

 * add ticketing time limit for American Airlines, assume
 today's date 8(time)

 84P

 * add ticketing time limit for American Airlines,
 specify date 8(time)(date)

 87P/09NOV

 * add ticketing time limit for American Airlines,
 indicate 30 minute time limit 830

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketingTimeLimit.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="DownlineCity" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CarrierCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Time" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FutureDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ThirtyMinuteInterval" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="id"/>
 *   &lt;xs:attribute type="xs:integer" name="index"/>
 *   &lt;xs:attribute type="ns:OperationType.PNRB" name="op"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="elementId"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TicketingTimeLimitPNRB implements Serializable
{
    private String downlineCity;
    private String carrierCode;
    private String time;
    private String futureDate;
    private String thirtyMinuteInterval;
    private String id;
    private BigInteger index;
    private OperationTypePNRB op;
    private String elementId;
    private String RPH;

    /** 
     * Get the 'DownlineCity' element value.
     * 
     * @return value
     */
    public String getDownlineCity() {
        return downlineCity;
    }

    /** 
     * Set the 'DownlineCity' element value.
     * 
     * @param downlineCity
     */
    public void setDownlineCity(String downlineCity) {
        this.downlineCity = downlineCity;
    }

    /** 
     * Get the 'CarrierCode' element value.
     * 
     * @return value
     */
    public String getCarrierCode() {
        return carrierCode;
    }

    /** 
     * Set the 'CarrierCode' element value.
     * 
     * @param carrierCode
     */
    public void setCarrierCode(String carrierCode) {
        this.carrierCode = carrierCode;
    }

    /** 
     * Get the 'Time' element value.
     * 
     * @return value
     */
    public String getTime() {
        return time;
    }

    /** 
     * Set the 'Time' element value.
     * 
     * @param time
     */
    public void setTime(String time) {
        this.time = time;
    }

    /** 
     * Get the 'FutureDate' element value.
     * 
     * @return value
     */
    public String getFutureDate() {
        return futureDate;
    }

    /** 
     * Set the 'FutureDate' element value.
     * 
     * @param futureDate
     */
    public void setFutureDate(String futureDate) {
        this.futureDate = futureDate;
    }

    /** 
     * Get the 'ThirtyMinuteInterval' element value.
     * 
     * @return value
     */
    public String getThirtyMinuteInterval() {
        return thirtyMinuteInterval;
    }

    /** 
     * Set the 'ThirtyMinuteInterval' element value.
     * 
     * @param thirtyMinuteInterval
     */
    public void setThirtyMinuteInterval(String thirtyMinuteInterval) {
        this.thirtyMinuteInterval = thirtyMinuteInterval;
    }

    /** 
     * Get the 'id' attribute value.
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value.
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'index' attribute value.
     * 
     * @return value
     */
    public BigInteger getIndex() {
        return index;
    }

    /** 
     * Set the 'index' attribute value.
     * 
     * @param index
     */
    public void setIndex(BigInteger index) {
        this.index = index;
    }

    /** 
     * Get the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @return value
     */
    public OperationTypePNRB getOp() {
        return op;
    }

    /** 
     * Set the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @param op
     */
    public void setOp(OperationTypePNRB op) {
        this.op = op;
    }

    /** 
     * Get the 'elementId' attribute value.
     * 
     * @return value
     */
    public String getElementId() {
        return elementId;
    }

    /** 
     * Set the 'elementId' attribute value.
     * 
     * @param elementId
     */
    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    /** 
     * Get the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                      in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                  
     * 
     * @return value
     */
    public String getRPH() {
        return RPH;
    }

    /** 
     * Set the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                      in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                  
     * 
     * @param RPH
     */
    public void setRPH(String RPH) {
        this.RPH = RPH;
    }
}
