
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * * add tour ticketing field 7TAV(tour operator
 code)/TAW(queue place date)(optional queue number)

 7TAVG0/TAW15APR101

 * add tour ticketing field and queue place to a branch
 office and add free text 7TAV(tour operator
 code)/TAW(Branch office pseudo city code)(queue place
 date) (branch office optional queue number)/(tour
 ticketing advice free text)

 7TAVXX/TAWB4T001JUN101/FINAL PAYMENT DUE

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TourTicketing.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="TourOperatorCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="QueuePlaceDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="QueueNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="BranchPCC" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Comment" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="id"/>
 *   &lt;xs:attribute type="xs:integer" name="index"/>
 *   &lt;xs:attribute type="ns:OperationType.PNRB" name="op"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="elementId"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TourTicketingPNRB implements Serializable
{
    private String tourOperatorCode;
    private String queuePlaceDate;
    private String queueNumber;
    private String branchPCC;
    private String comment;
    private String id;
    private BigInteger index;
    private OperationTypePNRB op;
    private String elementId;
    private String RPH;

    /** 
     * Get the 'TourOperatorCode' element value. Tour Operater Code.
     * 
     * @return value
     */
    public String getTourOperatorCode() {
        return tourOperatorCode;
    }

    /** 
     * Set the 'TourOperatorCode' element value. Tour Operater Code.
     * 
     * @param tourOperatorCode
     */
    public void setTourOperatorCode(String tourOperatorCode) {
        this.tourOperatorCode = tourOperatorCode;
    }

    /** 
     * Get the 'QueuePlaceDate' element value. The date the PNR is placed in the queue.
     * 
     * @return value
     */
    public String getQueuePlaceDate() {
        return queuePlaceDate;
    }

    /** 
     * Set the 'QueuePlaceDate' element value. The date the PNR is placed in the queue.
     * 
     * @param queuePlaceDate
     */
    public void setQueuePlaceDate(String queuePlaceDate) {
        this.queuePlaceDate = queuePlaceDate;
    }

    /** 
     * Get the 'QueueNumber' element value. Queue identification number.
     * 
     * @return value
     */
    public String getQueueNumber() {
        return queueNumber;
    }

    /** 
     * Set the 'QueueNumber' element value. Queue identification number.
     * 
     * @param queueNumber
     */
    public void setQueueNumber(String queueNumber) {
        this.queueNumber = queueNumber;
    }

    /** 
     * Get the 'BranchPCC' element value.
     * 
     * @return value
     */
    public String getBranchPCC() {
        return branchPCC;
    }

    /** 
     * Set the 'BranchPCC' element value.
     * 
     * @param branchPCC
     */
    public void setBranchPCC(String branchPCC) {
        this.branchPCC = branchPCC;
    }

    /** 
     * Get the 'Comment' element value.
     * 
     * @return value
     */
    public String getComment() {
        return comment;
    }

    /** 
     * Set the 'Comment' element value.
     * 
     * @param comment
     */
    public void setComment(String comment) {
        this.comment = comment;
    }

    /** 
     * Get the 'id' attribute value.
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value.
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'index' attribute value.
     * 
     * @return value
     */
    public BigInteger getIndex() {
        return index;
    }

    /** 
     * Set the 'index' attribute value.
     * 
     * @param index
     */
    public void setIndex(BigInteger index) {
        this.index = index;
    }

    /** 
     * Get the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @return value
     */
    public OperationTypePNRB getOp() {
        return op;
    }

    /** 
     * Set the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @param op
     */
    public void setOp(OperationTypePNRB op) {
        this.op = op;
    }

    /** 
     * Get the 'elementId' attribute value.
     * 
     * @return value
     */
    public String getElementId() {
        return elementId;
    }

    /** 
     * Set the 'elementId' attribute value.
     * 
     * @param elementId
     */
    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    /** 
     * Get the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                      in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                  
     * 
     * @return value
     */
    public String getRPH() {
        return RPH;
    }

    /** 
     * Set the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                      in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                  
     * 
     * @param RPH
     */
    public void setRPH(String RPH) {
        this.RPH = RPH;
    }
}
