
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;

/** 
 * 4/29/2009 - added GroundTransport to accomodate Profiles data. Other values from OTA Code
 List: travel sector (TVS).
 Values from OTA Code List: travel sector (TVS).
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelSectorType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Air"/>
 *     &lt;xs:enumeration value="Car"/>
 *     &lt;xs:enumeration value="Hotel"/>
 *     &lt;xs:enumeration value="Insurance"/>
 *     &lt;xs:enumeration value="Golf"/>
 *     &lt;xs:enumeration value="Tour"/>
 *     &lt;xs:enumeration value="Rail"/>
 *     &lt;xs:enumeration value="Cruise"/>
 *     &lt;xs:enumeration value="Excursion"/>
 *     &lt;xs:enumeration value="Ferry"/>
 *     &lt;xs:enumeration value="GroundTransport"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum TravelSectorType implements Serializable {
    AIR("Air"), CAR("Car"), HOTEL("Hotel"), INSURANCE("Insurance"), GOLF("Golf"), TOUR(
            "Tour"), RAIL("Rail"), CRUISE("Cruise"), EXCURSION("Excursion"), FERRY(
            "Ferry"), GROUND_TRANSPORT("GroundTransport");
    private final String value;

    private TravelSectorType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static TravelSectorType convert(String value) {
        for (TravelSectorType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
