
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UpdateReservationRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="ns:RequestType" name="RequestType" minOccurs="0"/>
 *       &lt;xs:element type="ns:ReturnOptions" name="ReturnOptions" minOccurs="0"/>
 *       &lt;xs:element type="ns:POS_Type.PNRB" name="POS" minOccurs="0"/>
 *       &lt;xs:element type="ns:ReservationUpdateListType" name="ReservationUpdateList" minOccurs="0"/>
 *       &lt;xs:element type="ns:AssociationUpdate.PNRB" name="AssociationUpdate" minOccurs="0" maxOccurs="unbounded"/>
 *       &lt;xs:element type="xs:string" name="UpdateToken" minOccurs="0"/>
 *       &lt;xs:element name="PnrContent" minOccurs="0">
 *         &lt;!-- Reference to inner class PnrContent -->
 *       &lt;/xs:element>
 *       &lt;xs:element type="xs:string" name="Partition" minOccurs="0"/>
 *       &lt;xs:element type="ns:ResultAction" name="ResultAction" minOccurs="0" maxOccurs="1"/>
 *       &lt;xs:element type="ns:ClientContext" name="ClientContext" minOccurs="0" maxOccurs="1"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:string" use="optional" name="Version"/>
 *     &lt;xs:attribute type="xs:string" use="optional" name="EchoToken"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class UpdateReservationRQ implements Serializable
{
    private RequestType requestType;
    private ReturnOptions returnOptions;
    private POSTypePNRB POS;
    private ReservationUpdateListType reservationUpdateList;
    private List<AssociationUpdatePNRB> associationUpdateList = new ArrayList<AssociationUpdatePNRB>();
    private String updateToken;
    private PnrContent pnrContent;
    private String partition;
    private ResultAction resultAction;
    private ClientContext clientContext;
    private String version;
    private String echoToken;

    /** 
     * Get the 'RequestType' element value.
     * 
     * @return value
     */
    public RequestType getRequestType() {
        return requestType;
    }

    /** 
     * Set the 'RequestType' element value.
     * 
     * @param requestType
     */
    public void setRequestType(RequestType requestType) {
        this.requestType = requestType;
    }

    /** 
     * Get the 'ReturnOptions' element value.
     * 
     * @return value
     */
    public ReturnOptions getReturnOptions() {
        return returnOptions;
    }

    /** 
     * Set the 'ReturnOptions' element value.
     * 
     * @param returnOptions
     */
    public void setReturnOptions(ReturnOptions returnOptions) {
        this.returnOptions = returnOptions;
    }

    /** 
     * Get the 'POS' element value.
     * 
     * @return value
     */
    public POSTypePNRB getPOS() {
        return POS;
    }

    /** 
     * Set the 'POS' element value.
     * 
     * @param POS
     */
    public void setPOS(POSTypePNRB POS) {
        this.POS = POS;
    }

    /** 
     * Get the 'ReservationUpdateList' element value.
     * 
     * @return value
     */
    public ReservationUpdateListType getReservationUpdateList() {
        return reservationUpdateList;
    }

    /** 
     * Set the 'ReservationUpdateList' element value.
     * 
     * @param reservationUpdateList
     */
    public void setReservationUpdateList(
            ReservationUpdateListType reservationUpdateList) {
        this.reservationUpdateList = reservationUpdateList;
    }

    /** 
     * Get the list of 'AssociationUpdate' element items.
     * 
     * @return list
     */
    public List<AssociationUpdatePNRB> getAssociationUpdateList() {
        return associationUpdateList;
    }

    /** 
     * Set the list of 'AssociationUpdate' element items.
     * 
     * @param list
     */
    public void setAssociationUpdateList(List<AssociationUpdatePNRB> list) {
        associationUpdateList = list;
    }

    /** 
     * Get the 'UpdateToken' element value.
     * 
     * @return value
     */
    public String getUpdateToken() {
        return updateToken;
    }

    /** 
     * Set the 'UpdateToken' element value.
     * 
     * @param updateToken
     */
    public void setUpdateToken(String updateToken) {
        this.updateToken = updateToken;
    }

    /** 
     * Get the 'PnrContent' element value.
     * 
     * @return value
     */
    public PnrContent getPnrContent() {
        return pnrContent;
    }

    /** 
     * Set the 'PnrContent' element value.
     * 
     * @param pnrContent
     */
    public void setPnrContent(PnrContent pnrContent) {
        this.pnrContent = pnrContent;
    }

    /** 
     * Get the 'Partition' element value.
     * 
     * @return value
     */
    public String getPartition() {
        return partition;
    }

    /** 
     * Set the 'Partition' element value.
     * 
     * @param partition
     */
    public void setPartition(String partition) {
        this.partition = partition;
    }

    /** 
     * Get the 'ResultAction' element value.
     * 
     * @return value
     */
    public ResultAction getResultAction() {
        return resultAction;
    }

    /** 
     * Set the 'ResultAction' element value.
     * 
     * @param resultAction
     */
    public void setResultAction(ResultAction resultAction) {
        this.resultAction = resultAction;
    }

    /** 
     * Get the 'ClientContext' element value.
     * 
     * @return value
     */
    public ClientContext getClientContext() {
        return clientContext;
    }

    /** 
     * Set the 'ClientContext' element value.
     * 
     * @param clientContext
     */
    public void setClientContext(ClientContext clientContext) {
        this.clientContext = clientContext;
    }

    /** 
     * Get the 'Version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }

    /** 
     * Get the 'EchoToken' attribute value.
     * 
     * @return value
     */
    public String getEchoToken() {
        return echoToken;
    }

    /** 
     * Set the 'EchoToken' attribute value.
     * 
     * @param echoToken
     */
    public void setEchoToken(String echoToken) {
        this.echoToken = echoToken;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PnrContent" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:base64Binary" name="RawContent" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PnrContent implements Serializable
    {
        private byte[] rawContent;

        /** 
         * Get the 'RawContent' element value.
         * 
         * @return value
         */
        public byte[] getRawContent() {
            return rawContent;
        }

        /** 
         * Set the 'RawContent' element value.
         * 
         * @param rawContent
         */
        public void setRawContent(byte[] rawContent) {
            this.rawContent = rawContent;
        }
    }
}
