
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import org.w3c.dom.Element;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UpdateReservationRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="xs:string" name="Locator" minOccurs="0" maxOccurs="1"/>
 *       &lt;xs:element type="xs:string" name="Success" minOccurs="0" maxOccurs="1"/>
 *       &lt;xs:element type="ns:UpdateWarnings.PNRB" name="Warnings" minOccurs="0" maxOccurs="1"/>
 *       &lt;xs:element type="ns:UpdateErrors.PNRB" name="Errors" minOccurs="0" maxOccurs="1"/>
 *       &lt;xs:choice>
 *         &lt;xs:element type="ns:Reservation.PNRB" name="Reservation" minOccurs="0"/>
 *         &lt;xs:element name="Content" minOccurs="0">
 *           &lt;xs:complexType>
 *             &lt;xs:choice>
 *               &lt;xs:any processContents="lax"/>
 *             &lt;/xs:choice>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *       &lt;/xs:choice>
 *       &lt;xs:element type="ns:Results.PNRB" name="Results" minOccurs="0" maxOccurs="1"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:string" use="optional" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class UpdateReservationRS implements Serializable
{
    private String locator;
    private String success;
    private UpdateWarningsPNRB warnings;
    private UpdateErrorsPNRB errors;
    private int choiceSelect = -1;
    private static final int RESERVATION_CHOICE = 0;
    private static final int CONTENT_CHOICE = 1;
    private ReservationPNRB reservation;
    private Element content;
    private ResultsPNRB results;
    private String version;

    /** 
     * Get the 'Locator' element value. Used to return PNR locator if requested using ReturnOptions.ReturnLocator in request is set to true and locator information is available
     * 
     * @return value
     */
    public String getLocator() {
        return locator;
    }

    /** 
     * Set the 'Locator' element value. Used to return PNR locator if requested using ReturnOptions.ReturnLocator in request is set to true and locator information is available
     * 
     * @param locator
     */
    public void setLocator(String locator) {
        this.locator = locator;
    }

    /** 
     * Get the 'Success' element value.
     * 
     * @return value
     */
    public String getSuccess() {
        return success;
    }

    /** 
     * Set the 'Success' element value.
     * 
     * @param success
     */
    public void setSuccess(String success) {
        this.success = success;
    }

    /** 
     * Get the 'Warnings' element value.
     * 
     * @return value
     */
    public UpdateWarningsPNRB getWarnings() {
        return warnings;
    }

    /** 
     * Set the 'Warnings' element value.
     * 
     * @param warnings
     */
    public void setWarnings(UpdateWarningsPNRB warnings) {
        this.warnings = warnings;
    }

    /** 
     * Get the 'Errors' element value.
     * 
     * @return value
     */
    public UpdateErrorsPNRB getErrors() {
        return errors;
    }

    /** 
     * Set the 'Errors' element value.
     * 
     * @param errors
     */
    public void setErrors(UpdateErrorsPNRB errors) {
        this.errors = errors;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Reservation is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifReservation() {
        return choiceSelect == RESERVATION_CHOICE;
    }

    /** 
     * Get the 'Reservation' element value.
     * 
     * @return value
     */
    public ReservationPNRB getReservation() {
        return reservation;
    }

    /** 
     * Set the 'Reservation' element value.
     * 
     * @param reservation
     */
    public void setReservation(ReservationPNRB reservation) {
        setChoiceSelect(RESERVATION_CHOICE);
        this.reservation = reservation;
    }

    /** 
     * Check if Content is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifContent() {
        return choiceSelect == CONTENT_CHOICE;
    }

    /** 
     * Get the 'Content' element value.
     * 
     * @return value
     */
    public Element getContent() {
        return content;
    }

    /** 
     * Set the 'Content' element value.
     * 
     * @param content
     */
    public void setContent(Element content) {
        setChoiceSelect(CONTENT_CHOICE);
        this.content = content;
    }

    /** 
     * Get the 'Results' element value.
     * 
     * @return value
     */
    public ResultsPNRB getResults() {
        return results;
    }

    /** 
     * Set the 'Results' element value.
     * 
     * @param results
     */
    public void setResults(ResultsPNRB results) {
        this.results = results;
    }

    /** 
     * Get the 'Version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
}
