
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Information on the charges associated with this vehicle. Such charges may include the
 base rental amount, additional mileage amounts, fuel costs, etc.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VehicleCharges.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="VehicleChargeAmount" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="ApproximateTotalChargeAmount" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:ApproximateChargeDetails.PNRB" name="ApproximateChargeDetails" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="ApproximateTotalChargeRateType" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="NumDays" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="NumHours" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Mileage" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TotalMandatoryCharges" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="DropOffCharge" minOccurs="0"/>
 *     &lt;xs:element type="xs:integer" name="DropOffDecimalPlaces" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="GuaranteedInd" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class VehicleChargesPNRB implements Serializable
{
    private List<String> vehicleChargeAmountList = new ArrayList<String>();
    private List<String> approximateTotalChargeAmountList = new ArrayList<String>();
    private List<ApproximateChargeDetailsPNRB> approximateChargeDetailList = new ArrayList<ApproximateChargeDetailsPNRB>();
    private List<String> approximateTotalChargeRateTypeList = new ArrayList<String>();
    private String numDays;
    private String numHours;
    private String mileage;
    private String totalMandatoryCharges;
    private String dropOffCharge;
    private BigInteger dropOffDecimalPlaces;
    private String guaranteedInd;

    /** 
     * Get the list of 'VehicleChargeAmount' element items. The VehicleChargeType complex type defines information on a specific charge
                          associated with the rental of a vehicle, including unit cost, quantity and total cost.
                      
     * 
     * @return list
     */
    public List<String> getVehicleChargeAmountList() {
        return vehicleChargeAmountList;
    }

    /** 
     * Set the list of 'VehicleChargeAmount' element items. The VehicleChargeType complex type defines information on a specific charge
                          associated with the rental of a vehicle, including unit cost, quantity and total cost.
                      
     * 
     * @param list
     */
    public void setVehicleChargeAmountList(List<String> list) {
        vehicleChargeAmountList = list;
    }

    /** 
     * Get the list of 'ApproximateTotalChargeAmount' element items. approximate total charge (vehicle)
     * 
     * @return list
     */
    public List<String> getApproximateTotalChargeAmountList() {
        return approximateTotalChargeAmountList;
    }

    /** 
     * Set the list of 'ApproximateTotalChargeAmount' element items. approximate total charge (vehicle)
     * 
     * @param list
     */
    public void setApproximateTotalChargeAmountList(List<String> list) {
        approximateTotalChargeAmountList = list;
    }

    /** 
     * Get the list of 'ApproximateChargeDetails' element items.
     * 
     * @return list
     */
    public List<ApproximateChargeDetailsPNRB> getApproximateChargeDetailList() {
        return approximateChargeDetailList;
    }

    /** 
     * Set the list of 'ApproximateChargeDetails' element items.
     * 
     * @param list
     */
    public void setApproximateChargeDetailList(
            List<ApproximateChargeDetailsPNRB> list) {
        approximateChargeDetailList = list;
    }

    /** 
     * Get the list of 'ApproximateTotalChargeRateType' element items.
     * 
     * @return list
     */
    public List<String> getApproximateTotalChargeRateTypeList() {
        return approximateTotalChargeRateTypeList;
    }

    /** 
     * Set the list of 'ApproximateTotalChargeRateType' element items.
     * 
     * @param list
     */
    public void setApproximateTotalChargeRateTypeList(List<String> list) {
        approximateTotalChargeRateTypeList = list;
    }

    /** 
     * Get the 'NumDays' element value. number of days of rental charge
     * 
     * @return value
     */
    public String getNumDays() {
        return numDays;
    }

    /** 
     * Set the 'NumDays' element value. number of days of rental charge
     * 
     * @param numDays
     */
    public void setNumDays(String numDays) {
        this.numDays = numDays;
    }

    /** 
     * Get the 'NumHours' element value. number of hours of rental charge
     * 
     * @return value
     */
    public String getNumHours() {
        return numHours;
    }

    /** 
     * Set the 'NumHours' element value. number of hours of rental charge
     * 
     * @param numHours
     */
    public void setNumHours(String numHours) {
        this.numHours = numHours;
    }

    /** 
     * Get the 'Mileage' element value. mileage allowance
     * 
     * @return value
     */
    public String getMileage() {
        return mileage;
    }

    /** 
     * Set the 'Mileage' element value. mileage allowance
     * 
     * @param mileage
     */
    public void setMileage(String mileage) {
        this.mileage = mileage;
    }

    /** 
     * Get the 'TotalMandatoryCharges' element value. mandatory charges total, e.g., state tax
     * 
     * @return value
     */
    public String getTotalMandatoryCharges() {
        return totalMandatoryCharges;
    }

    /** 
     * Set the 'TotalMandatoryCharges' element value. mandatory charges total, e.g., state tax
     * 
     * @param totalMandatoryCharges
     */
    public void setTotalMandatoryCharges(String totalMandatoryCharges) {
        this.totalMandatoryCharges = totalMandatoryCharges;
    }

    /** 
     * Get the 'DropOffCharge' element value. the car is being dropped off at a different location than the pick-up location
                          the vendor may assess a drop-off charge which
                          will be stated in this field in the currency indicated in the CarDropOffCurCode field
                      
     * 
     * @return value
     */
    public String getDropOffCharge() {
        return dropOffCharge;
    }

    /** 
     * Set the 'DropOffCharge' element value. the car is being dropped off at a different location than the pick-up location
                          the vendor may assess a drop-off charge which
                          will be stated in this field in the currency indicated in the CarDropOffCurCode field
                      
     * 
     * @param dropOffCharge
     */
    public void setDropOffCharge(String dropOffCharge) {
        this.dropOffCharge = dropOffCharge;
    }

    /** 
     * Get the 'DropOffDecimalPlaces' element value. decimal places in drop off charge
     * 
     * @return value
     */
    public BigInteger getDropOffDecimalPlaces() {
        return dropOffDecimalPlaces;
    }

    /** 
     * Set the 'DropOffDecimalPlaces' element value. decimal places in drop off charge
     * 
     * @param dropOffDecimalPlaces
     */
    public void setDropOffDecimalPlaces(BigInteger dropOffDecimalPlaces) {
        this.dropOffDecimalPlaces = dropOffDecimalPlaces;
    }

    /** 
     * Get the 'GuaranteedInd' element value. ID of guarantee
     * 
     * @return value
     */
    public String getGuaranteedInd() {
        return guaranteedInd;
    }

    /** 
     * Set the 'GuaranteedInd' element value. ID of guarantee
     * 
     * @param guaranteedInd
     */
    public void setGuaranteedInd(String guaranteedInd) {
        this.guaranteedInd = guaranteedInd;
    }
}
