
package com.sabre.webservices.sabrexml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AddRemarkRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="RemarkInfo">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element name="FOP_Remark" minOccurs="0">
 *               &lt;!-- Reference to inner class FOPRemark -->
 *             &lt;/xs:element>
 *             &lt;xs:element name="FutureQueuePlaceRemark" minOccurs="0">
 *               &lt;!-- Reference to inner class FutureQueuePlaceRemark -->
 *             &lt;/xs:element>
 *             &lt;xs:element name="Remark" minOccurs="0" maxOccurs="unbounded">
 *               &lt;!-- Reference to inner class Remark -->
 *             &lt;/xs:element>
 *           &lt;/xs:sequence>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:boolean" use="optional" name="ReturnHostCommand"/>
 *     &lt;xs:attribute type="xs:dateTime" use="optional" name="TimeStamp"/>
 *     &lt;xs:attribute type="xs:string" use="required" fixed="2.1.1" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class AddRemarkRQ implements Serializable
{
    private FOPRemark FOPRemark1;
    private FutureQueuePlaceRemark futureQueuePlaceRemark;
    private List<Remark> remarkList = new ArrayList<Remark>();
    private Boolean returnHostCommand;
    private Date timeStamp;
    private String version;

    /** 
     * Get the 'FOP_Remark' element value.
     * 
     * @return value
     */
    public FOPRemark getFOPRemark1() {
        return FOPRemark1;
    }

    /** 
     * Set the 'FOP_Remark' element value.
     * 
     * @param FOPRemark1
     */
    public void setFOPRemark1(FOPRemark FOPRemark1) {
        this.FOPRemark1 = FOPRemark1;
    }

    /** 
     * Get the 'FutureQueuePlaceRemark' element value.
     * 
     * @return value
     */
    public FutureQueuePlaceRemark getFutureQueuePlaceRemark() {
        return futureQueuePlaceRemark;
    }

    /** 
     * Set the 'FutureQueuePlaceRemark' element value.
     * 
     * @param futureQueuePlaceRemark
     */
    public void setFutureQueuePlaceRemark(
            FutureQueuePlaceRemark futureQueuePlaceRemark) {
        this.futureQueuePlaceRemark = futureQueuePlaceRemark;
    }

    /** 
     * Get the list of 'Remark' element items.
     * 
     * @return list
     */
    public List<Remark> getRemarkList() {
        return remarkList;
    }

    /** 
     * Set the list of 'Remark' element items.
     * 
     * @param list
     */
    public void setRemarkList(List<Remark> list) {
        remarkList = list;
    }

    /** 
     * Get the 'ReturnHostCommand' attribute value.
     * 
     * @return value
     */
    public Boolean getReturnHostCommand() {
        return returnHostCommand;
    }

    /** 
     * Set the 'ReturnHostCommand' attribute value.
     * 
     * @param returnHostCommand
     */
    public void setReturnHostCommand(Boolean returnHostCommand) {
        this.returnHostCommand = returnHostCommand;
    }

    /** 
     * Get the 'TimeStamp' attribute value.
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value.
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FOP_Remark" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="CC_Info" minOccurs="0">
     *         &lt;!-- Reference to inner class CCInfo -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FOPRemark implements Serializable
    {
        private CCInfo CCInfo1;
        private String type;

        /** 
         * Get the 'CC_Info' element value.
         * 
         * @return value
         */
        public CCInfo getCCInfo1() {
            return CCInfo1;
        }

        /** 
         * Set the 'CC_Info' element value.
         * 
         * @param CCInfo1
         */
        public void setCCInfo1(CCInfo CCInfo1) {
            this.CCInfo1 = CCInfo1;
        }

        /** 
         * Get the 'Type' attribute value.
         * 
         * @return value
         */
        public String getType() {
            return type;
        }

        /** 
         * Set the 'Type' attribute value.
         * 
         * @param type
         */
        public void setType(String type) {
            this.type = type;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="PaymentCard">
         *         &lt;xs:complexType>
         *           &lt;xs:attribute type="xs:string" use="optional" name="AirlineCode"/>
         *           &lt;xs:attribute type="xs:string" use="optional" name="CardSecurityCode"/>
         *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
         *           &lt;xs:attribute type="xs:string" use="required" name="ExpireDate"/>
         *           &lt;xs:attribute type="xs:string" use="optional" name="ExtendedPayment"/>
         *           &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
         *           &lt;xs:attribute type="xs:string" use="required" name="Number"/>
         *           &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="SuppressApprovalCode"/>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="Suppress"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class CCInfo implements Serializable
        {
            private String paymentCardAirlineCode;
            private String paymentCardCardSecurityCode;
            private String paymentCardCode;
            private String paymentCardExpireDate;
            private String paymentCardExtendedPayment;
            private String paymentCardManualApprovalCode;
            private String paymentCardNumber;
            private Boolean paymentCardSuppressApprovalCode;
            private Boolean suppress;

            /** 
             * Get the 'AirlineCode' attribute value.
             * 
             * @return value
             */
            public String getPaymentCardAirlineCode() {
                return paymentCardAirlineCode;
            }

            /** 
             * Set the 'AirlineCode' attribute value.
             * 
             * @param paymentCardAirlineCode
             */
            public void setPaymentCardAirlineCode(String paymentCardAirlineCode) {
                this.paymentCardAirlineCode = paymentCardAirlineCode;
            }

            /** 
             * Get the 'CardSecurityCode' attribute value.
             * 
             * @return value
             */
            public String getPaymentCardCardSecurityCode() {
                return paymentCardCardSecurityCode;
            }

            /** 
             * Set the 'CardSecurityCode' attribute value.
             * 
             * @param paymentCardCardSecurityCode
             */
            public void setPaymentCardCardSecurityCode(
                    String paymentCardCardSecurityCode) {
                this.paymentCardCardSecurityCode = paymentCardCardSecurityCode;
            }

            /** 
             * Get the 'Code' attribute value.
             * 
             * @return value
             */
            public String getPaymentCardCode() {
                return paymentCardCode;
            }

            /** 
             * Set the 'Code' attribute value.
             * 
             * @param paymentCardCode
             */
            public void setPaymentCardCode(String paymentCardCode) {
                this.paymentCardCode = paymentCardCode;
            }

            /** 
             * Get the 'ExpireDate' attribute value.
             * 
             * @return value
             */
            public String getPaymentCardExpireDate() {
                return paymentCardExpireDate;
            }

            /** 
             * Set the 'ExpireDate' attribute value.
             * 
             * @param paymentCardExpireDate
             */
            public void setPaymentCardExpireDate(String paymentCardExpireDate) {
                this.paymentCardExpireDate = paymentCardExpireDate;
            }

            /** 
             * Get the 'ExtendedPayment' attribute value.
             * 
             * @return value
             */
            public String getPaymentCardExtendedPayment() {
                return paymentCardExtendedPayment;
            }

            /** 
             * Set the 'ExtendedPayment' attribute value.
             * 
             * @param paymentCardExtendedPayment
             */
            public void setPaymentCardExtendedPayment(
                    String paymentCardExtendedPayment) {
                this.paymentCardExtendedPayment = paymentCardExtendedPayment;
            }

            /** 
             * Get the 'ManualApprovalCode' attribute value.
             * 
             * @return value
             */
            public String getPaymentCardManualApprovalCode() {
                return paymentCardManualApprovalCode;
            }

            /** 
             * Set the 'ManualApprovalCode' attribute value.
             * 
             * @param paymentCardManualApprovalCode
             */
            public void setPaymentCardManualApprovalCode(
                    String paymentCardManualApprovalCode) {
                this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
            }

            /** 
             * Get the 'Number' attribute value.
             * 
             * @return value
             */
            public String getPaymentCardNumber() {
                return paymentCardNumber;
            }

            /** 
             * Set the 'Number' attribute value.
             * 
             * @param paymentCardNumber
             */
            public void setPaymentCardNumber(String paymentCardNumber) {
                this.paymentCardNumber = paymentCardNumber;
            }

            /** 
             * Get the 'SuppressApprovalCode' attribute value.
             * 
             * @return value
             */
            public Boolean getPaymentCardSuppressApprovalCode() {
                return paymentCardSuppressApprovalCode;
            }

            /** 
             * Set the 'SuppressApprovalCode' attribute value.
             * 
             * @param paymentCardSuppressApprovalCode
             */
            public void setPaymentCardSuppressApprovalCode(
                    Boolean paymentCardSuppressApprovalCode) {
                this.paymentCardSuppressApprovalCode = paymentCardSuppressApprovalCode;
            }

            /** 
             * Get the 'Suppress' attribute value.
             * 
             * @return value
             */
            public Boolean getSuppress() {
                return suppress;
            }

            /** 
             * Set the 'Suppress' attribute value.
             * 
             * @param suppress
             */
            public void setSuppress(Boolean suppress) {
                this.suppress = suppress;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FutureQueuePlaceRemark" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="required" name="Date"/>
     *     &lt;xs:attribute type="xs:string" use="required" name="PrefatoryInstructionCode"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="PseudoCityCode"/>
     *     &lt;xs:attribute type="xs:string" use="required" name="QueueIdentifier"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="Time"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FutureQueuePlaceRemark implements Serializable
    {
        private String date;
        private String prefatoryInstructionCode;
        private String pseudoCityCode;
        private String queueIdentifier;
        private String time;

        /** 
         * Get the 'Date' attribute value.
         * 
         * @return value
         */
        public String getDate() {
            return date;
        }

        /** 
         * Set the 'Date' attribute value.
         * 
         * @param date
         */
        public void setDate(String date) {
            this.date = date;
        }

        /** 
         * Get the 'PrefatoryInstructionCode' attribute value.
         * 
         * @return value
         */
        public String getPrefatoryInstructionCode() {
            return prefatoryInstructionCode;
        }

        /** 
         * Set the 'PrefatoryInstructionCode' attribute value.
         * 
         * @param prefatoryInstructionCode
         */
        public void setPrefatoryInstructionCode(String prefatoryInstructionCode) {
            this.prefatoryInstructionCode = prefatoryInstructionCode;
        }

        /** 
         * Get the 'PseudoCityCode' attribute value.
         * 
         * @return value
         */
        public String getPseudoCityCode() {
            return pseudoCityCode;
        }

        /** 
         * Set the 'PseudoCityCode' attribute value.
         * 
         * @param pseudoCityCode
         */
        public void setPseudoCityCode(String pseudoCityCode) {
            this.pseudoCityCode = pseudoCityCode;
        }

        /** 
         * Get the 'QueueIdentifier' attribute value.
         * 
         * @return value
         */
        public String getQueueIdentifier() {
            return queueIdentifier;
        }

        /** 
         * Set the 'QueueIdentifier' attribute value.
         * 
         * @param queueIdentifier
         */
        public void setQueueIdentifier(String queueIdentifier) {
            this.queueIdentifier = queueIdentifier;
        }

        /** 
         * Get the 'Time' attribute value.
         * 
         * @return value
         */
        public String getTime() {
            return time;
        }

        /** 
         * Set the 'Time' attribute value.
         * 
         * @param time
         */
        public void setTime(String time) {
            this.time = time;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Remark" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Text"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="SegmentNumber"/>
     *     &lt;xs:attribute use="required" name="Type">
     *       &lt;xs:simpleType>
     *         &lt;!-- Reference to inner class Type -->
     *       &lt;/xs:simpleType>
     *     &lt;/xs:attribute>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Remark implements Serializable
    {
        private String text;
        private String code;
        private String segmentNumber;
        private Type type;

        /** 
         * Get the 'Text' element value.
         * 
         * @return value
         */
        public String getText() {
            return text;
        }

        /** 
         * Set the 'Text' element value.
         * 
         * @param text
         */
        public void setText(String text) {
            this.text = text;
        }

        /** 
         * Get the 'Code' attribute value.
         * 
         * @return value
         */
        public String getCode() {
            return code;
        }

        /** 
         * Set the 'Code' attribute value.
         * 
         * @param code
         */
        public void setCode(String code) {
            this.code = code;
        }

        /** 
         * Get the 'SegmentNumber' attribute value.
         * 
         * @return value
         */
        public String getSegmentNumber() {
            return segmentNumber;
        }

        /** 
         * Set the 'SegmentNumber' attribute value.
         * 
         * @param segmentNumber
         */
        public void setSegmentNumber(String segmentNumber) {
            this.segmentNumber = segmentNumber;
        }

        /** 
         * Get the 'Type' attribute value.
         * 
         * @return value
         */
        public Type getType() {
            return type;
        }

        /** 
         * Set the 'Type' attribute value.
         * 
         * @param type
         */
        public void setType(Type type) {
            this.type = type;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
         *   &lt;xs:restriction base="xs:string">
         *     &lt;xs:enumeration value="Alpha-Coded"/>
         *     &lt;xs:enumeration value="Client Address"/>
         *     &lt;xs:enumeration value="Corporate"/>
         *     &lt;xs:enumeration value="Delivery Address"/>
         *     &lt;xs:enumeration value="General"/>
         *     &lt;xs:enumeration value="Group Name"/>
         *     &lt;xs:enumeration value="Hidden"/>
         *     &lt;xs:enumeration value="Historical"/>
         *     &lt;xs:enumeration value="Invoice"/>
         *     &lt;xs:enumeration value="Itinerary"/>
         *   &lt;/xs:restriction>
         * &lt;/xs:simpleType>
         * </pre>
         */
        public static enum Type implements Serializable {
            ALPHA_CODED("Alpha-Coded"), CLIENT_ADDRESS("Client Address"), CORPORATE(
                    "Corporate"), DELIVERY_ADDRESS("Delivery Address"), GENERAL(
                    "General"), GROUP_NAME("Group Name"), HIDDEN("Hidden"), HISTORICAL(
                    "Historical"), INVOICE("Invoice"), ITINERARY("Itinerary");
            private final String value;

            private Type(String value) {
                this.value = value;
            }

            public String xmlValue() {
                return value;
            }

            public static Type convert(String value) {
                for (Type inst : values()) {
                    if (inst.xmlValue().equals(value)) {
                        return inst;
                    }
                }
                return null;
            }
        }
    }
}
