
package com.sabre.webservices.sabrexml;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AddonConstructionType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="1"/>
 *     &lt;xs:enumeration value="2"/>
 *     &lt;xs:enumeration value="3"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum AddonConstructionType implements Serializable {
    _1("1"), _2("2"), _3("3");
    private final String value;

    private AddonConstructionType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static AddonConstructionType convert(String value) {
        for (AddonConstructionType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
