
package com.sabre.webservices.sabrexml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Baggage Disclosure Item
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageDisclosureItemType">
 *   &lt;xs:sequence>
 *     &lt;xs:choice>
 *       &lt;xs:element type="ns:BaggageItemCountLimitType" name="BaggageItemCountLimit" minOccurs="0" maxOccurs="unbounded"/>
 *       &lt;xs:element type="ns:PriceAndFulfillmentInfoType" name="PriceAndFulfillmentInfo"/>
 *     &lt;/xs:choice>
 *     &lt;xs:element name="SegmentNumbers">
 *       &lt;xs:complexType>
 *         &lt;xs:sequence>
 *           &lt;xs:element type="xs:short" name="SegmentNumber" maxOccurs="24"/>
 *         &lt;/xs:sequence>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="ns:BaggageProvisionType" use="optional" name="ProvisionType"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ProvisionsCarrier"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Subcode"/>
 *   &lt;xs:attribute type="xs:byte" use="optional" name="Pieces"/>
 *   &lt;xs:attribute type="xs:short" use="optional" name="WeightLimit"/>
 *   &lt;xs:attribute type="ns:WeightUnitType" use="optional" name="UnitsOfWeightLimit"/>
 *   &lt;xs:attribute type="xs:byte" use="optional" name="FirstOccurrence"/>
 *   &lt;xs:attribute type="xs:byte" use="optional" name="LastOccurrence"/>
 *   &lt;xs:attribute type="xs:short" use="optional" name="CarrierTierLevel"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BaggageDisclosureItemType implements Serializable
{
    private int choiceSelect = -1;
    private static final int BAGGAGE_ITEM_COUNT_LIMIT_LIST_CHOICE = 0;
    private static final int PRICE_AND_FULFILLMENT_INFO_CHOICE = 1;
    private List<BaggageItemCountLimitType> baggageItemCountLimitList = new ArrayList<BaggageItemCountLimitType>();
    private PriceAndFulfillmentInfoType priceAndFulfillmentInfo;
    private List<Short> segmentNumberList = new ArrayList<Short>();
    private BaggageProvisionType provisionType;
    private String provisionsCarrier;
    private String subcode;
    private Byte pieces;
    private Short weightLimit;
    private WeightUnitType unitsOfWeightLimit;
    private Byte firstOccurrence;
    private Byte lastOccurrence;
    private Short carrierTierLevel;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if BaggageItemCountLimitList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifBaggageItemCountLimitList() {
        return choiceSelect == BAGGAGE_ITEM_COUNT_LIMIT_LIST_CHOICE;
    }

    /** 
     * Get the list of 'BaggageItemCountLimit' element items. Number of pieces per item type. Applicable to Allowance rules.
     * 
     * @return list
     */
    public List<BaggageItemCountLimitType> getBaggageItemCountLimitList() {
        return baggageItemCountLimitList;
    }

    /** 
     * Set the list of 'BaggageItemCountLimit' element items. Number of pieces per item type. Applicable to Allowance rules.
     * 
     * @param list
     */
    public void setBaggageItemCountLimitList(
            List<BaggageItemCountLimitType> list) {
        setChoiceSelect(BAGGAGE_ITEM_COUNT_LIMIT_LIST_CHOICE);
        baggageItemCountLimitList = list;
    }

    /** 
     * Check if PriceAndFulfillmentInfo is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPriceAndFulfillmentInfo() {
        return choiceSelect == PRICE_AND_FULFILLMENT_INFO_CHOICE;
    }

    /** 
     * Get the 'PriceAndFulfillmentInfo' element value. Price and Fulfillment Info. Applicable to baggage charges.
     * 
     * @return value
     */
    public PriceAndFulfillmentInfoType getPriceAndFulfillmentInfo() {
        return priceAndFulfillmentInfo;
    }

    /** 
     * Set the 'PriceAndFulfillmentInfo' element value. Price and Fulfillment Info. Applicable to baggage charges.
     * 
     * @param priceAndFulfillmentInfo
     */
    public void setPriceAndFulfillmentInfo(
            PriceAndFulfillmentInfoType priceAndFulfillmentInfo) {
        setChoiceSelect(PRICE_AND_FULFILLMENT_INFO_CHOICE);
        this.priceAndFulfillmentInfo = priceAndFulfillmentInfo;
    }

    /** 
     * Get the list of 'SegmentNumber' element items. Segment Number(s)
     * 
     * @return list
     */
    public List<Short> getSegmentNumberList() {
        return segmentNumberList;
    }

    /** 
     * Set the list of 'SegmentNumber' element items. Segment Number(s)
     * 
     * @param list
     */
    public void setSegmentNumberList(List<Short> list) {
        segmentNumberList = list;
    }

    /** 
     * Get the 'ProvisionType' attribute value. SUM/PXI/BDI/@BPT Provision Type (e.g. allowance, charges, embargo etc)
     * 
     * @return value
     */
    public BaggageProvisionType getProvisionType() {
        return provisionType;
    }

    /** 
     * Set the 'ProvisionType' attribute value. SUM/PXI/BDI/@BPT Provision Type (e.g. allowance, charges, embargo etc)
     * 
     * @param provisionType
     */
    public void setProvisionType(BaggageProvisionType provisionType) {
        this.provisionType = provisionType;
    }

    /** 
     * Get the 'ProvisionsCarrier' attribute value. SUM/PXI/BDI/@SFK Carrier whose baggage provisions apply
     * 
     * @return value
     */
    public String getProvisionsCarrier() {
        return provisionsCarrier;
    }

    /** 
     * Set the 'ProvisionsCarrier' attribute value. SUM/PXI/BDI/@SFK Carrier whose baggage provisions apply
     * 
     * @param provisionsCarrier
     */
    public void setProvisionsCarrier(String provisionsCarrier) {
        this.provisionsCarrier = provisionsCarrier;
    }

    /** 
     * Get the 'Subcode' attribute value. SUM/PXI/BDI/@SHK
     * 
     * @return value
     */
    public String getSubcode() {
        return subcode;
    }

    /** 
     * Set the 'Subcode' attribute value. SUM/PXI/BDI/@SHK
     * 
     * @param subcode
     */
    public void setSubcode(String subcode) {
        this.subcode = subcode;
    }

    /** 
     * Get the 'Pieces' attribute value. SUM/PXI/BDI/@BPC
     * 
     * @return value
     */
    public Byte getPieces() {
        return pieces;
    }

    /** 
     * Set the 'Pieces' attribute value. SUM/PXI/BDI/@BPC
     * 
     * @param pieces
     */
    public void setPieces(Byte pieces) {
        this.pieces = pieces;
    }

    /** 
     * Get the 'WeightLimit' attribute value. SUM/PXI/BDI/@B20
     * 
     * @return value
     */
    public Short getWeightLimit() {
        return weightLimit;
    }

    /** 
     * Set the 'WeightLimit' attribute value. SUM/PXI/BDI/@B20
     * 
     * @param weightLimit
     */
    public void setWeightLimit(Short weightLimit) {
        this.weightLimit = weightLimit;
    }

    /** 
     * Get the 'UnitsOfWeightLimit' attribute value. SUM/PXI/BDI/@N0D
     * 
     * @return value
     */
    public WeightUnitType getUnitsOfWeightLimit() {
        return unitsOfWeightLimit;
    }

    /** 
     * Set the 'UnitsOfWeightLimit' attribute value. SUM/PXI/BDI/@N0D
     * 
     * @param unitsOfWeightLimit
     */
    public void setUnitsOfWeightLimit(WeightUnitType unitsOfWeightLimit) {
        this.unitsOfWeightLimit = unitsOfWeightLimit;
    }

    /** 
     * Get the 'FirstOccurrence' attribute value. SUM/PXI/BDI/@OC1
     * 
     * @return value
     */
    public Byte getFirstOccurrence() {
        return firstOccurrence;
    }

    /** 
     * Set the 'FirstOccurrence' attribute value. SUM/PXI/BDI/@OC1
     * 
     * @param firstOccurrence
     */
    public void setFirstOccurrence(Byte firstOccurrence) {
        this.firstOccurrence = firstOccurrence;
    }

    /** 
     * Get the 'LastOccurrence' attribute value. SUM/PXI/BDI/@OC2
     * 
     * @return value
     */
    public Byte getLastOccurrence() {
        return lastOccurrence;
    }

    /** 
     * Set the 'LastOccurrence' attribute value. SUM/PXI/BDI/@OC2
     * 
     * @param lastOccurrence
     */
    public void setLastOccurrence(Byte lastOccurrence) {
        this.lastOccurrence = lastOccurrence;
    }

    /** 
     * Get the 'CarrierTierLevel' attribute value. SUM/PXI/BDI/@Q7D
     * 
     * @return value
     */
    public Short getCarrierTierLevel() {
        return carrierTierLevel;
    }

    /** 
     * Set the 'CarrierTierLevel' attribute value. SUM/PXI/BDI/@Q7D
     * 
     * @param carrierTierLevel
     */
    public void setCarrierTierLevel(Short carrierTierLevel) {
        this.carrierTierLevel = carrierTierLevel;
    }
}
