
package com.sabre.webservices.sabrexml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BrandFiltersType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="NonBrandedFares" minOccurs="0" maxOccurs="1">
 *       &lt;xs:complexType>
 *         &lt;xs:attribute type="ns:PreferLevelType" default="Preferred" name="PreferredLevel"/>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:BrandFilterType" name="Brand" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BrandFiltersType implements Serializable
{
    private PreferLevelType nonBrandedFares;
    private List<BrandFilterType> brandList = new ArrayList<BrandFilterType>();

    /** 
     * Get the 'PreferredLevel' attribute value. NonBrand code filter to /BCF/IBC/@SB2 or /BCF/XBC/@SB2 depends on PreferredLevel attribute
     * 
     * @return value
     */
    public PreferLevelType getNonBrandedFares() {
        return nonBrandedFares;
    }

    /** 
     * Set the 'PreferredLevel' attribute value. NonBrand code filter to /BCF/IBC/@SB2 or /BCF/XBC/@SB2 depends on PreferredLevel attribute
     * 
     * @param nonBrandedFares
     */
    public void setNonBrandedFares(PreferLevelType nonBrandedFares) {
        this.nonBrandedFares = nonBrandedFares;
    }

    /** 
     * Get the list of 'Brand' element items. Defines preferred brand ids to be used in a search.
     * 
     * @return list
     */
    public List<BrandFilterType> getBrandList() {
        return brandList;
    }

    /** 
     * Set the list of 'Brand' element items. Defines preferred brand ids to be used in a search.
     * 
     * @param list
     */
    public void setBrandList(List<BrandFilterType> list) {
        brandList = list;
    }
}
