
package com.sabre.webservices.sabrexml;

import com.sabre.services.stl.v01.ApplicationResults;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://services.sabre.com/STL/v01" xmlns:ns1="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContextChangeRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:ApplicationResults"/>
 *       &lt;xs:element name="SecurityToken" minOccurs="0">
 *         &lt;!-- Reference to inner class SecurityToken -->
 *       &lt;/xs:element>
 *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:string" use="optional" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class ContextChangeRS implements Serializable
{
    private ApplicationResults applicationResults;
    private SecurityToken securityToken;
    private List<String> textList = new ArrayList<String>();
    private String version;

    /** 
     * Get the 'ApplicationResults' element value.
     * 
     * @return value
     */
    public ApplicationResults getApplicationResults() {
        return applicationResults;
    }

    /** 
     * Set the 'ApplicationResults' element value.
     * 
     * @param applicationResults
     */
    public void setApplicationResults(ApplicationResults applicationResults) {
        this.applicationResults = applicationResults;
    }

    /** 
     * Get the 'SecurityToken' element value.
     * 
     * @return value
     */
    public SecurityToken getSecurityToken() {
        return securityToken;
    }

    /** 
     * Set the 'SecurityToken' element value.
     * 
     * @param securityToken
     */
    public void setSecurityToken(SecurityToken securityToken) {
        this.securityToken = securityToken;
    }

    /** 
     * Get the list of 'Text' element items.
     * 
     * @return list
     */
    public List<String> getTextList() {
        return textList;
    }

    /** 
     * Set the list of 'Text' element items.
     * 
     * @param list
     */
    public void setTextList(List<String> list) {
        textList = list;
    }

    /** 
     * Get the 'Version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SecurityToken" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:boolean" use="optional" name="Updated"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class SecurityToken implements Serializable
    {
        private String string;
        private Boolean updated;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'Updated' attribute value.
         * 
         * @return value
         */
        public Boolean getUpdated() {
            return updated;
        }

        /** 
         * Set the 'Updated' attribute value.
         * 
         * @param updated
         */
        public void setUpdated(Boolean updated) {
            this.updated = updated;
        }
    }
}
