
package com.sabre.webservices.sabrexml;

import java.io.Serializable;

/** 
 * CurrencyConversionType - Currency Conversion Information
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CurrencyConversionType">
 *   &lt;xs:attribute type="xs:string" use="optional" name="FromCurrency"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ToCurrency"/>
 *   &lt;xs:attribute type="xs:float" use="optional" name="ExchangeRateOne"/>
 *   &lt;xs:attribute type="xs:short" use="optional" name="DecimalPlacesForRateOne"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="IntermmediateCurrency"/>
 *   &lt;xs:attribute type="xs:float" use="optional" name="ExchangeRateTwo"/>
 *   &lt;xs:attribute type="xs:short" use="optional" name="DecimalPlacesForRateTwo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="EffectiveDate"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DiscontinueDate"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CurrencyConversionType implements Serializable
{
    private String fromCurrency;
    private String toCurrency;
    private Float exchangeRateOne;
    private Short decimalPlacesForRateOne;
    private String intermmediateCurrency;
    private Float exchangeRateTwo;
    private Short decimalPlacesForRateTwo;
    private String effectiveDate;
    private String discontinueDate;

    /** 
     * Get the 'FromCurrency' attribute value. From Currency CCD/@C41
     * 
     * @return value
     */
    public String getFromCurrency() {
        return fromCurrency;
    }

    /** 
     * Set the 'FromCurrency' attribute value. From Currency CCD/@C41
     * 
     * @param fromCurrency
     */
    public void setFromCurrency(String fromCurrency) {
        this.fromCurrency = fromCurrency;
    }

    /** 
     * Get the 'ToCurrency' attribute value. To Currency CCD/@C42
     * 
     * @return value
     */
    public String getToCurrency() {
        return toCurrency;
    }

    /** 
     * Set the 'ToCurrency' attribute value. To Currency CCD/@C42
     * 
     * @param toCurrency
     */
    public void setToCurrency(String toCurrency) {
        this.toCurrency = toCurrency;
    }

    /** 
     * Get the 'ExchangeRateOne' attribute value. Exchange Rate One CCD/@C54
     * 
     * @return value
     */
    public Float getExchangeRateOne() {
        return exchangeRateOne;
    }

    /** 
     * Set the 'ExchangeRateOne' attribute value. Exchange Rate One CCD/@C54
     * 
     * @param exchangeRateOne
     */
    public void setExchangeRateOne(Float exchangeRateOne) {
        this.exchangeRateOne = exchangeRateOne;
    }

    /** 
     * Get the 'DecimalPlacesForRateOne' attribute value. Number of decimal places for Exchange Rate One CCD/@Q05
     * 
     * @return value
     */
    public Short getDecimalPlacesForRateOne() {
        return decimalPlacesForRateOne;
    }

    /** 
     * Set the 'DecimalPlacesForRateOne' attribute value. Number of decimal places for Exchange Rate One CCD/@Q05
     * 
     * @param decimalPlacesForRateOne
     */
    public void setDecimalPlacesForRateOne(Short decimalPlacesForRateOne) {
        this.decimalPlacesForRateOne = decimalPlacesForRateOne;
    }

    /** 
     * Get the 'IntermmediateCurrency' attribute value. Intermmediate Currency CCD/@C46
     * 
     * @return value
     */
    public String getIntermmediateCurrency() {
        return intermmediateCurrency;
    }

    /** 
     * Set the 'IntermmediateCurrency' attribute value. Intermmediate Currency CCD/@C46
     * 
     * @param intermmediateCurrency
     */
    public void setIntermmediateCurrency(String intermmediateCurrency) {
        this.intermmediateCurrency = intermmediateCurrency;
    }

    /** 
     * Get the 'ExchangeRateTwo' attribute value. Exchange Rate Two CCD/@C55
     * 
     * @return value
     */
    public Float getExchangeRateTwo() {
        return exchangeRateTwo;
    }

    /** 
     * Set the 'ExchangeRateTwo' attribute value. Exchange Rate Two CCD/@C55
     * 
     * @param exchangeRateTwo
     */
    public void setExchangeRateTwo(Float exchangeRateTwo) {
        this.exchangeRateTwo = exchangeRateTwo;
    }

    /** 
     * Get the 'DecimalPlacesForRateTwo' attribute value. Number of decimal places for Exchange Rate Two CCD/@Q06
     * 
     * @return value
     */
    public Short getDecimalPlacesForRateTwo() {
        return decimalPlacesForRateTwo;
    }

    /** 
     * Set the 'DecimalPlacesForRateTwo' attribute value. Number of decimal places for Exchange Rate Two CCD/@Q06
     * 
     * @param decimalPlacesForRateTwo
     */
    public void setDecimalPlacesForRateTwo(Short decimalPlacesForRateTwo) {
        this.decimalPlacesForRateTwo = decimalPlacesForRateTwo;
    }

    /** 
     * Get the 'EffectiveDate' attribute value. Effective Date CCD/@D06
     * 
     * @return value
     */
    public String getEffectiveDate() {
        return effectiveDate;
    }

    /** 
     * Set the 'EffectiveDate' attribute value. Effective Date CCD/@D06
     * 
     * @param effectiveDate
     */
    public void setEffectiveDate(String effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    /** 
     * Get the 'DiscontinueDate' attribute value. Discontinue Date CCD/@D05
     * 
     * @return value
     */
    public String getDiscontinueDate() {
        return discontinueDate;
    }

    /** 
     * Set the 'DiscontinueDate' attribute value. Discontinue Date CCD/@D05
     * 
     * @param discontinueDate
     */
    public void setDiscontinueDate(String discontinueDate) {
        this.discontinueDate = discontinueDate;
    }
}
