
package com.sabre.webservices.sabrexml;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DeleteSpecialServiceRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="Service" maxOccurs="unbounded">
 *         &lt;!-- Reference to inner class Service -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="VendorPrefs" minOccurs="0">
 *         &lt;!-- Reference to inner class VendorPrefs -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:boolean" use="optional" name="ReturnHostCommand"/>
 *     &lt;xs:attribute type="xs:dateTime" use="optional" name="TimeStamp"/>
 *     &lt;xs:attribute type="xs:string" use="required" fixed="2.2.1" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class DeleteSpecialServiceRQ implements Serializable
{
    private List<Service> serviceList = new ArrayList<Service>();
    private VendorPrefs vendorPrefs;
    private Boolean returnHostCommand;
    private Date timeStamp;
    private String version;

    /** 
     * Get the list of 'Service' element items.
     * 
     * @return list
     */
    public List<Service> getServiceList() {
        return serviceList;
    }

    /** 
     * Set the list of 'Service' element items.
     * 
     * @param list
     */
    public void setServiceList(List<Service> list) {
        serviceList = list;
    }

    /** 
     * Get the 'VendorPrefs' element value.
     * 
     * @return value
     */
    public VendorPrefs getVendorPrefs() {
        return vendorPrefs;
    }

    /** 
     * Set the 'VendorPrefs' element value.
     * 
     * @param vendorPrefs
     */
    public void setVendorPrefs(VendorPrefs vendorPrefs) {
        this.vendorPrefs = vendorPrefs;
    }

    /** 
     * Get the 'ReturnHostCommand' attribute value.
     * 
     * @return value
     */
    public Boolean getReturnHostCommand() {
        return returnHostCommand;
    }

    /** 
     * Set the 'ReturnHostCommand' attribute value.
     * 
     * @param returnHostCommand
     */
    public void setReturnHostCommand(Boolean returnHostCommand) {
        this.returnHostCommand = returnHostCommand;
    }

    /** 
     * Get the 'TimeStamp' attribute value.
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value.
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Service" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="PersonName" minOccurs="0">
     *         &lt;!-- Reference to inner class PersonName -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:integer" use="optional" name="EndRPH"/>
     *     &lt;xs:attribute type="xs:integer" use="required" name="RPH"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Service implements Serializable
    {
        private PersonName personName;
        private BigInteger endRPH;
        private BigInteger RPH;

        /** 
         * Get the 'PersonName' element value.
         * 
         * @return value
         */
        public PersonName getPersonName() {
            return personName;
        }

        /** 
         * Set the 'PersonName' element value.
         * 
         * @param personName
         */
        public void setPersonName(PersonName personName) {
            this.personName = personName;
        }

        /** 
         * Get the 'EndRPH' attribute value.
         * 
         * @return value
         */
        public BigInteger getEndRPH() {
            return endRPH;
        }

        /** 
         * Set the 'EndRPH' attribute value.
         * 
         * @param endRPH
         */
        public void setEndRPH(BigInteger endRPH) {
            this.endRPH = endRPH;
        }

        /** 
         * Get the 'RPH' attribute value.
         * 
         * @return value
         */
        public BigInteger getRPH() {
            return RPH;
        }

        /** 
         * Set the 'RPH' attribute value.
         * 
         * @param RPH
         */
        public void setRPH(BigInteger RPH) {
            this.RPH = RPH;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PersonName" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="NameNumber" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute use="required" name="Action">
         *       &lt;xs:simpleType>
         *         &lt;!-- Reference to inner class Action -->
         *       &lt;/xs:simpleType>
         *     &lt;/xs:attribute>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PersonName implements Serializable
        {
            private List<String> nameNumberList = new ArrayList<String>();
            private Action action;

            /** 
             * Get the list of 'NameNumber' element items.
             * 
             * @return list
             */
            public List<String> getNameNumberList() {
                return nameNumberList;
            }

            /** 
             * Set the list of 'NameNumber' element items.
             * 
             * @param list
             */
            public void setNameNumberList(List<String> list) {
                nameNumberList = list;
            }

            /** 
             * Get the 'Action' attribute value.
             * 
             * @return value
             */
            public Action getAction() {
                return action;
            }

            /** 
             * Set the 'Action' attribute value.
             * 
             * @param action
             */
            public void setAction(Action action) {
                this.action = action;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
             *   &lt;xs:restriction base="xs:string">
             *     &lt;xs:enumeration value="Add"/>
             *     &lt;xs:enumeration value="Modify"/>
             *     &lt;xs:enumeration value="Remove"/>
             *   &lt;/xs:restriction>
             * &lt;/xs:simpleType>
             * </pre>
             */
            public static enum Action implements Serializable {
                ADD("Add"), MODIFY("Modify"), REMOVE("Remove");
                private final String value;

                private Action(String value) {
                    this.value = value;
                }

                public String xmlValue() {
                    return value;
                }

                public static Action convert(String value) {
                    for (Action inst : values()) {
                        if (inst.xmlValue().equals(value)) {
                            return inst;
                        }
                    }
                    return null;
                }
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VendorPrefs" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Airline">
     *         &lt;xs:complexType>
     *           &lt;xs:attribute type="xs:boolean" use="required" name="Hosted"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class VendorPrefs implements Serializable
    {
        private boolean airline;

        /** 
         * Get the 'Hosted' attribute value.
         * 
         * @return value
         */
        public boolean isAirline() {
            return airline;
        }

        /** 
         * Set the 'Hosted' attribute value.
         * 
         * @param airline
         */
        public void setAirline(boolean airline) {
            this.airline = airline;
        }
    }
}
