
package com.sabre.webservices.sabrexml;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DiagnosticInfos">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="DiagnosticInfo" maxOccurs="unbounded">
 *         &lt;!-- Reference to inner class DiagnosticInfo -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:short" use="required" name="Type"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class DiagnosticInfos implements Serializable
{
    private List<DiagnosticInfo> diagnosticInfoList = new ArrayList<DiagnosticInfo>();
    private short type;

    /** 
     * Get the list of 'DiagnosticInfo' element items.
     * 
     * @return list
     */
    public List<DiagnosticInfo> getDiagnosticInfoList() {
        return diagnosticInfoList;
    }

    /** 
     * Set the list of 'DiagnosticInfo' element items.
     * 
     * @param list
     */
    public void setDiagnosticInfoList(List<DiagnosticInfo> list) {
        diagnosticInfoList = list;
    }

    /** 
     * Get the 'Type' attribute value. Diagnostic Number
     * 
     * @return value
     */
    public short getType() {
        return type;
    }

    /** 
     * Set the 'Type' attribute value. Diagnostic Number
     * 
     * @param type
     */
    public void setType(short type) {
        this.type = type;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DiagnosticInfo" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:integer" use="required" name="Line"/>
     *     &lt;xs:attribute type="xs:string" use="required" name="Message"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class DiagnosticInfo implements Serializable
    {
        private BigInteger line;
        private String message;

        /** 
         * Get the 'Line' attribute value. Line number
         * 
         * @return value
         */
        public BigInteger getLine() {
            return line;
        }

        /** 
         * Set the 'Line' attribute value. Line number
         * 
         * @param line
         */
        public void setLine(BigInteger line) {
            this.line = line;
        }

        /** 
         * Get the 'Message' attribute value.
         * 
         * @return value
         */
        public String getMessage() {
            return message;
        }

        /** 
         * Set the 'Message' attribute value.
         * 
         * @param message
         */
        public void setMessage(String message) {
            this.message = message;
        }
    }
}
