
package com.sabre.webservices.sabrexml;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EncodeDecodeRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:choice>
 *       &lt;xs:element name="Decode">
 *         &lt;xs:complexType>
 *           &lt;xs:choice>
 *             &lt;xs:element name="Address">
 *               &lt;!-- Reference to inner class Address -->
 *             &lt;/xs:element>
 *             &lt;xs:element name="Airline">
 *               &lt;xs:complexType>
 *                 &lt;xs:attribute type="xs:string" use="required" name="Code"/>
 *               &lt;/xs:complexType>
 *             &lt;/xs:element>
 *             &lt;xs:element name="CruiseLine">
 *               &lt;xs:complexType>
 *                 &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
 *               &lt;/xs:complexType>
 *             &lt;/xs:element>
 *             &lt;xs:element name="Equipment">
 *               &lt;xs:complexType>
 *                 &lt;xs:attribute type="xs:string" use="optional" name="AirEquipType"/>
 *               &lt;/xs:complexType>
 *             &lt;/xs:element>
 *             &lt;xs:element name="TravelAgency">
 *               &lt;xs:complexType>
 *                 &lt;xs:attribute type="xs:string" use="optional" name="PseudoCityCode"/>
 *               &lt;/xs:complexType>
 *             &lt;/xs:element>
 *             &lt;xs:element name="UniversalAssociate">
 *               &lt;xs:complexType>
 *                 &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
 *               &lt;/xs:complexType>
 *             &lt;/xs:element>
 *           &lt;/xs:choice>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *       &lt;xs:element name="Encode">
 *         &lt;xs:complexType>
 *           &lt;xs:choice>
 *             &lt;xs:element name="Address">
 *               &lt;xs:complexType>
 *                 &lt;xs:choice>
 *                   &lt;xs:element type="xs:string" name="CityName"/>
 *                   &lt;xs:element type="xs:string" name="Country"/>
 *                   &lt;xs:element type="xs:string" name="StateCountyProv"/>
 *                 &lt;/xs:choice>
 *               &lt;/xs:complexType>
 *             &lt;/xs:element>
 *             &lt;xs:element type="xs:string" name="AirEquipmentManufacturer"/>
 *             &lt;xs:element type="xs:string" name="Airline"/>
 *             &lt;xs:element type="xs:string" name="Airport"/>
 *             &lt;xs:element type="xs:string" name="CruiseLine"/>
 *             &lt;xs:element type="xs:string" name="TravelAgency"/>
 *             &lt;xs:element type="xs:string" name="UniversalAssociate"/>
 *           &lt;/xs:choice>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *     &lt;/xs:choice>
 *     &lt;xs:attribute type="xs:string" use="optional" name="ReturnHostCommand"/>
 *     &lt;xs:attribute type="xs:string" use="optional" name="TimeStamp"/>
 *     &lt;xs:attribute type="xs:string" use="required" fixed="2.0.0" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class EncodeDecodeRQ implements Serializable
{
    private int choiceSelect = -1;
    private static final int DECODE_CHOICE = 0;
    private static final int ENCODE_CHOICE = 1;
    private int decodeSelect = -1;
    private static final int ADDRESS_CHOICE = 0;
    private static final int DECODE_AIRLINE_CHOICE = 1;
    private static final int DECODE_CRUISE_LINE_CHOICE = 2;
    private static final int DECODE_EQUIPMENT_CHOICE = 3;
    private static final int DECODE_TRAVEL_AGENCY_CHOICE = 4;
    private static final int DECODE_UNIVERSAL_ASSOCIATE_CHOICE = 5;
    private Address address;
    private String decodeAirline;
    private String decodeCruiseLine;
    private String decodeEquipment;
    private String decodeTravelAgency;
    private String decodeUniversalAssociate;
    private int encodeSelect = -1;
    private static final int ENCODE_ADDRESS_CHOICE = 0;
    private static final int ENCODE_AIR_EQUIPMENT_MANUFACTURER_CHOICE = 1;
    private static final int ENCODE_AIRLINE_CHOICE = 2;
    private static final int ENCODE_AIRPORT_CHOICE = 3;
    private static final int ENCODE_CRUISE_LINE_CHOICE = 4;
    private static final int ENCODE_TRAVEL_AGENCY_CHOICE = 5;
    private static final int ENCODE_UNIVERSAL_ASSOCIATE_CHOICE = 6;
    private int encodeAddressSelect = -1;
    private static final int ENCODE_CITY_NAME_CHOICE = 0;
    private static final int ENCODE_COUNTRY_CHOICE = 1;
    private static final int ENCODE_STATE_COUNTY_PROV_CHOICE = 2;
    private String encodeCityName;
    private String encodeCountry;
    private String encodeStateCountyProv;
    private String encodeAirEquipmentManufacturer;
    private String encodeAirline;
    private String encodeAirport;
    private String encodeCruiseLine;
    private String encodeTravelAgency;
    private String encodeUniversalAssociate;
    private String returnHostCommand;
    private String timeStamp;
    private String version;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Decode is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDecode() {
        return choiceSelect == DECODE_CHOICE;
    }

    private void setDecodeSelect(int choice) {
        setChoiceSelect(DECODE_CHOICE);
        if (decodeSelect == -1) {
            decodeSelect = choice;
        } else if (decodeSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearDecodeSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearDecodeSelect() {
        decodeSelect = -1;
    }

    /** 
     * Check if Address is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAddress() {
        return decodeSelect == ADDRESS_CHOICE;
    }

    /** 
     * Get the 'Address' element value.
     * 
     * @return value
     */
    public Address getAddress() {
        return address;
    }

    /** 
     * Set the 'Address' element value.
     * 
     * @param address
     */
    public void setAddress(Address address) {
        setDecodeSelect(ADDRESS_CHOICE);
        this.address = address;
    }

    /** 
     * Check if DecodeAirline is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDecodeAirline() {
        return decodeSelect == DECODE_AIRLINE_CHOICE;
    }

    /** 
     * Get the 'Code' attribute value.
     * 
     * @return value
     */
    public String getDecodeAirline() {
        return decodeAirline;
    }

    /** 
     * Set the 'Code' attribute value.
     * 
     * @param decodeAirline
     */
    public void setDecodeAirline(String decodeAirline) {
        setDecodeSelect(DECODE_AIRLINE_CHOICE);
        this.decodeAirline = decodeAirline;
    }

    /** 
     * Check if DecodeCruiseLine is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDecodeCruiseLine() {
        return decodeSelect == DECODE_CRUISE_LINE_CHOICE;
    }

    /** 
     * Get the 'Code' attribute value.
     * 
     * @return value
     */
    public String getDecodeCruiseLine() {
        return decodeCruiseLine;
    }

    /** 
     * Set the 'Code' attribute value.
     * 
     * @param decodeCruiseLine
     */
    public void setDecodeCruiseLine(String decodeCruiseLine) {
        setDecodeSelect(DECODE_CRUISE_LINE_CHOICE);
        this.decodeCruiseLine = decodeCruiseLine;
    }

    /** 
     * Check if DecodeEquipment is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDecodeEquipment() {
        return decodeSelect == DECODE_EQUIPMENT_CHOICE;
    }

    /** 
     * Get the 'AirEquipType' attribute value.
     * 
     * @return value
     */
    public String getDecodeEquipment() {
        return decodeEquipment;
    }

    /** 
     * Set the 'AirEquipType' attribute value.
     * 
     * @param decodeEquipment
     */
    public void setDecodeEquipment(String decodeEquipment) {
        setDecodeSelect(DECODE_EQUIPMENT_CHOICE);
        this.decodeEquipment = decodeEquipment;
    }

    /** 
     * Check if DecodeTravelAgency is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDecodeTravelAgency() {
        return decodeSelect == DECODE_TRAVEL_AGENCY_CHOICE;
    }

    /** 
     * Get the 'PseudoCityCode' attribute value.
     * 
     * @return value
     */
    public String getDecodeTravelAgency() {
        return decodeTravelAgency;
    }

    /** 
     * Set the 'PseudoCityCode' attribute value.
     * 
     * @param decodeTravelAgency
     */
    public void setDecodeTravelAgency(String decodeTravelAgency) {
        setDecodeSelect(DECODE_TRAVEL_AGENCY_CHOICE);
        this.decodeTravelAgency = decodeTravelAgency;
    }

    /** 
     * Check if DecodeUniversalAssociate is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDecodeUniversalAssociate() {
        return decodeSelect == DECODE_UNIVERSAL_ASSOCIATE_CHOICE;
    }

    /** 
     * Get the 'Code' attribute value.
     * 
     * @return value
     */
    public String getDecodeUniversalAssociate() {
        return decodeUniversalAssociate;
    }

    /** 
     * Set the 'Code' attribute value.
     * 
     * @param decodeUniversalAssociate
     */
    public void setDecodeUniversalAssociate(String decodeUniversalAssociate) {
        setDecodeSelect(DECODE_UNIVERSAL_ASSOCIATE_CHOICE);
        this.decodeUniversalAssociate = decodeUniversalAssociate;
    }

    /** 
     * Check if Encode is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifEncode() {
        return choiceSelect == ENCODE_CHOICE;
    }

    private void setEncodeSelect(int choice) {
        setChoiceSelect(ENCODE_CHOICE);
        if (encodeSelect == -1) {
            encodeSelect = choice;
        } else if (encodeSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearEncodeSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearEncodeSelect() {
        encodeSelect = -1;
    }

    /** 
     * Check if EncodeAddress is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifEncodeAddress() {
        return encodeSelect == ENCODE_ADDRESS_CHOICE;
    }

    private void setEncodeAddressSelect(int choice) {
        setEncodeSelect(ENCODE_ADDRESS_CHOICE);
        if (encodeAddressSelect == -1) {
            encodeAddressSelect = choice;
        } else if (encodeAddressSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearEncodeAddressSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearEncodeAddressSelect() {
        encodeAddressSelect = -1;
    }

    /** 
     * Check if EncodeCityName is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifEncodeCityName() {
        return encodeAddressSelect == ENCODE_CITY_NAME_CHOICE;
    }

    /** 
     * Get the 'CityName' element value.
     * 
     * @return value
     */
    public String getEncodeCityName() {
        return encodeCityName;
    }

    /** 
     * Set the 'CityName' element value.
     * 
     * @param encodeCityName
     */
    public void setEncodeCityName(String encodeCityName) {
        setEncodeAddressSelect(ENCODE_CITY_NAME_CHOICE);
        this.encodeCityName = encodeCityName;
    }

    /** 
     * Check if EncodeCountry is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifEncodeCountry() {
        return encodeAddressSelect == ENCODE_COUNTRY_CHOICE;
    }

    /** 
     * Get the 'Country' element value.
     * 
     * @return value
     */
    public String getEncodeCountry() {
        return encodeCountry;
    }

    /** 
     * Set the 'Country' element value.
     * 
     * @param encodeCountry
     */
    public void setEncodeCountry(String encodeCountry) {
        setEncodeAddressSelect(ENCODE_COUNTRY_CHOICE);
        this.encodeCountry = encodeCountry;
    }

    /** 
     * Check if EncodeStateCountyProv is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifEncodeStateCountyProv() {
        return encodeAddressSelect == ENCODE_STATE_COUNTY_PROV_CHOICE;
    }

    /** 
     * Get the 'StateCountyProv' element value.
     * 
     * @return value
     */
    public String getEncodeStateCountyProv() {
        return encodeStateCountyProv;
    }

    /** 
     * Set the 'StateCountyProv' element value.
     * 
     * @param encodeStateCountyProv
     */
    public void setEncodeStateCountyProv(String encodeStateCountyProv) {
        setEncodeAddressSelect(ENCODE_STATE_COUNTY_PROV_CHOICE);
        this.encodeStateCountyProv = encodeStateCountyProv;
    }

    /** 
     * Check if EncodeAirEquipmentManufacturer is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifEncodeAirEquipmentManufacturer() {
        return encodeSelect == ENCODE_AIR_EQUIPMENT_MANUFACTURER_CHOICE;
    }

    /** 
     * Get the 'AirEquipmentManufacturer' element value.
     * 
     * @return value
     */
    public String getEncodeAirEquipmentManufacturer() {
        return encodeAirEquipmentManufacturer;
    }

    /** 
     * Set the 'AirEquipmentManufacturer' element value.
     * 
     * @param encodeAirEquipmentManufacturer
     */
    public void setEncodeAirEquipmentManufacturer(
            String encodeAirEquipmentManufacturer) {
        setEncodeSelect(ENCODE_AIR_EQUIPMENT_MANUFACTURER_CHOICE);
        this.encodeAirEquipmentManufacturer = encodeAirEquipmentManufacturer;
    }

    /** 
     * Check if EncodeAirline is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifEncodeAirline() {
        return encodeSelect == ENCODE_AIRLINE_CHOICE;
    }

    /** 
     * Get the 'Airline' element value.
     * 
     * @return value
     */
    public String getEncodeAirline() {
        return encodeAirline;
    }

    /** 
     * Set the 'Airline' element value.
     * 
     * @param encodeAirline
     */
    public void setEncodeAirline(String encodeAirline) {
        setEncodeSelect(ENCODE_AIRLINE_CHOICE);
        this.encodeAirline = encodeAirline;
    }

    /** 
     * Check if EncodeAirport is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifEncodeAirport() {
        return encodeSelect == ENCODE_AIRPORT_CHOICE;
    }

    /** 
     * Get the 'Airport' element value.
     * 
     * @return value
     */
    public String getEncodeAirport() {
        return encodeAirport;
    }

    /** 
     * Set the 'Airport' element value.
     * 
     * @param encodeAirport
     */
    public void setEncodeAirport(String encodeAirport) {
        setEncodeSelect(ENCODE_AIRPORT_CHOICE);
        this.encodeAirport = encodeAirport;
    }

    /** 
     * Check if EncodeCruiseLine is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifEncodeCruiseLine() {
        return encodeSelect == ENCODE_CRUISE_LINE_CHOICE;
    }

    /** 
     * Get the 'CruiseLine' element value.
     * 
     * @return value
     */
    public String getEncodeCruiseLine() {
        return encodeCruiseLine;
    }

    /** 
     * Set the 'CruiseLine' element value.
     * 
     * @param encodeCruiseLine
     */
    public void setEncodeCruiseLine(String encodeCruiseLine) {
        setEncodeSelect(ENCODE_CRUISE_LINE_CHOICE);
        this.encodeCruiseLine = encodeCruiseLine;
    }

    /** 
     * Check if EncodeTravelAgency is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifEncodeTravelAgency() {
        return encodeSelect == ENCODE_TRAVEL_AGENCY_CHOICE;
    }

    /** 
     * Get the 'TravelAgency' element value.
     * 
     * @return value
     */
    public String getEncodeTravelAgency() {
        return encodeTravelAgency;
    }

    /** 
     * Set the 'TravelAgency' element value.
     * 
     * @param encodeTravelAgency
     */
    public void setEncodeTravelAgency(String encodeTravelAgency) {
        setEncodeSelect(ENCODE_TRAVEL_AGENCY_CHOICE);
        this.encodeTravelAgency = encodeTravelAgency;
    }

    /** 
     * Check if EncodeUniversalAssociate is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifEncodeUniversalAssociate() {
        return encodeSelect == ENCODE_UNIVERSAL_ASSOCIATE_CHOICE;
    }

    /** 
     * Get the 'UniversalAssociate' element value.
     * 
     * @return value
     */
    public String getEncodeUniversalAssociate() {
        return encodeUniversalAssociate;
    }

    /** 
     * Set the 'UniversalAssociate' element value.
     * 
     * @param encodeUniversalAssociate
     */
    public void setEncodeUniversalAssociate(String encodeUniversalAssociate) {
        setEncodeSelect(ENCODE_UNIVERSAL_ASSOCIATE_CHOICE);
        this.encodeUniversalAssociate = encodeUniversalAssociate;
    }

    /** 
     * Get the 'ReturnHostCommand' attribute value.
     * 
     * @return value
     */
    public String getReturnHostCommand() {
        return returnHostCommand;
    }

    /** 
     * Set the 'ReturnHostCommand' attribute value.
     * 
     * @param returnHostCommand
     */
    public void setReturnHostCommand(String returnHostCommand) {
        this.returnHostCommand = returnHostCommand;
    }

    /** 
     * Get the 'TimeStamp' attribute value.
     * 
     * @return value
     */
    public String getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value.
     * 
     * @param timeStamp
     */
    public void setTimeStamp(String timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Address">
     *   &lt;xs:complexType>
     *     &lt;xs:choice>
     *       &lt;xs:element name="CityName">
     *         &lt;xs:complexType>
     *           &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:string" name="CountryCode"/>
     *       &lt;xs:element name="StateCountyProv">
     *         &lt;xs:complexType>
     *           &lt;xs:attribute type="xs:string" use="optional" name="StateCode"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *     &lt;/xs:choice>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Address implements Serializable
    {
        private int addressSelect = -1;
        private static final int CITY_NAME_CHOICE = 0;
        private static final int COUNTRY_CODE_CHOICE = 1;
        private static final int STATE_COUNTY_PROV_CHOICE = 2;
        private String cityName;
        private String countryCode;
        private String stateCountyProv;

        private void setAddressSelect(int choice) {
            if (addressSelect == -1) {
                addressSelect = choice;
            } else if (addressSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearAddressSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearAddressSelect() {
            addressSelect = -1;
        }

        /** 
         * Check if CityName is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifCityName() {
            return addressSelect == CITY_NAME_CHOICE;
        }

        /** 
         * Get the 'LocationCode' attribute value.
         * 
         * @return value
         */
        public String getCityName() {
            return cityName;
        }

        /** 
         * Set the 'LocationCode' attribute value.
         * 
         * @param cityName
         */
        public void setCityName(String cityName) {
            setAddressSelect(CITY_NAME_CHOICE);
            this.cityName = cityName;
        }

        /** 
         * Check if CountryCode is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifCountryCode() {
            return addressSelect == COUNTRY_CODE_CHOICE;
        }

        /** 
         * Get the 'CountryCode' element value.
         * 
         * @return value
         */
        public String getCountryCode() {
            return countryCode;
        }

        /** 
         * Set the 'CountryCode' element value.
         * 
         * @param countryCode
         */
        public void setCountryCode(String countryCode) {
            setAddressSelect(COUNTRY_CODE_CHOICE);
            this.countryCode = countryCode;
        }

        /** 
         * Check if StateCountyProv is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifStateCountyProv() {
            return addressSelect == STATE_COUNTY_PROV_CHOICE;
        }

        /** 
         * Get the 'StateCode' attribute value.
         * 
         * @return value
         */
        public String getStateCountyProv() {
            return stateCountyProv;
        }

        /** 
         * Set the 'StateCode' attribute value.
         * 
         * @param stateCountyProv
         */
        public void setStateCountyProv(String stateCountyProv) {
            setAddressSelect(STATE_COUNTY_PROV_CHOICE);
            this.stateCountyProv = stateCountyProv;
        }
    }
}
