
package com.sabre.webservices.sabrexml;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EndTransactionRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="EndTransaction" minOccurs="0">
 *         &lt;!-- Reference to inner class EndTransaction -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="Source" minOccurs="0">
 *         &lt;!-- Reference to inner class Source -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:boolean" use="optional" name="ReturnHostCommand"/>
 *     &lt;xs:attribute type="xs:dateTime" use="optional" name="TimeStamp"/>
 *     &lt;xs:attribute type="xs:string" use="required" fixed="2.1.0" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class EndTransactionRQ implements Serializable
{
    private EndTransaction endTransaction;
    private Source source;
    private Boolean returnHostCommand;
    private Date timeStamp;
    private String version;

    /** 
     * Get the 'EndTransaction' element value.
     * 
     * @return value
     */
    public EndTransaction getEndTransaction() {
        return endTransaction;
    }

    /** 
     * Set the 'EndTransaction' element value.
     * 
     * @param endTransaction
     */
    public void setEndTransaction(EndTransaction endTransaction) {
        this.endTransaction = endTransaction;
    }

    /** 
     * Get the 'Source' element value.
     * 
     * @return value
     */
    public Source getSource() {
        return source;
    }

    /** 
     * Set the 'Source' element value.
     * 
     * @param source
     */
    public void setSource(Source source) {
        this.source = source;
    }

    /** 
     * Get the 'ReturnHostCommand' attribute value.
     * 
     * @return value
     */
    public Boolean getReturnHostCommand() {
        return returnHostCommand;
    }

    /** 
     * Set the 'ReturnHostCommand' attribute value.
     * 
     * @param returnHostCommand
     */
    public void setReturnHostCommand(Boolean returnHostCommand) {
        this.returnHostCommand = returnHostCommand;
    }

    /** 
     * Get the 'TimeStamp' attribute value.
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value.
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EndTransaction" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Email" minOccurs="0">
     *         &lt;!-- Reference to inner class Email -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ScheduleChange" minOccurs="0">
     *         &lt;!-- Reference to inner class ScheduleChange -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class EndTransaction implements Serializable
    {
        private Email email;
        private ScheduleChange scheduleChange;
        private boolean ind;

        /** 
         * Get the 'Email' element value.
         * 
         * @return value
         */
        public Email getEmail() {
            return email;
        }

        /** 
         * Set the 'Email' element value.
         * 
         * @param email
         */
        public void setEmail(Email email) {
            this.email = email;
        }

        /** 
         * Get the 'ScheduleChange' element value.
         * 
         * @return value
         */
        public ScheduleChange getScheduleChange() {
            return scheduleChange;
        }

        /** 
         * Set the 'ScheduleChange' element value.
         * 
         * @param scheduleChange
         */
        public void setScheduleChange(ScheduleChange scheduleChange) {
            this.scheduleChange = scheduleChange;
        }

        /** 
         * Get the 'Ind' attribute value.
         * 
         * @return value
         */
        public boolean isInd() {
            return ind;
        }

        /** 
         * Set the 'Ind' attribute value.
         * 
         * @param ind
         */
        public void setInd(boolean ind) {
            this.ind = ind;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Email" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="eTicket" minOccurs="0">
         *         &lt;!-- Reference to inner class ETicket -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Invoice" minOccurs="0">
         *         &lt;!-- Reference to inner class Invoice -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Itinerary" minOccurs="0">
         *         &lt;!-- Reference to inner class Itinerary -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="PersonName" minOccurs="0">
         *         &lt;!-- Reference to inner class PersonName -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Email implements Serializable
        {
            private ETicket ETicket;
            private Invoice invoice;
            private Itinerary itinerary;
            private PersonName personName;
            private boolean ind;

            /** 
             * Get the 'eTicket' element value.
             * 
             * @return value
             */
            public ETicket getETicket() {
                return ETicket;
            }

            /** 
             * Set the 'eTicket' element value.
             * 
             * @param eTicket
             */
            public void setETicket(ETicket eTicket) {
                ETicket = eTicket;
            }

            /** 
             * Get the 'Invoice' element value.
             * 
             * @return value
             */
            public Invoice getInvoice() {
                return invoice;
            }

            /** 
             * Set the 'Invoice' element value.
             * 
             * @param invoice
             */
            public void setInvoice(Invoice invoice) {
                this.invoice = invoice;
            }

            /** 
             * Get the 'Itinerary' element value.
             * 
             * @return value
             */
            public Itinerary getItinerary() {
                return itinerary;
            }

            /** 
             * Set the 'Itinerary' element value.
             * 
             * @param itinerary
             */
            public void setItinerary(Itinerary itinerary) {
                this.itinerary = itinerary;
            }

            /** 
             * Get the 'PersonName' element value.
             * 
             * @return value
             */
            public PersonName getPersonName() {
                return personName;
            }

            /** 
             * Set the 'PersonName' element value.
             * 
             * @param personName
             */
            public void setPersonName(PersonName personName) {
                this.personName = personName;
            }

            /** 
             * Get the 'Ind' attribute value.
             * 
             * @return value
             */
            public boolean isInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value.
             * 
             * @param ind
             */
            public void setInd(boolean ind) {
                this.ind = ind;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="eTicket" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="PDF" minOccurs="0">
             *         &lt;!-- Reference to inner class PDF -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ETicket implements Serializable
            {
                private PDF PDF1;
                private boolean ind;

                /** 
                 * Get the 'PDF' element value.
                 * 
                 * @return value
                 */
                public PDF getPDF1() {
                    return PDF1;
                }

                /** 
                 * Set the 'PDF' element value.
                 * 
                 * @param PDF1
                 */
                public void setPDF1(PDF PDF1) {
                    this.PDF1 = PDF1;
                }

                /** 
                 * Get the 'Ind' attribute value.
                 * 
                 * @return value
                 */
                public boolean isInd() {
                    return ind;
                }

                /** 
                 * Set the 'Ind' attribute value.
                 * 
                 * @param ind
                 */
                public void setInd(boolean ind) {
                    this.ind = ind;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PDF" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class PDF implements Serializable
                {
                    private boolean ind;

                    /** 
                     * Get the 'Ind' attribute value.
                     * 
                     * @return value
                     */
                    public boolean isInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value.
                     * 
                     * @param ind
                     */
                    public void setInd(boolean ind) {
                        this.ind = ind;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Invoice" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Invoice implements Serializable
            {
                private boolean ind;

                /** 
                 * Get the 'Ind' attribute value.
                 * 
                 * @return value
                 */
                public boolean isInd() {
                    return ind;
                }

                /** 
                 * Set the 'Ind' attribute value.
                 * 
                 * @param ind
                 */
                public void setInd(boolean ind) {
                    this.ind = ind;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Itinerary" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="PDF" minOccurs="0">
             *         &lt;!-- Reference to inner class PDF -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Segment" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class Segment -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Itinerary implements Serializable
            {
                private PDF PDF1;
                private List<Segment> segmentList = new ArrayList<Segment>();
                private boolean ind;

                /** 
                 * Get the 'PDF' element value.
                 * 
                 * @return value
                 */
                public PDF getPDF1() {
                    return PDF1;
                }

                /** 
                 * Set the 'PDF' element value.
                 * 
                 * @param PDF1
                 */
                public void setPDF1(PDF PDF1) {
                    this.PDF1 = PDF1;
                }

                /** 
                 * Get the list of 'Segment' element items.
                 * 
                 * @return list
                 */
                public List<Segment> getSegmentList() {
                    return segmentList;
                }

                /** 
                 * Set the list of 'Segment' element items.
                 * 
                 * @param list
                 */
                public void setSegmentList(List<Segment> list) {
                    segmentList = list;
                }

                /** 
                 * Get the 'Ind' attribute value.
                 * 
                 * @return value
                 */
                public boolean isInd() {
                    return ind;
                }

                /** 
                 * Set the 'Ind' attribute value.
                 * 
                 * @param ind
                 */
                public void setInd(boolean ind) {
                    this.ind = ind;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PDF" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class PDF implements Serializable
                {
                    private boolean ind;

                    /** 
                     * Get the 'Ind' attribute value.
                     * 
                     * @return value
                     */
                    public boolean isInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value.
                     * 
                     * @param ind
                     */
                    public void setInd(boolean ind) {
                        this.ind = ind;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Segment" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:integer" use="optional" name="EndNumber"/>
                 *     &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Segment implements Serializable
                {
                    private BigInteger endNumber;
                    private BigInteger number;

                    /** 
                     * Get the 'EndNumber' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getEndNumber() {
                        return endNumber;
                    }

                    /** 
                     * Set the 'EndNumber' attribute value.
                     * 
                     * @param endNumber
                     */
                    public void setEndNumber(BigInteger endNumber) {
                        this.endNumber = endNumber;
                    }

                    /** 
                     * Get the 'Number' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'Number' attribute value.
                     * 
                     * @param number
                     */
                    public void setNumber(BigInteger number) {
                        this.number = number;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PersonName" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="NameNumber"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class PersonName implements Serializable
            {
                private String nameNumber;

                /** 
                 * Get the 'NameNumber' attribute value.
                 * 
                 * @return value
                 */
                public String getNameNumber() {
                    return nameNumber;
                }

                /** 
                 * Set the 'NameNumber' attribute value.
                 * 
                 * @param nameNumber
                 */
                public void setNameNumber(String nameNumber) {
                    this.nameNumber = nameNumber;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ScheduleChange" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ScheduleChange implements Serializable
        {
            private boolean ind;

            /** 
             * Get the 'Ind' attribute value.
             * 
             * @return value
             */
            public boolean isInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value.
             * 
             * @param ind
             */
            public void setInd(boolean ind) {
                this.ind = ind;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Source" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="required" name="ReceivedFrom"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Source implements Serializable
    {
        private String receivedFrom;

        /** 
         * Get the 'ReceivedFrom' attribute value.
         * 
         * @return value
         */
        public String getReceivedFrom() {
            return receivedFrom;
        }

        /** 
         * Set the 'ReceivedFrom' attribute value.
         * 
         * @param receivedFrom
         */
        public void setReceivedFrom(String receivedFrom) {
            this.receivedFrom = receivedFrom;
        }
    }
}
