
package com.sabre.webservices.sabrexml;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareComponent">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="Departure">
 *         &lt;xs:complexType>
 *           &lt;xs:attribute type="xs:string" name="CityCode"/>
 *           &lt;xs:attribute type="xs:string" use="required" name="AirportCode"/>
 *           &lt;xs:attribute type="xs:short" name="IATAAreaCode"/>
 *           &lt;xs:attribute type="xs:string" name="NationCode"/>
 *           &lt;xs:attribute type="xs:string" name="StateProvince"/>
 *           &lt;xs:attribute type="xs:string" use="optional" name="DepartureDate"/>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *       &lt;xs:element name="Arrival">
 *         &lt;xs:complexType>
 *           &lt;xs:attribute type="xs:string" name="CityCode"/>
 *           &lt;xs:attribute type="xs:string" use="required" name="AirportCode"/>
 *           &lt;xs:attribute type="xs:short" name="IATAAreaCode"/>
 *           &lt;xs:attribute type="xs:string" name="NationCode"/>
 *           &lt;xs:attribute type="xs:string" name="StateProvince"/>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *       &lt;xs:element name="Fare" minOccurs="0">
 *         &lt;!-- Reference to inner class Fare -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="NetRemitPublishedFare" minOccurs="0">
 *         &lt;!-- Reference to inner class NetRemitPublishedFare -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="HigherIntermediateFare" minOccurs="0">
 *         &lt;!-- Reference to inner class HigherIntermediateFare -->
 *       &lt;/xs:element>
 *       &lt;xs:element type="ns:DifferentialType" name="Differential" minOccurs="0" maxOccurs="unbounded"/>
 *       &lt;xs:element type="ns:DifferentialType" name="ZeroDifferential" minOccurs="0" maxOccurs="unbounded"/>
 *       &lt;xs:element name="FlightSegments">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element name="FlightSegment" maxOccurs="16">
 *               &lt;!-- Reference to inner class FlightSegment -->
 *             &lt;/xs:element>
 *           &lt;/xs:sequence>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *       &lt;xs:element name="PlusUps" minOccurs="0">
 *         &lt;!-- Reference to inner class PlusUps -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="NetRemitPlusUps" minOccurs="0">
 *         &lt;!-- Reference to inner class NetRemitPlusUps -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="HandlingMarkupDetails" minOccurs="0">
 *         &lt;!-- Reference to inner class HandlingMarkupDetails -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="FareRetailerInfo" minOccurs="0">
 *         &lt;!-- Reference to inner class FareRetailerInfo -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="OC_FeeMatchedGroup" minOccurs="0" maxOccurs="unbounded">
 *         &lt;!-- Reference to inner class OCFeeMatchedGroup -->
 *       &lt;/xs:element>
 *       &lt;xs:element type="ns:PointsRedemptionType" name="PointsRedemption" minOccurs="0" maxOccurs="1"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:unsignedShort" use="optional" name="PricingUnitCount"/>
 *     &lt;xs:attribute type="xs:string" name="PricingUnitType"/>
 *     &lt;xs:attribute type="xs:string" use="optional" name="GlobalDirection"/>
 *     &lt;xs:attribute type="xs:string" use="optional" name="FareCalcDirectionality"/>
 *     &lt;xs:attribute type="xs:string" name="CommencementDate"/>
 *     &lt;xs:attribute type="xs:unsignedShort" name="NumberOfSegments"/>
 *     &lt;xs:attribute type="xs:boolean" name="InterruptedBySideTripInd"/>
 *     &lt;xs:attribute type="xs:boolean" name="EndOfSideTripInd"/>
 *     &lt;xs:attribute type="xs:boolean" name="StopoverInd"/>
 *     &lt;xs:attribute type="xs:string" name="CabinCode"/>
 *     &lt;xs:attribute type="xs:string" name="BrandId"/>
 *     &lt;xs:attribute type="xs:string" name="BrandName"/>
 *     &lt;xs:attribute type="xs:string" name="ProgramCode"/>
 *     &lt;xs:attribute type="xs:string" name="ProgramName"/>
 *     &lt;xs:attribute type="xs:string" name="ProgramSystemCode"/>
 *     &lt;xs:attribute type="xs:unsignedLong" name="ProgramID"/>
 *     &lt;xs:attribute type="xs:unsignedShort" use="optional" name="FareComponentReferenceID"/>
 *     &lt;xs:attribute type="xs:hexBinary" name="FareTypeBitmap"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class FareComponent implements Serializable
{
    private String departureCityCode;
    private String departureAirportCode;
    private Short departureIATAAreaCode;
    private String departureNationCode;
    private String departureStateProvince;
    private String departureDepartureDate;
    private String arrivalCityCode;
    private String arrivalAirportCode;
    private Short arrivalIATAAreaCode;
    private String arrivalNationCode;
    private String arrivalStateProvince;
    private Fare fare;
    private NetRemitPublishedFare netRemitPublishedFare;
    private HigherIntermediateFare higherIntermediateFare;
    private List<DifferentialType> differentialList = new ArrayList<DifferentialType>();
    private List<DifferentialType> zeroDifferentialList = new ArrayList<DifferentialType>();
    private List<FlightSegment> flightSegmentList = new ArrayList<FlightSegment>();
    private PlusUps plusUps;
    private NetRemitPlusUps netRemitPlusUps;
    private HandlingMarkupDetails handlingMarkupDetails;
    private FareRetailerInfo fareRetailerInfo;
    private List<OCFeeMatchedGroup> OCFeeMatchedGroupList = new ArrayList<OCFeeMatchedGroup>();
    private PointsRedemptionType pointsRedemption;
    private String pricingUnitCount;
    private String pricingUnitType;
    private String globalDirection;
    private String fareCalcDirectionality;
    private String commencementDate;
    private String numberOfSegments;
    private Boolean interruptedBySideTripInd;
    private Boolean endOfSideTripInd;
    private Boolean stopoverInd;
    private String cabinCode;
    private String brandId;
    private String brandName;
    private String programCode;
    private String programName;
    private String programSystemCode;
    private String programID;
    private String fareComponentReferenceID;
    private byte[] fareTypeBitmap;

    /** 
     * Get the 'CityCode' attribute value.  CAL/@A11
     * 
     * @return value
     */
    public String getDepartureCityCode() {
        return departureCityCode;
    }

    /** 
     * Set the 'CityCode' attribute value.  CAL/@A11
     * 
     * @param departureCityCode
     */
    public void setDepartureCityCode(String departureCityCode) {
        this.departureCityCode = departureCityCode;
    }

    /** 
     * Get the 'AirportCode' attribute value.  CAL/@A01
     * 
     * @return value
     */
    public String getDepartureAirportCode() {
        return departureAirportCode;
    }

    /** 
     * Set the 'AirportCode' attribute value.  CAL/@A01
     * 
     * @param departureAirportCode
     */
    public void setDepartureAirportCode(String departureAirportCode) {
        this.departureAirportCode = departureAirportCode;
    }

    /** 
     * Get the 'IATAAreaCode' attribute value.  CAL/@A51
     * 
     * @return value
     */
    public Short getDepartureIATAAreaCode() {
        return departureIATAAreaCode;
    }

    /** 
     * Set the 'IATAAreaCode' attribute value.  CAL/@A51
     * 
     * @param departureIATAAreaCode
     */
    public void setDepartureIATAAreaCode(Short departureIATAAreaCode) {
        this.departureIATAAreaCode = departureIATAAreaCode;
    }

    /** 
     * Get the 'NationCode' attribute value.  CAL/@A41
     * 
     * @return value
     */
    public String getDepartureNationCode() {
        return departureNationCode;
    }

    /** 
     * Set the 'NationCode' attribute value.  CAL/@A41
     * 
     * @param departureNationCode
     */
    public void setDepartureNationCode(String departureNationCode) {
        this.departureNationCode = departureNationCode;
    }

    /** 
     * Get the 'StateProvince' attribute value.  CAL/@A31
     * 
     * @return value
     */
    public String getDepartureStateProvince() {
        return departureStateProvince;
    }

    /** 
     * Set the 'StateProvince' attribute value.  CAL/@A31
     * 
     * @param departureStateProvince
     */
    public void setDepartureStateProvince(String departureStateProvince) {
        this.departureStateProvince = departureStateProvince;
    }

    /** 
     * Get the 'DepartureDate' attribute value.  CAL/ERD/@D08
     * 
     * @return value
     */
    public String getDepartureDepartureDate() {
        return departureDepartureDate;
    }

    /** 
     * Set the 'DepartureDate' attribute value.  CAL/ERD/@D08
     * 
     * @param departureDepartureDate
     */
    public void setDepartureDepartureDate(String departureDepartureDate) {
        this.departureDepartureDate = departureDepartureDate;
    }

    /** 
     * Get the 'CityCode' attribute value.  CAL/@A12
     * 
     * @return value
     */
    public String getArrivalCityCode() {
        return arrivalCityCode;
    }

    /** 
     * Set the 'CityCode' attribute value.  CAL/@A12
     * 
     * @param arrivalCityCode
     */
    public void setArrivalCityCode(String arrivalCityCode) {
        this.arrivalCityCode = arrivalCityCode;
    }

    /** 
     * Get the 'AirportCode' attribute value.  CAL/@A02
     * 
     * @return value
     */
    public String getArrivalAirportCode() {
        return arrivalAirportCode;
    }

    /** 
     * Set the 'AirportCode' attribute value.  CAL/@A02
     * 
     * @param arrivalAirportCode
     */
    public void setArrivalAirportCode(String arrivalAirportCode) {
        this.arrivalAirportCode = arrivalAirportCode;
    }

    /** 
     * Get the 'IATAAreaCode' attribute value.  CAL/@A52
     * 
     * @return value
     */
    public Short getArrivalIATAAreaCode() {
        return arrivalIATAAreaCode;
    }

    /** 
     * Set the 'IATAAreaCode' attribute value.  CAL/@A52
     * 
     * @param arrivalIATAAreaCode
     */
    public void setArrivalIATAAreaCode(Short arrivalIATAAreaCode) {
        this.arrivalIATAAreaCode = arrivalIATAAreaCode;
    }

    /** 
     * Get the 'NationCode' attribute value.  CAL/@A42
     * 
     * @return value
     */
    public String getArrivalNationCode() {
        return arrivalNationCode;
    }

    /** 
     * Set the 'NationCode' attribute value.  CAL/@A42
     * 
     * @param arrivalNationCode
     */
    public void setArrivalNationCode(String arrivalNationCode) {
        this.arrivalNationCode = arrivalNationCode;
    }

    /** 
     * Get the 'StateProvince' attribute value.  CAL/@A32
     * 
     * @return value
     */
    public String getArrivalStateProvince() {
        return arrivalStateProvince;
    }

    /** 
     * Set the 'StateProvince' attribute value.  CAL/@A32
     * 
     * @param arrivalStateProvince
     */
    public void setArrivalStateProvince(String arrivalStateProvince) {
        this.arrivalStateProvince = arrivalStateProvince;
    }

    /** 
     * Get the 'Fare' element value.
     * 
     * @return value
     */
    public Fare getFare() {
        return fare;
    }

    /** 
     * Set the 'Fare' element value.
     * 
     * @param fare
     */
    public void setFare(Fare fare) {
        this.fare = fare;
    }

    /** 
     * Get the 'NetRemitPublishedFare' element value.
     * 
     * @return value
     */
    public NetRemitPublishedFare getNetRemitPublishedFare() {
        return netRemitPublishedFare;
    }

    /** 
     * Set the 'NetRemitPublishedFare' element value.
     * 
     * @param netRemitPublishedFare
     */
    public void setNetRemitPublishedFare(
            NetRemitPublishedFare netRemitPublishedFare) {
        this.netRemitPublishedFare = netRemitPublishedFare;
    }

    /** 
     * Get the 'HigherIntermediateFare' element value.
     * 
     * @return value
     */
    public HigherIntermediateFare getHigherIntermediateFare() {
        return higherIntermediateFare;
    }

    /** 
     * Set the 'HigherIntermediateFare' element value.
     * 
     * @param higherIntermediateFare
     */
    public void setHigherIntermediateFare(
            HigherIntermediateFare higherIntermediateFare) {
        this.higherIntermediateFare = higherIntermediateFare;
    }

    /** 
     * Get the list of 'Differential' element items.
     * 
     * @return list
     */
    public List<DifferentialType> getDifferentialList() {
        return differentialList;
    }

    /** 
     * Set the list of 'Differential' element items.
     * 
     * @param list
     */
    public void setDifferentialList(List<DifferentialType> list) {
        differentialList = list;
    }

    /** 
     * Get the list of 'ZeroDifferential' element items.
     * 
     * @return list
     */
    public List<DifferentialType> getZeroDifferentialList() {
        return zeroDifferentialList;
    }

    /** 
     * Set the list of 'ZeroDifferential' element items.
     * 
     * @param list
     */
    public void setZeroDifferentialList(List<DifferentialType> list) {
        zeroDifferentialList = list;
    }

    /** 
     * Get the list of 'FlightSegment' element items.
     * 
     * @return list
     */
    public List<FlightSegment> getFlightSegmentList() {
        return flightSegmentList;
    }

    /** 
     * Set the list of 'FlightSegment' element items.
     * 
     * @param list
     */
    public void setFlightSegmentList(List<FlightSegment> list) {
        flightSegmentList = list;
    }

    /** 
     * Get the 'PlusUps' element value.
     * 
     * @return value
     */
    public PlusUps getPlusUps() {
        return plusUps;
    }

    /** 
     * Set the 'PlusUps' element value.
     * 
     * @param plusUps
     */
    public void setPlusUps(PlusUps plusUps) {
        this.plusUps = plusUps;
    }

    /** 
     * Get the 'NetRemitPlusUps' element value.
     * 
     * @return value
     */
    public NetRemitPlusUps getNetRemitPlusUps() {
        return netRemitPlusUps;
    }

    /** 
     * Set the 'NetRemitPlusUps' element value.
     * 
     * @param netRemitPlusUps
     */
    public void setNetRemitPlusUps(NetRemitPlusUps netRemitPlusUps) {
        this.netRemitPlusUps = netRemitPlusUps;
    }

    /** 
     * Get the 'HandlingMarkupDetails' element value.
     * 
     * @return value
     */
    public HandlingMarkupDetails getHandlingMarkupDetails() {
        return handlingMarkupDetails;
    }

    /** 
     * Set the 'HandlingMarkupDetails' element value.
     * 
     * @param handlingMarkupDetails
     */
    public void setHandlingMarkupDetails(
            HandlingMarkupDetails handlingMarkupDetails) {
        this.handlingMarkupDetails = handlingMarkupDetails;
    }

    /** 
     * Get the 'FareRetailerInfo' element value.
     * 
     * @return value
     */
    public FareRetailerInfo getFareRetailerInfo() {
        return fareRetailerInfo;
    }

    /** 
     * Set the 'FareRetailerInfo' element value.
     * 
     * @param fareRetailerInfo
     */
    public void setFareRetailerInfo(FareRetailerInfo fareRetailerInfo) {
        this.fareRetailerInfo = fareRetailerInfo;
    }

    /** 
     * Get the list of 'OC_FeeMatchedGroup' element items.
     * 
     * @return list
     */
    public List<OCFeeMatchedGroup> getOCFeeMatchedGroupList() {
        return OCFeeMatchedGroupList;
    }

    /** 
     * Set the list of 'OC_FeeMatchedGroup' element items.
     * 
     * @param list
     */
    public void setOCFeeMatchedGroupList(List<OCFeeMatchedGroup> list) {
        OCFeeMatchedGroupList = list;
    }

    /** 
     * Get the 'PointsRedemption' element value.
     * 
     * @return value
     */
    public PointsRedemptionType getPointsRedemption() {
        return pointsRedemption;
    }

    /** 
     * Set the 'PointsRedemption' element value.
     * 
     * @param pointsRedemption
     */
    public void setPointsRedemption(PointsRedemptionType pointsRedemption) {
        this.pointsRedemption = pointsRedemption;
    }

    /** 
     * Get the 'PricingUnitCount' attribute value.  CAL/@Q4J
     * 
     * @return value
     */
    public String getPricingUnitCount() {
        return pricingUnitCount;
    }

    /** 
     * Set the 'PricingUnitCount' attribute value.  CAL/@Q4J
     * 
     * @param pricingUnitCount
     */
    public void setPricingUnitCount(String pricingUnitCount) {
        this.pricingUnitCount = pricingUnitCount;
    }

    /** 
     * Get the 'PricingUnitType' attribute value.  CAL/@N1K
     * 
     * @return value
     */
    public String getPricingUnitType() {
        return pricingUnitType;
    }

    /** 
     * Set the 'PricingUnitType' attribute value.  CAL/@N1K
     * 
     * @param pricingUnitType
     */
    public void setPricingUnitType(String pricingUnitType) {
        this.pricingUnitType = pricingUnitType;
    }

    /** 
     * Get the 'GlobalDirection' attribute value.  CAL/@A60
     * 
     * @return value
     */
    public String getGlobalDirection() {
        return globalDirection;
    }

    /** 
     * Set the 'GlobalDirection' attribute value.  CAL/@A60
     * 
     * @param globalDirection
     */
    public void setGlobalDirection(String globalDirection) {
        this.globalDirection = globalDirection;
    }

    /** 
     * Get the 'FareCalcDirectionality' attribute value.   ( either TO or FR) CAL/@S70
     * 
     * @return value
     */
    public String getFareCalcDirectionality() {
        return fareCalcDirectionality;
    }

    /** 
     * Set the 'FareCalcDirectionality' attribute value.   ( either TO or FR) CAL/@S70
     * 
     * @param fareCalcDirectionality
     */
    public void setFareCalcDirectionality(String fareCalcDirectionality) {
        this.fareCalcDirectionality = fareCalcDirectionality;
    }

    /** 
     * Get the 'CommencementDate' attribute value.  CAL/@D00
     * 
     * @return value
     */
    public String getCommencementDate() {
        return commencementDate;
    }

    /** 
     * Set the 'CommencementDate' attribute value.  CAL/@D00
     * 
     * @param commencementDate
     */
    public void setCommencementDate(String commencementDate) {
        this.commencementDate = commencementDate;
    }

    /** 
     * Get the 'NumberOfSegments' attribute value.  CAL/@Q0U
     * 
     * @return value
     */
    public String getNumberOfSegments() {
        return numberOfSegments;
    }

    /** 
     * Set the 'NumberOfSegments' attribute value.  CAL/@Q0U
     * 
     * @param numberOfSegments
     */
    public void setNumberOfSegments(String numberOfSegments) {
        this.numberOfSegments = numberOfSegments;
    }

    /** 
     * Get the 'InterruptedBySideTripInd' attribute value.  CAL/@P2N
     * 
     * @return value
     */
    public Boolean getInterruptedBySideTripInd() {
        return interruptedBySideTripInd;
    }

    /** 
     * Set the 'InterruptedBySideTripInd' attribute value.  CAL/@P2N
     * 
     * @param interruptedBySideTripInd
     */
    public void setInterruptedBySideTripInd(Boolean interruptedBySideTripInd) {
        this.interruptedBySideTripInd = interruptedBySideTripInd;
    }

    /** 
     * Get the 'EndOfSideTripInd' attribute value.  CAL/SEG/@S08
     * 
     * @return value
     */
    public Boolean getEndOfSideTripInd() {
        return endOfSideTripInd;
    }

    /** 
     * Set the 'EndOfSideTripInd' attribute value.  CAL/SEG/@S08
     * 
     * @param endOfSideTripInd
     */
    public void setEndOfSideTripInd(Boolean endOfSideTripInd) {
        this.endOfSideTripInd = endOfSideTripInd;
    }

    /** 
     * Get the 'StopoverInd' attribute value.  CAL/@P2M
     * 
     * @return value
     */
    public Boolean getStopoverInd() {
        return stopoverInd;
    }

    /** 
     * Set the 'StopoverInd' attribute value.  CAL/@P2M
     * 
     * @param stopoverInd
     */
    public void setStopoverInd(Boolean stopoverInd) {
        this.stopoverInd = stopoverInd;
    }

    /** 
     * Get the 'CabinCode' attribute value.  CAL/@N00
     * 
     * @return value
     */
    public String getCabinCode() {
        return cabinCode;
    }

    /** 
     * Set the 'CabinCode' attribute value.  CAL/@N00
     * 
     * @param cabinCode
     */
    public void setCabinCode(String cabinCode) {
        this.cabinCode = cabinCode;
    }

    /** 
     * Get the 'BrandId' attribute value.  CAL/@SB2
     * 
     * @return value
     */
    public String getBrandId() {
        return brandId;
    }

    /** 
     * Set the 'BrandId' attribute value.  CAL/@SB2
     * 
     * @param brandId
     */
    public void setBrandId(String brandId) {
        this.brandId = brandId;
    }

    /** 
     * Get the 'BrandName' attribute value.  CAL/@SB3
     * 
     * @return value
     */
    public String getBrandName() {
        return brandName;
    }

    /** 
     * Set the 'BrandName' attribute value.  CAL/@SB3
     * 
     * @param brandName
     */
    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    /** 
     * Get the 'ProgramCode' attribute value.  CAL/@SC0
     * 
     * @return value
     */
    public String getProgramCode() {
        return programCode;
    }

    /** 
     * Set the 'ProgramCode' attribute value.  CAL/@SC0
     * 
     * @param programCode
     */
    public void setProgramCode(String programCode) {
        this.programCode = programCode;
    }

    /** 
     * Get the 'ProgramName' attribute value.  CAL/@SC2
     * 
     * @return value
     */
    public String getProgramName() {
        return programName;
    }

    /** 
     * Set the 'ProgramName' attribute value.  CAL/@SC2
     * 
     * @param programName
     */
    public void setProgramName(String programName) {
        this.programName = programName;
    }

    /** 
     * Get the 'ProgramSystemCode' attribute value.  CAL/@SC1
     * 
     * @return value
     */
    public String getProgramSystemCode() {
        return programSystemCode;
    }

    /** 
     * Set the 'ProgramSystemCode' attribute value.  CAL/@SC1
     * 
     * @param programSystemCode
     */
    public void setProgramSystemCode(String programSystemCode) {
        this.programSystemCode = programSystemCode;
    }

    /** 
     * Get the 'ProgramID' attribute value.  CAL/@SC3
     * 
     * @return value
     */
    public String getProgramID() {
        return programID;
    }

    /** 
     * Set the 'ProgramID' attribute value.  CAL/@SC3
     * 
     * @param programID
     */
    public void setProgramID(String programID) {
        this.programID = programID;
    }

    /** 
     * Get the 'FareComponentReferenceID' attribute value.  CAL/@Q6D
     * 
     * @return value
     */
    public String getFareComponentReferenceID() {
        return fareComponentReferenceID;
    }

    /** 
     * Set the 'FareComponentReferenceID' attribute value.  CAL/@Q6D
     * 
     * @param fareComponentReferenceID
     */
    public void setFareComponentReferenceID(String fareComponentReferenceID) {
        this.fareComponentReferenceID = fareComponentReferenceID;
    }

    /** 
     * Get the 'FareTypeBitmap' attribute value.  CAL/@FTY
     * 
     * @return value
     */
    public byte[] getFareTypeBitmap() {
        return fareTypeBitmap;
    }

    /** 
     * Set the 'FareTypeBitmap' attribute value.  CAL/@FTY
     * 
     * @param fareTypeBitmap
     */
    public void setFareTypeBitmap(byte[] fareTypeBitmap) {
        this.fareTypeBitmap = fareTypeBitmap;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Fare" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="FareBasis">
     *         &lt;xs:complexType>
     *           &lt;xs:attribute type="xs:string" use="required" name="FareBasisCode"/>
     *           &lt;xs:attribute type="xs:unsignedShort" name="FareBasisCodeLength"/>
     *           &lt;xs:attribute type="xs:string" use="optional" name="FareClassCode"/>
     *           &lt;xs:attribute type="xs:unsignedShort" name="FareClassCodeLength"/>
     *           &lt;xs:attribute type="xs:string" name="OriginalFareBasisCode"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element name="FareDetails">
     *         &lt;xs:complexType>
     *           &lt;xs:attribute type="xs:boolean" use="optional" name="OneWayInd"/>
     *           &lt;xs:attribute type="xs:boolean" use="optional" name="RoundTripInd"/>
     *           &lt;xs:attribute type="xs:boolean" name="SpecialFareInd"/>
     *           &lt;xs:attribute type="xs:string" use="optional" name="PublicOrNeg"/>
     *           &lt;xs:attribute type="xs:string" use="optional" name="FareType"/>
     *           &lt;xs:attribute type="xs:string" name="BookingCode"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element name="Mileage" minOccurs="0">
     *         &lt;!-- Reference to inner class Mileage -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="QualifyingTypes" minOccurs="0">
     *         &lt;!-- Reference to inner class QualifyingTypes -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="PassengerType" minOccurs="0">
     *         &lt;!-- Reference to inner class PassengerType -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Source">
     *         &lt;xs:complexType>
     *           &lt;xs:attribute type="xs:string" use="required" name="FilingAirlineCode"/>
     *           &lt;xs:attribute type="xs:string" name="IndustryCarrierCode"/>
     *           &lt;xs:attribute type="xs:string" use="optional" name="VendorCode"/>
     *           &lt;xs:attribute type="xs:string" use="optional" name="TariffCode"/>
     *           &lt;xs:attribute type="xs:string" use="optional" name="Rule"/>
     *           &lt;xs:attribute type="xs:unsignedInt" use="optional" name="LinkNumber"/>
     *           &lt;xs:attribute type="xs:unsignedInt" use="optional" name="SequenceNumber"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element name="FareAmount">
     *         &lt;xs:complexType>
     *           &lt;xs:attribute type="xs:float" use="required" name="Amount"/>
     *           &lt;xs:attribute type="xs:string" use="required" name="PublishedCurrencyCode"/>
     *           &lt;xs:attribute type="xs:float" use="required" name="PublishedAmount"/>
     *           &lt;xs:attribute type="xs:float" use="optional" name="PublishedAmountRaw"/>
     *           &lt;xs:attribute type="xs:float" use="optional" name="AmountInPaymentCurrency"/>
     *           &lt;xs:attribute type="xs:float" use="optional" name="NetAmount"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element name="FCTaxes" minOccurs="0">
     *         &lt;!-- Reference to inner class FCTaxes -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FCTaxDetails" minOccurs="0">
     *         &lt;!-- Reference to inner class FCTaxDetails -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FCSurcharges" minOccurs="0" maxOccurs="1">
     *         &lt;!-- Reference to inner class FCSurcharges -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FareByRule" minOccurs="0">
     *         &lt;!-- Reference to inner class FareByRule -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="NegotiatedFare" minOccurs="0">
     *         &lt;!-- Reference to inner class NegotiatedFare -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="DiscountRule" minOccurs="0">
     *         &lt;!-- Reference to inner class DiscountRule -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="InternationalConstruction" minOccurs="0">
     *         &lt;!-- Reference to inner class InternationalConstruction -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="required" name="GoverningAirline"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="CreateDate"/>
     *     &lt;xs:attribute type="xs:boolean" name="CommandPricedInd"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Fare implements Serializable
    {
        private String fareBasisFareBasisCode;
        private String fareBasisFareBasisCodeLength;
        private String fareBasisFareClassCode;
        private String fareBasisFareClassCodeLength;
        private String fareBasisOriginalFareBasisCode;
        private Boolean fareDetailsOneWayInd;
        private Boolean fareDetailsRoundTripInd;
        private Boolean fareDetailsSpecialFareInd;
        private String fareDetailsPublicOrNeg;
        private String fareDetailsFareType;
        private String fareDetailsBookingCode;
        private Mileage mileage;
        private QualifyingTypes qualifyingTypes;
        private PassengerType passengerType;
        private String sourceFilingAirlineCode;
        private String sourceIndustryCarrierCode;
        private String sourceVendorCode;
        private String sourceTariffCode;
        private String sourceRule;
        private String sourceLinkNumber;
        private String sourceSequenceNumber;
        private Float fareAmountAmount;
        private String fareAmountPublishedCurrencyCode;
        private Float fareAmountPublishedAmount;
        private Float fareAmountPublishedAmountRaw;
        private Float fareAmountAmountInPaymentCurrency;
        private Float fareAmountNetAmount;
        private FCTaxes FCTaxes1;
        private FCTaxDetails FCTaxDetails1;
        private FCSurcharges FCSurcharges1;
        private FareByRule fareByRule;
        private NegotiatedFare negotiatedFare;
        private DiscountRule discountRule;
        private InternationalConstruction internationalConstruction;
        private String governingAirline;
        private String createDate;
        private Boolean commandPricedInd;

        /** 
         * Get the 'FareBasisCode' attribute value.  CAL/@B50
         * 
         * @return value
         */
        public String getFareBasisFareBasisCode() {
            return fareBasisFareBasisCode;
        }

        /** 
         * Set the 'FareBasisCode' attribute value.  CAL/@B50
         * 
         * @param fareBasisFareBasisCode
         */
        public void setFareBasisFareBasisCode(String fareBasisFareBasisCode) {
            this.fareBasisFareBasisCode = fareBasisFareBasisCode;
        }

        /** 
         * Get the 'FareBasisCodeLength' attribute value.  CAL/@Q04
         * 
         * @return value
         */
        public String getFareBasisFareBasisCodeLength() {
            return fareBasisFareBasisCodeLength;
        }

        /** 
         * Set the 'FareBasisCodeLength' attribute value.  CAL/@Q04
         * 
         * @param fareBasisFareBasisCodeLength
         */
        public void setFareBasisFareBasisCodeLength(
                String fareBasisFareBasisCodeLength) {
            this.fareBasisFareBasisCodeLength = fareBasisFareBasisCodeLength;
        }

        /** 
         * Get the 'FareClassCode' attribute value.  CAL/ERD/@BJ0
         * 
         * @return value
         */
        public String getFareBasisFareClassCode() {
            return fareBasisFareClassCode;
        }

        /** 
         * Set the 'FareClassCode' attribute value.  CAL/ERD/@BJ0
         * 
         * @param fareBasisFareClassCode
         */
        public void setFareBasisFareClassCode(String fareBasisFareClassCode) {
            this.fareBasisFareClassCode = fareBasisFareClassCode;
        }

        /** 
         * Get the 'FareClassCodeLength' attribute value.  CAL/ERD/@Q04
         * 
         * @return value
         */
        public String getFareBasisFareClassCodeLength() {
            return fareBasisFareClassCodeLength;
        }

        /** 
         * Set the 'FareClassCodeLength' attribute value.  CAL/ERD/@Q04
         * 
         * @param fareBasisFareClassCodeLength
         */
        public void setFareBasisFareClassCodeLength(
                String fareBasisFareClassCodeLength) {
            this.fareBasisFareClassCodeLength = fareBasisFareClassCodeLength;
        }

        /** 
         * Get the 'OriginalFareBasisCode' attribute value.  CAL/ERD/@B50
         * 
         * @return value
         */
        public String getFareBasisOriginalFareBasisCode() {
            return fareBasisOriginalFareBasisCode;
        }

        /** 
         * Set the 'OriginalFareBasisCode' attribute value.  CAL/ERD/@B50
         * 
         * @param fareBasisOriginalFareBasisCode
         */
        public void setFareBasisOriginalFareBasisCode(
                String fareBasisOriginalFareBasisCode) {
            this.fareBasisOriginalFareBasisCode = fareBasisOriginalFareBasisCode;
        }

        /** 
         * Get the 'OneWayInd' attribute value.  CAL/@P04
         * 
         * @return value
         */
        public Boolean getFareDetailsOneWayInd() {
            return fareDetailsOneWayInd;
        }

        /** 
         * Set the 'OneWayInd' attribute value.  CAL/@P04
         * 
         * @param fareDetailsOneWayInd
         */
        public void setFareDetailsOneWayInd(Boolean fareDetailsOneWayInd) {
            this.fareDetailsOneWayInd = fareDetailsOneWayInd;
        }

        /** 
         * Get the 'RoundTripInd' attribute value.  CAL/@P05
         * 
         * @return value
         */
        public Boolean getFareDetailsRoundTripInd() {
            return fareDetailsRoundTripInd;
        }

        /** 
         * Set the 'RoundTripInd' attribute value.  CAL/@P05
         * 
         * @param fareDetailsRoundTripInd
         */
        public void setFareDetailsRoundTripInd(Boolean fareDetailsRoundTripInd) {
            this.fareDetailsRoundTripInd = fareDetailsRoundTripInd;
        }

        /** 
         * Get the 'SpecialFareInd' attribute value.  CAL/@PAZ
         * 
         * @return value
         */
        public Boolean getFareDetailsSpecialFareInd() {
            return fareDetailsSpecialFareInd;
        }

        /** 
         * Set the 'SpecialFareInd' attribute value.  CAL/@PAZ
         * 
         * @param fareDetailsSpecialFareInd
         */
        public void setFareDetailsSpecialFareInd(
                Boolean fareDetailsSpecialFareInd) {
            this.fareDetailsSpecialFareInd = fareDetailsSpecialFareInd;
        }

        /** 
         * Get the 'PublicOrNeg' attribute value. (value can be N for negotiated or P for Public) CAL/@N0K
         * 
         * @return value
         */
        public String getFareDetailsPublicOrNeg() {
            return fareDetailsPublicOrNeg;
        }

        /** 
         * Set the 'PublicOrNeg' attribute value. (value can be N for negotiated or P for Public) CAL/@N0K
         * 
         * @param fareDetailsPublicOrNeg
         */
        public void setFareDetailsPublicOrNeg(String fareDetailsPublicOrNeg) {
            this.fareDetailsPublicOrNeg = fareDetailsPublicOrNeg;
        }

        /** 
         * Get the 'FareType' attribute value.  CAL/ERD/@S53
         * 
         * @return value
         */
        public String getFareDetailsFareType() {
            return fareDetailsFareType;
        }

        /** 
         * Set the 'FareType' attribute value.  CAL/ERD/@S53
         * 
         * @param fareDetailsFareType
         */
        public void setFareDetailsFareType(String fareDetailsFareType) {
            this.fareDetailsFareType = fareDetailsFareType;
        }

        /** 
         * Get the 'BookingCode' attribute value.  CAL/ERD/@P72
         * 
         * @return value
         */
        public String getFareDetailsBookingCode() {
            return fareDetailsBookingCode;
        }

        /** 
         * Set the 'BookingCode' attribute value.  CAL/ERD/@P72
         * 
         * @param fareDetailsBookingCode
         */
        public void setFareDetailsBookingCode(String fareDetailsBookingCode) {
            this.fareDetailsBookingCode = fareDetailsBookingCode;
        }

        /** 
         * Get the 'Mileage' element value.
         * 
         * @return value
         */
        public Mileage getMileage() {
            return mileage;
        }

        /** 
         * Set the 'Mileage' element value.
         * 
         * @param mileage
         */
        public void setMileage(Mileage mileage) {
            this.mileage = mileage;
        }

        /** 
         * Get the 'QualifyingTypes' element value.
         * 
         * @return value
         */
        public QualifyingTypes getQualifyingTypes() {
            return qualifyingTypes;
        }

        /** 
         * Set the 'QualifyingTypes' element value.
         * 
         * @param qualifyingTypes
         */
        public void setQualifyingTypes(QualifyingTypes qualifyingTypes) {
            this.qualifyingTypes = qualifyingTypes;
        }

        /** 
         * Get the 'PassengerType' element value.
         * 
         * @return value
         */
        public PassengerType getPassengerType() {
            return passengerType;
        }

        /** 
         * Set the 'PassengerType' element value.
         * 
         * @param passengerType
         */
        public void setPassengerType(PassengerType passengerType) {
            this.passengerType = passengerType;
        }

        /** 
         * Get the 'FilingAirlineCode' attribute value.  CAL/@B08
         * 
         * @return value
         */
        public String getSourceFilingAirlineCode() {
            return sourceFilingAirlineCode;
        }

        /** 
         * Set the 'FilingAirlineCode' attribute value.  CAL/@B08
         * 
         * @param sourceFilingAirlineCode
         */
        public void setSourceFilingAirlineCode(String sourceFilingAirlineCode) {
            this.sourceFilingAirlineCode = sourceFilingAirlineCode;
        }

        /** 
         * Get the 'IndustryCarrierCode' attribute value.  CAL/ERD/@B00
         * 
         * @return value
         */
        public String getSourceIndustryCarrierCode() {
            return sourceIndustryCarrierCode;
        }

        /** 
         * Set the 'IndustryCarrierCode' attribute value.  CAL/ERD/@B00
         * 
         * @param sourceIndustryCarrierCode
         */
        public void setSourceIndustryCarrierCode(
                String sourceIndustryCarrierCode) {
            this.sourceIndustryCarrierCode = sourceIndustryCarrierCode;
        }

        /** 
         * Get the 'VendorCode' attribute value.  CAL/SEG[last]/@S37
         * 
         * @return value
         */
        public String getSourceVendorCode() {
            return sourceVendorCode;
        }

        /** 
         * Set the 'VendorCode' attribute value.  CAL/SEG[last]/@S37
         * 
         * @param sourceVendorCode
         */
        public void setSourceVendorCode(String sourceVendorCode) {
            this.sourceVendorCode = sourceVendorCode;
        }

        /** 
         * Get the 'TariffCode' attribute value.  CAL/SEG[last]/@S89
         * 
         * @return value
         */
        public String getSourceTariffCode() {
            return sourceTariffCode;
        }

        /** 
         * Set the 'TariffCode' attribute value.  CAL/SEG[last]/@S89
         * 
         * @param sourceTariffCode
         */
        public void setSourceTariffCode(String sourceTariffCode) {
            this.sourceTariffCode = sourceTariffCode;
        }

        /** 
         * Get the 'Rule' attribute value.  CAL/SEG[last]/@S90
         * 
         * @return value
         */
        public String getSourceRule() {
            return sourceRule;
        }

        /** 
         * Set the 'Rule' attribute value.  CAL/SEG[last]/@S90
         * 
         * @param sourceRule
         */
        public void setSourceRule(String sourceRule) {
            this.sourceRule = sourceRule;
        }

        /** 
         * Get the 'LinkNumber' attribute value.  CAL/ERD/@Q46
         * 
         * @return value
         */
        public String getSourceLinkNumber() {
            return sourceLinkNumber;
        }

        /** 
         * Set the 'LinkNumber' attribute value.  CAL/ERD/@Q46
         * 
         * @param sourceLinkNumber
         */
        public void setSourceLinkNumber(String sourceLinkNumber) {
            this.sourceLinkNumber = sourceLinkNumber;
        }

        /** 
         * Get the 'SequenceNumber' attribute value.  CAL/ERD/@Q1K
         * 
         * @return value
         */
        public String getSourceSequenceNumber() {
            return sourceSequenceNumber;
        }

        /** 
         * Set the 'SequenceNumber' attribute value.  CAL/ERD/@Q1K
         * 
         * @param sourceSequenceNumber
         */
        public void setSourceSequenceNumber(String sourceSequenceNumber) {
            this.sourceSequenceNumber = sourceSequenceNumber;
        }

        /** 
         * Get the 'Amount' attribute value.  CAL/@C50
         * 
         * @return value
         */
        public Float getFareAmountAmount() {
            return fareAmountAmount;
        }

        /** 
         * Set the 'Amount' attribute value.  CAL/@C50
         * 
         * @param fareAmountAmount
         */
        public void setFareAmountAmount(Float fareAmountAmount) {
            this.fareAmountAmount = fareAmountAmount;
        }

        /** 
         * Get the 'PublishedCurrencyCode' attribute value.  CAL/@C40
         * 
         * @return value
         */
        public String getFareAmountPublishedCurrencyCode() {
            return fareAmountPublishedCurrencyCode;
        }

        /** 
         * Set the 'PublishedCurrencyCode' attribute value.  CAL/@C40
         * 
         * @param fareAmountPublishedCurrencyCode
         */
        public void setFareAmountPublishedCurrencyCode(
                String fareAmountPublishedCurrencyCode) {
            this.fareAmountPublishedCurrencyCode = fareAmountPublishedCurrencyCode;
        }

        /** 
         * Get the 'PublishedAmount' attribute value.  CAL/@C51
         * 
         * @return value
         */
        public Float getFareAmountPublishedAmount() {
            return fareAmountPublishedAmount;
        }

        /** 
         * Set the 'PublishedAmount' attribute value.  CAL/@C51
         * 
         * @param fareAmountPublishedAmount
         */
        public void setFareAmountPublishedAmount(Float fareAmountPublishedAmount) {
            this.fareAmountPublishedAmount = fareAmountPublishedAmount;
        }

        /** 
         * Get the 'PublishedAmountRaw' attribute value.  CAL/ERD/@C5A
         * 
         * @return value
         */
        public Float getFareAmountPublishedAmountRaw() {
            return fareAmountPublishedAmountRaw;
        }

        /** 
         * Set the 'PublishedAmountRaw' attribute value.  CAL/ERD/@C5A
         * 
         * @param fareAmountPublishedAmountRaw
         */
        public void setFareAmountPublishedAmountRaw(
                Float fareAmountPublishedAmountRaw) {
            this.fareAmountPublishedAmountRaw = fareAmountPublishedAmountRaw;
        }

        /** 
         * Get the 'AmountInPaymentCurrency' attribute value.  CAL/@FAE
         * 
         * @return value
         */
        public Float getFareAmountAmountInPaymentCurrency() {
            return fareAmountAmountInPaymentCurrency;
        }

        /** 
         * Set the 'AmountInPaymentCurrency' attribute value.  CAL/@FAE
         * 
         * @param fareAmountAmountInPaymentCurrency
         */
        public void setFareAmountAmountInPaymentCurrency(
                Float fareAmountAmountInPaymentCurrency) {
            this.fareAmountAmountInPaymentCurrency = fareAmountAmountInPaymentCurrency;
        }

        /** 
         * Get the 'NetAmount' attribute value.  CAL/@C5R
         * 
         * @return value
         */
        public Float getFareAmountNetAmount() {
            return fareAmountNetAmount;
        }

        /** 
         * Set the 'NetAmount' attribute value.  CAL/@C5R
         * 
         * @param fareAmountNetAmount
         */
        public void setFareAmountNetAmount(Float fareAmountNetAmount) {
            this.fareAmountNetAmount = fareAmountNetAmount;
        }

        /** 
         * Get the 'FCTaxes' element value.
         * 
         * @return value
         */
        public FCTaxes getFCTaxes1() {
            return FCTaxes1;
        }

        /** 
         * Set the 'FCTaxes' element value.
         * 
         * @param FCTaxes1
         */
        public void setFCTaxes1(FCTaxes FCTaxes1) {
            this.FCTaxes1 = FCTaxes1;
        }

        /** 
         * Get the 'FCTaxDetails' element value.
         * 
         * @return value
         */
        public FCTaxDetails getFCTaxDetails1() {
            return FCTaxDetails1;
        }

        /** 
         * Set the 'FCTaxDetails' element value.
         * 
         * @param FCTaxDetails1
         */
        public void setFCTaxDetails1(FCTaxDetails FCTaxDetails1) {
            this.FCTaxDetails1 = FCTaxDetails1;
        }

        /** 
         * Get the 'FCSurcharges' element value.
         * 
         * @return value
         */
        public FCSurcharges getFCSurcharges1() {
            return FCSurcharges1;
        }

        /** 
         * Set the 'FCSurcharges' element value.
         * 
         * @param FCSurcharges1
         */
        public void setFCSurcharges1(FCSurcharges FCSurcharges1) {
            this.FCSurcharges1 = FCSurcharges1;
        }

        /** 
         * Get the 'FareByRule' element value.
         * 
         * @return value
         */
        public FareByRule getFareByRule() {
            return fareByRule;
        }

        /** 
         * Set the 'FareByRule' element value.
         * 
         * @param fareByRule
         */
        public void setFareByRule(FareByRule fareByRule) {
            this.fareByRule = fareByRule;
        }

        /** 
         * Get the 'NegotiatedFare' element value.
         * 
         * @return value
         */
        public NegotiatedFare getNegotiatedFare() {
            return negotiatedFare;
        }

        /** 
         * Set the 'NegotiatedFare' element value.
         * 
         * @param negotiatedFare
         */
        public void setNegotiatedFare(NegotiatedFare negotiatedFare) {
            this.negotiatedFare = negotiatedFare;
        }

        /** 
         * Get the 'DiscountRule' element value.
         * 
         * @return value
         */
        public DiscountRule getDiscountRule() {
            return discountRule;
        }

        /** 
         * Set the 'DiscountRule' element value.
         * 
         * @param discountRule
         */
        public void setDiscountRule(DiscountRule discountRule) {
            this.discountRule = discountRule;
        }

        /** 
         * Get the 'InternationalConstruction' element value.
         * 
         * @return value
         */
        public InternationalConstruction getInternationalConstruction() {
            return internationalConstruction;
        }

        /** 
         * Set the 'InternationalConstruction' element value.
         * 
         * @param internationalConstruction
         */
        public void setInternationalConstruction(
                InternationalConstruction internationalConstruction) {
            this.internationalConstruction = internationalConstruction;
        }

        /** 
         * Get the 'GoverningAirline' attribute value.  CAL/@B02
         * 
         * @return value
         */
        public String getGoverningAirline() {
            return governingAirline;
        }

        /** 
         * Set the 'GoverningAirline' attribute value.  CAL/@B02
         * 
         * @param governingAirline
         */
        public void setGoverningAirline(String governingAirline) {
            this.governingAirline = governingAirline;
        }

        /** 
         * Get the 'CreateDate' attribute value.  CAL/ERD/@D12 + T + CAL/ERD/@D55
         * 
         * @return value
         */
        public String getCreateDate() {
            return createDate;
        }

        /** 
         * Set the 'CreateDate' attribute value.  CAL/ERD/@D12 + T + CAL/ERD/@D55
         * 
         * @param createDate
         */
        public void setCreateDate(String createDate) {
            this.createDate = createDate;
        }

        /** 
         * Get the 'CommandPricedInd' attribute value.  CAL/ERD/@CP0
         * 
         * @return value
         */
        public Boolean getCommandPricedInd() {
            return commandPricedInd;
        }

        /** 
         * Set the 'CommandPricedInd' attribute value.  CAL/ERD/@CP0
         * 
         * @param commandPricedInd
         */
        public void setCommandPricedInd(Boolean commandPricedInd) {
            this.commandPricedInd = commandPricedInd;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Mileage" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" name="Ind"/>
         *     &lt;xs:attribute type="xs:double" name="SurchargePercent"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Mileage implements Serializable
        {
            private Boolean ind;
            private Double surchargePercent;

            /** 
             * Get the 'Ind' attribute value.  CAL/@PAY
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value.  CAL/@PAY
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }

            /** 
             * Get the 'SurchargePercent' attribute value.  CAL/@Q48
             * 
             * @return value
             */
            public Double getSurchargePercent() {
                return surchargePercent;
            }

            /** 
             * Set the 'SurchargePercent' attribute value.  CAL/@Q48
             * 
             * @param surchargePercent
             */
            public void setSurchargePercent(Double surchargePercent) {
                this.surchargePercent = surchargePercent;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="QualifyingTypes" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" name="CorporateID"/>
         *     &lt;xs:attribute type="xs:string" name="AccountCode"/>
         *     &lt;xs:attribute type="xs:string" name="TicketDesignator"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class QualifyingTypes implements Serializable
        {
            private String corporateID;
            private String accountCode;
            private String ticketDesignator;

            /** 
             * Get the 'CorporateID' attribute value. CAL/@AC0
             * 
             * @return value
             */
            public String getCorporateID() {
                return corporateID;
            }

            /** 
             * Set the 'CorporateID' attribute value. CAL/@AC0
             * 
             * @param corporateID
             */
            public void setCorporateID(String corporateID) {
                this.corporateID = corporateID;
            }

            /** 
             * Get the 'AccountCode' attribute value.  CAL/ERD/@AC0 or CAL/@AC0 whichever is filled
             * 
             * @return value
             */
            public String getAccountCode() {
                return accountCode;
            }

            /** 
             * Set the 'AccountCode' attribute value.  CAL/ERD/@AC0 or CAL/@AC0 whichever is filled
             * 
             * @param accountCode
             */
            public void setAccountCode(String accountCode) {
                this.accountCode = accountCode;
            }

            /** 
             * Get the 'TicketDesignator' attribute value.  CAL/ERD/@BE0
             * 
             * @return value
             */
            public String getTicketDesignator() {
                return ticketDesignator;
            }

            /** 
             * Set the 'TicketDesignator' attribute value.  CAL/ERD/@BE0
             * 
             * @param ticketDesignator
             */
            public void setTicketDesignator(String ticketDesignator) {
                this.ticketDesignator = ticketDesignator;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerType" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="RequestedCode"/>
         *     &lt;xs:attribute type="xs:string" use="required" name="ActualCode"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PassengerType implements Serializable
        {
            private String requestedCode;
            private String actualCode;

            /** 
             * Get the 'RequestedCode' attribute value.  CAL/@B71
             * 
             * @return value
             */
            public String getRequestedCode() {
                return requestedCode;
            }

            /** 
             * Set the 'RequestedCode' attribute value.  CAL/@B71
             * 
             * @param requestedCode
             */
            public void setRequestedCode(String requestedCode) {
                this.requestedCode = requestedCode;
            }

            /** 
             * Get the 'ActualCode' attribute value.  CAL/ERD/@B70
             * 
             * @return value
             */
            public String getActualCode() {
                return actualCode;
            }

            /** 
             * Set the 'ActualCode' attribute value.  CAL/ERD/@B70
             * 
             * @param actualCode
             */
            public void setActualCode(String actualCode) {
                this.actualCode = actualCode;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FCTaxes" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:TaxType" name="Tax" minOccurs="0" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FCTaxes implements Serializable
        {
            private List<TaxType> taxList = new ArrayList<TaxType>();

            /** 
             * Get the list of 'Tax' element items.
             * 
             * @return list
             */
            public List<TaxType> getTaxList() {
                return taxList;
            }

            /** 
             * Set the list of 'Tax' element items.
             * 
             * @param list
             */
            public void setTaxList(List<TaxType> list) {
                taxList = list;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FCTaxDetails" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:TaxDetailType" name="TaxDetail" minOccurs="0" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FCTaxDetails implements Serializable
        {
            private List<TaxDetailType> taxDetailList = new ArrayList<TaxDetailType>();

            /** 
             * Get the list of 'TaxDetail' element items.
             * 
             * @return list
             */
            public List<TaxDetailType> getTaxDetailList() {
                return taxDetailList;
            }

            /** 
             * Set the list of 'TaxDetail' element items.
             * 
             * @param list
             */
            public void setTaxDetailList(List<TaxDetailType> list) {
                taxDetailList = list;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FCSurcharges" minOccurs="0" maxOccurs="1">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:float" use="required" name="SurchargeAmount"/>
         *     &lt;xs:attribute type="xs:float" use="required" name="NullableAmount"/>
         *     &lt;xs:attribute type="xs:float" use="required" name="TotalFareAmount"/>
         *     &lt;xs:attribute type="xs:string" use="required" name="Currency"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FCSurcharges implements Serializable
        {
            private Float surchargeAmount;
            private Float nullableAmount;
            private Float totalFareAmount;
            private String currency;

            /** 
             * Get the 'SurchargeAmount' attribute value. SUM/PXI/CAL/FCS/@PQS - Surcharge amount on FC level in Payment currency. Sum of all Fare Component specific cat 8/9/12 surcharges including segment level surcharges and pro rated part of cat 8/9/12 surcharges ovelapping Fare Component
             * 
             * @return value
             */
            public Float getSurchargeAmount() {
                return surchargeAmount;
            }

            /** 
             * Set the 'SurchargeAmount' attribute value. SUM/PXI/CAL/FCS/@PQS - Surcharge amount on FC level in Payment currency. Sum of all Fare Component specific cat 8/9/12 surcharges including segment level surcharges and pro rated part of cat 8/9/12 surcharges ovelapping Fare Component
             * 
             * @param surchargeAmount
             */
            public void setSurchargeAmount(Float surchargeAmount) {
                this.surchargeAmount = surchargeAmount;
            }

            /** 
             * Get the 'NullableAmount' attribute value. SUM/PXI/CAL/FCS/@ZFA -  Published or Constructed fare amount with all surcharges which are subject to full discount with DP100 in Fare filling currency
             * 
             * @return value
             */
            public Float getNullableAmount() {
                return nullableAmount;
            }

            /** 
             * Set the 'NullableAmount' attribute value. SUM/PXI/CAL/FCS/@ZFA -  Published or Constructed fare amount with all surcharges which are subject to full discount with DP100 in Fare filling currency
             * 
             * @param nullableAmount
             */
            public void setNullableAmount(Float nullableAmount) {
                this.nullableAmount = nullableAmount;
            }

            /** 
             * Get the 'TotalFareAmount' attribute value. SUM/PXI/CAL/FCS/@TFA -  Total fare amount (sum of NullableAmount and SurchargeAmount) in Payment Currency
             * 
             * @return value
             */
            public Float getTotalFareAmount() {
                return totalFareAmount;
            }

            /** 
             * Set the 'TotalFareAmount' attribute value. SUM/PXI/CAL/FCS/@TFA -  Total fare amount (sum of NullableAmount and SurchargeAmount) in Payment Currency
             * 
             * @param totalFareAmount
             */
            public void setTotalFareAmount(Float totalFareAmount) {
                this.totalFareAmount = totalFareAmount;
            }

            /** 
             * Get the 'Currency' attribute value. SUM/PXI/CAL/FCS/@PCQ - Payment Currency Code
             * 
             * @return value
             */
            public String getCurrency() {
                return currency;
            }

            /** 
             * Set the 'Currency' attribute value. SUM/PXI/CAL/FCS/@PCQ - Payment Currency Code
             * 
             * @param currency
             */
            public void setCurrency(String currency) {
                this.currency = currency;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareByRule" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" name="VendorCode"/>
         *     &lt;xs:attribute type="xs:unsignedInt" name="ItemNumber"/>
         *     &lt;xs:attribute type="xs:string" name="Directionality"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FareByRule implements Serializable
        {
            private String vendorCode;
            private String itemNumber;
            private String directionality;

            /** 
             * Get the 'VendorCode' attribute value.  CAL/C25/@S37
             * 
             * @return value
             */
            public String getVendorCode() {
                return vendorCode;
            }

            /** 
             * Set the 'VendorCode' attribute value.  CAL/C25/@S37
             * 
             * @param vendorCode
             */
            public void setVendorCode(String vendorCode) {
                this.vendorCode = vendorCode;
            }

            /** 
             * Get the 'ItemNumber' attribute value.  CAL/C25/@Q41
             * 
             * @return value
             */
            public String getItemNumber() {
                return itemNumber;
            }

            /** 
             * Set the 'ItemNumber' attribute value.  CAL/C25/@Q41
             * 
             * @param itemNumber
             */
            public void setItemNumber(String itemNumber) {
                this.itemNumber = itemNumber;
            }

            /** 
             * Get the 'Directionality' attribute value.  CAL/C25/@S70
             * 
             * @return value
             */
            public String getDirectionality() {
                return directionality;
            }

            /** 
             * Set the 'Directionality' attribute value.  CAL/C25/@S70
             * 
             * @param directionality
             */
            public void setDirectionality(String directionality) {
                this.directionality = directionality;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NegotiatedFare" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" name="VendorCode"/>
         *     &lt;xs:attribute type="xs:unsignedInt" name="ItemNumber"/>
         *     &lt;xs:attribute type="xs:string" name="DisplayType"/>
         *     &lt;xs:attribute type="xs:string" name="Directionality"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class NegotiatedFare implements Serializable
        {
            private String vendorCode;
            private String itemNumber;
            private String displayType;
            private String directionality;

            /** 
             * Get the 'VendorCode' attribute value.  CAL/C35/@S37
             * 
             * @return value
             */
            public String getVendorCode() {
                return vendorCode;
            }

            /** 
             * Set the 'VendorCode' attribute value.  CAL/C35/@S37
             * 
             * @param vendorCode
             */
            public void setVendorCode(String vendorCode) {
                this.vendorCode = vendorCode;
            }

            /** 
             * Get the 'ItemNumber' attribute value.  CAL/C35/@Q41
             * 
             * @return value
             */
            public String getItemNumber() {
                return itemNumber;
            }

            /** 
             * Set the 'ItemNumber' attribute value.  CAL/C35/@Q41
             * 
             * @param itemNumber
             */
            public void setItemNumber(String itemNumber) {
                this.itemNumber = itemNumber;
            }

            /** 
             * Get the 'DisplayType' attribute value.  CAL/ERD/@N1P
             * 
             * @return value
             */
            public String getDisplayType() {
                return displayType;
            }

            /** 
             * Set the 'DisplayType' attribute value.  CAL/ERD/@N1P
             * 
             * @param displayType
             */
            public void setDisplayType(String displayType) {
                this.displayType = displayType;
            }

            /** 
             * Get the 'Directionality' attribute value.  CAL/C35/@S70
             * 
             * @return value
             */
            public String getDirectionality() {
                return directionality;
            }

            /** 
             * Set the 'Directionality' attribute value.  CAL/C35/@S70
             * 
             * @param directionality
             */
            public void setDirectionality(String directionality) {
                this.directionality = directionality;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DiscountRule" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" name="VendorCode"/>
         *     &lt;xs:attribute type="xs:unsignedInt" name="ItemNumber"/>
         *     &lt;xs:attribute type="xs:string" name="Directionality"/>
         *     &lt;xs:attribute type="xs:string" name="DiscountCode"/>
         *     &lt;xs:attribute type="xs:double" name="DiscountPercent"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class DiscountRule implements Serializable
        {
            private String vendorCode;
            private String itemNumber;
            private String directionality;
            private String discountCode;
            private Double discountPercent;

            /** 
             * Get the 'VendorCode' attribute value.  CAL/DFI/@S37
             * 
             * @return value
             */
            public String getVendorCode() {
                return vendorCode;
            }

            /** 
             * Set the 'VendorCode' attribute value.  CAL/DFI/@S37
             * 
             * @param vendorCode
             */
            public void setVendorCode(String vendorCode) {
                this.vendorCode = vendorCode;
            }

            /** 
             * Get the 'ItemNumber' attribute value.  CAL/DFI/@Q41
             * 
             * @return value
             */
            public String getItemNumber() {
                return itemNumber;
            }

            /** 
             * Set the 'ItemNumber' attribute value.  CAL/DFI/@Q41
             * 
             * @param itemNumber
             */
            public void setItemNumber(String itemNumber) {
                this.itemNumber = itemNumber;
            }

            /** 
             * Get the 'Directionality' attribute value.  CAL/DFI/@S70
             * 
             * @return value
             */
            public String getDirectionality() {
                return directionality;
            }

            /** 
             * Set the 'Directionality' attribute value.  CAL/DFI/@S70
             * 
             * @param directionality
             */
            public void setDirectionality(String directionality) {
                this.directionality = directionality;
            }

            /** 
             * Get the 'DiscountCode' attribute value.  CAL/@S67
             * 
             * @return value
             */
            public String getDiscountCode() {
                return discountCode;
            }

            /** 
             * Set the 'DiscountCode' attribute value.  CAL/@S67
             * 
             * @param discountCode
             */
            public void setDiscountCode(String discountCode) {
                this.discountCode = discountCode;
            }

            /** 
             * Get the 'DiscountPercent' attribute value.  CAL/@Q17
             * 
             * @return value
             */
            public Double getDiscountPercent() {
                return discountPercent;
            }

            /** 
             * Set the 'DiscountPercent' attribute value.  CAL/@Q17
             * 
             * @param discountPercent
             */
            public void setDiscountPercent(Double discountPercent) {
                this.discountPercent = discountPercent;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InternationalConstruction" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="PublishedFare">
         *         &lt;xs:complexType>
         *           &lt;xs:attribute type="xs:string" name="DepartureCity"/>
         *           &lt;xs:attribute type="xs:string" name="ArrivalCity"/>
         *           &lt;xs:attribute type="xs:float" name="NucAmount"/>
         *           &lt;xs:attribute type="xs:float" name="PublishedAmount"/>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element name="AddonFare" maxOccurs="2">
         *         &lt;!-- Reference to inner class AddonFare -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="ns:AddonConstructionType" name="Type"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class InternationalConstruction implements Serializable
        {
            private String publishedFareDepartureCity;
            private String publishedFareArrivalCity;
            private Float publishedFareNucAmount;
            private Float publishedFarePublishedAmount;
            private List<AddonFare> addonFareList = new ArrayList<AddonFare>();
            private AddonConstructionType type;

            /** 
             * Get the 'DepartureCity' attribute value.  CAL/ECN/@AM0
             * 
             * @return value
             */
            public String getPublishedFareDepartureCity() {
                return publishedFareDepartureCity;
            }

            /** 
             * Set the 'DepartureCity' attribute value.  CAL/ECN/@AM0
             * 
             * @param publishedFareDepartureCity
             */
            public void setPublishedFareDepartureCity(
                    String publishedFareDepartureCity) {
                this.publishedFareDepartureCity = publishedFareDepartureCity;
            }

            /** 
             * Get the 'ArrivalCity' attribute value.  CAL/ECN/@AN0
             * 
             * @return value
             */
            public String getPublishedFareArrivalCity() {
                return publishedFareArrivalCity;
            }

            /** 
             * Set the 'ArrivalCity' attribute value.  CAL/ECN/@AN0
             * 
             * @param publishedFareArrivalCity
             */
            public void setPublishedFareArrivalCity(
                    String publishedFareArrivalCity) {
                this.publishedFareArrivalCity = publishedFareArrivalCity;
            }

            /** 
             * Get the 'NucAmount' attribute value.  CAL/ECN/@C6K
             * 
             * @return value
             */
            public Float getPublishedFareNucAmount() {
                return publishedFareNucAmount;
            }

            /** 
             * Set the 'NucAmount' attribute value.  CAL/ECN/@C6K
             * 
             * @param publishedFareNucAmount
             */
            public void setPublishedFareNucAmount(Float publishedFareNucAmount) {
                this.publishedFareNucAmount = publishedFareNucAmount;
            }

            /** 
             * Get the 'PublishedAmount' attribute value.  CAL/ECN/@C66
             * 
             * @return value
             */
            public Float getPublishedFarePublishedAmount() {
                return publishedFarePublishedAmount;
            }

            /** 
             * Set the 'PublishedAmount' attribute value.  CAL/ECN/@C66
             * 
             * @param publishedFarePublishedAmount
             */
            public void setPublishedFarePublishedAmount(
                    Float publishedFarePublishedAmount) {
                this.publishedFarePublishedAmount = publishedFarePublishedAmount;
            }

            /** 
             * Get the list of 'AddonFare' element items.
             * 
             * @return list
             */
            public List<AddonFare> getAddonFareList() {
                return addonFareList;
            }

            /** 
             * Set the list of 'AddonFare' element items.
             * 
             * @param list
             */
            public void setAddonFareList(List<AddonFare> list) {
                addonFareList = list;
            }

            /** 
             * Get the 'Type' attribute value.  CAL/ECN/@N1J
             * 
             * @return value
             */
            public AddonConstructionType getType() {
                return type;
            }

            /** 
             * Set the 'Type' attribute value.  CAL/ECN/@N1J
             * 
             * @param type
             */
            public void setType(AddonConstructionType type) {
                this.type = type;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AddonFare" maxOccurs="2">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Amount">
             *         &lt;xs:complexType>
             *           &lt;xs:attribute type="xs:string" name="PublishedCurrencyCode"/>
             *           &lt;xs:attribute type="xs:float" name="PublishedAmount"/>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" name="FareClass"/>
             *     &lt;xs:attribute type="xs:string" name="RoutingNumber"/>
             *     &lt;xs:attribute type="ns:OWRTType" name="TripType"/>
             *     &lt;xs:attribute type="xs:string" name="AddonTariffCode"/>
             *     &lt;xs:attribute type="xs:string" name="FootNote1"/>
             *     &lt;xs:attribute type="xs:string" name="FootNote2"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AddonFare implements Serializable
            {
                private String amountPublishedCurrencyCode;
                private Float amountPublishedAmount;
                private String fareClass;
                private String routingNumber;
                private OWRTType tripType;
                private String addonTariffCode;
                private String footNote1;
                private String footNote2;

                /** 
                 * Get the 'PublishedCurrencyCode' attribute value.  CAL/DAO/@C40 CAL/OAO/@C40
                 * 
                 * @return value
                 */
                public String getAmountPublishedCurrencyCode() {
                    return amountPublishedCurrencyCode;
                }

                /** 
                 * Set the 'PublishedCurrencyCode' attribute value.  CAL/DAO/@C40 CAL/OAO/@C40
                 * 
                 * @param amountPublishedCurrencyCode
                 */
                public void setAmountPublishedCurrencyCode(
                        String amountPublishedCurrencyCode) {
                    this.amountPublishedCurrencyCode = amountPublishedCurrencyCode;
                }

                /** 
                 * Get the 'PublishedAmount' attribute value.  CAL/DAO/@C50 CAL/OAO/@C50
                 * 
                 * @return value
                 */
                public Float getAmountPublishedAmount() {
                    return amountPublishedAmount;
                }

                /** 
                 * Set the 'PublishedAmount' attribute value.  CAL/DAO/@C50 CAL/OAO/@C50
                 * 
                 * @param amountPublishedAmount
                 */
                public void setAmountPublishedAmount(Float amountPublishedAmount) {
                    this.amountPublishedAmount = amountPublishedAmount;
                }

                /** 
                 * Get the 'FareClass' attribute value.  CAL/DAO/@BJ0 CAL/OAO/@BJ0
                 * 
                 * @return value
                 */
                public String getFareClass() {
                    return fareClass;
                }

                /** 
                 * Set the 'FareClass' attribute value.  CAL/DAO/@BJ0 CAL/OAO/@BJ0
                 * 
                 * @param fareClass
                 */
                public void setFareClass(String fareClass) {
                    this.fareClass = fareClass;
                }

                /** 
                 * Get the 'RoutingNumber' attribute value.  CAL/DAO/@S65 CAL/OAO/@S65
                 * 
                 * @return value
                 */
                public String getRoutingNumber() {
                    return routingNumber;
                }

                /** 
                 * Set the 'RoutingNumber' attribute value.  CAL/DAO/@S65 CAL/OAO/@S65
                 * 
                 * @param routingNumber
                 */
                public void setRoutingNumber(String routingNumber) {
                    this.routingNumber = routingNumber;
                }

                /** 
                 * Get the 'TripType' attribute value.  CAL/DAO/@P04 CAL/OAO/@P04
                 * 
                 * @return value
                 */
                public OWRTType getTripType() {
                    return tripType;
                }

                /** 
                 * Set the 'TripType' attribute value.  CAL/DAO/@P04 CAL/OAO/@P04
                 * 
                 * @param tripType
                 */
                public void setTripType(OWRTType tripType) {
                    this.tripType = tripType;
                }

                /** 
                 * Get the 'AddonTariffCode' attribute value.  CAL/DAO/@Q3W CAL/OAO/@Q3W
                 * 
                 * @return value
                 */
                public String getAddonTariffCode() {
                    return addonTariffCode;
                }

                /** 
                 * Set the 'AddonTariffCode' attribute value.  CAL/DAO/@Q3W CAL/OAO/@Q3W
                 * 
                 * @param addonTariffCode
                 */
                public void setAddonTariffCode(String addonTariffCode) {
                    this.addonTariffCode = addonTariffCode;
                }

                /** 
                 * Get the 'FootNote1' attribute value.  CAL/DAO/@S55 CAL/OAO/@S55
                 * 
                 * @return value
                 */
                public String getFootNote1() {
                    return footNote1;
                }

                /** 
                 * Set the 'FootNote1' attribute value.  CAL/DAO/@S55 CAL/OAO/@S55
                 * 
                 * @param footNote1
                 */
                public void setFootNote1(String footNote1) {
                    this.footNote1 = footNote1;
                }

                /** 
                 * Get the 'FootNote2' attribute value.  CAL/DAO/@S64 CAL/OAO/@S64
                 * 
                 * @return value
                 */
                public String getFootNote2() {
                    return footNote2;
                }

                /** 
                 * Set the 'FootNote2' attribute value.  CAL/DAO/@S64 CAL/OAO/@S64
                 * 
                 * @param footNote2
                 */
                public void setFootNote2(String footNote2) {
                    this.footNote2 = footNote2;
                }
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NetRemitPublishedFare" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="required" name="FareBasisCode"/>
     *     &lt;xs:attribute type="xs:unsignedShort" name="FareBasisCodeLength"/>
     *     &lt;xs:attribute type="xs:float" use="optional" name="Amount"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class NetRemitPublishedFare implements Serializable
    {
        private String fareBasisCode;
        private String fareBasisCodeLength;
        private Float amount;

        /** 
         * Get the 'FareBasisCode' attribute value.  CAL/@B51
         * 
         * @return value
         */
        public String getFareBasisCode() {
            return fareBasisCode;
        }

        /** 
         * Set the 'FareBasisCode' attribute value.  CAL/@B51
         * 
         * @param fareBasisCode
         */
        public void setFareBasisCode(String fareBasisCode) {
            this.fareBasisCode = fareBasisCode;
        }

        /** 
         * Get the 'FareBasisCodeLength' attribute value.  CAL/@Q10
         * 
         * @return value
         */
        public String getFareBasisCodeLength() {
            return fareBasisCodeLength;
        }

        /** 
         * Set the 'FareBasisCodeLength' attribute value.  CAL/@Q10
         * 
         * @param fareBasisCodeLength
         */
        public void setFareBasisCodeLength(String fareBasisCodeLength) {
            this.fareBasisCodeLength = fareBasisCodeLength;
        }

        /** 
         * Get the 'Amount' attribute value.  CAL/@C52
         * 
         * @return value
         */
        public Float getAmount() {
            return amount;
        }

        /** 
         * Set the 'Amount' attribute value.  CAL/@C52
         * 
         * @param amount
         */
        public void setAmount(Float amount) {
            this.amount = amount;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HigherIntermediateFare" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Departure">
     *         &lt;xs:complexType>
     *           &lt;xs:attribute type="xs:string" name="CityCode"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element name="Arrival">
     *         &lt;xs:complexType>
     *           &lt;xs:attribute type="xs:string" name="CityCode"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" name="ConstructedCityCode"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class HigherIntermediateFare implements Serializable
    {
        private String departure;
        private String arrival;
        private String constructedCityCode;

        /** 
         * Get the 'CityCode' attribute value.  CAL/@A13
         * 
         * @return value
         */
        public String getDeparture() {
            return departure;
        }

        /** 
         * Set the 'CityCode' attribute value.  CAL/@A13
         * 
         * @param departure
         */
        public void setDeparture(String departure) {
            this.departure = departure;
        }

        /** 
         * Get the 'CityCode' attribute value.  CAL/@A14
         * 
         * @return value
         */
        public String getArrival() {
            return arrival;
        }

        /** 
         * Set the 'CityCode' attribute value.  CAL/@A14
         * 
         * @param arrival
         */
        public void setArrival(String arrival) {
            this.arrival = arrival;
        }

        /** 
         * Get the 'ConstructedCityCode' attribute value.  CAL/@A18
         * 
         * @return value
         */
        public String getConstructedCityCode() {
            return constructedCityCode;
        }

        /** 
         * Set the 'ConstructedCityCode' attribute value.  CAL/@A18
         * 
         * @param constructedCityCode
         */
        public void setConstructedCityCode(String constructedCityCode) {
            this.constructedCityCode = constructedCityCode;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightSegment" maxOccurs="16">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Departure">
     *         &lt;xs:complexType>
     *           &lt;xs:attribute type="xs:string" use="optional" name="CityCode"/>
     *           &lt;xs:attribute type="xs:string" name="AirportCode"/>
     *           &lt;xs:attribute type="xs:string" name="NationCode"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element name="Arrival">
     *         &lt;xs:complexType>
     *           &lt;xs:attribute type="xs:string" use="optional" name="CityCode"/>
     *           &lt;xs:attribute type="xs:string" name="AirportCode"/>
     *           &lt;xs:attribute type="xs:string" name="NationCode"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element name="Validity" minOccurs="0">
     *         &lt;!-- Reference to inner class Validity -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="ns:SurchargeType" name="Surcharge" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element name="NetRemitSurcharges" minOccurs="0">
     *         &lt;!-- Reference to inner class NetRemitSurcharges -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Transfer" minOccurs="0">
     *         &lt;!-- Reference to inner class Transfer -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Stopover" minOccurs="0">
     *         &lt;!-- Reference to inner class Stopover -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Surface" minOccurs="0">
     *         &lt;!-- Reference to inner class Surface -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FreeBaggageAllowance" minOccurs="0">
     *         &lt;!-- Reference to inner class FreeBaggageAllowance -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Mileage" minOccurs="0">
     *         &lt;!-- Reference to inner class Mileage -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Journey" minOccurs="0">
     *         &lt;!-- Reference to inner class Journey -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Cat35" minOccurs="0">
     *         &lt;!-- Reference to inner class Cat35 -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="TicketFarePerSegment" minOccurs="0">
     *         &lt;!-- Reference to inner class TicketFarePerSegment -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="MarketingAirline" minOccurs="0">
     *         &lt;!-- Reference to inner class MarketingAirline -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="OperatingCarrier" minOccurs="0">
     *         &lt;!-- Reference to inner class OperatingCarrier -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:unsignedByte" name="SequenceNumber"/>
     *     &lt;xs:attribute type="xs:string" name="RequiredBookingCode"/>
     *     &lt;xs:attribute type="xs:boolean" name="RebookSameBookingCodeInd"/>
     *     &lt;xs:attribute type="xs:string" name="GlobalDirection"/>
     *     &lt;xs:attribute type="xs:boolean" name="FareBreakPointInd"/>
     *     &lt;xs:attribute type="xs:boolean" name="SideTripInd"/>
     *     &lt;xs:attribute type="xs:boolean" name="EndOfSideTripSegmentInd"/>
     *     &lt;xs:attribute type="xs:string" name="GeographyType"/>
     *     &lt;xs:attribute type="xs:string" name="CabinCode"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="EquipmentType"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FlightSegment implements Serializable
    {
        private String departureCityCode;
        private String departureAirportCode;
        private String departureNationCode;
        private String arrivalCityCode;
        private String arrivalAirportCode;
        private String arrivalNationCode;
        private Validity validity;
        private List<SurchargeType> surchargeList = new ArrayList<SurchargeType>();
        private NetRemitSurcharges netRemitSurcharges;
        private Transfer transfer;
        private Stopover stopover;
        private Surface surface;
        private FreeBaggageAllowance freeBaggageAllowance;
        private Mileage mileage;
        private Journey journey;
        private Cat35 cat35;
        private TicketFarePerSegment ticketFarePerSegment;
        private MarketingAirline marketingAirline;
        private OperatingCarrier operatingCarrier;
        private String sequenceNumber;
        private String requiredBookingCode;
        private Boolean rebookSameBookingCodeInd;
        private String globalDirection;
        private Boolean fareBreakPointInd;
        private Boolean sideTripInd;
        private Boolean endOfSideTripSegmentInd;
        private String geographyType;
        private String cabinCode;
        private String equipmentType;

        /** 
         * Get the 'CityCode' attribute value.  SEG/@A11
         * 
         * @return value
         */
        public String getDepartureCityCode() {
            return departureCityCode;
        }

        /** 
         * Set the 'CityCode' attribute value.  SEG/@A11
         * 
         * @param departureCityCode
         */
        public void setDepartureCityCode(String departureCityCode) {
            this.departureCityCode = departureCityCode;
        }

        /** 
         * Get the 'AirportCode' attribute value.  SEG/@C6I
         * 
         * @return value
         */
        public String getDepartureAirportCode() {
            return departureAirportCode;
        }

        /** 
         * Set the 'AirportCode' attribute value.  SEG/@C6I
         * 
         * @param departureAirportCode
         */
        public void setDepartureAirportCode(String departureAirportCode) {
            this.departureAirportCode = departureAirportCode;
        }

        /** 
         * Get the 'NationCode' attribute value.  SEG/@C11
         * 
         * @return value
         */
        public String getDepartureNationCode() {
            return departureNationCode;
        }

        /** 
         * Set the 'NationCode' attribute value.  SEG/@C11
         * 
         * @param departureNationCode
         */
        public void setDepartureNationCode(String departureNationCode) {
            this.departureNationCode = departureNationCode;
        }

        /** 
         * Get the 'CityCode' attribute value.  SEG/@A12
         * 
         * @return value
         */
        public String getArrivalCityCode() {
            return arrivalCityCode;
        }

        /** 
         * Set the 'CityCode' attribute value.  SEG/@A12
         * 
         * @param arrivalCityCode
         */
        public void setArrivalCityCode(String arrivalCityCode) {
            this.arrivalCityCode = arrivalCityCode;
        }

        /** 
         * Get the 'AirportCode' attribute value.  SEG/@A02
         * 
         * @return value
         */
        public String getArrivalAirportCode() {
            return arrivalAirportCode;
        }

        /** 
         * Set the 'AirportCode' attribute value.  SEG/@A02
         * 
         * @param arrivalAirportCode
         */
        public void setArrivalAirportCode(String arrivalAirportCode) {
            this.arrivalAirportCode = arrivalAirportCode;
        }

        /** 
         * Get the 'NationCode' attribute value.  SEG/@C12
         * 
         * @return value
         */
        public String getArrivalNationCode() {
            return arrivalNationCode;
        }

        /** 
         * Set the 'NationCode' attribute value.  SEG/@C12
         * 
         * @param arrivalNationCode
         */
        public void setArrivalNationCode(String arrivalNationCode) {
            this.arrivalNationCode = arrivalNationCode;
        }

        /** 
         * Get the 'Validity' element value.
         * 
         * @return value
         */
        public Validity getValidity() {
            return validity;
        }

        /** 
         * Set the 'Validity' element value.
         * 
         * @param validity
         */
        public void setValidity(Validity validity) {
            this.validity = validity;
        }

        /** 
         * Get the list of 'Surcharge' element items.  CAL/SUR
         * 
         * @return list
         */
        public List<SurchargeType> getSurchargeList() {
            return surchargeList;
        }

        /** 
         * Set the list of 'Surcharge' element items.  CAL/SUR
         * 
         * @param list
         */
        public void setSurchargeList(List<SurchargeType> list) {
            surchargeList = list;
        }

        /** 
         * Get the 'NetRemitSurcharges' element value.
         * 
         * @return value
         */
        public NetRemitSurcharges getNetRemitSurcharges() {
            return netRemitSurcharges;
        }

        /** 
         * Set the 'NetRemitSurcharges' element value.
         * 
         * @param netRemitSurcharges
         */
        public void setNetRemitSurcharges(NetRemitSurcharges netRemitSurcharges) {
            this.netRemitSurcharges = netRemitSurcharges;
        }

        /** 
         * Get the 'Transfer' element value.
         * 
         * @return value
         */
        public Transfer getTransfer() {
            return transfer;
        }

        /** 
         * Set the 'Transfer' element value.
         * 
         * @param transfer
         */
        public void setTransfer(Transfer transfer) {
            this.transfer = transfer;
        }

        /** 
         * Get the 'Stopover' element value.
         * 
         * @return value
         */
        public Stopover getStopover() {
            return stopover;
        }

        /** 
         * Set the 'Stopover' element value.
         * 
         * @param stopover
         */
        public void setStopover(Stopover stopover) {
            this.stopover = stopover;
        }

        /** 
         * Get the 'Surface' element value.
         * 
         * @return value
         */
        public Surface getSurface() {
            return surface;
        }

        /** 
         * Set the 'Surface' element value.
         * 
         * @param surface
         */
        public void setSurface(Surface surface) {
            this.surface = surface;
        }

        /** 
         * Get the 'FreeBaggageAllowance' element value.
         * 
         * @return value
         */
        public FreeBaggageAllowance getFreeBaggageAllowance() {
            return freeBaggageAllowance;
        }

        /** 
         * Set the 'FreeBaggageAllowance' element value.
         * 
         * @param freeBaggageAllowance
         */
        public void setFreeBaggageAllowance(
                FreeBaggageAllowance freeBaggageAllowance) {
            this.freeBaggageAllowance = freeBaggageAllowance;
        }

        /** 
         * Get the 'Mileage' element value.
         * 
         * @return value
         */
        public Mileage getMileage() {
            return mileage;
        }

        /** 
         * Set the 'Mileage' element value.
         * 
         * @param mileage
         */
        public void setMileage(Mileage mileage) {
            this.mileage = mileage;
        }

        /** 
         * Get the 'Journey' element value.
         * 
         * @return value
         */
        public Journey getJourney() {
            return journey;
        }

        /** 
         * Set the 'Journey' element value.
         * 
         * @param journey
         */
        public void setJourney(Journey journey) {
            this.journey = journey;
        }

        /** 
         * Get the 'Cat35' element value.
         * 
         * @return value
         */
        public Cat35 getCat35() {
            return cat35;
        }

        /** 
         * Set the 'Cat35' element value.
         * 
         * @param cat35
         */
        public void setCat35(Cat35 cat35) {
            this.cat35 = cat35;
        }

        /** 
         * Get the 'TicketFarePerSegment' element value.
         * 
         * @return value
         */
        public TicketFarePerSegment getTicketFarePerSegment() {
            return ticketFarePerSegment;
        }

        /** 
         * Set the 'TicketFarePerSegment' element value.
         * 
         * @param ticketFarePerSegment
         */
        public void setTicketFarePerSegment(
                TicketFarePerSegment ticketFarePerSegment) {
            this.ticketFarePerSegment = ticketFarePerSegment;
        }

        /** 
         * Get the 'MarketingAirline' element value.
         * 
         * @return value
         */
        public MarketingAirline getMarketingAirline() {
            return marketingAirline;
        }

        /** 
         * Set the 'MarketingAirline' element value.
         * 
         * @param marketingAirline
         */
        public void setMarketingAirline(MarketingAirline marketingAirline) {
            this.marketingAirline = marketingAirline;
        }

        /** 
         * Get the 'OperatingCarrier' element value.
         * 
         * @return value
         */
        public OperatingCarrier getOperatingCarrier() {
            return operatingCarrier;
        }

        /** 
         * Set the 'OperatingCarrier' element value.
         * 
         * @param operatingCarrier
         */
        public void setOperatingCarrier(OperatingCarrier operatingCarrier) {
            this.operatingCarrier = operatingCarrier;
        }

        /** 
         * Get the 'SequenceNumber' attribute value.  SEG/@Q0Z
         * 
         * @return value
         */
        public String getSequenceNumber() {
            return sequenceNumber;
        }

        /** 
         * Set the 'SequenceNumber' attribute value.  SEG/@Q0Z
         * 
         * @param sequenceNumber
         */
        public void setSequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        /** 
         * Get the 'RequiredBookingCode' attribute value.  SEG/@P72
         * 
         * @return value
         */
        public String getRequiredBookingCode() {
            return requiredBookingCode;
        }

        /** 
         * Set the 'RequiredBookingCode' attribute value.  SEG/@P72
         * 
         * @param requiredBookingCode
         */
        public void setRequiredBookingCode(String requiredBookingCode) {
            this.requiredBookingCode = requiredBookingCode;
        }

        /** 
         * Get the 'RebookSameBookingCodeInd' attribute value.  SEG/@PAX
         * 
         * @return value
         */
        public Boolean getRebookSameBookingCodeInd() {
            return rebookSameBookingCodeInd;
        }

        /** 
         * Set the 'RebookSameBookingCodeInd' attribute value.  SEG/@PAX
         * 
         * @param rebookSameBookingCodeInd
         */
        public void setRebookSameBookingCodeInd(Boolean rebookSameBookingCodeInd) {
            this.rebookSameBookingCodeInd = rebookSameBookingCodeInd;
        }

        /** 
         * Get the 'GlobalDirection' attribute value.  SEG/@S12
         * 
         * @return value
         */
        public String getGlobalDirection() {
            return globalDirection;
        }

        /** 
         * Set the 'GlobalDirection' attribute value.  SEG/@S12
         * 
         * @param globalDirection
         */
        public void setGlobalDirection(String globalDirection) {
            this.globalDirection = globalDirection;
        }

        /** 
         * Get the 'FareBreakPointInd' attribute value.  SEG/@P2F
         * 
         * @return value
         */
        public Boolean getFareBreakPointInd() {
            return fareBreakPointInd;
        }

        /** 
         * Set the 'FareBreakPointInd' attribute value.  SEG/@P2F
         * 
         * @param fareBreakPointInd
         */
        public void setFareBreakPointInd(Boolean fareBreakPointInd) {
            this.fareBreakPointInd = fareBreakPointInd;
        }

        /** 
         * Get the 'SideTripInd' attribute value.  SEG/@P2N
         * 
         * @return value
         */
        public Boolean getSideTripInd() {
            return sideTripInd;
        }

        /** 
         * Set the 'SideTripInd' attribute value.  SEG/@P2N
         * 
         * @param sideTripInd
         */
        public void setSideTripInd(Boolean sideTripInd) {
            this.sideTripInd = sideTripInd;
        }

        /** 
         * Get the 'EndOfSideTripSegmentInd' attribute value.  SEG/@S07
         * 
         * @return value
         */
        public Boolean getEndOfSideTripSegmentInd() {
            return endOfSideTripSegmentInd;
        }

        /** 
         * Set the 'EndOfSideTripSegmentInd' attribute value.  SEG/@S07
         * 
         * @param endOfSideTripSegmentInd
         */
        public void setEndOfSideTripSegmentInd(Boolean endOfSideTripSegmentInd) {
            this.endOfSideTripSegmentInd = endOfSideTripSegmentInd;
        }

        /** 
         * Get the 'GeographyType' attribute value.  SEG/@C13
         * 
         * @return value
         */
        public String getGeographyType() {
            return geographyType;
        }

        /** 
         * Set the 'GeographyType' attribute value.  SEG/@C13
         * 
         * @param geographyType
         */
        public void setGeographyType(String geographyType) {
            this.geographyType = geographyType;
        }

        /** 
         * Get the 'CabinCode' attribute value.  SEG/@N00
         * 
         * @return value
         */
        public String getCabinCode() {
            return cabinCode;
        }

        /** 
         * Set the 'CabinCode' attribute value.  SEG/@N00
         * 
         * @param cabinCode
         */
        public void setCabinCode(String cabinCode) {
            this.cabinCode = cabinCode;
        }

        /** 
         * Get the 'EquipmentType' attribute value. Equipment Type SEG/@SHR
         * 
         * @return value
         */
        public String getEquipmentType() {
            return equipmentType;
        }

        /** 
         * Set the 'EquipmentType' attribute value. Equipment Type SEG/@SHR
         * 
         * @param equipmentType
         */
        public void setEquipmentType(String equipmentType) {
            this.equipmentType = equipmentType;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Validity" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" name="NotValidBeforeDate"/>
         *     &lt;xs:attribute type="xs:string" name="NotValidAfterDate"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Validity implements Serializable
        {
            private String notValidBeforeDate;
            private String notValidAfterDate;

            /** 
             * Get the 'NotValidBeforeDate' attribute value.  SEG/@D06
             * 
             * @return value
             */
            public String getNotValidBeforeDate() {
                return notValidBeforeDate;
            }

            /** 
             * Set the 'NotValidBeforeDate' attribute value.  SEG/@D06
             * 
             * @param notValidBeforeDate
             */
            public void setNotValidBeforeDate(String notValidBeforeDate) {
                this.notValidBeforeDate = notValidBeforeDate;
            }

            /** 
             * Get the 'NotValidAfterDate' attribute value.  SEG/@D05
             * 
             * @return value
             */
            public String getNotValidAfterDate() {
                return notValidAfterDate;
            }

            /** 
             * Set the 'NotValidAfterDate' attribute value.  SEG/@D05
             * 
             * @param notValidAfterDate
             */
            public void setNotValidAfterDate(String notValidAfterDate) {
                this.notValidAfterDate = notValidAfterDate;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NetRemitSurcharges" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:SurchargeType" name="Surcharge" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class NetRemitSurcharges implements Serializable
        {
            private List<SurchargeType> surchargeList = new ArrayList<SurchargeType>();

            /** 
             * Get the list of 'Surcharge' element items.
             * 
             * @return list
             */
            public List<SurchargeType> getSurchargeList() {
                return surchargeList;
            }

            /** 
             * Set the list of 'Surcharge' element items.
             * 
             * @param list
             */
            public void setSurchargeList(List<SurchargeType> list) {
                surchargeList = list;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Transfer" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:float" name="Amount"/>
         *     &lt;xs:attribute type="xs:string" name="PublishedCurrencyCode"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Transfer implements Serializable
        {
            private Float amount;
            private String publishedCurrencyCode;

            /** 
             * Get the 'Amount' attribute value.  SEG/@C68
             * 
             * @return value
             */
            public Float getAmount() {
                return amount;
            }

            /** 
             * Set the 'Amount' attribute value.  SEG/@C68
             * 
             * @param amount
             */
            public void setAmount(Float amount) {
                this.amount = amount;
            }

            /** 
             * Get the 'PublishedCurrencyCode' attribute value.  SEG/@C72
             * 
             * @return value
             */
            public String getPublishedCurrencyCode() {
                return publishedCurrencyCode;
            }

            /** 
             * Set the 'PublishedCurrencyCode' attribute value.  SEG/@C72
             * 
             * @param publishedCurrencyCode
             */
            public void setPublishedCurrencyCode(String publishedCurrencyCode) {
                this.publishedCurrencyCode = publishedCurrencyCode;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Stopover" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" name="Ind"/>
         *     &lt;xs:attribute type="xs:float" name="Amount"/>
         *     &lt;xs:attribute type="xs:string" name="PublishedCurrencyCode"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Stopover implements Serializable
        {
            private Boolean ind;
            private Float amount;
            private String publishedCurrencyCode;

            /** 
             * Get the 'Ind' attribute value.  (True means stopver, F means connection point) SEG/@P2M
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value.  (True means stopver, F means connection point) SEG/@P2M
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }

            /** 
             * Get the 'Amount' attribute value.  SEG/@C67
             * 
             * @return value
             */
            public Float getAmount() {
                return amount;
            }

            /** 
             * Set the 'Amount' attribute value.  SEG/@C67
             * 
             * @param amount
             */
            public void setAmount(Float amount) {
                this.amount = amount;
            }

            /** 
             * Get the 'PublishedCurrencyCode' attribute value.  SEG/@C73
             * 
             * @return value
             */
            public String getPublishedCurrencyCode() {
                return publishedCurrencyCode;
            }

            /** 
             * Set the 'PublishedCurrencyCode' attribute value.  SEG/@C73
             * 
             * @param publishedCurrencyCode
             */
            public void setPublishedCurrencyCode(String publishedCurrencyCode) {
                this.publishedCurrencyCode = publishedCurrencyCode;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Surface" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" name="Ind"/>
         *     &lt;xs:attribute type="xs:boolean" name="UnchargedInd"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Surface implements Serializable
        {
            private Boolean ind;
            private Boolean unchargedInd;

            /** 
             * Get the 'Ind' attribute value.  SEG/@S10
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value.  SEG/@S10
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }

            /** 
             * Get the 'UnchargedInd' attribute value.  SEG/@S09
             * 
             * @return value
             */
            public Boolean getUnchargedInd() {
                return unchargedInd;
            }

            /** 
             * Set the 'UnchargedInd' attribute value.  SEG/@S09
             * 
             * @param unchargedInd
             */
            public void setUnchargedInd(Boolean unchargedInd) {
                this.unchargedInd = unchargedInd;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FreeBaggageAllowance" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:unsignedShort" name="Quantity"/>
         *     &lt;xs:attribute type="xs:string" name="UnitOfMeasure"/>
         *     &lt;xs:attribute type="xs:boolean" name="NegFareRestInd"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FreeBaggageAllowance implements Serializable
        {
            private String quantity;
            private String unitOfMeasure;
            private Boolean negFareRestInd;

            /** 
             * Get the 'Quantity' attribute value.  SEG/@B20
             * 
             * @return value
             */
            public String getQuantity() {
                return quantity;
            }

            /** 
             * Set the 'Quantity' attribute value.  SEG/@B20
             * 
             * @param quantity
             */
            public void setQuantity(String quantity) {
                this.quantity = quantity;
            }

            /** 
             * Get the 'UnitOfMeasure' attribute value.  SEG/@N0D
             * 
             * @return value
             */
            public String getUnitOfMeasure() {
                return unitOfMeasure;
            }

            /** 
             * Set the 'UnitOfMeasure' attribute value.  SEG/@N0D
             * 
             * @param unitOfMeasure
             */
            public void setUnitOfMeasure(String unitOfMeasure) {
                this.unitOfMeasure = unitOfMeasure;
            }

            /** 
             * Get the 'NegFareRestInd' attribute value.   (Baggage comes from Cat 35 rather than FreeBaggage DB) SEG/@P26
             * 
             * @return value
             */
            public Boolean getNegFareRestInd() {
                return negFareRestInd;
            }

            /** 
             * Set the 'NegFareRestInd' attribute value.   (Baggage comes from Cat 35 rather than FreeBaggage DB) SEG/@P26
             * 
             * @param negFareRestInd
             */
            public void setNegFareRestInd(Boolean negFareRestInd) {
                this.negFareRestInd = negFareRestInd;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Mileage" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" name="ExtraAllowanceInd"/>
         *     &lt;xs:attribute type="xs:string" name="DisplayType"/>
         *     &lt;xs:attribute type="xs:string" name="DisplayCity"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Mileage implements Serializable
        {
            private Boolean extraAllowanceInd;
            private String displayType;
            private String displayCity;

            /** 
             * Get the 'ExtraAllowanceInd' attribute value.  SEG/@P2I
             * 
             * @return value
             */
            public Boolean getExtraAllowanceInd() {
                return extraAllowanceInd;
            }

            /** 
             * Set the 'ExtraAllowanceInd' attribute value.  SEG/@P2I
             * 
             * @param extraAllowanceInd
             */
            public void setExtraAllowanceInd(Boolean extraAllowanceInd) {
                this.extraAllowanceInd = extraAllowanceInd;
            }

            /** 
             * Get the 'DisplayType' attribute value.  SEG/MIL/@AP2
             * 
             * @return value
             */
            public String getDisplayType() {
                return displayType;
            }

            /** 
             * Set the 'DisplayType' attribute value.  SEG/MIL/@AP2
             * 
             * @param displayType
             */
            public void setDisplayType(String displayType) {
                this.displayType = displayType;
            }

            /** 
             * Get the 'DisplayCity' attribute value.  SEG/MIL/@AP3
             * 
             * @return value
             */
            public String getDisplayCity() {
                return displayCity;
            }

            /** 
             * Set the 'DisplayCity' attribute value.  SEG/MIL/@AP3
             * 
             * @param displayCity
             */
            public void setDisplayCity(String displayCity) {
                this.displayCity = displayCity;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Journey" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:anySimpleType" name="Type"/>
         *     &lt;xs:attribute type="xs:boolean" name="AvailabilityBreakInd"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Journey implements Serializable
        {
            private String type;
            private Boolean availabilityBreakInd;

            /** 
             * Get the 'Type' attribute value. Journey Type SEG/@N1L
             * 
             * @return value
             */
            public String getType() {
                return type;
            }

            /** 
             * Set the 'Type' attribute value. Journey Type SEG/@N1L
             * 
             * @param type
             */
            public void setType(String type) {
                this.type = type;
            }

            /** 
             * Get the 'AvailabilityBreakInd' attribute value. Availability Break SEG/@PAW
             * 
             * @return value
             */
            public Boolean getAvailabilityBreakInd() {
                return availabilityBreakInd;
            }

            /** 
             * Set the 'AvailabilityBreakInd' attribute value. Availability Break SEG/@PAW
             * 
             * @param availabilityBreakInd
             */
            public void setAvailabilityBreakInd(Boolean availabilityBreakInd) {
                this.availabilityBreakInd = availabilityBreakInd;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Cat35" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" name="FareBasisCode"/>
         *     &lt;xs:attribute type="xs:short" name="FareBasisCodeLength"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="FareSegment"/>
         *     &lt;xs:attribute type="xs:short" use="optional" name="PassengerNumber"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Cat35 implements Serializable
        {
            private String fareBasisCode;
            private Short fareBasisCodeLength;
            private Boolean fareSegment;
            private Short passengerNumber;

            /** 
             * Get the 'FareBasisCode' attribute value. Cat35 Fare Basis Code SEG/@B50
             * 
             * @return value
             */
            public String getFareBasisCode() {
                return fareBasisCode;
            }

            /** 
             * Set the 'FareBasisCode' attribute value. Cat35 Fare Basis Code SEG/@B50
             * 
             * @param fareBasisCode
             */
            public void setFareBasisCode(String fareBasisCode) {
                this.fareBasisCode = fareBasisCode;
            }

            /** 
             * Get the 'FareBasisCodeLength' attribute value. Cat35 Fare Basis Code Length SEG/@Q04
             * 
             * @return value
             */
            public Short getFareBasisCodeLength() {
                return fareBasisCodeLength;
            }

            /** 
             * Set the 'FareBasisCodeLength' attribute value. Cat35 Fare Basis Code Length SEG/@Q04
             * 
             * @param fareBasisCodeLength
             */
            public void setFareBasisCodeLength(Short fareBasisCodeLength) {
                this.fareBasisCodeLength = fareBasisCodeLength;
            }

            /** 
             * Get the 'FareSegment' attribute value. Cat35 Fare Segment SEG/@P26
             * 
             * @return value
             */
            public Boolean getFareSegment() {
                return fareSegment;
            }

            /** 
             * Set the 'FareSegment' attribute value. Cat35 Fare Segment SEG/@P26
             * 
             * @param fareSegment
             */
            public void setFareSegment(Boolean fareSegment) {
                this.fareSegment = fareSegment;
            }

            /** 
             * Get the 'PassengerNumber' attribute value.  SEGment Passenger Number SEG/@Q0Y
             * 
             * @return value
             */
            public Short getPassengerNumber() {
                return passengerNumber;
            }

            /** 
             * Set the 'PassengerNumber' attribute value.  SEGment Passenger Number SEG/@Q0Y
             * 
             * @param passengerNumber
             */
            public void setPassengerNumber(Short passengerNumber) {
                this.passengerNumber = passengerNumber;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketFarePerSegment" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:float" use="optional" name="Amount"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="FareBasisCode"/>
         *     &lt;xs:attribute type="xs:short" use="optional" name="FareBasisCodeLength"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class TicketFarePerSegment implements Serializable
        {
            private Float amount;
            private String fareBasisCode;
            private Short fareBasisCodeLength;

            /** 
             * Get the 'Amount' attribute value. Ticket Fare Per Segment Fare Amount SEG/@C52
             * 
             * @return value
             */
            public Float getAmount() {
                return amount;
            }

            /** 
             * Set the 'Amount' attribute value. Ticket Fare Per Segment Fare Amount SEG/@C52
             * 
             * @param amount
             */
            public void setAmount(Float amount) {
                this.amount = amount;
            }

            /** 
             * Get the 'FareBasisCode' attribute value. Ticket Fare Per Segment Fare Basis SEG/@B51
             * 
             * @return value
             */
            public String getFareBasisCode() {
                return fareBasisCode;
            }

            /** 
             * Set the 'FareBasisCode' attribute value. Ticket Fare Per Segment Fare Basis SEG/@B51
             * 
             * @param fareBasisCode
             */
            public void setFareBasisCode(String fareBasisCode) {
                this.fareBasisCode = fareBasisCode;
            }

            /** 
             * Get the 'FareBasisCodeLength' attribute value. Ticket Fare Per Segment Fare Basis Code Length SEG/@Q10
             * 
             * @return value
             */
            public Short getFareBasisCodeLength() {
                return fareBasisCodeLength;
            }

            /** 
             * Set the 'FareBasisCodeLength' attribute value. Ticket Fare Per Segment Fare Basis Code Length SEG/@Q10
             * 
             * @param fareBasisCodeLength
             */
            public void setFareBasisCodeLength(Short fareBasisCodeLength) {
                this.fareBasisCodeLength = fareBasisCodeLength;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarketingAirline" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class MarketingAirline implements Serializable
        {
            private String code;

            /** 
             * Get the 'Code' attribute value. Marketing Airline SEG/@B00
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'Code' attribute value. Marketing Airline SEG/@B00
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OperatingCarrier" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OperatingCarrier implements Serializable
        {
            private String code;

            /** 
             * Get the 'Code' attribute value. Operating Carrier Code SEG/@B01
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'Code' attribute value. Operating Carrier Code SEG/@B01
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PlusUps" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:PlusUpType" name="PlusUp" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PlusUps implements Serializable
    {
        private List<PlusUpType> plusUpList = new ArrayList<PlusUpType>();

        /** 
         * Get the list of 'PlusUp' element items.
         * 
         * @return list
         */
        public List<PlusUpType> getPlusUpList() {
            return plusUpList;
        }

        /** 
         * Set the list of 'PlusUp' element items.
         * 
         * @param list
         */
        public void setPlusUpList(List<PlusUpType> list) {
            plusUpList = list;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NetRemitPlusUps" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:PlusUpType" name="PlusUp" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class NetRemitPlusUps implements Serializable
    {
        private List<PlusUpType> plusUpList = new ArrayList<PlusUpType>();

        /** 
         * Get the list of 'PlusUp' element items.
         * 
         * @return list
         */
        public List<PlusUpType> getPlusUpList() {
            return plusUpList;
        }

        /** 
         * Set the list of 'PlusUp' element items.
         * 
         * @param list
         */
        public void setPlusUpList(List<PlusUpType> list) {
            plusUpList = list;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HandlingMarkupDetails" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="HandlingMarkupDetail" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class HandlingMarkupDetail -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class HandlingMarkupDetails implements Serializable
    {
        private List<HandlingMarkupDetail> handlingMarkupDetailList = new ArrayList<HandlingMarkupDetail>();

        /** 
         * Get the list of 'HandlingMarkupDetail' element items.
         * 
         * @return list
         */
        public List<HandlingMarkupDetail> getHandlingMarkupDetailList() {
            return handlingMarkupDetailList;
        }

        /** 
         * Set the list of 'HandlingMarkupDetail' element items.
         * 
         * @param list
         */
        public void setHandlingMarkupDetailList(List<HandlingMarkupDetail> list) {
            handlingMarkupDetailList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HandlingMarkupDetail" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="MarkupHandlingFeeAppID"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="MarkupTypeCode"/>
         *     &lt;xs:attribute type="xs:float" use="optional" name="FareAmountAfterMarkup"/>
         *     &lt;xs:attribute type="xs:float" use="optional" name="MarkupAmount"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="AmountCurrency"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="MarkupRuleSourcePCC"/>
         *     &lt;xs:attribute type="xs:unsignedLong" use="optional" name="MarkupRuleItemNumber"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="RetailerRuleQualifier"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class HandlingMarkupDetail implements Serializable
        {
            private String markupHandlingFeeAppID;
            private String markupTypeCode;
            private Float fareAmountAfterMarkup;
            private Float markupAmount;
            private String amountCurrency;
            private String markupRuleSourcePCC;
            private String markupRuleItemNumber;
            private String retailerRuleQualifier;

            /** 
             * Get the 'MarkupHandlingFeeAppID' attribute value.  CAL/HPU/@APP
             * 
             * @return value
             */
            public String getMarkupHandlingFeeAppID() {
                return markupHandlingFeeAppID;
            }

            /** 
             * Set the 'MarkupHandlingFeeAppID' attribute value.  CAL/HPU/@APP
             * 
             * @param markupHandlingFeeAppID
             */
            public void setMarkupHandlingFeeAppID(String markupHandlingFeeAppID) {
                this.markupHandlingFeeAppID = markupHandlingFeeAppID;
            }

            /** 
             * Get the 'MarkupTypeCode' attribute value.  CAL/HPU/@T52
             * 
             * @return value
             */
            public String getMarkupTypeCode() {
                return markupTypeCode;
            }

            /** 
             * Set the 'MarkupTypeCode' attribute value.  CAL/HPU/@T52
             * 
             * @param markupTypeCode
             */
            public void setMarkupTypeCode(String markupTypeCode) {
                this.markupTypeCode = markupTypeCode;
            }

            /** 
             * Get the 'FareAmountAfterMarkup' attribute value.  CAL/HPU/@C51
             * 
             * @return value
             */
            public Float getFareAmountAfterMarkup() {
                return fareAmountAfterMarkup;
            }

            /** 
             * Set the 'FareAmountAfterMarkup' attribute value.  CAL/HPU/@C51
             * 
             * @param fareAmountAfterMarkup
             */
            public void setFareAmountAfterMarkup(Float fareAmountAfterMarkup) {
                this.fareAmountAfterMarkup = fareAmountAfterMarkup;
            }

            /** 
             * Get the 'MarkupAmount' attribute value.  CAL/HPU/@C52
             * 
             * @return value
             */
            public Float getMarkupAmount() {
                return markupAmount;
            }

            /** 
             * Set the 'MarkupAmount' attribute value.  CAL/HPU/@C52
             * 
             * @param markupAmount
             */
            public void setMarkupAmount(Float markupAmount) {
                this.markupAmount = markupAmount;
            }

            /** 
             * Get the 'AmountCurrency' attribute value.  CAL/HPU/@C53
             * 
             * @return value
             */
            public String getAmountCurrency() {
                return amountCurrency;
            }

            /** 
             * Set the 'AmountCurrency' attribute value.  CAL/HPU/@C53
             * 
             * @param amountCurrency
             */
            public void setAmountCurrency(String amountCurrency) {
                this.amountCurrency = amountCurrency;
            }

            /** 
             * Get the 'MarkupRuleSourcePCC' attribute value.  CAL/HPU/@A52
             * 
             * @return value
             */
            public String getMarkupRuleSourcePCC() {
                return markupRuleSourcePCC;
            }

            /** 
             * Set the 'MarkupRuleSourcePCC' attribute value.  CAL/HPU/@A52
             * 
             * @param markupRuleSourcePCC
             */
            public void setMarkupRuleSourcePCC(String markupRuleSourcePCC) {
                this.markupRuleSourcePCC = markupRuleSourcePCC;
            }

            /** 
             * Get the 'MarkupRuleItemNumber' attribute value.  CAL/HPU/@R52
             * 
             * @return value
             */
            public String getMarkupRuleItemNumber() {
                return markupRuleItemNumber;
            }

            /** 
             * Set the 'MarkupRuleItemNumber' attribute value.  CAL/HPU/@R52
             * 
             * @param markupRuleItemNumber
             */
            public void setMarkupRuleItemNumber(String markupRuleItemNumber) {
                this.markupRuleItemNumber = markupRuleItemNumber;
            }

            /** 
             * Get the 'RetailerRuleQualifier' attribute value.  CAL/HPU/@RC3
             * 
             * @return value
             */
            public String getRetailerRuleQualifier() {
                return retailerRuleQualifier;
            }

            /** 
             * Set the 'RetailerRuleQualifier' attribute value.  CAL/HPU/@RC3
             * 
             * @param retailerRuleQualifier
             */
            public void setRetailerRuleQualifier(String retailerRuleQualifier) {
                this.retailerRuleQualifier = retailerRuleQualifier;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareRetailerInfo" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="FareRetailerRule" minOccurs="0" maxOccurs="2">
     *         &lt;!-- Reference to inner class FareRetailerRule -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FareRetailerSourcePCC" minOccurs="0" maxOccurs="2">
     *         &lt;!-- Reference to inner class FareRetailerSourcePCC -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FareRetailerInfo implements Serializable
    {
        private List<FareRetailerRule> fareRetailerRuleList = new ArrayList<FareRetailerRule>();
        private List<FareRetailerSourcePCC> fareRetailerSourcePCCList = new ArrayList<FareRetailerSourcePCC>();

        /** 
         * Get the list of 'FareRetailerRule' element items.
         * 
         * @return list
         */
        public List<FareRetailerRule> getFareRetailerRuleList() {
            return fareRetailerRuleList;
        }

        /** 
         * Set the list of 'FareRetailerRule' element items.
         * 
         * @param list
         */
        public void setFareRetailerRuleList(List<FareRetailerRule> list) {
            fareRetailerRuleList = list;
        }

        /** 
         * Get the list of 'FareRetailerSourcePCC' element items.
         * 
         * @return list
         */
        public List<FareRetailerSourcePCC> getFareRetailerSourcePCCList() {
            return fareRetailerSourcePCCList;
        }

        /** 
         * Set the list of 'FareRetailerSourcePCC' element items.
         * 
         * @param list
         */
        public void setFareRetailerSourcePCCList(
                List<FareRetailerSourcePCC> list) {
            fareRetailerSourcePCCList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareRetailerRule" minOccurs="0" maxOccurs="2">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="TransactionType"/>
         *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FareRetailerRule implements Serializable
        {
            private String transactionType;
            private String code;

            /** 
             * Get the 'TransactionType' attribute value.
             * 
             * @return value
             */
            public String getTransactionType() {
                return transactionType;
            }

            /** 
             * Set the 'TransactionType' attribute value.
             * 
             * @param transactionType
             */
            public void setTransactionType(String transactionType) {
                this.transactionType = transactionType;
            }

            /** 
             * Get the 'Code' attribute value.
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'Code' attribute value.
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareRetailerSourcePCC" minOccurs="0" maxOccurs="2">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="RuleType"/>
         *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FareRetailerSourcePCC implements Serializable
        {
            private String ruleType;
            private String code;

            /** 
             * Get the 'RuleType' attribute value.
             * 
             * @return value
             */
            public String getRuleType() {
                return ruleType;
            }

            /** 
             * Set the 'RuleType' attribute value.
             * 
             * @param ruleType
             */
            public void setRuleType(String ruleType) {
                this.ruleType = ruleType;
            }

            /** 
             * Get the 'Code' attribute value.
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'Code' attribute value.
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OC_FeeMatchedGroup" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="OC_PNR_ID" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class OCPNRID -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="required" name="GroupCode"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OCFeeMatchedGroup implements Serializable
    {
        private List<OCPNRID> OCPNRIDList = new ArrayList<OCPNRID>();
        private String groupCode;

        /** 
         * Get the list of 'OC_PNR_ID' element items.
         * 
         * @return list
         */
        public List<OCPNRID> getOCPNRIDList() {
            return OCPNRIDList;
        }

        /** 
         * Set the list of 'OC_PNR_ID' element items.
         * 
         * @param list
         */
        public void setOCPNRIDList(List<OCPNRID> list) {
            OCPNRIDList = list;
        }

        /** 
         * Get the 'GroupCode' attribute value. Matching Group Code /SUM/GOC/@SF0
         * 
         * @return value
         */
        public String getGroupCode() {
            return groupCode;
        }

        /** 
         * Set the 'GroupCode' attribute value. Matching Group Code /SUM/GOC/@SF0
         * 
         * @param groupCode
         */
        public void setGroupCode(String groupCode) {
            this.groupCode = groupCode;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OC_PNR_ID" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:integer" use="required" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OCPNRID implements Serializable
        {
            private BigInteger ind;

            /** 
             * Get the 'Ind' attribute value. Matching Reference Number /SUM/GOC/OCI/@ID0
             * 
             * @return value
             */
            public BigInteger getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. Matching Reference Number /SUM/GOC/OCI/@ID0
             * 
             * @param ind
             */
            public void setInd(BigInteger ind) {
                this.ind = ind;
            }
        }
    }
}
