
package com.sabre.webservices.sabrexml;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InvoiceItineraryRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="ActionIdentifier">
 *         &lt;xs:simpleType>
 *           &lt;!-- Reference to inner class ActionIdentifier -->
 *         &lt;/xs:simpleType>
 *       &lt;/xs:element>
 *       &lt;xs:element name="OptionalQualifiers" minOccurs="0">
 *         &lt;!-- Reference to inner class OptionalQualifiers -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="Print" minOccurs="0">
 *         &lt;!-- Reference to inner class Print -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:boolean" use="optional" name="ReturnHostCommand"/>
 *     &lt;xs:attribute type="xs:dateTime" use="optional" name="TimeStamp"/>
 *     &lt;xs:attribute type="xs:string" use="required" fixed="2.0.0" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class InvoiceItineraryRQ implements Serializable
{
    private ActionIdentifier actionIdentifier;
    private OptionalQualifiers optionalQualifiers;
    private Print print;
    private Boolean returnHostCommand;
    private Date timeStamp;
    private String version;

    /** 
     * Get the 'ActionIdentifier' element value.
     * 
     * @return value
     */
    public ActionIdentifier getActionIdentifier() {
        return actionIdentifier;
    }

    /** 
     * Set the 'ActionIdentifier' element value.
     * 
     * @param actionIdentifier
     */
    public void setActionIdentifier(ActionIdentifier actionIdentifier) {
        this.actionIdentifier = actionIdentifier;
    }

    /** 
     * Get the 'OptionalQualifiers' element value.
     * 
     * @return value
     */
    public OptionalQualifiers getOptionalQualifiers() {
        return optionalQualifiers;
    }

    /** 
     * Set the 'OptionalQualifiers' element value.
     * 
     * @param optionalQualifiers
     */
    public void setOptionalQualifiers(OptionalQualifiers optionalQualifiers) {
        this.optionalQualifiers = optionalQualifiers;
    }

    /** 
     * Get the 'Print' element value.
     * 
     * @return value
     */
    public Print getPrint() {
        return print;
    }

    /** 
     * Set the 'Print' element value.
     * 
     * @param print
     */
    public void setPrint(Print print) {
        this.print = print;
    }

    /** 
     * Get the 'ReturnHostCommand' attribute value.
     * 
     * @return value
     */
    public Boolean getReturnHostCommand() {
        return returnHostCommand;
    }

    /** 
     * Set the 'ReturnHostCommand' attribute value.
     * 
     * @param returnHostCommand
     */
    public void setReturnHostCommand(Boolean returnHostCommand) {
        this.returnHostCommand = returnHostCommand;
    }

    /** 
     * Get the 'TimeStamp' attribute value.
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value.
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="DIN"/>
     *     &lt;xs:enumeration value="DIT"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum ActionIdentifier implements Serializable {
        DIN, DIT
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OptionalQualifiers" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="MiscQualifiers" minOccurs="0">
     *         &lt;!-- Reference to inner class MiscQualifiers -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OptionalQualifiers implements Serializable
    {
        private MiscQualifiers miscQualifiers;

        /** 
         * Get the 'MiscQualifiers' element value.
         * 
         * @return value
         */
        public MiscQualifiers getMiscQualifiers() {
            return miscQualifiers;
        }

        /** 
         * Set the 'MiscQualifiers' element value.
         * 
         * @param miscQualifiers
         */
        public void setMiscQualifiers(MiscQualifiers miscQualifiers) {
            this.miscQualifiers = miscQualifiers;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MiscQualifiers" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="AccountingInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class AccountingInfo -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="CustomerIdentifier" minOccurs="0"/>
         *       &lt;xs:element name="ItineraryOptions" minOccurs="0">
         *         &lt;!-- Reference to inner class ItineraryOptions -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="NameSelect" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class NameSelect -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="QueueInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class QueueInfo -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class MiscQualifiers implements Serializable
        {
            private AccountingInfo accountingInfo;
            private String customerIdentifier;
            private ItineraryOptions itineraryOptions;
            private List<NameSelect> nameSelectList = new ArrayList<NameSelect>();
            private QueueInfo queueInfo;

            /** 
             * Get the 'AccountingInfo' element value.
             * 
             * @return value
             */
            public AccountingInfo getAccountingInfo() {
                return accountingInfo;
            }

            /** 
             * Set the 'AccountingInfo' element value.
             * 
             * @param accountingInfo
             */
            public void setAccountingInfo(AccountingInfo accountingInfo) {
                this.accountingInfo = accountingInfo;
            }

            /** 
             * Get the 'CustomerIdentifier' element value.
             * 
             * @return value
             */
            public String getCustomerIdentifier() {
                return customerIdentifier;
            }

            /** 
             * Set the 'CustomerIdentifier' element value.
             * 
             * @param customerIdentifier
             */
            public void setCustomerIdentifier(String customerIdentifier) {
                this.customerIdentifier = customerIdentifier;
            }

            /** 
             * Get the 'ItineraryOptions' element value.
             * 
             * @return value
             */
            public ItineraryOptions getItineraryOptions() {
                return itineraryOptions;
            }

            /** 
             * Set the 'ItineraryOptions' element value.
             * 
             * @param itineraryOptions
             */
            public void setItineraryOptions(ItineraryOptions itineraryOptions) {
                this.itineraryOptions = itineraryOptions;
            }

            /** 
             * Get the list of 'NameSelect' element items.
             * 
             * @return list
             */
            public List<NameSelect> getNameSelectList() {
                return nameSelectList;
            }

            /** 
             * Set the list of 'NameSelect' element items.
             * 
             * @param list
             */
            public void setNameSelectList(List<NameSelect> list) {
                nameSelectList = list;
            }

            /** 
             * Get the 'QueueInfo' element value.
             * 
             * @return value
             */
            public QueueInfo getQueueInfo() {
                return queueInfo;
            }

            /** 
             * Set the 'QueueInfo' element value.
             * 
             * @param queueInfo
             */
            public void setQueueInfo(QueueInfo queueInfo) {
                this.queueInfo = queueInfo;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AccountingInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Line" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class Line -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AccountingInfo implements Serializable
            {
                private List<Line> lineList = new ArrayList<Line>();

                /** 
                 * Get the list of 'Line' element items.
                 * 
                 * @return list
                 */
                public List<Line> getLineList() {
                    return lineList;
                }

                /** 
                 * Set the list of 'Line' element items.
                 * 
                 * @param list
                 */
                public void setLineList(List<Line> list) {
                    lineList = list;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Line" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Line implements Serializable
                {
                    private BigInteger number;

                    /** 
                     * Get the 'Number' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'Number' attribute value.
                     * 
                     * @param number
                     */
                    public void setNumber(BigInteger number) {
                        this.number = number;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ItineraryOptions" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="SegmentSelect" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class SegmentSelect -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ItineraryOptions implements Serializable
            {
                private List<SegmentSelect> segmentSelectList = new ArrayList<SegmentSelect>();

                /** 
                 * Get the list of 'SegmentSelect' element items.
                 * 
                 * @return list
                 */
                public List<SegmentSelect> getSegmentSelectList() {
                    return segmentSelectList;
                }

                /** 
                 * Set the list of 'SegmentSelect' element items.
                 * 
                 * @param list
                 */
                public void setSegmentSelectList(List<SegmentSelect> list) {
                    segmentSelectList = list;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SegmentSelect" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:integer" use="optional" name="EndNumber"/>
                 *     &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class SegmentSelect implements Serializable
                {
                    private BigInteger endNumber;
                    private BigInteger number;

                    /** 
                     * Get the 'EndNumber' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getEndNumber() {
                        return endNumber;
                    }

                    /** 
                     * Set the 'EndNumber' attribute value.
                     * 
                     * @param endNumber
                     */
                    public void setEndNumber(BigInteger endNumber) {
                        this.endNumber = endNumber;
                    }

                    /** 
                     * Get the 'Number' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'Number' attribute value.
                     * 
                     * @param number
                     */
                    public void setNumber(BigInteger number) {
                        this.number = number;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NameSelect" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="EndNameNumber"/>
             *     &lt;xs:attribute type="xs:string" use="required" name="NameNumber"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class NameSelect implements Serializable
            {
                private String endNameNumber;
                private String nameNumber;

                /** 
                 * Get the 'EndNameNumber' attribute value.
                 * 
                 * @return value
                 */
                public String getEndNameNumber() {
                    return endNameNumber;
                }

                /** 
                 * Set the 'EndNameNumber' attribute value.
                 * 
                 * @param endNameNumber
                 */
                public void setEndNameNumber(String endNameNumber) {
                    this.endNameNumber = endNameNumber;
                }

                /** 
                 * Get the 'NameNumber' attribute value.
                 * 
                 * @return value
                 */
                public String getNameNumber() {
                    return nameNumber;
                }

                /** 
                 * Set the 'NameNumber' attribute value.
                 * 
                 * @param nameNumber
                 */
                public void setNameNumber(String nameNumber) {
                    this.nameNumber = nameNumber;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="QueueInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="QueueIdentifier" maxOccurs="3">
             *         &lt;!-- Reference to inner class QueueIdentifier -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class QueueInfo implements Serializable
            {
                private List<QueueIdentifier> queueIdentifierList = new ArrayList<QueueIdentifier>();

                /** 
                 * Get the list of 'QueueIdentifier' element items.
                 * 
                 * @return list
                 */
                public List<QueueIdentifier> getQueueIdentifierList() {
                    return queueIdentifierList;
                }

                /** 
                 * Set the list of 'QueueIdentifier' element items.
                 * 
                 * @param list
                 */
                public void setQueueIdentifierList(List<QueueIdentifier> list) {
                    queueIdentifierList = list;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="QueueIdentifier" maxOccurs="3">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Number"/>
                 *     &lt;xs:attribute type="xs:string" use="required" name="PrefatoryInstructionCode"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="PseudoCityCode"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class QueueIdentifier implements Serializable
                {
                    private String number;
                    private String prefatoryInstructionCode;
                    private String pseudoCityCode;

                    /** 
                     * Get the 'Number' attribute value.
                     * 
                     * @return value
                     */
                    public String getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'Number' attribute value.
                     * 
                     * @param number
                     */
                    public void setNumber(String number) {
                        this.number = number;
                    }

                    /** 
                     * Get the 'PrefatoryInstructionCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getPrefatoryInstructionCode() {
                        return prefatoryInstructionCode;
                    }

                    /** 
                     * Set the 'PrefatoryInstructionCode' attribute value.
                     * 
                     * @param prefatoryInstructionCode
                     */
                    public void setPrefatoryInstructionCode(
                            String prefatoryInstructionCode) {
                        this.prefatoryInstructionCode = prefatoryInstructionCode;
                    }

                    /** 
                     * Get the 'PseudoCityCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getPseudoCityCode() {
                        return pseudoCityCode;
                    }

                    /** 
                     * Set the 'PseudoCityCode' attribute value.
                     * 
                     * @param pseudoCityCode
                     */
                    public void setPseudoCityCode(String pseudoCityCode) {
                        this.pseudoCityCode = pseudoCityCode;
                    }
                }
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Print" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Qualifier" minOccurs="0">
     *         &lt;xs:simpleType>
     *           &lt;!-- Reference to inner class Qualifier -->
     *         &lt;/xs:simpleType>
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:integer" use="optional" name="NumCopies"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="PNR_Hardcopy"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Print implements Serializable
    {
        private Qualifier qualifier;
        private BigInteger numCopies;
        private Boolean PNRHardcopy;

        /** 
         * Get the 'Qualifier' element value.
         * 
         * @return value
         */
        public Qualifier getQualifier() {
            return qualifier;
        }

        /** 
         * Set the 'Qualifier' element value.
         * 
         * @param qualifier
         */
        public void setQualifier(Qualifier qualifier) {
            this.qualifier = qualifier;
        }

        /** 
         * Get the 'NumCopies' attribute value.
         * 
         * @return value
         */
        public BigInteger getNumCopies() {
            return numCopies;
        }

        /** 
         * Set the 'NumCopies' attribute value.
         * 
         * @param numCopies
         */
        public void setNumCopies(BigInteger numCopies) {
            this.numCopies = numCopies;
        }

        /** 
         * Get the 'PNR_Hardcopy' attribute value.
         * 
         * @return value
         */
        public Boolean getPNRHardcopy() {
            return PNRHardcopy;
        }

        /** 
         * Set the 'PNR_Hardcopy' attribute value.
         * 
         * @param PNRHardcopy
         */
        public void setPNRHardcopy(Boolean PNRHardcopy) {
            this.PNRHardcopy = PNRHardcopy;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
         *   &lt;xs:restriction base="xs:string">
         *     &lt;xs:enumeration value="Invoice"/>
         *     &lt;xs:enumeration value="Itinerary"/>
         *     &lt;xs:enumeration value="InvoiceItinerary"/>
         *   &lt;/xs:restriction>
         * &lt;/xs:simpleType>
         * </pre>
         */
        public static enum Qualifier implements Serializable {
            INVOICE("Invoice"), ITINERARY("Itinerary"), INVOICE_ITINERARY(
                    "InvoiceItinerary");
            private final String value;

            private Qualifier(String value) {
                this.value = value;
            }

            public String xmlValue() {
                return value;
            }

            public static Qualifier convert(String value) {
                for (Qualifier inst : values()) {
                    if (inst.xmlValue().equals(value)) {
                        return inst;
                    }
                }
                return null;
            }
        }
    }
}
