
package com.sabre.webservices.sabrexml;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ManualPriceQuoteAddInfoRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="ContentDetails" minOccurs="0">
 *         &lt;!-- Reference to inner class ContentDetails -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="CreationDetails" minOccurs="0">
 *         &lt;!-- Reference to inner class CreationDetails -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:boolean" use="optional" name="ReturnHostCommand"/>
 *     &lt;xs:attribute type="xs:dateTime" use="optional" name="TimeStamp"/>
 *     &lt;xs:attribute type="xs:string" use="required" fixed="2.0.0" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class ManualPriceQuoteAddInfoRQ implements Serializable
{
    private ContentDetails contentDetails;
    private CreationDetails creationDetails;
    private Boolean returnHostCommand;
    private Date timeStamp;
    private String version;

    /** 
     * Get the 'ContentDetails' element value.
     * 
     * @return value
     */
    public ContentDetails getContentDetails() {
        return contentDetails;
    }

    /** 
     * Set the 'ContentDetails' element value.
     * 
     * @param contentDetails
     */
    public void setContentDetails(ContentDetails contentDetails) {
        this.contentDetails = contentDetails;
    }

    /** 
     * Get the 'CreationDetails' element value.
     * 
     * @return value
     */
    public CreationDetails getCreationDetails() {
        return creationDetails;
    }

    /** 
     * Set the 'CreationDetails' element value.
     * 
     * @param creationDetails
     */
    public void setCreationDetails(CreationDetails creationDetails) {
        this.creationDetails = creationDetails;
    }

    /** 
     * Get the 'ReturnHostCommand' attribute value.
     * 
     * @return value
     */
    public Boolean getReturnHostCommand() {
        return returnHostCommand;
    }

    /** 
     * Set the 'ReturnHostCommand' attribute value.
     * 
     * @param returnHostCommand
     */
    public void setReturnHostCommand(Boolean returnHostCommand) {
        this.returnHostCommand = returnHostCommand;
    }

    /** 
     * Get the 'TimeStamp' attribute value.
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value.
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContentDetails" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Commission" minOccurs="0">
     *         &lt;!-- Reference to inner class Commission -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Endorsements" minOccurs="0">
     *         &lt;!-- Reference to inner class Endorsements -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FareByLeg" minOccurs="0">
     *         &lt;!-- Reference to inner class FareByLeg -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FareCalc" minOccurs="0">
     *         &lt;!-- Reference to inner class FareCalc -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FareLadder" minOccurs="0">
     *         &lt;!-- Reference to inner class FareLadder -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:string" name="HemisphereCode" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="JourneyCode" minOccurs="0"/>
     *       &lt;xs:element name="LineEntitlements" minOccurs="0">
     *         &lt;!-- Reference to inner class LineEntitlements -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="NetRemit" minOccurs="0">
     *         &lt;!-- Reference to inner class NetRemit -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="TourCode" minOccurs="0">
     *         &lt;!-- Reference to inner class TourCode -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:string" name="ValidatingCarrier" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:integer" use="optional" name="Record"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ContentDetails implements Serializable
    {
        private Commission commission;
        private Endorsements endorsements;
        private FareByLeg fareByLeg;
        private FareCalc fareCalc;
        private FareLadder fareLadder;
        private String hemisphereCode;
        private String journeyCode;
        private LineEntitlements lineEntitlements;
        private NetRemit netRemit;
        private TourCode tourCode;
        private String validatingCarrier;
        private BigInteger record;

        /** 
         * Get the 'Commission' element value.
         * 
         * @return value
         */
        public Commission getCommission() {
            return commission;
        }

        /** 
         * Set the 'Commission' element value.
         * 
         * @param commission
         */
        public void setCommission(Commission commission) {
            this.commission = commission;
        }

        /** 
         * Get the 'Endorsements' element value.
         * 
         * @return value
         */
        public Endorsements getEndorsements() {
            return endorsements;
        }

        /** 
         * Set the 'Endorsements' element value.
         * 
         * @param endorsements
         */
        public void setEndorsements(Endorsements endorsements) {
            this.endorsements = endorsements;
        }

        /** 
         * Get the 'FareByLeg' element value.
         * 
         * @return value
         */
        public FareByLeg getFareByLeg() {
            return fareByLeg;
        }

        /** 
         * Set the 'FareByLeg' element value.
         * 
         * @param fareByLeg
         */
        public void setFareByLeg(FareByLeg fareByLeg) {
            this.fareByLeg = fareByLeg;
        }

        /** 
         * Get the 'FareCalc' element value.
         * 
         * @return value
         */
        public FareCalc getFareCalc() {
            return fareCalc;
        }

        /** 
         * Set the 'FareCalc' element value.
         * 
         * @param fareCalc
         */
        public void setFareCalc(FareCalc fareCalc) {
            this.fareCalc = fareCalc;
        }

        /** 
         * Get the 'FareLadder' element value.
         * 
         * @return value
         */
        public FareLadder getFareLadder() {
            return fareLadder;
        }

        /** 
         * Set the 'FareLadder' element value.
         * 
         * @param fareLadder
         */
        public void setFareLadder(FareLadder fareLadder) {
            this.fareLadder = fareLadder;
        }

        /** 
         * Get the 'HemisphereCode' element value.
         * 
         * @return value
         */
        public String getHemisphereCode() {
            return hemisphereCode;
        }

        /** 
         * Set the 'HemisphereCode' element value.
         * 
         * @param hemisphereCode
         */
        public void setHemisphereCode(String hemisphereCode) {
            this.hemisphereCode = hemisphereCode;
        }

        /** 
         * Get the 'JourneyCode' element value.
         * 
         * @return value
         */
        public String getJourneyCode() {
            return journeyCode;
        }

        /** 
         * Set the 'JourneyCode' element value.
         * 
         * @param journeyCode
         */
        public void setJourneyCode(String journeyCode) {
            this.journeyCode = journeyCode;
        }

        /** 
         * Get the 'LineEntitlements' element value.
         * 
         * @return value
         */
        public LineEntitlements getLineEntitlements() {
            return lineEntitlements;
        }

        /** 
         * Set the 'LineEntitlements' element value.
         * 
         * @param lineEntitlements
         */
        public void setLineEntitlements(LineEntitlements lineEntitlements) {
            this.lineEntitlements = lineEntitlements;
        }

        /** 
         * Get the 'NetRemit' element value.
         * 
         * @return value
         */
        public NetRemit getNetRemit() {
            return netRemit;
        }

        /** 
         * Set the 'NetRemit' element value.
         * 
         * @param netRemit
         */
        public void setNetRemit(NetRemit netRemit) {
            this.netRemit = netRemit;
        }

        /** 
         * Get the 'TourCode' element value.
         * 
         * @return value
         */
        public TourCode getTourCode() {
            return tourCode;
        }

        /** 
         * Set the 'TourCode' element value.
         * 
         * @param tourCode
         */
        public void setTourCode(TourCode tourCode) {
            this.tourCode = tourCode;
        }

        /** 
         * Get the 'ValidatingCarrier' element value.
         * 
         * @return value
         */
        public String getValidatingCarrier() {
            return validatingCarrier;
        }

        /** 
         * Set the 'ValidatingCarrier' element value.
         * 
         * @param validatingCarrier
         */
        public void setValidatingCarrier(String validatingCarrier) {
            this.validatingCarrier = validatingCarrier;
        }

        /** 
         * Get the 'Record' attribute value.
         * 
         * @return value
         */
        public BigInteger getRecord() {
            return record;
        }

        /** 
         * Set the 'Record' attribute value.
         * 
         * @param record
         */
        public void setRecord(BigInteger record) {
            this.record = record;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Commission" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
         *     &lt;xs:attribute type="xs:decimal" use="optional" name="Percent"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Commission implements Serializable
        {
            private String amount;
            private BigDecimal percent;

            /** 
             * Get the 'Amount' attribute value.
             * 
             * @return value
             */
            public String getAmount() {
                return amount;
            }

            /** 
             * Set the 'Amount' attribute value.
             * 
             * @param amount
             */
            public void setAmount(String amount) {
                this.amount = amount;
            }

            /** 
             * Get the 'Percent' attribute value.
             * 
             * @return value
             */
            public BigDecimal getPercent() {
                return percent;
            }

            /** 
             * Set the 'Percent' attribute value.
             * 
             * @param percent
             */
            public void setPercent(BigDecimal percent) {
                this.percent = percent;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Endorsements" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="Text"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="Override"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Endorsements implements Serializable
        {
            private String text;
            private Boolean override;

            /** 
             * Get the 'Text' element value.
             * 
             * @return value
             */
            public String getText() {
                return text;
            }

            /** 
             * Set the 'Text' element value.
             * 
             * @param text
             */
            public void setText(String text) {
                this.text = text;
            }

            /** 
             * Get the 'Override' attribute value.
             * 
             * @return value
             */
            public Boolean getOverride() {
                return override;
            }

            /** 
             * Set the 'Override' attribute value.
             * 
             * @param override
             */
            public void setOverride(Boolean override) {
                this.override = override;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareByLeg" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Line" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Line -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FareByLeg implements Serializable
        {
            private List<Line> lineList = new ArrayList<Line>();

            /** 
             * Get the list of 'Line' element items.
             * 
             * @return list
             */
            public List<Line> getLineList() {
                return lineList;
            }

            /** 
             * Set the list of 'Line' element items.
             * 
             * @param list
             */
            public void setLineList(List<Line> list) {
                lineList = list;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Line" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="BaseFare">
             *         &lt;xs:complexType>
             *           &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Line implements Serializable
            {
                private String baseFare;
                private BigInteger number;

                /** 
                 * Get the 'Amount' attribute value.
                 * 
                 * @return value
                 */
                public String getBaseFare() {
                    return baseFare;
                }

                /** 
                 * Set the 'Amount' attribute value.
                 * 
                 * @param baseFare
                 */
                public void setBaseFare(String baseFare) {
                    this.baseFare = baseFare;
                }

                /** 
                 * Get the 'Number' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getNumber() {
                    return number;
                }

                /** 
                 * Set the 'Number' attribute value.
                 * 
                 * @param number
                 */
                public void setNumber(BigInteger number) {
                    this.number = number;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareCalc" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="Text"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:integer" use="optional" name="BookletNumber"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FareCalc implements Serializable
        {
            private String text;
            private BigInteger bookletNumber;

            /** 
             * Get the 'Text' element value.
             * 
             * @return value
             */
            public String getText() {
                return text;
            }

            /** 
             * Set the 'Text' element value.
             * 
             * @param text
             */
            public void setText(String text) {
                this.text = text;
            }

            /** 
             * Get the 'BookletNumber' attribute value.
             * 
             * @return value
             */
            public BigInteger getBookletNumber() {
                return bookletNumber;
            }

            /** 
             * Set the 'BookletNumber' attribute value.
             * 
             * @param bookletNumber
             */
            public void setBookletNumber(BigInteger bookletNumber) {
                this.bookletNumber = bookletNumber;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareLadder" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="BaseFare" minOccurs="0">
         *         &lt;!-- Reference to inner class BaseFare -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="EquivFare" minOccurs="0">
         *         &lt;!-- Reference to inner class EquivFare -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="FareandPaidTaxes" minOccurs="0">
         *         &lt;!-- Reference to inner class FareandPaidTaxes -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Taxes" minOccurs="0">
         *         &lt;!-- Reference to inner class Taxes -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FareLadder implements Serializable
        {
            private BaseFare baseFare;
            private EquivFare equivFare;
            private FareandPaidTaxes fareandPaidTaxes;
            private Taxes taxes;

            /** 
             * Get the 'BaseFare' element value.
             * 
             * @return value
             */
            public BaseFare getBaseFare() {
                return baseFare;
            }

            /** 
             * Set the 'BaseFare' element value.
             * 
             * @param baseFare
             */
            public void setBaseFare(BaseFare baseFare) {
                this.baseFare = baseFare;
            }

            /** 
             * Get the 'EquivFare' element value.
             * 
             * @return value
             */
            public EquivFare getEquivFare() {
                return equivFare;
            }

            /** 
             * Set the 'EquivFare' element value.
             * 
             * @param equivFare
             */
            public void setEquivFare(EquivFare equivFare) {
                this.equivFare = equivFare;
            }

            /** 
             * Get the 'FareandPaidTaxes' element value.
             * 
             * @return value
             */
            public FareandPaidTaxes getFareandPaidTaxes() {
                return fareandPaidTaxes;
            }

            /** 
             * Set the 'FareandPaidTaxes' element value.
             * 
             * @param fareandPaidTaxes
             */
            public void setFareandPaidTaxes(FareandPaidTaxes fareandPaidTaxes) {
                this.fareandPaidTaxes = fareandPaidTaxes;
            }

            /** 
             * Get the 'Taxes' element value.
             * 
             * @return value
             */
            public Taxes getTaxes() {
                return taxes;
            }

            /** 
             * Set the 'Taxes' element value.
             * 
             * @param taxes
             */
            public void setTaxes(Taxes taxes) {
                this.taxes = taxes;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
             *     &lt;xs:attribute type="xs:string" use="required" name="CurrencyCode"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class BaseFare implements Serializable
            {
                private String amount;
                private String currencyCode;

                /** 
                 * Get the 'Amount' attribute value.
                 * 
                 * @return value
                 */
                public String getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' attribute value.
                 * 
                 * @param amount
                 */
                public void setAmount(String amount) {
                    this.amount = amount;
                }

                /** 
                 * Get the 'CurrencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'CurrencyCode' attribute value.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivFare" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
             *     &lt;xs:attribute type="xs:string" use="required" name="CurrencyCode"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class EquivFare implements Serializable
            {
                private String amount;
                private String currencyCode;

                /** 
                 * Get the 'Amount' attribute value.
                 * 
                 * @return value
                 */
                public String getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' attribute value.
                 * 
                 * @param amount
                 */
                public void setAmount(String amount) {
                    this.amount = amount;
                }

                /** 
                 * Get the 'CurrencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'CurrencyCode' attribute value.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareandPaidTaxes" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="BaseFare" minOccurs="0">
             *         &lt;!-- Reference to inner class BaseFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="EquivFare">
             *         &lt;xs:complexType>
             *           &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
             *           &lt;xs:attribute type="xs:string" use="required" name="CurrencyCode"/>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *       &lt;xs:element name="PaidTaxes" minOccurs="0">
             *         &lt;!-- Reference to inner class PaidTaxes -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class FareandPaidTaxes implements Serializable
            {
                private BaseFare baseFare;
                private String equivFareAmount;
                private String equivFareCurrencyCode;
                private PaidTaxes paidTaxes;

                /** 
                 * Get the 'BaseFare' element value.
                 * 
                 * @return value
                 */
                public BaseFare getBaseFare() {
                    return baseFare;
                }

                /** 
                 * Set the 'BaseFare' element value.
                 * 
                 * @param baseFare
                 */
                public void setBaseFare(BaseFare baseFare) {
                    this.baseFare = baseFare;
                }

                /** 
                 * Get the 'Amount' attribute value.
                 * 
                 * @return value
                 */
                public String getEquivFareAmount() {
                    return equivFareAmount;
                }

                /** 
                 * Set the 'Amount' attribute value.
                 * 
                 * @param equivFareAmount
                 */
                public void setEquivFareAmount(String equivFareAmount) {
                    this.equivFareAmount = equivFareAmount;
                }

                /** 
                 * Get the 'CurrencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getEquivFareCurrencyCode() {
                    return equivFareCurrencyCode;
                }

                /** 
                 * Set the 'CurrencyCode' attribute value.
                 * 
                 * @param equivFareCurrencyCode
                 */
                public void setEquivFareCurrencyCode(
                        String equivFareCurrencyCode) {
                    this.equivFareCurrencyCode = equivFareCurrencyCode;
                }

                /** 
                 * Get the 'PaidTaxes' element value.
                 * 
                 * @return value
                 */
                public PaidTaxes getPaidTaxes() {
                    return paidTaxes;
                }

                /** 
                 * Set the 'PaidTaxes' element value.
                 * 
                 * @param paidTaxes
                 */
                public void setPaidTaxes(PaidTaxes paidTaxes) {
                    this.paidTaxes = paidTaxes;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                 *     &lt;xs:attribute type="xs:string" use="required" name="CurrencyCode"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class BaseFare implements Serializable
                {
                    private String amount;
                    private String currencyCode;

                    /** 
                     * Get the 'Amount' attribute value.
                     * 
                     * @return value
                     */
                    public String getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' attribute value.
                     * 
                     * @param amount
                     */
                    public void setAmount(String amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'CurrencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'CurrencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaidTaxes" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Tax" minOccurs="0" maxOccurs="80">
                 *         &lt;!-- Reference to inner class Tax -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class PaidTaxes implements Serializable
                {
                    private List<Tax> taxList = new ArrayList<Tax>();

                    /** 
                     * Get the list of 'Tax' element items.
                     * 
                     * @return list
                     */
                    public List<Tax> getTaxList() {
                        return taxList;
                    }

                    /** 
                     * Set the list of 'Tax' element items.
                     * 
                     * @param list
                     */
                    public void setTaxList(List<Tax> list) {
                        taxList = list;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" minOccurs="0" maxOccurs="80">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                     *     &lt;xs:attribute type="xs:string" use="required" name="TaxCode"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Tax implements Serializable
                    {
                        private String amount;
                        private String taxCode;

                        /** 
                         * Get the 'Amount' attribute value.
                         * 
                         * @return value
                         */
                        public String getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' attribute value.
                         * 
                         * @param amount
                         */
                        public void setAmount(String amount) {
                            this.amount = amount;
                        }

                        /** 
                         * Get the 'TaxCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getTaxCode() {
                            return taxCode;
                        }

                        /** 
                         * Set the 'TaxCode' attribute value.
                         * 
                         * @param taxCode
                         */
                        public void setTaxCode(String taxCode) {
                            this.taxCode = taxCode;
                        }
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Tax" minOccurs="0" maxOccurs="80">
             *         &lt;!-- Reference to inner class Tax -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Taxes implements Serializable
            {
                private List<Tax> taxList = new ArrayList<Tax>();

                /** 
                 * Get the list of 'Tax' element items.
                 * 
                 * @return list
                 */
                public List<Tax> getTaxList() {
                    return taxList;
                }

                /** 
                 * Set the list of 'Tax' element items.
                 * 
                 * @param list
                 */
                public void setTaxList(List<Tax> list) {
                    taxList = list;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" minOccurs="0" maxOccurs="80">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                 *     &lt;xs:attribute type="xs:string" use="required" name="TaxCode"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Tax implements Serializable
                {
                    private String amount;
                    private String taxCode;

                    /** 
                     * Get the 'Amount' attribute value.
                     * 
                     * @return value
                     */
                    public String getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' attribute value.
                     * 
                     * @param amount
                     */
                    public void setAmount(String amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'TaxCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getTaxCode() {
                        return taxCode;
                    }

                    /** 
                     * Set the 'TaxCode' attribute value.
                     * 
                     * @param taxCode
                     */
                    public void setTaxCode(String taxCode) {
                        this.taxCode = taxCode;
                    }
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LineEntitlements" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Line" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Line -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class LineEntitlements implements Serializable
        {
            private List<Line> lineList = new ArrayList<Line>();

            /** 
             * Get the list of 'Line' element items.
             * 
             * @return list
             */
            public List<Line> getLineList() {
                return lineList;
            }

            /** 
             * Set the list of 'Line' element items.
             * 
             * @param list
             */
            public void setLineList(List<Line> list) {
                lineList = list;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Line" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="BaggageAllowance" minOccurs="0">
             *         &lt;!-- Reference to inner class BaggageAllowance -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="FareBasis" minOccurs="0">
             *         &lt;!-- Reference to inner class FareBasis -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="ItineraryOptions" minOccurs="0">
             *         &lt;!-- Reference to inner class ItineraryOptions -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="ValidityDates" minOccurs="0">
             *         &lt;!-- Reference to inner class ValidityDates -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Line implements Serializable
            {
                private BaggageAllowance baggageAllowance;
                private FareBasis fareBasis;
                private ItineraryOptions itineraryOptions;
                private ValidityDates validityDates;

                /** 
                 * Get the 'BaggageAllowance' element value.
                 * 
                 * @return value
                 */
                public BaggageAllowance getBaggageAllowance() {
                    return baggageAllowance;
                }

                /** 
                 * Set the 'BaggageAllowance' element value.
                 * 
                 * @param baggageAllowance
                 */
                public void setBaggageAllowance(
                        BaggageAllowance baggageAllowance) {
                    this.baggageAllowance = baggageAllowance;
                }

                /** 
                 * Get the 'FareBasis' element value.
                 * 
                 * @return value
                 */
                public FareBasis getFareBasis() {
                    return fareBasis;
                }

                /** 
                 * Set the 'FareBasis' element value.
                 * 
                 * @param fareBasis
                 */
                public void setFareBasis(FareBasis fareBasis) {
                    this.fareBasis = fareBasis;
                }

                /** 
                 * Get the 'ItineraryOptions' element value.
                 * 
                 * @return value
                 */
                public ItineraryOptions getItineraryOptions() {
                    return itineraryOptions;
                }

                /** 
                 * Set the 'ItineraryOptions' element value.
                 * 
                 * @param itineraryOptions
                 */
                public void setItineraryOptions(
                        ItineraryOptions itineraryOptions) {
                    this.itineraryOptions = itineraryOptions;
                }

                /** 
                 * Get the 'ValidityDates' element value.
                 * 
                 * @return value
                 */
                public ValidityDates getValidityDates() {
                    return validityDates;
                }

                /** 
                 * Set the 'ValidityDates' element value.
                 * 
                 * @param validityDates
                 */
                public void setValidityDates(ValidityDates validityDates) {
                    this.validityDates = validityDates;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageAllowance" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Modify"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Number"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Weight"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class BaggageAllowance implements Serializable
                {
                    private Boolean modify;
                    private String number;
                    private String weight;

                    /** 
                     * Get the 'Modify' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getModify() {
                        return modify;
                    }

                    /** 
                     * Set the 'Modify' attribute value.
                     * 
                     * @param modify
                     */
                    public void setModify(Boolean modify) {
                        this.modify = modify;
                    }

                    /** 
                     * Get the 'Number' attribute value.
                     * 
                     * @return value
                     */
                    public String getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'Number' attribute value.
                     * 
                     * @param number
                     */
                    public void setNumber(String number) {
                        this.number = number;
                    }

                    /** 
                     * Get the 'Weight' attribute value.
                     * 
                     * @return value
                     */
                    public String getWeight() {
                        return weight;
                    }

                    /** 
                     * Set the 'Weight' attribute value.
                     * 
                     * @param weight
                     */
                    public void setWeight(String weight) {
                        this.weight = weight;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareBasis" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Modify"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="TicketDesignator"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class FareBasis implements Serializable
                {
                    private String code;
                    private Boolean modify;
                    private String ticketDesignator;

                    /** 
                     * Get the 'Code' attribute value.
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'Code' attribute value.
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }

                    /** 
                     * Get the 'Modify' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getModify() {
                        return modify;
                    }

                    /** 
                     * Set the 'Modify' attribute value.
                     * 
                     * @param modify
                     */
                    public void setModify(Boolean modify) {
                        this.modify = modify;
                    }

                    /** 
                     * Get the 'TicketDesignator' attribute value.
                     * 
                     * @return value
                     */
                    public String getTicketDesignator() {
                        return ticketDesignator;
                    }

                    /** 
                     * Set the 'TicketDesignator' attribute value.
                     * 
                     * @param ticketDesignator
                     */
                    public void setTicketDesignator(String ticketDesignator) {
                        this.ticketDesignator = ticketDesignator;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ItineraryOptions" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="SegmentSelect" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class SegmentSelect -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Modify"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ItineraryOptions implements Serializable
                {
                    private List<SegmentSelect> segmentSelectList = new ArrayList<SegmentSelect>();
                    private Boolean modify;

                    /** 
                     * Get the list of 'SegmentSelect' element items.
                     * 
                     * @return list
                     */
                    public List<SegmentSelect> getSegmentSelectList() {
                        return segmentSelectList;
                    }

                    /** 
                     * Set the list of 'SegmentSelect' element items.
                     * 
                     * @param list
                     */
                    public void setSegmentSelectList(List<SegmentSelect> list) {
                        segmentSelectList = list;
                    }

                    /** 
                     * Get the 'Modify' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getModify() {
                        return modify;
                    }

                    /** 
                     * Set the 'Modify' attribute value.
                     * 
                     * @param modify
                     */
                    public void setModify(Boolean modify) {
                        this.modify = modify;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SegmentSelect" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="ConnectionInd"/>
                     *     &lt;xs:attribute type="xs:integer" use="optional" name="Number"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class SegmentSelect implements Serializable
                    {
                        private String connectionInd;
                        private BigInteger number;

                        /** 
                         * Get the 'ConnectionInd' attribute value.
                         * 
                         * @return value
                         */
                        public String getConnectionInd() {
                            return connectionInd;
                        }

                        /** 
                         * Set the 'ConnectionInd' attribute value.
                         * 
                         * @param connectionInd
                         */
                        public void setConnectionInd(String connectionInd) {
                            this.connectionInd = connectionInd;
                        }

                        /** 
                         * Get the 'Number' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getNumber() {
                            return number;
                        }

                        /** 
                         * Set the 'Number' attribute value.
                         * 
                         * @param number
                         */
                        public void setNumber(BigInteger number) {
                            this.number = number;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ValidityDates" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="NotValidAfter" minOccurs="0">
                 *         &lt;!-- Reference to inner class NotValidAfter -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="NotValidBefore" minOccurs="0">
                 *         &lt;!-- Reference to inner class NotValidBefore -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ValidityDates implements Serializable
                {
                    private NotValidAfter notValidAfter;
                    private NotValidBefore notValidBefore;

                    /** 
                     * Get the 'NotValidAfter' element value.
                     * 
                     * @return value
                     */
                    public NotValidAfter getNotValidAfter() {
                        return notValidAfter;
                    }

                    /** 
                     * Set the 'NotValidAfter' element value.
                     * 
                     * @param notValidAfter
                     */
                    public void setNotValidAfter(NotValidAfter notValidAfter) {
                        this.notValidAfter = notValidAfter;
                    }

                    /** 
                     * Get the 'NotValidBefore' element value.
                     * 
                     * @return value
                     */
                    public NotValidBefore getNotValidBefore() {
                        return notValidBefore;
                    }

                    /** 
                     * Set the 'NotValidBefore' element value.
                     * 
                     * @param notValidBefore
                     */
                    public void setNotValidBefore(NotValidBefore notValidBefore) {
                        this.notValidBefore = notValidBefore;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NotValidAfter" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Date"/>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="Modify"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class NotValidAfter implements Serializable
                    {
                        private String date;
                        private Boolean modify;

                        /** 
                         * Get the 'Date' attribute value.
                         * 
                         * @return value
                         */
                        public String getDate() {
                            return date;
                        }

                        /** 
                         * Set the 'Date' attribute value.
                         * 
                         * @param date
                         */
                        public void setDate(String date) {
                            this.date = date;
                        }

                        /** 
                         * Get the 'Modify' attribute value.
                         * 
                         * @return value
                         */
                        public Boolean getModify() {
                            return modify;
                        }

                        /** 
                         * Set the 'Modify' attribute value.
                         * 
                         * @param modify
                         */
                        public void setModify(Boolean modify) {
                            this.modify = modify;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NotValidBefore" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Date"/>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="Modify"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class NotValidBefore implements Serializable
                    {
                        private String date;
                        private Boolean modify;

                        /** 
                         * Get the 'Date' attribute value.
                         * 
                         * @return value
                         */
                        public String getDate() {
                            return date;
                        }

                        /** 
                         * Set the 'Date' attribute value.
                         * 
                         * @param date
                         */
                        public void setDate(String date) {
                            this.date = date;
                        }

                        /** 
                         * Get the 'Modify' attribute value.
                         * 
                         * @return value
                         */
                        public Boolean getModify() {
                            return modify;
                        }

                        /** 
                         * Set the 'Modify' attribute value.
                         * 
                         * @param modify
                         */
                        public void setModify(Boolean modify) {
                            this.modify = modify;
                        }
                    }
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NetRemit" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="BaseFare" minOccurs="0">
         *         &lt;!-- Reference to inner class BaseFare -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="Value" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class NetRemit implements Serializable
        {
            private BaseFare baseFare;
            private String value;

            /** 
             * Get the 'BaseFare' element value.
             * 
             * @return value
             */
            public BaseFare getBaseFare() {
                return baseFare;
            }

            /** 
             * Set the 'BaseFare' element value.
             * 
             * @param baseFare
             */
            public void setBaseFare(BaseFare baseFare) {
                this.baseFare = baseFare;
            }

            /** 
             * Get the 'Value' element value.
             * 
             * @return value
             */
            public String getValue() {
                return value;
            }

            /** 
             * Set the 'Value' element value.
             * 
             * @param value
             */
            public void setValue(String value) {
                this.value = value;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
             *     &lt;xs:attribute type="xs:string" use="required" name="CurrencyCode"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class BaseFare implements Serializable
            {
                private String amount;
                private String currencyCode;

                /** 
                 * Get the 'Amount' attribute value.
                 * 
                 * @return value
                 */
                public String getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' attribute value.
                 * 
                 * @param amount
                 */
                public void setAmount(String amount) {
                    this.amount = amount;
                }

                /** 
                 * Get the 'CurrencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'CurrencyCode' attribute value.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TourCode" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="Text"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="SuppressFareAmount"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="SuppressIT"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="InclusiveTour"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class TourCode implements Serializable
        {
            private String text;
            private Boolean suppressFareAmount;
            private Boolean suppressIT;
            private Boolean inclusiveTour;

            /** 
             * Get the 'Text' element value.
             * 
             * @return value
             */
            public String getText() {
                return text;
            }

            /** 
             * Set the 'Text' element value.
             * 
             * @param text
             */
            public void setText(String text) {
                this.text = text;
            }

            /** 
             * Get the 'SuppressFareAmount' attribute value.
             * 
             * @return value
             */
            public Boolean getSuppressFareAmount() {
                return suppressFareAmount;
            }

            /** 
             * Set the 'SuppressFareAmount' attribute value.
             * 
             * @param suppressFareAmount
             */
            public void setSuppressFareAmount(Boolean suppressFareAmount) {
                this.suppressFareAmount = suppressFareAmount;
            }

            /** 
             * Get the 'SuppressIT' attribute value.
             * 
             * @return value
             */
            public Boolean getSuppressIT() {
                return suppressIT;
            }

            /** 
             * Set the 'SuppressIT' attribute value.
             * 
             * @param suppressIT
             */
            public void setSuppressIT(Boolean suppressIT) {
                this.suppressIT = suppressIT;
            }

            /** 
             * Get the 'InclusiveTour' attribute value.
             * 
             * @return value
             */
            public Boolean getInclusiveTour() {
                return inclusiveTour;
            }

            /** 
             * Set the 'InclusiveTour' attribute value.
             * 
             * @param inclusiveTour
             */
            public void setInclusiveTour(Boolean inclusiveTour) {
                this.inclusiveTour = inclusiveTour;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CreationDetails" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="ItineraryOptions" minOccurs="0">
     *         &lt;!-- Reference to inner class ItineraryOptions -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:string" name="PassengerType" minOccurs="0" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class CreationDetails implements Serializable
    {
        private ItineraryOptions itineraryOptions;
        private List<String> passengerTypeList = new ArrayList<String>();

        /** 
         * Get the 'ItineraryOptions' element value.
         * 
         * @return value
         */
        public ItineraryOptions getItineraryOptions() {
            return itineraryOptions;
        }

        /** 
         * Set the 'ItineraryOptions' element value.
         * 
         * @param itineraryOptions
         */
        public void setItineraryOptions(ItineraryOptions itineraryOptions) {
            this.itineraryOptions = itineraryOptions;
        }

        /** 
         * Get the list of 'PassengerType' element items.
         * 
         * @return list
         */
        public List<String> getPassengerTypeList() {
            return passengerTypeList;
        }

        /** 
         * Set the list of 'PassengerType' element items.
         * 
         * @param list
         */
        public void setPassengerTypeList(List<String> list) {
            passengerTypeList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ItineraryOptions" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="SegmentSelect" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class SegmentSelect -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ItineraryOptions implements Serializable
        {
            private List<SegmentSelect> segmentSelectList = new ArrayList<SegmentSelect>();

            /** 
             * Get the list of 'SegmentSelect' element items.
             * 
             * @return list
             */
            public List<SegmentSelect> getSegmentSelectList() {
                return segmentSelectList;
            }

            /** 
             * Set the list of 'SegmentSelect' element items.
             * 
             * @param list
             */
            public void setSegmentSelectList(List<SegmentSelect> list) {
                segmentSelectList = list;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SegmentSelect" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class SegmentSelect implements Serializable
            {
                private BigInteger number;

                /** 
                 * Get the 'Number' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getNumber() {
                    return number;
                }

                /** 
                 * Set the 'Number' attribute value.
                 * 
                 * @param number
                 */
                public void setNumber(BigInteger number) {
                    this.number = number;
                }
            }
        }
    }
}
