
package com.sabre.webservices.sabrexml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OTA_AirAvailRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="OptionalQualifiers" minOccurs="0">
 *         &lt;!-- Reference to inner class OptionalQualifiers -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="OriginDestinationInformation" minOccurs="0">
 *         &lt;!-- Reference to inner class OriginDestinationInformation -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:boolean" use="optional" name="ReturnHostCommand"/>
 *     &lt;xs:attribute type="xs:dateTime" use="optional" name="TimeStamp"/>
 *     &lt;xs:attribute type="xs:string" use="required" fixed="2.4.0" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class OTAAirAvailRQ implements Serializable
{
    private OptionalQualifiers optionalQualifiers;
    private OriginDestinationInformation originDestinationInformation;
    private Boolean returnHostCommand;
    private Date timeStamp;
    private String version;

    /** 
     * Get the 'OptionalQualifiers' element value.
     * 
     * @return value
     */
    public OptionalQualifiers getOptionalQualifiers() {
        return optionalQualifiers;
    }

    /** 
     * Set the 'OptionalQualifiers' element value.
     * 
     * @param optionalQualifiers
     */
    public void setOptionalQualifiers(OptionalQualifiers optionalQualifiers) {
        this.optionalQualifiers = optionalQualifiers;
    }

    /** 
     * Get the 'OriginDestinationInformation' element value.
     * 
     * @return value
     */
    public OriginDestinationInformation getOriginDestinationInformation() {
        return originDestinationInformation;
    }

    /** 
     * Set the 'OriginDestinationInformation' element value.
     * 
     * @param originDestinationInformation
     */
    public void setOriginDestinationInformation(
            OriginDestinationInformation originDestinationInformation) {
        this.originDestinationInformation = originDestinationInformation;
    }

    /** 
     * Get the 'ReturnHostCommand' attribute value.
     * 
     * @return value
     */
    public Boolean getReturnHostCommand() {
        return returnHostCommand;
    }

    /** 
     * Set the 'ReturnHostCommand' attribute value.
     * 
     * @param returnHostCommand
     */
    public void setReturnHostCommand(Boolean returnHostCommand) {
        this.returnHostCommand = returnHostCommand;
    }

    /** 
     * Get the 'TimeStamp' attribute value.
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value.
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OptionalQualifiers" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="AdditionalAvailability" minOccurs="0">
     *         &lt;!-- Reference to inner class AdditionalAvailability -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FlightQualifiers" minOccurs="0">
     *         &lt;!-- Reference to inner class FlightQualifiers -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="TimeQualifiers" minOccurs="0">
     *         &lt;!-- Reference to inner class TimeQualifiers -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OptionalQualifiers implements Serializable
    {
        private AdditionalAvailability additionalAvailability;
        private FlightQualifiers flightQualifiers;
        private TimeQualifiers timeQualifiers;

        /** 
         * Get the 'AdditionalAvailability' element value.
         * 
         * @return value
         */
        public AdditionalAvailability getAdditionalAvailability() {
            return additionalAvailability;
        }

        /** 
         * Set the 'AdditionalAvailability' element value.
         * 
         * @param additionalAvailability
         */
        public void setAdditionalAvailability(
                AdditionalAvailability additionalAvailability) {
            this.additionalAvailability = additionalAvailability;
        }

        /** 
         * Get the 'FlightQualifiers' element value.
         * 
         * @return value
         */
        public FlightQualifiers getFlightQualifiers() {
            return flightQualifiers;
        }

        /** 
         * Set the 'FlightQualifiers' element value.
         * 
         * @param flightQualifiers
         */
        public void setFlightQualifiers(FlightQualifiers flightQualifiers) {
            this.flightQualifiers = flightQualifiers;
        }

        /** 
         * Get the 'TimeQualifiers' element value.
         * 
         * @return value
         */
        public TimeQualifiers getTimeQualifiers() {
            return timeQualifiers;
        }

        /** 
         * Set the 'TimeQualifiers' element value.
         * 
         * @param timeQualifiers
         */
        public void setTimeQualifiers(TimeQualifiers timeQualifiers) {
            this.timeQualifiers = timeQualifiers;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AdditionalAvailability" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="AirExtras"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="DirectAccess"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="Ind"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="MoveDown"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AdditionalAvailability implements Serializable
        {
            private String airExtras;
            private Boolean directAccess;
            private Boolean ind;
            private Boolean moveDown;

            /** 
             * Get the 'AirExtras' attribute value.
             * 
             * @return value
             */
            public String getAirExtras() {
                return airExtras;
            }

            /** 
             * Set the 'AirExtras' attribute value.
             * 
             * @param airExtras
             */
            public void setAirExtras(String airExtras) {
                this.airExtras = airExtras;
            }

            /** 
             * Get the 'DirectAccess' attribute value.
             * 
             * @return value
             */
            public Boolean getDirectAccess() {
                return directAccess;
            }

            /** 
             * Set the 'DirectAccess' attribute value.
             * 
             * @param directAccess
             */
            public void setDirectAccess(Boolean directAccess) {
                this.directAccess = directAccess;
            }

            /** 
             * Get the 'Ind' attribute value.
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value.
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }

            /** 
             * Get the 'MoveDown' attribute value.
             * 
             * @return value
             */
            public Boolean getMoveDown() {
                return moveDown;
            }

            /** 
             * Set the 'MoveDown' attribute value.
             * 
             * @param moveDown
             */
            public void setMoveDown(Boolean moveDown) {
                this.moveDown = moveDown;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightQualifiers" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="AlliancePartner" minOccurs="0">
         *         &lt;!-- Reference to inner class AlliancePartner -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Cabin" minOccurs="0">
         *         &lt;!-- Reference to inner class Cabin -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="VendorPrefs" minOccurs="0">
         *         &lt;!-- Reference to inner class VendorPrefs -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="Charters"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="DirectOnly"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="ExcludeCodeshares"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="OnlineOnly"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="Scan"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FlightQualifiers implements Serializable
        {
            private AlliancePartner alliancePartner;
            private Cabin cabin;
            private VendorPrefs vendorPrefs;
            private Boolean charters;
            private Boolean directOnly;
            private Boolean excludeCodeshares;
            private Boolean onlineOnly;
            private Boolean scan;

            /** 
             * Get the 'AlliancePartner' element value.
             * 
             * @return value
             */
            public AlliancePartner getAlliancePartner() {
                return alliancePartner;
            }

            /** 
             * Set the 'AlliancePartner' element value.
             * 
             * @param alliancePartner
             */
            public void setAlliancePartner(AlliancePartner alliancePartner) {
                this.alliancePartner = alliancePartner;
            }

            /** 
             * Get the 'Cabin' element value.
             * 
             * @return value
             */
            public Cabin getCabin() {
                return cabin;
            }

            /** 
             * Set the 'Cabin' element value.
             * 
             * @param cabin
             */
            public void setCabin(Cabin cabin) {
                this.cabin = cabin;
            }

            /** 
             * Get the 'VendorPrefs' element value.
             * 
             * @return value
             */
            public VendorPrefs getVendorPrefs() {
                return vendorPrefs;
            }

            /** 
             * Set the 'VendorPrefs' element value.
             * 
             * @param vendorPrefs
             */
            public void setVendorPrefs(VendorPrefs vendorPrefs) {
                this.vendorPrefs = vendorPrefs;
            }

            /** 
             * Get the 'Charters' attribute value.
             * 
             * @return value
             */
            public Boolean getCharters() {
                return charters;
            }

            /** 
             * Set the 'Charters' attribute value.
             * 
             * @param charters
             */
            public void setCharters(Boolean charters) {
                this.charters = charters;
            }

            /** 
             * Get the 'DirectOnly' attribute value.
             * 
             * @return value
             */
            public Boolean getDirectOnly() {
                return directOnly;
            }

            /** 
             * Set the 'DirectOnly' attribute value.
             * 
             * @param directOnly
             */
            public void setDirectOnly(Boolean directOnly) {
                this.directOnly = directOnly;
            }

            /** 
             * Get the 'ExcludeCodeshares' attribute value.
             * 
             * @return value
             */
            public Boolean getExcludeCodeshares() {
                return excludeCodeshares;
            }

            /** 
             * Set the 'ExcludeCodeshares' attribute value.
             * 
             * @param excludeCodeshares
             */
            public void setExcludeCodeshares(Boolean excludeCodeshares) {
                this.excludeCodeshares = excludeCodeshares;
            }

            /** 
             * Get the 'OnlineOnly' attribute value.
             * 
             * @return value
             */
            public Boolean getOnlineOnly() {
                return onlineOnly;
            }

            /** 
             * Set the 'OnlineOnly' attribute value.
             * 
             * @param onlineOnly
             */
            public void setOnlineOnly(Boolean onlineOnly) {
                this.onlineOnly = onlineOnly;
            }

            /** 
             * Get the 'Scan' attribute value.
             * 
             * @return value
             */
            public Boolean getScan() {
                return scan;
            }

            /** 
             * Set the 'Scan' attribute value.
             * 
             * @param scan
             */
            public void setScan(Boolean scan) {
                this.scan = scan;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AlliancePartner" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Group"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AlliancePartner implements Serializable
            {
                private String group;

                /** 
                 * Get the 'Group' element value.
                 * 
                 * @return value
                 */
                public String getGroup() {
                    return group;
                }

                /** 
                 * Set the 'Group' element value.
                 * 
                 * @param group
                 */
                public void setGroup(String group) {
                    this.group = group;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Cabin" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Designator" maxOccurs="unbounded"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="Exclude"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Cabin implements Serializable
            {
                private List<String> designatorList = new ArrayList<String>();
                private Boolean exclude;

                /** 
                 * Get the list of 'Designator' element items.
                 * 
                 * @return list
                 */
                public List<String> getDesignatorList() {
                    return designatorList;
                }

                /** 
                 * Set the list of 'Designator' element items.
                 * 
                 * @param list
                 */
                public void setDesignatorList(List<String> list) {
                    designatorList = list;
                }

                /** 
                 * Get the 'Exclude' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getExclude() {
                    return exclude;
                }

                /** 
                 * Set the 'Exclude' attribute value.
                 * 
                 * @param exclude
                 */
                public void setExclude(Boolean exclude) {
                    this.exclude = exclude;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VendorPrefs" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Airline" minOccurs="0" maxOccurs="20">
             *         &lt;!-- Reference to inner class Airline -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="DirectAccess"/>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="Exclude"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class VendorPrefs implements Serializable
            {
                private List<Airline> airlineList = new ArrayList<Airline>();
                private Boolean directAccess;
                private Boolean exclude;

                /** 
                 * Get the list of 'Airline' element items.
                 * 
                 * @return list
                 */
                public List<Airline> getAirlineList() {
                    return airlineList;
                }

                /** 
                 * Set the list of 'Airline' element items.
                 * 
                 * @param list
                 */
                public void setAirlineList(List<Airline> list) {
                    airlineList = list;
                }

                /** 
                 * Get the 'DirectAccess' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getDirectAccess() {
                    return directAccess;
                }

                /** 
                 * Set the 'DirectAccess' attribute value.
                 * 
                 * @param directAccess
                 */
                public void setDirectAccess(Boolean directAccess) {
                    this.directAccess = directAccess;
                }

                /** 
                 * Get the 'Exclude' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getExclude() {
                    return exclude;
                }

                /** 
                 * Set the 'Exclude' attribute value.
                 * 
                 * @param exclude
                 */
                public void setExclude(Boolean exclude) {
                    this.exclude = exclude;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Airline" minOccurs="0" maxOccurs="20">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Airline implements Serializable
                {
                    private String code;

                    /** 
                     * Get the 'Code' attribute value.
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'Code' attribute value.
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TimeQualifiers" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="ArrivalTime" minOccurs="0">
         *         &lt;!-- Reference to inner class ArrivalTime -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="DepartureTime" minOccurs="0">
         *         &lt;!-- Reference to inner class DepartureTime -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class TimeQualifiers implements Serializable
        {
            private ArrivalTime arrivalTime;
            private DepartureTime departureTime;

            /** 
             * Get the 'ArrivalTime' element value.
             * 
             * @return value
             */
            public ArrivalTime getArrivalTime() {
                return arrivalTime;
            }

            /** 
             * Set the 'ArrivalTime' element value.
             * 
             * @param arrivalTime
             */
            public void setArrivalTime(ArrivalTime arrivalTime) {
                this.arrivalTime = arrivalTime;
            }

            /** 
             * Get the 'DepartureTime' element value.
             * 
             * @return value
             */
            public DepartureTime getDepartureTime() {
                return departureTime;
            }

            /** 
             * Set the 'DepartureTime' element value.
             * 
             * @param departureTime
             */
            public void setDepartureTime(DepartureTime departureTime) {
                this.departureTime = departureTime;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ArrivalTime" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="WindowAfter"/>
             *     &lt;xs:attribute type="xs:string" use="required" name="WindowBefore"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ArrivalTime implements Serializable
            {
                private String windowAfter;
                private String windowBefore;

                /** 
                 * Get the 'WindowAfter' attribute value.
                 * 
                 * @return value
                 */
                public String getWindowAfter() {
                    return windowAfter;
                }

                /** 
                 * Set the 'WindowAfter' attribute value.
                 * 
                 * @param windowAfter
                 */
                public void setWindowAfter(String windowAfter) {
                    this.windowAfter = windowAfter;
                }

                /** 
                 * Get the 'WindowBefore' attribute value.
                 * 
                 * @return value
                 */
                public String getWindowBefore() {
                    return windowBefore;
                }

                /** 
                 * Set the 'WindowBefore' attribute value.
                 * 
                 * @param windowBefore
                 */
                public void setWindowBefore(String windowBefore) {
                    this.windowBefore = windowBefore;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DepartureTime" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="WindowBefore"/>
             *     &lt;xs:attribute type="xs:string" use="required" name="WindowAfter"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class DepartureTime implements Serializable
            {
                private String windowBefore;
                private String windowAfter;

                /** 
                 * Get the 'WindowBefore' attribute value.
                 * 
                 * @return value
                 */
                public String getWindowBefore() {
                    return windowBefore;
                }

                /** 
                 * Set the 'WindowBefore' attribute value.
                 * 
                 * @param windowBefore
                 */
                public void setWindowBefore(String windowBefore) {
                    this.windowBefore = windowBefore;
                }

                /** 
                 * Get the 'WindowAfter' attribute value.
                 * 
                 * @return value
                 */
                public String getWindowAfter() {
                    return windowAfter;
                }

                /** 
                 * Set the 'WindowAfter' attribute value.
                 * 
                 * @param windowAfter
                 */
                public void setWindowAfter(String windowAfter) {
                    this.windowAfter = windowAfter;
                }
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestinationInformation" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="FlightSegment">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element name="ConnectionLocations" minOccurs="0">
     *               &lt;!-- Reference to inner class ConnectionLocations -->
     *             &lt;/xs:element>
     *             &lt;xs:element name="DestinationLocation">
     *               &lt;xs:complexType>
     *                 &lt;xs:attribute type="xs:string" use="required" name="LocationCode"/>
     *               &lt;/xs:complexType>
     *             &lt;/xs:element>
     *             &lt;xs:element name="OriginLocation">
     *               &lt;xs:complexType>
     *                 &lt;xs:attribute type="xs:string" use="required" name="LocationCode"/>
     *               &lt;/xs:complexType>
     *             &lt;/xs:element>
     *           &lt;/xs:sequence>
     *           &lt;xs:attribute type="xs:string" use="optional" name="ArrivalDateTime"/>
     *           &lt;xs:attribute type="xs:string" use="optional" name="DepartureDateTime"/>
     *           &lt;xs:attribute type="xs:string" use="optional" name="FlightNumber"/>
     *           &lt;xs:attribute type="xs:string" use="optional" name="NumberInParty"/>
     *           &lt;xs:attribute type="xs:string" use="optional" name="ResBookDesigCode"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OriginDestinationInformation implements Serializable
    {
        private ConnectionLocations connectionLocations;
        private String flightSegmentDestinationLocation;
        private String flightSegmentOriginLocation;
        private String flightSegmentArrivalDateTime;
        private String flightSegmentDepartureDateTime;
        private String flightSegmentFlightNumber;
        private String flightSegmentNumberInParty;
        private String flightSegmentResBookDesigCode;

        /** 
         * Get the 'ConnectionLocations' element value.
         * 
         * @return value
         */
        public ConnectionLocations getConnectionLocations() {
            return connectionLocations;
        }

        /** 
         * Set the 'ConnectionLocations' element value.
         * 
         * @param connectionLocations
         */
        public void setConnectionLocations(
                ConnectionLocations connectionLocations) {
            this.connectionLocations = connectionLocations;
        }

        /** 
         * Get the 'LocationCode' attribute value.
         * 
         * @return value
         */
        public String getFlightSegmentDestinationLocation() {
            return flightSegmentDestinationLocation;
        }

        /** 
         * Set the 'LocationCode' attribute value.
         * 
         * @param flightSegmentDestinationLocation
         */
        public void setFlightSegmentDestinationLocation(
                String flightSegmentDestinationLocation) {
            this.flightSegmentDestinationLocation = flightSegmentDestinationLocation;
        }

        /** 
         * Get the 'LocationCode' attribute value.
         * 
         * @return value
         */
        public String getFlightSegmentOriginLocation() {
            return flightSegmentOriginLocation;
        }

        /** 
         * Set the 'LocationCode' attribute value.
         * 
         * @param flightSegmentOriginLocation
         */
        public void setFlightSegmentOriginLocation(
                String flightSegmentOriginLocation) {
            this.flightSegmentOriginLocation = flightSegmentOriginLocation;
        }

        /** 
         * Get the 'ArrivalDateTime' attribute value.
         * 
         * @return value
         */
        public String getFlightSegmentArrivalDateTime() {
            return flightSegmentArrivalDateTime;
        }

        /** 
         * Set the 'ArrivalDateTime' attribute value.
         * 
         * @param flightSegmentArrivalDateTime
         */
        public void setFlightSegmentArrivalDateTime(
                String flightSegmentArrivalDateTime) {
            this.flightSegmentArrivalDateTime = flightSegmentArrivalDateTime;
        }

        /** 
         * Get the 'DepartureDateTime' attribute value.
         * 
         * @return value
         */
        public String getFlightSegmentDepartureDateTime() {
            return flightSegmentDepartureDateTime;
        }

        /** 
         * Set the 'DepartureDateTime' attribute value.
         * 
         * @param flightSegmentDepartureDateTime
         */
        public void setFlightSegmentDepartureDateTime(
                String flightSegmentDepartureDateTime) {
            this.flightSegmentDepartureDateTime = flightSegmentDepartureDateTime;
        }

        /** 
         * Get the 'FlightNumber' attribute value.
         * 
         * @return value
         */
        public String getFlightSegmentFlightNumber() {
            return flightSegmentFlightNumber;
        }

        /** 
         * Set the 'FlightNumber' attribute value.
         * 
         * @param flightSegmentFlightNumber
         */
        public void setFlightSegmentFlightNumber(
                String flightSegmentFlightNumber) {
            this.flightSegmentFlightNumber = flightSegmentFlightNumber;
        }

        /** 
         * Get the 'NumberInParty' attribute value.
         * 
         * @return value
         */
        public String getFlightSegmentNumberInParty() {
            return flightSegmentNumberInParty;
        }

        /** 
         * Set the 'NumberInParty' attribute value.
         * 
         * @param flightSegmentNumberInParty
         */
        public void setFlightSegmentNumberInParty(
                String flightSegmentNumberInParty) {
            this.flightSegmentNumberInParty = flightSegmentNumberInParty;
        }

        /** 
         * Get the 'ResBookDesigCode' attribute value.
         * 
         * @return value
         */
        public String getFlightSegmentResBookDesigCode() {
            return flightSegmentResBookDesigCode;
        }

        /** 
         * Set the 'ResBookDesigCode' attribute value.
         * 
         * @param flightSegmentResBookDesigCode
         */
        public void setFlightSegmentResBookDesigCode(
                String flightSegmentResBookDesigCode) {
            this.flightSegmentResBookDesigCode = flightSegmentResBookDesigCode;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ConnectionLocations" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="CarrierSpecificDisplay" minOccurs="0">
         *         &lt;!-- Reference to inner class CarrierSpecificDisplay -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="ConnectionLocation" maxOccurs="2">
         *         &lt;!-- Reference to inner class ConnectionLocation -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ConnectionLocations implements Serializable
        {
            private CarrierSpecificDisplay carrierSpecificDisplay;
            private List<ConnectionLocation> connectionLocationList = new ArrayList<ConnectionLocation>();

            /** 
             * Get the 'CarrierSpecificDisplay' element value.
             * 
             * @return value
             */
            public CarrierSpecificDisplay getCarrierSpecificDisplay() {
                return carrierSpecificDisplay;
            }

            /** 
             * Set the 'CarrierSpecificDisplay' element value.
             * 
             * @param carrierSpecificDisplay
             */
            public void setCarrierSpecificDisplay(
                    CarrierSpecificDisplay carrierSpecificDisplay) {
                this.carrierSpecificDisplay = carrierSpecificDisplay;
            }

            /** 
             * Get the list of 'ConnectionLocation' element items.
             * 
             * @return list
             */
            public List<ConnectionLocation> getConnectionLocationList() {
                return connectionLocationList;
            }

            /** 
             * Set the list of 'ConnectionLocation' element items.
             * 
             * @param list
             */
            public void setConnectionLocationList(List<ConnectionLocation> list) {
                connectionLocationList = list;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CarrierSpecificDisplay" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="LegOne">
             *         &lt;xs:complexType>
             *           &lt;xs:sequence>
             *             &lt;xs:element name="VendorPrefs">
             *               &lt;xs:complexType>
             *                 &lt;xs:sequence>
             *                   &lt;xs:element name="Airline" minOccurs="0" maxOccurs="20">
             *                     &lt;!-- Reference to inner class Airline -->
             *                   &lt;/xs:element>
             *                 &lt;/xs:sequence>
             *                 &lt;xs:attribute type="xs:boolean" use="optional" name="Exclude"/>
             *                 &lt;xs:attribute type="xs:boolean" use="optional" name="ExcludeCodeshares"/>
             *                 &lt;xs:attribute type="xs:boolean" use="optional" name="Any"/>
             *               &lt;/xs:complexType>
             *             &lt;/xs:element>
             *           &lt;/xs:sequence>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *       &lt;xs:element name="LegThree" minOccurs="0">
             *         &lt;!-- Reference to inner class LegThree -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="LegTwo">
             *         &lt;xs:complexType>
             *           &lt;xs:sequence>
             *             &lt;xs:element name="VendorPrefs">
             *               &lt;xs:complexType>
             *                 &lt;xs:sequence>
             *                   &lt;xs:element name="Airline" minOccurs="0" maxOccurs="20">
             *                     &lt;!-- Reference to inner class Airline1 -->
             *                   &lt;/xs:element>
             *                 &lt;/xs:sequence>
             *                 &lt;xs:attribute type="xs:boolean" use="optional" name="Exclude"/>
             *                 &lt;xs:attribute type="xs:boolean" use="optional" name="ExcludeCodeshares"/>
             *                 &lt;xs:attribute type="xs:boolean" use="optional" name="Any"/>
             *               &lt;/xs:complexType>
             *             &lt;/xs:element>
             *           &lt;/xs:sequence>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class CarrierSpecificDisplay implements Serializable
            {
                private List<Airline> airlineList = new ArrayList<Airline>();
                private Boolean legOneVendorPrefsExclude;
                private Boolean legOneVendorPrefsExcludeCodeshares;
                private Boolean legOneVendorPrefsAny;
                private LegThree legThree;
                private List<Airline1> airlineList1s = new ArrayList<Airline1>();
                private Boolean legTwoVendorPrefsExclude;
                private Boolean legTwoVendorPrefsExcludeCodeshares;
                private Boolean legTwoVendorPrefsAny;

                /** 
                 * Get the list of 'Airline' element items.
                 * 
                 * @return list
                 */
                public List<Airline> getAirlineList() {
                    return airlineList;
                }

                /** 
                 * Set the list of 'Airline' element items.
                 * 
                 * @param list
                 */
                public void setAirlineList(List<Airline> list) {
                    airlineList = list;
                }

                /** 
                 * Get the 'Exclude' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getLegOneVendorPrefsExclude() {
                    return legOneVendorPrefsExclude;
                }

                /** 
                 * Set the 'Exclude' attribute value.
                 * 
                 * @param legOneVendorPrefsExclude
                 */
                public void setLegOneVendorPrefsExclude(
                        Boolean legOneVendorPrefsExclude) {
                    this.legOneVendorPrefsExclude = legOneVendorPrefsExclude;
                }

                /** 
                 * Get the 'ExcludeCodeshares' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getLegOneVendorPrefsExcludeCodeshares() {
                    return legOneVendorPrefsExcludeCodeshares;
                }

                /** 
                 * Set the 'ExcludeCodeshares' attribute value.
                 * 
                 * @param legOneVendorPrefsExcludeCodeshares
                 */
                public void setLegOneVendorPrefsExcludeCodeshares(
                        Boolean legOneVendorPrefsExcludeCodeshares) {
                    this.legOneVendorPrefsExcludeCodeshares = legOneVendorPrefsExcludeCodeshares;
                }

                /** 
                 * Get the 'Any' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getLegOneVendorPrefsAny() {
                    return legOneVendorPrefsAny;
                }

                /** 
                 * Set the 'Any' attribute value.
                 * 
                 * @param legOneVendorPrefsAny
                 */
                public void setLegOneVendorPrefsAny(Boolean legOneVendorPrefsAny) {
                    this.legOneVendorPrefsAny = legOneVendorPrefsAny;
                }

                /** 
                 * Get the 'LegThree' element value.
                 * 
                 * @return value
                 */
                public LegThree getLegThree() {
                    return legThree;
                }

                /** 
                 * Set the 'LegThree' element value.
                 * 
                 * @param legThree
                 */
                public void setLegThree(LegThree legThree) {
                    this.legThree = legThree;
                }

                /** 
                 * Get the list of 'Airline' element items.
                 * 
                 * @return list
                 */
                public List<Airline1> getAirlineList1s() {
                    return airlineList1s;
                }

                /** 
                 * Set the list of 'Airline' element items.
                 * 
                 * @param list
                 */
                public void setAirlineList1s(List<Airline1> list) {
                    airlineList1s = list;
                }

                /** 
                 * Get the 'Exclude' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getLegTwoVendorPrefsExclude() {
                    return legTwoVendorPrefsExclude;
                }

                /** 
                 * Set the 'Exclude' attribute value.
                 * 
                 * @param legTwoVendorPrefsExclude
                 */
                public void setLegTwoVendorPrefsExclude(
                        Boolean legTwoVendorPrefsExclude) {
                    this.legTwoVendorPrefsExclude = legTwoVendorPrefsExclude;
                }

                /** 
                 * Get the 'ExcludeCodeshares' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getLegTwoVendorPrefsExcludeCodeshares() {
                    return legTwoVendorPrefsExcludeCodeshares;
                }

                /** 
                 * Set the 'ExcludeCodeshares' attribute value.
                 * 
                 * @param legTwoVendorPrefsExcludeCodeshares
                 */
                public void setLegTwoVendorPrefsExcludeCodeshares(
                        Boolean legTwoVendorPrefsExcludeCodeshares) {
                    this.legTwoVendorPrefsExcludeCodeshares = legTwoVendorPrefsExcludeCodeshares;
                }

                /** 
                 * Get the 'Any' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getLegTwoVendorPrefsAny() {
                    return legTwoVendorPrefsAny;
                }

                /** 
                 * Set the 'Any' attribute value.
                 * 
                 * @param legTwoVendorPrefsAny
                 */
                public void setLegTwoVendorPrefsAny(Boolean legTwoVendorPrefsAny) {
                    this.legTwoVendorPrefsAny = legTwoVendorPrefsAny;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Airline" minOccurs="0" maxOccurs="20">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Airline implements Serializable
                {
                    private String code;

                    /** 
                     * Get the 'Code' attribute value.
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'Code' attribute value.
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LegThree" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="VendorPrefs">
                 *         &lt;xs:complexType>
                 *           &lt;xs:sequence>
                 *             &lt;xs:element name="Airline" minOccurs="0" maxOccurs="20">
                 *               &lt;!-- Reference to inner class Airline -->
                 *             &lt;/xs:element>
                 *           &lt;/xs:sequence>
                 *           &lt;xs:attribute type="xs:boolean" use="optional" name="Exclude"/>
                 *           &lt;xs:attribute type="xs:boolean" use="optional" name="ExcludeCodeshares"/>
                 *           &lt;xs:attribute type="xs:boolean" use="optional" name="Any"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class LegThree implements Serializable
                {
                    private List<Airline> airlineList = new ArrayList<Airline>();
                    private Boolean vendorPrefsExclude;
                    private Boolean vendorPrefsExcludeCodeshares;
                    private Boolean vendorPrefsAny;

                    /** 
                     * Get the list of 'Airline' element items.
                     * 
                     * @return list
                     */
                    public List<Airline> getAirlineList() {
                        return airlineList;
                    }

                    /** 
                     * Set the list of 'Airline' element items.
                     * 
                     * @param list
                     */
                    public void setAirlineList(List<Airline> list) {
                        airlineList = list;
                    }

                    /** 
                     * Get the 'Exclude' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getVendorPrefsExclude() {
                        return vendorPrefsExclude;
                    }

                    /** 
                     * Set the 'Exclude' attribute value.
                     * 
                     * @param vendorPrefsExclude
                     */
                    public void setVendorPrefsExclude(Boolean vendorPrefsExclude) {
                        this.vendorPrefsExclude = vendorPrefsExclude;
                    }

                    /** 
                     * Get the 'ExcludeCodeshares' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getVendorPrefsExcludeCodeshares() {
                        return vendorPrefsExcludeCodeshares;
                    }

                    /** 
                     * Set the 'ExcludeCodeshares' attribute value.
                     * 
                     * @param vendorPrefsExcludeCodeshares
                     */
                    public void setVendorPrefsExcludeCodeshares(
                            Boolean vendorPrefsExcludeCodeshares) {
                        this.vendorPrefsExcludeCodeshares = vendorPrefsExcludeCodeshares;
                    }

                    /** 
                     * Get the 'Any' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getVendorPrefsAny() {
                        return vendorPrefsAny;
                    }

                    /** 
                     * Set the 'Any' attribute value.
                     * 
                     * @param vendorPrefsAny
                     */
                    public void setVendorPrefsAny(Boolean vendorPrefsAny) {
                        this.vendorPrefsAny = vendorPrefsAny;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Airline" minOccurs="0" maxOccurs="20">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Airline implements Serializable
                    {
                        private String code;

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Airline" minOccurs="0" maxOccurs="20">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Airline1 implements Serializable
                {
                    private String code;

                    /** 
                     * Get the 'Code' attribute value.
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'Code' attribute value.
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ConnectionLocation" maxOccurs="2">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="ConnectTimeOverrides" minOccurs="0">
             *         &lt;!-- Reference to inner class ConnectTimeOverrides -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="required" name="LocationCode"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ConnectionLocation implements Serializable
            {
                private ConnectTimeOverrides connectTimeOverrides;
                private String locationCode;

                /** 
                 * Get the 'ConnectTimeOverrides' element value.
                 * 
                 * @return value
                 */
                public ConnectTimeOverrides getConnectTimeOverrides() {
                    return connectTimeOverrides;
                }

                /** 
                 * Set the 'ConnectTimeOverrides' element value.
                 * 
                 * @param connectTimeOverrides
                 */
                public void setConnectTimeOverrides(
                        ConnectTimeOverrides connectTimeOverrides) {
                    this.connectTimeOverrides = connectTimeOverrides;
                }

                /** 
                 * Get the 'LocationCode' attribute value.
                 * 
                 * @return value
                 */
                public String getLocationCode() {
                    return locationCode;
                }

                /** 
                 * Set the 'LocationCode' attribute value.
                 * 
                 * @param locationCode
                 */
                public void setLocationCode(String locationCode) {
                    this.locationCode = locationCode;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ConnectTimeOverrides" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Max"/>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Min"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ConnectTimeOverrides implements
                    Serializable
                {
                    private String max;
                    private String min;

                    /** 
                     * Get the 'Max' attribute value.
                     * 
                     * @return value
                     */
                    public String getMax() {
                        return max;
                    }

                    /** 
                     * Set the 'Max' attribute value.
                     * 
                     * @param max
                     */
                    public void setMax(String max) {
                        this.max = max;
                    }

                    /** 
                     * Get the 'Min' attribute value.
                     * 
                     * @return value
                     */
                    public String getMin() {
                        return min;
                    }

                    /** 
                     * Set the 'Min' attribute value.
                     * 
                     * @param min
                     */
                    public void setMin(String min) {
                        this.min = min;
                    }
                }
            }
        }
    }
}
