
package com.sabre.webservices.sabrexml;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OTA_AirPriceRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="OriginDestinationInformation" minOccurs="0">
 *         &lt;!-- Reference to inner class OriginDestinationInformation -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="PriceRequestInformation">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element name="OptionalQualifiers" minOccurs="0">
 *               &lt;!-- Reference to inner class OptionalQualifiers -->
 *             &lt;/xs:element>
 *           &lt;/xs:sequence>
 *           &lt;xs:attribute type="xs:boolean" use="optional" name="AlternativePricing"/>
 *           &lt;xs:attribute type="xs:boolean" use="optional" name="FutureTicket"/>
 *           &lt;xs:attribute type="xs:boolean" use="optional" name="Manual"/>
 *           &lt;xs:attribute type="xs:boolean" use="optional" name="Retain"/>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:boolean" use="optional" name="ReturnHostCommand"/>
 *     &lt;xs:attribute type="xs:dateTime" use="optional" name="TimeStamp"/>
 *     &lt;xs:attribute type="xs:string" use="required" fixed="2.17.0" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class OTAAirPriceRQ implements Serializable
{
    private OriginDestinationInformation originDestinationInformation;
    private OptionalQualifiers optionalQualifiers;
    private Boolean priceRequestInformationAlternativePricing;
    private Boolean priceRequestInformationFutureTicket;
    private Boolean priceRequestInformationManual;
    private Boolean priceRequestInformationRetain;
    private Boolean returnHostCommand;
    private Date timeStamp;
    private String version;

    /** 
     * Get the 'OriginDestinationInformation' element value.
     * 
     * @return value
     */
    public OriginDestinationInformation getOriginDestinationInformation() {
        return originDestinationInformation;
    }

    /** 
     * Set the 'OriginDestinationInformation' element value.
     * 
     * @param originDestinationInformation
     */
    public void setOriginDestinationInformation(
            OriginDestinationInformation originDestinationInformation) {
        this.originDestinationInformation = originDestinationInformation;
    }

    /** 
     * Get the 'OptionalQualifiers' element value.
     * 
     * @return value
     */
    public OptionalQualifiers getOptionalQualifiers() {
        return optionalQualifiers;
    }

    /** 
     * Set the 'OptionalQualifiers' element value.
     * 
     * @param optionalQualifiers
     */
    public void setOptionalQualifiers(OptionalQualifiers optionalQualifiers) {
        this.optionalQualifiers = optionalQualifiers;
    }

    /** 
     * Get the 'AlternativePricing' attribute value.
     * 
     * @return value
     */
    public Boolean getPriceRequestInformationAlternativePricing() {
        return priceRequestInformationAlternativePricing;
    }

    /** 
     * Set the 'AlternativePricing' attribute value.
     * 
     * @param priceRequestInformationAlternativePricing
     */
    public void setPriceRequestInformationAlternativePricing(
            Boolean priceRequestInformationAlternativePricing) {
        this.priceRequestInformationAlternativePricing = priceRequestInformationAlternativePricing;
    }

    /** 
     * Get the 'FutureTicket' attribute value.
     * 
     * @return value
     */
    public Boolean getPriceRequestInformationFutureTicket() {
        return priceRequestInformationFutureTicket;
    }

    /** 
     * Set the 'FutureTicket' attribute value.
     * 
     * @param priceRequestInformationFutureTicket
     */
    public void setPriceRequestInformationFutureTicket(
            Boolean priceRequestInformationFutureTicket) {
        this.priceRequestInformationFutureTicket = priceRequestInformationFutureTicket;
    }

    /** 
     * Get the 'Manual' attribute value.
     * 
     * @return value
     */
    public Boolean getPriceRequestInformationManual() {
        return priceRequestInformationManual;
    }

    /** 
     * Set the 'Manual' attribute value.
     * 
     * @param priceRequestInformationManual
     */
    public void setPriceRequestInformationManual(
            Boolean priceRequestInformationManual) {
        this.priceRequestInformationManual = priceRequestInformationManual;
    }

    /** 
     * Get the 'Retain' attribute value.
     * 
     * @return value
     */
    public Boolean getPriceRequestInformationRetain() {
        return priceRequestInformationRetain;
    }

    /** 
     * Set the 'Retain' attribute value.
     * 
     * @param priceRequestInformationRetain
     */
    public void setPriceRequestInformationRetain(
            Boolean priceRequestInformationRetain) {
        this.priceRequestInformationRetain = priceRequestInformationRetain;
    }

    /** 
     * Get the 'ReturnHostCommand' attribute value.
     * 
     * @return value
     */
    public Boolean getReturnHostCommand() {
        return returnHostCommand;
    }

    /** 
     * Set the 'ReturnHostCommand' attribute value.
     * 
     * @param returnHostCommand
     */
    public void setReturnHostCommand(Boolean returnHostCommand) {
        this.returnHostCommand = returnHostCommand;
    }

    /** 
     * Get the 'TimeStamp' attribute value.
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value.
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestinationInformation" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="FlightSegment" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class FlightSegment -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OriginDestinationInformation implements Serializable
    {
        private List<FlightSegment> flightSegmentList = new ArrayList<FlightSegment>();

        /** 
         * Get the list of 'FlightSegment' element items.
         * 
         * @return list
         */
        public List<FlightSegment> getFlightSegmentList() {
            return flightSegmentList;
        }

        /** 
         * Set the list of 'FlightSegment' element items.
         * 
         * @param list
         */
        public void setFlightSegmentList(List<FlightSegment> list) {
            flightSegmentList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightSegment" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="DestinationLocation">
         *         &lt;xs:complexType>
         *           &lt;xs:attribute type="xs:string" use="required" name="LocationCode"/>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element name="MarketingCarrier">
         *         &lt;xs:complexType>
         *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
         *           &lt;xs:attribute type="xs:string" use="required" name="FlightNumber"/>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element name="OriginLocation">
         *         &lt;xs:complexType>
         *           &lt;xs:attribute type="xs:string" use="required" name="LocationCode"/>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="optional" name="ArrivalDateTime"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="ConnectionInd"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="DepartureDateTime"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="FlightNumber"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="ResBookDesigCode"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FlightSegment implements Serializable
        {
            private String destinationLocation;
            private String marketingCarrierCode;
            private String marketingCarrierFlightNumber;
            private String originLocation;
            private String arrivalDateTime;
            private String connectionInd;
            private String departureDateTime;
            private String flightNumber;
            private String resBookDesigCode;
            private String RPH;

            /** 
             * Get the 'LocationCode' attribute value.
             * 
             * @return value
             */
            public String getDestinationLocation() {
                return destinationLocation;
            }

            /** 
             * Set the 'LocationCode' attribute value.
             * 
             * @param destinationLocation
             */
            public void setDestinationLocation(String destinationLocation) {
                this.destinationLocation = destinationLocation;
            }

            /** 
             * Get the 'Code' attribute value.
             * 
             * @return value
             */
            public String getMarketingCarrierCode() {
                return marketingCarrierCode;
            }

            /** 
             * Set the 'Code' attribute value.
             * 
             * @param marketingCarrierCode
             */
            public void setMarketingCarrierCode(String marketingCarrierCode) {
                this.marketingCarrierCode = marketingCarrierCode;
            }

            /** 
             * Get the 'FlightNumber' attribute value.
             * 
             * @return value
             */
            public String getMarketingCarrierFlightNumber() {
                return marketingCarrierFlightNumber;
            }

            /** 
             * Set the 'FlightNumber' attribute value.
             * 
             * @param marketingCarrierFlightNumber
             */
            public void setMarketingCarrierFlightNumber(
                    String marketingCarrierFlightNumber) {
                this.marketingCarrierFlightNumber = marketingCarrierFlightNumber;
            }

            /** 
             * Get the 'LocationCode' attribute value.
             * 
             * @return value
             */
            public String getOriginLocation() {
                return originLocation;
            }

            /** 
             * Set the 'LocationCode' attribute value.
             * 
             * @param originLocation
             */
            public void setOriginLocation(String originLocation) {
                this.originLocation = originLocation;
            }

            /** 
             * Get the 'ArrivalDateTime' attribute value.
             * 
             * @return value
             */
            public String getArrivalDateTime() {
                return arrivalDateTime;
            }

            /** 
             * Set the 'ArrivalDateTime' attribute value.
             * 
             * @param arrivalDateTime
             */
            public void setArrivalDateTime(String arrivalDateTime) {
                this.arrivalDateTime = arrivalDateTime;
            }

            /** 
             * Get the 'ConnectionInd' attribute value.
             * 
             * @return value
             */
            public String getConnectionInd() {
                return connectionInd;
            }

            /** 
             * Set the 'ConnectionInd' attribute value.
             * 
             * @param connectionInd
             */
            public void setConnectionInd(String connectionInd) {
                this.connectionInd = connectionInd;
            }

            /** 
             * Get the 'DepartureDateTime' attribute value.
             * 
             * @return value
             */
            public String getDepartureDateTime() {
                return departureDateTime;
            }

            /** 
             * Set the 'DepartureDateTime' attribute value.
             * 
             * @param departureDateTime
             */
            public void setDepartureDateTime(String departureDateTime) {
                this.departureDateTime = departureDateTime;
            }

            /** 
             * Get the 'FlightNumber' attribute value.
             * 
             * @return value
             */
            public String getFlightNumber() {
                return flightNumber;
            }

            /** 
             * Set the 'FlightNumber' attribute value.
             * 
             * @param flightNumber
             */
            public void setFlightNumber(String flightNumber) {
                this.flightNumber = flightNumber;
            }

            /** 
             * Get the 'ResBookDesigCode' attribute value.
             * 
             * @return value
             */
            public String getResBookDesigCode() {
                return resBookDesigCode;
            }

            /** 
             * Set the 'ResBookDesigCode' attribute value.
             * 
             * @param resBookDesigCode
             */
            public void setResBookDesigCode(String resBookDesigCode) {
                this.resBookDesigCode = resBookDesigCode;
            }

            /** 
             * Get the 'RPH' attribute value.
             * 
             * @return value
             */
            public String getRPH() {
                return RPH;
            }

            /** 
             * Set the 'RPH' attribute value.
             * 
             * @param RPH
             */
            public void setRPH(String RPH) {
                this.RPH = RPH;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OptionalQualifiers" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="FlightQualifiers" minOccurs="0">
     *         &lt;!-- Reference to inner class FlightQualifiers -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FOP_Qualifiers" minOccurs="0">
     *         &lt;!-- Reference to inner class FOPQualifiers -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="MiscQualifiers" minOccurs="0">
     *         &lt;!-- Reference to inner class MiscQualifiers -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="PricingQualifiers" minOccurs="0">
     *         &lt;!-- Reference to inner class PricingQualifiers -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OptionalQualifiers implements Serializable
    {
        private FlightQualifiers flightQualifiers;
        private FOPQualifiers FOPQualifiers1;
        private MiscQualifiers miscQualifiers;
        private PricingQualifiers pricingQualifiers;

        /** 
         * Get the 'FlightQualifiers' element value.
         * 
         * @return value
         */
        public FlightQualifiers getFlightQualifiers() {
            return flightQualifiers;
        }

        /** 
         * Set the 'FlightQualifiers' element value.
         * 
         * @param flightQualifiers
         */
        public void setFlightQualifiers(FlightQualifiers flightQualifiers) {
            this.flightQualifiers = flightQualifiers;
        }

        /** 
         * Get the 'FOP_Qualifiers' element value.
         * 
         * @return value
         */
        public FOPQualifiers getFOPQualifiers1() {
            return FOPQualifiers1;
        }

        /** 
         * Set the 'FOP_Qualifiers' element value.
         * 
         * @param FOPQualifiers1
         */
        public void setFOPQualifiers1(FOPQualifiers FOPQualifiers1) {
            this.FOPQualifiers1 = FOPQualifiers1;
        }

        /** 
         * Get the 'MiscQualifiers' element value.
         * 
         * @return value
         */
        public MiscQualifiers getMiscQualifiers() {
            return miscQualifiers;
        }

        /** 
         * Set the 'MiscQualifiers' element value.
         * 
         * @param miscQualifiers
         */
        public void setMiscQualifiers(MiscQualifiers miscQualifiers) {
            this.miscQualifiers = miscQualifiers;
        }

        /** 
         * Get the 'PricingQualifiers' element value.
         * 
         * @return value
         */
        public PricingQualifiers getPricingQualifiers() {
            return pricingQualifiers;
        }

        /** 
         * Set the 'PricingQualifiers' element value.
         * 
         * @param pricingQualifiers
         */
        public void setPricingQualifiers(PricingQualifiers pricingQualifiers) {
            this.pricingQualifiers = pricingQualifiers;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightQualifiers" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="VendorPrefs" minOccurs="0">
         *         &lt;!-- Reference to inner class VendorPrefs -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FlightQualifiers implements Serializable
        {
            private VendorPrefs vendorPrefs;

            /** 
             * Get the 'VendorPrefs' element value.
             * 
             * @return value
             */
            public VendorPrefs getVendorPrefs() {
                return vendorPrefs;
            }

            /** 
             * Set the 'VendorPrefs' element value.
             * 
             * @param vendorPrefs
             */
            public void setVendorPrefs(VendorPrefs vendorPrefs) {
                this.vendorPrefs = vendorPrefs;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VendorPrefs" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Airline">
             *         &lt;xs:complexType>
             *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class VendorPrefs implements Serializable
            {
                private String airline;

                /** 
                 * Get the 'Code' attribute value.
                 * 
                 * @return value
                 */
                public String getAirline() {
                    return airline;
                }

                /** 
                 * Set the 'Code' attribute value.
                 * 
                 * @param airline
                 */
                public void setAirline(String airline) {
                    this.airline = airline;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FOP_Qualifiers" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="BasicFOP" minOccurs="0">
         *         &lt;!-- Reference to inner class BasicFOP -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="BSP_Ticketing" minOccurs="0">
         *         &lt;!-- Reference to inner class BSPTicketing -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="MultipleCC_FOP" minOccurs="0">
         *         &lt;!-- Reference to inner class MultipleCCFOP -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="SabreSonicTicketing" minOccurs="0">
         *         &lt;!-- Reference to inner class SabreSonicTicketing -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="IgnoreStoredFOP"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FOPQualifiers implements Serializable
        {
            private BasicFOP basicFOP;
            private BSPTicketing BSPTicketing1;
            private MultipleCCFOP multipleCCFOP;
            private SabreSonicTicketing sabreSonicTicketing;
            private Boolean ignoreStoredFOP;

            /** 
             * Get the 'BasicFOP' element value.
             * 
             * @return value
             */
            public BasicFOP getBasicFOP() {
                return basicFOP;
            }

            /** 
             * Set the 'BasicFOP' element value.
             * 
             * @param basicFOP
             */
            public void setBasicFOP(BasicFOP basicFOP) {
                this.basicFOP = basicFOP;
            }

            /** 
             * Get the 'BSP_Ticketing' element value.
             * 
             * @return value
             */
            public BSPTicketing getBSPTicketing1() {
                return BSPTicketing1;
            }

            /** 
             * Set the 'BSP_Ticketing' element value.
             * 
             * @param BSPTicketing1
             */
            public void setBSPTicketing1(BSPTicketing BSPTicketing1) {
                this.BSPTicketing1 = BSPTicketing1;
            }

            /** 
             * Get the 'MultipleCC_FOP' element value.
             * 
             * @return value
             */
            public MultipleCCFOP getMultipleCCFOP() {
                return multipleCCFOP;
            }

            /** 
             * Set the 'MultipleCC_FOP' element value.
             * 
             * @param multipleCCFOP
             */
            public void setMultipleCCFOP(MultipleCCFOP multipleCCFOP) {
                this.multipleCCFOP = multipleCCFOP;
            }

            /** 
             * Get the 'SabreSonicTicketing' element value.
             * 
             * @return value
             */
            public SabreSonicTicketing getSabreSonicTicketing() {
                return sabreSonicTicketing;
            }

            /** 
             * Set the 'SabreSonicTicketing' element value.
             * 
             * @param sabreSonicTicketing
             */
            public void setSabreSonicTicketing(
                    SabreSonicTicketing sabreSonicTicketing) {
                this.sabreSonicTicketing = sabreSonicTicketing;
            }

            /** 
             * Get the 'IgnoreStoredFOP' attribute value.
             * 
             * @return value
             */
            public Boolean getIgnoreStoredFOP() {
                return ignoreStoredFOP;
            }

            /** 
             * Set the 'IgnoreStoredFOP' attribute value.
             * 
             * @param ignoreStoredFOP
             */
            public void setIgnoreStoredFOP(Boolean ignoreStoredFOP) {
                this.ignoreStoredFOP = ignoreStoredFOP;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BasicFOP" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="CC_Info" minOccurs="0">
             *         &lt;!-- Reference to inner class CCInfo -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
             *     &lt;xs:attribute type="xs:integer" use="optional" name="Reference"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Virtual"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class BasicFOP implements Serializable
            {
                private CCInfo CCInfo1;
                private String type;
                private BigInteger reference;
                private String virtual;

                /** 
                 * Get the 'CC_Info' element value.
                 * 
                 * @return value
                 */
                public CCInfo getCCInfo1() {
                    return CCInfo1;
                }

                /** 
                 * Set the 'CC_Info' element value.
                 * 
                 * @param CCInfo1
                 */
                public void setCCInfo1(CCInfo CCInfo1) {
                    this.CCInfo1 = CCInfo1;
                }

                /** 
                 * Get the 'Type' attribute value.
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'Type' attribute value.
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }

                /** 
                 * Get the 'Reference' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getReference() {
                    return reference;
                }

                /** 
                 * Set the 'Reference' attribute value.
                 * 
                 * @param reference
                 */
                public void setReference(BigInteger reference) {
                    this.reference = reference;
                }

                /** 
                 * Get the 'Virtual' attribute value.
                 * 
                 * @return value
                 */
                public String getVirtual() {
                    return virtual;
                }

                /** 
                 * Set the 'Virtual' attribute value.
                 * 
                 * @param virtual
                 */
                public void setVirtual(String virtual) {
                    this.virtual = virtual;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="PaymentCard">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="ExpireDate"/>
                 *           &lt;xs:attribute type="xs:integer" use="optional" name="ExtendedPayment"/>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                 *           &lt;xs:attribute type="xs:integer" use="optional" name="Number"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Suppress"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class CCInfo implements Serializable
                {
                    private String paymentCardCode;
                    private String paymentCardExpireDate;
                    private BigInteger paymentCardExtendedPayment;
                    private String paymentCardManualApprovalCode;
                    private BigInteger paymentCardNumber;
                    private Boolean suppress;

                    /** 
                     * Get the 'Code' attribute value.
                     * 
                     * @return value
                     */
                    public String getPaymentCardCode() {
                        return paymentCardCode;
                    }

                    /** 
                     * Set the 'Code' attribute value.
                     * 
                     * @param paymentCardCode
                     */
                    public void setPaymentCardCode(String paymentCardCode) {
                        this.paymentCardCode = paymentCardCode;
                    }

                    /** 
                     * Get the 'ExpireDate' attribute value.
                     * 
                     * @return value
                     */
                    public String getPaymentCardExpireDate() {
                        return paymentCardExpireDate;
                    }

                    /** 
                     * Set the 'ExpireDate' attribute value.
                     * 
                     * @param paymentCardExpireDate
                     */
                    public void setPaymentCardExpireDate(
                            String paymentCardExpireDate) {
                        this.paymentCardExpireDate = paymentCardExpireDate;
                    }

                    /** 
                     * Get the 'ExtendedPayment' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getPaymentCardExtendedPayment() {
                        return paymentCardExtendedPayment;
                    }

                    /** 
                     * Set the 'ExtendedPayment' attribute value.
                     * 
                     * @param paymentCardExtendedPayment
                     */
                    public void setPaymentCardExtendedPayment(
                            BigInteger paymentCardExtendedPayment) {
                        this.paymentCardExtendedPayment = paymentCardExtendedPayment;
                    }

                    /** 
                     * Get the 'ManualApprovalCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getPaymentCardManualApprovalCode() {
                        return paymentCardManualApprovalCode;
                    }

                    /** 
                     * Set the 'ManualApprovalCode' attribute value.
                     * 
                     * @param paymentCardManualApprovalCode
                     */
                    public void setPaymentCardManualApprovalCode(
                            String paymentCardManualApprovalCode) {
                        this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                    }

                    /** 
                     * Get the 'Number' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getPaymentCardNumber() {
                        return paymentCardNumber;
                    }

                    /** 
                     * Set the 'Number' attribute value.
                     * 
                     * @param paymentCardNumber
                     */
                    public void setPaymentCardNumber(
                            BigInteger paymentCardNumber) {
                        this.paymentCardNumber = paymentCardNumber;
                    }

                    /** 
                     * Get the 'Suppress' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getSuppress() {
                        return suppress;
                    }

                    /** 
                     * Set the 'Suppress' attribute value.
                     * 
                     * @param suppress
                     */
                    public void setSuppress(Boolean suppress) {
                        this.suppress = suppress;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BSP_Ticketing" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="MultipleFOP" minOccurs="0">
             *         &lt;!-- Reference to inner class MultipleFOP -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="MultipleMiscFOP" minOccurs="0">
             *         &lt;!-- Reference to inner class MultipleMiscFOP -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="PayLaterPlan" minOccurs="0">
             *         &lt;!-- Reference to inner class PayLaterPlan -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class BSPTicketing implements Serializable
            {
                private MultipleFOP multipleFOP;
                private MultipleMiscFOP multipleMiscFOP;
                private PayLaterPlan payLaterPlan;

                /** 
                 * Get the 'MultipleFOP' element value.
                 * 
                 * @return value
                 */
                public MultipleFOP getMultipleFOP() {
                    return multipleFOP;
                }

                /** 
                 * Set the 'MultipleFOP' element value.
                 * 
                 * @param multipleFOP
                 */
                public void setMultipleFOP(MultipleFOP multipleFOP) {
                    this.multipleFOP = multipleFOP;
                }

                /** 
                 * Get the 'MultipleMiscFOP' element value.
                 * 
                 * @return value
                 */
                public MultipleMiscFOP getMultipleMiscFOP() {
                    return multipleMiscFOP;
                }

                /** 
                 * Set the 'MultipleMiscFOP' element value.
                 * 
                 * @param multipleMiscFOP
                 */
                public void setMultipleMiscFOP(MultipleMiscFOP multipleMiscFOP) {
                    this.multipleMiscFOP = multipleMiscFOP;
                }

                /** 
                 * Get the 'PayLaterPlan' element value.
                 * 
                 * @return value
                 */
                public PayLaterPlan getPayLaterPlan() {
                    return payLaterPlan;
                }

                /** 
                 * Set the 'PayLaterPlan' element value.
                 * 
                 * @param payLaterPlan
                 */
                public void setPayLaterPlan(PayLaterPlan payLaterPlan) {
                    this.payLaterPlan = payLaterPlan;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MultipleFOP" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Fare">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="FOP_One">
                 *         &lt;xs:complexType>
                 *           &lt;xs:sequence>
                 *             &lt;xs:element name="CC_Info" minOccurs="0">
                 *               &lt;!-- Reference to inner class CCInfo -->
                 *             &lt;/xs:element>
                 *           &lt;/xs:sequence>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                 *           &lt;xs:attribute type="xs:integer" use="optional" name="Reference"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="FOP_Two">
                 *         &lt;xs:complexType>
                 *           &lt;xs:sequence>
                 *             &lt;xs:element name="CC_Info" minOccurs="0">
                 *               &lt;!-- Reference to inner class CCInfo1 -->
                 *             &lt;/xs:element>
                 *           &lt;/xs:sequence>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                 *           &lt;xs:attribute type="xs:integer" use="optional" name="Reference"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class MultipleFOP implements Serializable
                {
                    private String fare;
                    private CCInfo CCInfo2;
                    private String FOPOneType;
                    private BigInteger FOPOneReference;
                    private CCInfo1 CCInfo3;
                    private String FOPTwoType;
                    private BigInteger FOPTwoReference;

                    /** 
                     * Get the 'Amount' attribute value.
                     * 
                     * @return value
                     */
                    public String getFare() {
                        return fare;
                    }

                    /** 
                     * Set the 'Amount' attribute value.
                     * 
                     * @param fare
                     */
                    public void setFare(String fare) {
                        this.fare = fare;
                    }

                    /** 
                     * Get the 'CC_Info' element value.
                     * 
                     * @return value
                     */
                    public CCInfo getCCInfo2() {
                        return CCInfo2;
                    }

                    /** 
                     * Set the 'CC_Info' element value.
                     * 
                     * @param CCInfo2
                     */
                    public void setCCInfo2(CCInfo CCInfo2) {
                        this.CCInfo2 = CCInfo2;
                    }

                    /** 
                     * Get the 'Type' attribute value.
                     * 
                     * @return value
                     */
                    public String getFOPOneType() {
                        return FOPOneType;
                    }

                    /** 
                     * Set the 'Type' attribute value.
                     * 
                     * @param FOPOneType
                     */
                    public void setFOPOneType(String FOPOneType) {
                        this.FOPOneType = FOPOneType;
                    }

                    /** 
                     * Get the 'Reference' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getFOPOneReference() {
                        return FOPOneReference;
                    }

                    /** 
                     * Set the 'Reference' attribute value.
                     * 
                     * @param FOPOneReference
                     */
                    public void setFOPOneReference(BigInteger FOPOneReference) {
                        this.FOPOneReference = FOPOneReference;
                    }

                    /** 
                     * Get the 'CC_Info' element value.
                     * 
                     * @return value
                     */
                    public CCInfo1 getCCInfo3() {
                        return CCInfo3;
                    }

                    /** 
                     * Set the 'CC_Info' element value.
                     * 
                     * @param CCInfo3
                     */
                    public void setCCInfo3(CCInfo1 CCInfo3) {
                        this.CCInfo3 = CCInfo3;
                    }

                    /** 
                     * Get the 'Type' attribute value.
                     * 
                     * @return value
                     */
                    public String getFOPTwoType() {
                        return FOPTwoType;
                    }

                    /** 
                     * Set the 'Type' attribute value.
                     * 
                     * @param FOPTwoType
                     */
                    public void setFOPTwoType(String FOPTwoType) {
                        this.FOPTwoType = FOPTwoType;
                    }

                    /** 
                     * Get the 'Reference' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getFOPTwoReference() {
                        return FOPTwoReference;
                    }

                    /** 
                     * Set the 'Reference' attribute value.
                     * 
                     * @param FOPTwoReference
                     */
                    public void setFOPTwoReference(BigInteger FOPTwoReference) {
                        this.FOPTwoReference = FOPTwoReference;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="PaymentCard">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ExpireDate"/>
                     *           &lt;xs:attribute type="xs:integer" use="optional" name="ExtendedPayment"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                     *           &lt;xs:attribute type="xs:integer" use="optional" name="Number"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="Suppress"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CCInfo implements Serializable
                    {
                        private String paymentCardCode;
                        private String paymentCardExpireDate;
                        private BigInteger paymentCardExtendedPayment;
                        private String paymentCardManualApprovalCode;
                        private BigInteger paymentCardNumber;
                        private Boolean suppress;

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardCode() {
                            return paymentCardCode;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param paymentCardCode
                         */
                        public void setPaymentCardCode(String paymentCardCode) {
                            this.paymentCardCode = paymentCardCode;
                        }

                        /** 
                         * Get the 'ExpireDate' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardExpireDate() {
                            return paymentCardExpireDate;
                        }

                        /** 
                         * Set the 'ExpireDate' attribute value.
                         * 
                         * @param paymentCardExpireDate
                         */
                        public void setPaymentCardExpireDate(
                                String paymentCardExpireDate) {
                            this.paymentCardExpireDate = paymentCardExpireDate;
                        }

                        /** 
                         * Get the 'ExtendedPayment' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardExtendedPayment() {
                            return paymentCardExtendedPayment;
                        }

                        /** 
                         * Set the 'ExtendedPayment' attribute value.
                         * 
                         * @param paymentCardExtendedPayment
                         */
                        public void setPaymentCardExtendedPayment(
                                BigInteger paymentCardExtendedPayment) {
                            this.paymentCardExtendedPayment = paymentCardExtendedPayment;
                        }

                        /** 
                         * Get the 'ManualApprovalCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardManualApprovalCode() {
                            return paymentCardManualApprovalCode;
                        }

                        /** 
                         * Set the 'ManualApprovalCode' attribute value.
                         * 
                         * @param paymentCardManualApprovalCode
                         */
                        public void setPaymentCardManualApprovalCode(
                                String paymentCardManualApprovalCode) {
                            this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                        }

                        /** 
                         * Get the 'Number' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardNumber() {
                            return paymentCardNumber;
                        }

                        /** 
                         * Set the 'Number' attribute value.
                         * 
                         * @param paymentCardNumber
                         */
                        public void setPaymentCardNumber(
                                BigInteger paymentCardNumber) {
                            this.paymentCardNumber = paymentCardNumber;
                        }

                        /** 
                         * Get the 'Suppress' attribute value.
                         * 
                         * @return value
                         */
                        public Boolean getSuppress() {
                            return suppress;
                        }

                        /** 
                         * Set the 'Suppress' attribute value.
                         * 
                         * @param suppress
                         */
                        public void setSuppress(Boolean suppress) {
                            this.suppress = suppress;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="PaymentCard">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ExpireDate"/>
                     *           &lt;xs:attribute type="xs:integer" use="optional" name="ExtendedPayment"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                     *           &lt;xs:attribute type="xs:integer" use="optional" name="Number"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="Suppress"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CCInfo1 implements Serializable
                    {
                        private String paymentCardCode;
                        private String paymentCardExpireDate;
                        private BigInteger paymentCardExtendedPayment;
                        private String paymentCardManualApprovalCode;
                        private BigInteger paymentCardNumber;
                        private Boolean suppress;

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardCode() {
                            return paymentCardCode;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param paymentCardCode
                         */
                        public void setPaymentCardCode(String paymentCardCode) {
                            this.paymentCardCode = paymentCardCode;
                        }

                        /** 
                         * Get the 'ExpireDate' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardExpireDate() {
                            return paymentCardExpireDate;
                        }

                        /** 
                         * Set the 'ExpireDate' attribute value.
                         * 
                         * @param paymentCardExpireDate
                         */
                        public void setPaymentCardExpireDate(
                                String paymentCardExpireDate) {
                            this.paymentCardExpireDate = paymentCardExpireDate;
                        }

                        /** 
                         * Get the 'ExtendedPayment' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardExtendedPayment() {
                            return paymentCardExtendedPayment;
                        }

                        /** 
                         * Set the 'ExtendedPayment' attribute value.
                         * 
                         * @param paymentCardExtendedPayment
                         */
                        public void setPaymentCardExtendedPayment(
                                BigInteger paymentCardExtendedPayment) {
                            this.paymentCardExtendedPayment = paymentCardExtendedPayment;
                        }

                        /** 
                         * Get the 'ManualApprovalCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardManualApprovalCode() {
                            return paymentCardManualApprovalCode;
                        }

                        /** 
                         * Set the 'ManualApprovalCode' attribute value.
                         * 
                         * @param paymentCardManualApprovalCode
                         */
                        public void setPaymentCardManualApprovalCode(
                                String paymentCardManualApprovalCode) {
                            this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                        }

                        /** 
                         * Get the 'Number' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardNumber() {
                            return paymentCardNumber;
                        }

                        /** 
                         * Set the 'Number' attribute value.
                         * 
                         * @param paymentCardNumber
                         */
                        public void setPaymentCardNumber(
                                BigInteger paymentCardNumber) {
                            this.paymentCardNumber = paymentCardNumber;
                        }

                        /** 
                         * Get the 'Suppress' attribute value.
                         * 
                         * @return value
                         */
                        public Boolean getSuppress() {
                            return suppress;
                        }

                        /** 
                         * Set the 'Suppress' attribute value.
                         * 
                         * @param suppress
                         */
                        public void setSuppress(Boolean suppress) {
                            this.suppress = suppress;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MultipleMiscFOP" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Fare">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="FOP_One">
                 *         &lt;xs:complexType>
                 *           &lt;xs:sequence>
                 *             &lt;xs:element name="CC_Info" minOccurs="0">
                 *               &lt;!-- Reference to inner class CCInfo -->
                 *             &lt;/xs:element>
                 *           &lt;/xs:sequence>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                 *           &lt;xs:attribute type="xs:integer" use="optional" name="Reference"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="FOP_Two">
                 *         &lt;xs:complexType>
                 *           &lt;xs:sequence>
                 *             &lt;xs:element name="ExtendedPayment" minOccurs="0">
                 *               &lt;!-- Reference to inner class ExtendedPayment -->
                 *             &lt;/xs:element>
                 *           &lt;/xs:sequence>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                 *           &lt;xs:attribute type="xs:integer" use="optional" name="Reference"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Taxes" minOccurs="0">
                 *         &lt;!-- Reference to inner class Taxes -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class MultipleMiscFOP implements Serializable
                {
                    private String fare;
                    private CCInfo CCInfo1;
                    private String FOPOneType;
                    private BigInteger FOPOneReference;
                    private ExtendedPayment extendedPayment;
                    private String FOPTwoType;
                    private BigInteger FOPTwoReference;
                    private Taxes taxes;

                    /** 
                     * Get the 'Amount' attribute value.
                     * 
                     * @return value
                     */
                    public String getFare() {
                        return fare;
                    }

                    /** 
                     * Set the 'Amount' attribute value.
                     * 
                     * @param fare
                     */
                    public void setFare(String fare) {
                        this.fare = fare;
                    }

                    /** 
                     * Get the 'CC_Info' element value.
                     * 
                     * @return value
                     */
                    public CCInfo getCCInfo1() {
                        return CCInfo1;
                    }

                    /** 
                     * Set the 'CC_Info' element value.
                     * 
                     * @param CCInfo1
                     */
                    public void setCCInfo1(CCInfo CCInfo1) {
                        this.CCInfo1 = CCInfo1;
                    }

                    /** 
                     * Get the 'Type' attribute value.
                     * 
                     * @return value
                     */
                    public String getFOPOneType() {
                        return FOPOneType;
                    }

                    /** 
                     * Set the 'Type' attribute value.
                     * 
                     * @param FOPOneType
                     */
                    public void setFOPOneType(String FOPOneType) {
                        this.FOPOneType = FOPOneType;
                    }

                    /** 
                     * Get the 'Reference' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getFOPOneReference() {
                        return FOPOneReference;
                    }

                    /** 
                     * Set the 'Reference' attribute value.
                     * 
                     * @param FOPOneReference
                     */
                    public void setFOPOneReference(BigInteger FOPOneReference) {
                        this.FOPOneReference = FOPOneReference;
                    }

                    /** 
                     * Get the 'ExtendedPayment' element value.
                     * 
                     * @return value
                     */
                    public ExtendedPayment getExtendedPayment() {
                        return extendedPayment;
                    }

                    /** 
                     * Set the 'ExtendedPayment' element value.
                     * 
                     * @param extendedPayment
                     */
                    public void setExtendedPayment(
                            ExtendedPayment extendedPayment) {
                        this.extendedPayment = extendedPayment;
                    }

                    /** 
                     * Get the 'Type' attribute value.
                     * 
                     * @return value
                     */
                    public String getFOPTwoType() {
                        return FOPTwoType;
                    }

                    /** 
                     * Set the 'Type' attribute value.
                     * 
                     * @param FOPTwoType
                     */
                    public void setFOPTwoType(String FOPTwoType) {
                        this.FOPTwoType = FOPTwoType;
                    }

                    /** 
                     * Get the 'Reference' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getFOPTwoReference() {
                        return FOPTwoReference;
                    }

                    /** 
                     * Set the 'Reference' attribute value.
                     * 
                     * @param FOPTwoReference
                     */
                    public void setFOPTwoReference(BigInteger FOPTwoReference) {
                        this.FOPTwoReference = FOPTwoReference;
                    }

                    /** 
                     * Get the 'Taxes' element value.
                     * 
                     * @return value
                     */
                    public Taxes getTaxes() {
                        return taxes;
                    }

                    /** 
                     * Set the 'Taxes' element value.
                     * 
                     * @param taxes
                     */
                    public void setTaxes(Taxes taxes) {
                        this.taxes = taxes;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="PaymentCard">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ExpireDate"/>
                     *           &lt;xs:attribute type="xs:integer" use="optional" name="ExtendedPayment"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                     *           &lt;xs:attribute type="xs:integer" use="optional" name="Number"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="Suppress"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CCInfo implements Serializable
                    {
                        private String paymentCardCode;
                        private String paymentCardExpireDate;
                        private BigInteger paymentCardExtendedPayment;
                        private String paymentCardManualApprovalCode;
                        private BigInteger paymentCardNumber;
                        private Boolean suppress;

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardCode() {
                            return paymentCardCode;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param paymentCardCode
                         */
                        public void setPaymentCardCode(String paymentCardCode) {
                            this.paymentCardCode = paymentCardCode;
                        }

                        /** 
                         * Get the 'ExpireDate' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardExpireDate() {
                            return paymentCardExpireDate;
                        }

                        /** 
                         * Set the 'ExpireDate' attribute value.
                         * 
                         * @param paymentCardExpireDate
                         */
                        public void setPaymentCardExpireDate(
                                String paymentCardExpireDate) {
                            this.paymentCardExpireDate = paymentCardExpireDate;
                        }

                        /** 
                         * Get the 'ExtendedPayment' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardExtendedPayment() {
                            return paymentCardExtendedPayment;
                        }

                        /** 
                         * Set the 'ExtendedPayment' attribute value.
                         * 
                         * @param paymentCardExtendedPayment
                         */
                        public void setPaymentCardExtendedPayment(
                                BigInteger paymentCardExtendedPayment) {
                            this.paymentCardExtendedPayment = paymentCardExtendedPayment;
                        }

                        /** 
                         * Get the 'ManualApprovalCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardManualApprovalCode() {
                            return paymentCardManualApprovalCode;
                        }

                        /** 
                         * Set the 'ManualApprovalCode' attribute value.
                         * 
                         * @param paymentCardManualApprovalCode
                         */
                        public void setPaymentCardManualApprovalCode(
                                String paymentCardManualApprovalCode) {
                            this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                        }

                        /** 
                         * Get the 'Number' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardNumber() {
                            return paymentCardNumber;
                        }

                        /** 
                         * Set the 'Number' attribute value.
                         * 
                         * @param paymentCardNumber
                         */
                        public void setPaymentCardNumber(
                                BigInteger paymentCardNumber) {
                            this.paymentCardNumber = paymentCardNumber;
                        }

                        /** 
                         * Get the 'Suppress' attribute value.
                         * 
                         * @return value
                         */
                        public Boolean getSuppress() {
                            return suppress;
                        }

                        /** 
                         * Set the 'Suppress' attribute value.
                         * 
                         * @param suppress
                         */
                        public void setSuppress(Boolean suppress) {
                            this.suppress = suppress;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExtendedPayment" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:integer" use="required" name="NumMonths"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class ExtendedPayment implements Serializable
                    {
                        private BigInteger numMonths;

                        /** 
                         * Get the 'NumMonths' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getNumMonths() {
                            return numMonths;
                        }

                        /** 
                         * Set the 'NumMonths' attribute value.
                         * 
                         * @param numMonths
                         */
                        public void setNumMonths(BigInteger numMonths) {
                            this.numMonths = numMonths;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Tax" maxOccurs="2">
                     *         &lt;!-- Reference to inner class Tax -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Taxes implements Serializable
                    {
                        private List<Tax> taxList = new ArrayList<Tax>();

                        /** 
                         * Get the list of 'Tax' element items.
                         * 
                         * @return list
                         */
                        public List<Tax> getTaxList() {
                            return taxList;
                        }

                        /** 
                         * Set the list of 'Tax' element items.
                         * 
                         * @param list
                         */
                        public void setTaxList(List<Tax> list) {
                            taxList = list;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" maxOccurs="2">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                         *     &lt;xs:attribute type="xs:string" use="required" name="TaxCode"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Tax implements Serializable
                        {
                            private String amount;
                            private String taxCode;

                            /** 
                             * Get the 'Amount' attribute value.
                             * 
                             * @return value
                             */
                            public String getAmount() {
                                return amount;
                            }

                            /** 
                             * Set the 'Amount' attribute value.
                             * 
                             * @param amount
                             */
                            public void setAmount(String amount) {
                                this.amount = amount;
                            }

                            /** 
                             * Get the 'TaxCode' attribute value.
                             * 
                             * @return value
                             */
                            public String getTaxCode() {
                                return taxCode;
                            }

                            /** 
                             * Set the 'TaxCode' attribute value.
                             * 
                             * @param taxCode
                             */
                            public void setTaxCode(String taxCode) {
                                this.taxCode = taxCode;
                            }
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PayLaterPlan" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Fare">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="FOP">
                 *         &lt;xs:complexType>
                 *           &lt;xs:sequence>
                 *             &lt;xs:element name="CC_Info" minOccurs="0">
                 *               &lt;!-- Reference to inner class CCInfo -->
                 *             &lt;/xs:element>
                 *           &lt;/xs:sequence>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="Reference"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Installment">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:string" use="required" name="Count"/>
                 *           &lt;xs:attribute type="xs:string" use="required" name="PayLaterReferenceNumber"/>
                 *           &lt;xs:attribute type="xs:integer" use="optional" name="Reference"/>
                 *           &lt;xs:attribute type="xs:string" use="required" name="Value"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class PayLaterPlan implements Serializable
                {
                    private String fare;
                    private CCInfo CCInfo1;
                    private String FOPType;
                    private String FOPReference;
                    private String installmentCount;
                    private String installmentPayLaterReferenceNumber;
                    private BigInteger installmentReference;
                    private String installmentValue;

                    /** 
                     * Get the 'Amount' attribute value.
                     * 
                     * @return value
                     */
                    public String getFare() {
                        return fare;
                    }

                    /** 
                     * Set the 'Amount' attribute value.
                     * 
                     * @param fare
                     */
                    public void setFare(String fare) {
                        this.fare = fare;
                    }

                    /** 
                     * Get the 'CC_Info' element value.
                     * 
                     * @return value
                     */
                    public CCInfo getCCInfo1() {
                        return CCInfo1;
                    }

                    /** 
                     * Set the 'CC_Info' element value.
                     * 
                     * @param CCInfo1
                     */
                    public void setCCInfo1(CCInfo CCInfo1) {
                        this.CCInfo1 = CCInfo1;
                    }

                    /** 
                     * Get the 'Type' attribute value.
                     * 
                     * @return value
                     */
                    public String getFOPType() {
                        return FOPType;
                    }

                    /** 
                     * Set the 'Type' attribute value.
                     * 
                     * @param FOPType
                     */
                    public void setFOPType(String FOPType) {
                        this.FOPType = FOPType;
                    }

                    /** 
                     * Get the 'Reference' attribute value.
                     * 
                     * @return value
                     */
                    public String getFOPReference() {
                        return FOPReference;
                    }

                    /** 
                     * Set the 'Reference' attribute value.
                     * 
                     * @param FOPReference
                     */
                    public void setFOPReference(String FOPReference) {
                        this.FOPReference = FOPReference;
                    }

                    /** 
                     * Get the 'Count' attribute value.
                     * 
                     * @return value
                     */
                    public String getInstallmentCount() {
                        return installmentCount;
                    }

                    /** 
                     * Set the 'Count' attribute value.
                     * 
                     * @param installmentCount
                     */
                    public void setInstallmentCount(String installmentCount) {
                        this.installmentCount = installmentCount;
                    }

                    /** 
                     * Get the 'PayLaterReferenceNumber' attribute value.
                     * 
                     * @return value
                     */
                    public String getInstallmentPayLaterReferenceNumber() {
                        return installmentPayLaterReferenceNumber;
                    }

                    /** 
                     * Set the 'PayLaterReferenceNumber' attribute value.
                     * 
                     * @param installmentPayLaterReferenceNumber
                     */
                    public void setInstallmentPayLaterReferenceNumber(
                            String installmentPayLaterReferenceNumber) {
                        this.installmentPayLaterReferenceNumber = installmentPayLaterReferenceNumber;
                    }

                    /** 
                     * Get the 'Reference' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getInstallmentReference() {
                        return installmentReference;
                    }

                    /** 
                     * Set the 'Reference' attribute value.
                     * 
                     * @param installmentReference
                     */
                    public void setInstallmentReference(
                            BigInteger installmentReference) {
                        this.installmentReference = installmentReference;
                    }

                    /** 
                     * Get the 'Value' attribute value.
                     * 
                     * @return value
                     */
                    public String getInstallmentValue() {
                        return installmentValue;
                    }

                    /** 
                     * Set the 'Value' attribute value.
                     * 
                     * @param installmentValue
                     */
                    public void setInstallmentValue(String installmentValue) {
                        this.installmentValue = installmentValue;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="PaymentCard">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ExpireDate"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                     *           &lt;xs:attribute type="xs:integer" use="optional" name="Number"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CCInfo implements Serializable
                    {
                        private String paymentCardCode;
                        private String paymentCardExpireDate;
                        private String paymentCardManualApprovalCode;
                        private BigInteger paymentCardNumber;

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardCode() {
                            return paymentCardCode;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param paymentCardCode
                         */
                        public void setPaymentCardCode(String paymentCardCode) {
                            this.paymentCardCode = paymentCardCode;
                        }

                        /** 
                         * Get the 'ExpireDate' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardExpireDate() {
                            return paymentCardExpireDate;
                        }

                        /** 
                         * Set the 'ExpireDate' attribute value.
                         * 
                         * @param paymentCardExpireDate
                         */
                        public void setPaymentCardExpireDate(
                                String paymentCardExpireDate) {
                            this.paymentCardExpireDate = paymentCardExpireDate;
                        }

                        /** 
                         * Get the 'ManualApprovalCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardManualApprovalCode() {
                            return paymentCardManualApprovalCode;
                        }

                        /** 
                         * Set the 'ManualApprovalCode' attribute value.
                         * 
                         * @param paymentCardManualApprovalCode
                         */
                        public void setPaymentCardManualApprovalCode(
                                String paymentCardManualApprovalCode) {
                            this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                        }

                        /** 
                         * Get the 'Number' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardNumber() {
                            return paymentCardNumber;
                        }

                        /** 
                         * Set the 'Number' attribute value.
                         * 
                         * @param paymentCardNumber
                         */
                        public void setPaymentCardNumber(
                                BigInteger paymentCardNumber) {
                            this.paymentCardNumber = paymentCardNumber;
                        }
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MultipleCC_FOP" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Fare">
             *         &lt;xs:complexType>
             *           &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *       &lt;xs:element name="CC_One">
             *         &lt;xs:complexType>
             *           &lt;xs:sequence>
             *             &lt;xs:element name="CC_Info" minOccurs="0">
             *               &lt;!-- Reference to inner class CCInfo -->
             *             &lt;/xs:element>
             *           &lt;/xs:sequence>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *       &lt;xs:element name="CC_Two">
             *         &lt;xs:complexType>
             *           &lt;xs:sequence>
             *             &lt;xs:element name="CC_Info" minOccurs="0">
             *               &lt;!-- Reference to inner class CCInfo1 -->
             *             &lt;/xs:element>
             *           &lt;/xs:sequence>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class MultipleCCFOP implements Serializable
            {
                private String fare;
                private CCInfo CCOne;
                private CCInfo1 CCTwo;

                /** 
                 * Get the 'Amount' attribute value.
                 * 
                 * @return value
                 */
                public String getFare() {
                    return fare;
                }

                /** 
                 * Set the 'Amount' attribute value.
                 * 
                 * @param fare
                 */
                public void setFare(String fare) {
                    this.fare = fare;
                }

                /** 
                 * Get the 'CC_Info' element value.
                 * 
                 * @return value
                 */
                public CCInfo getCCOne() {
                    return CCOne;
                }

                /** 
                 * Set the 'CC_Info' element value.
                 * 
                 * @param CCOne
                 */
                public void setCCOne(CCInfo CCOne) {
                    this.CCOne = CCOne;
                }

                /** 
                 * Get the 'CC_Info' element value.
                 * 
                 * @return value
                 */
                public CCInfo1 getCCTwo() {
                    return CCTwo;
                }

                /** 
                 * Set the 'CC_Info' element value.
                 * 
                 * @param CCTwo
                 */
                public void setCCTwo(CCInfo1 CCTwo) {
                    this.CCTwo = CCTwo;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="PaymentCard">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                 *           &lt;xs:attribute type="xs:string" use="required" name="ExpireDate"/>
                 *           &lt;xs:attribute type="xs:integer" use="optional" name="ExtendedPayment"/>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                 *           &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Suppress"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class CCInfo implements Serializable
                {
                    private String paymentCardCode;
                    private String paymentCardExpireDate;
                    private BigInteger paymentCardExtendedPayment;
                    private String paymentCardManualApprovalCode;
                    private BigInteger paymentCardNumber;
                    private Boolean suppress;

                    /** 
                     * Get the 'Code' attribute value.
                     * 
                     * @return value
                     */
                    public String getPaymentCardCode() {
                        return paymentCardCode;
                    }

                    /** 
                     * Set the 'Code' attribute value.
                     * 
                     * @param paymentCardCode
                     */
                    public void setPaymentCardCode(String paymentCardCode) {
                        this.paymentCardCode = paymentCardCode;
                    }

                    /** 
                     * Get the 'ExpireDate' attribute value.
                     * 
                     * @return value
                     */
                    public String getPaymentCardExpireDate() {
                        return paymentCardExpireDate;
                    }

                    /** 
                     * Set the 'ExpireDate' attribute value.
                     * 
                     * @param paymentCardExpireDate
                     */
                    public void setPaymentCardExpireDate(
                            String paymentCardExpireDate) {
                        this.paymentCardExpireDate = paymentCardExpireDate;
                    }

                    /** 
                     * Get the 'ExtendedPayment' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getPaymentCardExtendedPayment() {
                        return paymentCardExtendedPayment;
                    }

                    /** 
                     * Set the 'ExtendedPayment' attribute value.
                     * 
                     * @param paymentCardExtendedPayment
                     */
                    public void setPaymentCardExtendedPayment(
                            BigInteger paymentCardExtendedPayment) {
                        this.paymentCardExtendedPayment = paymentCardExtendedPayment;
                    }

                    /** 
                     * Get the 'ManualApprovalCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getPaymentCardManualApprovalCode() {
                        return paymentCardManualApprovalCode;
                    }

                    /** 
                     * Set the 'ManualApprovalCode' attribute value.
                     * 
                     * @param paymentCardManualApprovalCode
                     */
                    public void setPaymentCardManualApprovalCode(
                            String paymentCardManualApprovalCode) {
                        this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                    }

                    /** 
                     * Get the 'Number' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getPaymentCardNumber() {
                        return paymentCardNumber;
                    }

                    /** 
                     * Set the 'Number' attribute value.
                     * 
                     * @param paymentCardNumber
                     */
                    public void setPaymentCardNumber(
                            BigInteger paymentCardNumber) {
                        this.paymentCardNumber = paymentCardNumber;
                    }

                    /** 
                     * Get the 'Suppress' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getSuppress() {
                        return suppress;
                    }

                    /** 
                     * Set the 'Suppress' attribute value.
                     * 
                     * @param suppress
                     */
                    public void setSuppress(Boolean suppress) {
                        this.suppress = suppress;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="PaymentCard">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                 *           &lt;xs:attribute type="xs:string" use="required" name="ExpireDate"/>
                 *           &lt;xs:attribute type="xs:integer" use="optional" name="ExtendedPayment"/>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                 *           &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Suppress"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class CCInfo1 implements Serializable
                {
                    private String paymentCardCode;
                    private String paymentCardExpireDate;
                    private BigInteger paymentCardExtendedPayment;
                    private String paymentCardManualApprovalCode;
                    private BigInteger paymentCardNumber;
                    private Boolean suppress;

                    /** 
                     * Get the 'Code' attribute value.
                     * 
                     * @return value
                     */
                    public String getPaymentCardCode() {
                        return paymentCardCode;
                    }

                    /** 
                     * Set the 'Code' attribute value.
                     * 
                     * @param paymentCardCode
                     */
                    public void setPaymentCardCode(String paymentCardCode) {
                        this.paymentCardCode = paymentCardCode;
                    }

                    /** 
                     * Get the 'ExpireDate' attribute value.
                     * 
                     * @return value
                     */
                    public String getPaymentCardExpireDate() {
                        return paymentCardExpireDate;
                    }

                    /** 
                     * Set the 'ExpireDate' attribute value.
                     * 
                     * @param paymentCardExpireDate
                     */
                    public void setPaymentCardExpireDate(
                            String paymentCardExpireDate) {
                        this.paymentCardExpireDate = paymentCardExpireDate;
                    }

                    /** 
                     * Get the 'ExtendedPayment' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getPaymentCardExtendedPayment() {
                        return paymentCardExtendedPayment;
                    }

                    /** 
                     * Set the 'ExtendedPayment' attribute value.
                     * 
                     * @param paymentCardExtendedPayment
                     */
                    public void setPaymentCardExtendedPayment(
                            BigInteger paymentCardExtendedPayment) {
                        this.paymentCardExtendedPayment = paymentCardExtendedPayment;
                    }

                    /** 
                     * Get the 'ManualApprovalCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getPaymentCardManualApprovalCode() {
                        return paymentCardManualApprovalCode;
                    }

                    /** 
                     * Set the 'ManualApprovalCode' attribute value.
                     * 
                     * @param paymentCardManualApprovalCode
                     */
                    public void setPaymentCardManualApprovalCode(
                            String paymentCardManualApprovalCode) {
                        this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                    }

                    /** 
                     * Get the 'Number' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getPaymentCardNumber() {
                        return paymentCardNumber;
                    }

                    /** 
                     * Set the 'Number' attribute value.
                     * 
                     * @param paymentCardNumber
                     */
                    public void setPaymentCardNumber(
                            BigInteger paymentCardNumber) {
                        this.paymentCardNumber = paymentCardNumber;
                    }

                    /** 
                     * Get the 'Suppress' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getSuppress() {
                        return suppress;
                    }

                    /** 
                     * Set the 'Suppress' attribute value.
                     * 
                     * @param suppress
                     */
                    public void setSuppress(Boolean suppress) {
                        this.suppress = suppress;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SabreSonicTicketing" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="BasicFOP" minOccurs="0">
             *         &lt;!-- Reference to inner class BasicFOP -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="EnhancedMultipleFOP" minOccurs="0">
             *         &lt;!-- Reference to inner class EnhancedMultipleFOP -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="MultipleFOP" minOccurs="0">
             *         &lt;!-- Reference to inner class MultipleFOP -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class SabreSonicTicketing implements Serializable
            {
                private BasicFOP basicFOP;
                private EnhancedMultipleFOP enhancedMultipleFOP;
                private MultipleFOP multipleFOP;

                /** 
                 * Get the 'BasicFOP' element value.
                 * 
                 * @return value
                 */
                public BasicFOP getBasicFOP() {
                    return basicFOP;
                }

                /** 
                 * Set the 'BasicFOP' element value.
                 * 
                 * @param basicFOP
                 */
                public void setBasicFOP(BasicFOP basicFOP) {
                    this.basicFOP = basicFOP;
                }

                /** 
                 * Get the 'EnhancedMultipleFOP' element value.
                 * 
                 * @return value
                 */
                public EnhancedMultipleFOP getEnhancedMultipleFOP() {
                    return enhancedMultipleFOP;
                }

                /** 
                 * Set the 'EnhancedMultipleFOP' element value.
                 * 
                 * @param enhancedMultipleFOP
                 */
                public void setEnhancedMultipleFOP(
                        EnhancedMultipleFOP enhancedMultipleFOP) {
                    this.enhancedMultipleFOP = enhancedMultipleFOP;
                }

                /** 
                 * Get the 'MultipleFOP' element value.
                 * 
                 * @return value
                 */
                public MultipleFOP getMultipleFOP() {
                    return multipleFOP;
                }

                /** 
                 * Set the 'MultipleFOP' element value.
                 * 
                 * @param multipleFOP
                 */
                public void setMultipleFOP(MultipleFOP multipleFOP) {
                    this.multipleFOP = multipleFOP;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BasicFOP" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="CC_Info" minOccurs="0">
                 *         &lt;!-- Reference to inner class CCInfo -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class BasicFOP implements Serializable
                {
                    private CCInfo CCInfo1;
                    private String manualApprovalCode;
                    private String type;

                    /** 
                     * Get the 'CC_Info' element value.
                     * 
                     * @return value
                     */
                    public CCInfo getCCInfo1() {
                        return CCInfo1;
                    }

                    /** 
                     * Set the 'CC_Info' element value.
                     * 
                     * @param CCInfo1
                     */
                    public void setCCInfo1(CCInfo CCInfo1) {
                        this.CCInfo1 = CCInfo1;
                    }

                    /** 
                     * Get the 'ManualApprovalCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getManualApprovalCode() {
                        return manualApprovalCode;
                    }

                    /** 
                     * Set the 'ManualApprovalCode' attribute value.
                     * 
                     * @param manualApprovalCode
                     */
                    public void setManualApprovalCode(String manualApprovalCode) {
                        this.manualApprovalCode = manualApprovalCode;
                    }

                    /** 
                     * Get the 'Type' attribute value.
                     * 
                     * @return value
                     */
                    public String getType() {
                        return type;
                    }

                    /** 
                     * Set the 'Type' attribute value.
                     * 
                     * @param type
                     */
                    public void setType(String type) {
                        this.type = type;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="PaymentCard">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:integer" use="optional" name="CardSecurityCode"/>
                     *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                     *           &lt;xs:attribute type="xs:string" use="required" name="ExpireDate"/>
                     *           &lt;xs:attribute type="xs:integer" use="optional" name="ExtendedPayment"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                     *           &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="Suppress"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CCInfo implements Serializable
                    {
                        private BigInteger paymentCardCardSecurityCode;
                        private String paymentCardCode;
                        private String paymentCardExpireDate;
                        private BigInteger paymentCardExtendedPayment;
                        private String paymentCardManualApprovalCode;
                        private BigInteger paymentCardNumber;
                        private Boolean suppress;

                        /** 
                         * Get the 'CardSecurityCode' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardCardSecurityCode() {
                            return paymentCardCardSecurityCode;
                        }

                        /** 
                         * Set the 'CardSecurityCode' attribute value.
                         * 
                         * @param paymentCardCardSecurityCode
                         */
                        public void setPaymentCardCardSecurityCode(
                                BigInteger paymentCardCardSecurityCode) {
                            this.paymentCardCardSecurityCode = paymentCardCardSecurityCode;
                        }

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardCode() {
                            return paymentCardCode;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param paymentCardCode
                         */
                        public void setPaymentCardCode(String paymentCardCode) {
                            this.paymentCardCode = paymentCardCode;
                        }

                        /** 
                         * Get the 'ExpireDate' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardExpireDate() {
                            return paymentCardExpireDate;
                        }

                        /** 
                         * Set the 'ExpireDate' attribute value.
                         * 
                         * @param paymentCardExpireDate
                         */
                        public void setPaymentCardExpireDate(
                                String paymentCardExpireDate) {
                            this.paymentCardExpireDate = paymentCardExpireDate;
                        }

                        /** 
                         * Get the 'ExtendedPayment' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardExtendedPayment() {
                            return paymentCardExtendedPayment;
                        }

                        /** 
                         * Set the 'ExtendedPayment' attribute value.
                         * 
                         * @param paymentCardExtendedPayment
                         */
                        public void setPaymentCardExtendedPayment(
                                BigInteger paymentCardExtendedPayment) {
                            this.paymentCardExtendedPayment = paymentCardExtendedPayment;
                        }

                        /** 
                         * Get the 'ManualApprovalCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardManualApprovalCode() {
                            return paymentCardManualApprovalCode;
                        }

                        /** 
                         * Set the 'ManualApprovalCode' attribute value.
                         * 
                         * @param paymentCardManualApprovalCode
                         */
                        public void setPaymentCardManualApprovalCode(
                                String paymentCardManualApprovalCode) {
                            this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                        }

                        /** 
                         * Get the 'Number' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardNumber() {
                            return paymentCardNumber;
                        }

                        /** 
                         * Set the 'Number' attribute value.
                         * 
                         * @param paymentCardNumber
                         */
                        public void setPaymentCardNumber(
                                BigInteger paymentCardNumber) {
                            this.paymentCardNumber = paymentCardNumber;
                        }

                        /** 
                         * Get the 'Suppress' attribute value.
                         * 
                         * @return value
                         */
                        public Boolean getSuppress() {
                            return suppress;
                        }

                        /** 
                         * Set the 'Suppress' attribute value.
                         * 
                         * @param suppress
                         */
                        public void setSuppress(Boolean suppress) {
                            this.suppress = suppress;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EnhancedMultipleFOP" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Fare">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="FOP_One">
                 *         &lt;xs:complexType>
                 *           &lt;xs:sequence>
                 *             &lt;xs:element name="CC_Info" minOccurs="0">
                 *               &lt;!-- Reference to inner class CCInfo -->
                 *             &lt;/xs:element>
                 *           &lt;/xs:sequence>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="FOP_Two">
                 *         &lt;xs:complexType>
                 *           &lt;xs:sequence>
                 *             &lt;xs:element name="CC_Info" minOccurs="0">
                 *               &lt;!-- Reference to inner class CCInfo1 -->
                 *             &lt;/xs:element>
                 *           &lt;/xs:sequence>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Taxes">
                 *         &lt;xs:complexType>
                 *           &lt;xs:sequence>
                 *             &lt;xs:element name="Tax">
                 *               &lt;xs:complexType>
                 *                 &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                 *                 &lt;xs:attribute type="xs:string" use="required" name="TaxCode"/>
                 *               &lt;/xs:complexType>
                 *             &lt;/xs:element>
                 *           &lt;/xs:sequence>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class EnhancedMultipleFOP implements Serializable
                {
                    private String fare;
                    private CCInfo CCInfo2;
                    private String FOPOneType;
                    private CCInfo1 CCInfo3;
                    private String FOPTwoType;
                    private String taxesTaxAmount;
                    private String taxesTaxTaxCode;

                    /** 
                     * Get the 'Amount' attribute value.
                     * 
                     * @return value
                     */
                    public String getFare() {
                        return fare;
                    }

                    /** 
                     * Set the 'Amount' attribute value.
                     * 
                     * @param fare
                     */
                    public void setFare(String fare) {
                        this.fare = fare;
                    }

                    /** 
                     * Get the 'CC_Info' element value.
                     * 
                     * @return value
                     */
                    public CCInfo getCCInfo2() {
                        return CCInfo2;
                    }

                    /** 
                     * Set the 'CC_Info' element value.
                     * 
                     * @param CCInfo2
                     */
                    public void setCCInfo2(CCInfo CCInfo2) {
                        this.CCInfo2 = CCInfo2;
                    }

                    /** 
                     * Get the 'Type' attribute value.
                     * 
                     * @return value
                     */
                    public String getFOPOneType() {
                        return FOPOneType;
                    }

                    /** 
                     * Set the 'Type' attribute value.
                     * 
                     * @param FOPOneType
                     */
                    public void setFOPOneType(String FOPOneType) {
                        this.FOPOneType = FOPOneType;
                    }

                    /** 
                     * Get the 'CC_Info' element value.
                     * 
                     * @return value
                     */
                    public CCInfo1 getCCInfo3() {
                        return CCInfo3;
                    }

                    /** 
                     * Set the 'CC_Info' element value.
                     * 
                     * @param CCInfo3
                     */
                    public void setCCInfo3(CCInfo1 CCInfo3) {
                        this.CCInfo3 = CCInfo3;
                    }

                    /** 
                     * Get the 'Type' attribute value.
                     * 
                     * @return value
                     */
                    public String getFOPTwoType() {
                        return FOPTwoType;
                    }

                    /** 
                     * Set the 'Type' attribute value.
                     * 
                     * @param FOPTwoType
                     */
                    public void setFOPTwoType(String FOPTwoType) {
                        this.FOPTwoType = FOPTwoType;
                    }

                    /** 
                     * Get the 'Amount' attribute value.
                     * 
                     * @return value
                     */
                    public String getTaxesTaxAmount() {
                        return taxesTaxAmount;
                    }

                    /** 
                     * Set the 'Amount' attribute value.
                     * 
                     * @param taxesTaxAmount
                     */
                    public void setTaxesTaxAmount(String taxesTaxAmount) {
                        this.taxesTaxAmount = taxesTaxAmount;
                    }

                    /** 
                     * Get the 'TaxCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getTaxesTaxTaxCode() {
                        return taxesTaxTaxCode;
                    }

                    /** 
                     * Set the 'TaxCode' attribute value.
                     * 
                     * @param taxesTaxTaxCode
                     */
                    public void setTaxesTaxTaxCode(String taxesTaxTaxCode) {
                        this.taxesTaxTaxCode = taxesTaxTaxCode;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="PaymentCard">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="CardSecurityCode"/>
                     *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                     *           &lt;xs:attribute type="xs:string" use="required" name="ExpireDate"/>
                     *           &lt;xs:attribute type="xs:integer" use="optional" name="ExtendedPayment"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                     *           &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CCInfo implements Serializable
                    {
                        private String paymentCardCardSecurityCode;
                        private String paymentCardCode;
                        private String paymentCardExpireDate;
                        private BigInteger paymentCardExtendedPayment;
                        private String paymentCardManualApprovalCode;
                        private BigInteger paymentCardNumber;

                        /** 
                         * Get the 'CardSecurityCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardCardSecurityCode() {
                            return paymentCardCardSecurityCode;
                        }

                        /** 
                         * Set the 'CardSecurityCode' attribute value.
                         * 
                         * @param paymentCardCardSecurityCode
                         */
                        public void setPaymentCardCardSecurityCode(
                                String paymentCardCardSecurityCode) {
                            this.paymentCardCardSecurityCode = paymentCardCardSecurityCode;
                        }

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardCode() {
                            return paymentCardCode;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param paymentCardCode
                         */
                        public void setPaymentCardCode(String paymentCardCode) {
                            this.paymentCardCode = paymentCardCode;
                        }

                        /** 
                         * Get the 'ExpireDate' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardExpireDate() {
                            return paymentCardExpireDate;
                        }

                        /** 
                         * Set the 'ExpireDate' attribute value.
                         * 
                         * @param paymentCardExpireDate
                         */
                        public void setPaymentCardExpireDate(
                                String paymentCardExpireDate) {
                            this.paymentCardExpireDate = paymentCardExpireDate;
                        }

                        /** 
                         * Get the 'ExtendedPayment' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardExtendedPayment() {
                            return paymentCardExtendedPayment;
                        }

                        /** 
                         * Set the 'ExtendedPayment' attribute value.
                         * 
                         * @param paymentCardExtendedPayment
                         */
                        public void setPaymentCardExtendedPayment(
                                BigInteger paymentCardExtendedPayment) {
                            this.paymentCardExtendedPayment = paymentCardExtendedPayment;
                        }

                        /** 
                         * Get the 'ManualApprovalCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardManualApprovalCode() {
                            return paymentCardManualApprovalCode;
                        }

                        /** 
                         * Set the 'ManualApprovalCode' attribute value.
                         * 
                         * @param paymentCardManualApprovalCode
                         */
                        public void setPaymentCardManualApprovalCode(
                                String paymentCardManualApprovalCode) {
                            this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                        }

                        /** 
                         * Get the 'Number' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardNumber() {
                            return paymentCardNumber;
                        }

                        /** 
                         * Set the 'Number' attribute value.
                         * 
                         * @param paymentCardNumber
                         */
                        public void setPaymentCardNumber(
                                BigInteger paymentCardNumber) {
                            this.paymentCardNumber = paymentCardNumber;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="PaymentCard">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="CardSecurityCode"/>
                     *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                     *           &lt;xs:attribute type="xs:string" use="required" name="ExpireDate"/>
                     *           &lt;xs:attribute type="xs:integer" use="optional" name="ExtendedPayment"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                     *           &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CCInfo1 implements Serializable
                    {
                        private String paymentCardCardSecurityCode;
                        private String paymentCardCode;
                        private String paymentCardExpireDate;
                        private BigInteger paymentCardExtendedPayment;
                        private String paymentCardManualApprovalCode;
                        private BigInteger paymentCardNumber;

                        /** 
                         * Get the 'CardSecurityCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardCardSecurityCode() {
                            return paymentCardCardSecurityCode;
                        }

                        /** 
                         * Set the 'CardSecurityCode' attribute value.
                         * 
                         * @param paymentCardCardSecurityCode
                         */
                        public void setPaymentCardCardSecurityCode(
                                String paymentCardCardSecurityCode) {
                            this.paymentCardCardSecurityCode = paymentCardCardSecurityCode;
                        }

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardCode() {
                            return paymentCardCode;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param paymentCardCode
                         */
                        public void setPaymentCardCode(String paymentCardCode) {
                            this.paymentCardCode = paymentCardCode;
                        }

                        /** 
                         * Get the 'ExpireDate' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardExpireDate() {
                            return paymentCardExpireDate;
                        }

                        /** 
                         * Set the 'ExpireDate' attribute value.
                         * 
                         * @param paymentCardExpireDate
                         */
                        public void setPaymentCardExpireDate(
                                String paymentCardExpireDate) {
                            this.paymentCardExpireDate = paymentCardExpireDate;
                        }

                        /** 
                         * Get the 'ExtendedPayment' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardExtendedPayment() {
                            return paymentCardExtendedPayment;
                        }

                        /** 
                         * Set the 'ExtendedPayment' attribute value.
                         * 
                         * @param paymentCardExtendedPayment
                         */
                        public void setPaymentCardExtendedPayment(
                                BigInteger paymentCardExtendedPayment) {
                            this.paymentCardExtendedPayment = paymentCardExtendedPayment;
                        }

                        /** 
                         * Get the 'ManualApprovalCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardManualApprovalCode() {
                            return paymentCardManualApprovalCode;
                        }

                        /** 
                         * Set the 'ManualApprovalCode' attribute value.
                         * 
                         * @param paymentCardManualApprovalCode
                         */
                        public void setPaymentCardManualApprovalCode(
                                String paymentCardManualApprovalCode) {
                            this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                        }

                        /** 
                         * Get the 'Number' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardNumber() {
                            return paymentCardNumber;
                        }

                        /** 
                         * Set the 'Number' attribute value.
                         * 
                         * @param paymentCardNumber
                         */
                        public void setPaymentCardNumber(
                                BigInteger paymentCardNumber) {
                            this.paymentCardNumber = paymentCardNumber;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MultipleFOP" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Fare">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="FOP_One">
                 *         &lt;xs:complexType>
                 *           &lt;xs:sequence>
                 *             &lt;xs:element name="CC_Info" minOccurs="0">
                 *               &lt;!-- Reference to inner class CCInfo -->
                 *             &lt;/xs:element>
                 *           &lt;/xs:sequence>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="FOP_Two">
                 *         &lt;xs:complexType>
                 *           &lt;xs:sequence>
                 *             &lt;xs:element name="CC_Info" minOccurs="0">
                 *               &lt;!-- Reference to inner class CCInfo1 -->
                 *             &lt;/xs:element>
                 *           &lt;/xs:sequence>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Taxes" minOccurs="0">
                 *         &lt;!-- Reference to inner class Taxes -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class MultipleFOP implements Serializable
                {
                    private String fare;
                    private CCInfo CCInfo2;
                    private String FOPOneType;
                    private CCInfo1 CCInfo3;
                    private String FOPTwoType;
                    private Taxes taxes;

                    /** 
                     * Get the 'Amount' attribute value.
                     * 
                     * @return value
                     */
                    public String getFare() {
                        return fare;
                    }

                    /** 
                     * Set the 'Amount' attribute value.
                     * 
                     * @param fare
                     */
                    public void setFare(String fare) {
                        this.fare = fare;
                    }

                    /** 
                     * Get the 'CC_Info' element value.
                     * 
                     * @return value
                     */
                    public CCInfo getCCInfo2() {
                        return CCInfo2;
                    }

                    /** 
                     * Set the 'CC_Info' element value.
                     * 
                     * @param CCInfo2
                     */
                    public void setCCInfo2(CCInfo CCInfo2) {
                        this.CCInfo2 = CCInfo2;
                    }

                    /** 
                     * Get the 'Type' attribute value.
                     * 
                     * @return value
                     */
                    public String getFOPOneType() {
                        return FOPOneType;
                    }

                    /** 
                     * Set the 'Type' attribute value.
                     * 
                     * @param FOPOneType
                     */
                    public void setFOPOneType(String FOPOneType) {
                        this.FOPOneType = FOPOneType;
                    }

                    /** 
                     * Get the 'CC_Info' element value.
                     * 
                     * @return value
                     */
                    public CCInfo1 getCCInfo3() {
                        return CCInfo3;
                    }

                    /** 
                     * Set the 'CC_Info' element value.
                     * 
                     * @param CCInfo3
                     */
                    public void setCCInfo3(CCInfo1 CCInfo3) {
                        this.CCInfo3 = CCInfo3;
                    }

                    /** 
                     * Get the 'Type' attribute value.
                     * 
                     * @return value
                     */
                    public String getFOPTwoType() {
                        return FOPTwoType;
                    }

                    /** 
                     * Set the 'Type' attribute value.
                     * 
                     * @param FOPTwoType
                     */
                    public void setFOPTwoType(String FOPTwoType) {
                        this.FOPTwoType = FOPTwoType;
                    }

                    /** 
                     * Get the 'Taxes' element value.
                     * 
                     * @return value
                     */
                    public Taxes getTaxes() {
                        return taxes;
                    }

                    /** 
                     * Set the 'Taxes' element value.
                     * 
                     * @param taxes
                     */
                    public void setTaxes(Taxes taxes) {
                        this.taxes = taxes;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="PaymentCard">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                     *           &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CCInfo implements Serializable
                    {
                        private String paymentCardCode;
                        private String paymentCardManualApprovalCode;
                        private BigInteger paymentCardNumber;

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardCode() {
                            return paymentCardCode;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param paymentCardCode
                         */
                        public void setPaymentCardCode(String paymentCardCode) {
                            this.paymentCardCode = paymentCardCode;
                        }

                        /** 
                         * Get the 'ManualApprovalCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardManualApprovalCode() {
                            return paymentCardManualApprovalCode;
                        }

                        /** 
                         * Set the 'ManualApprovalCode' attribute value.
                         * 
                         * @param paymentCardManualApprovalCode
                         */
                        public void setPaymentCardManualApprovalCode(
                                String paymentCardManualApprovalCode) {
                            this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                        }

                        /** 
                         * Get the 'Number' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardNumber() {
                            return paymentCardNumber;
                        }

                        /** 
                         * Set the 'Number' attribute value.
                         * 
                         * @param paymentCardNumber
                         */
                        public void setPaymentCardNumber(
                                BigInteger paymentCardNumber) {
                            this.paymentCardNumber = paymentCardNumber;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="PaymentCard">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                     *           &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CCInfo1 implements Serializable
                    {
                        private String paymentCardCode;
                        private String paymentCardManualApprovalCode;
                        private BigInteger paymentCardNumber;

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardCode() {
                            return paymentCardCode;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param paymentCardCode
                         */
                        public void setPaymentCardCode(String paymentCardCode) {
                            this.paymentCardCode = paymentCardCode;
                        }

                        /** 
                         * Get the 'ManualApprovalCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardManualApprovalCode() {
                            return paymentCardManualApprovalCode;
                        }

                        /** 
                         * Set the 'ManualApprovalCode' attribute value.
                         * 
                         * @param paymentCardManualApprovalCode
                         */
                        public void setPaymentCardManualApprovalCode(
                                String paymentCardManualApprovalCode) {
                            this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                        }

                        /** 
                         * Get the 'Number' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardNumber() {
                            return paymentCardNumber;
                        }

                        /** 
                         * Set the 'Number' attribute value.
                         * 
                         * @param paymentCardNumber
                         */
                        public void setPaymentCardNumber(
                                BigInteger paymentCardNumber) {
                            this.paymentCardNumber = paymentCardNumber;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Tax">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                     *           &lt;xs:attribute type="xs:string" use="required" name="TaxCode"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Taxes implements Serializable
                    {
                        private String taxAmount;
                        private String taxTaxCode;

                        /** 
                         * Get the 'Amount' attribute value.
                         * 
                         * @return value
                         */
                        public String getTaxAmount() {
                            return taxAmount;
                        }

                        /** 
                         * Set the 'Amount' attribute value.
                         * 
                         * @param taxAmount
                         */
                        public void setTaxAmount(String taxAmount) {
                            this.taxAmount = taxAmount;
                        }

                        /** 
                         * Get the 'TaxCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getTaxTaxCode() {
                            return taxTaxCode;
                        }

                        /** 
                         * Set the 'TaxCode' attribute value.
                         * 
                         * @param taxTaxCode
                         */
                        public void setTaxTaxCode(String taxTaxCode) {
                            this.taxTaxCode = taxTaxCode;
                        }
                    }
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MiscQualifiers" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="AirExtras" minOccurs="0">
         *         &lt;!-- Reference to inner class AirExtras -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="BaggageAllowance" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class BaggageAllowance -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Commission" minOccurs="0">
         *         &lt;!-- Reference to inner class Commission -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Customer" minOccurs="0">
         *         &lt;!-- Reference to inner class Customer -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Endorsements" minOccurs="0">
         *         &lt;!-- Reference to inner class Endorsements -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="HemisphereCode" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="JourneyCode" minOccurs="0"/>
         *       &lt;xs:element name="MultiTicket" minOccurs="0">
         *         &lt;!-- Reference to inner class MultiTicket -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="TourCode" minOccurs="0">
         *         &lt;!-- Reference to inner class TourCode -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="ValidationMethod" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class MiscQualifiers implements Serializable
        {
            private AirExtras airExtras;
            private List<BaggageAllowance> baggageAllowanceList = new ArrayList<BaggageAllowance>();
            private Commission commission;
            private Customer customer;
            private Endorsements endorsements;
            private String hemisphereCode;
            private String journeyCode;
            private MultiTicket multiTicket;
            private TourCode tourCode;
            private String validationMethod;

            /** 
             * Get the 'AirExtras' element value.
             * 
             * @return value
             */
            public AirExtras getAirExtras() {
                return airExtras;
            }

            /** 
             * Set the 'AirExtras' element value.
             * 
             * @param airExtras
             */
            public void setAirExtras(AirExtras airExtras) {
                this.airExtras = airExtras;
            }

            /** 
             * Get the list of 'BaggageAllowance' element items.
             * 
             * @return list
             */
            public List<BaggageAllowance> getBaggageAllowanceList() {
                return baggageAllowanceList;
            }

            /** 
             * Set the list of 'BaggageAllowance' element items.
             * 
             * @param list
             */
            public void setBaggageAllowanceList(List<BaggageAllowance> list) {
                baggageAllowanceList = list;
            }

            /** 
             * Get the 'Commission' element value.
             * 
             * @return value
             */
            public Commission getCommission() {
                return commission;
            }

            /** 
             * Set the 'Commission' element value.
             * 
             * @param commission
             */
            public void setCommission(Commission commission) {
                this.commission = commission;
            }

            /** 
             * Get the 'Customer' element value.
             * 
             * @return value
             */
            public Customer getCustomer() {
                return customer;
            }

            /** 
             * Set the 'Customer' element value.
             * 
             * @param customer
             */
            public void setCustomer(Customer customer) {
                this.customer = customer;
            }

            /** 
             * Get the 'Endorsements' element value.
             * 
             * @return value
             */
            public Endorsements getEndorsements() {
                return endorsements;
            }

            /** 
             * Set the 'Endorsements' element value.
             * 
             * @param endorsements
             */
            public void setEndorsements(Endorsements endorsements) {
                this.endorsements = endorsements;
            }

            /** 
             * Get the 'HemisphereCode' element value.
             * 
             * @return value
             */
            public String getHemisphereCode() {
                return hemisphereCode;
            }

            /** 
             * Set the 'HemisphereCode' element value.
             * 
             * @param hemisphereCode
             */
            public void setHemisphereCode(String hemisphereCode) {
                this.hemisphereCode = hemisphereCode;
            }

            /** 
             * Get the 'JourneyCode' element value.
             * 
             * @return value
             */
            public String getJourneyCode() {
                return journeyCode;
            }

            /** 
             * Set the 'JourneyCode' element value.
             * 
             * @param journeyCode
             */
            public void setJourneyCode(String journeyCode) {
                this.journeyCode = journeyCode;
            }

            /** 
             * Get the 'MultiTicket' element value.
             * 
             * @return value
             */
            public MultiTicket getMultiTicket() {
                return multiTicket;
            }

            /** 
             * Set the 'MultiTicket' element value.
             * 
             * @param multiTicket
             */
            public void setMultiTicket(MultiTicket multiTicket) {
                this.multiTicket = multiTicket;
            }

            /** 
             * Get the 'TourCode' element value.
             * 
             * @return value
             */
            public TourCode getTourCode() {
                return tourCode;
            }

            /** 
             * Set the 'TourCode' element value.
             * 
             * @param tourCode
             */
            public void setTourCode(TourCode tourCode) {
                this.tourCode = tourCode;
            }

            /** 
             * Get the 'ValidationMethod' element value.
             * 
             * @return value
             */
            public String getValidationMethod() {
                return validationMethod;
            }

            /** 
             * Set the 'ValidationMethod' element value.
             * 
             * @param validationMethod
             */
            public void setValidationMethod(String validationMethod) {
                this.validationMethod = validationMethod;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirExtras" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="CustLoyalty" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class CustLoyalty -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="Qualifier" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element type="xs:string" name="SSR_Code" minOccurs="0" maxOccurs="26"/>
             *       &lt;xs:element name="Ticketing" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class Ticketing -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="Summary"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AirExtras implements Serializable
            {
                private List<CustLoyalty> custLoyaltyList = new ArrayList<CustLoyalty>();
                private List<String> qualifierList = new ArrayList<String>();
                private List<String> SSRCodeList = new ArrayList<String>();
                private List<Ticketing> ticketingList = new ArrayList<Ticketing>();
                private boolean ind;
                private Boolean summary;

                /** 
                 * Get the list of 'CustLoyalty' element items.
                 * 
                 * @return list
                 */
                public List<CustLoyalty> getCustLoyaltyList() {
                    return custLoyaltyList;
                }

                /** 
                 * Set the list of 'CustLoyalty' element items.
                 * 
                 * @param list
                 */
                public void setCustLoyaltyList(List<CustLoyalty> list) {
                    custLoyaltyList = list;
                }

                /** 
                 * Get the list of 'Qualifier' element items.
                 * 
                 * @return list
                 */
                public List<String> getQualifierList() {
                    return qualifierList;
                }

                /** 
                 * Set the list of 'Qualifier' element items.
                 * 
                 * @param list
                 */
                public void setQualifierList(List<String> list) {
                    qualifierList = list;
                }

                /** 
                 * Get the list of 'SSR_Code' element items.
                 * 
                 * @return list
                 */
                public List<String> getSSRCodeList() {
                    return SSRCodeList;
                }

                /** 
                 * Set the list of 'SSR_Code' element items.
                 * 
                 * @param list
                 */
                public void setSSRCodeList(List<String> list) {
                    SSRCodeList = list;
                }

                /** 
                 * Get the list of 'Ticketing' element items.
                 * 
                 * @return list
                 */
                public List<Ticketing> getTicketingList() {
                    return ticketingList;
                }

                /** 
                 * Set the list of 'Ticketing' element items.
                 * 
                 * @param list
                 */
                public void setTicketingList(List<Ticketing> list) {
                    ticketingList = list;
                }

                /** 
                 * Get the 'Ind' attribute value.
                 * 
                 * @return value
                 */
                public boolean isInd() {
                    return ind;
                }

                /** 
                 * Set the 'Ind' attribute value.
                 * 
                 * @param ind
                 */
                public void setInd(boolean ind) {
                    this.ind = ind;
                }

                /** 
                 * Get the 'Summary' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getSummary() {
                    return summary;
                }

                /** 
                 * Set the 'Summary' attribute value.
                 * 
                 * @param summary
                 */
                public void setSummary(Boolean summary) {
                    this.summary = summary;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CustLoyalty" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="ProgramID"/>
                 *     &lt;xs:attribute type="xs:string" use="required" name="TierLevel"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class CustLoyalty implements Serializable
                {
                    private String programID;
                    private String tierLevel;

                    /** 
                     * Get the 'ProgramID' attribute value.
                     * 
                     * @return value
                     */
                    public String getProgramID() {
                        return programID;
                    }

                    /** 
                     * Set the 'ProgramID' attribute value.
                     * 
                     * @param programID
                     */
                    public void setProgramID(String programID) {
                        this.programID = programID;
                    }

                    /** 
                     * Get the 'TierLevel' attribute value.
                     * 
                     * @return value
                     */
                    public String getTierLevel() {
                        return tierLevel;
                    }

                    /** 
                     * Set the 'TierLevel' attribute value.
                     * 
                     * @param tierLevel
                     */
                    public void setTierLevel(String tierLevel) {
                        this.tierLevel = tierLevel;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Ticketing" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:integer" use="optional" name="EndNumber"/>
                 *     &lt;xs:attribute type="xs:integer" use="optional" name="eTicketNumber"/>
                 *     &lt;xs:attribute type="xs:integer" use="optional" name="Number"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Ticketing implements Serializable
                {
                    private BigInteger endNumber;
                    private BigInteger ETicketNumber;
                    private BigInteger number;

                    /** 
                     * Get the 'EndNumber' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getEndNumber() {
                        return endNumber;
                    }

                    /** 
                     * Set the 'EndNumber' attribute value.
                     * 
                     * @param endNumber
                     */
                    public void setEndNumber(BigInteger endNumber) {
                        this.endNumber = endNumber;
                    }

                    /** 
                     * Get the 'eTicketNumber' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getETicketNumber() {
                        return ETicketNumber;
                    }

                    /** 
                     * Set the 'eTicketNumber' attribute value.
                     * 
                     * @param eTicketNumber
                     */
                    public void setETicketNumber(BigInteger eTicketNumber) {
                        ETicketNumber = eTicketNumber;
                    }

                    /** 
                     * Get the 'Number' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'Number' attribute value.
                     * 
                     * @param number
                     */
                    public void setNumber(BigInteger number) {
                        this.number = number;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageAllowance" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Segment" minOccurs="0">
             *         &lt;!-- Reference to inner class Segment -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Number"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Weight"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class BaggageAllowance implements Serializable
            {
                private Segment segment;
                private String number;
                private String weight;

                /** 
                 * Get the 'Segment' element value.
                 * 
                 * @return value
                 */
                public Segment getSegment() {
                    return segment;
                }

                /** 
                 * Set the 'Segment' element value.
                 * 
                 * @param segment
                 */
                public void setSegment(Segment segment) {
                    this.segment = segment;
                }

                /** 
                 * Get the 'Number' attribute value.
                 * 
                 * @return value
                 */
                public String getNumber() {
                    return number;
                }

                /** 
                 * Set the 'Number' attribute value.
                 * 
                 * @param number
                 */
                public void setNumber(String number) {
                    this.number = number;
                }

                /** 
                 * Get the 'Weight' attribute value.
                 * 
                 * @return value
                 */
                public String getWeight() {
                    return weight;
                }

                /** 
                 * Set the 'Weight' attribute value.
                 * 
                 * @param weight
                 */
                public void setWeight(String weight) {
                    this.weight = weight;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Segment" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Number"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="EndNumber"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Segment implements Serializable
                {
                    private String number;
                    private String endNumber;

                    /** 
                     * Get the 'Number' attribute value.
                     * 
                     * @return value
                     */
                    public String getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'Number' attribute value.
                     * 
                     * @param number
                     */
                    public void setNumber(String number) {
                        this.number = number;
                    }

                    /** 
                     * Get the 'EndNumber' attribute value.
                     * 
                     * @return value
                     */
                    public String getEndNumber() {
                        return endNumber;
                    }

                    /** 
                     * Set the 'EndNumber' attribute value.
                     * 
                     * @param endNumber
                     */
                    public void setEndNumber(String endNumber) {
                        this.endNumber = endNumber;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Commission" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Percent"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Commission implements Serializable
            {
                private String amount;
                private String percent;

                /** 
                 * Get the 'Amount' attribute value.
                 * 
                 * @return value
                 */
                public String getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' attribute value.
                 * 
                 * @param amount
                 */
                public void setAmount(String amount) {
                    this.amount = amount;
                }

                /** 
                 * Get the 'Percent' attribute value.
                 * 
                 * @return value
                 */
                public String getPercent() {
                    return percent;
                }

                /** 
                 * Set the 'Percent' attribute value.
                 * 
                 * @param percent
                 */
                public void setPercent(String percent) {
                    this.percent = percent;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Customer" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Number"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Customer implements Serializable
            {
                private String number;

                /** 
                 * Get the 'Number' attribute value.
                 * 
                 * @return value
                 */
                public String getNumber() {
                    return number;
                }

                /** 
                 * Set the 'Number' attribute value.
                 * 
                 * @param number
                 */
                public void setNumber(String number) {
                    this.number = number;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Endorsements" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Text"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="Override"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Endorsements implements Serializable
            {
                private String text;
                private Boolean override;

                /** 
                 * Get the 'Text' element value.
                 * 
                 * @return value
                 */
                public String getText() {
                    return text;
                }

                /** 
                 * Set the 'Text' element value.
                 * 
                 * @param text
                 */
                public void setText(String text) {
                    this.text = text;
                }

                /** 
                 * Get the 'Override' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getOverride() {
                    return override;
                }

                /** 
                 * Set the 'Override' attribute value.
                 * 
                 * @param override
                 */
                public void setOverride(Boolean override) {
                    this.override = override;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MultiTicket" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class MultiTicket implements Serializable
            {
                private boolean ind;

                /** 
                 * Get the 'Ind' attribute value.
                 * 
                 * @return value
                 */
                public boolean isInd() {
                    return ind;
                }

                /** 
                 * Set the 'Ind' attribute value.
                 * 
                 * @param ind
                 */
                public void setInd(boolean ind) {
                    this.ind = ind;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TourCode" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="SuppressFareReplaceWithBT" minOccurs="0">
             *         &lt;!-- Reference to inner class SuppressFareReplaceWithBT -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="SuppressFareReplaceWithIT" minOccurs="0">
             *         &lt;!-- Reference to inner class SuppressFareReplaceWithIT -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="SuppressIT" minOccurs="0">
             *         &lt;!-- Reference to inner class SuppressIT -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="SuppressITSupressFare" minOccurs="0">
             *         &lt;!-- Reference to inner class SuppressITSupressFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class TourCode implements Serializable
            {
                private SuppressFareReplaceWithBT suppressFareReplaceWithBT;
                private SuppressFareReplaceWithIT suppressFareReplaceWithIT;
                private SuppressIT suppressIT;
                private SuppressITSupressFare suppressITSupressFare;
                private String text;

                /** 
                 * Get the 'SuppressFareReplaceWithBT' element value.
                 * 
                 * @return value
                 */
                public SuppressFareReplaceWithBT getSuppressFareReplaceWithBT() {
                    return suppressFareReplaceWithBT;
                }

                /** 
                 * Set the 'SuppressFareReplaceWithBT' element value.
                 * 
                 * @param suppressFareReplaceWithBT
                 */
                public void setSuppressFareReplaceWithBT(
                        SuppressFareReplaceWithBT suppressFareReplaceWithBT) {
                    this.suppressFareReplaceWithBT = suppressFareReplaceWithBT;
                }

                /** 
                 * Get the 'SuppressFareReplaceWithIT' element value.
                 * 
                 * @return value
                 */
                public SuppressFareReplaceWithIT getSuppressFareReplaceWithIT() {
                    return suppressFareReplaceWithIT;
                }

                /** 
                 * Set the 'SuppressFareReplaceWithIT' element value.
                 * 
                 * @param suppressFareReplaceWithIT
                 */
                public void setSuppressFareReplaceWithIT(
                        SuppressFareReplaceWithIT suppressFareReplaceWithIT) {
                    this.suppressFareReplaceWithIT = suppressFareReplaceWithIT;
                }

                /** 
                 * Get the 'SuppressIT' element value.
                 * 
                 * @return value
                 */
                public SuppressIT getSuppressIT() {
                    return suppressIT;
                }

                /** 
                 * Set the 'SuppressIT' element value.
                 * 
                 * @param suppressIT
                 */
                public void setSuppressIT(SuppressIT suppressIT) {
                    this.suppressIT = suppressIT;
                }

                /** 
                 * Get the 'SuppressITSupressFare' element value.
                 * 
                 * @return value
                 */
                public SuppressITSupressFare getSuppressITSupressFare() {
                    return suppressITSupressFare;
                }

                /** 
                 * Set the 'SuppressITSupressFare' element value.
                 * 
                 * @param suppressITSupressFare
                 */
                public void setSuppressITSupressFare(
                        SuppressITSupressFare suppressITSupressFare) {
                    this.suppressITSupressFare = suppressITSupressFare;
                }

                /** 
                 * Get the 'Text' element value.
                 * 
                 * @return value
                 */
                public String getText() {
                    return text;
                }

                /** 
                 * Set the 'Text' element value.
                 * 
                 * @param text
                 */
                public void setText(String text) {
                    this.text = text;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SuppressFareReplaceWithBT" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class SuppressFareReplaceWithBT implements
                    Serializable
                {
                    private boolean ind;

                    /** 
                     * Get the 'Ind' attribute value.
                     * 
                     * @return value
                     */
                    public boolean isInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value.
                     * 
                     * @param ind
                     */
                    public void setInd(boolean ind) {
                        this.ind = ind;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SuppressFareReplaceWithIT" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class SuppressFareReplaceWithIT implements
                    Serializable
                {
                    private boolean ind;

                    /** 
                     * Get the 'Ind' attribute value.
                     * 
                     * @return value
                     */
                    public boolean isInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value.
                     * 
                     * @param ind
                     */
                    public void setInd(boolean ind) {
                        this.ind = ind;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SuppressIT" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class SuppressIT implements Serializable
                {
                    private boolean ind;

                    /** 
                     * Get the 'Ind' attribute value.
                     * 
                     * @return value
                     */
                    public boolean isInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value.
                     * 
                     * @param ind
                     */
                    public void setInd(boolean ind) {
                        this.ind = ind;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SuppressITSupressFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class SuppressITSupressFare implements
                    Serializable
                {
                    private boolean ind;

                    /** 
                     * Get the 'Ind' attribute value.
                     * 
                     * @return value
                     */
                    public boolean isInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value.
                     * 
                     * @param ind
                     */
                    public void setInd(boolean ind) {
                        this.ind = ind;
                    }
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricingQualifiers" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Account" minOccurs="0">
         *         &lt;!-- Reference to inner class Account -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="AlternativePricing" minOccurs="0">
         *         &lt;!-- Reference to inner class AlternativePricing -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="BankersSellingRate" minOccurs="0"/>
         *       &lt;xs:element name="BargainFinder" minOccurs="0">
         *         &lt;!-- Reference to inner class BargainFinder -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="BasicEconomyExclude" minOccurs="0" maxOccurs="5"/>
         *       &lt;xs:element name="Brand" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Brand -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="BuyingDate" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="Cabin" minOccurs="0"/>
         *       &lt;xs:element name="CommandPricing" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class CommandPricing -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="CommissionContract" minOccurs="0" maxOccurs="4"/>
         *       &lt;xs:element name="Corporate" minOccurs="0">
         *         &lt;!-- Reference to inner class Corporate -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Fare" minOccurs="0">
         *         &lt;!-- Reference to inner class Fare -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="FareOptions" minOccurs="0">
         *         &lt;!-- Reference to inner class FareOptions -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="ItineraryOptions" minOccurs="0">
         *         &lt;!-- Reference to inner class ItineraryOptions -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="ManuallyAdjustedSellingLevel" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class ManuallyAdjustedSellingLevel -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="NameSelect" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class NameSelect -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="NetRemit" minOccurs="0">
         *         &lt;!-- Reference to inner class NetRemit -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Overrides" minOccurs="0">
         *         &lt;!-- Reference to inner class Overrides -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="PassengerStatus" minOccurs="0"/>
         *       &lt;xs:element name="PassengerType" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class PassengerType -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="PlusUp" minOccurs="0">
         *         &lt;!-- Reference to inner class PlusUp -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="RetailerRuleQualifier" minOccurs="0">
         *         &lt;!-- Reference to inner class RetailerRuleQualifier -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="ShipsRegistry" minOccurs="0"/>
         *       &lt;xs:element name="SpanishLargeFamilyDiscountLevel" minOccurs="0">
         *         &lt;xs:simpleType>
         *           &lt;!-- Reference to inner class SpanishLargeFamilyDiscountLevel -->
         *         &lt;/xs:simpleType>
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="SpanishResidentDiscount" minOccurs="0"/>
         *       &lt;xs:element name="SpecificFare" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class SpecificFare -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="SpecificPenalty" minOccurs="0">
         *         &lt;!-- Reference to inner class SpecificPenalty -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Taxes" minOccurs="0">
         *         &lt;!-- Reference to inner class Taxes -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="ValidityDates" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class ValidityDates -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="optional" name="AlternateCurrencyCode"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="AggregatedContentExclude"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="FareFocusExclude"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="NoDate"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="RoundTheWorld"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="Source"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PricingQualifiers implements Serializable
        {
            private Account account;
            private AlternativePricing alternativePricing;
            private String bankersSellingRate;
            private BargainFinder bargainFinder;
            private List<String> basicEconomyExcludeList = new ArrayList<String>();
            private List<Brand> brandList = new ArrayList<Brand>();
            private String buyingDate;
            private String cabin;
            private List<CommandPricing> commandPricingList = new ArrayList<CommandPricing>();
            private List<String> commissionContractList = new ArrayList<String>();
            private Corporate corporate;
            private Fare fare;
            private FareOptions fareOptions;
            private ItineraryOptions itineraryOptions;
            private List<ManuallyAdjustedSellingLevel> manuallyAdjustedSellingLevelList = new ArrayList<ManuallyAdjustedSellingLevel>();
            private List<NameSelect> nameSelectList = new ArrayList<NameSelect>();
            private NetRemit netRemit;
            private Overrides overrides;
            private String passengerStatus;
            private List<PassengerType> passengerTypeList = new ArrayList<PassengerType>();
            private PlusUp plusUp;
            private RetailerRuleQualifier retailerRuleQualifier;
            private String shipsRegistry;
            private SpanishLargeFamilyDiscountLevel spanishLargeFamilyDiscountLevel;
            private String spanishResidentDiscount;
            private List<SpecificFare> specificFareList = new ArrayList<SpecificFare>();
            private SpecificPenalty specificPenalty;
            private Taxes taxes;
            private List<ValidityDates> validityDateList = new ArrayList<ValidityDates>();
            private String alternateCurrencyCode;
            private String currencyCode;
            private Boolean aggregatedContentExclude;
            private Boolean fareFocusExclude;
            private Boolean noDate;
            private Boolean roundTheWorld;
            private String source;

            /** 
             * Get the 'Account' element value.
             * 
             * @return value
             */
            public Account getAccount() {
                return account;
            }

            /** 
             * Set the 'Account' element value.
             * 
             * @param account
             */
            public void setAccount(Account account) {
                this.account = account;
            }

            /** 
             * Get the 'AlternativePricing' element value.
             * 
             * @return value
             */
            public AlternativePricing getAlternativePricing() {
                return alternativePricing;
            }

            /** 
             * Set the 'AlternativePricing' element value.
             * 
             * @param alternativePricing
             */
            public void setAlternativePricing(
                    AlternativePricing alternativePricing) {
                this.alternativePricing = alternativePricing;
            }

            /** 
             * Get the 'BankersSellingRate' element value.
             * 
             * @return value
             */
            public String getBankersSellingRate() {
                return bankersSellingRate;
            }

            /** 
             * Set the 'BankersSellingRate' element value.
             * 
             * @param bankersSellingRate
             */
            public void setBankersSellingRate(String bankersSellingRate) {
                this.bankersSellingRate = bankersSellingRate;
            }

            /** 
             * Get the 'BargainFinder' element value.
             * 
             * @return value
             */
            public BargainFinder getBargainFinder() {
                return bargainFinder;
            }

            /** 
             * Set the 'BargainFinder' element value.
             * 
             * @param bargainFinder
             */
            public void setBargainFinder(BargainFinder bargainFinder) {
                this.bargainFinder = bargainFinder;
            }

            /** 
             * Get the list of 'BasicEconomyExclude' element items.
             * 
             * @return list
             */
            public List<String> getBasicEconomyExcludeList() {
                return basicEconomyExcludeList;
            }

            /** 
             * Set the list of 'BasicEconomyExclude' element items.
             * 
             * @param list
             */
            public void setBasicEconomyExcludeList(List<String> list) {
                basicEconomyExcludeList = list;
            }

            /** 
             * Get the list of 'Brand' element items.
             * 
             * @return list
             */
            public List<Brand> getBrandList() {
                return brandList;
            }

            /** 
             * Set the list of 'Brand' element items.
             * 
             * @param list
             */
            public void setBrandList(List<Brand> list) {
                brandList = list;
            }

            /** 
             * Get the 'BuyingDate' element value.
             * 
             * @return value
             */
            public String getBuyingDate() {
                return buyingDate;
            }

            /** 
             * Set the 'BuyingDate' element value.
             * 
             * @param buyingDate
             */
            public void setBuyingDate(String buyingDate) {
                this.buyingDate = buyingDate;
            }

            /** 
             * Get the 'Cabin' element value.
             * 
             * @return value
             */
            public String getCabin() {
                return cabin;
            }

            /** 
             * Set the 'Cabin' element value.
             * 
             * @param cabin
             */
            public void setCabin(String cabin) {
                this.cabin = cabin;
            }

            /** 
             * Get the list of 'CommandPricing' element items.
             * 
             * @return list
             */
            public List<CommandPricing> getCommandPricingList() {
                return commandPricingList;
            }

            /** 
             * Set the list of 'CommandPricing' element items.
             * 
             * @param list
             */
            public void setCommandPricingList(List<CommandPricing> list) {
                commandPricingList = list;
            }

            /** 
             * Get the list of 'CommissionContract' element items.
             * 
             * @return list
             */
            public List<String> getCommissionContractList() {
                return commissionContractList;
            }

            /** 
             * Set the list of 'CommissionContract' element items.
             * 
             * @param list
             */
            public void setCommissionContractList(List<String> list) {
                commissionContractList = list;
            }

            /** 
             * Get the 'Corporate' element value.
             * 
             * @return value
             */
            public Corporate getCorporate() {
                return corporate;
            }

            /** 
             * Set the 'Corporate' element value.
             * 
             * @param corporate
             */
            public void setCorporate(Corporate corporate) {
                this.corporate = corporate;
            }

            /** 
             * Get the 'Fare' element value.
             * 
             * @return value
             */
            public Fare getFare() {
                return fare;
            }

            /** 
             * Set the 'Fare' element value.
             * 
             * @param fare
             */
            public void setFare(Fare fare) {
                this.fare = fare;
            }

            /** 
             * Get the 'FareOptions' element value.
             * 
             * @return value
             */
            public FareOptions getFareOptions() {
                return fareOptions;
            }

            /** 
             * Set the 'FareOptions' element value.
             * 
             * @param fareOptions
             */
            public void setFareOptions(FareOptions fareOptions) {
                this.fareOptions = fareOptions;
            }

            /** 
             * Get the 'ItineraryOptions' element value.
             * 
             * @return value
             */
            public ItineraryOptions getItineraryOptions() {
                return itineraryOptions;
            }

            /** 
             * Set the 'ItineraryOptions' element value.
             * 
             * @param itineraryOptions
             */
            public void setItineraryOptions(ItineraryOptions itineraryOptions) {
                this.itineraryOptions = itineraryOptions;
            }

            /** 
             * Get the list of 'ManuallyAdjustedSellingLevel' element items.
             * 
             * @return list
             */
            public List<ManuallyAdjustedSellingLevel> getManuallyAdjustedSellingLevelList() {
                return manuallyAdjustedSellingLevelList;
            }

            /** 
             * Set the list of 'ManuallyAdjustedSellingLevel' element items.
             * 
             * @param list
             */
            public void setManuallyAdjustedSellingLevelList(
                    List<ManuallyAdjustedSellingLevel> list) {
                manuallyAdjustedSellingLevelList = list;
            }

            /** 
             * Get the list of 'NameSelect' element items.
             * 
             * @return list
             */
            public List<NameSelect> getNameSelectList() {
                return nameSelectList;
            }

            /** 
             * Set the list of 'NameSelect' element items.
             * 
             * @param list
             */
            public void setNameSelectList(List<NameSelect> list) {
                nameSelectList = list;
            }

            /** 
             * Get the 'NetRemit' element value.
             * 
             * @return value
             */
            public NetRemit getNetRemit() {
                return netRemit;
            }

            /** 
             * Set the 'NetRemit' element value.
             * 
             * @param netRemit
             */
            public void setNetRemit(NetRemit netRemit) {
                this.netRemit = netRemit;
            }

            /** 
             * Get the 'Overrides' element value.
             * 
             * @return value
             */
            public Overrides getOverrides() {
                return overrides;
            }

            /** 
             * Set the 'Overrides' element value.
             * 
             * @param overrides
             */
            public void setOverrides(Overrides overrides) {
                this.overrides = overrides;
            }

            /** 
             * Get the 'PassengerStatus' element value.
             * 
             * @return value
             */
            public String getPassengerStatus() {
                return passengerStatus;
            }

            /** 
             * Set the 'PassengerStatus' element value.
             * 
             * @param passengerStatus
             */
            public void setPassengerStatus(String passengerStatus) {
                this.passengerStatus = passengerStatus;
            }

            /** 
             * Get the list of 'PassengerType' element items.
             * 
             * @return list
             */
            public List<PassengerType> getPassengerTypeList() {
                return passengerTypeList;
            }

            /** 
             * Set the list of 'PassengerType' element items.
             * 
             * @param list
             */
            public void setPassengerTypeList(List<PassengerType> list) {
                passengerTypeList = list;
            }

            /** 
             * Get the 'PlusUp' element value.
             * 
             * @return value
             */
            public PlusUp getPlusUp() {
                return plusUp;
            }

            /** 
             * Set the 'PlusUp' element value.
             * 
             * @param plusUp
             */
            public void setPlusUp(PlusUp plusUp) {
                this.plusUp = plusUp;
            }

            /** 
             * Get the 'RetailerRuleQualifier' element value.
             * 
             * @return value
             */
            public RetailerRuleQualifier getRetailerRuleQualifier() {
                return retailerRuleQualifier;
            }

            /** 
             * Set the 'RetailerRuleQualifier' element value.
             * 
             * @param retailerRuleQualifier
             */
            public void setRetailerRuleQualifier(
                    RetailerRuleQualifier retailerRuleQualifier) {
                this.retailerRuleQualifier = retailerRuleQualifier;
            }

            /** 
             * Get the 'ShipsRegistry' element value.
             * 
             * @return value
             */
            public String getShipsRegistry() {
                return shipsRegistry;
            }

            /** 
             * Set the 'ShipsRegistry' element value.
             * 
             * @param shipsRegistry
             */
            public void setShipsRegistry(String shipsRegistry) {
                this.shipsRegistry = shipsRegistry;
            }

            /** 
             * Get the 'SpanishLargeFamilyDiscountLevel' element value.
             * 
             * @return value
             */
            public SpanishLargeFamilyDiscountLevel getSpanishLargeFamilyDiscountLevel() {
                return spanishLargeFamilyDiscountLevel;
            }

            /** 
             * Set the 'SpanishLargeFamilyDiscountLevel' element value.
             * 
             * @param spanishLargeFamilyDiscountLevel
             */
            public void setSpanishLargeFamilyDiscountLevel(
                    SpanishLargeFamilyDiscountLevel spanishLargeFamilyDiscountLevel) {
                this.spanishLargeFamilyDiscountLevel = spanishLargeFamilyDiscountLevel;
            }

            /** 
             * Get the 'SpanishResidentDiscount' element value.
             * 
             * @return value
             */
            public String getSpanishResidentDiscount() {
                return spanishResidentDiscount;
            }

            /** 
             * Set the 'SpanishResidentDiscount' element value.
             * 
             * @param spanishResidentDiscount
             */
            public void setSpanishResidentDiscount(
                    String spanishResidentDiscount) {
                this.spanishResidentDiscount = spanishResidentDiscount;
            }

            /** 
             * Get the list of 'SpecificFare' element items.
             * 
             * @return list
             */
            public List<SpecificFare> getSpecificFareList() {
                return specificFareList;
            }

            /** 
             * Set the list of 'SpecificFare' element items.
             * 
             * @param list
             */
            public void setSpecificFareList(List<SpecificFare> list) {
                specificFareList = list;
            }

            /** 
             * Get the 'SpecificPenalty' element value.
             * 
             * @return value
             */
            public SpecificPenalty getSpecificPenalty() {
                return specificPenalty;
            }

            /** 
             * Set the 'SpecificPenalty' element value.
             * 
             * @param specificPenalty
             */
            public void setSpecificPenalty(SpecificPenalty specificPenalty) {
                this.specificPenalty = specificPenalty;
            }

            /** 
             * Get the 'Taxes' element value.
             * 
             * @return value
             */
            public Taxes getTaxes() {
                return taxes;
            }

            /** 
             * Set the 'Taxes' element value.
             * 
             * @param taxes
             */
            public void setTaxes(Taxes taxes) {
                this.taxes = taxes;
            }

            /** 
             * Get the list of 'ValidityDates' element items.
             * 
             * @return list
             */
            public List<ValidityDates> getValidityDateList() {
                return validityDateList;
            }

            /** 
             * Set the list of 'ValidityDates' element items.
             * 
             * @param list
             */
            public void setValidityDateList(List<ValidityDates> list) {
                validityDateList = list;
            }

            /** 
             * Get the 'AlternateCurrencyCode' attribute value.
             * 
             * @return value
             */
            public String getAlternateCurrencyCode() {
                return alternateCurrencyCode;
            }

            /** 
             * Set the 'AlternateCurrencyCode' attribute value.
             * 
             * @param alternateCurrencyCode
             */
            public void setAlternateCurrencyCode(String alternateCurrencyCode) {
                this.alternateCurrencyCode = alternateCurrencyCode;
            }

            /** 
             * Get the 'CurrencyCode' attribute value.
             * 
             * @return value
             */
            public String getCurrencyCode() {
                return currencyCode;
            }

            /** 
             * Set the 'CurrencyCode' attribute value.
             * 
             * @param currencyCode
             */
            public void setCurrencyCode(String currencyCode) {
                this.currencyCode = currencyCode;
            }

            /** 
             * Get the 'AggregatedContentExclude' attribute value.
             * 
             * @return value
             */
            public Boolean getAggregatedContentExclude() {
                return aggregatedContentExclude;
            }

            /** 
             * Set the 'AggregatedContentExclude' attribute value.
             * 
             * @param aggregatedContentExclude
             */
            public void setAggregatedContentExclude(
                    Boolean aggregatedContentExclude) {
                this.aggregatedContentExclude = aggregatedContentExclude;
            }

            /** 
             * Get the 'FareFocusExclude' attribute value.
             * 
             * @return value
             */
            public Boolean getFareFocusExclude() {
                return fareFocusExclude;
            }

            /** 
             * Set the 'FareFocusExclude' attribute value.
             * 
             * @param fareFocusExclude
             */
            public void setFareFocusExclude(Boolean fareFocusExclude) {
                this.fareFocusExclude = fareFocusExclude;
            }

            /** 
             * Get the 'NoDate' attribute value.
             * 
             * @return value
             */
            public Boolean getNoDate() {
                return noDate;
            }

            /** 
             * Set the 'NoDate' attribute value.
             * 
             * @param noDate
             */
            public void setNoDate(Boolean noDate) {
                this.noDate = noDate;
            }

            /** 
             * Get the 'RoundTheWorld' attribute value.
             * 
             * @return value
             */
            public Boolean getRoundTheWorld() {
                return roundTheWorld;
            }

            /** 
             * Set the 'RoundTheWorld' attribute value.
             * 
             * @param roundTheWorld
             */
            public void setRoundTheWorld(Boolean roundTheWorld) {
                this.roundTheWorld = roundTheWorld;
            }

            /** 
             * Get the 'Source' attribute value.
             * 
             * @return value
             */
            public String getSource() {
                return source;
            }

            /** 
             * Set the 'Source' attribute value.
             * 
             * @param source
             */
            public void setSource(String source) {
                this.source = source;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Account" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Code" maxOccurs="4"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Force"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Account implements Serializable
            {
                private List<String> codeList = new ArrayList<String>();
                private String force;

                /** 
                 * Get the list of 'Code' element items.
                 * 
                 * @return list
                 */
                public List<String> getCodeList() {
                    return codeList;
                }

                /** 
                 * Set the list of 'Code' element items.
                 * 
                 * @param list
                 */
                public void setCodeList(List<String> list) {
                    codeList = list;
                }

                /** 
                 * Get the 'Force' attribute value.
                 * 
                 * @return value
                 */
                public String getForce() {
                    return force;
                }

                /** 
                 * Set the 'Force' attribute value.
                 * 
                 * @param force
                 */
                public void setForce(String force) {
                    this.force = force;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AlternativePricing" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Overrides" minOccurs="0">
             *         &lt;!-- Reference to inner class Overrides -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="NoAvailCheck"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AlternativePricing implements Serializable
            {
                private Overrides overrides;
                private Boolean noAvailCheck;

                /** 
                 * Get the 'Overrides' element value.
                 * 
                 * @return value
                 */
                public Overrides getOverrides() {
                    return overrides;
                }

                /** 
                 * Set the 'Overrides' element value.
                 * 
                 * @param overrides
                 */
                public void setOverrides(Overrides overrides) {
                    this.overrides = overrides;
                }

                /** 
                 * Get the 'NoAvailCheck' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getNoAvailCheck() {
                    return noAvailCheck;
                }

                /** 
                 * Set the 'NoAvailCheck' attribute value.
                 * 
                 * @param noAvailCheck
                 */
                public void setNoAvailCheck(Boolean noAvailCheck) {
                    this.noAvailCheck = noAvailCheck;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Overrides" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="MatchNoMatch" minOccurs="0">
                 *         &lt;!-- Reference to inner class MatchNoMatch -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="NoMatch" minOccurs="0">
                 *         &lt;!-- Reference to inner class NoMatch -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Overrides implements Serializable
                {
                    private MatchNoMatch matchNoMatch;
                    private NoMatch noMatch;

                    /** 
                     * Get the 'MatchNoMatch' element value.
                     * 
                     * @return value
                     */
                    public MatchNoMatch getMatchNoMatch() {
                        return matchNoMatch;
                    }

                    /** 
                     * Set the 'MatchNoMatch' element value.
                     * 
                     * @param matchNoMatch
                     */
                    public void setMatchNoMatch(MatchNoMatch matchNoMatch) {
                        this.matchNoMatch = matchNoMatch;
                    }

                    /** 
                     * Get the 'NoMatch' element value.
                     * 
                     * @return value
                     */
                    public NoMatch getNoMatch() {
                        return noMatch;
                    }

                    /** 
                     * Set the 'NoMatch' element value.
                     * 
                     * @param noMatch
                     */
                    public void setNoMatch(NoMatch noMatch) {
                        this.noMatch = noMatch;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MatchNoMatch" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="Ind"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class MatchNoMatch implements Serializable
                    {
                        private Boolean ind;

                        /** 
                         * Get the 'Ind' attribute value.
                         * 
                         * @return value
                         */
                        public Boolean getInd() {
                            return ind;
                        }

                        /** 
                         * Set the 'Ind' attribute value.
                         * 
                         * @param ind
                         */
                        public void setInd(Boolean ind) {
                            this.ind = ind;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NoMatch" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="Ind"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class NoMatch implements Serializable
                    {
                        private Boolean ind;

                        /** 
                         * Get the 'Ind' attribute value.
                         * 
                         * @return value
                         */
                        public Boolean getInd() {
                            return ind;
                        }

                        /** 
                         * Set the 'Ind' attribute value.
                         * 
                         * @param ind
                         */
                        public void setInd(Boolean ind) {
                            this.ind = ind;
                        }
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BargainFinder" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="Historical"/>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="Rebook"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class BargainFinder implements Serializable
            {
                private Boolean historical;
                private Boolean rebook;

                /** 
                 * Get the 'Historical' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getHistorical() {
                    return historical;
                }

                /** 
                 * Set the 'Historical' attribute value.
                 * 
                 * @param historical
                 */
                public void setHistorical(Boolean historical) {
                    this.historical = historical;
                }

                /** 
                 * Get the 'Rebook' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getRebook() {
                    return rebook;
                }

                /** 
                 * Set the 'Rebook' attribute value.
                 * 
                 * @param rebook
                 */
                public void setRebook(Boolean rebook) {
                    this.rebook = rebook;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Brand" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute type="xs:integer" use="optional" name="RPH"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Brand implements Serializable
            {
                private String string;
                private BigInteger RPH;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'RPH' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getRPH() {
                    return RPH;
                }

                /** 
                 * Set the 'RPH' attribute value.
                 * 
                 * @param RPH
                 */
                public void setRPH(BigInteger RPH) {
                    this.RPH = RPH;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CommandPricing" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Discount" minOccurs="0">
             *         &lt;!-- Reference to inner class Discount -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="FareBasis" minOccurs="0">
             *         &lt;!-- Reference to inner class FareBasis -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class CommandPricing implements Serializable
            {
                private Discount discount;
                private FareBasis fareBasis;
                private String RPH;

                /** 
                 * Get the 'Discount' element value.
                 * 
                 * @return value
                 */
                public Discount getDiscount() {
                    return discount;
                }

                /** 
                 * Set the 'Discount' element value.
                 * 
                 * @param discount
                 */
                public void setDiscount(Discount discount) {
                    this.discount = discount;
                }

                /** 
                 * Get the 'FareBasis' element value.
                 * 
                 * @return value
                 */
                public FareBasis getFareBasis() {
                    return fareBasis;
                }

                /** 
                 * Set the 'FareBasis' element value.
                 * 
                 * @param fareBasis
                 */
                public void setFareBasis(FareBasis fareBasis) {
                    this.fareBasis = fareBasis;
                }

                /** 
                 * Get the 'RPH' attribute value.
                 * 
                 * @return value
                 */
                public String getRPH() {
                    return RPH;
                }

                /** 
                 * Set the 'RPH' attribute value.
                 * 
                 * @param RPH
                 */
                public void setRPH(String RPH) {
                    this.RPH = RPH;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Discount" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="AuthCode"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Percent"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Discount implements Serializable
                {
                    private String amount;
                    private String authCode;
                    private String percent;

                    /** 
                     * Get the 'Amount' attribute value.
                     * 
                     * @return value
                     */
                    public String getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' attribute value.
                     * 
                     * @param amount
                     */
                    public void setAmount(String amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'AuthCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getAuthCode() {
                        return authCode;
                    }

                    /** 
                     * Set the 'AuthCode' attribute value.
                     * 
                     * @param authCode
                     */
                    public void setAuthCode(String authCode) {
                        this.authCode = authCode;
                    }

                    /** 
                     * Get the 'Percent' attribute value.
                     * 
                     * @return value
                     */
                    public String getPercent() {
                        return percent;
                    }

                    /** 
                     * Set the 'Percent' attribute value.
                     * 
                     * @param percent
                     */
                    public void setPercent(String percent) {
                        this.percent = percent;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareBasis" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="TicketDesignator"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class FareBasis implements Serializable
                {
                    private String code;
                    private String ticketDesignator;

                    /** 
                     * Get the 'Code' attribute value.
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'Code' attribute value.
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }

                    /** 
                     * Get the 'TicketDesignator' attribute value.
                     * 
                     * @return value
                     */
                    public String getTicketDesignator() {
                        return ticketDesignator;
                    }

                    /** 
                     * Set the 'TicketDesignator' attribute value.
                     * 
                     * @param ticketDesignator
                     */
                    public void setTicketDesignator(String ticketDesignator) {
                        this.ticketDesignator = ticketDesignator;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Corporate" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="ID" maxOccurs="4"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Force"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Corporate implements Serializable
            {
                private List<String> IDList = new ArrayList<String>();
                private String force;

                /** 
                 * Get the list of 'ID' element items.
                 * 
                 * @return list
                 */
                public List<String> getIDList() {
                    return IDList;
                }

                /** 
                 * Set the list of 'ID' element items.
                 * 
                 * @param list
                 */
                public void setIDList(List<String> list) {
                    IDList = list;
                }

                /** 
                 * Get the 'Force' attribute value.
                 * 
                 * @return value
                 */
                public String getForce() {
                    return force;
                }

                /** 
                 * Set the 'Force' attribute value.
                 * 
                 * @param force
                 */
                public void setForce(String force) {
                    this.force = force;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Fare" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="Type"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Fare implements Serializable
            {
                private String type;

                /** 
                 * Get the 'Type' attribute value.
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'Type' attribute value.
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareOptions" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="ASLBreakdown"/>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="ASLIgnore"/>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="Excursion"/>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="HandlingFees"/>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="Net"/>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="Private"/>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="Public"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class FareOptions implements Serializable
            {
                private Boolean ASLBreakdown;
                private Boolean ASLIgnore;
                private Boolean excursion;
                private Boolean handlingFees;
                private Boolean net;
                private Boolean _private;
                private Boolean _public;

                /** 
                 * Get the 'ASLBreakdown' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getASLBreakdown() {
                    return ASLBreakdown;
                }

                /** 
                 * Set the 'ASLBreakdown' attribute value.
                 * 
                 * @param ASLBreakdown
                 */
                public void setASLBreakdown(Boolean ASLBreakdown) {
                    this.ASLBreakdown = ASLBreakdown;
                }

                /** 
                 * Get the 'ASLIgnore' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getASLIgnore() {
                    return ASLIgnore;
                }

                /** 
                 * Set the 'ASLIgnore' attribute value.
                 * 
                 * @param ASLIgnore
                 */
                public void setASLIgnore(Boolean ASLIgnore) {
                    this.ASLIgnore = ASLIgnore;
                }

                /** 
                 * Get the 'Excursion' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getExcursion() {
                    return excursion;
                }

                /** 
                 * Set the 'Excursion' attribute value.
                 * 
                 * @param excursion
                 */
                public void setExcursion(Boolean excursion) {
                    this.excursion = excursion;
                }

                /** 
                 * Get the 'HandlingFees' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getHandlingFees() {
                    return handlingFees;
                }

                /** 
                 * Set the 'HandlingFees' attribute value.
                 * 
                 * @param handlingFees
                 */
                public void setHandlingFees(Boolean handlingFees) {
                    this.handlingFees = handlingFees;
                }

                /** 
                 * Get the 'Net' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getNet() {
                    return net;
                }

                /** 
                 * Set the 'Net' attribute value.
                 * 
                 * @param net
                 */
                public void setNet(Boolean net) {
                    this.net = net;
                }

                /** 
                 * Get the 'Private' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getPrivate() {
                    return _private;
                }

                /** 
                 * Set the 'Private' attribute value.
                 * 
                 * @param _private
                 */
                public void setPrivate(Boolean _private) {
                    this._private = _private;
                }

                /** 
                 * Get the 'Public' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getPublic() {
                    return _public;
                }

                /** 
                 * Set the 'Public' attribute value.
                 * 
                 * @param _public
                 */
                public void setPublic(Boolean _public) {
                    this._public = _public;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ItineraryOptions" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="BreakFare" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class BreakFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="ForceConnection" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class ForceConnection -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="ForceStopOver" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class ForceStopOver -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="OverrideBreak" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class OverrideBreak -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="SegmentSelect" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class SegmentSelect -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="SideTrip" minOccurs="0">
             *         &lt;!-- Reference to inner class SideTrip -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ItineraryOptions implements Serializable
            {
                private List<BreakFare> breakFareList = new ArrayList<BreakFare>();
                private List<ForceConnection> forceConnectionList = new ArrayList<ForceConnection>();
                private List<ForceStopOver> forceStopOverList = new ArrayList<ForceStopOver>();
                private List<OverrideBreak> overrideBreakList = new ArrayList<OverrideBreak>();
                private List<SegmentSelect> segmentSelectList = new ArrayList<SegmentSelect>();
                private SideTrip sideTrip;

                /** 
                 * Get the list of 'BreakFare' element items.
                 * 
                 * @return list
                 */
                public List<BreakFare> getBreakFareList() {
                    return breakFareList;
                }

                /** 
                 * Set the list of 'BreakFare' element items.
                 * 
                 * @param list
                 */
                public void setBreakFareList(List<BreakFare> list) {
                    breakFareList = list;
                }

                /** 
                 * Get the list of 'ForceConnection' element items.
                 * 
                 * @return list
                 */
                public List<ForceConnection> getForceConnectionList() {
                    return forceConnectionList;
                }

                /** 
                 * Set the list of 'ForceConnection' element items.
                 * 
                 * @param list
                 */
                public void setForceConnectionList(List<ForceConnection> list) {
                    forceConnectionList = list;
                }

                /** 
                 * Get the list of 'ForceStopOver' element items.
                 * 
                 * @return list
                 */
                public List<ForceStopOver> getForceStopOverList() {
                    return forceStopOverList;
                }

                /** 
                 * Set the list of 'ForceStopOver' element items.
                 * 
                 * @param list
                 */
                public void setForceStopOverList(List<ForceStopOver> list) {
                    forceStopOverList = list;
                }

                /** 
                 * Get the list of 'OverrideBreak' element items.
                 * 
                 * @return list
                 */
                public List<OverrideBreak> getOverrideBreakList() {
                    return overrideBreakList;
                }

                /** 
                 * Set the list of 'OverrideBreak' element items.
                 * 
                 * @param list
                 */
                public void setOverrideBreakList(List<OverrideBreak> list) {
                    overrideBreakList = list;
                }

                /** 
                 * Get the list of 'SegmentSelect' element items.
                 * 
                 * @return list
                 */
                public List<SegmentSelect> getSegmentSelectList() {
                    return segmentSelectList;
                }

                /** 
                 * Set the list of 'SegmentSelect' element items.
                 * 
                 * @param list
                 */
                public void setSegmentSelectList(List<SegmentSelect> list) {
                    segmentSelectList = list;
                }

                /** 
                 * Get the 'SideTrip' element value.
                 * 
                 * @return value
                 */
                public SideTrip getSideTrip() {
                    return sideTrip;
                }

                /** 
                 * Set the 'SideTrip' element value.
                 * 
                 * @param sideTrip
                 */
                public void setSideTrip(SideTrip sideTrip) {
                    this.sideTrip = sideTrip;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BreakFare" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Number"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class BreakFare implements Serializable
                {
                    private String number;

                    /** 
                     * Get the 'Number' attribute value.
                     * 
                     * @return value
                     */
                    public String getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'Number' attribute value.
                     * 
                     * @param number
                     */
                    public void setNumber(String number) {
                        this.number = number;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ForceConnection" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Number"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ForceConnection implements Serializable
                {
                    private String number;

                    /** 
                     * Get the 'Number' attribute value.
                     * 
                     * @return value
                     */
                    public String getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'Number' attribute value.
                     * 
                     * @param number
                     */
                    public void setNumber(String number) {
                        this.number = number;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ForceStopOver" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Number"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ForceStopOver implements Serializable
                {
                    private String number;

                    /** 
                     * Get the 'Number' attribute value.
                     * 
                     * @return value
                     */
                    public String getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'Number' attribute value.
                     * 
                     * @param number
                     */
                    public void setNumber(String number) {
                        this.number = number;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OverrideBreak" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Number"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class OverrideBreak implements Serializable
                {
                    private String number;

                    /** 
                     * Get the 'Number' attribute value.
                     * 
                     * @return value
                     */
                    public String getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'Number' attribute value.
                     * 
                     * @param number
                     */
                    public void setNumber(String number) {
                        this.number = number;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SegmentSelect" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Number"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="EndNumber"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class SegmentSelect implements Serializable
                {
                    private String number;
                    private String endNumber;
                    private String RPH;

                    /** 
                     * Get the 'Number' attribute value.
                     * 
                     * @return value
                     */
                    public String getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'Number' attribute value.
                     * 
                     * @param number
                     */
                    public void setNumber(String number) {
                        this.number = number;
                    }

                    /** 
                     * Get the 'EndNumber' attribute value.
                     * 
                     * @return value
                     */
                    public String getEndNumber() {
                        return endNumber;
                    }

                    /** 
                     * Set the 'EndNumber' attribute value.
                     * 
                     * @param endNumber
                     */
                    public void setEndNumber(String endNumber) {
                        this.endNumber = endNumber;
                    }

                    /** 
                     * Get the 'RPH' attribute value.
                     * 
                     * @return value
                     */
                    public String getRPH() {
                        return RPH;
                    }

                    /** 
                     * Set the 'RPH' attribute value.
                     * 
                     * @param RPH
                     */
                    public void setRPH(String RPH) {
                        this.RPH = RPH;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SideTrip" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Number"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="EndNumber"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class SideTrip implements Serializable
                {
                    private String number;
                    private String endNumber;

                    /** 
                     * Get the 'Number' attribute value.
                     * 
                     * @return value
                     */
                    public String getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'Number' attribute value.
                     * 
                     * @param number
                     */
                    public void setNumber(String number) {
                        this.number = number;
                    }

                    /** 
                     * Get the 'EndNumber' attribute value.
                     * 
                     * @return value
                     */
                    public String getEndNumber() {
                        return endNumber;
                    }

                    /** 
                     * Set the 'EndNumber' attribute value.
                     * 
                     * @param endNumber
                     */
                    public void setEndNumber(String endNumber) {
                        this.endNumber = endNumber;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ManuallyAdjustedSellingLevel" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:decimal" use="optional" name="MarkDown"/>
             *     &lt;xs:attribute type="xs:decimal" use="optional" name="MarkUp"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ManuallyAdjustedSellingLevel implements
                Serializable
            {
                private BigDecimal markDown;
                private BigDecimal markUp;

                /** 
                 * Get the 'MarkDown' attribute value.
                 * 
                 * @return value
                 */
                public BigDecimal getMarkDown() {
                    return markDown;
                }

                /** 
                 * Set the 'MarkDown' attribute value.
                 * 
                 * @param markDown
                 */
                public void setMarkDown(BigDecimal markDown) {
                    this.markDown = markDown;
                }

                /** 
                 * Get the 'MarkUp' attribute value.
                 * 
                 * @return value
                 */
                public BigDecimal getMarkUp() {
                    return markUp;
                }

                /** 
                 * Set the 'MarkUp' attribute value.
                 * 
                 * @param markUp
                 */
                public void setMarkUp(BigDecimal markUp) {
                    this.markUp = markUp;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NameSelect" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="NameNumber"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="EndNameNumber"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class NameSelect implements Serializable
            {
                private String nameNumber;
                private String endNameNumber;

                /** 
                 * Get the 'NameNumber' attribute value.
                 * 
                 * @return value
                 */
                public String getNameNumber() {
                    return nameNumber;
                }

                /** 
                 * Set the 'NameNumber' attribute value.
                 * 
                 * @param nameNumber
                 */
                public void setNameNumber(String nameNumber) {
                    this.nameNumber = nameNumber;
                }

                /** 
                 * Get the 'EndNameNumber' attribute value.
                 * 
                 * @return value
                 */
                public String getEndNameNumber() {
                    return endNameNumber;
                }

                /** 
                 * Set the 'EndNameNumber' attribute value.
                 * 
                 * @param endNameNumber
                 */
                public void setEndNameNumber(String endNameNumber) {
                    this.endNameNumber = endNameNumber;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NetRemit" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="CAR" minOccurs="0">
             *         &lt;!-- Reference to inner class CAR -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Cash" minOccurs="0">
             *         &lt;!-- Reference to inner class Cash -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Credit" minOccurs="0">
             *         &lt;!-- Reference to inner class Credit -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class NetRemit implements Serializable
            {
                private CAR CAR1;
                private Cash cash;
                private Credit credit;
                private String code;

                /** 
                 * Get the 'CAR' element value.
                 * 
                 * @return value
                 */
                public CAR getCAR1() {
                    return CAR1;
                }

                /** 
                 * Set the 'CAR' element value.
                 * 
                 * @param CAR1
                 */
                public void setCAR1(CAR CAR1) {
                    this.CAR1 = CAR1;
                }

                /** 
                 * Get the 'Cash' element value.
                 * 
                 * @return value
                 */
                public Cash getCash() {
                    return cash;
                }

                /** 
                 * Set the 'Cash' element value.
                 * 
                 * @param cash
                 */
                public void setCash(Cash cash) {
                    this.cash = cash;
                }

                /** 
                 * Get the 'Credit' element value.
                 * 
                 * @return value
                 */
                public Credit getCredit() {
                    return credit;
                }

                /** 
                 * Set the 'Credit' element value.
                 * 
                 * @param credit
                 */
                public void setCredit(Credit credit) {
                    this.credit = credit;
                }

                /** 
                 * Get the 'Code' attribute value.
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'Code' attribute value.
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CAR" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class CAR implements Serializable
                {
                    private String code;

                    /** 
                     * Get the 'Code' attribute value.
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'Code' attribute value.
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Cash" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Cash implements Serializable
                {
                    private String currencyCode;
                    private String amount;

                    /** 
                     * Get the 'CurrencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'CurrencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'Amount' attribute value.
                     * 
                     * @return value
                     */
                    public String getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' attribute value.
                     * 
                     * @param amount
                     */
                    public void setAmount(String amount) {
                        this.amount = amount;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Credit" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Credit implements Serializable
                {
                    private String amount;

                    /** 
                     * Get the 'Amount' attribute value.
                     * 
                     * @return value
                     */
                    public String getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' attribute value.
                     * 
                     * @param amount
                     */
                    public void setAmount(String amount) {
                        this.amount = amount;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Overrides" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="FuelSurchargeOverride" minOccurs="0">
             *         &lt;!-- Reference to inner class FuelSurchargeOverride -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="GoverningCarrierOverride" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class GoverningCarrierOverride -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="NoAdvancePurchase" minOccurs="0">
             *         &lt;!-- Reference to inner class NoAdvancePurchase -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="NoFareRestrictions" minOccurs="0">
             *         &lt;!-- Reference to inner class NoFareRestrictions -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="NoMinMaxStay" minOccurs="0">
             *         &lt;!-- Reference to inner class NoMinMaxStay -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="NoPenalty" minOccurs="0">
             *         &lt;!-- Reference to inner class NoPenalty -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Purchase" minOccurs="0">
             *         &lt;!-- Reference to inner class Purchase -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Ticketing" minOccurs="0">
             *         &lt;!-- Reference to inner class Ticketing -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Overrides implements Serializable
            {
                private FuelSurchargeOverride fuelSurchargeOverride;
                private List<GoverningCarrierOverride> governingCarrierOverrideList = new ArrayList<GoverningCarrierOverride>();
                private NoAdvancePurchase noAdvancePurchase;
                private NoFareRestrictions noFareRestrictions;
                private NoMinMaxStay noMinMaxStay;
                private NoPenalty noPenalty;
                private Purchase purchase;
                private Ticketing ticketing;

                /** 
                 * Get the 'FuelSurchargeOverride' element value.
                 * 
                 * @return value
                 */
                public FuelSurchargeOverride getFuelSurchargeOverride() {
                    return fuelSurchargeOverride;
                }

                /** 
                 * Set the 'FuelSurchargeOverride' element value.
                 * 
                 * @param fuelSurchargeOverride
                 */
                public void setFuelSurchargeOverride(
                        FuelSurchargeOverride fuelSurchargeOverride) {
                    this.fuelSurchargeOverride = fuelSurchargeOverride;
                }

                /** 
                 * Get the list of 'GoverningCarrierOverride' element items.
                 * 
                 * @return list
                 */
                public List<GoverningCarrierOverride> getGoverningCarrierOverrideList() {
                    return governingCarrierOverrideList;
                }

                /** 
                 * Set the list of 'GoverningCarrierOverride' element items.
                 * 
                 * @param list
                 */
                public void setGoverningCarrierOverrideList(
                        List<GoverningCarrierOverride> list) {
                    governingCarrierOverrideList = list;
                }

                /** 
                 * Get the 'NoAdvancePurchase' element value.
                 * 
                 * @return value
                 */
                public NoAdvancePurchase getNoAdvancePurchase() {
                    return noAdvancePurchase;
                }

                /** 
                 * Set the 'NoAdvancePurchase' element value.
                 * 
                 * @param noAdvancePurchase
                 */
                public void setNoAdvancePurchase(
                        NoAdvancePurchase noAdvancePurchase) {
                    this.noAdvancePurchase = noAdvancePurchase;
                }

                /** 
                 * Get the 'NoFareRestrictions' element value.
                 * 
                 * @return value
                 */
                public NoFareRestrictions getNoFareRestrictions() {
                    return noFareRestrictions;
                }

                /** 
                 * Set the 'NoFareRestrictions' element value.
                 * 
                 * @param noFareRestrictions
                 */
                public void setNoFareRestrictions(
                        NoFareRestrictions noFareRestrictions) {
                    this.noFareRestrictions = noFareRestrictions;
                }

                /** 
                 * Get the 'NoMinMaxStay' element value.
                 * 
                 * @return value
                 */
                public NoMinMaxStay getNoMinMaxStay() {
                    return noMinMaxStay;
                }

                /** 
                 * Set the 'NoMinMaxStay' element value.
                 * 
                 * @param noMinMaxStay
                 */
                public void setNoMinMaxStay(NoMinMaxStay noMinMaxStay) {
                    this.noMinMaxStay = noMinMaxStay;
                }

                /** 
                 * Get the 'NoPenalty' element value.
                 * 
                 * @return value
                 */
                public NoPenalty getNoPenalty() {
                    return noPenalty;
                }

                /** 
                 * Set the 'NoPenalty' element value.
                 * 
                 * @param noPenalty
                 */
                public void setNoPenalty(NoPenalty noPenalty) {
                    this.noPenalty = noPenalty;
                }

                /** 
                 * Get the 'Purchase' element value.
                 * 
                 * @return value
                 */
                public Purchase getPurchase() {
                    return purchase;
                }

                /** 
                 * Set the 'Purchase' element value.
                 * 
                 * @param purchase
                 */
                public void setPurchase(Purchase purchase) {
                    this.purchase = purchase;
                }

                /** 
                 * Get the 'Ticketing' element value.
                 * 
                 * @return value
                 */
                public Ticketing getTicketing() {
                    return ticketing;
                }

                /** 
                 * Set the 'Ticketing' element value.
                 * 
                 * @param ticketing
                 */
                public void setTicketing(Ticketing ticketing) {
                    this.ticketing = ticketing;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FuelSurchargeOverride" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class FuelSurchargeOverride implements
                    Serializable
                {
                    private boolean ind;

                    /** 
                     * Get the 'Ind' attribute value.
                     * 
                     * @return value
                     */
                    public boolean isInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value.
                     * 
                     * @param ind
                     */
                    public void setInd(boolean ind) {
                        this.ind = ind;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GoverningCarrierOverride" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Airline">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class GoverningCarrierOverride implements
                    Serializable
                {
                    private String airline;
                    private String RPH;

                    /** 
                     * Get the 'Code' attribute value.
                     * 
                     * @return value
                     */
                    public String getAirline() {
                        return airline;
                    }

                    /** 
                     * Set the 'Code' attribute value.
                     * 
                     * @param airline
                     */
                    public void setAirline(String airline) {
                        this.airline = airline;
                    }

                    /** 
                     * Get the 'RPH' attribute value.
                     * 
                     * @return value
                     */
                    public String getRPH() {
                        return RPH;
                    }

                    /** 
                     * Set the 'RPH' attribute value.
                     * 
                     * @param RPH
                     */
                    public void setRPH(String RPH) {
                        this.RPH = RPH;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NoAdvancePurchase" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class NoAdvancePurchase implements Serializable
                {
                    private boolean ind;

                    /** 
                     * Get the 'Ind' attribute value.
                     * 
                     * @return value
                     */
                    public boolean isInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value.
                     * 
                     * @param ind
                     */
                    public void setInd(boolean ind) {
                        this.ind = ind;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NoFareRestrictions" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class NoFareRestrictions implements Serializable
                {
                    private boolean ind;

                    /** 
                     * Get the 'Ind' attribute value.
                     * 
                     * @return value
                     */
                    public boolean isInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value.
                     * 
                     * @param ind
                     */
                    public void setInd(boolean ind) {
                        this.ind = ind;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NoMinMaxStay" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class NoMinMaxStay implements Serializable
                {
                    private boolean ind;

                    /** 
                     * Get the 'Ind' attribute value.
                     * 
                     * @return value
                     */
                    public boolean isInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value.
                     * 
                     * @param ind
                     */
                    public void setInd(boolean ind) {
                        this.ind = ind;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NoPenalty" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class NoPenalty implements Serializable
                {
                    private boolean ind;

                    /** 
                     * Get the 'Ind' attribute value.
                     * 
                     * @return value
                     */
                    public boolean isInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value.
                     * 
                     * @param ind
                     */
                    public void setInd(boolean ind) {
                        this.ind = ind;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Purchase" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="LocationCode"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Purchase implements Serializable
                {
                    private String locationCode;

                    /** 
                     * Get the 'LocationCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getLocationCode() {
                        return locationCode;
                    }

                    /** 
                     * Set the 'LocationCode' attribute value.
                     * 
                     * @param locationCode
                     */
                    public void setLocationCode(String locationCode) {
                        this.locationCode = locationCode;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Ticketing" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="LocationCode"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Ticketing implements Serializable
                {
                    private String locationCode;

                    /** 
                     * Get the 'LocationCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getLocationCode() {
                        return locationCode;
                    }

                    /** 
                     * Set the 'LocationCode' attribute value.
                     * 
                     * @param locationCode
                     */
                    public void setLocationCode(String locationCode) {
                        this.locationCode = locationCode;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerType" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="Force"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Quantity"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class PassengerType implements Serializable
            {
                private String code;
                private Boolean force;
                private String quantity;

                /** 
                 * Get the 'Code' attribute value.
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'Code' attribute value.
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }

                /** 
                 * Get the 'Force' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getForce() {
                    return force;
                }

                /** 
                 * Set the 'Force' attribute value.
                 * 
                 * @param force
                 */
                public void setForce(Boolean force) {
                    this.force = force;
                }

                /** 
                 * Get the 'Quantity' attribute value.
                 * 
                 * @return value
                 */
                public String getQuantity() {
                    return quantity;
                }

                /** 
                 * Set the 'Quantity' attribute value.
                 * 
                 * @param quantity
                 */
                public void setQuantity(String quantity) {
                    this.quantity = quantity;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PlusUp" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="TicketDesignator" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class PlusUp implements Serializable
            {
                private String ticketDesignator;
                private String amount;

                /** 
                 * Get the 'TicketDesignator' element value.
                 * 
                 * @return value
                 */
                public String getTicketDesignator() {
                    return ticketDesignator;
                }

                /** 
                 * Set the 'TicketDesignator' element value.
                 * 
                 * @param ticketDesignator
                 */
                public void setTicketDesignator(String ticketDesignator) {
                    this.ticketDesignator = ticketDesignator;
                }

                /** 
                 * Get the 'Amount' attribute value.
                 * 
                 * @return value
                 */
                public String getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' attribute value.
                 * 
                 * @param amount
                 */
                public void setAmount(String amount) {
                    this.amount = amount;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RetailerRuleQualifier" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Qualifier" maxOccurs="4"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="Force"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class RetailerRuleQualifier implements Serializable
            {
                private List<String> qualifierList = new ArrayList<String>();
                private Boolean force;

                /** 
                 * Get the list of 'Qualifier' element items.
                 * 
                 * @return list
                 */
                public List<String> getQualifierList() {
                    return qualifierList;
                }

                /** 
                 * Set the list of 'Qualifier' element items.
                 * 
                 * @param list
                 */
                public void setQualifierList(List<String> list) {
                    qualifierList = list;
                }

                /** 
                 * Get the 'Force' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getForce() {
                    return force;
                }

                /** 
                 * Set the 'Force' attribute value.
                 * 
                 * @param force
                 */
                public void setForce(Boolean force) {
                    this.force = force;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
             *   &lt;xs:restriction base="xs:string">
             *     &lt;xs:enumeration value="1"/>
             *     &lt;xs:enumeration value="2"/>
             *   &lt;/xs:restriction>
             * &lt;/xs:simpleType>
             * </pre>
             */
            public static enum SpanishLargeFamilyDiscountLevel
                    implements
                        Serializable {
                _1("1"), _2("2");
                private final String value;

                private SpanishLargeFamilyDiscountLevel(String value) {
                    this.value = value;
                }

                public String xmlValue() {
                    return value;
                }

                public static SpanishLargeFamilyDiscountLevel convert(
                        String value) {
                    for (SpanishLargeFamilyDiscountLevel inst : values()) {
                        if (inst.xmlValue().equals(value)) {
                            return inst;
                        }
                    }
                    return null;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecificFare" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="FareBasis" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class SpecificFare implements Serializable
            {
                private String fareBasis;
                private String RPH;

                /** 
                 * Get the 'FareBasis' element value.
                 * 
                 * @return value
                 */
                public String getFareBasis() {
                    return fareBasis;
                }

                /** 
                 * Set the 'FareBasis' element value.
                 * 
                 * @param fareBasis
                 */
                public void setFareBasis(String fareBasis) {
                    this.fareBasis = fareBasis;
                }

                /** 
                 * Get the 'RPH' attribute value.
                 * 
                 * @return value
                 */
                public String getRPH() {
                    return RPH;
                }

                /** 
                 * Set the 'RPH' attribute value.
                 * 
                 * @param RPH
                 */
                public void setRPH(String RPH) {
                    this.RPH = RPH;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecificPenalty" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Changeable" minOccurs="0">
             *         &lt;!-- Reference to inner class Changeable -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="EitherOr" minOccurs="0">
             *         &lt;!-- Reference to inner class EitherOr -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Refundable" minOccurs="0">
             *         &lt;!-- Reference to inner class Refundable -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="AdditionalInfo"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class SpecificPenalty implements Serializable
            {
                private Changeable changeable;
                private EitherOr eitherOr;
                private Refundable refundable;
                private Boolean additionalInfo;

                /** 
                 * Get the 'Changeable' element value.
                 * 
                 * @return value
                 */
                public Changeable getChangeable() {
                    return changeable;
                }

                /** 
                 * Set the 'Changeable' element value.
                 * 
                 * @param changeable
                 */
                public void setChangeable(Changeable changeable) {
                    this.changeable = changeable;
                }

                /** 
                 * Get the 'EitherOr' element value.
                 * 
                 * @return value
                 */
                public EitherOr getEitherOr() {
                    return eitherOr;
                }

                /** 
                 * Set the 'EitherOr' element value.
                 * 
                 * @param eitherOr
                 */
                public void setEitherOr(EitherOr eitherOr) {
                    this.eitherOr = eitherOr;
                }

                /** 
                 * Get the 'Refundable' element value.
                 * 
                 * @return value
                 */
                public Refundable getRefundable() {
                    return refundable;
                }

                /** 
                 * Set the 'Refundable' element value.
                 * 
                 * @param refundable
                 */
                public void setRefundable(Refundable refundable) {
                    this.refundable = refundable;
                }

                /** 
                 * Get the 'AdditionalInfo' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getAdditionalInfo() {
                    return additionalInfo;
                }

                /** 
                 * Set the 'AdditionalInfo' attribute value.
                 * 
                 * @param additionalInfo
                 */
                public void setAdditionalInfo(Boolean additionalInfo) {
                    this.additionalInfo = additionalInfo;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Changeable" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Any"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="MaxPenalty"/>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="BeforeDeparture"/>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="AfterDeparture"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Changeable implements Serializable
                {
                    private Boolean any;
                    private String currencyCode;
                    private String maxPenalty;
                    private Boolean beforeDeparture;
                    private Boolean afterDeparture;

                    /** 
                     * Get the 'Any' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getAny() {
                        return any;
                    }

                    /** 
                     * Set the 'Any' attribute value.
                     * 
                     * @param any
                     */
                    public void setAny(Boolean any) {
                        this.any = any;
                    }

                    /** 
                     * Get the 'CurrencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'CurrencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'MaxPenalty' attribute value.
                     * 
                     * @return value
                     */
                    public String getMaxPenalty() {
                        return maxPenalty;
                    }

                    /** 
                     * Set the 'MaxPenalty' attribute value.
                     * 
                     * @param maxPenalty
                     */
                    public void setMaxPenalty(String maxPenalty) {
                        this.maxPenalty = maxPenalty;
                    }

                    /** 
                     * Get the 'BeforeDeparture' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getBeforeDeparture() {
                        return beforeDeparture;
                    }

                    /** 
                     * Set the 'BeforeDeparture' attribute value.
                     * 
                     * @param beforeDeparture
                     */
                    public void setBeforeDeparture(Boolean beforeDeparture) {
                        this.beforeDeparture = beforeDeparture;
                    }

                    /** 
                     * Get the 'AfterDeparture' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getAfterDeparture() {
                        return afterDeparture;
                    }

                    /** 
                     * Set the 'AfterDeparture' attribute value.
                     * 
                     * @param afterDeparture
                     */
                    public void setAfterDeparture(Boolean afterDeparture) {
                        this.afterDeparture = afterDeparture;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EitherOr" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Any"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="MaxPenalty"/>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="BeforeDeparture"/>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="AfterDeparture"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class EitherOr implements Serializable
                {
                    private Boolean any;
                    private String currencyCode;
                    private String maxPenalty;
                    private Boolean beforeDeparture;
                    private Boolean afterDeparture;

                    /** 
                     * Get the 'Any' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getAny() {
                        return any;
                    }

                    /** 
                     * Set the 'Any' attribute value.
                     * 
                     * @param any
                     */
                    public void setAny(Boolean any) {
                        this.any = any;
                    }

                    /** 
                     * Get the 'CurrencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'CurrencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'MaxPenalty' attribute value.
                     * 
                     * @return value
                     */
                    public String getMaxPenalty() {
                        return maxPenalty;
                    }

                    /** 
                     * Set the 'MaxPenalty' attribute value.
                     * 
                     * @param maxPenalty
                     */
                    public void setMaxPenalty(String maxPenalty) {
                        this.maxPenalty = maxPenalty;
                    }

                    /** 
                     * Get the 'BeforeDeparture' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getBeforeDeparture() {
                        return beforeDeparture;
                    }

                    /** 
                     * Set the 'BeforeDeparture' attribute value.
                     * 
                     * @param beforeDeparture
                     */
                    public void setBeforeDeparture(Boolean beforeDeparture) {
                        this.beforeDeparture = beforeDeparture;
                    }

                    /** 
                     * Get the 'AfterDeparture' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getAfterDeparture() {
                        return afterDeparture;
                    }

                    /** 
                     * Set the 'AfterDeparture' attribute value.
                     * 
                     * @param afterDeparture
                     */
                    public void setAfterDeparture(Boolean afterDeparture) {
                        this.afterDeparture = afterDeparture;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Refundable" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Any"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="MaxPenalty"/>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="BeforeDeparture"/>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="AfterDeparture"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Refundable implements Serializable
                {
                    private Boolean any;
                    private String currencyCode;
                    private String maxPenalty;
                    private Boolean beforeDeparture;
                    private Boolean afterDeparture;

                    /** 
                     * Get the 'Any' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getAny() {
                        return any;
                    }

                    /** 
                     * Set the 'Any' attribute value.
                     * 
                     * @param any
                     */
                    public void setAny(Boolean any) {
                        this.any = any;
                    }

                    /** 
                     * Get the 'CurrencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'CurrencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'MaxPenalty' attribute value.
                     * 
                     * @return value
                     */
                    public String getMaxPenalty() {
                        return maxPenalty;
                    }

                    /** 
                     * Set the 'MaxPenalty' attribute value.
                     * 
                     * @param maxPenalty
                     */
                    public void setMaxPenalty(String maxPenalty) {
                        this.maxPenalty = maxPenalty;
                    }

                    /** 
                     * Get the 'BeforeDeparture' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getBeforeDeparture() {
                        return beforeDeparture;
                    }

                    /** 
                     * Set the 'BeforeDeparture' attribute value.
                     * 
                     * @param beforeDeparture
                     */
                    public void setBeforeDeparture(Boolean beforeDeparture) {
                        this.beforeDeparture = beforeDeparture;
                    }

                    /** 
                     * Get the 'AfterDeparture' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getAfterDeparture() {
                        return afterDeparture;
                    }

                    /** 
                     * Set the 'AfterDeparture' attribute value.
                     * 
                     * @param afterDeparture
                     */
                    public void setAfterDeparture(Boolean afterDeparture) {
                        this.afterDeparture = afterDeparture;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="NoTax" minOccurs="0">
             *         &lt;!-- Reference to inner class NoTax -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TaxExempt" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class TaxExempt -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TaxOverride" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class TaxOverride -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Taxes implements Serializable
            {
                private NoTax noTax;
                private List<TaxExempt> taxExemptList = new ArrayList<TaxExempt>();
                private List<TaxOverride> taxOverrideList = new ArrayList<TaxOverride>();

                /** 
                 * Get the 'NoTax' element value.
                 * 
                 * @return value
                 */
                public NoTax getNoTax() {
                    return noTax;
                }

                /** 
                 * Set the 'NoTax' element value.
                 * 
                 * @param noTax
                 */
                public void setNoTax(NoTax noTax) {
                    this.noTax = noTax;
                }

                /** 
                 * Get the list of 'TaxExempt' element items.
                 * 
                 * @return list
                 */
                public List<TaxExempt> getTaxExemptList() {
                    return taxExemptList;
                }

                /** 
                 * Set the list of 'TaxExempt' element items.
                 * 
                 * @param list
                 */
                public void setTaxExemptList(List<TaxExempt> list) {
                    taxExemptList = list;
                }

                /** 
                 * Get the list of 'TaxOverride' element items.
                 * 
                 * @return list
                 */
                public List<TaxOverride> getTaxOverrideList() {
                    return taxOverrideList;
                }

                /** 
                 * Set the list of 'TaxOverride' element items.
                 * 
                 * @param list
                 */
                public void setTaxOverrideList(List<TaxOverride> list) {
                    taxOverrideList = list;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NoTax" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class NoTax implements Serializable
                {
                    private boolean ind;

                    /** 
                     * Get the 'Ind' attribute value.
                     * 
                     * @return value
                     */
                    public boolean isInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value.
                     * 
                     * @param ind
                     */
                    public void setInd(boolean ind) {
                        this.ind = ind;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxExempt" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TaxExempt implements Serializable
                {
                    private String code;

                    /** 
                     * Get the 'Code' attribute value.
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'Code' attribute value.
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxOverride" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TaxOverride implements Serializable
                {
                    private String amount;
                    private String code;

                    /** 
                     * Get the 'Amount' attribute value.
                     * 
                     * @return value
                     */
                    public String getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' attribute value.
                     * 
                     * @param amount
                     */
                    public void setAmount(String amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'Code' attribute value.
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'Code' attribute value.
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ValidityDates" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="NotValidAfter" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="NotValidBefore" minOccurs="0"/>
             *       &lt;xs:element name="Segment">
             *         &lt;xs:complexType>
             *           &lt;xs:attribute type="xs:string" use="required" name="Number"/>
             *           &lt;xs:attribute type="xs:string" use="optional" name="EndNumber"/>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ValidityDates implements Serializable
            {
                private String notValidAfter;
                private String notValidBefore;
                private String segmentNumber;
                private String segmentEndNumber;

                /** 
                 * Get the 'NotValidAfter' element value.
                 * 
                 * @return value
                 */
                public String getNotValidAfter() {
                    return notValidAfter;
                }

                /** 
                 * Set the 'NotValidAfter' element value.
                 * 
                 * @param notValidAfter
                 */
                public void setNotValidAfter(String notValidAfter) {
                    this.notValidAfter = notValidAfter;
                }

                /** 
                 * Get the 'NotValidBefore' element value.
                 * 
                 * @return value
                 */
                public String getNotValidBefore() {
                    return notValidBefore;
                }

                /** 
                 * Set the 'NotValidBefore' element value.
                 * 
                 * @param notValidBefore
                 */
                public void setNotValidBefore(String notValidBefore) {
                    this.notValidBefore = notValidBefore;
                }

                /** 
                 * Get the 'Number' attribute value.
                 * 
                 * @return value
                 */
                public String getSegmentNumber() {
                    return segmentNumber;
                }

                /** 
                 * Set the 'Number' attribute value.
                 * 
                 * @param segmentNumber
                 */
                public void setSegmentNumber(String segmentNumber) {
                    this.segmentNumber = segmentNumber;
                }

                /** 
                 * Get the 'EndNumber' attribute value.
                 * 
                 * @return value
                 */
                public String getSegmentEndNumber() {
                    return segmentEndNumber;
                }

                /** 
                 * Set the 'EndNumber' attribute value.
                 * 
                 * @param segmentEndNumber
                 */
                public void setSegmentEndNumber(String segmentEndNumber) {
                    this.segmentEndNumber = segmentEndNumber;
                }
            }
        }
    }
}
