
package com.sabre.webservices.sabrexml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="QueuePlaceRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="MultiQueuePlace" minOccurs="0">
 *         &lt;!-- Reference to inner class MultiQueuePlace -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="QueueInfo" minOccurs="0">
 *         &lt;!-- Reference to inner class QueueInfo -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:boolean" use="optional" name="ReturnHostCommand"/>
 *     &lt;xs:attribute type="xs:dateTime" use="optional" name="TimeStamp"/>
 *     &lt;xs:attribute type="xs:string" use="required" fixed="2.0.4" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class QueuePlaceRQ implements Serializable
{
    private MultiQueuePlace multiQueuePlace;
    private QueueInfo queueInfo;
    private Boolean returnHostCommand;
    private Date timeStamp;
    private String version;

    /** 
     * Get the 'MultiQueuePlace' element value.
     * 
     * @return value
     */
    public MultiQueuePlace getMultiQueuePlace() {
        return multiQueuePlace;
    }

    /** 
     * Set the 'MultiQueuePlace' element value.
     * 
     * @param multiQueuePlace
     */
    public void setMultiQueuePlace(MultiQueuePlace multiQueuePlace) {
        this.multiQueuePlace = multiQueuePlace;
    }

    /** 
     * Get the 'QueueInfo' element value.
     * 
     * @return value
     */
    public QueueInfo getQueueInfo() {
        return queueInfo;
    }

    /** 
     * Set the 'QueueInfo' element value.
     * 
     * @param queueInfo
     */
    public void setQueueInfo(QueueInfo queueInfo) {
        this.queueInfo = queueInfo;
    }

    /** 
     * Get the 'ReturnHostCommand' attribute value.
     * 
     * @return value
     */
    public Boolean getReturnHostCommand() {
        return returnHostCommand;
    }

    /** 
     * Set the 'ReturnHostCommand' attribute value.
     * 
     * @param returnHostCommand
     */
    public void setReturnHostCommand(Boolean returnHostCommand) {
        this.returnHostCommand = returnHostCommand;
    }

    /** 
     * Get the 'TimeStamp' attribute value.
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value.
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MultiQueuePlace" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="QueueIdentifier" maxOccurs="20">
     *         &lt;!-- Reference to inner class QueueIdentifier -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class MultiQueuePlace implements Serializable
    {
        private List<QueueIdentifier> queueIdentifierList = new ArrayList<QueueIdentifier>();

        /** 
         * Get the list of 'QueueIdentifier' element items.
         * 
         * @return list
         */
        public List<QueueIdentifier> getQueueIdentifierList() {
            return queueIdentifierList;
        }

        /** 
         * Set the list of 'QueueIdentifier' element items.
         * 
         * @param list
         */
        public void setQueueIdentifierList(List<QueueIdentifier> list) {
            queueIdentifierList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="QueueIdentifier" maxOccurs="20">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Number"/>
         *     &lt;xs:attribute type="xs:string" use="required" name="PrefatoryInstructionCode"/>
         *     &lt;xs:attribute type="xs:string" use="required" name="PseudoCityCode"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class QueueIdentifier implements Serializable
        {
            private String number;
            private String prefatoryInstructionCode;
            private String pseudoCityCode;

            /** 
             * Get the 'Number' attribute value.
             * 
             * @return value
             */
            public String getNumber() {
                return number;
            }

            /** 
             * Set the 'Number' attribute value.
             * 
             * @param number
             */
            public void setNumber(String number) {
                this.number = number;
            }

            /** 
             * Get the 'PrefatoryInstructionCode' attribute value.
             * 
             * @return value
             */
            public String getPrefatoryInstructionCode() {
                return prefatoryInstructionCode;
            }

            /** 
             * Set the 'PrefatoryInstructionCode' attribute value.
             * 
             * @param prefatoryInstructionCode
             */
            public void setPrefatoryInstructionCode(
                    String prefatoryInstructionCode) {
                this.prefatoryInstructionCode = prefatoryInstructionCode;
            }

            /** 
             * Get the 'PseudoCityCode' attribute value.
             * 
             * @return value
             */
            public String getPseudoCityCode() {
                return pseudoCityCode;
            }

            /** 
             * Set the 'PseudoCityCode' attribute value.
             * 
             * @param pseudoCityCode
             */
            public void setPseudoCityCode(String pseudoCityCode) {
                this.pseudoCityCode = pseudoCityCode;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="QueueInfo" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="QueueIdentifier" maxOccurs="3">
     *         &lt;!-- Reference to inner class QueueIdentifier -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="UniqueID" minOccurs="0" maxOccurs="6">
     *         &lt;!-- Reference to inner class UniqueID -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class QueueInfo implements Serializable
    {
        private List<QueueIdentifier> queueIdentifierList = new ArrayList<QueueIdentifier>();
        private List<UniqueID> uniqueIDList = new ArrayList<UniqueID>();

        /** 
         * Get the list of 'QueueIdentifier' element items.
         * 
         * @return list
         */
        public List<QueueIdentifier> getQueueIdentifierList() {
            return queueIdentifierList;
        }

        /** 
         * Set the list of 'QueueIdentifier' element items.
         * 
         * @param list
         */
        public void setQueueIdentifierList(List<QueueIdentifier> list) {
            queueIdentifierList = list;
        }

        /** 
         * Get the list of 'UniqueID' element items.
         * 
         * @return list
         */
        public List<UniqueID> getUniqueIDList() {
            return uniqueIDList;
        }

        /** 
         * Set the list of 'UniqueID' element items.
         * 
         * @param list
         */
        public void setUniqueIDList(List<UniqueID> list) {
            uniqueIDList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="QueueIdentifier" maxOccurs="3">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="Name"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="Number"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="PrefatoryInstructionCode"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="PseudoCityCode"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class QueueIdentifier implements Serializable
        {
            private String name;
            private String number;
            private String prefatoryInstructionCode;
            private String pseudoCityCode;

            /** 
             * Get the 'Name' attribute value.
             * 
             * @return value
             */
            public String getName() {
                return name;
            }

            /** 
             * Set the 'Name' attribute value.
             * 
             * @param name
             */
            public void setName(String name) {
                this.name = name;
            }

            /** 
             * Get the 'Number' attribute value.
             * 
             * @return value
             */
            public String getNumber() {
                return number;
            }

            /** 
             * Set the 'Number' attribute value.
             * 
             * @param number
             */
            public void setNumber(String number) {
                this.number = number;
            }

            /** 
             * Get the 'PrefatoryInstructionCode' attribute value.
             * 
             * @return value
             */
            public String getPrefatoryInstructionCode() {
                return prefatoryInstructionCode;
            }

            /** 
             * Set the 'PrefatoryInstructionCode' attribute value.
             * 
             * @param prefatoryInstructionCode
             */
            public void setPrefatoryInstructionCode(
                    String prefatoryInstructionCode) {
                this.prefatoryInstructionCode = prefatoryInstructionCode;
            }

            /** 
             * Get the 'PseudoCityCode' attribute value.
             * 
             * @return value
             */
            public String getPseudoCityCode() {
                return pseudoCityCode;
            }

            /** 
             * Set the 'PseudoCityCode' attribute value.
             * 
             * @param pseudoCityCode
             */
            public void setPseudoCityCode(String pseudoCityCode) {
                this.pseudoCityCode = pseudoCityCode;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UniqueID" minOccurs="0" maxOccurs="6">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="ID"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class UniqueID implements Serializable
        {
            private String ID;

            /** 
             * Get the 'ID' attribute value.
             * 
             * @return value
             */
            public String getID() {
                return ID;
            }

            /** 
             * Set the 'ID' attribute value.
             * 
             * @param ID
             */
            public void setID(String ID) {
                this.ID = ID;
            }
        }
    }
}
