
package com.sabre.webservices.sabrexml;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecialServiceRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="SpecialServiceInfo">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element name="AdvancePassenger" minOccurs="0" maxOccurs="unbounded">
 *               &lt;!-- Reference to inner class AdvancePassenger -->
 *             &lt;/xs:element>
 *             &lt;xs:element name="SecureFlight" minOccurs="0" maxOccurs="unbounded">
 *               &lt;!-- Reference to inner class SecureFlight -->
 *             &lt;/xs:element>
 *             &lt;xs:element name="Service" minOccurs="0" maxOccurs="unbounded">
 *               &lt;!-- Reference to inner class Service -->
 *             &lt;/xs:element>
 *           &lt;/xs:sequence>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:boolean" use="optional" name="ReturnHostCommand"/>
 *     &lt;xs:attribute type="xs:dateTime" use="optional" name="TimeStamp"/>
 *     &lt;xs:attribute type="xs:string" use="required" fixed="2.3.1" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class SpecialServiceRQ implements Serializable
{
    private List<AdvancePassenger> advancePassengerList = new ArrayList<AdvancePassenger>();
    private List<SecureFlight> secureFlightList = new ArrayList<SecureFlight>();
    private List<Service> serviceList = new ArrayList<Service>();
    private Boolean returnHostCommand;
    private java.util.Date timeStamp;
    private String version;

    /** 
     * Get the list of 'AdvancePassenger' element items.
     * 
     * @return list
     */
    public List<AdvancePassenger> getAdvancePassengerList() {
        return advancePassengerList;
    }

    /** 
     * Set the list of 'AdvancePassenger' element items.
     * 
     * @param list
     */
    public void setAdvancePassengerList(List<AdvancePassenger> list) {
        advancePassengerList = list;
    }

    /** 
     * Get the list of 'SecureFlight' element items.
     * 
     * @return list
     */
    public List<SecureFlight> getSecureFlightList() {
        return secureFlightList;
    }

    /** 
     * Set the list of 'SecureFlight' element items.
     * 
     * @param list
     */
    public void setSecureFlightList(List<SecureFlight> list) {
        secureFlightList = list;
    }

    /** 
     * Get the list of 'Service' element items.
     * 
     * @return list
     */
    public List<Service> getServiceList() {
        return serviceList;
    }

    /** 
     * Set the list of 'Service' element items.
     * 
     * @param list
     */
    public void setServiceList(List<Service> list) {
        serviceList = list;
    }

    /** 
     * Get the 'ReturnHostCommand' attribute value.
     * 
     * @return value
     */
    public Boolean getReturnHostCommand() {
        return returnHostCommand;
    }

    /** 
     * Set the 'ReturnHostCommand' attribute value.
     * 
     * @param returnHostCommand
     */
    public void setReturnHostCommand(Boolean returnHostCommand) {
        this.returnHostCommand = returnHostCommand;
    }

    /** 
     * Get the 'TimeStamp' attribute value.
     * 
     * @return value
     */
    public java.util.Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value.
     * 
     * @param timeStamp
     */
    public void setTimeStamp(java.util.Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AdvancePassenger" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Document" minOccurs="0">
     *         &lt;!-- Reference to inner class Document -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="PersonName" minOccurs="0">
     *         &lt;!-- Reference to inner class PersonName -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ResidentDestinationAddress" minOccurs="0">
     *         &lt;!-- Reference to inner class ResidentDestinationAddress -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="VendorPrefs" minOccurs="0">
     *         &lt;!-- Reference to inner class VendorPrefs -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="optional" name="SegmentNumber"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AdvancePassenger implements Serializable
    {
        private Document document;
        private PersonName personName;
        private ResidentDestinationAddress residentDestinationAddress;
        private VendorPrefs vendorPrefs;
        private String segmentNumber;

        /** 
         * Get the 'Document' element value.
         * 
         * @return value
         */
        public Document getDocument() {
            return document;
        }

        /** 
         * Set the 'Document' element value.
         * 
         * @param document
         */
        public void setDocument(Document document) {
            this.document = document;
        }

        /** 
         * Get the 'PersonName' element value.
         * 
         * @return value
         */
        public PersonName getPersonName() {
            return personName;
        }

        /** 
         * Set the 'PersonName' element value.
         * 
         * @param personName
         */
        public void setPersonName(PersonName personName) {
            this.personName = personName;
        }

        /** 
         * Get the 'ResidentDestinationAddress' element value.
         * 
         * @return value
         */
        public ResidentDestinationAddress getResidentDestinationAddress() {
            return residentDestinationAddress;
        }

        /** 
         * Set the 'ResidentDestinationAddress' element value.
         * 
         * @param residentDestinationAddress
         */
        public void setResidentDestinationAddress(
                ResidentDestinationAddress residentDestinationAddress) {
            this.residentDestinationAddress = residentDestinationAddress;
        }

        /** 
         * Get the 'VendorPrefs' element value.
         * 
         * @return value
         */
        public VendorPrefs getVendorPrefs() {
            return vendorPrefs;
        }

        /** 
         * Set the 'VendorPrefs' element value.
         * 
         * @param vendorPrefs
         */
        public void setVendorPrefs(VendorPrefs vendorPrefs) {
            this.vendorPrefs = vendorPrefs;
        }

        /** 
         * Get the 'SegmentNumber' attribute value.
         * 
         * @return value
         */
        public String getSegmentNumber() {
            return segmentNumber;
        }

        /** 
         * Set the 'SegmentNumber' attribute value.
         * 
         * @param segmentNumber
         */
        public void setSegmentNumber(String segmentNumber) {
            this.segmentNumber = segmentNumber;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Document" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="IssueCountry" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="NationalityCountry" minOccurs="0"/>
         *       &lt;xs:element name="Visa" minOccurs="0">
         *         &lt;!-- Reference to inner class Visa -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:date" use="optional" name="ExpirationDate"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="Number"/>
         *     &lt;xs:attribute type="xs:string" use="required" name="Type"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Document implements Serializable
        {
            private String issueCountry;
            private String nationalityCountry;
            private Visa visa;
            private Date expirationDate;
            private String number;
            private String type;

            /** 
             * Get the 'IssueCountry' element value.
             * 
             * @return value
             */
            public String getIssueCountry() {
                return issueCountry;
            }

            /** 
             * Set the 'IssueCountry' element value.
             * 
             * @param issueCountry
             */
            public void setIssueCountry(String issueCountry) {
                this.issueCountry = issueCountry;
            }

            /** 
             * Get the 'NationalityCountry' element value.
             * 
             * @return value
             */
            public String getNationalityCountry() {
                return nationalityCountry;
            }

            /** 
             * Set the 'NationalityCountry' element value.
             * 
             * @param nationalityCountry
             */
            public void setNationalityCountry(String nationalityCountry) {
                this.nationalityCountry = nationalityCountry;
            }

            /** 
             * Get the 'Visa' element value.
             * 
             * @return value
             */
            public Visa getVisa() {
                return visa;
            }

            /** 
             * Set the 'Visa' element value.
             * 
             * @param visa
             */
            public void setVisa(Visa visa) {
                this.visa = visa;
            }

            /** 
             * Get the 'ExpirationDate' attribute value.
             * 
             * @return value
             */
            public Date getExpirationDate() {
                return expirationDate;
            }

            /** 
             * Set the 'ExpirationDate' attribute value.
             * 
             * @param expirationDate
             */
            public void setExpirationDate(Date expirationDate) {
                this.expirationDate = expirationDate;
            }

            /** 
             * Get the 'Number' attribute value.
             * 
             * @return value
             */
            public String getNumber() {
                return number;
            }

            /** 
             * Set the 'Number' attribute value.
             * 
             * @param number
             */
            public void setNumber(String number) {
                this.number = number;
            }

            /** 
             * Get the 'Type' attribute value.
             * 
             * @return value
             */
            public String getType() {
                return type;
            }

            /** 
             * Set the 'Type' attribute value.
             * 
             * @param type
             */
            public void setType(String type) {
                this.type = type;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Visa" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="ApplicableCountry" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="PlaceOfBirth" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="PlaceOfIssue" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:date" use="optional" name="IssueDate"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Visa implements Serializable
            {
                private String applicableCountry;
                private String placeOfBirth;
                private String placeOfIssue;
                private Date issueDate;

                /** 
                 * Get the 'ApplicableCountry' element value.
                 * 
                 * @return value
                 */
                public String getApplicableCountry() {
                    return applicableCountry;
                }

                /** 
                 * Set the 'ApplicableCountry' element value.
                 * 
                 * @param applicableCountry
                 */
                public void setApplicableCountry(String applicableCountry) {
                    this.applicableCountry = applicableCountry;
                }

                /** 
                 * Get the 'PlaceOfBirth' element value.
                 * 
                 * @return value
                 */
                public String getPlaceOfBirth() {
                    return placeOfBirth;
                }

                /** 
                 * Set the 'PlaceOfBirth' element value.
                 * 
                 * @param placeOfBirth
                 */
                public void setPlaceOfBirth(String placeOfBirth) {
                    this.placeOfBirth = placeOfBirth;
                }

                /** 
                 * Get the 'PlaceOfIssue' element value.
                 * 
                 * @return value
                 */
                public String getPlaceOfIssue() {
                    return placeOfIssue;
                }

                /** 
                 * Set the 'PlaceOfIssue' element value.
                 * 
                 * @param placeOfIssue
                 */
                public void setPlaceOfIssue(String placeOfIssue) {
                    this.placeOfIssue = placeOfIssue;
                }

                /** 
                 * Get the 'IssueDate' attribute value.
                 * 
                 * @return value
                 */
                public Date getIssueDate() {
                    return issueDate;
                }

                /** 
                 * Set the 'IssueDate' attribute value.
                 * 
                 * @param issueDate
                 */
                public void setIssueDate(Date issueDate) {
                    this.issueDate = issueDate;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PersonName" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="GivenName" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="MiddleName" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="Surname" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:date" use="optional" name="DateOfBirth"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="DocumentHolder"/>
         *     &lt;xs:attribute use="optional" name="Gender">
         *       &lt;xs:simpleType>
         *         &lt;!-- Reference to inner class Gender -->
         *       &lt;/xs:simpleType>
         *     &lt;/xs:attribute>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="LapChild"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="NameNumber"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PersonName implements Serializable
        {
            private String givenName;
            private String middleName;
            private String surname;
            private Date dateOfBirth;
            private Boolean documentHolder;
            private Gender gender;
            private Boolean lapChild;
            private String nameNumber;

            /** 
             * Get the 'GivenName' element value.
             * 
             * @return value
             */
            public String getGivenName() {
                return givenName;
            }

            /** 
             * Set the 'GivenName' element value.
             * 
             * @param givenName
             */
            public void setGivenName(String givenName) {
                this.givenName = givenName;
            }

            /** 
             * Get the 'MiddleName' element value.
             * 
             * @return value
             */
            public String getMiddleName() {
                return middleName;
            }

            /** 
             * Set the 'MiddleName' element value.
             * 
             * @param middleName
             */
            public void setMiddleName(String middleName) {
                this.middleName = middleName;
            }

            /** 
             * Get the 'Surname' element value.
             * 
             * @return value
             */
            public String getSurname() {
                return surname;
            }

            /** 
             * Set the 'Surname' element value.
             * 
             * @param surname
             */
            public void setSurname(String surname) {
                this.surname = surname;
            }

            /** 
             * Get the 'DateOfBirth' attribute value.
             * 
             * @return value
             */
            public Date getDateOfBirth() {
                return dateOfBirth;
            }

            /** 
             * Set the 'DateOfBirth' attribute value.
             * 
             * @param dateOfBirth
             */
            public void setDateOfBirth(Date dateOfBirth) {
                this.dateOfBirth = dateOfBirth;
            }

            /** 
             * Get the 'DocumentHolder' attribute value.
             * 
             * @return value
             */
            public Boolean getDocumentHolder() {
                return documentHolder;
            }

            /** 
             * Set the 'DocumentHolder' attribute value.
             * 
             * @param documentHolder
             */
            public void setDocumentHolder(Boolean documentHolder) {
                this.documentHolder = documentHolder;
            }

            /** 
             * Get the 'Gender' attribute value.
             * 
             * @return value
             */
            public Gender getGender() {
                return gender;
            }

            /** 
             * Set the 'Gender' attribute value.
             * 
             * @param gender
             */
            public void setGender(Gender gender) {
                this.gender = gender;
            }

            /** 
             * Get the 'LapChild' attribute value.
             * 
             * @return value
             */
            public Boolean getLapChild() {
                return lapChild;
            }

            /** 
             * Set the 'LapChild' attribute value.
             * 
             * @param lapChild
             */
            public void setLapChild(Boolean lapChild) {
                this.lapChild = lapChild;
            }

            /** 
             * Get the 'NameNumber' attribute value.
             * 
             * @return value
             */
            public String getNameNumber() {
                return nameNumber;
            }

            /** 
             * Set the 'NameNumber' attribute value.
             * 
             * @param nameNumber
             */
            public void setNameNumber(String nameNumber) {
                this.nameNumber = nameNumber;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
             *   &lt;xs:restriction base="xs:string">
             *     &lt;xs:enumeration value="F"/>
             *     &lt;xs:enumeration value="M"/>
             *     &lt;xs:enumeration value="FI"/>
             *     &lt;xs:enumeration value="MI"/>
             *     &lt;xs:enumeration value="U"/>
             *     &lt;xs:enumeration value="X"/>
             *   &lt;/xs:restriction>
             * &lt;/xs:simpleType>
             * </pre>
             */
            public static enum Gender implements Serializable {
                F, M, FI, MI, U, X
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ResidentDestinationAddress" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="City" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="Country"/>
         *       &lt;xs:element type="xs:string" name="Street" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="State" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="Zip" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="required" name="Type"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ResidentDestinationAddress implements Serializable
        {
            private String city;
            private String country;
            private String street;
            private String state;
            private String zip;
            private String type;

            /** 
             * Get the 'City' element value.
             * 
             * @return value
             */
            public String getCity() {
                return city;
            }

            /** 
             * Set the 'City' element value.
             * 
             * @param city
             */
            public void setCity(String city) {
                this.city = city;
            }

            /** 
             * Get the 'Country' element value.
             * 
             * @return value
             */
            public String getCountry() {
                return country;
            }

            /** 
             * Set the 'Country' element value.
             * 
             * @param country
             */
            public void setCountry(String country) {
                this.country = country;
            }

            /** 
             * Get the 'Street' element value.
             * 
             * @return value
             */
            public String getStreet() {
                return street;
            }

            /** 
             * Set the 'Street' element value.
             * 
             * @param street
             */
            public void setStreet(String street) {
                this.street = street;
            }

            /** 
             * Get the 'State' element value.
             * 
             * @return value
             */
            public String getState() {
                return state;
            }

            /** 
             * Set the 'State' element value.
             * 
             * @param state
             */
            public void setState(String state) {
                this.state = state;
            }

            /** 
             * Get the 'Zip' element value.
             * 
             * @return value
             */
            public String getZip() {
                return zip;
            }

            /** 
             * Set the 'Zip' element value.
             * 
             * @param zip
             */
            public void setZip(String zip) {
                this.zip = zip;
            }

            /** 
             * Get the 'Type' attribute value.
             * 
             * @return value
             */
            public String getType() {
                return type;
            }

            /** 
             * Set the 'Type' attribute value.
             * 
             * @param type
             */
            public void setType(String type) {
                this.type = type;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VendorPrefs" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Airline">
         *         &lt;xs:complexType>
         *           &lt;xs:attribute type="xs:boolean" use="optional" name="Hosted"/>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class VendorPrefs implements Serializable
        {
            private Boolean airline;

            /** 
             * Get the 'Hosted' attribute value.
             * 
             * @return value
             */
            public Boolean getAirline() {
                return airline;
            }

            /** 
             * Set the 'Hosted' attribute value.
             * 
             * @param airline
             */
            public void setAirline(Boolean airline) {
                this.airline = airline;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SecureFlight" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="IssueCountry" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="KnownTravelerNumber" minOccurs="0"/>
     *       &lt;xs:element name="PersonName" minOccurs="0">
     *         &lt;!-- Reference to inner class PersonName -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:string" name="RedressNumber" minOccurs="0"/>
     *       &lt;xs:element name="VendorPrefs" minOccurs="0">
     *         &lt;!-- Reference to inner class VendorPrefs -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="optional" name="SegmentNumber"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class SecureFlight implements Serializable
    {
        private String issueCountry;
        private String knownTravelerNumber;
        private PersonName personName;
        private String redressNumber;
        private VendorPrefs vendorPrefs;
        private String segmentNumber;

        /** 
         * Get the 'IssueCountry' element value.
         * 
         * @return value
         */
        public String getIssueCountry() {
            return issueCountry;
        }

        /** 
         * Set the 'IssueCountry' element value.
         * 
         * @param issueCountry
         */
        public void setIssueCountry(String issueCountry) {
            this.issueCountry = issueCountry;
        }

        /** 
         * Get the 'KnownTravelerNumber' element value.
         * 
         * @return value
         */
        public String getKnownTravelerNumber() {
            return knownTravelerNumber;
        }

        /** 
         * Set the 'KnownTravelerNumber' element value.
         * 
         * @param knownTravelerNumber
         */
        public void setKnownTravelerNumber(String knownTravelerNumber) {
            this.knownTravelerNumber = knownTravelerNumber;
        }

        /** 
         * Get the 'PersonName' element value.
         * 
         * @return value
         */
        public PersonName getPersonName() {
            return personName;
        }

        /** 
         * Set the 'PersonName' element value.
         * 
         * @param personName
         */
        public void setPersonName(PersonName personName) {
            this.personName = personName;
        }

        /** 
         * Get the 'RedressNumber' element value.
         * 
         * @return value
         */
        public String getRedressNumber() {
            return redressNumber;
        }

        /** 
         * Set the 'RedressNumber' element value.
         * 
         * @param redressNumber
         */
        public void setRedressNumber(String redressNumber) {
            this.redressNumber = redressNumber;
        }

        /** 
         * Get the 'VendorPrefs' element value.
         * 
         * @return value
         */
        public VendorPrefs getVendorPrefs() {
            return vendorPrefs;
        }

        /** 
         * Set the 'VendorPrefs' element value.
         * 
         * @param vendorPrefs
         */
        public void setVendorPrefs(VendorPrefs vendorPrefs) {
            this.vendorPrefs = vendorPrefs;
        }

        /** 
         * Get the 'SegmentNumber' attribute value.
         * 
         * @return value
         */
        public String getSegmentNumber() {
            return segmentNumber;
        }

        /** 
         * Set the 'SegmentNumber' attribute value.
         * 
         * @param segmentNumber
         */
        public void setSegmentNumber(String segmentNumber) {
            this.segmentNumber = segmentNumber;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PersonName" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="GivenName" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="Surname" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="optional" name="DateOfBirth"/>
         *     &lt;xs:attribute use="optional" name="Gender">
         *       &lt;xs:simpleType>
         *         &lt;!-- Reference to inner class Gender -->
         *       &lt;/xs:simpleType>
         *     &lt;/xs:attribute>
         *     &lt;xs:attribute type="xs:string" use="optional" name="NameNumber"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PersonName implements Serializable
        {
            private String givenName;
            private String surname;
            private String dateOfBirth;
            private Gender gender;
            private String nameNumber;

            /** 
             * Get the 'GivenName' element value.
             * 
             * @return value
             */
            public String getGivenName() {
                return givenName;
            }

            /** 
             * Set the 'GivenName' element value.
             * 
             * @param givenName
             */
            public void setGivenName(String givenName) {
                this.givenName = givenName;
            }

            /** 
             * Get the 'Surname' element value.
             * 
             * @return value
             */
            public String getSurname() {
                return surname;
            }

            /** 
             * Set the 'Surname' element value.
             * 
             * @param surname
             */
            public void setSurname(String surname) {
                this.surname = surname;
            }

            /** 
             * Get the 'DateOfBirth' attribute value.
             * 
             * @return value
             */
            public String getDateOfBirth() {
                return dateOfBirth;
            }

            /** 
             * Set the 'DateOfBirth' attribute value.
             * 
             * @param dateOfBirth
             */
            public void setDateOfBirth(String dateOfBirth) {
                this.dateOfBirth = dateOfBirth;
            }

            /** 
             * Get the 'Gender' attribute value.
             * 
             * @return value
             */
            public Gender getGender() {
                return gender;
            }

            /** 
             * Set the 'Gender' attribute value.
             * 
             * @param gender
             */
            public void setGender(Gender gender) {
                this.gender = gender;
            }

            /** 
             * Get the 'NameNumber' attribute value.
             * 
             * @return value
             */
            public String getNameNumber() {
                return nameNumber;
            }

            /** 
             * Set the 'NameNumber' attribute value.
             * 
             * @param nameNumber
             */
            public void setNameNumber(String nameNumber) {
                this.nameNumber = nameNumber;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
             *   &lt;xs:restriction base="xs:string">
             *     &lt;xs:enumeration value="F"/>
             *     &lt;xs:enumeration value="M"/>
             *     &lt;xs:enumeration value="FI"/>
             *     &lt;xs:enumeration value="MI"/>
             *     &lt;xs:enumeration value="U"/>
             *     &lt;xs:enumeration value="X"/>
             *   &lt;/xs:restriction>
             * &lt;/xs:simpleType>
             * </pre>
             */
            public static enum Gender implements Serializable {
                F, M, FI, MI, U, X
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VendorPrefs" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Airline">
         *         &lt;xs:complexType>
         *           &lt;xs:attribute type="xs:boolean" use="optional" name="Hosted"/>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class VendorPrefs implements Serializable
        {
            private Boolean airline;

            /** 
             * Get the 'Hosted' attribute value.
             * 
             * @return value
             */
            public Boolean getAirline() {
                return airline;
            }

            /** 
             * Set the 'Hosted' attribute value.
             * 
             * @param airline
             */
            public void setAirline(Boolean airline) {
                this.airline = airline;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Service" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="PersonName" minOccurs="0">
     *         &lt;!-- Reference to inner class PersonName -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
     *       &lt;xs:element name="VendorPrefs" minOccurs="0">
     *         &lt;!-- Reference to inner class VendorPrefs -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="optional" name="SegmentNumber"/>
     *     &lt;xs:attribute type="xs:string" use="required" name="SSR_Code"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Service implements Serializable
    {
        private PersonName personName;
        private String text;
        private VendorPrefs vendorPrefs;
        private String segmentNumber;
        private String SSRCode;

        /** 
         * Get the 'PersonName' element value.
         * 
         * @return value
         */
        public PersonName getPersonName() {
            return personName;
        }

        /** 
         * Set the 'PersonName' element value.
         * 
         * @param personName
         */
        public void setPersonName(PersonName personName) {
            this.personName = personName;
        }

        /** 
         * Get the 'Text' element value.
         * 
         * @return value
         */
        public String getText() {
            return text;
        }

        /** 
         * Set the 'Text' element value.
         * 
         * @param text
         */
        public void setText(String text) {
            this.text = text;
        }

        /** 
         * Get the 'VendorPrefs' element value.
         * 
         * @return value
         */
        public VendorPrefs getVendorPrefs() {
            return vendorPrefs;
        }

        /** 
         * Set the 'VendorPrefs' element value.
         * 
         * @param vendorPrefs
         */
        public void setVendorPrefs(VendorPrefs vendorPrefs) {
            this.vendorPrefs = vendorPrefs;
        }

        /** 
         * Get the 'SegmentNumber' attribute value.
         * 
         * @return value
         */
        public String getSegmentNumber() {
            return segmentNumber;
        }

        /** 
         * Set the 'SegmentNumber' attribute value.
         * 
         * @param segmentNumber
         */
        public void setSegmentNumber(String segmentNumber) {
            this.segmentNumber = segmentNumber;
        }

        /** 
         * Get the 'SSR_Code' attribute value.
         * 
         * @return value
         */
        public String getSSRCode() {
            return SSRCode;
        }

        /** 
         * Set the 'SSR_Code' attribute value.
         * 
         * @param SSRCode
         */
        public void setSSRCode(String SSRCode) {
            this.SSRCode = SSRCode;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PersonName" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="NameNumber"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PersonName implements Serializable
        {
            private String nameNumber;

            /** 
             * Get the 'NameNumber' attribute value.
             * 
             * @return value
             */
            public String getNameNumber() {
                return nameNumber;
            }

            /** 
             * Set the 'NameNumber' attribute value.
             * 
             * @param nameNumber
             */
            public void setNameNumber(String nameNumber) {
                this.nameNumber = nameNumber;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VendorPrefs" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Airline">
         *         &lt;xs:complexType>
         *           &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
         *           &lt;xs:attribute type="xs:boolean" use="optional" name="Hosted"/>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class VendorPrefs implements Serializable
        {
            private String airlineCode;
            private Boolean airlineHosted;

            /** 
             * Get the 'Code' attribute value.
             * 
             * @return value
             */
            public String getAirlineCode() {
                return airlineCode;
            }

            /** 
             * Set the 'Code' attribute value.
             * 
             * @param airlineCode
             */
            public void setAirlineCode(String airlineCode) {
                this.airlineCode = airlineCode;
            }

            /** 
             * Get the 'Hosted' attribute value.
             * 
             * @return value
             */
            public Boolean getAirlineHosted() {
                return airlineHosted;
            }

            /** 
             * Set the 'Hosted' attribute value.
             * 
             * @param airlineHosted
             */
            public void setAirlineHosted(Boolean airlineHosted) {
                this.airlineHosted = airlineHosted;
            }
        }
    }
}
