
package com.sabre.webservices.sabrexml;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Structure Fare Rules Request
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StructureFareRulesRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:Diagnostic" minOccurs="0"/>
 *       &lt;xs:element name="PriceRequestInformation" minOccurs="0">
 *         &lt;!-- Reference to inner class PriceRequestInformation -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="AirItinerary">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element name="OriginDestinationOptions">
 *               &lt;xs:complexType>
 *                 &lt;xs:sequence>
 *                   &lt;xs:element name="OriginDestinationOption" maxOccurs="24">
 *                     &lt;!-- Reference to inner class OriginDestinationOption -->
 *                   &lt;/xs:element>
 *                 &lt;/xs:sequence>
 *               &lt;/xs:complexType>
 *             &lt;/xs:element>
 *           &lt;/xs:sequence>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:string" use="optional" name="EchoToken"/>
 *     &lt;xs:attribute type="xs:string" use="optional" name="TimeStamp"/>
 *     &lt;xs:attribute use="optional" default="Production" name="Target">
 *       &lt;xs:simpleType>
 *         &lt;!-- Reference to inner class Target -->
 *       &lt;/xs:simpleType>
 *     &lt;/xs:attribute>
 *     &lt;xs:attribute type="xs:string" use="optional" name="Version"/>
 *     &lt;xs:attribute type="xs:integer" use="optional" name="SequenceNmbr"/>
 *     &lt;xs:attribute type="xs:string" use="optional" name="PrimaryLangID"/>
 *     &lt;xs:attribute type="xs:string" use="optional" name="AltLangID"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class StructureFareRulesRQ implements Serializable
{
    private Diagnostic diagnostic;
    private PriceRequestInformation priceRequestInformation;
    private List<OriginDestinationOption> airItineraryList = new ArrayList<OriginDestinationOption>();
    private String echoToken;
    private String timeStamp;
    private Target target;
    private String version;
    private BigInteger sequenceNmbr;
    private String primaryLangID;
    private String altLangID;

    /** 
     * Get the 'Diagnostic' element value.
     * 
     * @return value
     */
    public Diagnostic getDiagnostic() {
        return diagnostic;
    }

    /** 
     * Set the 'Diagnostic' element value.
     * 
     * @param diagnostic
     */
    public void setDiagnostic(Diagnostic diagnostic) {
        this.diagnostic = diagnostic;
    }

    /** 
     * Get the 'PriceRequestInformation' element value.
     * 
     * @return value
     */
    public PriceRequestInformation getPriceRequestInformation() {
        return priceRequestInformation;
    }

    /** 
     * Set the 'PriceRequestInformation' element value.
     * 
     * @param priceRequestInformation
     */
    public void setPriceRequestInformation(
            PriceRequestInformation priceRequestInformation) {
        this.priceRequestInformation = priceRequestInformation;
    }

    /** 
     * Get the list of 'OriginDestinationOption' element items.
     * 
     * @return list
     */
    public List<OriginDestinationOption> getAirItineraryList() {
        return airItineraryList;
    }

    /** 
     * Set the list of 'OriginDestinationOption' element items.
     * 
     * @param list
     */
    public void setAirItineraryList(List<OriginDestinationOption> list) {
        airItineraryList = list;
    }

    /** 
     * Get the 'EchoToken' attribute value. A sequence number for additional message identification, assigned by the requesting host system. When a request                                       message includes an echo token the corresponding response message MUST include an echo token with an identical value.                                           
     * 
     * @return value
     */
    public String getEchoToken() {
        return echoToken;
    }

    /** 
     * Set the 'EchoToken' attribute value. A sequence number for additional message identification, assigned by the requesting host system. When a request                                       message includes an echo token the corresponding response message MUST include an echo token with an identical value.                                           
     * 
     * @param echoToken
     */
    public void setEchoToken(String echoToken) {
        this.echoToken = echoToken;
    }

    /** 
     * Get the 'TimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-    MM-                 DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-20T13:59:38Z).                     
     * 
     * @return value
     */
    public String getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-    MM-                 DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-20T13:59:38Z).                     
     * 
     * @param timeStamp
     */
    public void setTimeStamp(String timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Target' attribute value. Used to indicate whether the request is for the Test or Production system.
     * 
     * @return value
     */
    public Target getTarget() {
        return target;
    }

    /** 
     * Set the 'Target' attribute value. Used to indicate whether the request is for the Test or Production system.
     * 
     * @param target
     */
    public void setTarget(Target target) {
        this.target = target;
    }

    /** 
     * Get the 'Version' attribute value. For all OTA versioned messages, the version of the message is indicated by a decimal value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value. For all OTA versioned messages, the version of the message is indicated by a decimal value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }

    /** 
     * Get the 'SequenceNmbr' attribute value. Used to identify the sequence number of the transaction as assigned by the sending system; allows for an application to process messages in a certain order or to request a resynchronization of messages in the event that a system has been off-line and needs to retrieve messages that were missed. 
     * 
     * @return value
     */
    public BigInteger getSequenceNmbr() {
        return sequenceNmbr;
    }

    /** 
     * Set the 'SequenceNmbr' attribute value. Used to identify the sequence number of the transaction as assigned by the sending system; allows for an application to process messages in a certain order or to request a resynchronization of messages in the event that a system has been off-line and needs to retrieve messages that were missed. 
     * 
     * @param sequenceNmbr
     */
    public void setSequenceNmbr(BigInteger sequenceNmbr) {
        this.sequenceNmbr = sequenceNmbr;
    }

    /** 
     * Get the 'PrimaryLangID' attribute value. Identifes the primary language preference for the form of travel represented in a collection.
                       The human language is identified by ISO 639 codes.
     * 
     * @return value
     */
    public String getPrimaryLangID() {
        return primaryLangID;
    }

    /** 
     * Set the 'PrimaryLangID' attribute value. Identifes the primary language preference for the form of travel represented in a collection.
                       The human language is identified by ISO 639 codes.
     * 
     * @param primaryLangID
     */
    public void setPrimaryLangID(String primaryLangID) {
        this.primaryLangID = primaryLangID;
    }

    /** 
     * Get the 'AltLangID' attribute value. Identifes the primary language preference for the form of travel represented in a collection.
                       The human language is identified by ISO 639 codes.
     * 
     * @return value
     */
    public String getAltLangID() {
        return altLangID;
    }

    /** 
     * Set the 'AltLangID' attribute value. Identifes the primary language preference for the form of travel represented in a collection.
                       The human language is identified by ISO 639 codes.
     * 
     * @param altLangID
     */
    public void setAltLangID(String altLangID) {
        this.altLangID = altLangID;
    }
    /** 
     * Processing Options /PRO
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceRequestInformation" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="PassengerTypes">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element name="PassengerType" maxOccurs="4">
     *               &lt;!-- Reference to inner class PassengerType -->
     *             &lt;/xs:element>
     *           &lt;/xs:sequence>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element name="PassengerStatus" minOccurs="0">
     *         &lt;!-- Reference to inner class PassengerStatus -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="AlternateCurrency" minOccurs="0">
     *         &lt;!-- Reference to inner class AlternateCurrency -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Account" minOccurs="0" maxOccurs="4">
     *         &lt;!-- Reference to inner class Account -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Corporate" minOccurs="0" maxOccurs="4">
     *         &lt;!-- Reference to inner class Corporate -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ForceCorporate" minOccurs="0">
     *         &lt;!-- Reference to inner class ForceCorporate -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="PublicFare" minOccurs="0">
     *         &lt;!-- Reference to inner class PublicFare -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="PrivateFare" minOccurs="0">
     *         &lt;!-- Reference to inner class PrivateFare -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="NetFare" minOccurs="0">
     *         &lt;!-- Reference to inner class NetFare -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="OnlineFare" minOccurs="0">
     *         &lt;!-- Reference to inner class OnlineFare -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="IATA_Fare" minOccurs="0">
     *         &lt;!-- Reference to inner class IATAFare -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ValidatingCarrier" minOccurs="0">
     *         &lt;!-- Reference to inner class ValidatingCarrier -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="OverridePurchaseCity" minOccurs="0">
     *         &lt;!-- Reference to inner class OverridePurchaseCity -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="OverrideTicketingCity" minOccurs="0">
     *         &lt;!-- Reference to inner class OverrideTicketingCity -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="BSR" minOccurs="0">
     *         &lt;!-- Reference to inner class BSR -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="NoPenalty" minOccurs="0">
     *         &lt;!-- Reference to inner class NoPenalty -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="NoAdvancePurchase" minOccurs="0">
     *         &lt;!-- Reference to inner class NoAdvancePurchase -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="NoMinMaxStay" minOccurs="0">
     *         &lt;!-- Reference to inner class NoMinMaxStay -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="LowFareNoRebook" minOccurs="0">
     *         &lt;!-- Reference to inner class LowFareNoRebook -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="AwardShoppingPricing" minOccurs="0">
     *         &lt;!-- Reference to inner class AwardShoppingPricing -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="PriceNoAvailability" minOccurs="0">
     *         &lt;!-- Reference to inner class PriceNoAvailability -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="CurrencyOverride" minOccurs="0">
     *         &lt;!-- Reference to inner class CurrencyOverride -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ReturnAllData" minOccurs="0">
     *         &lt;!-- Reference to inner class ReturnAllData -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ATB_FareCalc" minOccurs="0">
     *         &lt;!-- Reference to inner class ATBFareCalc -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="EquivalentAmountOverride" minOccurs="0">
     *         &lt;!-- Reference to inner class EquivalentAmountOverride -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="NormalFare" minOccurs="0">
     *         &lt;!-- Reference to inner class NormalFare -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="LowFareNoAvailability" minOccurs="0">
     *         &lt;!-- Reference to inner class LowFareNoAvailability -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="LowFareRequested" minOccurs="0">
     *         &lt;!-- Reference to inner class LowFareRequested -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="RoundTheWorld" minOccurs="0">
     *         &lt;!-- Reference to inner class RoundTheWorld -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="SettlementMethod" minOccurs="0">
     *         &lt;!-- Reference to inner class SettlementMethod -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="PriceNullDate" minOccurs="0">
     *         &lt;!-- Reference to inner class PriceNullDate -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="TicketEntry" minOccurs="0">
     *         &lt;!-- Reference to inner class TicketEntry -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Cat35FarePreference" minOccurs="0">
     *         &lt;!-- Reference to inner class Cat35FarePreference -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FormOfPayment" minOccurs="0">
     *         &lt;!-- Reference to inner class FormOfPayment -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ExemptFromPFCTax" minOccurs="0">
     *         &lt;!-- Reference to inner class ExemptFromPFCTax -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="TicketStock" minOccurs="0">
     *         &lt;!-- Reference to inner class TicketStock -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="AgentCommission" minOccurs="0">
     *         &lt;!-- Reference to inner class AgentCommission -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="WebBasedFare" minOccurs="0">
     *         &lt;!-- Reference to inner class WebBasedFare -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="EticketableFare" minOccurs="0">
     *         &lt;!-- Reference to inner class EticketableFare -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Government" minOccurs="0">
     *         &lt;!-- Reference to inner class Government -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="PassengerNameRecord" minOccurs="0">
     *         &lt;!-- Reference to inner class PassengerNameRecord -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="LineEntry" minOccurs="0">
     *         &lt;!-- Reference to inner class LineEntry -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="OverrideTaxes" minOccurs="0">
     *         &lt;!-- Reference to inner class OverrideTaxes -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="M_Override" minOccurs="0">
     *         &lt;!-- Reference to inner class MOverride -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="RQ" minOccurs="0">
     *         &lt;!-- Reference to inner class RQ -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="IgnoreFuelSurcharge" minOccurs="0">
     *         &lt;!-- Reference to inner class IgnoreFuelSurcharge -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="BookingCodeOverride" minOccurs="0">
     *         &lt;!-- Reference to inner class BookingCodeOverride -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FreeBaggageSubscriber" minOccurs="0">
     *         &lt;!-- Reference to inner class FreeBaggageSubscriber -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="PCCHostCarrier" minOccurs="0">
     *         &lt;!-- Reference to inner class PCCHostCarrier -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FareFamily" minOccurs="0">
     *         &lt;!-- Reference to inner class FareFamily -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FareX" minOccurs="0">
     *         &lt;!-- Reference to inner class FareX -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="UpSellEntry" minOccurs="0">
     *         &lt;!-- Reference to inner class UpSellEntry -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="PaperTicketSurcharge" minOccurs="0">
     *         &lt;!-- Reference to inner class PaperTicketSurcharge -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ConsolidatorPlusUp" minOccurs="0">
     *         &lt;!-- Reference to inner class ConsolidatorPlusUp -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="CreditCard" minOccurs="0">
     *         &lt;!-- Reference to inner class CreditCard -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Confirmation" minOccurs="0">
     *         &lt;!-- Reference to inner class Confirmation -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="IgnoreNameChange" minOccurs="0">
     *         &lt;!-- Reference to inner class IgnoreNameChange -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="IgnoreSegmentChange" minOccurs="0">
     *         &lt;!-- Reference to inner class IgnoreSegmentChange -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="IgnoreNetRemit" minOccurs="0">
     *         &lt;!-- Reference to inner class IgnoreNetRemit -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="NetSell" minOccurs="0">
     *         &lt;!-- Reference to inner class NetSell -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ChargeAmount" minOccurs="0">
     *         &lt;!-- Reference to inner class ChargeAmount -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ChargeResidual" minOccurs="0">
     *         &lt;!-- Reference to inner class ChargeResidual -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ExcludeFareFocusRule" minOccurs="0">
     *         &lt;!-- Reference to inner class ExcludeFareFocusRule -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="PriceByBrand" minOccurs="0">
     *         &lt;!-- Reference to inner class PriceByBrand -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="RetailerRules" minOccurs="0" maxOccurs="1">
     *         &lt;!-- Reference to inner class RetailerRules -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="BuyingDate"/>
     *     &lt;xs:attribute type="ns:SpanishLargeFamilyDiscountLevel" use="optional" name="SpanishFamilyDiscount"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PriceRequestInformation implements Serializable
    {
        private List<PassengerType> passengerTypeList = new ArrayList<PassengerType>();
        private PassengerStatus passengerStatus;
        private AlternateCurrency alternateCurrency;
        private List<Account> accountList = new ArrayList<Account>();
        private List<Corporate> corporateList = new ArrayList<Corporate>();
        private ForceCorporate forceCorporate;
        private PublicFare publicFare;
        private PrivateFare privateFare;
        private NetFare netFare;
        private OnlineFare onlineFare;
        private IATAFare IATAFare1;
        private ValidatingCarrier validatingCarrier;
        private OverridePurchaseCity overridePurchaseCity;
        private OverrideTicketingCity overrideTicketingCity;
        private BSR BSR1;
        private NoPenalty noPenalty;
        private NoAdvancePurchase noAdvancePurchase;
        private NoMinMaxStay noMinMaxStay;
        private LowFareNoRebook lowFareNoRebook;
        private AwardShoppingPricing awardShoppingPricing;
        private PriceNoAvailability priceNoAvailability;
        private CurrencyOverride currencyOverride;
        private ReturnAllData returnAllData;
        private ATBFareCalc ATBFareCalc1;
        private EquivalentAmountOverride equivalentAmountOverride;
        private NormalFare normalFare;
        private LowFareNoAvailability lowFareNoAvailability;
        private LowFareRequested lowFareRequested;
        private RoundTheWorld roundTheWorld;
        private SettlementMethod settlementMethod;
        private PriceNullDate priceNullDate;
        private TicketEntry ticketEntry;
        private Cat35FarePreference cat35FarePreference;
        private FormOfPayment formOfPayment;
        private ExemptFromPFCTax exemptFromPFCTax;
        private TicketStock ticketStock;
        private AgentCommission agentCommission;
        private WebBasedFare webBasedFare;
        private EticketableFare eticketableFare;
        private Government government;
        private PassengerNameRecord passengerNameRecord;
        private LineEntry lineEntry;
        private OverrideTaxes overrideTaxes;
        private MOverride MOverride1;
        private RQ RQ1;
        private IgnoreFuelSurcharge ignoreFuelSurcharge;
        private BookingCodeOverride bookingCodeOverride;
        private FreeBaggageSubscriber freeBaggageSubscriber;
        private PCCHostCarrier PCCHostCarrier1;
        private FareFamily fareFamily;
        private FareX fareX;
        private UpSellEntry upSellEntry;
        private PaperTicketSurcharge paperTicketSurcharge;
        private ConsolidatorPlusUp consolidatorPlusUp;
        private CreditCard creditCard;
        private Confirmation confirmation;
        private IgnoreNameChange ignoreNameChange;
        private IgnoreSegmentChange ignoreSegmentChange;
        private IgnoreNetRemit ignoreNetRemit;
        private NetSell netSell;
        private ChargeAmount chargeAmount;
        private ChargeResidual chargeResidual;
        private ExcludeFareFocusRule excludeFareFocusRule;
        private PriceByBrand priceByBrand;
        private RetailerRules retailerRules;
        private String currencyCode;
        private String buyingDate;
        private SpanishLargeFamilyDiscountLevel spanishFamilyDiscount;

        /** 
         * Get the list of 'PassengerType' element items.
         * 
         * @return list
         */
        public List<PassengerType> getPassengerTypeList() {
            return passengerTypeList;
        }

        /** 
         * Set the list of 'PassengerType' element items.
         * 
         * @param list
         */
        public void setPassengerTypeList(List<PassengerType> list) {
            passengerTypeList = list;
        }

        /** 
         * Get the 'PassengerStatus' element value.
         * 
         * @return value
         */
        public PassengerStatus getPassengerStatus() {
            return passengerStatus;
        }

        /** 
         * Set the 'PassengerStatus' element value.
         * 
         * @param passengerStatus
         */
        public void setPassengerStatus(PassengerStatus passengerStatus) {
            this.passengerStatus = passengerStatus;
        }

        /** 
         * Get the 'AlternateCurrency' element value.
         * 
         * @return value
         */
        public AlternateCurrency getAlternateCurrency() {
            return alternateCurrency;
        }

        /** 
         * Set the 'AlternateCurrency' element value.
         * 
         * @param alternateCurrency
         */
        public void setAlternateCurrency(AlternateCurrency alternateCurrency) {
            this.alternateCurrency = alternateCurrency;
        }

        /** 
         * Get the list of 'Account' element items.
         * 
         * @return list
         */
        public List<Account> getAccountList() {
            return accountList;
        }

        /** 
         * Set the list of 'Account' element items.
         * 
         * @param list
         */
        public void setAccountList(List<Account> list) {
            accountList = list;
        }

        /** 
         * Get the list of 'Corporate' element items.
         * 
         * @return list
         */
        public List<Corporate> getCorporateList() {
            return corporateList;
        }

        /** 
         * Set the list of 'Corporate' element items.
         * 
         * @param list
         */
        public void setCorporateList(List<Corporate> list) {
            corporateList = list;
        }

        /** 
         * Get the 'ForceCorporate' element value.
         * 
         * @return value
         */
        public ForceCorporate getForceCorporate() {
            return forceCorporate;
        }

        /** 
         * Set the 'ForceCorporate' element value.
         * 
         * @param forceCorporate
         */
        public void setForceCorporate(ForceCorporate forceCorporate) {
            this.forceCorporate = forceCorporate;
        }

        /** 
         * Get the 'PublicFare' element value.
         * 
         * @return value
         */
        public PublicFare getPublicFare() {
            return publicFare;
        }

        /** 
         * Set the 'PublicFare' element value.
         * 
         * @param publicFare
         */
        public void setPublicFare(PublicFare publicFare) {
            this.publicFare = publicFare;
        }

        /** 
         * Get the 'PrivateFare' element value.
         * 
         * @return value
         */
        public PrivateFare getPrivateFare() {
            return privateFare;
        }

        /** 
         * Set the 'PrivateFare' element value.
         * 
         * @param privateFare
         */
        public void setPrivateFare(PrivateFare privateFare) {
            this.privateFare = privateFare;
        }

        /** 
         * Get the 'NetFare' element value.
         * 
         * @return value
         */
        public NetFare getNetFare() {
            return netFare;
        }

        /** 
         * Set the 'NetFare' element value.
         * 
         * @param netFare
         */
        public void setNetFare(NetFare netFare) {
            this.netFare = netFare;
        }

        /** 
         * Get the 'OnlineFare' element value.
         * 
         * @return value
         */
        public OnlineFare getOnlineFare() {
            return onlineFare;
        }

        /** 
         * Set the 'OnlineFare' element value.
         * 
         * @param onlineFare
         */
        public void setOnlineFare(OnlineFare onlineFare) {
            this.onlineFare = onlineFare;
        }

        /** 
         * Get the 'IATA_Fare' element value.
         * 
         * @return value
         */
        public IATAFare getIATAFare1() {
            return IATAFare1;
        }

        /** 
         * Set the 'IATA_Fare' element value.
         * 
         * @param IATAFare1
         */
        public void setIATAFare1(IATAFare IATAFare1) {
            this.IATAFare1 = IATAFare1;
        }

        /** 
         * Get the 'ValidatingCarrier' element value.
         * 
         * @return value
         */
        public ValidatingCarrier getValidatingCarrier() {
            return validatingCarrier;
        }

        /** 
         * Set the 'ValidatingCarrier' element value.
         * 
         * @param validatingCarrier
         */
        public void setValidatingCarrier(ValidatingCarrier validatingCarrier) {
            this.validatingCarrier = validatingCarrier;
        }

        /** 
         * Get the 'OverridePurchaseCity' element value.
         * 
         * @return value
         */
        public OverridePurchaseCity getOverridePurchaseCity() {
            return overridePurchaseCity;
        }

        /** 
         * Set the 'OverridePurchaseCity' element value.
         * 
         * @param overridePurchaseCity
         */
        public void setOverridePurchaseCity(
                OverridePurchaseCity overridePurchaseCity) {
            this.overridePurchaseCity = overridePurchaseCity;
        }

        /** 
         * Get the 'OverrideTicketingCity' element value.
         * 
         * @return value
         */
        public OverrideTicketingCity getOverrideTicketingCity() {
            return overrideTicketingCity;
        }

        /** 
         * Set the 'OverrideTicketingCity' element value.
         * 
         * @param overrideTicketingCity
         */
        public void setOverrideTicketingCity(
                OverrideTicketingCity overrideTicketingCity) {
            this.overrideTicketingCity = overrideTicketingCity;
        }

        /** 
         * Get the 'BSR' element value.
         * 
         * @return value
         */
        public BSR getBSR1() {
            return BSR1;
        }

        /** 
         * Set the 'BSR' element value.
         * 
         * @param BSR1
         */
        public void setBSR1(BSR BSR1) {
            this.BSR1 = BSR1;
        }

        /** 
         * Get the 'NoPenalty' element value.
         * 
         * @return value
         */
        public NoPenalty getNoPenalty() {
            return noPenalty;
        }

        /** 
         * Set the 'NoPenalty' element value.
         * 
         * @param noPenalty
         */
        public void setNoPenalty(NoPenalty noPenalty) {
            this.noPenalty = noPenalty;
        }

        /** 
         * Get the 'NoAdvancePurchase' element value.
         * 
         * @return value
         */
        public NoAdvancePurchase getNoAdvancePurchase() {
            return noAdvancePurchase;
        }

        /** 
         * Set the 'NoAdvancePurchase' element value.
         * 
         * @param noAdvancePurchase
         */
        public void setNoAdvancePurchase(NoAdvancePurchase noAdvancePurchase) {
            this.noAdvancePurchase = noAdvancePurchase;
        }

        /** 
         * Get the 'NoMinMaxStay' element value.
         * 
         * @return value
         */
        public NoMinMaxStay getNoMinMaxStay() {
            return noMinMaxStay;
        }

        /** 
         * Set the 'NoMinMaxStay' element value.
         * 
         * @param noMinMaxStay
         */
        public void setNoMinMaxStay(NoMinMaxStay noMinMaxStay) {
            this.noMinMaxStay = noMinMaxStay;
        }

        /** 
         * Get the 'LowFareNoRebook' element value.
         * 
         * @return value
         */
        public LowFareNoRebook getLowFareNoRebook() {
            return lowFareNoRebook;
        }

        /** 
         * Set the 'LowFareNoRebook' element value.
         * 
         * @param lowFareNoRebook
         */
        public void setLowFareNoRebook(LowFareNoRebook lowFareNoRebook) {
            this.lowFareNoRebook = lowFareNoRebook;
        }

        /** 
         * Get the 'AwardShoppingPricing' element value.
         * 
         * @return value
         */
        public AwardShoppingPricing getAwardShoppingPricing() {
            return awardShoppingPricing;
        }

        /** 
         * Set the 'AwardShoppingPricing' element value.
         * 
         * @param awardShoppingPricing
         */
        public void setAwardShoppingPricing(
                AwardShoppingPricing awardShoppingPricing) {
            this.awardShoppingPricing = awardShoppingPricing;
        }

        /** 
         * Get the 'PriceNoAvailability' element value.
         * 
         * @return value
         */
        public PriceNoAvailability getPriceNoAvailability() {
            return priceNoAvailability;
        }

        /** 
         * Set the 'PriceNoAvailability' element value.
         * 
         * @param priceNoAvailability
         */
        public void setPriceNoAvailability(
                PriceNoAvailability priceNoAvailability) {
            this.priceNoAvailability = priceNoAvailability;
        }

        /** 
         * Get the 'CurrencyOverride' element value.
         * 
         * @return value
         */
        public CurrencyOverride getCurrencyOverride() {
            return currencyOverride;
        }

        /** 
         * Set the 'CurrencyOverride' element value.
         * 
         * @param currencyOverride
         */
        public void setCurrencyOverride(CurrencyOverride currencyOverride) {
            this.currencyOverride = currencyOverride;
        }

        /** 
         * Get the 'ReturnAllData' element value.
         * 
         * @return value
         */
        public ReturnAllData getReturnAllData() {
            return returnAllData;
        }

        /** 
         * Set the 'ReturnAllData' element value.
         * 
         * @param returnAllData
         */
        public void setReturnAllData(ReturnAllData returnAllData) {
            this.returnAllData = returnAllData;
        }

        /** 
         * Get the 'ATB_FareCalc' element value.
         * 
         * @return value
         */
        public ATBFareCalc getATBFareCalc1() {
            return ATBFareCalc1;
        }

        /** 
         * Set the 'ATB_FareCalc' element value.
         * 
         * @param ATBFareCalc1
         */
        public void setATBFareCalc1(ATBFareCalc ATBFareCalc1) {
            this.ATBFareCalc1 = ATBFareCalc1;
        }

        /** 
         * Get the 'EquivalentAmountOverride' element value.
         * 
         * @return value
         */
        public EquivalentAmountOverride getEquivalentAmountOverride() {
            return equivalentAmountOverride;
        }

        /** 
         * Set the 'EquivalentAmountOverride' element value.
         * 
         * @param equivalentAmountOverride
         */
        public void setEquivalentAmountOverride(
                EquivalentAmountOverride equivalentAmountOverride) {
            this.equivalentAmountOverride = equivalentAmountOverride;
        }

        /** 
         * Get the 'NormalFare' element value.
         * 
         * @return value
         */
        public NormalFare getNormalFare() {
            return normalFare;
        }

        /** 
         * Set the 'NormalFare' element value.
         * 
         * @param normalFare
         */
        public void setNormalFare(NormalFare normalFare) {
            this.normalFare = normalFare;
        }

        /** 
         * Get the 'LowFareNoAvailability' element value.
         * 
         * @return value
         */
        public LowFareNoAvailability getLowFareNoAvailability() {
            return lowFareNoAvailability;
        }

        /** 
         * Set the 'LowFareNoAvailability' element value.
         * 
         * @param lowFareNoAvailability
         */
        public void setLowFareNoAvailability(
                LowFareNoAvailability lowFareNoAvailability) {
            this.lowFareNoAvailability = lowFareNoAvailability;
        }

        /** 
         * Get the 'LowFareRequested' element value.
         * 
         * @return value
         */
        public LowFareRequested getLowFareRequested() {
            return lowFareRequested;
        }

        /** 
         * Set the 'LowFareRequested' element value.
         * 
         * @param lowFareRequested
         */
        public void setLowFareRequested(LowFareRequested lowFareRequested) {
            this.lowFareRequested = lowFareRequested;
        }

        /** 
         * Get the 'RoundTheWorld' element value.
         * 
         * @return value
         */
        public RoundTheWorld getRoundTheWorld() {
            return roundTheWorld;
        }

        /** 
         * Set the 'RoundTheWorld' element value.
         * 
         * @param roundTheWorld
         */
        public void setRoundTheWorld(RoundTheWorld roundTheWorld) {
            this.roundTheWorld = roundTheWorld;
        }

        /** 
         * Get the 'SettlementMethod' element value.
         * 
         * @return value
         */
        public SettlementMethod getSettlementMethod() {
            return settlementMethod;
        }

        /** 
         * Set the 'SettlementMethod' element value.
         * 
         * @param settlementMethod
         */
        public void setSettlementMethod(SettlementMethod settlementMethod) {
            this.settlementMethod = settlementMethod;
        }

        /** 
         * Get the 'PriceNullDate' element value.
         * 
         * @return value
         */
        public PriceNullDate getPriceNullDate() {
            return priceNullDate;
        }

        /** 
         * Set the 'PriceNullDate' element value.
         * 
         * @param priceNullDate
         */
        public void setPriceNullDate(PriceNullDate priceNullDate) {
            this.priceNullDate = priceNullDate;
        }

        /** 
         * Get the 'TicketEntry' element value.
         * 
         * @return value
         */
        public TicketEntry getTicketEntry() {
            return ticketEntry;
        }

        /** 
         * Set the 'TicketEntry' element value.
         * 
         * @param ticketEntry
         */
        public void setTicketEntry(TicketEntry ticketEntry) {
            this.ticketEntry = ticketEntry;
        }

        /** 
         * Get the 'Cat35FarePreference' element value.
         * 
         * @return value
         */
        public Cat35FarePreference getCat35FarePreference() {
            return cat35FarePreference;
        }

        /** 
         * Set the 'Cat35FarePreference' element value.
         * 
         * @param cat35FarePreference
         */
        public void setCat35FarePreference(
                Cat35FarePreference cat35FarePreference) {
            this.cat35FarePreference = cat35FarePreference;
        }

        /** 
         * Get the 'FormOfPayment' element value.
         * 
         * @return value
         */
        public FormOfPayment getFormOfPayment() {
            return formOfPayment;
        }

        /** 
         * Set the 'FormOfPayment' element value.
         * 
         * @param formOfPayment
         */
        public void setFormOfPayment(FormOfPayment formOfPayment) {
            this.formOfPayment = formOfPayment;
        }

        /** 
         * Get the 'ExemptFromPFCTax' element value.
         * 
         * @return value
         */
        public ExemptFromPFCTax getExemptFromPFCTax() {
            return exemptFromPFCTax;
        }

        /** 
         * Set the 'ExemptFromPFCTax' element value.
         * 
         * @param exemptFromPFCTax
         */
        public void setExemptFromPFCTax(ExemptFromPFCTax exemptFromPFCTax) {
            this.exemptFromPFCTax = exemptFromPFCTax;
        }

        /** 
         * Get the 'TicketStock' element value.
         * 
         * @return value
         */
        public TicketStock getTicketStock() {
            return ticketStock;
        }

        /** 
         * Set the 'TicketStock' element value.
         * 
         * @param ticketStock
         */
        public void setTicketStock(TicketStock ticketStock) {
            this.ticketStock = ticketStock;
        }

        /** 
         * Get the 'AgentCommission' element value.
         * 
         * @return value
         */
        public AgentCommission getAgentCommission() {
            return agentCommission;
        }

        /** 
         * Set the 'AgentCommission' element value.
         * 
         * @param agentCommission
         */
        public void setAgentCommission(AgentCommission agentCommission) {
            this.agentCommission = agentCommission;
        }

        /** 
         * Get the 'WebBasedFare' element value.
         * 
         * @return value
         */
        public WebBasedFare getWebBasedFare() {
            return webBasedFare;
        }

        /** 
         * Set the 'WebBasedFare' element value.
         * 
         * @param webBasedFare
         */
        public void setWebBasedFare(WebBasedFare webBasedFare) {
            this.webBasedFare = webBasedFare;
        }

        /** 
         * Get the 'EticketableFare' element value.
         * 
         * @return value
         */
        public EticketableFare getEticketableFare() {
            return eticketableFare;
        }

        /** 
         * Set the 'EticketableFare' element value.
         * 
         * @param eticketableFare
         */
        public void setEticketableFare(EticketableFare eticketableFare) {
            this.eticketableFare = eticketableFare;
        }

        /** 
         * Get the 'Government' element value.
         * 
         * @return value
         */
        public Government getGovernment() {
            return government;
        }

        /** 
         * Set the 'Government' element value.
         * 
         * @param government
         */
        public void setGovernment(Government government) {
            this.government = government;
        }

        /** 
         * Get the 'PassengerNameRecord' element value.
         * 
         * @return value
         */
        public PassengerNameRecord getPassengerNameRecord() {
            return passengerNameRecord;
        }

        /** 
         * Set the 'PassengerNameRecord' element value.
         * 
         * @param passengerNameRecord
         */
        public void setPassengerNameRecord(
                PassengerNameRecord passengerNameRecord) {
            this.passengerNameRecord = passengerNameRecord;
        }

        /** 
         * Get the 'LineEntry' element value.
         * 
         * @return value
         */
        public LineEntry getLineEntry() {
            return lineEntry;
        }

        /** 
         * Set the 'LineEntry' element value.
         * 
         * @param lineEntry
         */
        public void setLineEntry(LineEntry lineEntry) {
            this.lineEntry = lineEntry;
        }

        /** 
         * Get the 'OverrideTaxes' element value.
         * 
         * @return value
         */
        public OverrideTaxes getOverrideTaxes() {
            return overrideTaxes;
        }

        /** 
         * Set the 'OverrideTaxes' element value.
         * 
         * @param overrideTaxes
         */
        public void setOverrideTaxes(OverrideTaxes overrideTaxes) {
            this.overrideTaxes = overrideTaxes;
        }

        /** 
         * Get the 'M_Override' element value.
         * 
         * @return value
         */
        public MOverride getMOverride1() {
            return MOverride1;
        }

        /** 
         * Set the 'M_Override' element value.
         * 
         * @param MOverride1
         */
        public void setMOverride1(MOverride MOverride1) {
            this.MOverride1 = MOverride1;
        }

        /** 
         * Get the 'RQ' element value.
         * 
         * @return value
         */
        public RQ getRQ1() {
            return RQ1;
        }

        /** 
         * Set the 'RQ' element value.
         * 
         * @param RQ1
         */
        public void setRQ1(RQ RQ1) {
            this.RQ1 = RQ1;
        }

        /** 
         * Get the 'IgnoreFuelSurcharge' element value.
         * 
         * @return value
         */
        public IgnoreFuelSurcharge getIgnoreFuelSurcharge() {
            return ignoreFuelSurcharge;
        }

        /** 
         * Set the 'IgnoreFuelSurcharge' element value.
         * 
         * @param ignoreFuelSurcharge
         */
        public void setIgnoreFuelSurcharge(
                IgnoreFuelSurcharge ignoreFuelSurcharge) {
            this.ignoreFuelSurcharge = ignoreFuelSurcharge;
        }

        /** 
         * Get the 'BookingCodeOverride' element value.
         * 
         * @return value
         */
        public BookingCodeOverride getBookingCodeOverride() {
            return bookingCodeOverride;
        }

        /** 
         * Set the 'BookingCodeOverride' element value.
         * 
         * @param bookingCodeOverride
         */
        public void setBookingCodeOverride(
                BookingCodeOverride bookingCodeOverride) {
            this.bookingCodeOverride = bookingCodeOverride;
        }

        /** 
         * Get the 'FreeBaggageSubscriber' element value.
         * 
         * @return value
         */
        public FreeBaggageSubscriber getFreeBaggageSubscriber() {
            return freeBaggageSubscriber;
        }

        /** 
         * Set the 'FreeBaggageSubscriber' element value.
         * 
         * @param freeBaggageSubscriber
         */
        public void setFreeBaggageSubscriber(
                FreeBaggageSubscriber freeBaggageSubscriber) {
            this.freeBaggageSubscriber = freeBaggageSubscriber;
        }

        /** 
         * Get the 'PCCHostCarrier' element value.
         * 
         * @return value
         */
        public PCCHostCarrier getPCCHostCarrier1() {
            return PCCHostCarrier1;
        }

        /** 
         * Set the 'PCCHostCarrier' element value.
         * 
         * @param PCCHostCarrier1
         */
        public void setPCCHostCarrier1(PCCHostCarrier PCCHostCarrier1) {
            this.PCCHostCarrier1 = PCCHostCarrier1;
        }

        /** 
         * Get the 'FareFamily' element value.
         * 
         * @return value
         */
        public FareFamily getFareFamily() {
            return fareFamily;
        }

        /** 
         * Set the 'FareFamily' element value.
         * 
         * @param fareFamily
         */
        public void setFareFamily(FareFamily fareFamily) {
            this.fareFamily = fareFamily;
        }

        /** 
         * Get the 'FareX' element value.
         * 
         * @return value
         */
        public FareX getFareX() {
            return fareX;
        }

        /** 
         * Set the 'FareX' element value.
         * 
         * @param fareX
         */
        public void setFareX(FareX fareX) {
            this.fareX = fareX;
        }

        /** 
         * Get the 'UpSellEntry' element value.
         * 
         * @return value
         */
        public UpSellEntry getUpSellEntry() {
            return upSellEntry;
        }

        /** 
         * Set the 'UpSellEntry' element value.
         * 
         * @param upSellEntry
         */
        public void setUpSellEntry(UpSellEntry upSellEntry) {
            this.upSellEntry = upSellEntry;
        }

        /** 
         * Get the 'PaperTicketSurcharge' element value.
         * 
         * @return value
         */
        public PaperTicketSurcharge getPaperTicketSurcharge() {
            return paperTicketSurcharge;
        }

        /** 
         * Set the 'PaperTicketSurcharge' element value.
         * 
         * @param paperTicketSurcharge
         */
        public void setPaperTicketSurcharge(
                PaperTicketSurcharge paperTicketSurcharge) {
            this.paperTicketSurcharge = paperTicketSurcharge;
        }

        /** 
         * Get the 'ConsolidatorPlusUp' element value.
         * 
         * @return value
         */
        public ConsolidatorPlusUp getConsolidatorPlusUp() {
            return consolidatorPlusUp;
        }

        /** 
         * Set the 'ConsolidatorPlusUp' element value.
         * 
         * @param consolidatorPlusUp
         */
        public void setConsolidatorPlusUp(ConsolidatorPlusUp consolidatorPlusUp) {
            this.consolidatorPlusUp = consolidatorPlusUp;
        }

        /** 
         * Get the 'CreditCard' element value.
         * 
         * @return value
         */
        public CreditCard getCreditCard() {
            return creditCard;
        }

        /** 
         * Set the 'CreditCard' element value.
         * 
         * @param creditCard
         */
        public void setCreditCard(CreditCard creditCard) {
            this.creditCard = creditCard;
        }

        /** 
         * Get the 'Confirmation' element value.
         * 
         * @return value
         */
        public Confirmation getConfirmation() {
            return confirmation;
        }

        /** 
         * Set the 'Confirmation' element value.
         * 
         * @param confirmation
         */
        public void setConfirmation(Confirmation confirmation) {
            this.confirmation = confirmation;
        }

        /** 
         * Get the 'IgnoreNameChange' element value.
         * 
         * @return value
         */
        public IgnoreNameChange getIgnoreNameChange() {
            return ignoreNameChange;
        }

        /** 
         * Set the 'IgnoreNameChange' element value.
         * 
         * @param ignoreNameChange
         */
        public void setIgnoreNameChange(IgnoreNameChange ignoreNameChange) {
            this.ignoreNameChange = ignoreNameChange;
        }

        /** 
         * Get the 'IgnoreSegmentChange' element value.
         * 
         * @return value
         */
        public IgnoreSegmentChange getIgnoreSegmentChange() {
            return ignoreSegmentChange;
        }

        /** 
         * Set the 'IgnoreSegmentChange' element value.
         * 
         * @param ignoreSegmentChange
         */
        public void setIgnoreSegmentChange(
                IgnoreSegmentChange ignoreSegmentChange) {
            this.ignoreSegmentChange = ignoreSegmentChange;
        }

        /** 
         * Get the 'IgnoreNetRemit' element value.
         * 
         * @return value
         */
        public IgnoreNetRemit getIgnoreNetRemit() {
            return ignoreNetRemit;
        }

        /** 
         * Set the 'IgnoreNetRemit' element value.
         * 
         * @param ignoreNetRemit
         */
        public void setIgnoreNetRemit(IgnoreNetRemit ignoreNetRemit) {
            this.ignoreNetRemit = ignoreNetRemit;
        }

        /** 
         * Get the 'NetSell' element value.
         * 
         * @return value
         */
        public NetSell getNetSell() {
            return netSell;
        }

        /** 
         * Set the 'NetSell' element value.
         * 
         * @param netSell
         */
        public void setNetSell(NetSell netSell) {
            this.netSell = netSell;
        }

        /** 
         * Get the 'ChargeAmount' element value.
         * 
         * @return value
         */
        public ChargeAmount getChargeAmount() {
            return chargeAmount;
        }

        /** 
         * Set the 'ChargeAmount' element value.
         * 
         * @param chargeAmount
         */
        public void setChargeAmount(ChargeAmount chargeAmount) {
            this.chargeAmount = chargeAmount;
        }

        /** 
         * Get the 'ChargeResidual' element value.
         * 
         * @return value
         */
        public ChargeResidual getChargeResidual() {
            return chargeResidual;
        }

        /** 
         * Set the 'ChargeResidual' element value.
         * 
         * @param chargeResidual
         */
        public void setChargeResidual(ChargeResidual chargeResidual) {
            this.chargeResidual = chargeResidual;
        }

        /** 
         * Get the 'ExcludeFareFocusRule' element value.
         * 
         * @return value
         */
        public ExcludeFareFocusRule getExcludeFareFocusRule() {
            return excludeFareFocusRule;
        }

        /** 
         * Set the 'ExcludeFareFocusRule' element value.
         * 
         * @param excludeFareFocusRule
         */
        public void setExcludeFareFocusRule(
                ExcludeFareFocusRule excludeFareFocusRule) {
            this.excludeFareFocusRule = excludeFareFocusRule;
        }

        /** 
         * Get the 'PriceByBrand' element value.
         * 
         * @return value
         */
        public PriceByBrand getPriceByBrand() {
            return priceByBrand;
        }

        /** 
         * Set the 'PriceByBrand' element value.
         * 
         * @param priceByBrand
         */
        public void setPriceByBrand(PriceByBrand priceByBrand) {
            this.priceByBrand = priceByBrand;
        }

        /** 
         * Get the 'RetailerRules' element value.
         * 
         * @return value
         */
        public RetailerRules getRetailerRules() {
            return retailerRules;
        }

        /** 
         * Set the 'RetailerRules' element value.
         * 
         * @param retailerRules
         */
        public void setRetailerRules(RetailerRules retailerRules) {
            this.retailerRules = retailerRules;
        }

        /** 
         * Get the 'CurrencyCode' attribute value. Equivalent currency code /PRO/@C45
         * 
         * @return value
         */
        public String getCurrencyCode() {
            return currencyCode;
        }

        /** 
         * Set the 'CurrencyCode' attribute value. Equivalent currency code /PRO/@C45
         * 
         * @param currencyCode
         */
        public void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        /** 
         * Get the 'BuyingDate' attribute value. Buying time override /PRO/@D54 Buying date /PRO/@D07
         * 
         * @return value
         */
        public String getBuyingDate() {
            return buyingDate;
        }

        /** 
         * Set the 'BuyingDate' attribute value. Buying time override /PRO/@D54 Buying date /PRO/@D07
         * 
         * @param buyingDate
         */
        public void setBuyingDate(String buyingDate) {
            this.buyingDate = buyingDate;
        }

        /** 
         * Get the 'SpanishFamilyDiscount' attribute value. Spanish Large Family discount /PRO/@DFN 
         * 
         * @return value
         */
        public SpanishLargeFamilyDiscountLevel getSpanishFamilyDiscount() {
            return spanishFamilyDiscount;
        }

        /** 
         * Set the 'SpanishFamilyDiscount' attribute value. Spanish Large Family discount /PRO/@DFN 
         * 
         * @param spanishFamilyDiscount
         */
        public void setSpanishFamilyDiscount(
                SpanishLargeFamilyDiscountLevel spanishFamilyDiscount) {
            this.spanishFamilyDiscount = spanishFamilyDiscount;
        }
        /** 
         * Passenger Information
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerType" maxOccurs="4">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="ShipRegistry" minOccurs="0">
         *         &lt;!-- Reference to inner class ShipRegistry -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
         *     &lt;xs:attribute type="xs:short" use="optional" default="1" name="Count"/>
         *     &lt;xs:attribute type="xs:short" use="optional" name="Age"/>
         *     &lt;xs:attribute type="xs:boolean" default="false" name="AlternatePassengerTypeInd"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PassengerType implements Serializable
        {
            private ShipRegistry shipRegistry;
            private String code;
            private Short count;
            private Short age;
            private Boolean alternatePassengerTypeInd;

            /** 
             * Get the 'ShipRegistry' element value.
             * 
             * @return value
             */
            public ShipRegistry getShipRegistry() {
                return shipRegistry;
            }

            /** 
             * Set the 'ShipRegistry' element value.
             * 
             * @param shipRegistry
             */
            public void setShipRegistry(ShipRegistry shipRegistry) {
                this.shipRegistry = shipRegistry;
            }

            /** 
             * Get the 'Code' attribute value. Passenger Type Code /PXI/@B70
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'Code' attribute value. Passenger Type Code /PXI/@B70
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }

            /** 
             * Get the 'Count' attribute value. Passenger Type Count /PXI/@Q0U
             * 
             * @return value
             */
            public Short getCount() {
                return count;
            }

            /** 
             * Set the 'Count' attribute value. Passenger Type Count /PXI/@Q0U
             * 
             * @param count
             */
            public void setCount(Short count) {
                this.count = count;
            }

            /** 
             * Get the 'Age' attribute value. Passenger Age /PXI/@Q0T
             * 
             * @return value
             */
            public Short getAge() {
                return age;
            }

            /** 
             * Set the 'Age' attribute value. Passenger Age /PXI/@Q0T
             * 
             * @param age
             */
            public void setAge(Short age) {
                this.age = age;
            }

            /** 
             * Get the 'AlternatePassengerTypeInd' attribute value. XO Fare /PRO/@P20
             * 
             * @return value
             */
            public Boolean getAlternatePassengerTypeInd() {
                return alternatePassengerTypeInd;
            }

            /** 
             * Set the 'AlternatePassengerTypeInd' attribute value. XO Fare /PRO/@P20
             * 
             * @param alternatePassengerTypeInd
             */
            public void setAlternatePassengerTypeInd(
                    Boolean alternatePassengerTypeInd) {
                this.alternatePassengerTypeInd = alternatePassengerTypeInd;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ShipRegistry" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ShipRegistry implements Serializable
            {
                private String code;

                /** 
                 * Get the 'Code' attribute value. Fare by rule ship registry /PRO/@S12
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'Code' attribute value. Fare by rule ship registry /PRO/@S12
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerStatus" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="NationCode"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="StateProvinceCode"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="CityCode"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PassengerStatus implements Serializable
        {
            private String type;
            private String nationCode;
            private String stateProvinceCode;
            private String cityCode;

            /** 
             * Get the 'Type' attribute value. Country type /PRO/@N0M
             * 
             * @return value
             */
            public String getType() {
                return type;
            }

            /** 
             * Set the 'Type' attribute value. Country type /PRO/@N0M
             * 
             * @param type
             */
            public void setType(String type) {
                this.type = type;
            }

            /** 
             * Get the 'NationCode' attribute value. Country code /PRO/@A40
             * 
             * @return value
             */
            public String getNationCode() {
                return nationCode;
            }

            /** 
             * Set the 'NationCode' attribute value. Country code /PRO/@A40
             * 
             * @param nationCode
             */
            public void setNationCode(String nationCode) {
                this.nationCode = nationCode;
            }

            /** 
             * Get the 'StateProvinceCode' attribute value. Region code /PRO/@AH0
             * 
             * @return value
             */
            public String getStateProvinceCode() {
                return stateProvinceCode;
            }

            /** 
             * Set the 'StateProvinceCode' attribute value. Region code /PRO/@AH0
             * 
             * @param stateProvinceCode
             */
            public void setStateProvinceCode(String stateProvinceCode) {
                this.stateProvinceCode = stateProvinceCode;
            }

            /** 
             * Get the 'CityCode' attribute value. cityCode /PRO/@A50
             * 
             * @return value
             */
            public String getCityCode() {
                return cityCode;
            }

            /** 
             * Set the 'CityCode' attribute value. cityCode /PRO/@A50
             * 
             * @param cityCode
             */
            public void setCityCode(String cityCode) {
                this.cityCode = cityCode;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AlternateCurrency" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AlternateCurrency implements Serializable
        {
            private String code;

            /** 
             * Get the 'Code' attribute value. Alternate currency code /PRO/@C47
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'Code' attribute value. Alternate currency code /PRO/@C47
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Account" minOccurs="0" maxOccurs="4">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Account implements Serializable
        {
            private String code;

            /** 
             * Get the 'Code' attribute value. Account code in multi AccCode /PRO/@SM1 through SM4
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'Code' attribute value. Account code in multi AccCode /PRO/@SM1 through SM4
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Corporate" minOccurs="0" maxOccurs="4">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="ID"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Corporate implements Serializable
        {
            private String ID;

            /** 
             * Get the 'ID' attribute value. Corporate ID in multi CorpID /PRO/@AC1 through AC4
             * 
             * @return value
             */
            public String getID() {
                return ID;
            }

            /** 
             * Set the 'ID' attribute value. Corporate ID in multi CorpID /PRO/@AC1 through AC4
             * 
             * @param ID
             */
            public void setID(String ID) {
                this.ID = ID;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ForceCorporate" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ForceCorporate implements Serializable
        {
            private boolean ind;

            /** 
             * Get the 'Ind' attribute value. Force Corporate Fares indicator /PRO/@PXC
             * 
             * @return value
             */
            public boolean isInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. Force Corporate Fares indicator /PRO/@PXC
             * 
             * @param ind
             */
            public void setInd(boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PublicFare" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" default="false" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PublicFare implements Serializable
        {
            private Boolean ind;

            /** 
             * Get the 'Ind' attribute value. Public Fares /PRO/@P1Y
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. Public Fares /PRO/@P1Y
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PrivateFare" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" default="false" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PrivateFare implements Serializable
        {
            private Boolean ind;

            /** 
             * Get the 'Ind' attribute value. Private Fares /PRO/@P1Z
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. Private Fares /PRO/@P1Z
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NetFare" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" default="false" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class NetFare implements Serializable
        {
            private Boolean ind;

            /** 
             * Get the 'Ind' attribute value. Net indicator /PRO/@P71
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. Net indicator /PRO/@P71
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OnlineFare" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" default="false" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OnlineFare implements Serializable
        {
            private Boolean ind;

            /** 
             * Get the 'Ind' attribute value. Online Fares /PRO/@P1W
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. Online Fares /PRO/@P1W
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="IATA_Fare" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" default="false" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class IATAFare implements Serializable
        {
            private Boolean ind;

            /** 
             * Get the 'Ind' attribute value. IATA fares /PRO/@P21
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. IATA fares /PRO/@P21
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ValidatingCarrier" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ValidatingCarrier implements Serializable
        {
            private String code;

            /** 
             * Get the 'Code' attribute value. Validating carrier code /PRO/@B05
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'Code' attribute value. Validating carrier code /PRO/@B05
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OverridePurchaseCity" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="LocationCode"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OverridePurchaseCity implements Serializable
        {
            private String locationCode;

            /** 
             * Get the 'LocationCode' attribute value. Sale point override /PRO/@AG0
             * 
             * @return value
             */
            public String getLocationCode() {
                return locationCode;
            }

            /** 
             * Set the 'LocationCode' attribute value. Sale point override /PRO/@AG0
             * 
             * @param locationCode
             */
            public void setLocationCode(String locationCode) {
                this.locationCode = locationCode;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OverrideTicketingCity" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="LocationCode"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OverrideTicketingCity implements Serializable
        {
            private String locationCode;

            /** 
             * Get the 'LocationCode' attribute value. Ticketing point override /PRO/@AF0
             * 
             * @return value
             */
            public String getLocationCode() {
                return locationCode;
            }

            /** 
             * Set the 'LocationCode' attribute value. Ticketing point override /PRO/@AF0
             * 
             * @param locationCode
             */
            public void setLocationCode(String locationCode) {
                this.locationCode = locationCode;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BSR" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:decimal" use="optional" name="AmountOverride1"/>
         *     &lt;xs:attribute type="xs:decimal" use="optional" name="AmountOverride2"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class BSR implements Serializable
        {
            private BigDecimal amountOverride1;
            private BigDecimal amountOverride2;

            /** 
             * Get the 'AmountOverride1' attribute value. Rate amount override /PRO/@C6E
             * 
             * @return value
             */
            public BigDecimal getAmountOverride1() {
                return amountOverride1;
            }

            /** 
             * Set the 'AmountOverride1' attribute value. Rate amount override /PRO/@C6E
             * 
             * @param amountOverride1
             */
            public void setAmountOverride1(BigDecimal amountOverride1) {
                this.amountOverride1 = amountOverride1;
            }

            /** 
             * Get the 'AmountOverride2' attribute value. Rate amount override 2 /PRO/@C6H
             * 
             * @return value
             */
            public BigDecimal getAmountOverride2() {
                return amountOverride2;
            }

            /** 
             * Set the 'AmountOverride2' attribute value. Rate amount override 2 /PRO/@C6H
             * 
             * @param amountOverride2
             */
            public void setAmountOverride2(BigDecimal amountOverride2) {
                this.amountOverride2 = amountOverride2;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NoPenalty" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" default="false" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class NoPenalty implements Serializable
        {
            private Boolean ind;

            /** 
             * Get the 'Ind' attribute value. No penalties /PRO/@P47
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. No penalties /PRO/@P47
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NoAdvancePurchase" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" default="false" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class NoAdvancePurchase implements Serializable
        {
            private Boolean ind;

            /** 
             * Get the 'Ind' attribute value. No advance purchase restriction /PRO/@P48
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. No advance purchase restriction /PRO/@P48
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NoMinMaxStay" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" default="false" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class NoMinMaxStay implements Serializable
        {
            private Boolean ind;

            /** 
             * Get the 'Ind' attribute value. No min/max stay restriction /PRO/@P49
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. No min/max stay restriction /PRO/@P49
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LowFareNoRebook" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" default="false" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class LowFareNoRebook implements Serializable
        {
            private Boolean ind;

            /** 
             * Get the 'Ind' attribute value. Low fare requested with No rebook - T /PRO/@OCL
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. Low fare requested with No rebook - T /PRO/@OCL
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AwardShoppingPricing" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AwardShoppingPricing implements Serializable
        {
            private boolean ind;

            /** 
             * Get the 'Ind' attribute value. Award Shopping/Pricing Request - T /PRO/@Q6W
             * 
             * @return value
             */
            public boolean isInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. Award Shopping/Pricing Request - T /PRO/@Q6W
             * 
             * @param ind
             */
            public void setInd(boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceNoAvailability" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PriceNoAvailability implements Serializable
        {
            private Boolean ind;

            /** 
             * Get the 'Ind' attribute value. Price no availability /PRO/@P1V
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. Price no availability /PRO/@P1V
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CurrencyOverride" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class CurrencyOverride implements Serializable
        {
            private String value;

            /** 
             * Get the 'Value' attribute value. Currency override /PRO/@P44
             * 
             * @return value
             */
            public String getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value. Currency override /PRO/@P44
             * 
             * @param value
             */
            public void setValue(String value) {
                this.value = value;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReturnAllData" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute use="optional" name="Value">
         *       &lt;xs:simpleType>
         *         &lt;!-- Reference to inner class Value -->
         *       &lt;/xs:simpleType>
         *     &lt;/xs:attribute>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ReturnAllData implements Serializable
        {
            private Value value;

            /** 
             * Get the 'Value' attribute value. Return all data /PRO/@Q0P
             * 
             * @return value
             */
            public Value getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value. Return all data /PRO/@Q0P
             * 
             * @param value
             */
            public void setValue(Value value) {
                this.value = value;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
             *   &lt;xs:restriction base="xs:string">
             *     &lt;xs:enumeration value="1"/>
             *     &lt;xs:enumeration value="2"/>
             *     &lt;xs:enumeration value="3"/>
             *     &lt;xs:enumeration value="4"/>
             *     &lt;xs:enumeration value="5"/>
             *   &lt;/xs:restriction>
             * &lt;/xs:simpleType>
             * </pre>
             */
            public static enum Value implements Serializable {
                _1("1"), _2("2"), _3("3"), _4("4"), _5("5");
                private final String value;

                private Value(String value) {
                    this.value = value;
                }

                public String xmlValue() {
                    return value;
                }

                public static Value convert(String value) {
                    for (Value inst : values()) {
                        if (inst.xmlValue().equals(value)) {
                            return inst;
                        }
                    }
                    return null;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ATB_FareCalc" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:short" use="required" name="Length"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ATBFareCalc implements Serializable
        {
            private short length;

            /** 
             * Get the 'Length' attribute value. Length of ATB fare calc /PRO/@Q15
             * 
             * @return value
             */
            public short getLength() {
                return length;
            }

            /** 
             * Set the 'Length' attribute value. Length of ATB fare calc /PRO/@Q15
             * 
             * @param length
             */
            public void setLength(short length) {
                this.length = length;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivalentAmountOverride" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:decimal" use="required" name="Amount"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class EquivalentAmountOverride implements Serializable
        {
            private BigDecimal amount;

            /** 
             * Get the 'Amount' attribute value. Equivalent amount override /PRO/@C6D
             * 
             * @return value
             */
            public BigDecimal getAmount() {
                return amount;
            }

            /** 
             * Set the 'Amount' attribute value. Equivalent amount override /PRO/@C6D
             * 
             * @param amount
             */
            public void setAmount(BigDecimal amount) {
                this.amount = amount;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NormalFare" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class NormalFare implements Serializable
        {
            private Boolean ind;

            /** 
             * Get the 'Ind' attribute value. Normal fare /PRO/@P50
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. Normal fare /PRO/@P50
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LowFareNoAvailability" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class LowFareNoAvailability implements Serializable
        {
            private Boolean ind;

            /** 
             * Get the 'Ind' attribute value. Low fare no availability /PRO/@P51
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. Low fare no availability /PRO/@P51
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LowFareRequested" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class LowFareRequested implements Serializable
        {
            private Boolean ind;

            /** 
             * Get the 'Ind' attribute value. Low fare requested /PRO/@P52
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. Low fare requested /PRO/@P52
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RoundTheWorld" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class RoundTheWorld implements Serializable
        {
            private Boolean ind;

            /** 
             * Get the 'Ind' attribute value. Round The World /PRO/@RTW
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. Round The World /PRO/@RTW
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SettlementMethod" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class SettlementMethod implements Serializable
        {
            private String value;

            /** 
             * Get the 'Value' attribute value. Ticketing settlement method override /PRO/@SM0 
             * 
             * @return value
             */
            public String getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value. Ticketing settlement method override /PRO/@SM0 
             * 
             * @param value
             */
            public void setValue(String value) {
                this.value = value;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceNullDate" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PriceNullDate implements Serializable
        {
            private Boolean ind;

            /** 
             * Get the 'Ind' attribute value. Price null date /PRO/@P55
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. Price null date /PRO/@P55
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketEntry" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class TicketEntry implements Serializable
        {
            private Boolean ind;

            /** 
             * Get the 'Ind' attribute value. Ticket entry /PRO/@P58
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. Ticket entry /PRO/@P58
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Cat35FarePreference" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="NotAllowed"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="Ignored"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="SellInd"/>
         *     &lt;xs:attribute type="xs:boolean" use="required" name="WPSEL_Ind"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="WPNETT_Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Cat35FarePreference implements Serializable
        {
            private Boolean notAllowed;
            private Boolean ignored;
            private Boolean sellInd;
            private boolean WPSELInd;
            private Boolean WPNETTInd;

            /** 
             * Get the 'NotAllowed' attribute value. CAT35 not allowed /PRO/@P59
             * 
             * @return value
             */
            public Boolean getNotAllowed() {
                return notAllowed;
            }

            /** 
             * Set the 'NotAllowed' attribute value. CAT35 not allowed /PRO/@P59
             * 
             * @param notAllowed
             */
            public void setNotAllowed(Boolean notAllowed) {
                this.notAllowed = notAllowed;
            }

            /** 
             * Get the 'Ignored' attribute value. CAT35 fare should be ignored /PRO/@P60
             * 
             * @return value
             */
            public Boolean getIgnored() {
                return ignored;
            }

            /** 
             * Set the 'Ignored' attribute value. CAT35 fare should be ignored /PRO/@P60
             * 
             * @param ignored
             */
            public void setIgnored(Boolean ignored) {
                this.ignored = ignored;
            }

            /** 
             * Get the 'SellInd' attribute value. CAT35 sell indicator /PRO/@P70
             * 
             * @return value
             */
            public Boolean getSellInd() {
                return sellInd;
            }

            /** 
             * Set the 'SellInd' attribute value. CAT35 sell indicator /PRO/@P70
             * 
             * @param sellInd
             */
            public void setSellInd(Boolean sellInd) {
                this.sellInd = sellInd;
            }

            /** 
             * Get the 'WPSEL_Ind' attribute value. JAL/AXESS WPSEL entry indicator - T /PRO/@PCE
             * 
             * @return value
             */
            public boolean isWPSELInd() {
                return WPSELInd;
            }

            /** 
             * Set the 'WPSEL_Ind' attribute value. JAL/AXESS WPSEL entry indicator - T /PRO/@PCE
             * 
             * @param WPSELInd
             */
            public void setWPSELInd(boolean WPSELInd) {
                this.WPSELInd = WPSELInd;
            }

            /** 
             * Get the 'WPNETT_Ind' attribute value. JAL/AXESS WPNETT entry indicator - T /PRO/@PCD
             * 
             * @return value
             */
            public Boolean getWPNETTInd() {
                return WPNETTInd;
            }

            /** 
             * Set the 'WPNETT_Ind' attribute value. JAL/AXESS WPNETT entry indicator - T /PRO/@PCD
             * 
             * @param WPNETTInd
             */
            public void setWPNETTInd(Boolean WPNETTInd) {
                this.WPNETTInd = WPNETTInd;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FormOfPayment" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="Cash"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="Check"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="Card"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FormOfPayment implements Serializable
        {
            private Boolean cash;
            private Boolean check;
            private Boolean card;

            /** 
             * Get the 'Cash' attribute value. Form of payment cash /PRO/@P61
             * 
             * @return value
             */
            public Boolean getCash() {
                return cash;
            }

            /** 
             * Set the 'Cash' attribute value. Form of payment cash /PRO/@P61
             * 
             * @param cash
             */
            public void setCash(Boolean cash) {
                this.cash = cash;
            }

            /** 
             * Get the 'Check' attribute value. Form of payment check /PRO/@P62
             * 
             * @return value
             */
            public Boolean getCheck() {
                return check;
            }

            /** 
             * Set the 'Check' attribute value. Form of payment check /PRO/@P62
             * 
             * @param check
             */
            public void setCheck(Boolean check) {
                this.check = check;
            }

            /** 
             * Get the 'Card' attribute value. Form of payment card /PRO/@P63
             * 
             * @return value
             */
            public Boolean getCard() {
                return card;
            }

            /** 
             * Set the 'Card' attribute value. Form of payment card /PRO/@P63
             * 
             * @param card
             */
            public void setCard(Boolean card) {
                this.card = card;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExemptFromPFCTax" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ExemptFromPFCTax implements Serializable
        {
            private Boolean ind;

            /** 
             * Get the 'Ind' attribute value. Exempt from PFC tax /PRO/@P66
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. Exempt from PFC tax /PRO/@P66
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketStock" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class TicketStock implements Serializable
        {
            private String value;

            /** 
             * Get the 'Value' attribute value. Ticket stock /PRO/@BG0
             * 
             * @return value
             */
            public String getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value. Ticket stock /PRO/@BG0
             * 
             * @param value
             */
            public void setValue(String value) {
                this.value = value;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AgentCommission" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
         *     &lt;xs:attribute type="xs:decimal" use="optional" name="Amount"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AgentCommission implements Serializable
        {
            private String type;
            private BigDecimal amount;

            /** 
             * Get the 'Type' attribute value. Agent commission type /PRO/@N0L
             * 
             * @return value
             */
            public String getType() {
                return type;
            }

            /** 
             * Set the 'Type' attribute value. Agent commission type /PRO/@N0L
             * 
             * @param type
             */
            public void setType(String type) {
                this.type = type;
            }

            /** 
             * Get the 'Amount' attribute value. Agent commission amount /PRO/@C6C
             * 
             * @return value
             */
            public BigDecimal getAmount() {
                return amount;
            }

            /** 
             * Set the 'Amount' attribute value. Agent commission amount /PRO/@C6C
             * 
             * @param amount
             */
            public void setAmount(BigDecimal amount) {
                this.amount = amount;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="WebBasedFare" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class WebBasedFare implements Serializable
        {
            private Boolean ind;

            /** 
             * Get the 'Ind' attribute value. Web based fare /PRO/@P0F
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. Web based fare /PRO/@P0F
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EticketableFare" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class EticketableFare implements Serializable
        {
            private Boolean ind;

            /** 
             * Get the 'Ind' attribute value. Eticketable fare /PRO/@P0J
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. Eticketable fare /PRO/@P0J
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Government" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="TransportationRequest"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Government implements Serializable
        {
            private Boolean transportationRequest;

            /** 
             * Get the 'TransportationRequest' attribute value. Government transportation request /PRO/@P67
             * 
             * @return value
             */
            public Boolean getTransportationRequest() {
                return transportationRequest;
            }

            /** 
             * Set the 'TransportationRequest' attribute value. Government transportation request /PRO/@P67
             * 
             * @param transportationRequest
             */
            public void setTransportationRequest(Boolean transportationRequest) {
                this.transportationRequest = transportationRequest;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerNameRecord" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Locator"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PassengerNameRecord implements Serializable
        {
            private String locator;

            /** 
             * Get the 'Locator' attribute value. Passenger name record /PRO/@S13
             * 
             * @return value
             */
            public String getLocator() {
                return locator;
            }

            /** 
             * Set the 'Locator' attribute value. Passenger name record /PRO/@S13
             * 
             * @param locator
             */
            public void setLocator(String locator) {
                this.locator = locator;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LineEntry" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Text"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class LineEntry implements Serializable
        {
            private String text;

            /** 
             * Get the 'Text' attribute value. Line entry /PRO/@S14
             * 
             * @return value
             */
            public String getText() {
                return text;
            }

            /** 
             * Set the 'Text' attribute value. Line entry /PRO/@S14
             * 
             * @param text
             */
            public void setText(String text) {
                this.text = text;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OverrideTaxes" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="OverrideTax" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class OverrideTax -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OverrideTaxes implements Serializable
        {
            private List<OverrideTax> overrideTaxList = new ArrayList<OverrideTax>();

            /** 
             * Get the list of 'OverrideTax' element items.
             * 
             * @return list
             */
            public List<OverrideTax> getOverrideTaxList() {
                return overrideTaxList;
            }

            /** 
             * Set the list of 'OverrideTax' element items.
             * 
             * @param list
             */
            public void setOverrideTaxList(List<OverrideTax> list) {
                overrideTaxList = list;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OverrideTax" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
             *     &lt;xs:attribute type="xs:decimal" use="required" name="Amount"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class OverrideTax implements Serializable
            {
                private String code;
                private BigDecimal amount;

                /** 
                 * Get the 'Code' attribute value. Override tax code Should go to the same pro as amount /PRO/@BC0
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'Code' attribute value. Override tax code Should go to the same pro as amount /PRO/@BC0
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }

                /** 
                 * Get the 'Amount' attribute value. Override tax amount /PRO/@C6B
                 * 
                 * @return value
                 */
                public BigDecimal getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' attribute value. Override tax amount /PRO/@C6B
                 * 
                 * @param amount
                 */
                public void setAmount(BigDecimal amount) {
                    this.amount = amount;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="M_Override" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class MOverride implements Serializable
        {
            private Boolean ind;

            /** 
             * Get the 'Ind' attribute value. M override /PRO/@P69
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. M override /PRO/@P69
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RQ" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class RQ implements Serializable
        {
            private Boolean ind;

            /** 
             * Get the 'Ind' attribute value. RQ indicator /PRO/@P77
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. RQ indicator /PRO/@P77
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="IgnoreFuelSurcharge" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class IgnoreFuelSurcharge implements Serializable
        {
            private boolean ind;

            /** 
             * Get the 'Ind' attribute value. Ignore fuel surcharge /PRO/@PBI
             * 
             * @return value
             */
            public boolean isInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. Ignore fuel surcharge /PRO/@PBI
             * 
             * @param ind
             */
            public void setInd(boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BookingCodeOverride" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class BookingCodeOverride implements Serializable
        {
            private boolean ind;

            /** 
             * Get the 'Ind' attribute value. Booking code override /PRO/@PBJ
             * 
             * @return value
             */
            public boolean isInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. Booking code override /PRO/@PBJ
             * 
             * @param ind
             */
            public void setInd(boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FreeBaggageSubscriber" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FreeBaggageSubscriber implements Serializable
        {
            private boolean ind;

            /** 
             * Get the 'Ind' attribute value. Free baggage subscriber /PRO/@PBK
             * 
             * @return value
             */
            public boolean isInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. Free baggage subscriber /PRO/@PBK
             * 
             * @param ind
             */
            public void setInd(boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PCCHostCarrier" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PCCHostCarrier implements Serializable
        {
            private String code;

            /** 
             * Get the 'Code' attribute value. PCC host carrier /PRO/@AE0
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'Code' attribute value. PCC host carrier /PRO/@AE0
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareFamily" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Type"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FareFamily implements Serializable
        {
            private String type;

            /** 
             * Get the 'Type' attribute value. Fare type request fare family N/S/T /PRO/@N1R
             * 
             * @return value
             */
            public String getType() {
                return type;
            }

            /** 
             * Set the 'Type' attribute value. Fare type request fare family N/S/T /PRO/@N1R
             * 
             * @param type
             */
            public void setType(String type) {
                this.type = type;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareX" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FareX implements Serializable
        {
            private boolean ind;

            /** 
             * Get the 'Ind' attribute value. FareX indicator /PRO/@P4A
             * 
             * @return value
             */
            public boolean isInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. FareX indicator /PRO/@P4A
             * 
             * @param ind
             */
            public void setInd(boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UpSellEntry" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class UpSellEntry implements Serializable
        {
            private boolean ind;

            /** 
             * Get the 'Ind' attribute value. UpSell entry /PRO/@P4B
             * 
             * @return value
             */
            public boolean isInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. UpSell entry /PRO/@P4B
             * 
             * @param ind
             */
            public void setInd(boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaperTicketSurcharge" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="required" name="OverrideInd"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PaperTicketSurcharge implements Serializable
        {
            private boolean overrideInd;

            /** 
             * Get the 'OverrideInd' attribute value. Override Paper Ticket Surcharge /PRO/@PCB
             * 
             * @return value
             */
            public boolean isOverrideInd() {
                return overrideInd;
            }

            /** 
             * Set the 'OverrideInd' attribute value. Override Paper Ticket Surcharge /PRO/@PCB
             * 
             * @param overrideInd
             */
            public void setOverrideInd(boolean overrideInd) {
                this.overrideInd = overrideInd;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ConsolidatorPlusUp" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
         *     &lt;xs:attribute type="xs:decimal" use="optional" name="Amount"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="TicketDesignator"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ConsolidatorPlusUp implements Serializable
        {
            private String currencyCode;
            private BigDecimal amount;
            private String ticketDesignator;

            /** 
             * Get the 'CurrencyCode' attribute value. Consolidator Plus Up Currency Code /PRO/@C74
             * 
             * @return value
             */
            public String getCurrencyCode() {
                return currencyCode;
            }

            /** 
             * Set the 'CurrencyCode' attribute value. Consolidator Plus Up Currency Code /PRO/@C74
             * 
             * @param currencyCode
             */
            public void setCurrencyCode(String currencyCode) {
                this.currencyCode = currencyCode;
            }

            /** 
             * Get the 'Amount' attribute value. Consolidator Plus Up Amount /PRO/@C6Z
             * 
             * @return value
             */
            public BigDecimal getAmount() {
                return amount;
            }

            /** 
             * Set the 'Amount' attribute value. Consolidator Plus Up Amount /PRO/@C6Z
             * 
             * @param amount
             */
            public void setAmount(BigDecimal amount) {
                this.amount = amount;
            }

            /** 
             * Get the 'TicketDesignator' attribute value. Consolidator Plus Up Ticket Designator /PRO/@BE1
             * 
             * @return value
             */
            public String getTicketDesignator() {
                return ticketDesignator;
            }

            /** 
             * Set the 'TicketDesignator' attribute value. Consolidator Plus Up Ticket Designator /PRO/@BE1
             * 
             * @param ticketDesignator
             */
            public void setTicketDesignator(String ticketDesignator) {
                this.ticketDesignator = ticketDesignator;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CreditCard" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Type"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class CreditCard implements Serializable
        {
            private String type;

            /** 
             * Get the 'Type' attribute value. Credit Card Type /PRO/@C4D
             * 
             * @return value
             */
            public String getType() {
                return type;
            }

            /** 
             * Set the 'Type' attribute value. Credit Card Type /PRO/@C4D
             * 
             * @param type
             */
            public void setType(String type) {
                this.type = type;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Confirmation" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Number"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Confirmation implements Serializable
        {
            private String number;

            /** 
             * Get the 'Number' attribute value. Confirmation Number /PRO/@SA9
             * 
             * @return value
             */
            public String getNumber() {
                return number;
            }

            /** 
             * Set the 'Number' attribute value. Confirmation Number /PRO/@SA9
             * 
             * @param number
             */
            public void setNumber(String number) {
                this.number = number;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="IgnoreNameChange" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class IgnoreNameChange implements Serializable
        {
            private Boolean ind;

            /** 
             * Get the 'Ind' attribute value. Ignore Name Change /PRO/@PY0
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. Ignore Name Change /PRO/@PY0
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="IgnoreSegmentChange" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class IgnoreSegmentChange implements Serializable
        {
            private Boolean ind;

            /** 
             * Get the 'Ind' attribute value. Ignore Segment Change /PRO/@PY1
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. Ignore Segment Change /PRO/@PY1
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="IgnoreNetRemit" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class IgnoreNetRemit implements Serializable
        {
            private Boolean ind;

            /** 
             * Get the 'Ind' attribute value. Ignore Net Remit /PRO/@P4N
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. Ignore Net Remit /PRO/@P4N
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NetSell" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class NetSell implements Serializable
        {
            private Boolean ind;

            /** 
             * Get the 'Ind' attribute value. TJR NETSELL Indicator /PRO/@PNS
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. TJR NETSELL Indicator /PRO/@PNS
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ChargeAmount" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:decimal" use="optional" name="Amount"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ChargeAmount implements Serializable
        {
            private BigDecimal amount;

            /** 
             * Get the 'Amount' attribute value. Charge Amount to Credit Card FOP /PRO/@PAT
             * 
             * @return value
             */
            public BigDecimal getAmount() {
                return amount;
            }

            /** 
             * Set the 'Amount' attribute value. Charge Amount to Credit Card FOP /PRO/@PAT
             * 
             * @param amount
             */
            public void setAmount(BigDecimal amount) {
                this.amount = amount;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ChargeResidual" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ChargeResidual implements Serializable
        {
            private Boolean ind;

            /** 
             * Get the 'Ind' attribute value. Amount is Residual (T) or Specified (F) /PRO/@PRS
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. Amount is Residual (T) or Specified (F) /PRO/@PRS
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExcludeFareFocusRule" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ExcludeFareFocusRule implements Serializable
        {
            private boolean ind;

            /** 
             * Get the 'Ind' attribute value. Exclude Fare Focus /PRO/@XFF
             * 
             * @return value
             */
            public boolean isInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. Exclude Fare Focus /PRO/@XFF
             * 
             * @param ind
             */
            public void setInd(boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceByBrand" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="Ind"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="BrandCode"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PriceByBrand implements Serializable
        {
            private Boolean ind;
            private String brandCode;

            /** 
             * Get the 'Ind' attribute value. Price By Brand /PRO/@PBB
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. Price By Brand /PRO/@PBB
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }

            /** 
             * Get the 'BrandCode' attribute value. Brand Code /PRO/@SB2
             * 
             * @return value
             */
            public String getBrandCode() {
                return brandCode;
            }

            /** 
             * Set the 'BrandCode' attribute value. Brand Code /PRO/@SB2
             * 
             * @param brandCode
             */
            public void setBrandCode(String brandCode) {
                this.brandCode = brandCode;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RetailerRules" minOccurs="0" maxOccurs="1">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="RetailerRule" minOccurs="1" maxOccurs="4">
         *         &lt;!-- Reference to inner class RetailerRule -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="Force"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class RetailerRules implements Serializable
        {
            private List<RetailerRule> retailerRuleList = new ArrayList<RetailerRule>();
            private Boolean force;

            /** 
             * Get the list of 'RetailerRule' element items.
             * 
             * @return list
             */
            public List<RetailerRule> getRetailerRuleList() {
                return retailerRuleList;
            }

            /** 
             * Set the list of 'RetailerRule' element items.
             * 
             * @param list
             */
            public void setRetailerRuleList(List<RetailerRule> list) {
                retailerRuleList = list;
            }

            /** 
             * Get the 'Force' attribute value. Force flag /PRO/@PRM
             * 
             * @return value
             */
            public Boolean getForce() {
                return force;
            }

            /** 
             * Set the 'Force' attribute value. Force flag /PRO/@PRM
             * 
             * @param force
             */
            public void setForce(Boolean force) {
                this.force = force;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RetailerRule" minOccurs="1" maxOccurs="4">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" name="Code"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class RetailerRule implements Serializable
            {
                private String code;

                /** 
                 * Get the 'Code' attribute value. Concatenated RetailerRuleCodes /PRO/@RCQ
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'Code' attribute value. Concatenated RetailerRuleCodes /PRO/@RCQ
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestinationOption" maxOccurs="24">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="FlightSegment">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element name="DepartureAirport">
     *               &lt;xs:complexType>
     *                 &lt;xs:attribute type="xs:string" use="required" name="LocationCode"/>
     *               &lt;/xs:complexType>
     *             &lt;/xs:element>
     *             &lt;xs:element name="ArrivalAirport">
     *               &lt;xs:complexType>
     *                 &lt;xs:attribute type="xs:string" use="required" name="LocationCode"/>
     *               &lt;/xs:complexType>
     *             &lt;/xs:element>
     *             &lt;xs:element name="MarketingAirline" minOccurs="0">
     *               &lt;!-- Reference to inner class MarketingAirline -->
     *             &lt;/xs:element>
     *             &lt;xs:element name="OperatingAirline" minOccurs="0">
     *               &lt;!-- Reference to inner class OperatingAirline -->
     *             &lt;/xs:element>
     *             &lt;xs:element name="Marriage" minOccurs="0">
     *               &lt;!-- Reference to inner class Marriage -->
     *             &lt;/xs:element>
     *             &lt;xs:element name="Equipment" minOccurs="0">
     *               &lt;!-- Reference to inner class Equipment -->
     *             &lt;/xs:element>
     *           &lt;/xs:sequence>
     *           &lt;xs:attribute type="xs:short" use="optional" name="SegmentNumber"/>
     *           &lt;xs:attribute type="xs:string" use="required" name="SegmentType"/>
     *           &lt;xs:attribute type="xs:short" use="optional" name="FlightNumber"/>
     *           &lt;xs:attribute type="xs:string" use="optional" name="DepartureDate"/>
     *           &lt;xs:attribute type="xs:string" use="optional" name="ArrivalDate"/>
     *           &lt;xs:attribute type="xs:string" use="required" name="BookingDate"/>
     *           &lt;xs:attribute type="xs:string" use="optional" name="ResBookDesigCode"/>
     *           &lt;xs:attribute type="xs:string" use="required" name="RealReservationStatus"/>
     *           &lt;xs:attribute type="xs:string" use="optional" name="Eticket"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element name="SegmentInformation" minOccurs="0">
     *         &lt;!-- Reference to inner class SegmentInformation -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="PaxTypeInformation" minOccurs="1" maxOccurs="4">
     *         &lt;!-- Reference to inner class PaxTypeInformation -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OriginDestinationOption implements Serializable
    {
        private String flightSegmentDepartureAirport;
        private String flightSegmentArrivalAirport;
        private MarketingAirline marketingAirline;
        private OperatingAirline operatingAirline;
        private Marriage marriage;
        private Equipment equipment;
        private Short flightSegmentSegmentNumber;
        private String flightSegmentSegmentType;
        private Short flightSegmentFlightNumber;
        private String flightSegmentDepartureDate;
        private String flightSegmentArrivalDate;
        private String flightSegmentBookingDate;
        private String flightSegmentResBookDesigCode;
        private String flightSegmentRealReservationStatus;
        private String flightSegmentEticket;
        private SegmentInformation segmentInformation;
        private List<PaxTypeInformation> paxTypeInformationList = new ArrayList<PaxTypeInformation>();

        /** 
         * Get the 'LocationCode' attribute value. Departure airport code /SGI/FLI/@A01
         * 
         * @return value
         */
        public String getFlightSegmentDepartureAirport() {
            return flightSegmentDepartureAirport;
        }

        /** 
         * Set the 'LocationCode' attribute value. Departure airport code /SGI/FLI/@A01
         * 
         * @param flightSegmentDepartureAirport
         */
        public void setFlightSegmentDepartureAirport(
                String flightSegmentDepartureAirport) {
            this.flightSegmentDepartureAirport = flightSegmentDepartureAirport;
        }

        /** 
         * Get the 'LocationCode' attribute value. Arrival airport code /SGI/FLI/@A02
         * 
         * @return value
         */
        public String getFlightSegmentArrivalAirport() {
            return flightSegmentArrivalAirport;
        }

        /** 
         * Set the 'LocationCode' attribute value. Arrival airport code /SGI/FLI/@A02
         * 
         * @param flightSegmentArrivalAirport
         */
        public void setFlightSegmentArrivalAirport(
                String flightSegmentArrivalAirport) {
            this.flightSegmentArrivalAirport = flightSegmentArrivalAirport;
        }

        /** 
         * Get the 'MarketingAirline' element value. Flight Information
         * 
         * @return value
         */
        public MarketingAirline getMarketingAirline() {
            return marketingAirline;
        }

        /** 
         * Set the 'MarketingAirline' element value. Flight Information
         * 
         * @param marketingAirline
         */
        public void setMarketingAirline(MarketingAirline marketingAirline) {
            this.marketingAirline = marketingAirline;
        }

        /** 
         * Get the 'OperatingAirline' element value. Flight Information
         * 
         * @return value
         */
        public OperatingAirline getOperatingAirline() {
            return operatingAirline;
        }

        /** 
         * Set the 'OperatingAirline' element value. Flight Information
         * 
         * @param operatingAirline
         */
        public void setOperatingAirline(OperatingAirline operatingAirline) {
            this.operatingAirline = operatingAirline;
        }

        /** 
         * Get the 'Marriage' element value. Flight Information
         * 
         * @return value
         */
        public Marriage getMarriage() {
            return marriage;
        }

        /** 
         * Set the 'Marriage' element value. Flight Information
         * 
         * @param marriage
         */
        public void setMarriage(Marriage marriage) {
            this.marriage = marriage;
        }

        /** 
         * Get the 'Equipment' element value. Flight Information
         * 
         * @return value
         */
        public Equipment getEquipment() {
            return equipment;
        }

        /** 
         * Set the 'Equipment' element value. Flight Information
         * 
         * @param equipment
         */
        public void setEquipment(Equipment equipment) {
            this.equipment = equipment;
        }

        /** 
         * Get the 'SegmentNumber' attribute value. segment number /SGI/FLI/@Q0C
         * 
         * @return value
         */
        public Short getFlightSegmentSegmentNumber() {
            return flightSegmentSegmentNumber;
        }

        /** 
         * Set the 'SegmentNumber' attribute value. segment number /SGI/FLI/@Q0C
         * 
         * @param flightSegmentSegmentNumber
         */
        public void setFlightSegmentSegmentNumber(
                Short flightSegmentSegmentNumber) {
            this.flightSegmentSegmentNumber = flightSegmentSegmentNumber;
        }

        /** 
         * Get the 'SegmentType' attribute value. Segment Type /SGI/FLI/@N03
         * 
         * @return value
         */
        public String getFlightSegmentSegmentType() {
            return flightSegmentSegmentType;
        }

        /** 
         * Set the 'SegmentType' attribute value. Segment Type /SGI/FLI/@N03
         * 
         * @param flightSegmentSegmentType
         */
        public void setFlightSegmentSegmentType(String flightSegmentSegmentType) {
            this.flightSegmentSegmentType = flightSegmentSegmentType;
        }

        /** 
         * Get the 'FlightNumber' attribute value. Flight number /SGI/FLI/@Q0B
         * 
         * @return value
         */
        public Short getFlightSegmentFlightNumber() {
            return flightSegmentFlightNumber;
        }

        /** 
         * Set the 'FlightNumber' attribute value. Flight number /SGI/FLI/@Q0B
         * 
         * @param flightSegmentFlightNumber
         */
        public void setFlightSegmentFlightNumber(Short flightSegmentFlightNumber) {
            this.flightSegmentFlightNumber = flightSegmentFlightNumber;
        }

        /** 
         * Get the 'DepartureDate' attribute value. Departure date /SGI/FLI/@D01 Departure time /SGI/FLI/@D31
         * 
         * @return value
         */
        public String getFlightSegmentDepartureDate() {
            return flightSegmentDepartureDate;
        }

        /** 
         * Set the 'DepartureDate' attribute value. Departure date /SGI/FLI/@D01 Departure time /SGI/FLI/@D31
         * 
         * @param flightSegmentDepartureDate
         */
        public void setFlightSegmentDepartureDate(
                String flightSegmentDepartureDate) {
            this.flightSegmentDepartureDate = flightSegmentDepartureDate;
        }

        /** 
         * Get the 'ArrivalDate' attribute value. Arrival date /SGI/FLI/@D02 Arrival time /SGI/FLI/@D32
         * 
         * @return value
         */
        public String getFlightSegmentArrivalDate() {
            return flightSegmentArrivalDate;
        }

        /** 
         * Set the 'ArrivalDate' attribute value. Arrival date /SGI/FLI/@D02 Arrival time /SGI/FLI/@D32
         * 
         * @param flightSegmentArrivalDate
         */
        public void setFlightSegmentArrivalDate(String flightSegmentArrivalDate) {
            this.flightSegmentArrivalDate = flightSegmentArrivalDate;
        }

        /** 
         * Get the 'BookingDate' attribute value.  Booking date /SGI/FLI/@D00 Booking time /SGI/FLI/@D30
         * 
         * @return value
         */
        public String getFlightSegmentBookingDate() {
            return flightSegmentBookingDate;
        }

        /** 
         * Set the 'BookingDate' attribute value.  Booking date /SGI/FLI/@D00 Booking time /SGI/FLI/@D30
         * 
         * @param flightSegmentBookingDate
         */
        public void setFlightSegmentBookingDate(String flightSegmentBookingDate) {
            this.flightSegmentBookingDate = flightSegmentBookingDate;
        }

        /** 
         * Get the 'ResBookDesigCode' attribute value. Class of service /SGI/FLI/@B30
         * 
         * @return value
         */
        public String getFlightSegmentResBookDesigCode() {
            return flightSegmentResBookDesigCode;
        }

        /** 
         * Set the 'ResBookDesigCode' attribute value. Class of service /SGI/FLI/@B30
         * 
         * @param flightSegmentResBookDesigCode
         */
        public void setFlightSegmentResBookDesigCode(
                String flightSegmentResBookDesigCode) {
            this.flightSegmentResBookDesigCode = flightSegmentResBookDesigCode;
        }

        /** 
         * Get the 'RealReservationStatus' attribute value. Real Reservation status /SGI/FLI/@BB2
         * 
         * @return value
         */
        public String getFlightSegmentRealReservationStatus() {
            return flightSegmentRealReservationStatus;
        }

        /** 
         * Set the 'RealReservationStatus' attribute value. Real Reservation status /SGI/FLI/@BB2
         * 
         * @param flightSegmentRealReservationStatus
         */
        public void setFlightSegmentRealReservationStatus(
                String flightSegmentRealReservationStatus) {
            this.flightSegmentRealReservationStatus = flightSegmentRealReservationStatus;
        }

        /** 
         * Get the 'Eticket' attribute value. E-ticket /SGI/FLI/@P2X
         * 
         * @return value
         */
        public String getFlightSegmentEticket() {
            return flightSegmentEticket;
        }

        /** 
         * Set the 'Eticket' attribute value. E-ticket /SGI/FLI/@P2X
         * 
         * @param flightSegmentEticket
         */
        public void setFlightSegmentEticket(String flightSegmentEticket) {
            this.flightSegmentEticket = flightSegmentEticket;
        }

        /** 
         * Get the 'SegmentInformation' element value.
         * 
         * @return value
         */
        public SegmentInformation getSegmentInformation() {
            return segmentInformation;
        }

        /** 
         * Set the 'SegmentInformation' element value.
         * 
         * @param segmentInformation
         */
        public void setSegmentInformation(SegmentInformation segmentInformation) {
            this.segmentInformation = segmentInformation;
        }

        /** 
         * Get the list of 'PaxTypeInformation' element items.
         * 
         * @return list
         */
        public List<PaxTypeInformation> getPaxTypeInformationList() {
            return paxTypeInformationList;
        }

        /** 
         * Set the list of 'PaxTypeInformation' element items.
         * 
         * @param list
         */
        public void setPaxTypeInformationList(List<PaxTypeInformation> list) {
            paxTypeInformationList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarketingAirline" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class MarketingAirline implements Serializable
        {
            private String code;

            /** 
             * Get the 'Code' attribute value. Marketing carrier code /SGI/FLI/@B00
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'Code' attribute value. Marketing carrier code /SGI/FLI/@B00
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OperatingAirline" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OperatingAirline implements Serializable
        {
            private String code;

            /** 
             * Get the 'Code' attribute value. Operating carrier code /SGI/FLI/@B01
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'Code' attribute value. Operating carrier code /SGI/FLI/@B01
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Marriage" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Status"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Marriage implements Serializable
        {
            private String status;

            /** 
             * Get the 'Status' attribute value. Marriage Status /SGI/FLI/@BB3
             * 
             * @return value
             */
            public String getStatus() {
                return status;
            }

            /** 
             * Set the 'Status' attribute value. Marriage Status /SGI/FLI/@BB3
             * 
             * @param status
             */
            public void setStatus(String status) {
                this.status = status;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Equipment" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Equipment implements Serializable
        {
            private String type;

            /** 
             * Get the 'Type' attribute value. Equipment Type /SGI/FLI/@B40
             * 
             * @return value
             */
            public String getType() {
                return type;
            }

            /** 
             * Set the 'Type' attribute value. Equipment Type /SGI/FLI/@B40
             * 
             * @param type
             */
            public void setType(String type) {
                this.type = type;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SegmentInformation" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="ForcedConnection" minOccurs="0">
         *         &lt;!-- Reference to inner class ForcedConnection -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="ForcedStopOver" minOccurs="0">
         *         &lt;!-- Reference to inner class ForcedStopOver -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="BreakFare" minOccurs="0">
         *         &lt;!-- Reference to inner class BreakFare -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="SideTrip" minOccurs="0">
         *         &lt;!-- Reference to inner class SideTrip -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="TicketDesignator" minOccurs="0">
         *         &lt;!-- Reference to inner class TicketDesignator -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Discount" minOccurs="0">
         *         &lt;!-- Reference to inner class Discount -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Flown" minOccurs="0">
         *         &lt;!-- Reference to inner class Flown -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:short" use="optional" name="SegmentNumber"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="GoverningCarrier"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class SegmentInformation implements Serializable
        {
            private ForcedConnection forcedConnection;
            private ForcedStopOver forcedStopOver;
            private BreakFare breakFare;
            private SideTrip sideTrip;
            private TicketDesignator ticketDesignator;
            private Discount discount;
            private Flown flown;
            private Short segmentNumber;
            private String governingCarrier;

            /** 
             * Get the 'ForcedConnection' element value.
             * 
             * @return value
             */
            public ForcedConnection getForcedConnection() {
                return forcedConnection;
            }

            /** 
             * Set the 'ForcedConnection' element value.
             * 
             * @param forcedConnection
             */
            public void setForcedConnection(ForcedConnection forcedConnection) {
                this.forcedConnection = forcedConnection;
            }

            /** 
             * Get the 'ForcedStopOver' element value.
             * 
             * @return value
             */
            public ForcedStopOver getForcedStopOver() {
                return forcedStopOver;
            }

            /** 
             * Set the 'ForcedStopOver' element value.
             * 
             * @param forcedStopOver
             */
            public void setForcedStopOver(ForcedStopOver forcedStopOver) {
                this.forcedStopOver = forcedStopOver;
            }

            /** 
             * Get the 'BreakFare' element value.
             * 
             * @return value
             */
            public BreakFare getBreakFare() {
                return breakFare;
            }

            /** 
             * Set the 'BreakFare' element value.
             * 
             * @param breakFare
             */
            public void setBreakFare(BreakFare breakFare) {
                this.breakFare = breakFare;
            }

            /** 
             * Get the 'SideTrip' element value.
             * 
             * @return value
             */
            public SideTrip getSideTrip() {
                return sideTrip;
            }

            /** 
             * Set the 'SideTrip' element value.
             * 
             * @param sideTrip
             */
            public void setSideTrip(SideTrip sideTrip) {
                this.sideTrip = sideTrip;
            }

            /** 
             * Get the 'TicketDesignator' element value.
             * 
             * @return value
             */
            public TicketDesignator getTicketDesignator() {
                return ticketDesignator;
            }

            /** 
             * Set the 'TicketDesignator' element value.
             * 
             * @param ticketDesignator
             */
            public void setTicketDesignator(TicketDesignator ticketDesignator) {
                this.ticketDesignator = ticketDesignator;
            }

            /** 
             * Get the 'Discount' element value.
             * 
             * @return value
             */
            public Discount getDiscount() {
                return discount;
            }

            /** 
             * Set the 'Discount' element value.
             * 
             * @param discount
             */
            public void setDiscount(Discount discount) {
                this.discount = discount;
            }

            /** 
             * Get the 'Flown' element value.
             * 
             * @return value
             */
            public Flown getFlown() {
                return flown;
            }

            /** 
             * Set the 'Flown' element value.
             * 
             * @param flown
             */
            public void setFlown(Flown flown) {
                this.flown = flown;
            }

            /** 
             * Get the 'SegmentNumber' attribute value. Segment number /SGI/@Q0C
             * 
             * @return value
             */
            public Short getSegmentNumber() {
                return segmentNumber;
            }

            /** 
             * Set the 'SegmentNumber' attribute value. Segment number /SGI/@Q0C
             * 
             * @param segmentNumber
             */
            public void setSegmentNumber(Short segmentNumber) {
                this.segmentNumber = segmentNumber;
            }

            /** 
             * Get the 'GoverningCarrier' attribute value. Governing carrier 
             * 
             * @return value
             */
            public String getGoverningCarrier() {
                return governingCarrier;
            }

            /** 
             * Set the 'GoverningCarrier' attribute value. Governing carrier 
             * 
             * @param governingCarrier
             */
            public void setGoverningCarrier(String governingCarrier) {
                this.governingCarrier = governingCarrier;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ForcedConnection" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ForcedConnection implements Serializable
            {
                private boolean ind;

                /** 
                 * Get the 'Ind' attribute value. Forced connection /SGI/@P72
                 * 
                 * @return value
                 */
                public boolean isInd() {
                    return ind;
                }

                /** 
                 * Set the 'Ind' attribute value. Forced connection /SGI/@P72
                 * 
                 * @param ind
                 */
                public void setInd(boolean ind) {
                    this.ind = ind;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ForcedStopOver" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ForcedStopOver implements Serializable
            {
                private boolean ind;

                /** 
                 * Get the 'Ind' attribute value. Forced stop over /SGI/@P73
                 * 
                 * @return value
                 */
                public boolean isInd() {
                    return ind;
                }

                /** 
                 * Set the 'Ind' attribute value. Forced stop over /SGI/@P73
                 * 
                 * @param ind
                 */
                public void setInd(boolean ind) {
                    this.ind = ind;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BreakFare" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="ForcedBreakFareInd"/>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="ForcedNoBreakFareInd"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class BreakFare implements Serializable
            {
                private Boolean forcedBreakFareInd;
                private Boolean forcedNoBreakFareInd;

                /** 
                 * Get the 'ForcedBreakFareInd' attribute value. Forced fare break /SGI/@P74
                 * 
                 * @return value
                 */
                public Boolean getForcedBreakFareInd() {
                    return forcedBreakFareInd;
                }

                /** 
                 * Set the 'ForcedBreakFareInd' attribute value. Forced fare break /SGI/@P74
                 * 
                 * @param forcedBreakFareInd
                 */
                public void setForcedBreakFareInd(Boolean forcedBreakFareInd) {
                    this.forcedBreakFareInd = forcedBreakFareInd;
                }

                /** 
                 * Get the 'ForcedNoBreakFareInd' attribute value. Forced no fare break /SGI/@P75
                 * 
                 * @return value
                 */
                public Boolean getForcedNoBreakFareInd() {
                    return forcedNoBreakFareInd;
                }

                /** 
                 * Set the 'ForcedNoBreakFareInd' attribute value. Forced no fare break /SGI/@P75
                 * 
                 * @param forcedNoBreakFareInd
                 */
                public void setForcedNoBreakFareInd(Boolean forcedNoBreakFareInd) {
                    this.forcedNoBreakFareInd = forcedNoBreakFareInd;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SideTrip" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class SideTrip implements Serializable
            {
                private boolean ind;

                /** 
                 * Get the 'Ind' attribute value. Forced side trip /SGI/@P76
                 * 
                 * @return value
                 */
                public boolean isInd() {
                    return ind;
                }

                /** 
                 * Set the 'Ind' attribute value. Forced side trip /SGI/@P76
                 * 
                 * @param ind
                 */
                public void setInd(boolean ind) {
                    this.ind = ind;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketDesignator" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="AuthCode"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="SpecifiedCode"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class TicketDesignator implements Serializable
            {
                private String authCode;
                private String specifiedCode;

                /** 
                 * Get the 'AuthCode' attribute value. Ticket designator /SGI/@BE0
                 * 
                 * @return value
                 */
                public String getAuthCode() {
                    return authCode;
                }

                /** 
                 * Set the 'AuthCode' attribute value. Ticket designator /SGI/@BE0
                 * 
                 * @param authCode
                 */
                public void setAuthCode(String authCode) {
                    this.authCode = authCode;
                }

                /** 
                 * Get the 'SpecifiedCode' attribute value. Specified ticket designator /SGI/@BD0
                 * 
                 * @return value
                 */
                public String getSpecifiedCode() {
                    return specifiedCode;
                }

                /** 
                 * Set the 'SpecifiedCode' attribute value. Specified ticket designator /SGI/@BD0
                 * 
                 * @param specifiedCode
                 */
                public void setSpecifiedCode(String specifiedCode) {
                    this.specifiedCode = specifiedCode;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Discount" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:decimal" use="optional" name="Amount"/>
             *     &lt;xs:attribute type="xs:short" use="optional" name="Percentage"/>
             *     &lt;xs:attribute type="xs:short" use="optional" name="AmountGroupNumber"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="AmountCurrencyCode"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Discount implements Serializable
            {
                private BigDecimal amount;
                private Short percentage;
                private Short amountGroupNumber;
                private String amountCurrencyCode;

                /** 
                 * Get the 'Amount' attribute value. Discount amount /SGI/@C6I
                 * 
                 * @return value
                 */
                public BigDecimal getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' attribute value. Discount amount /SGI/@C6I
                 * 
                 * @param amount
                 */
                public void setAmount(BigDecimal amount) {
                    this.amount = amount;
                }

                /** 
                 * Get the 'Percentage' attribute value. Discount percentage /SGI/@Q17
                 * 
                 * @return value
                 */
                public Short getPercentage() {
                    return percentage;
                }

                /** 
                 * Set the 'Percentage' attribute value. Discount percentage /SGI/@Q17
                 * 
                 * @param percentage
                 */
                public void setPercentage(Short percentage) {
                    this.percentage = percentage;
                }

                /** 
                 * Get the 'AmountGroupNumber' attribute value. Discount amount group number /SGI/@Q12
                 * 
                 * @return value
                 */
                public Short getAmountGroupNumber() {
                    return amountGroupNumber;
                }

                /** 
                 * Set the 'AmountGroupNumber' attribute value. Discount amount group number /SGI/@Q12
                 * 
                 * @param amountGroupNumber
                 */
                public void setAmountGroupNumber(Short amountGroupNumber) {
                    this.amountGroupNumber = amountGroupNumber;
                }

                /** 
                 * Get the 'AmountCurrencyCode' attribute value. Discount amount currency code /SGI/@C48
                 * 
                 * @return value
                 */
                public String getAmountCurrencyCode() {
                    return amountCurrencyCode;
                }

                /** 
                 * Set the 'AmountCurrencyCode' attribute value. Discount amount currency code /SGI/@C48
                 * 
                 * @param amountCurrencyCode
                 */
                public void setAmountCurrencyCode(String amountCurrencyCode) {
                    this.amountCurrencyCode = amountCurrencyCode;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Flown" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Flown implements Serializable
            {
                private boolean ind;

                /** 
                 * Get the 'Ind' attribute value. Segment Flown Indicator /SGI/@PCI
                 * 
                 * @return value
                 */
                public boolean isInd() {
                    return ind;
                }

                /** 
                 * Set the 'Ind' attribute value. Segment Flown Indicator /SGI/@PCI
                 * 
                 * @param ind
                 */
                public void setInd(boolean ind) {
                    this.ind = ind;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaxTypeInformation" minOccurs="1" maxOccurs="4">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="FareBasisCode"/>
         *     &lt;xs:attribute type="xs:string" use="required" name="PassengerType"/>
         *     &lt;xs:attribute type="xs:decimal" use="optional" name="FareComponentAmount"/>
         *     &lt;xs:attribute type="xs:short" use="required" name="FareComponentNumber"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PaxTypeInformation implements Serializable
        {
            private String fareBasisCode;
            private String passengerType;
            private BigDecimal fareComponentAmount;
            private Short fareComponentNumber;

            /** 
             * Get the 'FareBasisCode' attribute value. Fare Basis Code PXF/@B50 
             * 
             * @return value
             */
            public String getFareBasisCode() {
                return fareBasisCode;
            }

            /** 
             * Set the 'FareBasisCode' attribute value. Fare Basis Code PXF/@B50 
             * 
             * @param fareBasisCode
             */
            public void setFareBasisCode(String fareBasisCode) {
                this.fareBasisCode = fareBasisCode;
            }

            /** 
             * Get the 'PassengerType' attribute value. Passenger Type PXF/@B70
             * 
             * @return value
             */
            public String getPassengerType() {
                return passengerType;
            }

            /** 
             * Set the 'PassengerType' attribute value. Passenger Type PXF/@B70
             * 
             * @param passengerType
             */
            public void setPassengerType(String passengerType) {
                this.passengerType = passengerType;
            }

            /** 
             * Get the 'FareComponentAmount' attribute value. Fare Amount  PXF/@C51
             * 
             * @return value
             */
            public BigDecimal getFareComponentAmount() {
                return fareComponentAmount;
            }

            /** 
             * Set the 'FareComponentAmount' attribute value. Fare Amount  PXF/@C51
             * 
             * @param fareComponentAmount
             */
            public void setFareComponentAmount(BigDecimal fareComponentAmount) {
                this.fareComponentAmount = fareComponentAmount;
            }

            /** 
             * Get the 'FareComponentNumber' attribute value. Fare Component Number PXF/@Q6D
             * 
             * @return value
             */
            public Short getFareComponentNumber() {
                return fareComponentNumber;
            }

            /** 
             * Set the 'FareComponentNumber' attribute value. Fare Component Number PXF/@Q6D
             * 
             * @param fareComponentNumber
             */
            public void setFareComponentNumber(Short fareComponentNumber) {
                this.fareComponentNumber = fareComponentNumber;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="Test"/>
     *     &lt;xs:enumeration value="Production"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum Target implements Serializable {
        TEST("Test"), PRODUCTION("Production");
        private final String value;

        private Target(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static Target convert(String value) {
            for (Target inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
