
package com.sabre.webservices.sabrexml;

import com.sabre.services.stl.v01.ApplicationResults;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://services.sabre.com/STL/v01" xmlns:ns1="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelItineraryHistoryRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:ApplicationResults"/>
 *       &lt;xs:element name="HistoricalInfo" minOccurs="0" maxOccurs="unbounded">
 *         &lt;!-- Reference to inner class HistoricalInfo -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:string" use="optional" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class TravelItineraryHistoryRS implements Serializable
{
    private ApplicationResults applicationResults;
    private List<HistoricalInfo> historicalInfoList = new ArrayList<HistoricalInfo>();
    private String version;

    /** 
     * Get the 'ApplicationResults' element value.
     * 
     * @return value
     */
    public ApplicationResults getApplicationResults() {
        return applicationResults;
    }

    /** 
     * Set the 'ApplicationResults' element value.
     * 
     * @param applicationResults
     */
    public void setApplicationResults(ApplicationResults applicationResults) {
        this.applicationResults = applicationResults;
    }

    /** 
     * Get the list of 'HistoricalInfo' element items.
     * 
     * @return list
     */
    public List<HistoricalInfo> getHistoricalInfoList() {
        return historicalInfoList;
    }

    /** 
     * Set the list of 'HistoricalInfo' element items.
     * 
     * @param list
     */
    public void setHistoricalInfoList(List<HistoricalInfo> list) {
        historicalInfoList = list;
    }

    /** 
     * Get the 'Version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HistoricalInfo" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="AccountingInfo" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class AccountingInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="GeneralInfo" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class GeneralInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ItineraryInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class ItineraryInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ItineraryRef" minOccurs="0">
     *         &lt;!-- Reference to inner class ItineraryRef -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="InvoiceInfo" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class InvoiceInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="RemarkInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class RemarkInfo -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class HistoricalInfo implements Serializable
    {
        private List<AccountingInfo> accountingInfoList = new ArrayList<AccountingInfo>();
        private List<GeneralInfo> generalInfoList = new ArrayList<GeneralInfo>();
        private ItineraryInfo itineraryInfo;
        private ItineraryRef itineraryRef;
        private List<InvoiceInfo> invoiceInfoList = new ArrayList<InvoiceInfo>();
        private RemarkInfo remarkInfo;
        private String RPH;

        /** 
         * Get the list of 'AccountingInfo' element items.
         * 
         * @return list
         */
        public List<AccountingInfo> getAccountingInfoList() {
            return accountingInfoList;
        }

        /** 
         * Set the list of 'AccountingInfo' element items.
         * 
         * @param list
         */
        public void setAccountingInfoList(List<AccountingInfo> list) {
            accountingInfoList = list;
        }

        /** 
         * Get the list of 'GeneralInfo' element items.
         * 
         * @return list
         */
        public List<GeneralInfo> getGeneralInfoList() {
            return generalInfoList;
        }

        /** 
         * Set the list of 'GeneralInfo' element items.
         * 
         * @param list
         */
        public void setGeneralInfoList(List<GeneralInfo> list) {
            generalInfoList = list;
        }

        /** 
         * Get the 'ItineraryInfo' element value.
         * 
         * @return value
         */
        public ItineraryInfo getItineraryInfo() {
            return itineraryInfo;
        }

        /** 
         * Set the 'ItineraryInfo' element value.
         * 
         * @param itineraryInfo
         */
        public void setItineraryInfo(ItineraryInfo itineraryInfo) {
            this.itineraryInfo = itineraryInfo;
        }

        /** 
         * Get the 'ItineraryRef' element value.
         * 
         * @return value
         */
        public ItineraryRef getItineraryRef() {
            return itineraryRef;
        }

        /** 
         * Set the 'ItineraryRef' element value.
         * 
         * @param itineraryRef
         */
        public void setItineraryRef(ItineraryRef itineraryRef) {
            this.itineraryRef = itineraryRef;
        }

        /** 
         * Get the list of 'InvoiceInfo' element items.
         * 
         * @return list
         */
        public List<InvoiceInfo> getInvoiceInfoList() {
            return invoiceInfoList;
        }

        /** 
         * Set the list of 'InvoiceInfo' element items.
         * 
         * @param list
         */
        public void setInvoiceInfoList(List<InvoiceInfo> list) {
            invoiceInfoList = list;
        }

        /** 
         * Get the 'RemarkInfo' element value.
         * 
         * @return value
         */
        public RemarkInfo getRemarkInfo() {
            return remarkInfo;
        }

        /** 
         * Set the 'RemarkInfo' element value.
         * 
         * @param remarkInfo
         */
        public void setRemarkInfo(RemarkInfo remarkInfo) {
            this.remarkInfo = remarkInfo;
        }

        /** 
         * Get the 'RPH' attribute value.
         * 
         * @return value
         */
        public String getRPH() {
            return RPH;
        }

        /** 
         * Set the 'RPH' attribute value.
         * 
         * @param RPH
         */
        public void setRPH(String RPH) {
            this.RPH = RPH;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AccountingInfo" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="AccountVendor" minOccurs="0">
         *         &lt;!-- Reference to inner class AccountVendor -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Airline" minOccurs="0">
         *         &lt;!-- Reference to inner class Airline -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="BaseFare" minOccurs="0">
         *         &lt;!-- Reference to inner class BaseFare -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="DocumentInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class DocumentInfo -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="PaymentInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class PaymentInfo -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="PersonName" minOccurs="0">
         *         &lt;!-- Reference to inner class PersonName -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Taxes" minOccurs="0">
         *         &lt;!-- Reference to inner class Taxes -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
         *       &lt;xs:element name="TicketingInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class TicketingInfo -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="optional" name="Action"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="LinkCode"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AccountingInfo implements Serializable
        {
            private AccountVendor accountVendor;
            private Airline airline;
            private BaseFare baseFare;
            private DocumentInfo documentInfo;
            private PaymentInfo paymentInfo;
            private PersonName personName;
            private Taxes taxes;
            private String text;
            private TicketingInfo ticketingInfo;
            private String action;
            private String linkCode;
            private String type;

            /** 
             * Get the 'AccountVendor' element value.
             * 
             * @return value
             */
            public AccountVendor getAccountVendor() {
                return accountVendor;
            }

            /** 
             * Set the 'AccountVendor' element value.
             * 
             * @param accountVendor
             */
            public void setAccountVendor(AccountVendor accountVendor) {
                this.accountVendor = accountVendor;
            }

            /** 
             * Get the 'Airline' element value.
             * 
             * @return value
             */
            public Airline getAirline() {
                return airline;
            }

            /** 
             * Set the 'Airline' element value.
             * 
             * @param airline
             */
            public void setAirline(Airline airline) {
                this.airline = airline;
            }

            /** 
             * Get the 'BaseFare' element value.
             * 
             * @return value
             */
            public BaseFare getBaseFare() {
                return baseFare;
            }

            /** 
             * Set the 'BaseFare' element value.
             * 
             * @param baseFare
             */
            public void setBaseFare(BaseFare baseFare) {
                this.baseFare = baseFare;
            }

            /** 
             * Get the 'DocumentInfo' element value.
             * 
             * @return value
             */
            public DocumentInfo getDocumentInfo() {
                return documentInfo;
            }

            /** 
             * Set the 'DocumentInfo' element value.
             * 
             * @param documentInfo
             */
            public void setDocumentInfo(DocumentInfo documentInfo) {
                this.documentInfo = documentInfo;
            }

            /** 
             * Get the 'PaymentInfo' element value.
             * 
             * @return value
             */
            public PaymentInfo getPaymentInfo() {
                return paymentInfo;
            }

            /** 
             * Set the 'PaymentInfo' element value.
             * 
             * @param paymentInfo
             */
            public void setPaymentInfo(PaymentInfo paymentInfo) {
                this.paymentInfo = paymentInfo;
            }

            /** 
             * Get the 'PersonName' element value.
             * 
             * @return value
             */
            public PersonName getPersonName() {
                return personName;
            }

            /** 
             * Set the 'PersonName' element value.
             * 
             * @param personName
             */
            public void setPersonName(PersonName personName) {
                this.personName = personName;
            }

            /** 
             * Get the 'Taxes' element value.
             * 
             * @return value
             */
            public Taxes getTaxes() {
                return taxes;
            }

            /** 
             * Set the 'Taxes' element value.
             * 
             * @param taxes
             */
            public void setTaxes(Taxes taxes) {
                this.taxes = taxes;
            }

            /** 
             * Get the 'Text' element value.
             * 
             * @return value
             */
            public String getText() {
                return text;
            }

            /** 
             * Set the 'Text' element value.
             * 
             * @param text
             */
            public void setText(String text) {
                this.text = text;
            }

            /** 
             * Get the 'TicketingInfo' element value.
             * 
             * @return value
             */
            public TicketingInfo getTicketingInfo() {
                return ticketingInfo;
            }

            /** 
             * Set the 'TicketingInfo' element value.
             * 
             * @param ticketingInfo
             */
            public void setTicketingInfo(TicketingInfo ticketingInfo) {
                this.ticketingInfo = ticketingInfo;
            }

            /** 
             * Get the 'Action' attribute value.
             * 
             * @return value
             */
            public String getAction() {
                return action;
            }

            /** 
             * Set the 'Action' attribute value.
             * 
             * @param action
             */
            public void setAction(String action) {
                this.action = action;
            }

            /** 
             * Get the 'LinkCode' attribute value.
             * 
             * @return value
             */
            public String getLinkCode() {
                return linkCode;
            }

            /** 
             * Set the 'LinkCode' attribute value.
             * 
             * @param linkCode
             */
            public void setLinkCode(String linkCode) {
                this.linkCode = linkCode;
            }

            /** 
             * Get the 'Type' attribute value.
             * 
             * @return value
             */
            public String getType() {
                return type;
            }

            /** 
             * Set the 'Type' attribute value.
             * 
             * @param type
             */
            public void setType(String type) {
                this.type = type;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AccountVendor" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AccountVendor implements Serializable
            {
                private String code;

                /** 
                 * Get the 'Code' attribute value.
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'Code' attribute value.
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Airline" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Airline implements Serializable
            {
                private String code;

                /** 
                 * Get the 'Code' attribute value.
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'Code' attribute value.
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Percent"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class BaseFare implements Serializable
            {
                private String amount;
                private String currencyCode;
                private String percent;

                /** 
                 * Get the 'Amount' attribute value.
                 * 
                 * @return value
                 */
                public String getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' attribute value.
                 * 
                 * @param amount
                 */
                public void setAmount(String amount) {
                    this.amount = amount;
                }

                /** 
                 * Get the 'CurrencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'CurrencyCode' attribute value.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'Percent' attribute value.
                 * 
                 * @return value
                 */
                public String getPercent() {
                    return percent;
                }

                /** 
                 * Set the 'Percent' attribute value.
                 * 
                 * @param percent
                 */
                public void setPercent(String percent) {
                    this.percent = percent;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DocumentInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Document" minOccurs="0">
             *         &lt;!-- Reference to inner class Document -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class DocumentInfo implements Serializable
            {
                private Document document;

                /** 
                 * Get the 'Document' element value.
                 * 
                 * @return value
                 */
                public Document getDocument() {
                    return document;
                }

                /** 
                 * Set the 'Document' element value.
                 * 
                 * @param document
                 */
                public void setDocument(Document document) {
                    this.document = document;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Document" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Number"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Document implements Serializable
                {
                    private String number;

                    /** 
                     * Get the 'Number' attribute value.
                     * 
                     * @return value
                     */
                    public String getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'Number' attribute value.
                     * 
                     * @param number
                     */
                    public void setNumber(String number) {
                        this.number = number;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Commission" minOccurs="0">
             *         &lt;!-- Reference to inner class Commission -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="FareApplication" minOccurs="0"/>
             *       &lt;xs:element name="Payment" minOccurs="0">
             *         &lt;!-- Reference to inner class Payment -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class PaymentInfo implements Serializable
            {
                private Commission commission;
                private String fareApplication;
                private Payment payment;

                /** 
                 * Get the 'Commission' element value.
                 * 
                 * @return value
                 */
                public Commission getCommission() {
                    return commission;
                }

                /** 
                 * Set the 'Commission' element value.
                 * 
                 * @param commission
                 */
                public void setCommission(Commission commission) {
                    this.commission = commission;
                }

                /** 
                 * Get the 'FareApplication' element value.
                 * 
                 * @return value
                 */
                public String getFareApplication() {
                    return fareApplication;
                }

                /** 
                 * Set the 'FareApplication' element value.
                 * 
                 * @param fareApplication
                 */
                public void setFareApplication(String fareApplication) {
                    this.fareApplication = fareApplication;
                }

                /** 
                 * Get the 'Payment' element value.
                 * 
                 * @return value
                 */
                public Payment getPayment() {
                    return payment;
                }

                /** 
                 * Set the 'Payment' element value.
                 * 
                 * @param payment
                 */
                public void setPayment(Payment payment) {
                    this.payment = payment;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Commission" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Percent"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Commission implements Serializable
                {
                    private String amount;
                    private String percent;

                    /** 
                     * Get the 'Amount' attribute value.
                     * 
                     * @return value
                     */
                    public String getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' attribute value.
                     * 
                     * @param amount
                     */
                    public void setAmount(String amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'Percent' attribute value.
                     * 
                     * @return value
                     */
                    public String getPercent() {
                        return percent;
                    }

                    /** 
                     * Set the 'Percent' attribute value.
                     * 
                     * @param percent
                     */
                    public void setPercent(String percent) {
                        this.percent = percent;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payment" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="CC_Info" minOccurs="0">
                 *         &lt;!-- Reference to inner class CCInfo -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:string" name="Form" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Payment implements Serializable
                {
                    private CCInfo CCInfo1;
                    private String form;

                    /** 
                     * Get the 'CC_Info' element value.
                     * 
                     * @return value
                     */
                    public CCInfo getCCInfo1() {
                        return CCInfo1;
                    }

                    /** 
                     * Set the 'CC_Info' element value.
                     * 
                     * @param CCInfo1
                     */
                    public void setCCInfo1(CCInfo CCInfo1) {
                        this.CCInfo1 = CCInfo1;
                    }

                    /** 
                     * Get the 'Form' element value.
                     * 
                     * @return value
                     */
                    public String getForm() {
                        return form;
                    }

                    /** 
                     * Set the 'Form' element value.
                     * 
                     * @param form
                     */
                    public void setForm(String form) {
                        this.form = form;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="PaymentCard" minOccurs="0">
                     *         &lt;!-- Reference to inner class PaymentCard -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CCInfo implements Serializable
                    {
                        private PaymentCard paymentCard;

                        /** 
                         * Get the 'PaymentCard' element value.
                         * 
                         * @return value
                         */
                        public PaymentCard getPaymentCard() {
                            return paymentCard;
                        }

                        /** 
                         * Set the 'PaymentCard' element value.
                         * 
                         * @param paymentCard
                         */
                        public void setPaymentCard(PaymentCard paymentCard) {
                            this.paymentCard = paymentCard;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentCard" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Number"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class PaymentCard implements Serializable
                        {
                            private String code;
                            private String number;

                            /** 
                             * Get the 'Code' attribute value.
                             * 
                             * @return value
                             */
                            public String getCode() {
                                return code;
                            }

                            /** 
                             * Set the 'Code' attribute value.
                             * 
                             * @param code
                             */
                            public void setCode(String code) {
                                this.code = code;
                            }

                            /** 
                             * Get the 'Number' attribute value.
                             * 
                             * @return value
                             */
                            public String getNumber() {
                                return number;
                            }

                            /** 
                             * Set the 'Number' attribute value.
                             * 
                             * @param number
                             */
                            public void setNumber(String number) {
                                this.number = number;
                            }
                        }
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PersonName" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute type="xs:string" use="optional" name="NameNumber"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class PersonName implements Serializable
            {
                private String string;
                private String nameNumber;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'NameNumber' attribute value.
                 * 
                 * @return value
                 */
                public String getNameNumber() {
                    return nameNumber;
                }

                /** 
                 * Set the 'NameNumber' attribute value.
                 * 
                 * @param nameNumber
                 */
                public void setNameNumber(String nameNumber) {
                    this.nameNumber = nameNumber;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="GST" minOccurs="0">
             *         &lt;!-- Reference to inner class GST -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="QST" minOccurs="0">
             *         &lt;!-- Reference to inner class QST -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Tax" minOccurs="0">
             *         &lt;!-- Reference to inner class Tax -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Taxes implements Serializable
            {
                private GST GST1;
                private QST QST1;
                private Tax tax;

                /** 
                 * Get the 'GST' element value.
                 * 
                 * @return value
                 */
                public GST getGST1() {
                    return GST1;
                }

                /** 
                 * Set the 'GST' element value.
                 * 
                 * @param GST1
                 */
                public void setGST1(GST GST1) {
                    this.GST1 = GST1;
                }

                /** 
                 * Get the 'QST' element value.
                 * 
                 * @return value
                 */
                public QST getQST1() {
                    return QST1;
                }

                /** 
                 * Set the 'QST' element value.
                 * 
                 * @param QST1
                 */
                public void setQST1(QST QST1) {
                    this.QST1 = QST1;
                }

                /** 
                 * Get the 'Tax' element value.
                 * 
                 * @return value
                 */
                public Tax getTax() {
                    return tax;
                }

                /** 
                 * Set the 'Tax' element value.
                 * 
                 * @param tax
                 */
                public void setTax(Tax tax) {
                    this.tax = tax;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GST" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Percent"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class GST implements Serializable
                {
                    private String amount;
                    private String currencyCode;
                    private String percent;

                    /** 
                     * Get the 'Amount' attribute value.
                     * 
                     * @return value
                     */
                    public String getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' attribute value.
                     * 
                     * @param amount
                     */
                    public void setAmount(String amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'CurrencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'CurrencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'Percent' attribute value.
                     * 
                     * @return value
                     */
                    public String getPercent() {
                        return percent;
                    }

                    /** 
                     * Set the 'Percent' attribute value.
                     * 
                     * @param percent
                     */
                    public void setPercent(String percent) {
                        this.percent = percent;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="QST" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Percent"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="TaxCode"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class QST implements Serializable
                {
                    private String amount;
                    private String currencyCode;
                    private String percent;
                    private String taxCode;

                    /** 
                     * Get the 'Amount' attribute value.
                     * 
                     * @return value
                     */
                    public String getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' attribute value.
                     * 
                     * @param amount
                     */
                    public void setAmount(String amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'CurrencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'CurrencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'Percent' attribute value.
                     * 
                     * @return value
                     */
                    public String getPercent() {
                        return percent;
                    }

                    /** 
                     * Set the 'Percent' attribute value.
                     * 
                     * @param percent
                     */
                    public void setPercent(String percent) {
                        this.percent = percent;
                    }

                    /** 
                     * Get the 'TaxCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getTaxCode() {
                        return taxCode;
                    }

                    /** 
                     * Set the 'TaxCode' attribute value.
                     * 
                     * @param taxCode
                     */
                    public void setTaxCode(String taxCode) {
                        this.taxCode = taxCode;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Percent"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="TaxCode"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Tax implements Serializable
                {
                    private String amount;
                    private String currencyCode;
                    private String percent;
                    private String taxCode;

                    /** 
                     * Get the 'Amount' attribute value.
                     * 
                     * @return value
                     */
                    public String getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' attribute value.
                     * 
                     * @param amount
                     */
                    public void setAmount(String amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'CurrencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'CurrencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'Percent' attribute value.
                     * 
                     * @return value
                     */
                    public String getPercent() {
                        return percent;
                    }

                    /** 
                     * Set the 'Percent' attribute value.
                     * 
                     * @param percent
                     */
                    public void setPercent(String percent) {
                        this.percent = percent;
                    }

                    /** 
                     * Get the 'TaxCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getTaxCode() {
                        return taxCode;
                    }

                    /** 
                     * Set the 'TaxCode' attribute value.
                     * 
                     * @param taxCode
                     */
                    public void setTaxCode(String taxCode) {
                        this.taxCode = taxCode;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketingInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Exchange" minOccurs="0">
             *         &lt;!-- Reference to inner class Exchange -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="IssueDate" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="IssueLocation" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="OriginalInvoiceNumber" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="OriginalTicketNumber" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="TarriffBasis" minOccurs="0"/>
             *       &lt;xs:element name="Ticketing" minOccurs="0">
             *         &lt;!-- Reference to inner class Ticketing -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class TicketingInfo implements Serializable
            {
                private Exchange exchange;
                private String issueDate;
                private String issueLocation;
                private String originalInvoiceNumber;
                private String originalTicketNumber;
                private String tarriffBasis;
                private Ticketing ticketing;

                /** 
                 * Get the 'Exchange' element value.
                 * 
                 * @return value
                 */
                public Exchange getExchange() {
                    return exchange;
                }

                /** 
                 * Set the 'Exchange' element value.
                 * 
                 * @param exchange
                 */
                public void setExchange(Exchange exchange) {
                    this.exchange = exchange;
                }

                /** 
                 * Get the 'IssueDate' element value.
                 * 
                 * @return value
                 */
                public String getIssueDate() {
                    return issueDate;
                }

                /** 
                 * Set the 'IssueDate' element value.
                 * 
                 * @param issueDate
                 */
                public void setIssueDate(String issueDate) {
                    this.issueDate = issueDate;
                }

                /** 
                 * Get the 'IssueLocation' element value.
                 * 
                 * @return value
                 */
                public String getIssueLocation() {
                    return issueLocation;
                }

                /** 
                 * Set the 'IssueLocation' element value.
                 * 
                 * @param issueLocation
                 */
                public void setIssueLocation(String issueLocation) {
                    this.issueLocation = issueLocation;
                }

                /** 
                 * Get the 'OriginalInvoiceNumber' element value.
                 * 
                 * @return value
                 */
                public String getOriginalInvoiceNumber() {
                    return originalInvoiceNumber;
                }

                /** 
                 * Set the 'OriginalInvoiceNumber' element value.
                 * 
                 * @param originalInvoiceNumber
                 */
                public void setOriginalInvoiceNumber(
                        String originalInvoiceNumber) {
                    this.originalInvoiceNumber = originalInvoiceNumber;
                }

                /** 
                 * Get the 'OriginalTicketNumber' element value.
                 * 
                 * @return value
                 */
                public String getOriginalTicketNumber() {
                    return originalTicketNumber;
                }

                /** 
                 * Set the 'OriginalTicketNumber' element value.
                 * 
                 * @param originalTicketNumber
                 */
                public void setOriginalTicketNumber(String originalTicketNumber) {
                    this.originalTicketNumber = originalTicketNumber;
                }

                /** 
                 * Get the 'TarriffBasis' element value.
                 * 
                 * @return value
                 */
                public String getTarriffBasis() {
                    return tarriffBasis;
                }

                /** 
                 * Set the 'TarriffBasis' element value.
                 * 
                 * @param tarriffBasis
                 */
                public void setTarriffBasis(String tarriffBasis) {
                    this.tarriffBasis = tarriffBasis;
                }

                /** 
                 * Get the 'Ticketing' element value.
                 * 
                 * @return value
                 */
                public Ticketing getTicketing() {
                    return ticketing;
                }

                /** 
                 * Set the 'Ticketing' element value.
                 * 
                 * @param ticketing
                 */
                public void setTicketing(Ticketing ticketing) {
                    this.ticketing = ticketing;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Exchange" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Ind"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Exchange implements Serializable
                {
                    private Boolean ind;

                    /** 
                     * Get the 'Ind' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value.
                     * 
                     * @param ind
                     */
                    public void setInd(Boolean ind) {
                        this.ind = ind;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Ticketing" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="ConjunctedCount"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="CouponCount"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Ticketing implements Serializable
                {
                    private String conjunctedCount;
                    private String couponCount;

                    /** 
                     * Get the 'ConjunctedCount' attribute value.
                     * 
                     * @return value
                     */
                    public String getConjunctedCount() {
                        return conjunctedCount;
                    }

                    /** 
                     * Set the 'ConjunctedCount' attribute value.
                     * 
                     * @param conjunctedCount
                     */
                    public void setConjunctedCount(String conjunctedCount) {
                        this.conjunctedCount = conjunctedCount;
                    }

                    /** 
                     * Get the 'CouponCount' attribute value.
                     * 
                     * @return value
                     */
                    public String getCouponCount() {
                        return couponCount;
                    }

                    /** 
                     * Set the 'CouponCount' attribute value.
                     * 
                     * @param couponCount
                     */
                    public void setCouponCount(String couponCount) {
                        this.couponCount = couponCount;
                    }
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GeneralInfo" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="optional" name="Action"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class GeneralInfo implements Serializable
        {
            private String text;
            private String action;

            /** 
             * Get the 'Text' element value.
             * 
             * @return value
             */
            public String getText() {
                return text;
            }

            /** 
             * Set the 'Text' element value.
             * 
             * @param text
             */
            public void setText(String text) {
                this.text = text;
            }

            /** 
             * Get the 'Action' attribute value.
             * 
             * @return value
             */
            public String getAction() {
                return action;
            }

            /** 
             * Set the 'Action' attribute value.
             * 
             * @param action
             */
            public void setAction(String action) {
                this.action = action;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ItineraryInfo" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="ReservationItems" minOccurs="0">
         *         &lt;!-- Reference to inner class ReservationItems -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ItineraryInfo implements Serializable
        {
            private ReservationItems reservationItems;

            /** 
             * Get the 'ReservationItems' element value.
             * 
             * @return value
             */
            public ReservationItems getReservationItems() {
                return reservationItems;
            }

            /** 
             * Set the 'ReservationItems' element value.
             * 
             * @param reservationItems
             */
            public void setReservationItems(ReservationItems reservationItems) {
                this.reservationItems = reservationItems;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReservationItems" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Item" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class Item -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ReservationItems implements Serializable
            {
                private List<Item> itemList = new ArrayList<Item>();

                /** 
                 * Get the list of 'Item' element items.
                 * 
                 * @return list
                 */
                public List<Item> getItemList() {
                    return itemList;
                }

                /** 
                 * Set the list of 'Item' element items.
                 * 
                 * @param list
                 */
                public void setItemList(List<Item> list) {
                    itemList = list;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Item" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="FlightSegment" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class FlightSegment -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Hotel" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class Hotel -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Insurance" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class Insurance -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Rail" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class Rail -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Seats" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class Seats -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Vehicle" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class Vehicle -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Item implements Serializable
                {
                    private List<FlightSegment> flightSegmentList = new ArrayList<FlightSegment>();
                    private List<Hotel> hotelList = new ArrayList<Hotel>();
                    private List<Insurance> insuranceList = new ArrayList<Insurance>();
                    private List<Rail> railList = new ArrayList<Rail>();
                    private List<Seats> seatList = new ArrayList<Seats>();
                    private List<Vehicle> vehicleList = new ArrayList<Vehicle>();
                    private String RPH;

                    /** 
                     * Get the list of 'FlightSegment' element items.
                     * 
                     * @return list
                     */
                    public List<FlightSegment> getFlightSegmentList() {
                        return flightSegmentList;
                    }

                    /** 
                     * Set the list of 'FlightSegment' element items.
                     * 
                     * @param list
                     */
                    public void setFlightSegmentList(List<FlightSegment> list) {
                        flightSegmentList = list;
                    }

                    /** 
                     * Get the list of 'Hotel' element items.
                     * 
                     * @return list
                     */
                    public List<Hotel> getHotelList() {
                        return hotelList;
                    }

                    /** 
                     * Set the list of 'Hotel' element items.
                     * 
                     * @param list
                     */
                    public void setHotelList(List<Hotel> list) {
                        hotelList = list;
                    }

                    /** 
                     * Get the list of 'Insurance' element items.
                     * 
                     * @return list
                     */
                    public List<Insurance> getInsuranceList() {
                        return insuranceList;
                    }

                    /** 
                     * Set the list of 'Insurance' element items.
                     * 
                     * @param list
                     */
                    public void setInsuranceList(List<Insurance> list) {
                        insuranceList = list;
                    }

                    /** 
                     * Get the list of 'Rail' element items.
                     * 
                     * @return list
                     */
                    public List<Rail> getRailList() {
                        return railList;
                    }

                    /** 
                     * Set the list of 'Rail' element items.
                     * 
                     * @param list
                     */
                    public void setRailList(List<Rail> list) {
                        railList = list;
                    }

                    /** 
                     * Get the list of 'Seats' element items.
                     * 
                     * @return list
                     */
                    public List<Seats> getSeatList() {
                        return seatList;
                    }

                    /** 
                     * Set the list of 'Seats' element items.
                     * 
                     * @param list
                     */
                    public void setSeatList(List<Seats> list) {
                        seatList = list;
                    }

                    /** 
                     * Get the list of 'Vehicle' element items.
                     * 
                     * @return list
                     */
                    public List<Vehicle> getVehicleList() {
                        return vehicleList;
                    }

                    /** 
                     * Set the list of 'Vehicle' element items.
                     * 
                     * @param list
                     */
                    public void setVehicleList(List<Vehicle> list) {
                        vehicleList = list;
                    }

                    /** 
                     * Get the 'RPH' attribute value.
                     * 
                     * @return value
                     */
                    public String getRPH() {
                        return RPH;
                    }

                    /** 
                     * Set the 'RPH' attribute value.
                     * 
                     * @param RPH
                     */
                    public void setRPH(String RPH) {
                        this.RPH = RPH;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightSegment" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="DestinationLocation" minOccurs="0">
                     *         &lt;!-- Reference to inner class DestinationLocation -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="MarketingAirline" minOccurs="0">
                     *         &lt;!-- Reference to inner class MarketingAirline -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="MarriageGrp" minOccurs="0">
                     *         &lt;!-- Reference to inner class MarriageGrp -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="OriginLocation" minOccurs="0">
                     *         &lt;!-- Reference to inner class OriginLocation -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="SupplierRef" minOccurs="0">
                     *         &lt;!-- Reference to inner class SupplierRef -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Action"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="ArrivalDateTime"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="ConnectionInd"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="DepartureDateTime"/>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="eTicket"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="FlightNumber"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="NumberInParty"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="ResBookDesigCode"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Status"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class FlightSegment implements Serializable
                    {
                        private DestinationLocation destinationLocation;
                        private MarketingAirline marketingAirline;
                        private MarriageGrp marriageGrp;
                        private OriginLocation originLocation;
                        private SupplierRef supplierRef;
                        private String action;
                        private String arrivalDateTime;
                        private String connectionInd;
                        private String departureDateTime;
                        private Boolean ETicket;
                        private String flightNumber;
                        private String numberInParty;
                        private String resBookDesigCode;
                        private String status;

                        /** 
                         * Get the 'DestinationLocation' element value.
                         * 
                         * @return value
                         */
                        public DestinationLocation getDestinationLocation() {
                            return destinationLocation;
                        }

                        /** 
                         * Set the 'DestinationLocation' element value.
                         * 
                         * @param destinationLocation
                         */
                        public void setDestinationLocation(
                                DestinationLocation destinationLocation) {
                            this.destinationLocation = destinationLocation;
                        }

                        /** 
                         * Get the 'MarketingAirline' element value.
                         * 
                         * @return value
                         */
                        public MarketingAirline getMarketingAirline() {
                            return marketingAirline;
                        }

                        /** 
                         * Set the 'MarketingAirline' element value.
                         * 
                         * @param marketingAirline
                         */
                        public void setMarketingAirline(
                                MarketingAirline marketingAirline) {
                            this.marketingAirline = marketingAirline;
                        }

                        /** 
                         * Get the 'MarriageGrp' element value.
                         * 
                         * @return value
                         */
                        public MarriageGrp getMarriageGrp() {
                            return marriageGrp;
                        }

                        /** 
                         * Set the 'MarriageGrp' element value.
                         * 
                         * @param marriageGrp
                         */
                        public void setMarriageGrp(MarriageGrp marriageGrp) {
                            this.marriageGrp = marriageGrp;
                        }

                        /** 
                         * Get the 'OriginLocation' element value.
                         * 
                         * @return value
                         */
                        public OriginLocation getOriginLocation() {
                            return originLocation;
                        }

                        /** 
                         * Set the 'OriginLocation' element value.
                         * 
                         * @param originLocation
                         */
                        public void setOriginLocation(
                                OriginLocation originLocation) {
                            this.originLocation = originLocation;
                        }

                        /** 
                         * Get the 'SupplierRef' element value.
                         * 
                         * @return value
                         */
                        public SupplierRef getSupplierRef() {
                            return supplierRef;
                        }

                        /** 
                         * Set the 'SupplierRef' element value.
                         * 
                         * @param supplierRef
                         */
                        public void setSupplierRef(SupplierRef supplierRef) {
                            this.supplierRef = supplierRef;
                        }

                        /** 
                         * Get the 'Action' attribute value.
                         * 
                         * @return value
                         */
                        public String getAction() {
                            return action;
                        }

                        /** 
                         * Set the 'Action' attribute value.
                         * 
                         * @param action
                         */
                        public void setAction(String action) {
                            this.action = action;
                        }

                        /** 
                         * Get the 'ArrivalDateTime' attribute value.
                         * 
                         * @return value
                         */
                        public String getArrivalDateTime() {
                            return arrivalDateTime;
                        }

                        /** 
                         * Set the 'ArrivalDateTime' attribute value.
                         * 
                         * @param arrivalDateTime
                         */
                        public void setArrivalDateTime(String arrivalDateTime) {
                            this.arrivalDateTime = arrivalDateTime;
                        }

                        /** 
                         * Get the 'ConnectionInd' attribute value.
                         * 
                         * @return value
                         */
                        public String getConnectionInd() {
                            return connectionInd;
                        }

                        /** 
                         * Set the 'ConnectionInd' attribute value.
                         * 
                         * @param connectionInd
                         */
                        public void setConnectionInd(String connectionInd) {
                            this.connectionInd = connectionInd;
                        }

                        /** 
                         * Get the 'DepartureDateTime' attribute value.
                         * 
                         * @return value
                         */
                        public String getDepartureDateTime() {
                            return departureDateTime;
                        }

                        /** 
                         * Set the 'DepartureDateTime' attribute value.
                         * 
                         * @param departureDateTime
                         */
                        public void setDepartureDateTime(
                                String departureDateTime) {
                            this.departureDateTime = departureDateTime;
                        }

                        /** 
                         * Get the 'eTicket' attribute value.
                         * 
                         * @return value
                         */
                        public Boolean getETicket() {
                            return ETicket;
                        }

                        /** 
                         * Set the 'eTicket' attribute value.
                         * 
                         * @param eTicket
                         */
                        public void setETicket(Boolean eTicket) {
                            ETicket = eTicket;
                        }

                        /** 
                         * Get the 'FlightNumber' attribute value.
                         * 
                         * @return value
                         */
                        public String getFlightNumber() {
                            return flightNumber;
                        }

                        /** 
                         * Set the 'FlightNumber' attribute value.
                         * 
                         * @param flightNumber
                         */
                        public void setFlightNumber(String flightNumber) {
                            this.flightNumber = flightNumber;
                        }

                        /** 
                         * Get the 'NumberInParty' attribute value.
                         * 
                         * @return value
                         */
                        public String getNumberInParty() {
                            return numberInParty;
                        }

                        /** 
                         * Set the 'NumberInParty' attribute value.
                         * 
                         * @param numberInParty
                         */
                        public void setNumberInParty(String numberInParty) {
                            this.numberInParty = numberInParty;
                        }

                        /** 
                         * Get the 'ResBookDesigCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getResBookDesigCode() {
                            return resBookDesigCode;
                        }

                        /** 
                         * Set the 'ResBookDesigCode' attribute value.
                         * 
                         * @param resBookDesigCode
                         */
                        public void setResBookDesigCode(String resBookDesigCode) {
                            this.resBookDesigCode = resBookDesigCode;
                        }

                        /** 
                         * Get the 'Status' attribute value.
                         * 
                         * @return value
                         */
                        public String getStatus() {
                            return status;
                        }

                        /** 
                         * Set the 'Status' attribute value.
                         * 
                         * @param status
                         */
                        public void setStatus(String status) {
                            this.status = status;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DestinationLocation" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class DestinationLocation implements
                            Serializable
                        {
                            private String locationCode;

                            /** 
                             * Get the 'LocationCode' attribute value.
                             * 
                             * @return value
                             */
                            public String getLocationCode() {
                                return locationCode;
                            }

                            /** 
                             * Set the 'LocationCode' attribute value.
                             * 
                             * @param locationCode
                             */
                            public void setLocationCode(String locationCode) {
                                this.locationCode = locationCode;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarketingAirline" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="FlightNumber"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class MarketingAirline implements
                            Serializable
                        {
                            private String code;
                            private String flightNumber;

                            /** 
                             * Get the 'Code' attribute value.
                             * 
                             * @return value
                             */
                            public String getCode() {
                                return code;
                            }

                            /** 
                             * Set the 'Code' attribute value.
                             * 
                             * @param code
                             */
                            public void setCode(String code) {
                                this.code = code;
                            }

                            /** 
                             * Get the 'FlightNumber' attribute value.
                             * 
                             * @return value
                             */
                            public String getFlightNumber() {
                                return flightNumber;
                            }

                            /** 
                             * Set the 'FlightNumber' attribute value.
                             * 
                             * @param flightNumber
                             */
                            public void setFlightNumber(String flightNumber) {
                                this.flightNumber = flightNumber;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarriageGrp" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Ind"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class MarriageGrp implements Serializable
                        {
                            private String ind;

                            /** 
                             * Get the 'Ind' attribute value.
                             * 
                             * @return value
                             */
                            public String getInd() {
                                return ind;
                            }

                            /** 
                             * Set the 'Ind' attribute value.
                             * 
                             * @param ind
                             */
                            public void setInd(String ind) {
                                this.ind = ind;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginLocation" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class OriginLocation implements
                            Serializable
                        {
                            private String locationCode;

                            /** 
                             * Get the 'LocationCode' attribute value.
                             * 
                             * @return value
                             */
                            public String getLocationCode() {
                                return locationCode;
                            }

                            /** 
                             * Set the 'LocationCode' attribute value.
                             * 
                             * @param locationCode
                             */
                            public void setLocationCode(String locationCode) {
                                this.locationCode = locationCode;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SupplierRef" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="ID"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class SupplierRef implements Serializable
                        {
                            private String ID;

                            /** 
                             * Get the 'ID' attribute value.
                             * 
                             * @return value
                             */
                            public String getID() {
                                return ID;
                            }

                            /** 
                             * Set the 'ID' attribute value.
                             * 
                             * @param ID
                             */
                            public void setID(String ID) {
                                this.ID = ID;
                            }
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Hotel" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="BasicPropertyInfo" minOccurs="0">
                     *         &lt;!-- Reference to inner class BasicPropertyInfo -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="Customer" minOccurs="0">
                     *         &lt;!-- Reference to inner class Customer -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element type="xs:string" name="Guarantee" minOccurs="0"/>
                     *       &lt;xs:element name="POS" minOccurs="0">
                     *         &lt;!-- Reference to inner class POS -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="RoomRates" minOccurs="0">
                     *         &lt;!-- Reference to inner class RoomRates -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="SpecialPrefs" minOccurs="0">
                     *         &lt;!-- Reference to inner class SpecialPrefs -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                     *       &lt;xs:element name="TimeSpan" minOccurs="0">
                     *         &lt;!-- Reference to inner class TimeSpan -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Action"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="LinkCode"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="MergedSegmentInd"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="NumberInParty"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="NumberOfUnits"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Status"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Hotel implements Serializable
                    {
                        private BasicPropertyInfo basicPropertyInfo;
                        private Customer customer;
                        private String guarantee;
                        private POS POS1;
                        private RoomRates roomRates;
                        private SpecialPrefs specialPrefs;
                        private String text;
                        private TimeSpan timeSpan;
                        private String action;
                        private String linkCode;
                        private String mergedSegmentInd;
                        private String numberInParty;
                        private String numberOfUnits;
                        private String status;
                        private String type;

                        /** 
                         * Get the 'BasicPropertyInfo' element value.
                         * 
                         * @return value
                         */
                        public BasicPropertyInfo getBasicPropertyInfo() {
                            return basicPropertyInfo;
                        }

                        /** 
                         * Set the 'BasicPropertyInfo' element value.
                         * 
                         * @param basicPropertyInfo
                         */
                        public void setBasicPropertyInfo(
                                BasicPropertyInfo basicPropertyInfo) {
                            this.basicPropertyInfo = basicPropertyInfo;
                        }

                        /** 
                         * Get the 'Customer' element value.
                         * 
                         * @return value
                         */
                        public Customer getCustomer() {
                            return customer;
                        }

                        /** 
                         * Set the 'Customer' element value.
                         * 
                         * @param customer
                         */
                        public void setCustomer(Customer customer) {
                            this.customer = customer;
                        }

                        /** 
                         * Get the 'Guarantee' element value.
                         * 
                         * @return value
                         */
                        public String getGuarantee() {
                            return guarantee;
                        }

                        /** 
                         * Set the 'Guarantee' element value.
                         * 
                         * @param guarantee
                         */
                        public void setGuarantee(String guarantee) {
                            this.guarantee = guarantee;
                        }

                        /** 
                         * Get the 'POS' element value.
                         * 
                         * @return value
                         */
                        public POS getPOS1() {
                            return POS1;
                        }

                        /** 
                         * Set the 'POS' element value.
                         * 
                         * @param POS1
                         */
                        public void setPOS1(POS POS1) {
                            this.POS1 = POS1;
                        }

                        /** 
                         * Get the 'RoomRates' element value.
                         * 
                         * @return value
                         */
                        public RoomRates getRoomRates() {
                            return roomRates;
                        }

                        /** 
                         * Set the 'RoomRates' element value.
                         * 
                         * @param roomRates
                         */
                        public void setRoomRates(RoomRates roomRates) {
                            this.roomRates = roomRates;
                        }

                        /** 
                         * Get the 'SpecialPrefs' element value.
                         * 
                         * @return value
                         */
                        public SpecialPrefs getSpecialPrefs() {
                            return specialPrefs;
                        }

                        /** 
                         * Set the 'SpecialPrefs' element value.
                         * 
                         * @param specialPrefs
                         */
                        public void setSpecialPrefs(SpecialPrefs specialPrefs) {
                            this.specialPrefs = specialPrefs;
                        }

                        /** 
                         * Get the 'Text' element value.
                         * 
                         * @return value
                         */
                        public String getText() {
                            return text;
                        }

                        /** 
                         * Set the 'Text' element value.
                         * 
                         * @param text
                         */
                        public void setText(String text) {
                            this.text = text;
                        }

                        /** 
                         * Get the 'TimeSpan' element value.
                         * 
                         * @return value
                         */
                        public TimeSpan getTimeSpan() {
                            return timeSpan;
                        }

                        /** 
                         * Set the 'TimeSpan' element value.
                         * 
                         * @param timeSpan
                         */
                        public void setTimeSpan(TimeSpan timeSpan) {
                            this.timeSpan = timeSpan;
                        }

                        /** 
                         * Get the 'Action' attribute value.
                         * 
                         * @return value
                         */
                        public String getAction() {
                            return action;
                        }

                        /** 
                         * Set the 'Action' attribute value.
                         * 
                         * @param action
                         */
                        public void setAction(String action) {
                            this.action = action;
                        }

                        /** 
                         * Get the 'LinkCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getLinkCode() {
                            return linkCode;
                        }

                        /** 
                         * Set the 'LinkCode' attribute value.
                         * 
                         * @param linkCode
                         */
                        public void setLinkCode(String linkCode) {
                            this.linkCode = linkCode;
                        }

                        /** 
                         * Get the 'MergedSegmentInd' attribute value.
                         * 
                         * @return value
                         */
                        public String getMergedSegmentInd() {
                            return mergedSegmentInd;
                        }

                        /** 
                         * Set the 'MergedSegmentInd' attribute value.
                         * 
                         * @param mergedSegmentInd
                         */
                        public void setMergedSegmentInd(String mergedSegmentInd) {
                            this.mergedSegmentInd = mergedSegmentInd;
                        }

                        /** 
                         * Get the 'NumberInParty' attribute value.
                         * 
                         * @return value
                         */
                        public String getNumberInParty() {
                            return numberInParty;
                        }

                        /** 
                         * Set the 'NumberInParty' attribute value.
                         * 
                         * @param numberInParty
                         */
                        public void setNumberInParty(String numberInParty) {
                            this.numberInParty = numberInParty;
                        }

                        /** 
                         * Get the 'NumberOfUnits' attribute value.
                         * 
                         * @return value
                         */
                        public String getNumberOfUnits() {
                            return numberOfUnits;
                        }

                        /** 
                         * Set the 'NumberOfUnits' attribute value.
                         * 
                         * @param numberOfUnits
                         */
                        public void setNumberOfUnits(String numberOfUnits) {
                            this.numberOfUnits = numberOfUnits;
                        }

                        /** 
                         * Get the 'Status' attribute value.
                         * 
                         * @return value
                         */
                        public String getStatus() {
                            return status;
                        }

                        /** 
                         * Set the 'Status' attribute value.
                         * 
                         * @param status
                         */
                        public void setStatus(String status) {
                            this.status = status;
                        }

                        /** 
                         * Get the 'Type' attribute value.
                         * 
                         * @return value
                         */
                        public String getType() {
                            return type;
                        }

                        /** 
                         * Set the 'Type' attribute value.
                         * 
                         * @param type
                         */
                        public void setType(String type) {
                            this.type = type;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BasicPropertyInfo" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="Address" minOccurs="0">
                         *         &lt;!-- Reference to inner class Address -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element type="xs:string" name="ConfirmationNumber" minOccurs="0"/>
                         *       &lt;xs:element name="ContactNumbers" minOccurs="0">
                         *         &lt;!-- Reference to inner class ContactNumbers -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="ChainCode"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="HotelCityCode"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="HotelCode"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="HotelName"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class BasicPropertyInfo implements
                            Serializable
                        {
                            private Address address;
                            private String confirmationNumber;
                            private ContactNumbers contactNumbers;
                            private String chainCode;
                            private String hotelCityCode;
                            private String hotelCode;
                            private String hotelName;

                            /** 
                             * Get the 'Address' element value.
                             * 
                             * @return value
                             */
                            public Address getAddress() {
                                return address;
                            }

                            /** 
                             * Set the 'Address' element value.
                             * 
                             * @param address
                             */
                            public void setAddress(Address address) {
                                this.address = address;
                            }

                            /** 
                             * Get the 'ConfirmationNumber' element value.
                             * 
                             * @return value
                             */
                            public String getConfirmationNumber() {
                                return confirmationNumber;
                            }

                            /** 
                             * Set the 'ConfirmationNumber' element value.
                             * 
                             * @param confirmationNumber
                             */
                            public void setConfirmationNumber(
                                    String confirmationNumber) {
                                this.confirmationNumber = confirmationNumber;
                            }

                            /** 
                             * Get the 'ContactNumbers' element value.
                             * 
                             * @return value
                             */
                            public ContactNumbers getContactNumbers() {
                                return contactNumbers;
                            }

                            /** 
                             * Set the 'ContactNumbers' element value.
                             * 
                             * @param contactNumbers
                             */
                            public void setContactNumbers(
                                    ContactNumbers contactNumbers) {
                                this.contactNumbers = contactNumbers;
                            }

                            /** 
                             * Get the 'ChainCode' attribute value.
                             * 
                             * @return value
                             */
                            public String getChainCode() {
                                return chainCode;
                            }

                            /** 
                             * Set the 'ChainCode' attribute value.
                             * 
                             * @param chainCode
                             */
                            public void setChainCode(String chainCode) {
                                this.chainCode = chainCode;
                            }

                            /** 
                             * Get the 'HotelCityCode' attribute value.
                             * 
                             * @return value
                             */
                            public String getHotelCityCode() {
                                return hotelCityCode;
                            }

                            /** 
                             * Set the 'HotelCityCode' attribute value.
                             * 
                             * @param hotelCityCode
                             */
                            public void setHotelCityCode(String hotelCityCode) {
                                this.hotelCityCode = hotelCityCode;
                            }

                            /** 
                             * Get the 'HotelCode' attribute value.
                             * 
                             * @return value
                             */
                            public String getHotelCode() {
                                return hotelCode;
                            }

                            /** 
                             * Set the 'HotelCode' attribute value.
                             * 
                             * @param hotelCode
                             */
                            public void setHotelCode(String hotelCode) {
                                this.hotelCode = hotelCode;
                            }

                            /** 
                             * Get the 'HotelName' attribute value.
                             * 
                             * @return value
                             */
                            public String getHotelName() {
                                return hotelName;
                            }

                            /** 
                             * Set the 'HotelName' attribute value.
                             * 
                             * @param hotelName
                             */
                            public void setHotelName(String hotelName) {
                                this.hotelName = hotelName;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Address" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element type="xs:string" name="AddressLine" minOccurs="0" maxOccurs="3"/>
                             *     &lt;/xs:sequence>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Address implements Serializable
                            {
                                private List<String> addressLineList = new ArrayList<String>();

                                /** 
                                 * Get the list of 'AddressLine' element items.
                                 * 
                                 * @return list
                                 */
                                public List<String> getAddressLineList() {
                                    return addressLineList;
                                }

                                /** 
                                 * Set the list of 'AddressLine' element items.
                                 * 
                                 * @param list
                                 */
                                public void setAddressLineList(List<String> list) {
                                    addressLineList = list;
                                }
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactNumbers" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element name="ContactNumber" minOccurs="0">
                             *         &lt;!-- Reference to inner class ContactNumber -->
                             *       &lt;/xs:element>
                             *     &lt;/xs:sequence>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class ContactNumbers implements
                                Serializable
                            {
                                private ContactNumber contactNumber;

                                /** 
                                 * Get the 'ContactNumber' element value.
                                 * 
                                 * @return value
                                 */
                                public ContactNumber getContactNumber() {
                                    return contactNumber;
                                }

                                /** 
                                 * Set the 'ContactNumber' element value.
                                 * 
                                 * @param contactNumber
                                 */
                                public void setContactNumber(
                                        ContactNumber contactNumber) {
                                    this.contactNumber = contactNumber;
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactNumber" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Phone"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class ContactNumber implements
                                    Serializable
                                {
                                    private String phone;

                                    /** 
                                     * Get the 'Phone' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public String getPhone() {
                                        return phone;
                                    }

                                    /** 
                                     * Set the 'Phone' attribute value.
                                     * 
                                     * @param phone
                                     */
                                    public void setPhone(String phone) {
                                        this.phone = phone;
                                    }
                                }
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Customer" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="Corporate" minOccurs="0">
                         *         &lt;!-- Reference to inner class Corporate -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element name="CustLoyalty" minOccurs="0">
                         *         &lt;!-- Reference to inner class CustLoyalty -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element name="ID" minOccurs="0">
                         *         &lt;!-- Reference to inner class ID -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element type="xs:string" name="ReserveUnderName" minOccurs="0"/>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Customer implements Serializable
                        {
                            private Corporate corporate;
                            private CustLoyalty custLoyalty;
                            private ID ID1;
                            private String reserveUnderName;

                            /** 
                             * Get the 'Corporate' element value.
                             * 
                             * @return value
                             */
                            public Corporate getCorporate() {
                                return corporate;
                            }

                            /** 
                             * Set the 'Corporate' element value.
                             * 
                             * @param corporate
                             */
                            public void setCorporate(Corporate corporate) {
                                this.corporate = corporate;
                            }

                            /** 
                             * Get the 'CustLoyalty' element value.
                             * 
                             * @return value
                             */
                            public CustLoyalty getCustLoyalty() {
                                return custLoyalty;
                            }

                            /** 
                             * Set the 'CustLoyalty' element value.
                             * 
                             * @param custLoyalty
                             */
                            public void setCustLoyalty(CustLoyalty custLoyalty) {
                                this.custLoyalty = custLoyalty;
                            }

                            /** 
                             * Get the 'ID' element value.
                             * 
                             * @return value
                             */
                            public ID getID1() {
                                return ID1;
                            }

                            /** 
                             * Set the 'ID' element value.
                             * 
                             * @param ID1
                             */
                            public void setID1(ID ID1) {
                                this.ID1 = ID1;
                            }

                            /** 
                             * Get the 'ReserveUnderName' element value.
                             * 
                             * @return value
                             */
                            public String getReserveUnderName() {
                                return reserveUnderName;
                            }

                            /** 
                             * Set the 'ReserveUnderName' element value.
                             * 
                             * @param reserveUnderName
                             */
                            public void setReserveUnderName(
                                    String reserveUnderName) {
                                this.reserveUnderName = reserveUnderName;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Corporate" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element type="xs:string" name="ID" minOccurs="0"/>
                             *     &lt;/xs:sequence>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Corporate implements
                                Serializable
                            {
                                private String ID;

                                /** 
                                 * Get the 'ID' element value.
                                 * 
                                 * @return value
                                 */
                                public String getID() {
                                    return ID;
                                }

                                /** 
                                 * Set the 'ID' element value.
                                 * 
                                 * @param ID
                                 */
                                public void setID(String ID) {
                                    this.ID = ID;
                                }
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CustLoyalty" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="MembershipID"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class CustLoyalty implements
                                Serializable
                            {
                                private String membershipID;

                                /** 
                                 * Get the 'MembershipID' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getMembershipID() {
                                    return membershipID;
                                }

                                /** 
                                 * Set the 'MembershipID' attribute value.
                                 * 
                                 * @param membershipID
                                 */
                                public void setMembershipID(String membershipID) {
                                    this.membershipID = membershipID;
                                }
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ID" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element type="xs:string" name="Number" minOccurs="0"/>
                             *     &lt;/xs:sequence>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class ID implements Serializable
                            {
                                private String number;

                                /** 
                                 * Get the 'Number' element value.
                                 * 
                                 * @return value
                                 */
                                public String getNumber() {
                                    return number;
                                }

                                /** 
                                 * Set the 'Number' element value.
                                 * 
                                 * @param number
                                 */
                                public void setNumber(String number) {
                                    this.number = number;
                                }
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="POS" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="Source" minOccurs="0">
                         *         &lt;!-- Reference to inner class Source -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class POS implements Serializable
                        {
                            private Source source;

                            /** 
                             * Get the 'Source' element value.
                             * 
                             * @return value
                             */
                            public Source getSource() {
                                return source;
                            }

                            /** 
                             * Set the 'Source' element value.
                             * 
                             * @param source
                             */
                            public void setSource(Source source) {
                                this.source = source;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Source" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element type="xs:string" name="RequestorID" minOccurs="0"/>
                             *     &lt;/xs:sequence>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Source implements Serializable
                            {
                                private String requestorID;

                                /** 
                                 * Get the 'RequestorID' element value.
                                 * 
                                 * @return value
                                 */
                                public String getRequestorID() {
                                    return requestorID;
                                }

                                /** 
                                 * Set the 'RequestorID' element value.
                                 * 
                                 * @param requestorID
                                 */
                                public void setRequestorID(String requestorID) {
                                    this.requestorID = requestorID;
                                }
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RoomRates" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="RoomRate" minOccurs="0">
                         *         &lt;!-- Reference to inner class RoomRate -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class RoomRates implements Serializable
                        {
                            private RoomRate roomRate;

                            /** 
                             * Get the 'RoomRate' element value.
                             * 
                             * @return value
                             */
                            public RoomRate getRoomRate() {
                                return roomRate;
                            }

                            /** 
                             * Set the 'RoomRate' element value.
                             * 
                             * @param roomRate
                             */
                            public void setRoomRate(RoomRate roomRate) {
                                this.roomRate = roomRate;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RoomRate" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element name="AdditionalInfo" minOccurs="0">
                             *         &lt;!-- Reference to inner class AdditionalInfo -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="Commission" minOccurs="0">
                             *         &lt;!-- Reference to inner class Commission -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="Rates" minOccurs="0">
                             *         &lt;!-- Reference to inner class Rates -->
                             *       &lt;/xs:element>
                             *     &lt;/xs:sequence>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class RoomRate implements
                                Serializable
                            {
                                private AdditionalInfo additionalInfo;
                                private Commission commission;
                                private Rates rates;

                                /** 
                                 * Get the 'AdditionalInfo' element value.
                                 * 
                                 * @return value
                                 */
                                public AdditionalInfo getAdditionalInfo() {
                                    return additionalInfo;
                                }

                                /** 
                                 * Set the 'AdditionalInfo' element value.
                                 * 
                                 * @param additionalInfo
                                 */
                                public void setAdditionalInfo(
                                        AdditionalInfo additionalInfo) {
                                    this.additionalInfo = additionalInfo;
                                }

                                /** 
                                 * Get the 'Commission' element value.
                                 * 
                                 * @return value
                                 */
                                public Commission getCommission() {
                                    return commission;
                                }

                                /** 
                                 * Set the 'Commission' element value.
                                 * 
                                 * @param commission
                                 */
                                public void setCommission(Commission commission) {
                                    this.commission = commission;
                                }

                                /** 
                                 * Get the 'Rates' element value.
                                 * 
                                 * @return value
                                 */
                                public Rates getRates() {
                                    return rates;
                                }

                                /** 
                                 * Set the 'Rates' element value.
                                 * 
                                 * @param rates
                                 */
                                public void setRates(Rates rates) {
                                    this.rates = rates;
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AdditionalInfo" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:sequence>
                                 *       &lt;xs:element name="CancelPolicy" minOccurs="0">
                                 *         &lt;!-- Reference to inner class CancelPolicy -->
                                 *       &lt;/xs:element>
                                 *       &lt;xs:element name="DCA_Advance" minOccurs="0">
                                 *         &lt;!-- Reference to inner class DCAAdvance -->
                                 *       &lt;/xs:element>
                                 *       &lt;xs:element name="DCA_Cancellation" minOccurs="0">
                                 *         &lt;!-- Reference to inner class DCACancellation -->
                                 *       &lt;/xs:element>
                                 *       &lt;xs:element name="DCA_Deposit" minOccurs="0">
                                 *         &lt;!-- Reference to inner class DCADeposit -->
                                 *       &lt;/xs:element>
                                 *       &lt;xs:element name="DCA_Guarantee" minOccurs="0">
                                 *         &lt;!-- Reference to inner class DCAGuarantee -->
                                 *       &lt;/xs:element>
                                 *       &lt;xs:element name="DCA_Other" minOccurs="0">
                                 *         &lt;!-- Reference to inner class DCAOther -->
                                 *       &lt;/xs:element>
                                 *     &lt;/xs:sequence>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class AdditionalInfo implements
                                    Serializable
                                {
                                    private CancelPolicy cancelPolicy;
                                    private DCAAdvance DCAAdvance1;
                                    private DCACancellation DCACancellation1;
                                    private DCADeposit DCADeposit1;
                                    private DCAGuarantee DCAGuarantee1;
                                    private DCAOther DCAOther1;

                                    /** 
                                     * Get the 'CancelPolicy' element value.
                                     * 
                                     * @return value
                                     */
                                    public CancelPolicy getCancelPolicy() {
                                        return cancelPolicy;
                                    }

                                    /** 
                                     * Set the 'CancelPolicy' element value.
                                     * 
                                     * @param cancelPolicy
                                     */
                                    public void setCancelPolicy(
                                            CancelPolicy cancelPolicy) {
                                        this.cancelPolicy = cancelPolicy;
                                    }

                                    /** 
                                     * Get the 'DCA_Advance' element value.
                                     * 
                                     * @return value
                                     */
                                    public DCAAdvance getDCAAdvance1() {
                                        return DCAAdvance1;
                                    }

                                    /** 
                                     * Set the 'DCA_Advance' element value.
                                     * 
                                     * @param DCAAdvance1
                                     */
                                    public void setDCAAdvance1(
                                            DCAAdvance DCAAdvance1) {
                                        this.DCAAdvance1 = DCAAdvance1;
                                    }

                                    /** 
                                     * Get the 'DCA_Cancellation' element value.
                                     * 
                                     * @return value
                                     */
                                    public DCACancellation getDCACancellation1() {
                                        return DCACancellation1;
                                    }

                                    /** 
                                     * Set the 'DCA_Cancellation' element value.
                                     * 
                                     * @param DCACancellation1
                                     */
                                    public void setDCACancellation1(
                                            DCACancellation DCACancellation1) {
                                        this.DCACancellation1 = DCACancellation1;
                                    }

                                    /** 
                                     * Get the 'DCA_Deposit' element value.
                                     * 
                                     * @return value
                                     */
                                    public DCADeposit getDCADeposit1() {
                                        return DCADeposit1;
                                    }

                                    /** 
                                     * Set the 'DCA_Deposit' element value.
                                     * 
                                     * @param DCADeposit1
                                     */
                                    public void setDCADeposit1(
                                            DCADeposit DCADeposit1) {
                                        this.DCADeposit1 = DCADeposit1;
                                    }

                                    /** 
                                     * Get the 'DCA_Guarantee' element value.
                                     * 
                                     * @return value
                                     */
                                    public DCAGuarantee getDCAGuarantee1() {
                                        return DCAGuarantee1;
                                    }

                                    /** 
                                     * Set the 'DCA_Guarantee' element value.
                                     * 
                                     * @param DCAGuarantee1
                                     */
                                    public void setDCAGuarantee1(
                                            DCAGuarantee DCAGuarantee1) {
                                        this.DCAGuarantee1 = DCAGuarantee1;
                                    }

                                    /** 
                                     * Get the 'DCA_Other' element value.
                                     * 
                                     * @return value
                                     */
                                    public DCAOther getDCAOther1() {
                                        return DCAOther1;
                                    }

                                    /** 
                                     * Set the 'DCA_Other' element value.
                                     * 
                                     * @param DCAOther1
                                     */
                                    public void setDCAOther1(DCAOther DCAOther1) {
                                        this.DCAOther1 = DCAOther1;
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CancelPolicy" minOccurs="0">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:sequence>
                                     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                                     *     &lt;/xs:sequence>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class CancelPolicy implements
                                        Serializable
                                    {
                                        private String text;

                                        /** 
                                         * Get the 'Text' element value.
                                         * 
                                         * @return value
                                         */
                                        public String getText() {
                                            return text;
                                        }

                                        /** 
                                         * Set the 'Text' element value.
                                         * 
                                         * @param text
                                         */
                                        public void setText(String text) {
                                            this.text = text;
                                        }
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DCA_Advance" minOccurs="0">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:sequence>
                                     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
                                     *     &lt;/xs:sequence>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class DCAAdvance implements
                                        Serializable
                                    {
                                        private List<String> textList = new ArrayList<String>();

                                        /** 
                                         * Get the list of 'Text' element items.
                                         * 
                                         * @return list
                                         */
                                        public List<String> getTextList() {
                                            return textList;
                                        }

                                        /** 
                                         * Set the list of 'Text' element items.
                                         * 
                                         * @param list
                                         */
                                        public void setTextList(
                                                List<String> list) {
                                            textList = list;
                                        }
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DCA_Cancellation" minOccurs="0">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:sequence>
                                     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
                                     *     &lt;/xs:sequence>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class DCACancellation
                                        implements Serializable
                                    {
                                        private List<String> textList = new ArrayList<String>();

                                        /** 
                                         * Get the list of 'Text' element items.
                                         * 
                                         * @return list
                                         */
                                        public List<String> getTextList() {
                                            return textList;
                                        }

                                        /** 
                                         * Set the list of 'Text' element items.
                                         * 
                                         * @param list
                                         */
                                        public void setTextList(
                                                List<String> list) {
                                            textList = list;
                                        }
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DCA_Deposit" minOccurs="0">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:sequence>
                                     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
                                     *     &lt;/xs:sequence>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class DCADeposit implements
                                        Serializable
                                    {
                                        private List<String> textList = new ArrayList<String>();

                                        /** 
                                         * Get the list of 'Text' element items.
                                         * 
                                         * @return list
                                         */
                                        public List<String> getTextList() {
                                            return textList;
                                        }

                                        /** 
                                         * Set the list of 'Text' element items.
                                         * 
                                         * @param list
                                         */
                                        public void setTextList(
                                                List<String> list) {
                                            textList = list;
                                        }
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DCA_Guarantee" minOccurs="0">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:sequence>
                                     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
                                     *     &lt;/xs:sequence>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class DCAGuarantee implements
                                        Serializable
                                    {
                                        private List<String> textList = new ArrayList<String>();

                                        /** 
                                         * Get the list of 'Text' element items.
                                         * 
                                         * @return list
                                         */
                                        public List<String> getTextList() {
                                            return textList;
                                        }

                                        /** 
                                         * Set the list of 'Text' element items.
                                         * 
                                         * @param list
                                         */
                                        public void setTextList(
                                                List<String> list) {
                                            textList = list;
                                        }
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DCA_Other" minOccurs="0">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:sequence>
                                     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
                                     *     &lt;/xs:sequence>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class DCAOther implements
                                        Serializable
                                    {
                                        private List<String> textList = new ArrayList<String>();

                                        /** 
                                         * Get the list of 'Text' element items.
                                         * 
                                         * @return list
                                         */
                                        public List<String> getTextList() {
                                            return textList;
                                        }

                                        /** 
                                         * Set the list of 'Text' element items.
                                         * 
                                         * @param list
                                         */
                                        public void setTextList(
                                                List<String> list) {
                                            textList = list;
                                        }
                                    }
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Commission" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:simpleContent>
                                 *       &lt;xs:extension base="xs:string">
                                 *         &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                 *         &lt;xs:attribute type="xs:boolean" use="optional" name="NonCommission"/>
                                 *         &lt;xs:attribute type="xs:string" use="optional" name="Percent"/>
                                 *       &lt;/xs:extension>
                                 *     &lt;/xs:simpleContent>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class Commission implements
                                    Serializable
                                {
                                    private String string;
                                    private String amount;
                                    private Boolean nonCommission;
                                    private String percent;

                                    /** 
                                     * Get the extension value.
                                     * 
                                     * @return value
                                     */
                                    public String getString() {
                                        return string;
                                    }

                                    /** 
                                     * Set the extension value.
                                     * 
                                     * @param string
                                     */
                                    public void setString(String string) {
                                        this.string = string;
                                    }

                                    /** 
                                     * Get the 'Amount' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public String getAmount() {
                                        return amount;
                                    }

                                    /** 
                                     * Set the 'Amount' attribute value.
                                     * 
                                     * @param amount
                                     */
                                    public void setAmount(String amount) {
                                        this.amount = amount;
                                    }

                                    /** 
                                     * Get the 'NonCommission' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public Boolean getNonCommission() {
                                        return nonCommission;
                                    }

                                    /** 
                                     * Set the 'NonCommission' attribute value.
                                     * 
                                     * @param nonCommission
                                     */
                                    public void setNonCommission(
                                            Boolean nonCommission) {
                                        this.nonCommission = nonCommission;
                                    }

                                    /** 
                                     * Get the 'Percent' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public String getPercent() {
                                        return percent;
                                    }

                                    /** 
                                     * Set the 'Percent' attribute value.
                                     * 
                                     * @param percent
                                     */
                                    public void setPercent(String percent) {
                                        this.percent = percent;
                                    }
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Rates" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:sequence>
                                 *       &lt;xs:element name="Rate" minOccurs="0">
                                 *         &lt;!-- Reference to inner class Rate -->
                                 *       &lt;/xs:element>
                                 *     &lt;/xs:sequence>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class Rates implements
                                    Serializable
                                {
                                    private Rate rate;

                                    /** 
                                     * Get the 'Rate' element value.
                                     * 
                                     * @return value
                                     */
                                    public Rate getRate() {
                                        return rate;
                                    }

                                    /** 
                                     * Set the 'Rate' element value.
                                     * 
                                     * @param rate
                                     */
                                    public void setRate(Rate rate) {
                                        this.rate = rate;
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Rate" minOccurs="0">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:sequence>
                                     *       &lt;xs:element name="AdditionalGuestAmounts" minOccurs="0">
                                     *         &lt;!-- Reference to inner class AdditionalGuestAmounts -->
                                     *       &lt;/xs:element>
                                     *       &lt;xs:element name="HotelTotalPricing" minOccurs="0">
                                     *         &lt;!-- Reference to inner class HotelTotalPricing -->
                                     *       &lt;/xs:element>
                                     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="30"/>
                                     *     &lt;/xs:sequence>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="CancelPolicy"/>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="DepositRequired"/>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="GuaranteeRequired"/>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="LAP"/>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="RoomTypeCode"/>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class Rate implements
                                        Serializable
                                    {
                                        private AdditionalGuestAmounts additionalGuestAmounts;
                                        private HotelTotalPricing hotelTotalPricing;
                                        private List<String> textList = new ArrayList<String>();
                                        private String amount;
                                        private String cancelPolicy;
                                        private String currencyCode;
                                        private String depositRequired;
                                        private String guaranteeRequired;
                                        private String LAP;
                                        private String roomTypeCode;

                                        /** 
                                         * Get the 'AdditionalGuestAmounts' element value.
                                         * 
                                         * @return value
                                         */
                                        public AdditionalGuestAmounts getAdditionalGuestAmounts() {
                                            return additionalGuestAmounts;
                                        }

                                        /** 
                                         * Set the 'AdditionalGuestAmounts' element value.
                                         * 
                                         * @param additionalGuestAmounts
                                         */
                                        public void setAdditionalGuestAmounts(
                                                AdditionalGuestAmounts additionalGuestAmounts) {
                                            this.additionalGuestAmounts = additionalGuestAmounts;
                                        }

                                        /** 
                                         * Get the 'HotelTotalPricing' element value.
                                         * 
                                         * @return value
                                         */
                                        public HotelTotalPricing getHotelTotalPricing() {
                                            return hotelTotalPricing;
                                        }

                                        /** 
                                         * Set the 'HotelTotalPricing' element value.
                                         * 
                                         * @param hotelTotalPricing
                                         */
                                        public void setHotelTotalPricing(
                                                HotelTotalPricing hotelTotalPricing) {
                                            this.hotelTotalPricing = hotelTotalPricing;
                                        }

                                        /** 
                                         * Get the list of 'Text' element items.
                                         * 
                                         * @return list
                                         */
                                        public List<String> getTextList() {
                                            return textList;
                                        }

                                        /** 
                                         * Set the list of 'Text' element items.
                                         * 
                                         * @param list
                                         */
                                        public void setTextList(
                                                List<String> list) {
                                            textList = list;
                                        }

                                        /** 
                                         * Get the 'Amount' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getAmount() {
                                            return amount;
                                        }

                                        /** 
                                         * Set the 'Amount' attribute value.
                                         * 
                                         * @param amount
                                         */
                                        public void setAmount(String amount) {
                                            this.amount = amount;
                                        }

                                        /** 
                                         * Get the 'CancelPolicy' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getCancelPolicy() {
                                            return cancelPolicy;
                                        }

                                        /** 
                                         * Set the 'CancelPolicy' attribute value.
                                         * 
                                         * @param cancelPolicy
                                         */
                                        public void setCancelPolicy(
                                                String cancelPolicy) {
                                            this.cancelPolicy = cancelPolicy;
                                        }

                                        /** 
                                         * Get the 'CurrencyCode' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getCurrencyCode() {
                                            return currencyCode;
                                        }

                                        /** 
                                         * Set the 'CurrencyCode' attribute value.
                                         * 
                                         * @param currencyCode
                                         */
                                        public void setCurrencyCode(
                                                String currencyCode) {
                                            this.currencyCode = currencyCode;
                                        }

                                        /** 
                                         * Get the 'DepositRequired' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getDepositRequired() {
                                            return depositRequired;
                                        }

                                        /** 
                                         * Set the 'DepositRequired' attribute value.
                                         * 
                                         * @param depositRequired
                                         */
                                        public void setDepositRequired(
                                                String depositRequired) {
                                            this.depositRequired = depositRequired;
                                        }

                                        /** 
                                         * Get the 'GuaranteeRequired' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getGuaranteeRequired() {
                                            return guaranteeRequired;
                                        }

                                        /** 
                                         * Set the 'GuaranteeRequired' attribute value.
                                         * 
                                         * @param guaranteeRequired
                                         */
                                        public void setGuaranteeRequired(
                                                String guaranteeRequired) {
                                            this.guaranteeRequired = guaranteeRequired;
                                        }

                                        /** 
                                         * Get the 'LAP' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getLAP() {
                                            return LAP;
                                        }

                                        /** 
                                         * Set the 'LAP' attribute value.
                                         * 
                                         * @param LAP
                                         */
                                        public void setLAP(String LAP) {
                                            this.LAP = LAP;
                                        }

                                        /** 
                                         * Get the 'RoomTypeCode' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getRoomTypeCode() {
                                            return roomTypeCode;
                                        }

                                        /** 
                                         * Set the 'RoomTypeCode' attribute value.
                                         * 
                                         * @param roomTypeCode
                                         */
                                        public void setRoomTypeCode(
                                                String roomTypeCode) {
                                            this.roomTypeCode = roomTypeCode;
                                        }
                                        /** 
                                         * Schema fragment(s) for this class:
                                         * <pre>
                                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AdditionalGuestAmounts" minOccurs="0">
                                         *   &lt;xs:complexType>
                                         *     &lt;xs:sequence>
                                         *       &lt;xs:element name="AdditionalGuestAmount" minOccurs="0">
                                         *         &lt;!-- Reference to inner class AdditionalGuestAmount -->
                                         *       &lt;/xs:element>
                                         *     &lt;/xs:sequence>
                                         *   &lt;/xs:complexType>
                                         * &lt;/xs:element>
                                         * </pre>
                                         */
                                        public static class AdditionalGuestAmounts
                                            implements Serializable
                                        {
                                            private AdditionalGuestAmount additionalGuestAmount;

                                            /** 
                                             * Get the 'AdditionalGuestAmount' element value.
                                             * 
                                             * @return value
                                             */
                                            public AdditionalGuestAmount getAdditionalGuestAmount() {
                                                return additionalGuestAmount;
                                            }

                                            /** 
                                             * Set the 'AdditionalGuestAmount' element value.
                                             * 
                                             * @param additionalGuestAmount
                                             */
                                            public void setAdditionalGuestAmount(
                                                    AdditionalGuestAmount additionalGuestAmount) {
                                                this.additionalGuestAmount = additionalGuestAmount;
                                            }
                                            /** 
                                             * Schema fragment(s) for this class:
                                             * <pre>
                                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AdditionalGuestAmount" minOccurs="0">
                                             *   &lt;xs:complexType>
                                             *     &lt;xs:attribute type="xs:string" use="optional" name="NumCribs"/>
                                             *     &lt;xs:attribute type="xs:string" use="optional" name="NumExtraPersons"/>
                                             *     &lt;xs:attribute type="xs:string" use="optional" name="NumRollaways"/>
                                             *   &lt;/xs:complexType>
                                             * &lt;/xs:element>
                                             * </pre>
                                             */
                                            public static class AdditionalGuestAmount
                                                implements Serializable
                                            {
                                                private String numCribs;
                                                private String numExtraPersons;
                                                private String numRollaways;

                                                /** 
                                                 * Get the 'NumCribs' attribute value.
                                                 * 
                                                 * @return value
                                                 */
                                                public String getNumCribs() {
                                                    return numCribs;
                                                }

                                                /** 
                                                 * Set the 'NumCribs' attribute value.
                                                 * 
                                                 * @param numCribs
                                                 */
                                                public void setNumCribs(
                                                        String numCribs) {
                                                    this.numCribs = numCribs;
                                                }

                                                /** 
                                                 * Get the 'NumExtraPersons' attribute value.
                                                 * 
                                                 * @return value
                                                 */
                                                public String getNumExtraPersons() {
                                                    return numExtraPersons;
                                                }

                                                /** 
                                                 * Set the 'NumExtraPersons' attribute value.
                                                 * 
                                                 * @param numExtraPersons
                                                 */
                                                public void setNumExtraPersons(
                                                        String numExtraPersons) {
                                                    this.numExtraPersons = numExtraPersons;
                                                }

                                                /** 
                                                 * Get the 'NumRollaways' attribute value.
                                                 * 
                                                 * @return value
                                                 */
                                                public String getNumRollaways() {
                                                    return numRollaways;
                                                }

                                                /** 
                                                 * Set the 'NumRollaways' attribute value.
                                                 * 
                                                 * @param numRollaways
                                                 */
                                                public void setNumRollaways(
                                                        String numRollaways) {
                                                    this.numRollaways = numRollaways;
                                                }
                                            }
                                        }
                                        /** 
                                         * Schema fragment(s) for this class:
                                         * <pre>
                                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HotelTotalPricing" minOccurs="0">
                                         *   &lt;xs:complexType>
                                         *     &lt;xs:sequence>
                                         *       &lt;xs:element type="xs:string" name="Disclaimer" minOccurs="0" maxOccurs="unbounded"/>
                                         *       &lt;xs:element name="RateRange" minOccurs="0" maxOccurs="8">
                                         *         &lt;!-- Reference to inner class RateRange -->
                                         *       &lt;/xs:element>
                                         *       &lt;xs:element name="TotalSurcharges" minOccurs="0">
                                         *         &lt;!-- Reference to inner class TotalSurcharges -->
                                         *       &lt;/xs:element>
                                         *       &lt;xs:element name="TotalTaxes" minOccurs="0">
                                         *         &lt;!-- Reference to inner class TotalTaxes -->
                                         *       &lt;/xs:element>
                                         *     &lt;/xs:sequence>
                                         *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                         *   &lt;/xs:complexType>
                                         * &lt;/xs:element>
                                         * </pre>
                                         */
                                        public static class HotelTotalPricing
                                            implements Serializable
                                        {
                                            private List<String> disclaimerList = new ArrayList<String>();
                                            private List<RateRange> rateRangeList = new ArrayList<RateRange>();
                                            private TotalSurcharges totalSurcharges;
                                            private TotalTaxes totalTaxes;
                                            private String amount;

                                            /** 
                                             * Get the list of 'Disclaimer' element items.
                                             * 
                                             * @return list
                                             */
                                            public List<String> getDisclaimerList() {
                                                return disclaimerList;
                                            }

                                            /** 
                                             * Set the list of 'Disclaimer' element items.
                                             * 
                                             * @param list
                                             */
                                            public void setDisclaimerList(
                                                    List<String> list) {
                                                disclaimerList = list;
                                            }

                                            /** 
                                             * Get the list of 'RateRange' element items.
                                             * 
                                             * @return list
                                             */
                                            public List<RateRange> getRateRangeList() {
                                                return rateRangeList;
                                            }

                                            /** 
                                             * Set the list of 'RateRange' element items.
                                             * 
                                             * @param list
                                             */
                                            public void setRateRangeList(
                                                    List<RateRange> list) {
                                                rateRangeList = list;
                                            }

                                            /** 
                                             * Get the 'TotalSurcharges' element value.
                                             * 
                                             * @return value
                                             */
                                            public TotalSurcharges getTotalSurcharges() {
                                                return totalSurcharges;
                                            }

                                            /** 
                                             * Set the 'TotalSurcharges' element value.
                                             * 
                                             * @param totalSurcharges
                                             */
                                            public void setTotalSurcharges(
                                                    TotalSurcharges totalSurcharges) {
                                                this.totalSurcharges = totalSurcharges;
                                            }

                                            /** 
                                             * Get the 'TotalTaxes' element value.
                                             * 
                                             * @return value
                                             */
                                            public TotalTaxes getTotalTaxes() {
                                                return totalTaxes;
                                            }

                                            /** 
                                             * Set the 'TotalTaxes' element value.
                                             * 
                                             * @param totalTaxes
                                             */
                                            public void setTotalTaxes(
                                                    TotalTaxes totalTaxes) {
                                                this.totalTaxes = totalTaxes;
                                            }

                                            /** 
                                             * Get the 'Amount' attribute value.
                                             * 
                                             * @return value
                                             */
                                            public String getAmount() {
                                                return amount;
                                            }

                                            /** 
                                             * Set the 'Amount' attribute value.
                                             * 
                                             * @param amount
                                             */
                                            public void setAmount(String amount) {
                                                this.amount = amount;
                                            }
                                            /** 
                                             * Schema fragment(s) for this class:
                                             * <pre>
                                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RateRange" minOccurs="0" maxOccurs="8">
                                             *   &lt;xs:complexType>
                                             *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                             *     &lt;xs:attribute type="xs:string" use="optional" name="EffectiveDate"/>
                                             *     &lt;xs:attribute type="xs:string" use="optional" name="ExpireDate"/>
                                             *     &lt;xs:attribute type="xs:string" use="optional" name="Surcharges"/>
                                             *     &lt;xs:attribute type="xs:string" use="optional" name="Taxes"/>
                                             *   &lt;/xs:complexType>
                                             * &lt;/xs:element>
                                             * </pre>
                                             */
                                            public static class RateRange
                                                implements Serializable
                                            {
                                                private String amount;
                                                private String effectiveDate;
                                                private String expireDate;
                                                private String surcharges;
                                                private String taxes;

                                                /** 
                                                 * Get the 'Amount' attribute value.
                                                 * 
                                                 * @return value
                                                 */
                                                public String getAmount() {
                                                    return amount;
                                                }

                                                /** 
                                                 * Set the 'Amount' attribute value.
                                                 * 
                                                 * @param amount
                                                 */
                                                public void setAmount(
                                                        String amount) {
                                                    this.amount = amount;
                                                }

                                                /** 
                                                 * Get the 'EffectiveDate' attribute value.
                                                 * 
                                                 * @return value
                                                 */
                                                public String getEffectiveDate() {
                                                    return effectiveDate;
                                                }

                                                /** 
                                                 * Set the 'EffectiveDate' attribute value.
                                                 * 
                                                 * @param effectiveDate
                                                 */
                                                public void setEffectiveDate(
                                                        String effectiveDate) {
                                                    this.effectiveDate = effectiveDate;
                                                }

                                                /** 
                                                 * Get the 'ExpireDate' attribute value.
                                                 * 
                                                 * @return value
                                                 */
                                                public String getExpireDate() {
                                                    return expireDate;
                                                }

                                                /** 
                                                 * Set the 'ExpireDate' attribute value.
                                                 * 
                                                 * @param expireDate
                                                 */
                                                public void setExpireDate(
                                                        String expireDate) {
                                                    this.expireDate = expireDate;
                                                }

                                                /** 
                                                 * Get the 'Surcharges' attribute value.
                                                 * 
                                                 * @return value
                                                 */
                                                public String getSurcharges() {
                                                    return surcharges;
                                                }

                                                /** 
                                                 * Set the 'Surcharges' attribute value.
                                                 * 
                                                 * @param surcharges
                                                 */
                                                public void setSurcharges(
                                                        String surcharges) {
                                                    this.surcharges = surcharges;
                                                }

                                                /** 
                                                 * Get the 'Taxes' attribute value.
                                                 * 
                                                 * @return value
                                                 */
                                                public String getTaxes() {
                                                    return taxes;
                                                }

                                                /** 
                                                 * Set the 'Taxes' attribute value.
                                                 * 
                                                 * @param taxes
                                                 */
                                                public void setTaxes(
                                                        String taxes) {
                                                    this.taxes = taxes;
                                                }
                                            }
                                            /** 
                                             * Schema fragment(s) for this class:
                                             * <pre>
                                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalSurcharges" minOccurs="0">
                                             *   &lt;xs:complexType>
                                             *     &lt;xs:sequence>
                                             *       &lt;xs:element name="SurchargeFour" minOccurs="0">
                                             *         &lt;!-- Reference to inner class SurchargeFour -->
                                             *       &lt;/xs:element>
                                             *       &lt;xs:element name="SurchargeOne" minOccurs="0">
                                             *         &lt;!-- Reference to inner class SurchargeOne -->
                                             *       &lt;/xs:element>
                                             *       &lt;xs:element name="SurchargeThree" minOccurs="0">
                                             *         &lt;!-- Reference to inner class SurchargeThree -->
                                             *       &lt;/xs:element>
                                             *       &lt;xs:element name="SurchargeTwo" minOccurs="0">
                                             *         &lt;!-- Reference to inner class SurchargeTwo -->
                                             *       &lt;/xs:element>
                                             *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="4"/>
                                             *     &lt;/xs:sequence>
                                             *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                             *   &lt;/xs:complexType>
                                             * &lt;/xs:element>
                                             * </pre>
                                             */
                                            public static class TotalSurcharges
                                                implements Serializable
                                            {
                                                private SurchargeFour surchargeFour;
                                                private SurchargeOne surchargeOne;
                                                private SurchargeThree surchargeThree;
                                                private SurchargeTwo surchargeTwo;
                                                private List<String> textList = new ArrayList<String>();
                                                private String amount;

                                                /** 
                                                 * Get the 'SurchargeFour' element value.
                                                 * 
                                                 * @return value
                                                 */
                                                public SurchargeFour getSurchargeFour() {
                                                    return surchargeFour;
                                                }

                                                /** 
                                                 * Set the 'SurchargeFour' element value.
                                                 * 
                                                 * @param surchargeFour
                                                 */
                                                public void setSurchargeFour(
                                                        SurchargeFour surchargeFour) {
                                                    this.surchargeFour = surchargeFour;
                                                }

                                                /** 
                                                 * Get the 'SurchargeOne' element value.
                                                 * 
                                                 * @return value
                                                 */
                                                public SurchargeOne getSurchargeOne() {
                                                    return surchargeOne;
                                                }

                                                /** 
                                                 * Set the 'SurchargeOne' element value.
                                                 * 
                                                 * @param surchargeOne
                                                 */
                                                public void setSurchargeOne(
                                                        SurchargeOne surchargeOne) {
                                                    this.surchargeOne = surchargeOne;
                                                }

                                                /** 
                                                 * Get the 'SurchargeThree' element value.
                                                 * 
                                                 * @return value
                                                 */
                                                public SurchargeThree getSurchargeThree() {
                                                    return surchargeThree;
                                                }

                                                /** 
                                                 * Set the 'SurchargeThree' element value.
                                                 * 
                                                 * @param surchargeThree
                                                 */
                                                public void setSurchargeThree(
                                                        SurchargeThree surchargeThree) {
                                                    this.surchargeThree = surchargeThree;
                                                }

                                                /** 
                                                 * Get the 'SurchargeTwo' element value.
                                                 * 
                                                 * @return value
                                                 */
                                                public SurchargeTwo getSurchargeTwo() {
                                                    return surchargeTwo;
                                                }

                                                /** 
                                                 * Set the 'SurchargeTwo' element value.
                                                 * 
                                                 * @param surchargeTwo
                                                 */
                                                public void setSurchargeTwo(
                                                        SurchargeTwo surchargeTwo) {
                                                    this.surchargeTwo = surchargeTwo;
                                                }

                                                /** 
                                                 * Get the list of 'Text' element items.
                                                 * 
                                                 * @return list
                                                 */
                                                public List<String> getTextList() {
                                                    return textList;
                                                }

                                                /** 
                                                 * Set the list of 'Text' element items.
                                                 * 
                                                 * @param list
                                                 */
                                                public void setTextList(
                                                        List<String> list) {
                                                    textList = list;
                                                }

                                                /** 
                                                 * Get the 'Amount' attribute value.
                                                 * 
                                                 * @return value
                                                 */
                                                public String getAmount() {
                                                    return amount;
                                                }

                                                /** 
                                                 * Set the 'Amount' attribute value.
                                                 * 
                                                 * @param amount
                                                 */
                                                public void setAmount(
                                                        String amount) {
                                                    this.amount = amount;
                                                }
                                                /** 
                                                 * Schema fragment(s) for this class:
                                                 * <pre>
                                                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SurchargeFour" minOccurs="0">
                                                 *   &lt;xs:complexType>
                                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                                 *   &lt;/xs:complexType>
                                                 * &lt;/xs:element>
                                                 * </pre>
                                                 */
                                                public static class SurchargeFour
                                                    implements Serializable
                                                {
                                                    private String amount;

                                                    /** 
                                                     * Get the 'Amount' attribute value.
                                                     * 
                                                     * @return value
                                                     */
                                                    public String getAmount() {
                                                        return amount;
                                                    }

                                                    /** 
                                                     * Set the 'Amount' attribute value.
                                                     * 
                                                     * @param amount
                                                     */
                                                    public void setAmount(
                                                            String amount) {
                                                        this.amount = amount;
                                                    }
                                                }
                                                /** 
                                                 * Schema fragment(s) for this class:
                                                 * <pre>
                                                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SurchargeOne" minOccurs="0">
                                                 *   &lt;xs:complexType>
                                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                                 *   &lt;/xs:complexType>
                                                 * &lt;/xs:element>
                                                 * </pre>
                                                 */
                                                public static class SurchargeOne
                                                    implements Serializable
                                                {
                                                    private String amount;

                                                    /** 
                                                     * Get the 'Amount' attribute value.
                                                     * 
                                                     * @return value
                                                     */
                                                    public String getAmount() {
                                                        return amount;
                                                    }

                                                    /** 
                                                     * Set the 'Amount' attribute value.
                                                     * 
                                                     * @param amount
                                                     */
                                                    public void setAmount(
                                                            String amount) {
                                                        this.amount = amount;
                                                    }
                                                }
                                                /** 
                                                 * Schema fragment(s) for this class:
                                                 * <pre>
                                                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SurchargeThree" minOccurs="0">
                                                 *   &lt;xs:complexType>
                                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                                 *   &lt;/xs:complexType>
                                                 * &lt;/xs:element>
                                                 * </pre>
                                                 */
                                                public static class SurchargeThree
                                                    implements Serializable
                                                {
                                                    private String amount;

                                                    /** 
                                                     * Get the 'Amount' attribute value.
                                                     * 
                                                     * @return value
                                                     */
                                                    public String getAmount() {
                                                        return amount;
                                                    }

                                                    /** 
                                                     * Set the 'Amount' attribute value.
                                                     * 
                                                     * @param amount
                                                     */
                                                    public void setAmount(
                                                            String amount) {
                                                        this.amount = amount;
                                                    }
                                                }
                                                /** 
                                                 * Schema fragment(s) for this class:
                                                 * <pre>
                                                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SurchargeTwo" minOccurs="0">
                                                 *   &lt;xs:complexType>
                                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                                 *   &lt;/xs:complexType>
                                                 * &lt;/xs:element>
                                                 * </pre>
                                                 */
                                                public static class SurchargeTwo
                                                    implements Serializable
                                                {
                                                    private String amount;

                                                    /** 
                                                     * Get the 'Amount' attribute value.
                                                     * 
                                                     * @return value
                                                     */
                                                    public String getAmount() {
                                                        return amount;
                                                    }

                                                    /** 
                                                     * Set the 'Amount' attribute value.
                                                     * 
                                                     * @param amount
                                                     */
                                                    public void setAmount(
                                                            String amount) {
                                                        this.amount = amount;
                                                    }
                                                }
                                            }
                                            /** 
                                             * Schema fragment(s) for this class:
                                             * <pre>
                                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalTaxes" minOccurs="0">
                                             *   &lt;xs:complexType>
                                             *     &lt;xs:sequence>
                                             *       &lt;xs:element name="Tax" minOccurs="0">
                                             *         &lt;!-- Reference to inner class Tax -->
                                             *       &lt;/xs:element>
                                             *       &lt;xs:element type="xs:string" name="TaxFieldOne" minOccurs="0"/>
                                             *       &lt;xs:element type="xs:string" name="TaxFieldThree" minOccurs="0"/>
                                             *       &lt;xs:element type="xs:string" name="TaxFieldTwo" minOccurs="0"/>
                                             *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="4"/>
                                             *     &lt;/xs:sequence>
                                             *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                             *   &lt;/xs:complexType>
                                             * &lt;/xs:element>
                                             * </pre>
                                             */
                                            public static class TotalTaxes
                                                implements Serializable
                                            {
                                                private Tax tax;
                                                private String taxFieldOne;
                                                private String taxFieldThree;
                                                private String taxFieldTwo;
                                                private List<String> textList = new ArrayList<String>();
                                                private String amount;

                                                /** 
                                                 * Get the 'Tax' element value.
                                                 * 
                                                 * @return value
                                                 */
                                                public Tax getTax() {
                                                    return tax;
                                                }

                                                /** 
                                                 * Set the 'Tax' element value.
                                                 * 
                                                 * @param tax
                                                 */
                                                public void setTax(Tax tax) {
                                                    this.tax = tax;
                                                }

                                                /** 
                                                 * Get the 'TaxFieldOne' element value.
                                                 * 
                                                 * @return value
                                                 */
                                                public String getTaxFieldOne() {
                                                    return taxFieldOne;
                                                }

                                                /** 
                                                 * Set the 'TaxFieldOne' element value.
                                                 * 
                                                 * @param taxFieldOne
                                                 */
                                                public void setTaxFieldOne(
                                                        String taxFieldOne) {
                                                    this.taxFieldOne = taxFieldOne;
                                                }

                                                /** 
                                                 * Get the 'TaxFieldThree' element value.
                                                 * 
                                                 * @return value
                                                 */
                                                public String getTaxFieldThree() {
                                                    return taxFieldThree;
                                                }

                                                /** 
                                                 * Set the 'TaxFieldThree' element value.
                                                 * 
                                                 * @param taxFieldThree
                                                 */
                                                public void setTaxFieldThree(
                                                        String taxFieldThree) {
                                                    this.taxFieldThree = taxFieldThree;
                                                }

                                                /** 
                                                 * Get the 'TaxFieldTwo' element value.
                                                 * 
                                                 * @return value
                                                 */
                                                public String getTaxFieldTwo() {
                                                    return taxFieldTwo;
                                                }

                                                /** 
                                                 * Set the 'TaxFieldTwo' element value.
                                                 * 
                                                 * @param taxFieldTwo
                                                 */
                                                public void setTaxFieldTwo(
                                                        String taxFieldTwo) {
                                                    this.taxFieldTwo = taxFieldTwo;
                                                }

                                                /** 
                                                 * Get the list of 'Text' element items.
                                                 * 
                                                 * @return list
                                                 */
                                                public List<String> getTextList() {
                                                    return textList;
                                                }

                                                /** 
                                                 * Set the list of 'Text' element items.
                                                 * 
                                                 * @param list
                                                 */
                                                public void setTextList(
                                                        List<String> list) {
                                                    textList = list;
                                                }

                                                /** 
                                                 * Get the 'Amount' attribute value.
                                                 * 
                                                 * @return value
                                                 */
                                                public String getAmount() {
                                                    return amount;
                                                }

                                                /** 
                                                 * Set the 'Amount' attribute value.
                                                 * 
                                                 * @param amount
                                                 */
                                                public void setAmount(
                                                        String amount) {
                                                    this.amount = amount;
                                                }
                                                /** 
                                                 * Schema fragment(s) for this class:
                                                 * <pre>
                                                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" minOccurs="0">
                                                 *   &lt;xs:complexType>
                                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                                 *   &lt;/xs:complexType>
                                                 * &lt;/xs:element>
                                                 * </pre>
                                                 */
                                                public static class Tax
                                                    implements Serializable
                                                {
                                                    private String amount;

                                                    /** 
                                                     * Get the 'Amount' attribute value.
                                                     * 
                                                     * @return value
                                                     */
                                                    public String getAmount() {
                                                        return amount;
                                                    }

                                                    /** 
                                                     * Set the 'Amount' attribute value.
                                                     * 
                                                     * @param amount
                                                     */
                                                    public void setAmount(
                                                            String amount) {
                                                        this.amount = amount;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecialPrefs" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class SpecialPrefs implements
                            Serializable
                        {
                            private String text;

                            /** 
                             * Get the 'Text' element value.
                             * 
                             * @return value
                             */
                            public String getText() {
                                return text;
                            }

                            /** 
                             * Set the 'Text' element value.
                             * 
                             * @param text
                             */
                            public void setText(String text) {
                                this.text = text;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TimeSpan" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Duration"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="End"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Start"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class TimeSpan implements Serializable
                        {
                            private String duration;
                            private String end;
                            private String start;

                            /** 
                             * Get the 'Duration' attribute value.
                             * 
                             * @return value
                             */
                            public String getDuration() {
                                return duration;
                            }

                            /** 
                             * Set the 'Duration' attribute value.
                             * 
                             * @param duration
                             */
                            public void setDuration(String duration) {
                                this.duration = duration;
                            }

                            /** 
                             * Get the 'End' attribute value.
                             * 
                             * @return value
                             */
                            public String getEnd() {
                                return end;
                            }

                            /** 
                             * Set the 'End' attribute value.
                             * 
                             * @param end
                             */
                            public void setEnd(String end) {
                                this.end = end;
                            }

                            /** 
                             * Get the 'Start' attribute value.
                             * 
                             * @return value
                             */
                            public String getStart() {
                                return start;
                            }

                            /** 
                             * Set the 'Start' attribute value.
                             * 
                             * @param start
                             */
                            public void setStart(String start) {
                                this.start = start;
                            }
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Insurance" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="InsuranceData" minOccurs="0">
                     *         &lt;!-- Reference to inner class InsuranceData -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="SegmentNumber"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Status"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Insurance implements Serializable
                    {
                        private InsuranceData insuranceData;
                        private String segmentNumber;
                        private String status;
                        private String type;

                        /** 
                         * Get the 'InsuranceData' element value.
                         * 
                         * @return value
                         */
                        public InsuranceData getInsuranceData() {
                            return insuranceData;
                        }

                        /** 
                         * Set the 'InsuranceData' element value.
                         * 
                         * @param insuranceData
                         */
                        public void setInsuranceData(InsuranceData insuranceData) {
                            this.insuranceData = insuranceData;
                        }

                        /** 
                         * Get the 'SegmentNumber' attribute value.
                         * 
                         * @return value
                         */
                        public String getSegmentNumber() {
                            return segmentNumber;
                        }

                        /** 
                         * Set the 'SegmentNumber' attribute value.
                         * 
                         * @param segmentNumber
                         */
                        public void setSegmentNumber(String segmentNumber) {
                            this.segmentNumber = segmentNumber;
                        }

                        /** 
                         * Get the 'Status' attribute value.
                         * 
                         * @return value
                         */
                        public String getStatus() {
                            return status;
                        }

                        /** 
                         * Set the 'Status' attribute value.
                         * 
                         * @param status
                         */
                        public void setStatus(String status) {
                            this.status = status;
                        }

                        /** 
                         * Get the 'Type' attribute value.
                         * 
                         * @return value
                         */
                        public String getType() {
                            return type;
                        }

                        /** 
                         * Set the 'Type' attribute value.
                         * 
                         * @param type
                         */
                        public void setType(String type) {
                            this.type = type;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InsuranceData" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:string" name="ConfirmationNumber" minOccurs="0"/>
                         *       &lt;xs:element name="Coverage" minOccurs="0">
                         *         &lt;!-- Reference to inner class Coverage -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element name="DestinationLocation" minOccurs="0" maxOccurs="2">
                         *         &lt;!-- Reference to inner class DestinationLocation -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element name="OriginLocation" minOccurs="0">
                         *         &lt;!-- Reference to inner class OriginLocation -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element type="xs:string" name="PaymentForm" minOccurs="0"/>
                         *       &lt;xs:element name="PersonName" minOccurs="0" maxOccurs="unbounded">
                         *         &lt;!-- Reference to inner class PersonName -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                         *       &lt;xs:element name="Vendor" minOccurs="0">
                         *         &lt;!-- Reference to inner class Vendor -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="End"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="NumPolicies"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="PlanType"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="PremiumAmount"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="PurchaseDate"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Start"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="StatusCode"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class InsuranceData implements
                            Serializable
                        {
                            private String confirmationNumber;
                            private Coverage coverage;
                            private List<DestinationLocation> destinationLocationList = new ArrayList<DestinationLocation>();
                            private OriginLocation originLocation;
                            private String paymentForm;
                            private List<PersonName> personNameList = new ArrayList<PersonName>();
                            private String text;
                            private Vendor vendor;
                            private String currencyCode;
                            private String end;
                            private String numPolicies;
                            private String planType;
                            private String premiumAmount;
                            private String purchaseDate;
                            private String start;
                            private String statusCode;

                            /** 
                             * Get the 'ConfirmationNumber' element value.
                             * 
                             * @return value
                             */
                            public String getConfirmationNumber() {
                                return confirmationNumber;
                            }

                            /** 
                             * Set the 'ConfirmationNumber' element value.
                             * 
                             * @param confirmationNumber
                             */
                            public void setConfirmationNumber(
                                    String confirmationNumber) {
                                this.confirmationNumber = confirmationNumber;
                            }

                            /** 
                             * Get the 'Coverage' element value.
                             * 
                             * @return value
                             */
                            public Coverage getCoverage() {
                                return coverage;
                            }

                            /** 
                             * Set the 'Coverage' element value.
                             * 
                             * @param coverage
                             */
                            public void setCoverage(Coverage coverage) {
                                this.coverage = coverage;
                            }

                            /** 
                             * Get the list of 'DestinationLocation' element items.
                             * 
                             * @return list
                             */
                            public List<DestinationLocation> getDestinationLocationList() {
                                return destinationLocationList;
                            }

                            /** 
                             * Set the list of 'DestinationLocation' element items.
                             * 
                             * @param list
                             */
                            public void setDestinationLocationList(
                                    List<DestinationLocation> list) {
                                destinationLocationList = list;
                            }

                            /** 
                             * Get the 'OriginLocation' element value.
                             * 
                             * @return value
                             */
                            public OriginLocation getOriginLocation() {
                                return originLocation;
                            }

                            /** 
                             * Set the 'OriginLocation' element value.
                             * 
                             * @param originLocation
                             */
                            public void setOriginLocation(
                                    OriginLocation originLocation) {
                                this.originLocation = originLocation;
                            }

                            /** 
                             * Get the 'PaymentForm' element value.
                             * 
                             * @return value
                             */
                            public String getPaymentForm() {
                                return paymentForm;
                            }

                            /** 
                             * Set the 'PaymentForm' element value.
                             * 
                             * @param paymentForm
                             */
                            public void setPaymentForm(String paymentForm) {
                                this.paymentForm = paymentForm;
                            }

                            /** 
                             * Get the list of 'PersonName' element items.
                             * 
                             * @return list
                             */
                            public List<PersonName> getPersonNameList() {
                                return personNameList;
                            }

                            /** 
                             * Set the list of 'PersonName' element items.
                             * 
                             * @param list
                             */
                            public void setPersonNameList(List<PersonName> list) {
                                personNameList = list;
                            }

                            /** 
                             * Get the 'Text' element value.
                             * 
                             * @return value
                             */
                            public String getText() {
                                return text;
                            }

                            /** 
                             * Set the 'Text' element value.
                             * 
                             * @param text
                             */
                            public void setText(String text) {
                                this.text = text;
                            }

                            /** 
                             * Get the 'Vendor' element value.
                             * 
                             * @return value
                             */
                            public Vendor getVendor() {
                                return vendor;
                            }

                            /** 
                             * Set the 'Vendor' element value.
                             * 
                             * @param vendor
                             */
                            public void setVendor(Vendor vendor) {
                                this.vendor = vendor;
                            }

                            /** 
                             * Get the 'CurrencyCode' attribute value.
                             * 
                             * @return value
                             */
                            public String getCurrencyCode() {
                                return currencyCode;
                            }

                            /** 
                             * Set the 'CurrencyCode' attribute value.
                             * 
                             * @param currencyCode
                             */
                            public void setCurrencyCode(String currencyCode) {
                                this.currencyCode = currencyCode;
                            }

                            /** 
                             * Get the 'End' attribute value.
                             * 
                             * @return value
                             */
                            public String getEnd() {
                                return end;
                            }

                            /** 
                             * Set the 'End' attribute value.
                             * 
                             * @param end
                             */
                            public void setEnd(String end) {
                                this.end = end;
                            }

                            /** 
                             * Get the 'NumPolicies' attribute value.
                             * 
                             * @return value
                             */
                            public String getNumPolicies() {
                                return numPolicies;
                            }

                            /** 
                             * Set the 'NumPolicies' attribute value.
                             * 
                             * @param numPolicies
                             */
                            public void setNumPolicies(String numPolicies) {
                                this.numPolicies = numPolicies;
                            }

                            /** 
                             * Get the 'PlanType' attribute value.
                             * 
                             * @return value
                             */
                            public String getPlanType() {
                                return planType;
                            }

                            /** 
                             * Set the 'PlanType' attribute value.
                             * 
                             * @param planType
                             */
                            public void setPlanType(String planType) {
                                this.planType = planType;
                            }

                            /** 
                             * Get the 'PremiumAmount' attribute value.
                             * 
                             * @return value
                             */
                            public String getPremiumAmount() {
                                return premiumAmount;
                            }

                            /** 
                             * Set the 'PremiumAmount' attribute value.
                             * 
                             * @param premiumAmount
                             */
                            public void setPremiumAmount(String premiumAmount) {
                                this.premiumAmount = premiumAmount;
                            }

                            /** 
                             * Get the 'PurchaseDate' attribute value.
                             * 
                             * @return value
                             */
                            public String getPurchaseDate() {
                                return purchaseDate;
                            }

                            /** 
                             * Set the 'PurchaseDate' attribute value.
                             * 
                             * @param purchaseDate
                             */
                            public void setPurchaseDate(String purchaseDate) {
                                this.purchaseDate = purchaseDate;
                            }

                            /** 
                             * Get the 'Start' attribute value.
                             * 
                             * @return value
                             */
                            public String getStart() {
                                return start;
                            }

                            /** 
                             * Set the 'Start' attribute value.
                             * 
                             * @param start
                             */
                            public void setStart(String start) {
                                this.start = start;
                            }

                            /** 
                             * Get the 'StatusCode' attribute value.
                             * 
                             * @return value
                             */
                            public String getStatusCode() {
                                return statusCode;
                            }

                            /** 
                             * Set the 'StatusCode' attribute value.
                             * 
                             * @param statusCode
                             */
                            public void setStatusCode(String statusCode) {
                                this.statusCode = statusCode;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Coverage" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element type="xs:string" name="Amount" minOccurs="0" maxOccurs="unbounded"/>
                             *       &lt;xs:element type="xs:string" name="Type" minOccurs="0" maxOccurs="unbounded"/>
                             *     &lt;/xs:sequence>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Coverage implements
                                Serializable
                            {
                                private List<String> amountList = new ArrayList<String>();
                                private List<String> typeList = new ArrayList<String>();

                                /** 
                                 * Get the list of 'Amount' element items.
                                 * 
                                 * @return list
                                 */
                                public List<String> getAmountList() {
                                    return amountList;
                                }

                                /** 
                                 * Set the list of 'Amount' element items.
                                 * 
                                 * @param list
                                 */
                                public void setAmountList(List<String> list) {
                                    amountList = list;
                                }

                                /** 
                                 * Get the list of 'Type' element items.
                                 * 
                                 * @return list
                                 */
                                public List<String> getTypeList() {
                                    return typeList;
                                }

                                /** 
                                 * Set the list of 'Type' element items.
                                 * 
                                 * @param list
                                 */
                                public void setTypeList(List<String> list) {
                                    typeList = list;
                                }
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DestinationLocation" minOccurs="0" maxOccurs="2">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class DestinationLocation implements
                                Serializable
                            {
                                private String locationCode;

                                /** 
                                 * Get the 'LocationCode' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getLocationCode() {
                                    return locationCode;
                                }

                                /** 
                                 * Set the 'LocationCode' attribute value.
                                 * 
                                 * @param locationCode
                                 */
                                public void setLocationCode(String locationCode) {
                                    this.locationCode = locationCode;
                                }
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginLocation" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class OriginLocation implements
                                Serializable
                            {
                                private String locationCode;

                                /** 
                                 * Get the 'LocationCode' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getLocationCode() {
                                    return locationCode;
                                }

                                /** 
                                 * Set the 'LocationCode' attribute value.
                                 * 
                                 * @param locationCode
                                 */
                                public void setLocationCode(String locationCode) {
                                    this.locationCode = locationCode;
                                }
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PersonName" minOccurs="0" maxOccurs="unbounded">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element type="xs:string" name="GivenName" minOccurs="0"/>
                             *       &lt;xs:element type="xs:string" name="Surname" minOccurs="0"/>
                             *     &lt;/xs:sequence>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class PersonName implements
                                Serializable
                            {
                                private String givenName;
                                private String surname;

                                /** 
                                 * Get the 'GivenName' element value.
                                 * 
                                 * @return value
                                 */
                                public String getGivenName() {
                                    return givenName;
                                }

                                /** 
                                 * Set the 'GivenName' element value.
                                 * 
                                 * @param givenName
                                 */
                                public void setGivenName(String givenName) {
                                    this.givenName = givenName;
                                }

                                /** 
                                 * Get the 'Surname' element value.
                                 * 
                                 * @return value
                                 */
                                public String getSurname() {
                                    return surname;
                                }

                                /** 
                                 * Set the 'Surname' element value.
                                 * 
                                 * @param surname
                                 */
                                public void setSurname(String surname) {
                                    this.surname = surname;
                                }
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Vendor" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="CompanyShortName"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Vendor implements Serializable
                            {
                                private String code;
                                private String companyShortName;

                                /** 
                                 * Get the 'Code' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getCode() {
                                    return code;
                                }

                                /** 
                                 * Set the 'Code' attribute value.
                                 * 
                                 * @param code
                                 */
                                public void setCode(String code) {
                                    this.code = code;
                                }

                                /** 
                                 * Get the 'CompanyShortName' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getCompanyShortName() {
                                    return companyShortName;
                                }

                                /** 
                                 * Set the 'CompanyShortName' attribute value.
                                 * 
                                 * @param companyShortName
                                 */
                                public void setCompanyShortName(
                                        String companyShortName) {
                                    this.companyShortName = companyShortName;
                                }
                            }
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Rail" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="ConfirmationNumber" minOccurs="0"/>
                     *       &lt;xs:element name="DestinationLocation" minOccurs="0">
                     *         &lt;!-- Reference to inner class DestinationLocation -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="OriginLocation" minOccurs="0">
                     *         &lt;!-- Reference to inner class OriginLocation -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="ServiceInformation" minOccurs="0">
                     *         &lt;!-- Reference to inner class ServiceInformation -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element type="xs:string" name="SpaceReserved" minOccurs="0"/>
                     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                     *       &lt;xs:element name="Train" minOccurs="0">
                     *         &lt;!-- Reference to inner class Train -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="Vendor" minOccurs="0">
                     *         &lt;!-- Reference to inner class Vendor -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Action"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="LinkCode"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="MergedSegmentInd"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="NumberInParty"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="ResBookDesigCode"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Status"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Rail implements Serializable
                    {
                        private String confirmationNumber;
                        private DestinationLocation destinationLocation;
                        private OriginLocation originLocation;
                        private ServiceInformation serviceInformation;
                        private String spaceReserved;
                        private String text;
                        private Train train;
                        private Vendor vendor;
                        private String action;
                        private String linkCode;
                        private String mergedSegmentInd;
                        private String numberInParty;
                        private String resBookDesigCode;
                        private String status;
                        private String type;

                        /** 
                         * Get the 'ConfirmationNumber' element value.
                         * 
                         * @return value
                         */
                        public String getConfirmationNumber() {
                            return confirmationNumber;
                        }

                        /** 
                         * Set the 'ConfirmationNumber' element value.
                         * 
                         * @param confirmationNumber
                         */
                        public void setConfirmationNumber(
                                String confirmationNumber) {
                            this.confirmationNumber = confirmationNumber;
                        }

                        /** 
                         * Get the 'DestinationLocation' element value.
                         * 
                         * @return value
                         */
                        public DestinationLocation getDestinationLocation() {
                            return destinationLocation;
                        }

                        /** 
                         * Set the 'DestinationLocation' element value.
                         * 
                         * @param destinationLocation
                         */
                        public void setDestinationLocation(
                                DestinationLocation destinationLocation) {
                            this.destinationLocation = destinationLocation;
                        }

                        /** 
                         * Get the 'OriginLocation' element value.
                         * 
                         * @return value
                         */
                        public OriginLocation getOriginLocation() {
                            return originLocation;
                        }

                        /** 
                         * Set the 'OriginLocation' element value.
                         * 
                         * @param originLocation
                         */
                        public void setOriginLocation(
                                OriginLocation originLocation) {
                            this.originLocation = originLocation;
                        }

                        /** 
                         * Get the 'ServiceInformation' element value.
                         * 
                         * @return value
                         */
                        public ServiceInformation getServiceInformation() {
                            return serviceInformation;
                        }

                        /** 
                         * Set the 'ServiceInformation' element value.
                         * 
                         * @param serviceInformation
                         */
                        public void setServiceInformation(
                                ServiceInformation serviceInformation) {
                            this.serviceInformation = serviceInformation;
                        }

                        /** 
                         * Get the 'SpaceReserved' element value.
                         * 
                         * @return value
                         */
                        public String getSpaceReserved() {
                            return spaceReserved;
                        }

                        /** 
                         * Set the 'SpaceReserved' element value.
                         * 
                         * @param spaceReserved
                         */
                        public void setSpaceReserved(String spaceReserved) {
                            this.spaceReserved = spaceReserved;
                        }

                        /** 
                         * Get the 'Text' element value.
                         * 
                         * @return value
                         */
                        public String getText() {
                            return text;
                        }

                        /** 
                         * Set the 'Text' element value.
                         * 
                         * @param text
                         */
                        public void setText(String text) {
                            this.text = text;
                        }

                        /** 
                         * Get the 'Train' element value.
                         * 
                         * @return value
                         */
                        public Train getTrain() {
                            return train;
                        }

                        /** 
                         * Set the 'Train' element value.
                         * 
                         * @param train
                         */
                        public void setTrain(Train train) {
                            this.train = train;
                        }

                        /** 
                         * Get the 'Vendor' element value.
                         * 
                         * @return value
                         */
                        public Vendor getVendor() {
                            return vendor;
                        }

                        /** 
                         * Set the 'Vendor' element value.
                         * 
                         * @param vendor
                         */
                        public void setVendor(Vendor vendor) {
                            this.vendor = vendor;
                        }

                        /** 
                         * Get the 'Action' attribute value.
                         * 
                         * @return value
                         */
                        public String getAction() {
                            return action;
                        }

                        /** 
                         * Set the 'Action' attribute value.
                         * 
                         * @param action
                         */
                        public void setAction(String action) {
                            this.action = action;
                        }

                        /** 
                         * Get the 'LinkCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getLinkCode() {
                            return linkCode;
                        }

                        /** 
                         * Set the 'LinkCode' attribute value.
                         * 
                         * @param linkCode
                         */
                        public void setLinkCode(String linkCode) {
                            this.linkCode = linkCode;
                        }

                        /** 
                         * Get the 'MergedSegmentInd' attribute value.
                         * 
                         * @return value
                         */
                        public String getMergedSegmentInd() {
                            return mergedSegmentInd;
                        }

                        /** 
                         * Set the 'MergedSegmentInd' attribute value.
                         * 
                         * @param mergedSegmentInd
                         */
                        public void setMergedSegmentInd(String mergedSegmentInd) {
                            this.mergedSegmentInd = mergedSegmentInd;
                        }

                        /** 
                         * Get the 'NumberInParty' attribute value.
                         * 
                         * @return value
                         */
                        public String getNumberInParty() {
                            return numberInParty;
                        }

                        /** 
                         * Set the 'NumberInParty' attribute value.
                         * 
                         * @param numberInParty
                         */
                        public void setNumberInParty(String numberInParty) {
                            this.numberInParty = numberInParty;
                        }

                        /** 
                         * Get the 'ResBookDesigCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getResBookDesigCode() {
                            return resBookDesigCode;
                        }

                        /** 
                         * Set the 'ResBookDesigCode' attribute value.
                         * 
                         * @param resBookDesigCode
                         */
                        public void setResBookDesigCode(String resBookDesigCode) {
                            this.resBookDesigCode = resBookDesigCode;
                        }

                        /** 
                         * Get the 'Status' attribute value.
                         * 
                         * @return value
                         */
                        public String getStatus() {
                            return status;
                        }

                        /** 
                         * Set the 'Status' attribute value.
                         * 
                         * @param status
                         */
                        public void setStatus(String status) {
                            this.status = status;
                        }

                        /** 
                         * Get the 'Type' attribute value.
                         * 
                         * @return value
                         */
                        public String getType() {
                            return type;
                        }

                        /** 
                         * Set the 'Type' attribute value.
                         * 
                         * @param type
                         */
                        public void setType(String type) {
                            this.type = type;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DestinationLocation" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:string" name="ArrivalTime" minOccurs="0"/>
                         *       &lt;xs:element type="xs:string" name="LocationName" minOccurs="0"/>
                         *       &lt;xs:element type="xs:string" name="Point" minOccurs="0"/>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class DestinationLocation implements
                            Serializable
                        {
                            private String arrivalTime;
                            private String locationName;
                            private String point;
                            private String locationCode;

                            /** 
                             * Get the 'ArrivalTime' element value.
                             * 
                             * @return value
                             */
                            public String getArrivalTime() {
                                return arrivalTime;
                            }

                            /** 
                             * Set the 'ArrivalTime' element value.
                             * 
                             * @param arrivalTime
                             */
                            public void setArrivalTime(String arrivalTime) {
                                this.arrivalTime = arrivalTime;
                            }

                            /** 
                             * Get the 'LocationName' element value.
                             * 
                             * @return value
                             */
                            public String getLocationName() {
                                return locationName;
                            }

                            /** 
                             * Set the 'LocationName' element value.
                             * 
                             * @param locationName
                             */
                            public void setLocationName(String locationName) {
                                this.locationName = locationName;
                            }

                            /** 
                             * Get the 'Point' element value.
                             * 
                             * @return value
                             */
                            public String getPoint() {
                                return point;
                            }

                            /** 
                             * Set the 'Point' element value.
                             * 
                             * @param point
                             */
                            public void setPoint(String point) {
                                this.point = point;
                            }

                            /** 
                             * Get the 'LocationCode' attribute value.
                             * 
                             * @return value
                             */
                            public String getLocationCode() {
                                return locationCode;
                            }

                            /** 
                             * Set the 'LocationCode' attribute value.
                             * 
                             * @param locationCode
                             */
                            public void setLocationCode(String locationCode) {
                                this.locationCode = locationCode;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginLocation" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:string" name="DepartureDate" minOccurs="0"/>
                         *       &lt;xs:element type="xs:string" name="DepartureTime" minOccurs="0"/>
                         *       &lt;xs:element type="xs:string" name="LocationName" minOccurs="0"/>
                         *       &lt;xs:element type="xs:string" name="Point" minOccurs="0"/>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class OriginLocation implements
                            Serializable
                        {
                            private String departureDate;
                            private String departureTime;
                            private String locationName;
                            private String point;
                            private String locationCode;

                            /** 
                             * Get the 'DepartureDate' element value.
                             * 
                             * @return value
                             */
                            public String getDepartureDate() {
                                return departureDate;
                            }

                            /** 
                             * Set the 'DepartureDate' element value.
                             * 
                             * @param departureDate
                             */
                            public void setDepartureDate(String departureDate) {
                                this.departureDate = departureDate;
                            }

                            /** 
                             * Get the 'DepartureTime' element value.
                             * 
                             * @return value
                             */
                            public String getDepartureTime() {
                                return departureTime;
                            }

                            /** 
                             * Set the 'DepartureTime' element value.
                             * 
                             * @param departureTime
                             */
                            public void setDepartureTime(String departureTime) {
                                this.departureTime = departureTime;
                            }

                            /** 
                             * Get the 'LocationName' element value.
                             * 
                             * @return value
                             */
                            public String getLocationName() {
                                return locationName;
                            }

                            /** 
                             * Set the 'LocationName' element value.
                             * 
                             * @param locationName
                             */
                            public void setLocationName(String locationName) {
                                this.locationName = locationName;
                            }

                            /** 
                             * Get the 'Point' element value.
                             * 
                             * @return value
                             */
                            public String getPoint() {
                                return point;
                            }

                            /** 
                             * Set the 'Point' element value.
                             * 
                             * @param point
                             */
                            public void setPoint(String point) {
                                this.point = point;
                            }

                            /** 
                             * Get the 'LocationCode' attribute value.
                             * 
                             * @return value
                             */
                            public String getLocationCode() {
                                return locationCode;
                            }

                            /** 
                             * Set the 'LocationCode' attribute value.
                             * 
                             * @param locationCode
                             */
                            public void setLocationCode(String locationCode) {
                                this.locationCode = locationCode;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceInformation" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class ServiceInformation implements
                            Serializable
                        {
                            private String text;

                            /** 
                             * Get the 'Text' element value.
                             * 
                             * @return value
                             */
                            public String getText() {
                                return text;
                            }

                            /** 
                             * Set the 'Text' element value.
                             * 
                             * @param text
                             */
                            public void setText(String text) {
                                this.text = text;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Train" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Number"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Train implements Serializable
                        {
                            private String number;

                            /** 
                             * Get the 'Number' attribute value.
                             * 
                             * @return value
                             */
                            public String getNumber() {
                                return number;
                            }

                            /** 
                             * Set the 'Number' attribute value.
                             * 
                             * @param number
                             */
                            public void setNumber(String number) {
                                this.number = number;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Vendor" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Vendor implements Serializable
                        {
                            private String code;

                            /** 
                             * Get the 'Code' attribute value.
                             * 
                             * @return value
                             */
                            public String getCode() {
                                return code;
                            }

                            /** 
                             * Set the 'Code' attribute value.
                             * 
                             * @param code
                             */
                            public void setCode(String code) {
                                this.code = code;
                            }
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Seats" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Seat" minOccurs="0" maxOccurs="unbounded">
                     *         &lt;!-- Reference to inner class Seat -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Seats implements Serializable
                    {
                        private List<Seat> seatList = new ArrayList<Seat>();

                        /** 
                         * Get the list of 'Seat' element items.
                         * 
                         * @return list
                         */
                        public List<Seat> getSeatList() {
                            return seatList;
                        }

                        /** 
                         * Set the list of 'Seat' element items.
                         * 
                         * @param list
                         */
                        public void setSeatList(List<Seat> list) {
                            seatList = list;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Seat" minOccurs="0" maxOccurs="unbounded">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="FlightSegment" minOccurs="0">
                         *         &lt;!-- Reference to inner class FlightSegment -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Action"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="CustomerName"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Number"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Status"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Seat implements Serializable
                        {
                            private FlightSegment flightSegment;
                            private String action;
                            private String customerName;
                            private String number;
                            private String status;
                            private String type;

                            /** 
                             * Get the 'FlightSegment' element value.
                             * 
                             * @return value
                             */
                            public FlightSegment getFlightSegment() {
                                return flightSegment;
                            }

                            /** 
                             * Set the 'FlightSegment' element value.
                             * 
                             * @param flightSegment
                             */
                            public void setFlightSegment(
                                    FlightSegment flightSegment) {
                                this.flightSegment = flightSegment;
                            }

                            /** 
                             * Get the 'Action' attribute value.
                             * 
                             * @return value
                             */
                            public String getAction() {
                                return action;
                            }

                            /** 
                             * Set the 'Action' attribute value.
                             * 
                             * @param action
                             */
                            public void setAction(String action) {
                                this.action = action;
                            }

                            /** 
                             * Get the 'CustomerName' attribute value.
                             * 
                             * @return value
                             */
                            public String getCustomerName() {
                                return customerName;
                            }

                            /** 
                             * Set the 'CustomerName' attribute value.
                             * 
                             * @param customerName
                             */
                            public void setCustomerName(String customerName) {
                                this.customerName = customerName;
                            }

                            /** 
                             * Get the 'Number' attribute value.
                             * 
                             * @return value
                             */
                            public String getNumber() {
                                return number;
                            }

                            /** 
                             * Set the 'Number' attribute value.
                             * 
                             * @param number
                             */
                            public void setNumber(String number) {
                                this.number = number;
                            }

                            /** 
                             * Get the 'Status' attribute value.
                             * 
                             * @return value
                             */
                            public String getStatus() {
                                return status;
                            }

                            /** 
                             * Set the 'Status' attribute value.
                             * 
                             * @param status
                             */
                            public void setStatus(String status) {
                                this.status = status;
                            }

                            /** 
                             * Get the 'Type' attribute value.
                             * 
                             * @return value
                             */
                            public String getType() {
                                return type;
                            }

                            /** 
                             * Set the 'Type' attribute value.
                             * 
                             * @param type
                             */
                            public void setType(String type) {
                                this.type = type;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightSegment" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element name="DestinationLocation" minOccurs="0">
                             *         &lt;!-- Reference to inner class DestinationLocation -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="MarketingAirline" minOccurs="0">
                             *         &lt;!-- Reference to inner class MarketingAirline -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="OriginLocation" minOccurs="0">
                             *         &lt;!-- Reference to inner class OriginLocation -->
                             *       &lt;/xs:element>
                             *     &lt;/xs:sequence>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="DepartureDateTime"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="FlightNumber"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="ResBookDesigCode"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class FlightSegment implements
                                Serializable
                            {
                                private DestinationLocation destinationLocation;
                                private MarketingAirline marketingAirline;
                                private OriginLocation originLocation;
                                private String departureDateTime;
                                private String flightNumber;
                                private String resBookDesigCode;

                                /** 
                                 * Get the 'DestinationLocation' element value.
                                 * 
                                 * @return value
                                 */
                                public DestinationLocation getDestinationLocation() {
                                    return destinationLocation;
                                }

                                /** 
                                 * Set the 'DestinationLocation' element value.
                                 * 
                                 * @param destinationLocation
                                 */
                                public void setDestinationLocation(
                                        DestinationLocation destinationLocation) {
                                    this.destinationLocation = destinationLocation;
                                }

                                /** 
                                 * Get the 'MarketingAirline' element value.
                                 * 
                                 * @return value
                                 */
                                public MarketingAirline getMarketingAirline() {
                                    return marketingAirline;
                                }

                                /** 
                                 * Set the 'MarketingAirline' element value.
                                 * 
                                 * @param marketingAirline
                                 */
                                public void setMarketingAirline(
                                        MarketingAirline marketingAirline) {
                                    this.marketingAirline = marketingAirline;
                                }

                                /** 
                                 * Get the 'OriginLocation' element value.
                                 * 
                                 * @return value
                                 */
                                public OriginLocation getOriginLocation() {
                                    return originLocation;
                                }

                                /** 
                                 * Set the 'OriginLocation' element value.
                                 * 
                                 * @param originLocation
                                 */
                                public void setOriginLocation(
                                        OriginLocation originLocation) {
                                    this.originLocation = originLocation;
                                }

                                /** 
                                 * Get the 'DepartureDateTime' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getDepartureDateTime() {
                                    return departureDateTime;
                                }

                                /** 
                                 * Set the 'DepartureDateTime' attribute value.
                                 * 
                                 * @param departureDateTime
                                 */
                                public void setDepartureDateTime(
                                        String departureDateTime) {
                                    this.departureDateTime = departureDateTime;
                                }

                                /** 
                                 * Get the 'FlightNumber' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getFlightNumber() {
                                    return flightNumber;
                                }

                                /** 
                                 * Set the 'FlightNumber' attribute value.
                                 * 
                                 * @param flightNumber
                                 */
                                public void setFlightNumber(String flightNumber) {
                                    this.flightNumber = flightNumber;
                                }

                                /** 
                                 * Get the 'ResBookDesigCode' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getResBookDesigCode() {
                                    return resBookDesigCode;
                                }

                                /** 
                                 * Set the 'ResBookDesigCode' attribute value.
                                 * 
                                 * @param resBookDesigCode
                                 */
                                public void setResBookDesigCode(
                                        String resBookDesigCode) {
                                    this.resBookDesigCode = resBookDesigCode;
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DestinationLocation" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class DestinationLocation
                                    implements Serializable
                                {
                                    private String locationCode;

                                    /** 
                                     * Get the 'LocationCode' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public String getLocationCode() {
                                        return locationCode;
                                    }

                                    /** 
                                     * Set the 'LocationCode' attribute value.
                                     * 
                                     * @param locationCode
                                     */
                                    public void setLocationCode(
                                            String locationCode) {
                                        this.locationCode = locationCode;
                                    }
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarketingAirline" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="FlightNumber"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class MarketingAirline implements
                                    Serializable
                                {
                                    private String code;
                                    private String flightNumber;

                                    /** 
                                     * Get the 'Code' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public String getCode() {
                                        return code;
                                    }

                                    /** 
                                     * Set the 'Code' attribute value.
                                     * 
                                     * @param code
                                     */
                                    public void setCode(String code) {
                                        this.code = code;
                                    }

                                    /** 
                                     * Get the 'FlightNumber' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public String getFlightNumber() {
                                        return flightNumber;
                                    }

                                    /** 
                                     * Set the 'FlightNumber' attribute value.
                                     * 
                                     * @param flightNumber
                                     */
                                    public void setFlightNumber(
                                            String flightNumber) {
                                        this.flightNumber = flightNumber;
                                    }
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginLocation" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class OriginLocation implements
                                    Serializable
                                {
                                    private String locationCode;

                                    /** 
                                     * Get the 'LocationCode' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public String getLocationCode() {
                                        return locationCode;
                                    }

                                    /** 
                                     * Set the 'LocationCode' attribute value.
                                     * 
                                     * @param locationCode
                                     */
                                    public void setLocationCode(
                                            String locationCode) {
                                        this.locationCode = locationCode;
                                    }
                                }
                            }
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Vehicle" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="ConfirmationNumber" minOccurs="0"/>
                     *       &lt;xs:element name="POS" minOccurs="0">
                     *         &lt;!-- Reference to inner class POS -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="VehRentalCore" minOccurs="0">
                     *         &lt;!-- Reference to inner class VehRentalCore -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="VehVendorAvail" minOccurs="0">
                     *         &lt;!-- Reference to inner class VehVendorAvail -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Action"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="LinkCode"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="MergedSegmentInd"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Status"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Vehicle implements Serializable
                    {
                        private String confirmationNumber;
                        private POS POS1;
                        private VehRentalCore vehRentalCore;
                        private VehVendorAvail vehVendorAvail;
                        private String action;
                        private String linkCode;
                        private String mergedSegmentInd;
                        private String status;
                        private String type;

                        /** 
                         * Get the 'ConfirmationNumber' element value.
                         * 
                         * @return value
                         */
                        public String getConfirmationNumber() {
                            return confirmationNumber;
                        }

                        /** 
                         * Set the 'ConfirmationNumber' element value.
                         * 
                         * @param confirmationNumber
                         */
                        public void setConfirmationNumber(
                                String confirmationNumber) {
                            this.confirmationNumber = confirmationNumber;
                        }

                        /** 
                         * Get the 'POS' element value.
                         * 
                         * @return value
                         */
                        public POS getPOS1() {
                            return POS1;
                        }

                        /** 
                         * Set the 'POS' element value.
                         * 
                         * @param POS1
                         */
                        public void setPOS1(POS POS1) {
                            this.POS1 = POS1;
                        }

                        /** 
                         * Get the 'VehRentalCore' element value.
                         * 
                         * @return value
                         */
                        public VehRentalCore getVehRentalCore() {
                            return vehRentalCore;
                        }

                        /** 
                         * Set the 'VehRentalCore' element value.
                         * 
                         * @param vehRentalCore
                         */
                        public void setVehRentalCore(VehRentalCore vehRentalCore) {
                            this.vehRentalCore = vehRentalCore;
                        }

                        /** 
                         * Get the 'VehVendorAvail' element value.
                         * 
                         * @return value
                         */
                        public VehVendorAvail getVehVendorAvail() {
                            return vehVendorAvail;
                        }

                        /** 
                         * Set the 'VehVendorAvail' element value.
                         * 
                         * @param vehVendorAvail
                         */
                        public void setVehVendorAvail(
                                VehVendorAvail vehVendorAvail) {
                            this.vehVendorAvail = vehVendorAvail;
                        }

                        /** 
                         * Get the 'Action' attribute value.
                         * 
                         * @return value
                         */
                        public String getAction() {
                            return action;
                        }

                        /** 
                         * Set the 'Action' attribute value.
                         * 
                         * @param action
                         */
                        public void setAction(String action) {
                            this.action = action;
                        }

                        /** 
                         * Get the 'LinkCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getLinkCode() {
                            return linkCode;
                        }

                        /** 
                         * Set the 'LinkCode' attribute value.
                         * 
                         * @param linkCode
                         */
                        public void setLinkCode(String linkCode) {
                            this.linkCode = linkCode;
                        }

                        /** 
                         * Get the 'MergedSegmentInd' attribute value.
                         * 
                         * @return value
                         */
                        public String getMergedSegmentInd() {
                            return mergedSegmentInd;
                        }

                        /** 
                         * Set the 'MergedSegmentInd' attribute value.
                         * 
                         * @param mergedSegmentInd
                         */
                        public void setMergedSegmentInd(String mergedSegmentInd) {
                            this.mergedSegmentInd = mergedSegmentInd;
                        }

                        /** 
                         * Get the 'Status' attribute value.
                         * 
                         * @return value
                         */
                        public String getStatus() {
                            return status;
                        }

                        /** 
                         * Set the 'Status' attribute value.
                         * 
                         * @param status
                         */
                        public void setStatus(String status) {
                            this.status = status;
                        }

                        /** 
                         * Get the 'Type' attribute value.
                         * 
                         * @return value
                         */
                        public String getType() {
                            return type;
                        }

                        /** 
                         * Set the 'Type' attribute value.
                         * 
                         * @param type
                         */
                        public void setType(String type) {
                            this.type = type;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="POS" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="Source" minOccurs="0">
                         *         &lt;!-- Reference to inner class Source -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class POS implements Serializable
                        {
                            private Source source;

                            /** 
                             * Get the 'Source' element value.
                             * 
                             * @return value
                             */
                            public Source getSource() {
                                return source;
                            }

                            /** 
                             * Set the 'Source' element value.
                             * 
                             * @param source
                             */
                            public void setSource(Source source) {
                                this.source = source;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Source" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element type="xs:string" name="RequestorID" minOccurs="0"/>
                             *     &lt;/xs:sequence>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Source implements Serializable
                            {
                                private String requestorID;

                                /** 
                                 * Get the 'RequestorID' element value.
                                 * 
                                 * @return value
                                 */
                                public String getRequestorID() {
                                    return requestorID;
                                }

                                /** 
                                 * Set the 'RequestorID' element value.
                                 * 
                                 * @param requestorID
                                 */
                                public void setRequestorID(String requestorID) {
                                    this.requestorID = requestorID;
                                }
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VehRentalCore" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="DropOffLocationDetails" minOccurs="0">
                         *         &lt;!-- Reference to inner class DropOffLocationDetails -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element name="LocationDetails" minOccurs="0">
                         *         &lt;!-- Reference to inner class LocationDetails -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="PickUpDateTime"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Quantity"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="ReturnDateTime"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class VehRentalCore implements
                            Serializable
                        {
                            private DropOffLocationDetails dropOffLocationDetails;
                            private LocationDetails locationDetails;
                            private String pickUpDateTime;
                            private String quantity;
                            private String returnDateTime;

                            /** 
                             * Get the 'DropOffLocationDetails' element value.
                             * 
                             * @return value
                             */
                            public DropOffLocationDetails getDropOffLocationDetails() {
                                return dropOffLocationDetails;
                            }

                            /** 
                             * Set the 'DropOffLocationDetails' element value.
                             * 
                             * @param dropOffLocationDetails
                             */
                            public void setDropOffLocationDetails(
                                    DropOffLocationDetails dropOffLocationDetails) {
                                this.dropOffLocationDetails = dropOffLocationDetails;
                            }

                            /** 
                             * Get the 'LocationDetails' element value.
                             * 
                             * @return value
                             */
                            public LocationDetails getLocationDetails() {
                                return locationDetails;
                            }

                            /** 
                             * Set the 'LocationDetails' element value.
                             * 
                             * @param locationDetails
                             */
                            public void setLocationDetails(
                                    LocationDetails locationDetails) {
                                this.locationDetails = locationDetails;
                            }

                            /** 
                             * Get the 'PickUpDateTime' attribute value.
                             * 
                             * @return value
                             */
                            public String getPickUpDateTime() {
                                return pickUpDateTime;
                            }

                            /** 
                             * Set the 'PickUpDateTime' attribute value.
                             * 
                             * @param pickUpDateTime
                             */
                            public void setPickUpDateTime(String pickUpDateTime) {
                                this.pickUpDateTime = pickUpDateTime;
                            }

                            /** 
                             * Get the 'Quantity' attribute value.
                             * 
                             * @return value
                             */
                            public String getQuantity() {
                                return quantity;
                            }

                            /** 
                             * Set the 'Quantity' attribute value.
                             * 
                             * @param quantity
                             */
                            public void setQuantity(String quantity) {
                                this.quantity = quantity;
                            }

                            /** 
                             * Get the 'ReturnDateTime' attribute value.
                             * 
                             * @return value
                             */
                            public String getReturnDateTime() {
                                return returnDateTime;
                            }

                            /** 
                             * Set the 'ReturnDateTime' attribute value.
                             * 
                             * @param returnDateTime
                             */
                            public void setReturnDateTime(String returnDateTime) {
                                this.returnDateTime = returnDateTime;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DropOffLocationDetails" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class DropOffLocationDetails
                                implements Serializable
                            {
                                private String locationCode;

                                /** 
                                 * Get the 'LocationCode' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getLocationCode() {
                                    return locationCode;
                                }

                                /** 
                                 * Set the 'LocationCode' attribute value.
                                 * 
                                 * @param locationCode
                                 */
                                public void setLocationCode(String locationCode) {
                                    this.locationCode = locationCode;
                                }
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LocationDetails" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element name="ContactNumbers" minOccurs="0">
                             *         &lt;!-- Reference to inner class ContactNumbers -->
                             *       &lt;/xs:element>
                             *     &lt;/xs:sequence>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="ExtendedLocationCode"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="LocationName"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class LocationDetails implements
                                Serializable
                            {
                                private ContactNumbers contactNumbers;
                                private String extendedLocationCode;
                                private String locationCode;
                                private String locationName;

                                /** 
                                 * Get the 'ContactNumbers' element value.
                                 * 
                                 * @return value
                                 */
                                public ContactNumbers getContactNumbers() {
                                    return contactNumbers;
                                }

                                /** 
                                 * Set the 'ContactNumbers' element value.
                                 * 
                                 * @param contactNumbers
                                 */
                                public void setContactNumbers(
                                        ContactNumbers contactNumbers) {
                                    this.contactNumbers = contactNumbers;
                                }

                                /** 
                                 * Get the 'ExtendedLocationCode' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getExtendedLocationCode() {
                                    return extendedLocationCode;
                                }

                                /** 
                                 * Set the 'ExtendedLocationCode' attribute value.
                                 * 
                                 * @param extendedLocationCode
                                 */
                                public void setExtendedLocationCode(
                                        String extendedLocationCode) {
                                    this.extendedLocationCode = extendedLocationCode;
                                }

                                /** 
                                 * Get the 'LocationCode' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getLocationCode() {
                                    return locationCode;
                                }

                                /** 
                                 * Set the 'LocationCode' attribute value.
                                 * 
                                 * @param locationCode
                                 */
                                public void setLocationCode(String locationCode) {
                                    this.locationCode = locationCode;
                                }

                                /** 
                                 * Get the 'LocationName' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getLocationName() {
                                    return locationName;
                                }

                                /** 
                                 * Set the 'LocationName' attribute value.
                                 * 
                                 * @param locationName
                                 */
                                public void setLocationName(String locationName) {
                                    this.locationName = locationName;
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactNumbers" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:sequence>
                                 *       &lt;xs:element name="ContactNumber" minOccurs="0">
                                 *         &lt;!-- Reference to inner class ContactNumber -->
                                 *       &lt;/xs:element>
                                 *     &lt;/xs:sequence>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class ContactNumbers implements
                                    Serializable
                                {
                                    private ContactNumber contactNumber;

                                    /** 
                                     * Get the 'ContactNumber' element value.
                                     * 
                                     * @return value
                                     */
                                    public ContactNumber getContactNumber() {
                                        return contactNumber;
                                    }

                                    /** 
                                     * Set the 'ContactNumber' element value.
                                     * 
                                     * @param contactNumber
                                     */
                                    public void setContactNumber(
                                            ContactNumber contactNumber) {
                                        this.contactNumber = contactNumber;
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactNumber" minOccurs="0">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="Fax"/>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="Phone"/>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class ContactNumber implements
                                        Serializable
                                    {
                                        private String fax;
                                        private String phone;

                                        /** 
                                         * Get the 'Fax' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getFax() {
                                            return fax;
                                        }

                                        /** 
                                         * Set the 'Fax' attribute value.
                                         * 
                                         * @param fax
                                         */
                                        public void setFax(String fax) {
                                            this.fax = fax;
                                        }

                                        /** 
                                         * Get the 'Phone' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getPhone() {
                                            return phone;
                                        }

                                        /** 
                                         * Set the 'Phone' attribute value.
                                         * 
                                         * @param phone
                                         */
                                        public void setPhone(String phone) {
                                            this.phone = phone;
                                        }
                                    }
                                }
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VehVendorAvail" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="VehResCore" minOccurs="0">
                         *         &lt;!-- Reference to inner class VehResCore -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element name="Vendor" minOccurs="0">
                         *         &lt;!-- Reference to inner class Vendor -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class VehVendorAvail implements
                            Serializable
                        {
                            private VehResCore vehResCore;
                            private Vendor vendor;

                            /** 
                             * Get the 'VehResCore' element value.
                             * 
                             * @return value
                             */
                            public VehResCore getVehResCore() {
                                return vehResCore;
                            }

                            /** 
                             * Set the 'VehResCore' element value.
                             * 
                             * @param vehResCore
                             */
                            public void setVehResCore(VehResCore vehResCore) {
                                this.vehResCore = vehResCore;
                            }

                            /** 
                             * Get the 'Vendor' element value.
                             * 
                             * @return value
                             */
                            public Vendor getVendor() {
                                return vendor;
                            }

                            /** 
                             * Set the 'Vendor' element value.
                             * 
                             * @param vendor
                             */
                            public void setVendor(Vendor vendor) {
                                this.vendor = vendor;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VehResCore" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element name="CollectionDeliveryInfo" minOccurs="0">
                             *         &lt;!-- Reference to inner class CollectionDeliveryInfo -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="GuaranteePrepaid" minOccurs="0">
                             *         &lt;!-- Reference to inner class GuaranteePrepaid -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="PricedEquip" minOccurs="0">
                             *         &lt;!-- Reference to inner class PricedEquip -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="RentalRate" minOccurs="0">
                             *         &lt;!-- Reference to inner class RentalRate -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="VehicleCharges" minOccurs="0">
                             *         &lt;!-- Reference to inner class VehicleCharges -->
                             *       &lt;/xs:element>
                             *     &lt;/xs:sequence>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class VehResCore implements
                                Serializable
                            {
                                private CollectionDeliveryInfo collectionDeliveryInfo;
                                private GuaranteePrepaid guaranteePrepaid;
                                private PricedEquip pricedEquip;
                                private RentalRate rentalRate;
                                private VehicleCharges vehicleCharges;

                                /** 
                                 * Get the 'CollectionDeliveryInfo' element value.
                                 * 
                                 * @return value
                                 */
                                public CollectionDeliveryInfo getCollectionDeliveryInfo() {
                                    return collectionDeliveryInfo;
                                }

                                /** 
                                 * Set the 'CollectionDeliveryInfo' element value.
                                 * 
                                 * @param collectionDeliveryInfo
                                 */
                                public void setCollectionDeliveryInfo(
                                        CollectionDeliveryInfo collectionDeliveryInfo) {
                                    this.collectionDeliveryInfo = collectionDeliveryInfo;
                                }

                                /** 
                                 * Get the 'GuaranteePrepaid' element value.
                                 * 
                                 * @return value
                                 */
                                public GuaranteePrepaid getGuaranteePrepaid() {
                                    return guaranteePrepaid;
                                }

                                /** 
                                 * Set the 'GuaranteePrepaid' element value.
                                 * 
                                 * @param guaranteePrepaid
                                 */
                                public void setGuaranteePrepaid(
                                        GuaranteePrepaid guaranteePrepaid) {
                                    this.guaranteePrepaid = guaranteePrepaid;
                                }

                                /** 
                                 * Get the 'PricedEquip' element value.
                                 * 
                                 * @return value
                                 */
                                public PricedEquip getPricedEquip() {
                                    return pricedEquip;
                                }

                                /** 
                                 * Set the 'PricedEquip' element value.
                                 * 
                                 * @param pricedEquip
                                 */
                                public void setPricedEquip(
                                        PricedEquip pricedEquip) {
                                    this.pricedEquip = pricedEquip;
                                }

                                /** 
                                 * Get the 'RentalRate' element value.
                                 * 
                                 * @return value
                                 */
                                public RentalRate getRentalRate() {
                                    return rentalRate;
                                }

                                /** 
                                 * Set the 'RentalRate' element value.
                                 * 
                                 * @param rentalRate
                                 */
                                public void setRentalRate(RentalRate rentalRate) {
                                    this.rentalRate = rentalRate;
                                }

                                /** 
                                 * Get the 'VehicleCharges' element value.
                                 * 
                                 * @return value
                                 */
                                public VehicleCharges getVehicleCharges() {
                                    return vehicleCharges;
                                }

                                /** 
                                 * Set the 'VehicleCharges' element value.
                                 * 
                                 * @param vehicleCharges
                                 */
                                public void setVehicleCharges(
                                        VehicleCharges vehicleCharges) {
                                    this.vehicleCharges = vehicleCharges;
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CollectionDeliveryInfo" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:sequence>
                                 *       &lt;xs:element name="CollectionInfo" minOccurs="0">
                                 *         &lt;!-- Reference to inner class CollectionInfo -->
                                 *       &lt;/xs:element>
                                 *       &lt;xs:element name="DeliveryInfo" minOccurs="0">
                                 *         &lt;!-- Reference to inner class DeliveryInfo -->
                                 *       &lt;/xs:element>
                                 *     &lt;/xs:sequence>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class CollectionDeliveryInfo
                                    implements Serializable
                                {
                                    private CollectionInfo collectionInfo;
                                    private DeliveryInfo deliveryInfo;

                                    /** 
                                     * Get the 'CollectionInfo' element value.
                                     * 
                                     * @return value
                                     */
                                    public CollectionInfo getCollectionInfo() {
                                        return collectionInfo;
                                    }

                                    /** 
                                     * Set the 'CollectionInfo' element value.
                                     * 
                                     * @param collectionInfo
                                     */
                                    public void setCollectionInfo(
                                            CollectionInfo collectionInfo) {
                                        this.collectionInfo = collectionInfo;
                                    }

                                    /** 
                                     * Get the 'DeliveryInfo' element value.
                                     * 
                                     * @return value
                                     */
                                    public DeliveryInfo getDeliveryInfo() {
                                        return deliveryInfo;
                                    }

                                    /** 
                                     * Set the 'DeliveryInfo' element value.
                                     * 
                                     * @param deliveryInfo
                                     */
                                    public void setDeliveryInfo(
                                            DeliveryInfo deliveryInfo) {
                                        this.deliveryInfo = deliveryInfo;
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CollectionInfo" minOccurs="0">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:sequence>
                                     *       &lt;xs:element name="Address" minOccurs="0">
                                     *         &lt;!-- Reference to inner class Address -->
                                     *       &lt;/xs:element>
                                     *       &lt;xs:element name="ContactNumbers" minOccurs="0">
                                     *         &lt;!-- Reference to inner class ContactNumbers -->
                                     *       &lt;/xs:element>
                                     *     &lt;/xs:sequence>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="SiteID"/>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="SiteName"/>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class CollectionInfo
                                        implements Serializable
                                    {
                                        private Address address;
                                        private ContactNumbers contactNumbers;
                                        private String siteID;
                                        private String siteName;

                                        /** 
                                         * Get the 'Address' element value.
                                         * 
                                         * @return value
                                         */
                                        public Address getAddress() {
                                            return address;
                                        }

                                        /** 
                                         * Set the 'Address' element value.
                                         * 
                                         * @param address
                                         */
                                        public void setAddress(Address address) {
                                            this.address = address;
                                        }

                                        /** 
                                         * Get the 'ContactNumbers' element value.
                                         * 
                                         * @return value
                                         */
                                        public ContactNumbers getContactNumbers() {
                                            return contactNumbers;
                                        }

                                        /** 
                                         * Set the 'ContactNumbers' element value.
                                         * 
                                         * @param contactNumbers
                                         */
                                        public void setContactNumbers(
                                                ContactNumbers contactNumbers) {
                                            this.contactNumbers = contactNumbers;
                                        }

                                        /** 
                                         * Get the 'SiteID' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getSiteID() {
                                            return siteID;
                                        }

                                        /** 
                                         * Set the 'SiteID' attribute value.
                                         * 
                                         * @param siteID
                                         */
                                        public void setSiteID(String siteID) {
                                            this.siteID = siteID;
                                        }

                                        /** 
                                         * Get the 'SiteName' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getSiteName() {
                                            return siteName;
                                        }

                                        /** 
                                         * Set the 'SiteName' attribute value.
                                         * 
                                         * @param siteName
                                         */
                                        public void setSiteName(String siteName) {
                                            this.siteName = siteName;
                                        }
                                        /** 
                                         * Schema fragment(s) for this class:
                                         * <pre>
                                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Address" minOccurs="0">
                                         *   &lt;xs:complexType>
                                         *     &lt;xs:sequence>
                                         *       &lt;xs:element type="xs:string" name="AddressLine" minOccurs="0"/>
                                         *       &lt;xs:element type="xs:string" name="CityName" minOccurs="0"/>
                                         *       &lt;xs:element type="xs:string" name="CountryCode" minOccurs="0"/>
                                         *       &lt;xs:element type="xs:string" name="PostalCode" minOccurs="0"/>
                                         *       &lt;xs:element name="StateCountyProv" minOccurs="0">
                                         *         &lt;!-- Reference to inner class StateCountyProv -->
                                         *       &lt;/xs:element>
                                         *       &lt;xs:element type="xs:string" name="StreetNmbr" minOccurs="0"/>
                                         *     &lt;/xs:sequence>
                                         *   &lt;/xs:complexType>
                                         * &lt;/xs:element>
                                         * </pre>
                                         */
                                        public static class Address implements
                                            Serializable
                                        {
                                            private String addressLine;
                                            private String cityName;
                                            private String countryCode;
                                            private String postalCode;
                                            private StateCountyProv stateCountyProv;
                                            private String streetNmbr;

                                            /** 
                                             * Get the 'AddressLine' element value.
                                             * 
                                             * @return value
                                             */
                                            public String getAddressLine() {
                                                return addressLine;
                                            }

                                            /** 
                                             * Set the 'AddressLine' element value.
                                             * 
                                             * @param addressLine
                                             */
                                            public void setAddressLine(
                                                    String addressLine) {
                                                this.addressLine = addressLine;
                                            }

                                            /** 
                                             * Get the 'CityName' element value.
                                             * 
                                             * @return value
                                             */
                                            public String getCityName() {
                                                return cityName;
                                            }

                                            /** 
                                             * Set the 'CityName' element value.
                                             * 
                                             * @param cityName
                                             */
                                            public void setCityName(
                                                    String cityName) {
                                                this.cityName = cityName;
                                            }

                                            /** 
                                             * Get the 'CountryCode' element value.
                                             * 
                                             * @return value
                                             */
                                            public String getCountryCode() {
                                                return countryCode;
                                            }

                                            /** 
                                             * Set the 'CountryCode' element value.
                                             * 
                                             * @param countryCode
                                             */
                                            public void setCountryCode(
                                                    String countryCode) {
                                                this.countryCode = countryCode;
                                            }

                                            /** 
                                             * Get the 'PostalCode' element value.
                                             * 
                                             * @return value
                                             */
                                            public String getPostalCode() {
                                                return postalCode;
                                            }

                                            /** 
                                             * Set the 'PostalCode' element value.
                                             * 
                                             * @param postalCode
                                             */
                                            public void setPostalCode(
                                                    String postalCode) {
                                                this.postalCode = postalCode;
                                            }

                                            /** 
                                             * Get the 'StateCountyProv' element value.
                                             * 
                                             * @return value
                                             */
                                            public StateCountyProv getStateCountyProv() {
                                                return stateCountyProv;
                                            }

                                            /** 
                                             * Set the 'StateCountyProv' element value.
                                             * 
                                             * @param stateCountyProv
                                             */
                                            public void setStateCountyProv(
                                                    StateCountyProv stateCountyProv) {
                                                this.stateCountyProv = stateCountyProv;
                                            }

                                            /** 
                                             * Get the 'StreetNmbr' element value.
                                             * 
                                             * @return value
                                             */
                                            public String getStreetNmbr() {
                                                return streetNmbr;
                                            }

                                            /** 
                                             * Set the 'StreetNmbr' element value.
                                             * 
                                             * @param streetNmbr
                                             */
                                            public void setStreetNmbr(
                                                    String streetNmbr) {
                                                this.streetNmbr = streetNmbr;
                                            }
                                            /** 
                                             * Schema fragment(s) for this class:
                                             * <pre>
                                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StateCountyProv" minOccurs="0">
                                             *   &lt;xs:complexType>
                                             *     &lt;xs:attribute type="xs:string" use="optional" name="StateCode"/>
                                             *   &lt;/xs:complexType>
                                             * &lt;/xs:element>
                                             * </pre>
                                             */
                                            public static class StateCountyProv
                                                implements Serializable
                                            {
                                                private String stateCode;

                                                /** 
                                                 * Get the 'StateCode' attribute value.
                                                 * 
                                                 * @return value
                                                 */
                                                public String getStateCode() {
                                                    return stateCode;
                                                }

                                                /** 
                                                 * Set the 'StateCode' attribute value.
                                                 * 
                                                 * @param stateCode
                                                 */
                                                public void setStateCode(
                                                        String stateCode) {
                                                    this.stateCode = stateCode;
                                                }
                                            }
                                        }
                                        /** 
                                         * Schema fragment(s) for this class:
                                         * <pre>
                                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactNumbers" minOccurs="0">
                                         *   &lt;xs:complexType>
                                         *     &lt;xs:sequence>
                                         *       &lt;xs:element name="ContactNumber" minOccurs="0">
                                         *         &lt;!-- Reference to inner class ContactNumber -->
                                         *       &lt;/xs:element>
                                         *     &lt;/xs:sequence>
                                         *   &lt;/xs:complexType>
                                         * &lt;/xs:element>
                                         * </pre>
                                         */
                                        public static class ContactNumbers
                                            implements Serializable
                                        {
                                            private ContactNumber contactNumber;

                                            /** 
                                             * Get the 'ContactNumber' element value.
                                             * 
                                             * @return value
                                             */
                                            public ContactNumber getContactNumber() {
                                                return contactNumber;
                                            }

                                            /** 
                                             * Set the 'ContactNumber' element value.
                                             * 
                                             * @param contactNumber
                                             */
                                            public void setContactNumber(
                                                    ContactNumber contactNumber) {
                                                this.contactNumber = contactNumber;
                                            }
                                            /** 
                                             * Schema fragment(s) for this class:
                                             * <pre>
                                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactNumber" minOccurs="0">
                                             *   &lt;xs:complexType>
                                             *     &lt;xs:attribute type="xs:string" use="optional" name="Phone"/>
                                             *   &lt;/xs:complexType>
                                             * &lt;/xs:element>
                                             * </pre>
                                             */
                                            public static class ContactNumber
                                                implements Serializable
                                            {
                                                private String phone;

                                                /** 
                                                 * Get the 'Phone' attribute value.
                                                 * 
                                                 * @return value
                                                 */
                                                public String getPhone() {
                                                    return phone;
                                                }

                                                /** 
                                                 * Set the 'Phone' attribute value.
                                                 * 
                                                 * @param phone
                                                 */
                                                public void setPhone(
                                                        String phone) {
                                                    this.phone = phone;
                                                }
                                            }
                                        }
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DeliveryInfo" minOccurs="0">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:sequence>
                                     *       &lt;xs:element name="Address" minOccurs="0">
                                     *         &lt;!-- Reference to inner class Address -->
                                     *       &lt;/xs:element>
                                     *       &lt;xs:element type="xs:string" name="CollectionFee" minOccurs="0"/>
                                     *       &lt;xs:element name="ContactNumbers" minOccurs="0">
                                     *         &lt;!-- Reference to inner class ContactNumbers -->
                                     *       &lt;/xs:element>
                                     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                                     *     &lt;/xs:sequence>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="SiteID"/>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="SiteName"/>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class DeliveryInfo implements
                                        Serializable
                                    {
                                        private Address address;
                                        private String collectionFee;
                                        private ContactNumbers contactNumbers;
                                        private String text;
                                        private String siteID;
                                        private String siteName;

                                        /** 
                                         * Get the 'Address' element value.
                                         * 
                                         * @return value
                                         */
                                        public Address getAddress() {
                                            return address;
                                        }

                                        /** 
                                         * Set the 'Address' element value.
                                         * 
                                         * @param address
                                         */
                                        public void setAddress(Address address) {
                                            this.address = address;
                                        }

                                        /** 
                                         * Get the 'CollectionFee' element value.
                                         * 
                                         * @return value
                                         */
                                        public String getCollectionFee() {
                                            return collectionFee;
                                        }

                                        /** 
                                         * Set the 'CollectionFee' element value.
                                         * 
                                         * @param collectionFee
                                         */
                                        public void setCollectionFee(
                                                String collectionFee) {
                                            this.collectionFee = collectionFee;
                                        }

                                        /** 
                                         * Get the 'ContactNumbers' element value.
                                         * 
                                         * @return value
                                         */
                                        public ContactNumbers getContactNumbers() {
                                            return contactNumbers;
                                        }

                                        /** 
                                         * Set the 'ContactNumbers' element value.
                                         * 
                                         * @param contactNumbers
                                         */
                                        public void setContactNumbers(
                                                ContactNumbers contactNumbers) {
                                            this.contactNumbers = contactNumbers;
                                        }

                                        /** 
                                         * Get the 'Text' element value.
                                         * 
                                         * @return value
                                         */
                                        public String getText() {
                                            return text;
                                        }

                                        /** 
                                         * Set the 'Text' element value.
                                         * 
                                         * @param text
                                         */
                                        public void setText(String text) {
                                            this.text = text;
                                        }

                                        /** 
                                         * Get the 'SiteID' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getSiteID() {
                                            return siteID;
                                        }

                                        /** 
                                         * Set the 'SiteID' attribute value.
                                         * 
                                         * @param siteID
                                         */
                                        public void setSiteID(String siteID) {
                                            this.siteID = siteID;
                                        }

                                        /** 
                                         * Get the 'SiteName' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getSiteName() {
                                            return siteName;
                                        }

                                        /** 
                                         * Set the 'SiteName' attribute value.
                                         * 
                                         * @param siteName
                                         */
                                        public void setSiteName(String siteName) {
                                            this.siteName = siteName;
                                        }
                                        /** 
                                         * Schema fragment(s) for this class:
                                         * <pre>
                                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Address" minOccurs="0">
                                         *   &lt;xs:complexType>
                                         *     &lt;xs:sequence>
                                         *       &lt;xs:element type="xs:string" name="AddressLine" minOccurs="0"/>
                                         *       &lt;xs:element type="xs:string" name="CityName" minOccurs="0"/>
                                         *       &lt;xs:element type="xs:string" name="CountryCode" minOccurs="0"/>
                                         *       &lt;xs:element type="xs:string" name="PostalCode" minOccurs="0"/>
                                         *       &lt;xs:element name="StateCountyProv" minOccurs="0">
                                         *         &lt;!-- Reference to inner class StateCountyProv -->
                                         *       &lt;/xs:element>
                                         *       &lt;xs:element type="xs:string" name="StreetNmbr" minOccurs="0"/>
                                         *     &lt;/xs:sequence>
                                         *   &lt;/xs:complexType>
                                         * &lt;/xs:element>
                                         * </pre>
                                         */
                                        public static class Address implements
                                            Serializable
                                        {
                                            private String addressLine;
                                            private String cityName;
                                            private String countryCode;
                                            private String postalCode;
                                            private StateCountyProv stateCountyProv;
                                            private String streetNmbr;

                                            /** 
                                             * Get the 'AddressLine' element value.
                                             * 
                                             * @return value
                                             */
                                            public String getAddressLine() {
                                                return addressLine;
                                            }

                                            /** 
                                             * Set the 'AddressLine' element value.
                                             * 
                                             * @param addressLine
                                             */
                                            public void setAddressLine(
                                                    String addressLine) {
                                                this.addressLine = addressLine;
                                            }

                                            /** 
                                             * Get the 'CityName' element value.
                                             * 
                                             * @return value
                                             */
                                            public String getCityName() {
                                                return cityName;
                                            }

                                            /** 
                                             * Set the 'CityName' element value.
                                             * 
                                             * @param cityName
                                             */
                                            public void setCityName(
                                                    String cityName) {
                                                this.cityName = cityName;
                                            }

                                            /** 
                                             * Get the 'CountryCode' element value.
                                             * 
                                             * @return value
                                             */
                                            public String getCountryCode() {
                                                return countryCode;
                                            }

                                            /** 
                                             * Set the 'CountryCode' element value.
                                             * 
                                             * @param countryCode
                                             */
                                            public void setCountryCode(
                                                    String countryCode) {
                                                this.countryCode = countryCode;
                                            }

                                            /** 
                                             * Get the 'PostalCode' element value.
                                             * 
                                             * @return value
                                             */
                                            public String getPostalCode() {
                                                return postalCode;
                                            }

                                            /** 
                                             * Set the 'PostalCode' element value.
                                             * 
                                             * @param postalCode
                                             */
                                            public void setPostalCode(
                                                    String postalCode) {
                                                this.postalCode = postalCode;
                                            }

                                            /** 
                                             * Get the 'StateCountyProv' element value.
                                             * 
                                             * @return value
                                             */
                                            public StateCountyProv getStateCountyProv() {
                                                return stateCountyProv;
                                            }

                                            /** 
                                             * Set the 'StateCountyProv' element value.
                                             * 
                                             * @param stateCountyProv
                                             */
                                            public void setStateCountyProv(
                                                    StateCountyProv stateCountyProv) {
                                                this.stateCountyProv = stateCountyProv;
                                            }

                                            /** 
                                             * Get the 'StreetNmbr' element value.
                                             * 
                                             * @return value
                                             */
                                            public String getStreetNmbr() {
                                                return streetNmbr;
                                            }

                                            /** 
                                             * Set the 'StreetNmbr' element value.
                                             * 
                                             * @param streetNmbr
                                             */
                                            public void setStreetNmbr(
                                                    String streetNmbr) {
                                                this.streetNmbr = streetNmbr;
                                            }
                                            /** 
                                             * Schema fragment(s) for this class:
                                             * <pre>
                                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StateCountyProv" minOccurs="0">
                                             *   &lt;xs:complexType>
                                             *     &lt;xs:attribute type="xs:string" use="optional" name="StateCode"/>
                                             *   &lt;/xs:complexType>
                                             * &lt;/xs:element>
                                             * </pre>
                                             */
                                            public static class StateCountyProv
                                                implements Serializable
                                            {
                                                private String stateCode;

                                                /** 
                                                 * Get the 'StateCode' attribute value.
                                                 * 
                                                 * @return value
                                                 */
                                                public String getStateCode() {
                                                    return stateCode;
                                                }

                                                /** 
                                                 * Set the 'StateCode' attribute value.
                                                 * 
                                                 * @param stateCode
                                                 */
                                                public void setStateCode(
                                                        String stateCode) {
                                                    this.stateCode = stateCode;
                                                }
                                            }
                                        }
                                        /** 
                                         * Schema fragment(s) for this class:
                                         * <pre>
                                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactNumbers" minOccurs="0">
                                         *   &lt;xs:complexType>
                                         *     &lt;xs:sequence>
                                         *       &lt;xs:element name="ContactNumber" minOccurs="0">
                                         *         &lt;!-- Reference to inner class ContactNumber -->
                                         *       &lt;/xs:element>
                                         *     &lt;/xs:sequence>
                                         *   &lt;/xs:complexType>
                                         * &lt;/xs:element>
                                         * </pre>
                                         */
                                        public static class ContactNumbers
                                            implements Serializable
                                        {
                                            private ContactNumber contactNumber;

                                            /** 
                                             * Get the 'ContactNumber' element value.
                                             * 
                                             * @return value
                                             */
                                            public ContactNumber getContactNumber() {
                                                return contactNumber;
                                            }

                                            /** 
                                             * Set the 'ContactNumber' element value.
                                             * 
                                             * @param contactNumber
                                             */
                                            public void setContactNumber(
                                                    ContactNumber contactNumber) {
                                                this.contactNumber = contactNumber;
                                            }
                                            /** 
                                             * Schema fragment(s) for this class:
                                             * <pre>
                                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactNumber" minOccurs="0">
                                             *   &lt;xs:complexType>
                                             *     &lt;xs:attribute type="xs:string" use="optional" name="Phone"/>
                                             *   &lt;/xs:complexType>
                                             * &lt;/xs:element>
                                             * </pre>
                                             */
                                            public static class ContactNumber
                                                implements Serializable
                                            {
                                                private String phone;

                                                /** 
                                                 * Get the 'Phone' attribute value.
                                                 * 
                                                 * @return value
                                                 */
                                                public String getPhone() {
                                                    return phone;
                                                }

                                                /** 
                                                 * Set the 'Phone' attribute value.
                                                 * 
                                                 * @param phone
                                                 */
                                                public void setPhone(
                                                        String phone) {
                                                    this.phone = phone;
                                                }
                                            }
                                        }
                                    }
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GuaranteePrepaid" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:sequence>
                                 *       &lt;xs:element name="CancellationRefundAmount" minOccurs="0" maxOccurs="4">
                                 *         &lt;!-- Reference to inner class CancellationRefundAmount -->
                                 *       &lt;/xs:element>
                                 *     &lt;/xs:sequence>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="AmountPercentage"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Ind"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class GuaranteePrepaid implements
                                    Serializable
                                {
                                    private List<CancellationRefundAmount> cancellationRefundAmountList = new ArrayList<CancellationRefundAmount>();
                                    private String amount;
                                    private String amountPercentage;
                                    private String currencyCode;
                                    private String ind;

                                    /** 
                                     * Get the list of 'CancellationRefundAmount' element items.
                                     * 
                                     * @return list
                                     */
                                    public List<CancellationRefundAmount> getCancellationRefundAmountList() {
                                        return cancellationRefundAmountList;
                                    }

                                    /** 
                                     * Set the list of 'CancellationRefundAmount' element items.
                                     * 
                                     * @param list
                                     */
                                    public void setCancellationRefundAmountList(
                                            List<CancellationRefundAmount> list) {
                                        cancellationRefundAmountList = list;
                                    }

                                    /** 
                                     * Get the 'Amount' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public String getAmount() {
                                        return amount;
                                    }

                                    /** 
                                     * Set the 'Amount' attribute value.
                                     * 
                                     * @param amount
                                     */
                                    public void setAmount(String amount) {
                                        this.amount = amount;
                                    }

                                    /** 
                                     * Get the 'AmountPercentage' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public String getAmountPercentage() {
                                        return amountPercentage;
                                    }

                                    /** 
                                     * Set the 'AmountPercentage' attribute value.
                                     * 
                                     * @param amountPercentage
                                     */
                                    public void setAmountPercentage(
                                            String amountPercentage) {
                                        this.amountPercentage = amountPercentage;
                                    }

                                    /** 
                                     * Get the 'CurrencyCode' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public String getCurrencyCode() {
                                        return currencyCode;
                                    }

                                    /** 
                                     * Set the 'CurrencyCode' attribute value.
                                     * 
                                     * @param currencyCode
                                     */
                                    public void setCurrencyCode(
                                            String currencyCode) {
                                        this.currencyCode = currencyCode;
                                    }

                                    /** 
                                     * Get the 'Ind' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public String getInd() {
                                        return ind;
                                    }

                                    /** 
                                     * Set the 'Ind' attribute value.
                                     * 
                                     * @param ind
                                     */
                                    public void setInd(String ind) {
                                        this.ind = ind;
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CancellationRefundAmount" minOccurs="0" maxOccurs="4">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:simpleContent>
                                     *       &lt;xs:extension base="xs:string">
                                     *         &lt;xs:attribute type="xs:string" use="optional" name="NumDays"/>
                                     *       &lt;/xs:extension>
                                     *     &lt;/xs:simpleContent>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class CancellationRefundAmount
                                        implements Serializable
                                    {
                                        private String string;
                                        private String numDays;

                                        /** 
                                         * Get the extension value.
                                         * 
                                         * @return value
                                         */
                                        public String getString() {
                                            return string;
                                        }

                                        /** 
                                         * Set the extension value.
                                         * 
                                         * @param string
                                         */
                                        public void setString(String string) {
                                            this.string = string;
                                        }

                                        /** 
                                         * Get the 'NumDays' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getNumDays() {
                                            return numDays;
                                        }

                                        /** 
                                         * Set the 'NumDays' attribute value.
                                         * 
                                         * @param numDays
                                         */
                                        public void setNumDays(String numDays) {
                                            this.numDays = numDays;
                                        }
                                    }
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricedEquip" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:sequence>
                                 *       &lt;xs:element name="Equipment" minOccurs="0">
                                 *         &lt;!-- Reference to inner class Equipment -->
                                 *       &lt;/xs:element>
                                 *     &lt;/xs:sequence>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class PricedEquip implements
                                    Serializable
                                {
                                    private Equipment equipment;

                                    /** 
                                     * Get the 'Equipment' element value.
                                     * 
                                     * @return value
                                     */
                                    public Equipment getEquipment() {
                                        return equipment;
                                    }

                                    /** 
                                     * Set the 'Equipment' element value.
                                     * 
                                     * @param equipment
                                     */
                                    public void setEquipment(Equipment equipment) {
                                        this.equipment = equipment;
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Equipment" minOccurs="0">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="EquipType"/>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="Quantity"/>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="SpecialEquip"/>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="SpecialEquipConfirmed"/>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="UpgradedVehType"/>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class Equipment implements
                                        Serializable
                                    {
                                        private String equipType;
                                        private String quantity;
                                        private String specialEquip;
                                        private String specialEquipConfirmed;
                                        private String upgradedVehType;

                                        /** 
                                         * Get the 'EquipType' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getEquipType() {
                                            return equipType;
                                        }

                                        /** 
                                         * Set the 'EquipType' attribute value.
                                         * 
                                         * @param equipType
                                         */
                                        public void setEquipType(
                                                String equipType) {
                                            this.equipType = equipType;
                                        }

                                        /** 
                                         * Get the 'Quantity' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getQuantity() {
                                            return quantity;
                                        }

                                        /** 
                                         * Set the 'Quantity' attribute value.
                                         * 
                                         * @param quantity
                                         */
                                        public void setQuantity(String quantity) {
                                            this.quantity = quantity;
                                        }

                                        /** 
                                         * Get the 'SpecialEquip' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getSpecialEquip() {
                                            return specialEquip;
                                        }

                                        /** 
                                         * Set the 'SpecialEquip' attribute value.
                                         * 
                                         * @param specialEquip
                                         */
                                        public void setSpecialEquip(
                                                String specialEquip) {
                                            this.specialEquip = specialEquip;
                                        }

                                        /** 
                                         * Get the 'SpecialEquipConfirmed' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getSpecialEquipConfirmed() {
                                            return specialEquipConfirmed;
                                        }

                                        /** 
                                         * Set the 'SpecialEquipConfirmed' attribute value.
                                         * 
                                         * @param specialEquipConfirmed
                                         */
                                        public void setSpecialEquipConfirmed(
                                                String specialEquipConfirmed) {
                                            this.specialEquipConfirmed = specialEquipConfirmed;
                                        }

                                        /** 
                                         * Get the 'UpgradedVehType' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getUpgradedVehType() {
                                            return upgradedVehType;
                                        }

                                        /** 
                                         * Set the 'UpgradedVehType' attribute value.
                                         * 
                                         * @param upgradedVehType
                                         */
                                        public void setUpgradedVehType(
                                                String upgradedVehType) {
                                            this.upgradedVehType = upgradedVehType;
                                        }
                                    }
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RentalRate" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:sequence>
                                 *       &lt;xs:element name="Billing" minOccurs="0">
                                 *         &lt;!-- Reference to inner class Billing -->
                                 *       &lt;/xs:element>
                                 *       &lt;xs:element name="Client" minOccurs="0">
                                 *         &lt;!-- Reference to inner class Client -->
                                 *       &lt;/xs:element>
                                 *       &lt;xs:element name="Corporate" minOccurs="0">
                                 *         &lt;!-- Reference to inner class Corporate -->
                                 *       &lt;/xs:element>
                                 *       &lt;xs:element name="CustLoyalty" minOccurs="0">
                                 *         &lt;!-- Reference to inner class CustLoyalty -->
                                 *       &lt;/xs:element>
                                 *       &lt;xs:element name="InvoiceRemarks" minOccurs="0">
                                 *         &lt;!-- Reference to inner class InvoiceRemarks -->
                                 *       &lt;/xs:element>
                                 *       &lt;xs:element name="Remarks" minOccurs="0">
                                 *         &lt;!-- Reference to inner class Remarks -->
                                 *       &lt;/xs:element>
                                 *       &lt;xs:element type="xs:string" name="ReserveUnderName" minOccurs="0"/>
                                 *       &lt;xs:element name="ServiceInformation" minOccurs="0">
                                 *         &lt;!-- Reference to inner class ServiceInformation -->
                                 *       &lt;/xs:element>
                                 *       &lt;xs:element name="TourCode" minOccurs="0">
                                 *         &lt;!-- Reference to inner class TourCode -->
                                 *       &lt;/xs:element>
                                 *       &lt;xs:element name="Voucher" minOccurs="0">
                                 *         &lt;!-- Reference to inner class Voucher -->
                                 *       &lt;/xs:element>
                                 *     &lt;/xs:sequence>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Changed"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="GuaranteedQuoted"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="RateCode"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="STM_RatePlan"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class RentalRate implements
                                    Serializable
                                {
                                    private Billing billing;
                                    private Client client;
                                    private Corporate corporate;
                                    private CustLoyalty custLoyalty;
                                    private InvoiceRemarks invoiceRemarks;
                                    private Remarks remarks;
                                    private String reserveUnderName;
                                    private ServiceInformation serviceInformation;
                                    private TourCode tourCode;
                                    private Voucher voucher;
                                    private String changed;
                                    private String guaranteedQuoted;
                                    private String rateCode;
                                    private String STMRatePlan;

                                    /** 
                                     * Get the 'Billing' element value.
                                     * 
                                     * @return value
                                     */
                                    public Billing getBilling() {
                                        return billing;
                                    }

                                    /** 
                                     * Set the 'Billing' element value.
                                     * 
                                     * @param billing
                                     */
                                    public void setBilling(Billing billing) {
                                        this.billing = billing;
                                    }

                                    /** 
                                     * Get the 'Client' element value.
                                     * 
                                     * @return value
                                     */
                                    public Client getClient() {
                                        return client;
                                    }

                                    /** 
                                     * Set the 'Client' element value.
                                     * 
                                     * @param client
                                     */
                                    public void setClient(Client client) {
                                        this.client = client;
                                    }

                                    /** 
                                     * Get the 'Corporate' element value.
                                     * 
                                     * @return value
                                     */
                                    public Corporate getCorporate() {
                                        return corporate;
                                    }

                                    /** 
                                     * Set the 'Corporate' element value.
                                     * 
                                     * @param corporate
                                     */
                                    public void setCorporate(Corporate corporate) {
                                        this.corporate = corporate;
                                    }

                                    /** 
                                     * Get the 'CustLoyalty' element value.
                                     * 
                                     * @return value
                                     */
                                    public CustLoyalty getCustLoyalty() {
                                        return custLoyalty;
                                    }

                                    /** 
                                     * Set the 'CustLoyalty' element value.
                                     * 
                                     * @param custLoyalty
                                     */
                                    public void setCustLoyalty(
                                            CustLoyalty custLoyalty) {
                                        this.custLoyalty = custLoyalty;
                                    }

                                    /** 
                                     * Get the 'InvoiceRemarks' element value.
                                     * 
                                     * @return value
                                     */
                                    public InvoiceRemarks getInvoiceRemarks() {
                                        return invoiceRemarks;
                                    }

                                    /** 
                                     * Set the 'InvoiceRemarks' element value.
                                     * 
                                     * @param invoiceRemarks
                                     */
                                    public void setInvoiceRemarks(
                                            InvoiceRemarks invoiceRemarks) {
                                        this.invoiceRemarks = invoiceRemarks;
                                    }

                                    /** 
                                     * Get the 'Remarks' element value.
                                     * 
                                     * @return value
                                     */
                                    public Remarks getRemarks() {
                                        return remarks;
                                    }

                                    /** 
                                     * Set the 'Remarks' element value.
                                     * 
                                     * @param remarks
                                     */
                                    public void setRemarks(Remarks remarks) {
                                        this.remarks = remarks;
                                    }

                                    /** 
                                     * Get the 'ReserveUnderName' element value.
                                     * 
                                     * @return value
                                     */
                                    public String getReserveUnderName() {
                                        return reserveUnderName;
                                    }

                                    /** 
                                     * Set the 'ReserveUnderName' element value.
                                     * 
                                     * @param reserveUnderName
                                     */
                                    public void setReserveUnderName(
                                            String reserveUnderName) {
                                        this.reserveUnderName = reserveUnderName;
                                    }

                                    /** 
                                     * Get the 'ServiceInformation' element value.
                                     * 
                                     * @return value
                                     */
                                    public ServiceInformation getServiceInformation() {
                                        return serviceInformation;
                                    }

                                    /** 
                                     * Set the 'ServiceInformation' element value.
                                     * 
                                     * @param serviceInformation
                                     */
                                    public void setServiceInformation(
                                            ServiceInformation serviceInformation) {
                                        this.serviceInformation = serviceInformation;
                                    }

                                    /** 
                                     * Get the 'TourCode' element value.
                                     * 
                                     * @return value
                                     */
                                    public TourCode getTourCode() {
                                        return tourCode;
                                    }

                                    /** 
                                     * Set the 'TourCode' element value.
                                     * 
                                     * @param tourCode
                                     */
                                    public void setTourCode(TourCode tourCode) {
                                        this.tourCode = tourCode;
                                    }

                                    /** 
                                     * Get the 'Voucher' element value.
                                     * 
                                     * @return value
                                     */
                                    public Voucher getVoucher() {
                                        return voucher;
                                    }

                                    /** 
                                     * Set the 'Voucher' element value.
                                     * 
                                     * @param voucher
                                     */
                                    public void setVoucher(Voucher voucher) {
                                        this.voucher = voucher;
                                    }

                                    /** 
                                     * Get the 'Changed' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public String getChanged() {
                                        return changed;
                                    }

                                    /** 
                                     * Set the 'Changed' attribute value.
                                     * 
                                     * @param changed
                                     */
                                    public void setChanged(String changed) {
                                        this.changed = changed;
                                    }

                                    /** 
                                     * Get the 'GuaranteedQuoted' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public String getGuaranteedQuoted() {
                                        return guaranteedQuoted;
                                    }

                                    /** 
                                     * Set the 'GuaranteedQuoted' attribute value.
                                     * 
                                     * @param guaranteedQuoted
                                     */
                                    public void setGuaranteedQuoted(
                                            String guaranteedQuoted) {
                                        this.guaranteedQuoted = guaranteedQuoted;
                                    }

                                    /** 
                                     * Get the 'RateCode' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public String getRateCode() {
                                        return rateCode;
                                    }

                                    /** 
                                     * Set the 'RateCode' attribute value.
                                     * 
                                     * @param rateCode
                                     */
                                    public void setRateCode(String rateCode) {
                                        this.rateCode = rateCode;
                                    }

                                    /** 
                                     * Get the 'STM_RatePlan' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public String getSTMRatePlan() {
                                        return STMRatePlan;
                                    }

                                    /** 
                                     * Set the 'STM_RatePlan' attribute value.
                                     * 
                                     * @param STMRatePlan
                                     */
                                    public void setSTMRatePlan(
                                            String STMRatePlan) {
                                        this.STMRatePlan = STMRatePlan;
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Billing" minOccurs="0">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="Number"/>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="Reference"/>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class Billing implements
                                        Serializable
                                    {
                                        private String number;
                                        private String reference;

                                        /** 
                                         * Get the 'Number' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getNumber() {
                                            return number;
                                        }

                                        /** 
                                         * Set the 'Number' attribute value.
                                         * 
                                         * @param number
                                         */
                                        public void setNumber(String number) {
                                            this.number = number;
                                        }

                                        /** 
                                         * Get the 'Reference' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getReference() {
                                            return reference;
                                        }

                                        /** 
                                         * Set the 'Reference' attribute value.
                                         * 
                                         * @param reference
                                         */
                                        public void setReference(
                                                String reference) {
                                            this.reference = reference;
                                        }
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Client" minOccurs="0">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:sequence>
                                     *       &lt;xs:element type="xs:string" name="ID" minOccurs="0"/>
                                     *     &lt;/xs:sequence>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class Client implements
                                        Serializable
                                    {
                                        private String ID;

                                        /** 
                                         * Get the 'ID' element value.
                                         * 
                                         * @return value
                                         */
                                        public String getID() {
                                            return ID;
                                        }

                                        /** 
                                         * Set the 'ID' element value.
                                         * 
                                         * @param ID
                                         */
                                        public void setID(String ID) {
                                            this.ID = ID;
                                        }
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Corporate" minOccurs="0">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:sequence>
                                     *       &lt;xs:element type="xs:string" name="ID" minOccurs="0"/>
                                     *     &lt;/xs:sequence>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class Corporate implements
                                        Serializable
                                    {
                                        private String ID;

                                        /** 
                                         * Get the 'ID' element value.
                                         * 
                                         * @return value
                                         */
                                        public String getID() {
                                            return ID;
                                        }

                                        /** 
                                         * Set the 'ID' element value.
                                         * 
                                         * @param ID
                                         */
                                        public void setID(String ID) {
                                            this.ID = ID;
                                        }
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CustLoyalty" minOccurs="0">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="MembershipID"/>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class CustLoyalty implements
                                        Serializable
                                    {
                                        private String membershipID;

                                        /** 
                                         * Get the 'MembershipID' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getMembershipID() {
                                            return membershipID;
                                        }

                                        /** 
                                         * Set the 'MembershipID' attribute value.
                                         * 
                                         * @param membershipID
                                         */
                                        public void setMembershipID(
                                                String membershipID) {
                                            this.membershipID = membershipID;
                                        }
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InvoiceRemarks" minOccurs="0">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:sequence>
                                     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                                     *     &lt;/xs:sequence>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class InvoiceRemarks
                                        implements Serializable
                                    {
                                        private String text;

                                        /** 
                                         * Get the 'Text' element value.
                                         * 
                                         * @return value
                                         */
                                        public String getText() {
                                            return text;
                                        }

                                        /** 
                                         * Set the 'Text' element value.
                                         * 
                                         * @param text
                                         */
                                        public void setText(String text) {
                                            this.text = text;
                                        }
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Remarks" minOccurs="0">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:sequence>
                                     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                                     *     &lt;/xs:sequence>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class Remarks implements
                                        Serializable
                                    {
                                        private String text;

                                        /** 
                                         * Get the 'Text' element value.
                                         * 
                                         * @return value
                                         */
                                        public String getText() {
                                            return text;
                                        }

                                        /** 
                                         * Set the 'Text' element value.
                                         * 
                                         * @param text
                                         */
                                        public void setText(String text) {
                                            this.text = text;
                                        }
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceInformation" minOccurs="0">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:sequence>
                                     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                                     *     &lt;/xs:sequence>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class ServiceInformation
                                        implements Serializable
                                    {
                                        private String text;

                                        /** 
                                         * Get the 'Text' element value.
                                         * 
                                         * @return value
                                         */
                                        public String getText() {
                                            return text;
                                        }

                                        /** 
                                         * Set the 'Text' element value.
                                         * 
                                         * @param text
                                         */
                                        public void setText(String text) {
                                            this.text = text;
                                        }
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TourCode" minOccurs="0">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:sequence>
                                     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                                     *     &lt;/xs:sequence>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class TourCode implements
                                        Serializable
                                    {
                                        private String text;

                                        /** 
                                         * Get the 'Text' element value.
                                         * 
                                         * @return value
                                         */
                                        public String getText() {
                                            return text;
                                        }

                                        /** 
                                         * Set the 'Text' element value.
                                         * 
                                         * @param text
                                         */
                                        public void setText(String text) {
                                            this.text = text;
                                        }
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Voucher" minOccurs="0">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="BillingNumber"/>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="Format"/>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="ID"/>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class Voucher implements
                                        Serializable
                                    {
                                        private String billingNumber;
                                        private String format;
                                        private String ID;
                                        private String type;

                                        /** 
                                         * Get the 'BillingNumber' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getBillingNumber() {
                                            return billingNumber;
                                        }

                                        /** 
                                         * Set the 'BillingNumber' attribute value.
                                         * 
                                         * @param billingNumber
                                         */
                                        public void setBillingNumber(
                                                String billingNumber) {
                                            this.billingNumber = billingNumber;
                                        }

                                        /** 
                                         * Get the 'Format' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getFormat() {
                                            return format;
                                        }

                                        /** 
                                         * Set the 'Format' attribute value.
                                         * 
                                         * @param format
                                         */
                                        public void setFormat(String format) {
                                            this.format = format;
                                        }

                                        /** 
                                         * Get the 'ID' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getID() {
                                            return ID;
                                        }

                                        /** 
                                         * Set the 'ID' attribute value.
                                         * 
                                         * @param ID
                                         */
                                        public void setID(String ID) {
                                            this.ID = ID;
                                        }

                                        /** 
                                         * Get the 'Type' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getType() {
                                            return type;
                                        }

                                        /** 
                                         * Set the 'Type' attribute value.
                                         * 
                                         * @param type
                                         */
                                        public void setType(String type) {
                                            this.type = type;
                                        }
                                    }
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VehicleCharges" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:sequence>
                                 *       &lt;xs:element name="VehicleCharge" minOccurs="0">
                                 *         &lt;!-- Reference to inner class VehicleCharge -->
                                 *       &lt;/xs:element>
                                 *     &lt;/xs:sequence>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class VehicleCharges implements
                                    Serializable
                                {
                                    private VehicleCharge vehicleCharge;

                                    /** 
                                     * Get the 'VehicleCharge' element value.
                                     * 
                                     * @return value
                                     */
                                    public VehicleCharge getVehicleCharge() {
                                        return vehicleCharge;
                                    }

                                    /** 
                                     * Set the 'VehicleCharge' element value.
                                     * 
                                     * @param vehicleCharge
                                     */
                                    public void setVehicleCharge(
                                            VehicleCharge vehicleCharge) {
                                        this.vehicleCharge = vehicleCharge;
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VehicleCharge" minOccurs="0">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:sequence>
                                     *       &lt;xs:element type="xs:string" name="Amount" minOccurs="0"/>
                                     *       &lt;xs:element name="ChargeDetails" minOccurs="0">
                                     *         &lt;!-- Reference to inner class ChargeDetails -->
                                     *       &lt;/xs:element>
                                     *       &lt;xs:element name="Commission" minOccurs="0">
                                     *         &lt;!-- Reference to inner class Commission -->
                                     *       &lt;/xs:element>
                                     *       &lt;xs:element name="Mileage" minOccurs="0">
                                     *         &lt;!-- Reference to inner class Mileage -->
                                     *       &lt;/xs:element>
                                     *     &lt;/xs:sequence>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="DropOffCharge"/>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="GuaranteeInd"/>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class VehicleCharge implements
                                        Serializable
                                    {
                                        private String amount;
                                        private ChargeDetails chargeDetails;
                                        private Commission commission;
                                        private Mileage mileage;
                                        private String amount1;
                                        private String dropOffCharge;
                                        private String guaranteeInd;

                                        /** 
                                         * Get the 'Amount' element value.
                                         * 
                                         * @return value
                                         */
                                        public String getAmount() {
                                            return amount;
                                        }

                                        /** 
                                         * Set the 'Amount' element value.
                                         * 
                                         * @param amount
                                         */
                                        public void setAmount(String amount) {
                                            this.amount = amount;
                                        }

                                        /** 
                                         * Get the 'ChargeDetails' element value.
                                         * 
                                         * @return value
                                         */
                                        public ChargeDetails getChargeDetails() {
                                            return chargeDetails;
                                        }

                                        /** 
                                         * Set the 'ChargeDetails' element value.
                                         * 
                                         * @param chargeDetails
                                         */
                                        public void setChargeDetails(
                                                ChargeDetails chargeDetails) {
                                            this.chargeDetails = chargeDetails;
                                        }

                                        /** 
                                         * Get the 'Commission' element value.
                                         * 
                                         * @return value
                                         */
                                        public Commission getCommission() {
                                            return commission;
                                        }

                                        /** 
                                         * Set the 'Commission' element value.
                                         * 
                                         * @param commission
                                         */
                                        public void setCommission(
                                                Commission commission) {
                                            this.commission = commission;
                                        }

                                        /** 
                                         * Get the 'Mileage' element value.
                                         * 
                                         * @return value
                                         */
                                        public Mileage getMileage() {
                                            return mileage;
                                        }

                                        /** 
                                         * Set the 'Mileage' element value.
                                         * 
                                         * @param mileage
                                         */
                                        public void setMileage(Mileage mileage) {
                                            this.mileage = mileage;
                                        }

                                        /** 
                                         * Get the 'Amount' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getAmount1() {
                                            return amount1;
                                        }

                                        /** 
                                         * Set the 'Amount' attribute value.
                                         * 
                                         * @param amount1
                                         */
                                        public void setAmount1(String amount1) {
                                            this.amount1 = amount1;
                                        }

                                        /** 
                                         * Get the 'DropOffCharge' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getDropOffCharge() {
                                            return dropOffCharge;
                                        }

                                        /** 
                                         * Set the 'DropOffCharge' attribute value.
                                         * 
                                         * @param dropOffCharge
                                         */
                                        public void setDropOffCharge(
                                                String dropOffCharge) {
                                            this.dropOffCharge = dropOffCharge;
                                        }

                                        /** 
                                         * Get the 'GuaranteeInd' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getGuaranteeInd() {
                                            return guaranteeInd;
                                        }

                                        /** 
                                         * Set the 'GuaranteeInd' attribute value.
                                         * 
                                         * @param guaranteeInd
                                         */
                                        public void setGuaranteeInd(
                                                String guaranteeInd) {
                                            this.guaranteeInd = guaranteeInd;
                                        }
                                        /** 
                                         * Schema fragment(s) for this class:
                                         * <pre>
                                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ChargeDetails" minOccurs="0">
                                         *   &lt;xs:complexType>
                                         *     &lt;xs:sequence>
                                         *       &lt;xs:element name="ApproximateTotalCharge" minOccurs="0" maxOccurs="20">
                                         *         &lt;!-- Reference to inner class ApproximateTotalCharge -->
                                         *       &lt;/xs:element>
                                         *     &lt;/xs:sequence>
                                         *   &lt;/xs:complexType>
                                         * &lt;/xs:element>
                                         * </pre>
                                         */
                                        public static class ChargeDetails
                                            implements Serializable
                                        {
                                            private List<ApproximateTotalCharge> approximateTotalChargeList = new ArrayList<ApproximateTotalCharge>();

                                            /** 
                                             * Get the list of 'ApproximateTotalCharge' element items.
                                             * 
                                             * @return list
                                             */
                                            public List<ApproximateTotalCharge> getApproximateTotalChargeList() {
                                                return approximateTotalChargeList;
                                            }

                                            /** 
                                             * Set the list of 'ApproximateTotalCharge' element items.
                                             * 
                                             * @param list
                                             */
                                            public void setApproximateTotalChargeList(
                                                    List<ApproximateTotalCharge> list) {
                                                approximateTotalChargeList = list;
                                            }
                                            /** 
                                             * Schema fragment(s) for this class:
                                             * <pre>
                                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ApproximateTotalCharge" minOccurs="0" maxOccurs="20">
                                             *   &lt;xs:complexType>
                                             *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                             *     &lt;xs:attribute type="xs:string" use="optional" name="MileageAllowance"/>
                                             *     &lt;xs:attribute type="xs:string" use="optional" name="NumDays"/>
                                             *     &lt;xs:attribute type="xs:string" use="optional" name="NumHours"/>
                                             *     &lt;xs:attribute type="xs:string" use="optional" name="RateType"/>
                                             *     &lt;xs:attribute type="xs:string" use="optional" name="TotalMandatoryCharges"/>
                                             *   &lt;/xs:complexType>
                                             * &lt;/xs:element>
                                             * </pre>
                                             */
                                            public static class ApproximateTotalCharge
                                                implements Serializable
                                            {
                                                private String amount;
                                                private String mileageAllowance;
                                                private String numDays;
                                                private String numHours;
                                                private String rateType;
                                                private String totalMandatoryCharges;

                                                /** 
                                                 * Get the 'Amount' attribute value.
                                                 * 
                                                 * @return value
                                                 */
                                                public String getAmount() {
                                                    return amount;
                                                }

                                                /** 
                                                 * Set the 'Amount' attribute value.
                                                 * 
                                                 * @param amount
                                                 */
                                                public void setAmount(
                                                        String amount) {
                                                    this.amount = amount;
                                                }

                                                /** 
                                                 * Get the 'MileageAllowance' attribute value.
                                                 * 
                                                 * @return value
                                                 */
                                                public String getMileageAllowance() {
                                                    return mileageAllowance;
                                                }

                                                /** 
                                                 * Set the 'MileageAllowance' attribute value.
                                                 * 
                                                 * @param mileageAllowance
                                                 */
                                                public void setMileageAllowance(
                                                        String mileageAllowance) {
                                                    this.mileageAllowance = mileageAllowance;
                                                }

                                                /** 
                                                 * Get the 'NumDays' attribute value.
                                                 * 
                                                 * @return value
                                                 */
                                                public String getNumDays() {
                                                    return numDays;
                                                }

                                                /** 
                                                 * Set the 'NumDays' attribute value.
                                                 * 
                                                 * @param numDays
                                                 */
                                                public void setNumDays(
                                                        String numDays) {
                                                    this.numDays = numDays;
                                                }

                                                /** 
                                                 * Get the 'NumHours' attribute value.
                                                 * 
                                                 * @return value
                                                 */
                                                public String getNumHours() {
                                                    return numHours;
                                                }

                                                /** 
                                                 * Set the 'NumHours' attribute value.
                                                 * 
                                                 * @param numHours
                                                 */
                                                public void setNumHours(
                                                        String numHours) {
                                                    this.numHours = numHours;
                                                }

                                                /** 
                                                 * Get the 'RateType' attribute value.
                                                 * 
                                                 * @return value
                                                 */
                                                public String getRateType() {
                                                    return rateType;
                                                }

                                                /** 
                                                 * Set the 'RateType' attribute value.
                                                 * 
                                                 * @param rateType
                                                 */
                                                public void setRateType(
                                                        String rateType) {
                                                    this.rateType = rateType;
                                                }

                                                /** 
                                                 * Get the 'TotalMandatoryCharges' attribute value.
                                                 * 
                                                 * @return value
                                                 */
                                                public String getTotalMandatoryCharges() {
                                                    return totalMandatoryCharges;
                                                }

                                                /** 
                                                 * Set the 'TotalMandatoryCharges' attribute value.
                                                 * 
                                                 * @param totalMandatoryCharges
                                                 */
                                                public void setTotalMandatoryCharges(
                                                        String totalMandatoryCharges) {
                                                    this.totalMandatoryCharges = totalMandatoryCharges;
                                                }
                                            }
                                        }
                                        /** 
                                         * Schema fragment(s) for this class:
                                         * <pre>
                                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Commission" minOccurs="0">
                                         *   &lt;xs:complexType>
                                         *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                         *     &lt;xs:attribute type="xs:string" use="optional" name="Percent"/>
                                         *   &lt;/xs:complexType>
                                         * &lt;/xs:element>
                                         * </pre>
                                         */
                                        public static class Commission
                                            implements Serializable
                                        {
                                            private String amount;
                                            private String percent;

                                            /** 
                                             * Get the 'Amount' attribute value.
                                             * 
                                             * @return value
                                             */
                                            public String getAmount() {
                                                return amount;
                                            }

                                            /** 
                                             * Set the 'Amount' attribute value.
                                             * 
                                             * @param amount
                                             */
                                            public void setAmount(String amount) {
                                                this.amount = amount;
                                            }

                                            /** 
                                             * Get the 'Percent' attribute value.
                                             * 
                                             * @return value
                                             */
                                            public String getPercent() {
                                                return percent;
                                            }

                                            /** 
                                             * Set the 'Percent' attribute value.
                                             * 
                                             * @param percent
                                             */
                                            public void setPercent(
                                                    String percent) {
                                                this.percent = percent;
                                            }
                                        }
                                        /** 
                                         * Schema fragment(s) for this class:
                                         * <pre>
                                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Mileage" minOccurs="0">
                                         *   &lt;xs:complexType>
                                         *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                                         *     &lt;xs:attribute type="xs:string" use="optional" name="ExtraMileageCharge"/>
                                         *     &lt;xs:attribute type="xs:string" use="optional" name="UnitOfMeasure"/>
                                         *   &lt;/xs:complexType>
                                         * &lt;/xs:element>
                                         * </pre>
                                         */
                                        public static class Mileage implements
                                            Serializable
                                        {
                                            private String currencyCode;
                                            private String extraMileageCharge;
                                            private String unitOfMeasure;

                                            /** 
                                             * Get the 'CurrencyCode' attribute value.
                                             * 
                                             * @return value
                                             */
                                            public String getCurrencyCode() {
                                                return currencyCode;
                                            }

                                            /** 
                                             * Set the 'CurrencyCode' attribute value.
                                             * 
                                             * @param currencyCode
                                             */
                                            public void setCurrencyCode(
                                                    String currencyCode) {
                                                this.currencyCode = currencyCode;
                                            }

                                            /** 
                                             * Get the 'ExtraMileageCharge' attribute value.
                                             * 
                                             * @return value
                                             */
                                            public String getExtraMileageCharge() {
                                                return extraMileageCharge;
                                            }

                                            /** 
                                             * Set the 'ExtraMileageCharge' attribute value.
                                             * 
                                             * @param extraMileageCharge
                                             */
                                            public void setExtraMileageCharge(
                                                    String extraMileageCharge) {
                                                this.extraMileageCharge = extraMileageCharge;
                                            }

                                            /** 
                                             * Get the 'UnitOfMeasure' attribute value.
                                             * 
                                             * @return value
                                             */
                                            public String getUnitOfMeasure() {
                                                return unitOfMeasure;
                                            }

                                            /** 
                                             * Set the 'UnitOfMeasure' attribute value.
                                             * 
                                             * @param unitOfMeasure
                                             */
                                            public void setUnitOfMeasure(
                                                    String unitOfMeasure) {
                                                this.unitOfMeasure = unitOfMeasure;
                                            }
                                        }
                                    }
                                }
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Vendor" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="CompanyShortName"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Vendor implements Serializable
                            {
                                private String code;
                                private String companyShortName;

                                /** 
                                 * Get the 'Code' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getCode() {
                                    return code;
                                }

                                /** 
                                 * Set the 'Code' attribute value.
                                 * 
                                 * @param code
                                 */
                                public void setCode(String code) {
                                    this.code = code;
                                }

                                /** 
                                 * Get the 'CompanyShortName' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getCompanyShortName() {
                                    return companyShortName;
                                }

                                /** 
                                 * Set the 'CompanyShortName' attribute value.
                                 * 
                                 * @param companyShortName
                                 */
                                public void setCompanyShortName(
                                        String companyShortName) {
                                    this.companyShortName = companyShortName;
                                }
                            }
                        }
                    }
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ItineraryRef" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Source" minOccurs="0">
         *         &lt;!-- Reference to inner class Source -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="optional" name="AccountingCity"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="AccountingCode"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="OfficeStationCode"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="TicketingCarrier"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ItineraryRef implements Serializable
        {
            private Source source;
            private String accountingCity;
            private String accountingCode;
            private String officeStationCode;
            private String ticketingCarrier;

            /** 
             * Get the 'Source' element value.
             * 
             * @return value
             */
            public Source getSource() {
                return source;
            }

            /** 
             * Set the 'Source' element value.
             * 
             * @param source
             */
            public void setSource(Source source) {
                this.source = source;
            }

            /** 
             * Get the 'AccountingCity' attribute value.
             * 
             * @return value
             */
            public String getAccountingCity() {
                return accountingCity;
            }

            /** 
             * Set the 'AccountingCity' attribute value.
             * 
             * @param accountingCity
             */
            public void setAccountingCity(String accountingCity) {
                this.accountingCity = accountingCity;
            }

            /** 
             * Get the 'AccountingCode' attribute value.
             * 
             * @return value
             */
            public String getAccountingCode() {
                return accountingCode;
            }

            /** 
             * Set the 'AccountingCode' attribute value.
             * 
             * @param accountingCode
             */
            public void setAccountingCode(String accountingCode) {
                this.accountingCode = accountingCode;
            }

            /** 
             * Get the 'OfficeStationCode' attribute value.
             * 
             * @return value
             */
            public String getOfficeStationCode() {
                return officeStationCode;
            }

            /** 
             * Set the 'OfficeStationCode' attribute value.
             * 
             * @param officeStationCode
             */
            public void setOfficeStationCode(String officeStationCode) {
                this.officeStationCode = officeStationCode;
            }

            /** 
             * Get the 'TicketingCarrier' attribute value.
             * 
             * @return value
             */
            public String getTicketingCarrier() {
                return ticketingCarrier;
            }

            /** 
             * Set the 'TicketingCarrier' attribute value.
             * 
             * @param ticketingCarrier
             */
            public void setTicketingCarrier(String ticketingCarrier) {
                this.ticketingCarrier = ticketingCarrier;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Source" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="AAA_PseudoCityCode"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="CreateDateTime"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="CreationAgent"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="CreationAgentDutyCode"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="CreationAgentFunctionCode"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="PseudoCityCode"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="ReceivedFrom"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Source implements Serializable
            {
                private String AAAPseudoCityCode;
                private String createDateTime;
                private String creationAgent;
                private String creationAgentDutyCode;
                private String creationAgentFunctionCode;
                private String pseudoCityCode;
                private String receivedFrom;

                /** 
                 * Get the 'AAA_PseudoCityCode' attribute value.
                 * 
                 * @return value
                 */
                public String getAAAPseudoCityCode() {
                    return AAAPseudoCityCode;
                }

                /** 
                 * Set the 'AAA_PseudoCityCode' attribute value.
                 * 
                 * @param AAAPseudoCityCode
                 */
                public void setAAAPseudoCityCode(String AAAPseudoCityCode) {
                    this.AAAPseudoCityCode = AAAPseudoCityCode;
                }

                /** 
                 * Get the 'CreateDateTime' attribute value.
                 * 
                 * @return value
                 */
                public String getCreateDateTime() {
                    return createDateTime;
                }

                /** 
                 * Set the 'CreateDateTime' attribute value.
                 * 
                 * @param createDateTime
                 */
                public void setCreateDateTime(String createDateTime) {
                    this.createDateTime = createDateTime;
                }

                /** 
                 * Get the 'CreationAgent' attribute value.
                 * 
                 * @return value
                 */
                public String getCreationAgent() {
                    return creationAgent;
                }

                /** 
                 * Set the 'CreationAgent' attribute value.
                 * 
                 * @param creationAgent
                 */
                public void setCreationAgent(String creationAgent) {
                    this.creationAgent = creationAgent;
                }

                /** 
                 * Get the 'CreationAgentDutyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getCreationAgentDutyCode() {
                    return creationAgentDutyCode;
                }

                /** 
                 * Set the 'CreationAgentDutyCode' attribute value.
                 * 
                 * @param creationAgentDutyCode
                 */
                public void setCreationAgentDutyCode(
                        String creationAgentDutyCode) {
                    this.creationAgentDutyCode = creationAgentDutyCode;
                }

                /** 
                 * Get the 'CreationAgentFunctionCode' attribute value.
                 * 
                 * @return value
                 */
                public String getCreationAgentFunctionCode() {
                    return creationAgentFunctionCode;
                }

                /** 
                 * Set the 'CreationAgentFunctionCode' attribute value.
                 * 
                 * @param creationAgentFunctionCode
                 */
                public void setCreationAgentFunctionCode(
                        String creationAgentFunctionCode) {
                    this.creationAgentFunctionCode = creationAgentFunctionCode;
                }

                /** 
                 * Get the 'PseudoCityCode' attribute value.
                 * 
                 * @return value
                 */
                public String getPseudoCityCode() {
                    return pseudoCityCode;
                }

                /** 
                 * Set the 'PseudoCityCode' attribute value.
                 * 
                 * @param pseudoCityCode
                 */
                public void setPseudoCityCode(String pseudoCityCode) {
                    this.pseudoCityCode = pseudoCityCode;
                }

                /** 
                 * Get the 'ReceivedFrom' attribute value.
                 * 
                 * @return value
                 */
                public String getReceivedFrom() {
                    return receivedFrom;
                }

                /** 
                 * Set the 'ReceivedFrom' attribute value.
                 * 
                 * @param receivedFrom
                 */
                public void setReceivedFrom(String receivedFrom) {
                    this.receivedFrom = receivedFrom;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InvoiceInfo" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="InvoiceNumber" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class InvoiceInfo implements Serializable
        {
            private String invoiceNumber;

            /** 
             * Get the 'InvoiceNumber' element value.
             * 
             * @return value
             */
            public String getInvoiceNumber() {
                return invoiceNumber;
            }

            /** 
             * Set the 'InvoiceNumber' element value.
             * 
             * @param invoiceNumber
             */
            public void setInvoiceNumber(String invoiceNumber) {
                this.invoiceNumber = invoiceNumber;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RemarkInfo" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Remark" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Remark -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class RemarkInfo implements Serializable
        {
            private List<Remark> remarkList = new ArrayList<Remark>();

            /** 
             * Get the list of 'Remark' element items.
             * 
             * @return list
             */
            public List<Remark> getRemarkList() {
                return remarkList;
            }

            /** 
             * Set the list of 'Remark' element items.
             * 
             * @param list
             */
            public void setRemarkList(List<Remark> list) {
                remarkList = list;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Remark" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Action"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Remark implements Serializable
            {
                private String text;
                private String action;

                /** 
                 * Get the 'Text' element value.
                 * 
                 * @return value
                 */
                public String getText() {
                    return text;
                }

                /** 
                 * Set the 'Text' element value.
                 * 
                 * @param text
                 */
                public void setText(String text) {
                    this.text = text;
                }

                /** 
                 * Get the 'Action' attribute value.
                 * 
                 * @return value
                 */
                public String getAction() {
                    return action;
                }

                /** 
                 * Set the 'Action' attribute value.
                 * 
                 * @param action
                 */
                public void setAction(String action) {
                    this.action = action;
                }
            }
        }
    }
}
