
package com.sabre.webservices.triprecord;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Provides address
 information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/triprecord" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AddressType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="AddressLine" minOccurs="0" maxOccurs="4"/>
 *     &lt;xs:element type="xs:string" name="CityName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PostalCd" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="StateCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CountryCode" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="LocationTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="AddressUsageTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Attention"/>
 *   &lt;xs:attributeGroup ref="ns:UpdateAttributes"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AddressType implements Serializable
{
    private List<String> addressLineList = new ArrayList<String>();
    private String cityName;
    private String postalCd;
    private String stateCode;
    private String countryCode;
    private String locationTypeCode;
    private String addressUsageTypeCode;
    private String attention;
    private UpdateAttributes updateAttributes;

    /** 
     * Get the list of 'AddressLine' element items. When the address is
    					unformatted (FormattedInd="false") these lines will
    					contain free
    					form address details. When the address is formatted and street
    					number and street name must be sent
    					independently, the street
    					number will be sent using StreetNmbr, and the street name will be
    					sent in the first
    					AddressLine occurrence.
     * 
     * @return list
     */
    public List<String> getAddressLineList() {
        return addressLineList;
    }

    /** 
     * Set the list of 'AddressLine' element items. When the address is
    					unformatted (FormattedInd="false") these lines will
    					contain free
    					form address details. When the address is formatted and street
    					number and street name must be sent
    					independently, the street
    					number will be sent using StreetNmbr, and the street name will be
    					sent in the first
    					AddressLine occurrence.
     * 
     * @param list
     */
    public void setAddressLineList(List<String> list) {
        addressLineList = list;
    }

    /** 
     * Get the 'CityName' element value. City (e.g.,
    					Dublin),
    					town, or postal station (i.e., a postal service
    					territory,
    					often
    					used in a military address).
     * 
     * @return value
     */
    public String getCityName() {
        return cityName;
    }

    /** 
     * Set the 'CityName' element value. City (e.g.,
    					Dublin),
    					town, or postal station (i.e., a postal service
    					territory,
    					often
    					used in a military address).
     * 
     * @param cityName
     */
    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    /** 
     * Get the 'PostalCd' element value. Post Office Code
    					number.
     * 
     * @return value
     */
    public String getPostalCd() {
        return postalCd;
    }

    /** 
     * Set the 'PostalCd' element value. Post Office Code
    					number.
     * 
     * @param postalCd
     */
    public void setPostalCd(String postalCd) {
        this.postalCd = postalCd;
    }

    /** 
     * Get the 'StateCode' element value. State or Province
    					Code
    					based on Postal Information(e.g., TX for Texas).
    				
     * 
     * @return value
     */
    public String getStateCode() {
        return stateCode;
    }

    /** 
     * Set the 'StateCode' element value. State or Province
    					Code
    					based on Postal Information(e.g., TX for Texas).
    				
     * 
     * @param stateCode
     */
    public void setStateCode(String stateCode) {
        this.stateCode = stateCode;
    }

    /** 
     * Get the 'CountryCode' element value. Country name as
    					a Code
    					(e.g., US or USA for United States of America).
    				
     * 
     * @return value
     */
    public String getCountryCode() {
        return countryCode;
    }

    /** 
     * Set the 'CountryCode' element value. Country name as
    					a Code
    					(e.g., US or USA for United States of America).
    				
     * 
     * @param countryCode
     */
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    /** 
     * Get the 'LocationTypeCode' attribute value. Defines the
    				Location of
    				the address (e.g. home, business, other). Refer to
    				Code
    				List
    			
     * 
     * @return value
     */
    public String getLocationTypeCode() {
        return locationTypeCode;
    }

    /** 
     * Set the 'LocationTypeCode' attribute value. Defines the
    				Location of
    				the address (e.g. home, business, other). Refer to
    				Code
    				List
    			
     * 
     * @param locationTypeCode
     */
    public void setLocationTypeCode(String locationTypeCode) {
        this.locationTypeCode = locationTypeCode;
    }

    /** 
     * Get the 'AddressUsageTypeCode' attribute value. Describes the
    				use of the
    				address (e.g. mailing, delivery, billing, etc.).
    				Refer
    				to
    				OTA Code
    				List Address Use Type (AUT).
     * 
     * @return value
     */
    public String getAddressUsageTypeCode() {
        return addressUsageTypeCode;
    }

    /** 
     * Set the 'AddressUsageTypeCode' attribute value. Describes the
    				use of the
    				address (e.g. mailing, delivery, billing, etc.).
    				Refer
    				to
    				OTA Code
    				List Address Use Type (AUT).
     * 
     * @param addressUsageTypeCode
     */
    public void setAddressUsageTypeCode(String addressUsageTypeCode) {
        this.addressUsageTypeCode = addressUsageTypeCode;
    }

    /** 
     * Get the 'Attention' attribute value. Address Attention
    			
     * 
     * @return value
     */
    public String getAttention() {
        return attention;
    }

    /** 
     * Set the 'Attention' attribute value. Address Attention
    			
     * 
     * @param attention
     */
    public void setAttention(String attention) {
        this.attention = attention;
    }

    /** 
     * Get the 'UpdateAttributes' attributeGroup value.
     * 
     * @return value
     */
    public UpdateAttributes getUpdateAttributes() {
        return updateAttributes;
    }

    /** 
     * Set the 'UpdateAttributes' attributeGroup value.
     * 
     * @param updateAttributes
     */
    public void setUpdateAttributes(UpdateAttributes updateAttributes) {
        this.updateAttributes = updateAttributes;
    }
}
