
package com.sabre.webservices.triprecord;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/triprecord" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CarbonEmissions">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="Segments">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element name="Segment" maxOccurs="unbounded">
 *               &lt;!-- Reference to inner class Segment -->
 *             &lt;/xs:element>
 *           &lt;/xs:sequence>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *       &lt;xs:element type="ns:CO2Value" name="CO2TotalValue"/>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class CarbonEmissions implements Serializable
{
    private List<Segment> segmentList = new ArrayList<Segment>();
    private CO2Value CO2TotalValue;

    /** 
     * Get the list of 'Segment' element items.
     * 
     * @return list
     */
    public List<Segment> getSegmentList() {
        return segmentList;
    }

    /** 
     * Set the list of 'Segment' element items.
     * 
     * @param list
     */
    public void setSegmentList(List<Segment> list) {
        segmentList = list;
    }

    /** 
     * Get the 'CO2TotalValue' element value.
     * 
     * @return value
     */
    public CO2Value getCO2TotalValue() {
        return CO2TotalValue;
    }

    /** 
     * Set the 'CO2TotalValue' element value.
     * 
     * @param CO2TotalValue
     */
    public void setCO2TotalValue(CO2Value CO2TotalValue) {
        this.CO2TotalValue = CO2TotalValue;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/triprecord" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Segment" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:choice>
     *         &lt;xs:element name="Flight" minOccurs="0">
     *           &lt;!-- Reference to inner class Flight -->
     *         &lt;/xs:element>
     *         &lt;xs:element name="Hotel" minOccurs="0">
     *           &lt;!-- Reference to inner class Hotel -->
     *         &lt;/xs:element>
     *         &lt;xs:element name="Car" minOccurs="0">
     *           &lt;!-- Reference to inner class Car -->
     *         &lt;/xs:element>
     *       &lt;/xs:choice>
     *       &lt;xs:element type="ns:CO2Value" name="CO2Value"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:short" use="optional" name="Sequence"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Segment implements Serializable
    {
        private int choiceSelect = -1;
        private static final int FLIGHT_CHOICE = 0;
        private static final int HOTEL_CHOICE = 1;
        private static final int CAR_CHOICE = 2;
        private Flight flight;
        private Hotel hotel;
        private Car car;
        private CO2Value CO2Value;
        private Short sequence;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if Flight is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifFlight() {
            return choiceSelect == FLIGHT_CHOICE;
        }

        /** 
         * Get the 'Flight' element value.
         * 
         * @return value
         */
        public Flight getFlight() {
            return flight;
        }

        /** 
         * Set the 'Flight' element value.
         * 
         * @param flight
         */
        public void setFlight(Flight flight) {
            setChoiceSelect(FLIGHT_CHOICE);
            this.flight = flight;
        }

        /** 
         * Check if Hotel is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifHotel() {
            return choiceSelect == HOTEL_CHOICE;
        }

        /** 
         * Get the 'Hotel' element value.
         * 
         * @return value
         */
        public Hotel getHotel() {
            return hotel;
        }

        /** 
         * Set the 'Hotel' element value.
         * 
         * @param hotel
         */
        public void setHotel(Hotel hotel) {
            setChoiceSelect(HOTEL_CHOICE);
            this.hotel = hotel;
        }

        /** 
         * Check if Car is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifCar() {
            return choiceSelect == CAR_CHOICE;
        }

        /** 
         * Get the 'Car' element value.
         * 
         * @return value
         */
        public Car getCar() {
            return car;
        }

        /** 
         * Set the 'Car' element value.
         * 
         * @param car
         */
        public void setCar(Car car) {
            setChoiceSelect(CAR_CHOICE);
            this.car = car;
        }

        /** 
         * Get the 'CO2Value' element value.
         * 
         * @return value
         */
        public CO2Value getCO2Value() {
            return CO2Value;
        }

        /** 
         * Set the 'CO2Value' element value.
         * 
         * @param CO2Value
         */
        public void setCO2Value(CO2Value CO2Value) {
            this.CO2Value = CO2Value;
        }

        /** 
         * Get the 'Sequence' attribute value.
         * 
         * @return value
         */
        public Short getSequence() {
            return sequence;
        }

        /** 
         * Set the 'Sequence' attribute value.
         * 
         * @param sequence
         */
        public void setSequence(Short sequence) {
            this.sequence = sequence;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/triprecord" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Flight" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="DepartureAirport"/>
         *       &lt;xs:element type="xs:string" name="ArrivalAirport"/>
         *       &lt;xs:element type="xs:string" name="AirlineCode"/>
         *       &lt;xs:element type="xs:string" name="EquipmentType" minOccurs="0"/>
         *       &lt;xs:element type="xs:short" name="EquipmentId" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="ClassOfService" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="NumberInParty" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Flight implements Serializable
        {
            private String departureAirport;
            private String arrivalAirport;
            private String airlineCode;
            private String equipmentType;
            private Short equipmentId;
            private String classOfService;
            private String numberInParty;

            /** 
             * Get the 'DepartureAirport' element value.
             * 
             * @return value
             */
            public String getDepartureAirport() {
                return departureAirport;
            }

            /** 
             * Set the 'DepartureAirport' element value.
             * 
             * @param departureAirport
             */
            public void setDepartureAirport(String departureAirport) {
                this.departureAirport = departureAirport;
            }

            /** 
             * Get the 'ArrivalAirport' element value.
             * 
             * @return value
             */
            public String getArrivalAirport() {
                return arrivalAirport;
            }

            /** 
             * Set the 'ArrivalAirport' element value.
             * 
             * @param arrivalAirport
             */
            public void setArrivalAirport(String arrivalAirport) {
                this.arrivalAirport = arrivalAirport;
            }

            /** 
             * Get the 'AirlineCode' element value.
             * 
             * @return value
             */
            public String getAirlineCode() {
                return airlineCode;
            }

            /** 
             * Set the 'AirlineCode' element value.
             * 
             * @param airlineCode
             */
            public void setAirlineCode(String airlineCode) {
                this.airlineCode = airlineCode;
            }

            /** 
             * Get the 'EquipmentType' element value.
             * 
             * @return value
             */
            public String getEquipmentType() {
                return equipmentType;
            }

            /** 
             * Set the 'EquipmentType' element value.
             * 
             * @param equipmentType
             */
            public void setEquipmentType(String equipmentType) {
                this.equipmentType = equipmentType;
            }

            /** 
             * Get the 'EquipmentId' element value.
             * 
             * @return value
             */
            public Short getEquipmentId() {
                return equipmentId;
            }

            /** 
             * Set the 'EquipmentId' element value.
             * 
             * @param equipmentId
             */
            public void setEquipmentId(Short equipmentId) {
                this.equipmentId = equipmentId;
            }

            /** 
             * Get the 'ClassOfService' element value.
             * 
             * @return value
             */
            public String getClassOfService() {
                return classOfService;
            }

            /** 
             * Set the 'ClassOfService' element value.
             * 
             * @param classOfService
             */
            public void setClassOfService(String classOfService) {
                this.classOfService = classOfService;
            }

            /** 
             * Get the 'NumberInParty' element value.
             * 
             * @return value
             */
            public String getNumberInParty() {
                return numberInParty;
            }

            /** 
             * Set the 'NumberInParty' element value.
             * 
             * @param numberInParty
             */
            public void setNumberInParty(String numberInParty) {
                this.numberInParty = numberInParty;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/triprecord" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Hotel" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="NumberOfDays"/>
         *       &lt;xs:element type="xs:string" name="CountryCode" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="NumberInParty" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Hotel implements Serializable
        {
            private String numberOfDays;
            private String countryCode;
            private String numberInParty;

            /** 
             * Get the 'NumberOfDays' element value.
             * 
             * @return value
             */
            public String getNumberOfDays() {
                return numberOfDays;
            }

            /** 
             * Set the 'NumberOfDays' element value.
             * 
             * @param numberOfDays
             */
            public void setNumberOfDays(String numberOfDays) {
                this.numberOfDays = numberOfDays;
            }

            /** 
             * Get the 'CountryCode' element value.
             * 
             * @return value
             */
            public String getCountryCode() {
                return countryCode;
            }

            /** 
             * Set the 'CountryCode' element value.
             * 
             * @param countryCode
             */
            public void setCountryCode(String countryCode) {
                this.countryCode = countryCode;
            }

            /** 
             * Get the 'NumberInParty' element value.
             * 
             * @return value
             */
            public String getNumberInParty() {
                return numberInParty;
            }

            /** 
             * Set the 'NumberInParty' element value.
             * 
             * @param numberInParty
             */
            public void setNumberInParty(String numberInParty) {
                this.numberInParty = numberInParty;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/triprecord" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Car" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="NumberOfDays"/>
         *       &lt;xs:element type="xs:string" name="NumberInParty" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="NumberOfUnitsBooked" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="CarClassificationCode" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="CarTypeCode" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="CarTransmissionTypeCode" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="CarAirConditioningCode" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="CountryCode" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="MapRegion" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Car implements Serializable
        {
            private String numberOfDays;
            private String numberInParty;
            private String numberOfUnitsBooked;
            private String carClassificationCode;
            private String carTypeCode;
            private String carTransmissionTypeCode;
            private String carAirConditioningCode;
            private String countryCode;
            private String mapRegion;

            /** 
             * Get the 'NumberOfDays' element value.
             * 
             * @return value
             */
            public String getNumberOfDays() {
                return numberOfDays;
            }

            /** 
             * Set the 'NumberOfDays' element value.
             * 
             * @param numberOfDays
             */
            public void setNumberOfDays(String numberOfDays) {
                this.numberOfDays = numberOfDays;
            }

            /** 
             * Get the 'NumberInParty' element value.
             * 
             * @return value
             */
            public String getNumberInParty() {
                return numberInParty;
            }

            /** 
             * Set the 'NumberInParty' element value.
             * 
             * @param numberInParty
             */
            public void setNumberInParty(String numberInParty) {
                this.numberInParty = numberInParty;
            }

            /** 
             * Get the 'NumberOfUnitsBooked' element value.
             * 
             * @return value
             */
            public String getNumberOfUnitsBooked() {
                return numberOfUnitsBooked;
            }

            /** 
             * Set the 'NumberOfUnitsBooked' element value.
             * 
             * @param numberOfUnitsBooked
             */
            public void setNumberOfUnitsBooked(String numberOfUnitsBooked) {
                this.numberOfUnitsBooked = numberOfUnitsBooked;
            }

            /** 
             * Get the 'CarClassificationCode' element value.
             * 
             * @return value
             */
            public String getCarClassificationCode() {
                return carClassificationCode;
            }

            /** 
             * Set the 'CarClassificationCode' element value.
             * 
             * @param carClassificationCode
             */
            public void setCarClassificationCode(String carClassificationCode) {
                this.carClassificationCode = carClassificationCode;
            }

            /** 
             * Get the 'CarTypeCode' element value.
             * 
             * @return value
             */
            public String getCarTypeCode() {
                return carTypeCode;
            }

            /** 
             * Set the 'CarTypeCode' element value.
             * 
             * @param carTypeCode
             */
            public void setCarTypeCode(String carTypeCode) {
                this.carTypeCode = carTypeCode;
            }

            /** 
             * Get the 'CarTransmissionTypeCode' element value.
             * 
             * @return value
             */
            public String getCarTransmissionTypeCode() {
                return carTransmissionTypeCode;
            }

            /** 
             * Set the 'CarTransmissionTypeCode' element value.
             * 
             * @param carTransmissionTypeCode
             */
            public void setCarTransmissionTypeCode(
                    String carTransmissionTypeCode) {
                this.carTransmissionTypeCode = carTransmissionTypeCode;
            }

            /** 
             * Get the 'CarAirConditioningCode' element value.
             * 
             * @return value
             */
            public String getCarAirConditioningCode() {
                return carAirConditioningCode;
            }

            /** 
             * Set the 'CarAirConditioningCode' element value.
             * 
             * @param carAirConditioningCode
             */
            public void setCarAirConditioningCode(String carAirConditioningCode) {
                this.carAirConditioningCode = carAirConditioningCode;
            }

            /** 
             * Get the 'CountryCode' element value.
             * 
             * @return value
             */
            public String getCountryCode() {
                return countryCode;
            }

            /** 
             * Set the 'CountryCode' element value.
             * 
             * @param countryCode
             */
            public void setCountryCode(String countryCode) {
                this.countryCode = countryCode;
            }

            /** 
             * Get the 'MapRegion' element value.
             * 
             * @return value
             */
            public String getMapRegion() {
                return mapRegion;
            }

            /** 
             * Set the 'MapRegion' element value.
             * 
             * @param mapRegion
             */
            public void setMapRegion(String mapRegion) {
                this.mapRegion = mapRegion;
            }
        }
    }
}
