
package com.sabre.webservices.triprecord;

import java.io.Serializable;
import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/triprecord" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Configuration">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="RuleSet"/>
 *     &lt;xs:element type="xs:string" name="DataSet"/>
 *     &lt;xs:element type="xs:string" name="DomainId" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="GroupId" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="Timestamp" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Content" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Version" minOccurs="0"/>
 *     &lt;xs:element type="xs:anyType" name="AnyContent" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Configuration implements Serializable
{
    private String ruleSet;
    private String dataSet;
    private String domainId;
    private String groupId;
    private Date timestamp;
    private String content;
    private String version;
    private boolean anyContent;

    /** 
     * Get the 'RuleSet' element value.
     * 
     * @return value
     */
    public String getRuleSet() {
        return ruleSet;
    }

    /** 
     * Set the 'RuleSet' element value.
     * 
     * @param ruleSet
     */
    public void setRuleSet(String ruleSet) {
        this.ruleSet = ruleSet;
    }

    /** 
     * Get the 'DataSet' element value.
     * 
     * @return value
     */
    public String getDataSet() {
        return dataSet;
    }

    /** 
     * Set the 'DataSet' element value.
     * 
     * @param dataSet
     */
    public void setDataSet(String dataSet) {
        this.dataSet = dataSet;
    }

    /** 
     * Get the 'DomainId' element value.
     * 
     * @return value
     */
    public String getDomainId() {
        return domainId;
    }

    /** 
     * Set the 'DomainId' element value.
     * 
     * @param domainId
     */
    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    /** 
     * Get the 'GroupId' element value.
     * 
     * @return value
     */
    public String getGroupId() {
        return groupId;
    }

    /** 
     * Set the 'GroupId' element value.
     * 
     * @param groupId
     */
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    /** 
     * Get the 'Timestamp' element value.
     * 
     * @return value
     */
    public Date getTimestamp() {
        return timestamp;
    }

    /** 
     * Set the 'Timestamp' element value.
     * 
     * @param timestamp
     */
    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    /** 
     * Get the 'Content' element value.
     * 
     * @return value
     */
    public String getContent() {
        return content;
    }

    /** 
     * Set the 'Content' element value.
     * 
     * @param content
     */
    public void setContent(String content) {
        this.content = content;
    }

    /** 
     * Get the 'Version' element value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' element value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }

    /** 
     * Check if the 'AnyContent' element is present.
     * 
     * @return <code>true</code> if present, <code>false</code> if not
     */
    public boolean ifAnyContentPresent() {
        return anyContent;
    }

    /** 
     * Set flag for 'AnyContent' element present.
     * 
     * @param anyContent
     */
    public void flagAnyContentPresent(boolean anyContent) {
        this.anyContent = anyContent;
    }
}
