
package com.sabre.webservices.triprecord;

import java.io.Serializable;

/** 
 * Program rewarding
 frequent use by accumulating credits for services
 provided by
 vendors.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:attributeGroup xmlns:ns="http://webservices.sabre.com/triprecord" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CustomerLoyaltyGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="ProgramID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="MembershipID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="FTStatusCode"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class CustomerLoyaltyGroup implements Serializable
{
    private String programID;
    private String membershipID;
    private String FTStatusCode;

    /** 
     * Get the 'ProgramID' attribute value. Identifier to
    				indicate
    				the company owner of the loyalty program.
    			
     * 
     * @return value
     */
    public String getProgramID() {
        return programID;
    }

    /** 
     * Set the 'ProgramID' attribute value. Identifier to
    				indicate
    				the company owner of the loyalty program.
    			
     * 
     * @param programID
     */
    public void setProgramID(String programID) {
        this.programID = programID;
    }

    /** 
     * Get the 'MembershipID' attribute value. Unique identifier
    				of the
    				member in the program (membership number, account
    				number,
    				etc.).
    			
     * 
     * @return value
     */
    public String getMembershipID() {
        return membershipID;
    }

    /** 
     * Set the 'MembershipID' attribute value. Unique identifier
    				of the
    				member in the program (membership number, account
    				number,
    				etc.).
    			
     * 
     * @param membershipID
     */
    public void setMembershipID(String membershipID) {
        this.membershipID = membershipID;
    }

    /** 
     * Get the 'FTStatusCode' attribute value.
     * 
     * @return value
     */
    public String getFTStatusCode() {
        return FTStatusCode;
    }

    /** 
     * Set the 'FTStatusCode' attribute value.
     * 
     * @param FTStatusCode
     */
    public void setFTStatusCode(String FTStatusCode) {
        this.FTStatusCode = FTStatusCode;
    }
}
