
package com.sabre.webservices.triprecord;

import java.io.Serializable;

/** 
 * List of possible Retry record statuses

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://webservices.sabre.com/triprecord" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RetryRecordServiceLocation">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Trip"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum RetryRecordServiceLocation implements Serializable {
    TRIP("Trip");
    private final String value;

    private RetryRecordServiceLocation(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static RetryRecordServiceLocation convert(String value) {
        for (RetryRecordServiceLocation inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
